/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ModelSource;
import com.vicmatskiv.weaponlib.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class StaticModelSourceRenderer
implements IItemRenderer {
    private Builder builder;

    private StaticModelSourceRenderer(Builder builder) {
        this.builder = builder;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        switch (type) {
            case ENTITY: {
                this.builder.entityPositioning.accept(itemStack);
                break;
            }
            case INVENTORY: {
                this.builder.inventoryPositioning.accept(itemStack);
                break;
            }
            case EQUIPPED: {
                this.builder.thirdPersonPositioning.accept(player, itemStack);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.builder.firstPersonPositioning.accept(player, itemStack);
                break;
            }
        }
        this.renderModelSource(itemStack, type, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        GL11.glPopMatrix();
    }

    private void renderModelSource(ItemStack itemStack, IItemRenderer.ItemRenderType type, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (!(itemStack.func_77973_b() instanceof ModelSource)) {
            throw new IllegalArgumentException();
        }
        GL11.glPushMatrix();
        for (Tuple<ModelBase, String> texturedModel : ((ModelSource)itemStack.func_77973_b()).getTexturedModels()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + texturedModel.getV()));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            ModelBase model = texturedModel.getU();
            switch (type) {
                case ENTITY: {
                    this.builder.entityModelPositioning.accept(model, itemStack);
                    break;
                }
                case INVENTORY: {
                    this.builder.inventoryModelPositioning.accept(model, itemStack);
                    break;
                }
                case EQUIPPED: {
                    this.builder.thirdPersonModelPositioning.accept(model, itemStack);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    this.builder.firstPersonModelPositioning.accept(model, itemStack);
                    break;
                }
            }
            model.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public static class Builder {
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning;
        private BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning;
        private BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning;
        private BiConsumer<ModelBase, ItemStack> inventoryModelPositioning;
        private BiConsumer<ModelBase, ItemStack> entityModelPositioning;
        private String modId;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withFirstPersonPositioning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonModelPositioning(BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning) {
            this.firstPersonModelPositioning = firstPersonModelPositioning;
            return this;
        }

        public Builder withEntityModelPositioning(BiConsumer<ModelBase, ItemStack> entityModelPositioning) {
            this.entityModelPositioning = entityModelPositioning;
            return this;
        }

        public Builder withInventoryModelPositioning(BiConsumer<ModelBase, ItemStack> inventoryModelPositioning) {
            this.inventoryModelPositioning = inventoryModelPositioning;
            return this;
        }

        public Builder withThirdPersonModelPositioning(BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning) {
            this.thirdPersonModelPositioning = thirdPersonModelPositioning;
            return this;
        }

        public StaticModelSourceRenderer build() {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            if (this.firstPersonPositioning == null) {
                this.firstPersonPositioning = (player, itemStack) -> {};
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = (player, itemStack) -> {};
            }
            if (this.inventoryModelPositioning == null) {
                this.inventoryModelPositioning = (m, i) -> {};
            }
            if (this.entityModelPositioning == null) {
                this.entityModelPositioning = (m, i) -> {};
            }
            if (this.firstPersonModelPositioning == null) {
                this.firstPersonModelPositioning = (m, i) -> {};
            }
            if (this.thirdPersonModelPositioning == null) {
                this.thirdPersonModelPositioning = (m, i) -> {};
            }
            return new StaticModelSourceRenderer(this);
        }
    }
}

