/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.ReloadManager;
import com.vicmatskiv.weaponlib.ReloadMessage;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WorldHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ReloadMessageHandler
implements IMessageHandler<ReloadMessage, IMessage> {
    private Function<MessageContext, EntityPlayer> entityPlayerSupplier;
    private ReloadManager reloadManager;

    public ReloadMessageHandler(ReloadManager reloadManager, Function<MessageContext, EntityPlayer> entityPlayerSupplier) {
        this.reloadManager = reloadManager;
        this.entityPlayerSupplier = entityPlayerSupplier;
    }

    public IMessage onMessage(ReloadMessage message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            EntityPlayer player = this.entityPlayerSupplier.apply(ctx);
            ItemStack itemStack = player.func_70694_bm();
            if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
                if (message.getType() == ReloadMessage.Type.LOAD) {
                    this.reloadManager.reload(itemStack, player);
                } else {
                    this.reloadManager.unload(itemStack, message.getAmmo(), player);
                }
            } else if (itemStack != null && itemStack.func_77973_b() instanceof ItemMagazine) {
                this.reloadManager.reload(itemStack, player);
            }
        } else {
            this.onClientMessage(message, ctx);
        }
        return null;
    }

    private void onClientMessage(ReloadMessage message, MessageContext ctx) {
        EntityPlayer player = this.entityPlayerSupplier.apply(ctx);
        ItemStack itemStack = player.func_70694_bm();
        if (itemStack != null) {
            Weapon targetWeapon = message.getWeapon();
            ItemMagazine targetMagazine = message.getMagazine();
            if (message.getType() == ReloadMessage.Type.LOAD) {
                ItemStack targetStack = null;
                if (message.getWeapon() != null) {
                    targetStack = itemStack.func_77973_b() == targetWeapon ? itemStack : WorldHelper.itemStackForItem(targetWeapon, s -> true, player);
                    this.reloadManager.completeReload(targetStack, player, message.getMagazine(), message.getAmmo(), itemStack.func_77973_b() != targetWeapon);
                } else if (targetMagazine != null) {
                    targetStack = itemStack.func_77973_b() == targetMagazine ? itemStack : WorldHelper.itemStackForItem(targetMagazine, s -> true, player);
                    this.reloadManager.completeReload(targetStack, player, targetMagazine, message.getAmmo(), itemStack.func_77973_b() != targetMagazine);
                }
            } else {
                this.reloadManager.completeUnload(itemStack, player);
            }
        }
    }
}

