/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.Weapon;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;

public class ReloadMessage
implements IMessage {
    private int ammo;
    private int weaponItemId;
    private int magazineItemId;
    private Type type = Type.LOAD;

    public ReloadMessage() {
    }

    public ReloadMessage(Weapon weapon) {
        this(weapon, Type.LOAD, null, 0);
    }

    public ReloadMessage(Weapon weapon, int ammo) {
        this(weapon, Type.LOAD, null, ammo);
    }

    public ReloadMessage(Weapon weapon, Type type, ItemMagazine magazine, int ammo) {
        this.weaponItemId = Item.func_150891_b((Item)weapon);
        this.magazineItemId = magazine != null ? Item.func_150891_b((Item)magazine) : 0;
        this.type = type;
        this.ammo = ammo;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public Type getType() {
        return this.type;
    }

    public Weapon getWeapon() {
        Item item = Item.func_150899_d((int)this.weaponItemId);
        return item != null ? (Weapon)item : null;
    }

    public ItemMagazine getMagazine() {
        Item item = Item.func_150899_d((int)this.magazineItemId);
        return item != null ? (ItemMagazine)item : null;
    }

    public void fromBytes(ByteBuf buf) {
        this.weaponItemId = buf.readInt();
        this.magazineItemId = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        this.ammo = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.weaponItemId);
        buf.writeInt(this.magazineItemId);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.ammo);
    }

    public static enum Type {
        LOAD,
        UNLOAD,
        CANCEL;

    }
}

