/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ItemBullet;
import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.ReloadMessage;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import com.vicmatskiv.weaponlib.WorldHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ReloadManager {
    private ModContext modContext;

    ReloadManager(ModContext modContext) {
        this.modContext = modContext;
    }

    @SideOnly(value=Side.CLIENT)
    void toggleReload(ItemStack itemStack, EntityPlayer player) {
        if (itemStack.func_77973_b() instanceof Weapon) {
            if (Weapon.isModifying(itemStack) || Weapon.isEjectedSpentRound(player, itemStack)) {
                return;
            }
            if (((Weapon)itemStack.func_77973_b()).getAmmoCapacity() > 0) {
                this.initiateLoad(itemStack, player);
            } else {
                ItemAttachment<Weapon> existingMagazine = this.modContext.getAttachmentManager().getActiveAttachment(itemStack, AttachmentCategory.MAGAZINE);
                if (existingMagazine != null) {
                    this.initiateUnload(itemStack, player);
                } else {
                    this.initiateLoad(itemStack, player);
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemMagazine) {
            this.initiateMagazineLoad(itemStack, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    void initiateMagazineLoad(ItemStack itemStack, EntityPlayer player) {
        ItemMagazine magazine = (ItemMagazine)itemStack.func_77973_b();
        if (Tags.getAmmo(itemStack) < magazine.getAmmo()) {
            this.modContext.getChannel().sendToServer((IMessage)new ReloadMessage(null, ReloadMessage.Type.LOAD, magazine, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    void initiateLoad(ItemStack itemStack, EntityPlayer player) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        if (Weapon.isModifying(itemStack)) {
            return;
        }
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() != Weapon.State.RELOAD_REQUESTED && storage.getState() != Weapon.State.RELOAD_CONFIRMED && (weapon.getAmmoCapacity() == 0 || storage.getCurrentAmmo().get() < weapon.getAmmoCapacity())) {
            storage.getReloadingStopsAt().set(player.field_70170_p.func_82737_E() + 60L);
            storage.setState(Weapon.State.RELOAD_REQUESTED);
            this.modContext.getChannel().sendToServer((IMessage)new ReloadMessage(weapon));
        }
    }

    @SideOnly(value=Side.CLIENT)
    void completeReload(ItemStack itemStack, EntityPlayer player, ItemMagazine itemMagazine, int ammo, boolean forceQuietReload) {
        if (itemStack.func_77973_b() instanceof Weapon) {
            Weapon weapon = (Weapon)itemStack.func_77973_b();
            WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
            if (storage == null) {
                return;
            }
            if (storage.getState() == Weapon.State.RELOAD_REQUESTED) {
                storage.getCurrentAmmo().set(ammo);
                if (!(itemMagazine == null && ammo <= 0 || forceQuietReload)) {
                    storage.setState(Weapon.State.RELOAD_CONFIRMED);
                    long reloadingStopsAt = player.field_70170_p.func_82737_E() + weapon.builder.reloadingTimeout;
                    storage.getReloadingStopsAt().set(reloadingStopsAt);
                    player.func_85030_a(weapon.builder.reloadSound, 1.0f, 1.0f);
                } else {
                    storage.setState(Weapon.State.READY);
                }
            }
        }
    }

    void reload(ItemStack itemStack, EntityPlayer player) {
        ItemStack consumedStack = null;
        if (itemStack.func_77973_b() instanceof ItemMagazine) {
            ItemStack magazineItemStack = itemStack;
            ItemMagazine magazine = (ItemMagazine)magazineItemStack.func_77973_b();
            List<ItemBullet> compatibleBullets = magazine.getCompatibleBullets();
            int currentAmmo = Tags.getAmmo(magazineItemStack);
            if (Tags.getState(magazineItemStack) != Weapon.State.RELOAD_CONFIRMED && currentAmmo < magazine.getAmmo() && (consumedStack = WorldHelper.tryConsumingCompatibleItem(compatibleBullets, magazine.getAmmo() - currentAmmo, player)) != null) {
                Tags.setState(magazineItemStack, Weapon.State.RELOAD_CONFIRMED);
                Tags.setDefaultTimer(magazineItemStack, player.field_70170_p.func_82737_E() + magazine.getReloadTimeout());
                Tags.setAmmo(magazineItemStack, currentAmmo + consumedStack.field_77994_a);
                player.field_70170_p.func_72956_a((Entity)player, magazine.getReloadSound(), 1.0f, 1.0f);
            }
            this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(null, ReloadMessage.Type.LOAD, magazine, currentAmmo), (EntityPlayerMP)player);
        } else if (itemStack.func_77973_b() instanceof Weapon) {
            ItemStack weaponItemStack = itemStack;
            Weapon weapon = (Weapon)itemStack.func_77973_b();
            if (weaponItemStack.field_77990_d != null && !player.func_70051_ag()) {
                List<ItemMagazine> compatibleMagazines = weapon.getCompatibleMagazines();
                List<ItemAttachment<Weapon>> compatibleBullets = weapon.getCompatibleAttachments(ItemBullet.class);
                if (!compatibleMagazines.isEmpty()) {
                    ItemAttachment<Weapon> existingMagazine = this.modContext.getAttachmentManager().getActiveAttachment(weaponItemStack, AttachmentCategory.MAGAZINE);
                    int ammo = Tags.getAmmo(weaponItemStack);
                    ItemMagazine newMagazine = null;
                    if (existingMagazine == null) {
                        ammo = 0;
                        ItemStack magazineItemStack = WorldHelper.tryConsumingCompatibleItem(compatibleMagazines, 1, player, magazineStack -> Tags.getAmmo(magazineStack) > 0, magazineStack -> true);
                        if (magazineItemStack != null) {
                            newMagazine = (ItemMagazine)magazineItemStack.func_77973_b();
                            ammo = Tags.getAmmo(magazineItemStack);
                            Tags.setAmmo(weaponItemStack, ammo);
                            this.modContext.getAttachmentManager().addAttachment((ItemAttachment)magazineItemStack.func_77973_b(), weaponItemStack, player);
                            player.field_70170_p.func_85173_a(player, weapon.builder.reloadSound, 1.0f, 1.0f);
                        }
                    }
                    this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(weapon, ReloadMessage.Type.LOAD, newMagazine, ammo), (EntityPlayerMP)player);
                } else if (!compatibleBullets.isEmpty() && (consumedStack = WorldHelper.tryConsumingCompatibleItem(compatibleBullets, Math.min(weapon.getMaxBulletsPerReload(), weapon.getAmmoCapacity() - Tags.getAmmo(weaponItemStack)), player)) != null) {
                    int ammo = Tags.getAmmo(weaponItemStack) + consumedStack.field_77994_a;
                    Tags.setAmmo(weaponItemStack, ammo);
                    this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(weapon, ammo), (EntityPlayerMP)player);
                    player.field_70170_p.func_85173_a(player, weapon.builder.reloadSound, 1.0f, 1.0f);
                } else if (player.field_71071_by.func_146026_a((Item)weapon.builder.ammo)) {
                    Tags.setAmmo(weaponItemStack, weapon.builder.ammoCapacity);
                    this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(weapon, weapon.builder.ammoCapacity), (EntityPlayerMP)player);
                    player.field_70170_p.func_85173_a(player, weapon.builder.reloadSound, 1.0f, 1.0f);
                } else {
                    Tags.setAmmo(weaponItemStack, 0);
                    this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(weapon, 0), (EntityPlayerMP)player);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void initiateUnload(ItemStack itemStack, EntityPlayer player) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        if (Weapon.isModifying(itemStack)) {
            return;
        }
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() != Weapon.State.UNLOAD_STARTED && storage.getState() != Weapon.State.UNLOAD_REQUESTED_FROM_SERVER && storage.getState() != Weapon.State.UNLOAD_CONFIRMED) {
            storage.getReloadingStopsAt().set(player.field_70170_p.func_82737_E() + weapon.getUnloadTimeoutTicks());
            storage.setState(Weapon.State.UNLOAD_STARTED);
            player.func_85030_a(weapon.builder.unloadSound, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    void requestUnloadFromServer(ItemStack itemStack, EntityPlayer player) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        if (Weapon.isModifying(itemStack)) {
            return;
        }
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() != Weapon.State.UNLOAD_STARTED) {
            throw new IllegalStateException();
        }
        storage.getReloadingStopsAt().set(player.field_70170_p.func_82737_E() + 60L);
        storage.setState(Weapon.State.UNLOAD_REQUESTED_FROM_SERVER);
        this.modContext.getChannel().sendToServer((IMessage)new ReloadMessage(weapon, ReloadMessage.Type.UNLOAD, null, storage.getCurrentAmmo().get()));
    }

    @SideOnly(value=Side.CLIENT)
    void completeUnload(ItemStack itemStack, EntityPlayer player) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() == Weapon.State.UNLOAD_REQUESTED_FROM_SERVER) {
            storage.getCurrentAmmo().set(0);
            storage.setState(Weapon.State.READY);
        }
    }

    void unload(ItemStack weaponItemStack, int ammo, EntityPlayer player) {
        Weapon weapon = (Weapon)weaponItemStack.func_77973_b();
        if (weaponItemStack.field_77990_d != null && !player.func_70051_ag()) {
            ItemAttachment<Weapon> attachment = this.modContext.getAttachmentManager().removeAttachment(AttachmentCategory.MAGAZINE, weaponItemStack, player);
            if (attachment instanceof ItemMagazine) {
                ItemStack attachmentItemStack = ((ItemMagazine)attachment).createItemStack();
                Tags.setAmmo(attachmentItemStack, ammo);
                if (!player.field_71071_by.func_70441_a(attachmentItemStack)) {
                    System.err.println("Cannot add item back to the inventory: " + attachment);
                }
            }
            Tags.setAmmo(weaponItemStack, 0);
            this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(weapon, ReloadMessage.Type.UNLOAD, null, 0), (EntityPlayerMP)player);
            player.field_70170_p.func_85173_a(player, weapon.builder.reloadSound, 1.0f, 1.0f);
        }
    }

    void update(ItemStack itemStack, EntityPlayer player) {
        if (itemStack.func_77973_b() instanceof Weapon) {
            Weapon weapon = (Weapon)itemStack.func_77973_b();
            WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
            if (storage == null) {
                return;
            }
            Weapon.State state = storage.getState();
            if (state == Weapon.State.RELOAD_REQUESTED || state == Weapon.State.RELOAD_CONFIRMED) {
                long currentTime = player.field_70170_p.func_82737_E();
                if (storage.getReloadingStopsAt().get() <= currentTime) {
                    storage.setState(Weapon.State.READY);
                }
            } else if (state == Weapon.State.UNLOAD_STARTED) {
                long currentTime = player.field_70170_p.func_82737_E();
                if (storage.getReloadingStopsAt().get() <= currentTime) {
                    this.requestUnloadFromServer(itemStack, player);
                }
            } else if (state == Weapon.State.UNLOAD_REQUESTED_FROM_SERVER || state == Weapon.State.UNLOAD_CONFIRMED) {
                long currentTime = player.field_70170_p.func_82737_E();
                if (storage.getReloadingStopsAt().get() <= currentTime) {
                    storage.setState(Weapon.State.READY);
                }
            }
        }
    }
}

