/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentBuilder;
import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ItemBullet;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemMagazine
extends ItemAttachment<Weapon>
implements Part {
    private static final long DEFAULT_RELOADING_TIMEOUT_TICKS = 25L;
    private final int DEFAULT_MAX_STACK_SIZE = 1;
    private int ammo;
    private long reloadingTimeout;
    private List<ItemBullet> compatibleBullets;
    private String reloadSound;

    public ItemMagazine(String modId, ModelBase model, String textureName, int ammo) {
        this(modId, model, textureName, ammo, null, null);
    }

    public ItemMagazine(String modId, ModelBase model, String textureName, int ammo, ItemAttachment.ApplyHandler<Weapon> apply, ItemAttachment.ApplyHandler<Weapon> remove) {
        super(modId, AttachmentCategory.MAGAZINE, model, textureName, null, apply, remove);
        this.ammo = ammo;
        this.func_77625_d(1);
    }

    ItemStack createItemStack() {
        ItemStack attachmentItemStack = new ItemStack((Item)this);
        this.ensureItemStack(attachmentItemStack);
        return attachmentItemStack;
    }

    private void ensureItemStack(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
            Tags.setAmmo(itemStack, this.ammo);
        }
    }

    public void func_77622_d(ItemStack stack, World p_77622_2_, EntityPlayer p_77622_3_) {
        this.ensureItemStack(stack);
        super.func_77622_d(stack, p_77622_2_, p_77622_3_);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        this.ensureItemStack(stack);
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        this.ensureItemStack(stack);
        Weapon.State state = Tags.getState(stack);
        if (state == Weapon.State.RELOAD_CONFIRMED && Tags.getDefaultTimer(stack) <= world.func_82737_E()) {
            Tags.setState(stack, Weapon.State.READY);
        }
        super.func_77663_a(stack, world, entity, p_77663_4_, p_77663_5_);
    }

    List<ItemBullet> getCompatibleBullets() {
        return this.compatibleBullets;
    }

    int getAmmo() {
        return this.ammo;
    }

    public String getReloadSound() {
        return this.reloadSound;
    }

    public long getReloadTimeout() {
        return this.reloadingTimeout;
    }

    @Override
    public Part getRenderablePart() {
        return this;
    }

    public static final class Builder
    extends AttachmentBuilder<Weapon> {
        private int ammo;
        private long reloadingTimeout = 25L;
        private Set<ItemBullet> compatibleBullets = new HashSet<ItemBullet>();
        private String reloadSound;

        public Builder withAmmo(int ammo) {
            this.ammo = ammo;
            return this;
        }

        public Builder withReloadingTimeout(int reloadingTimeout) {
            this.reloadingTimeout = reloadingTimeout;
            return this;
        }

        public Builder withReloadSound(String reloadSound) {
            this.reloadSound = reloadSound;
            return this;
        }

        public Builder withCompatibleBullet(ItemBullet compatibleBullet) {
            this.compatibleBullets.add(compatibleBullet);
            return this;
        }

        @Override
        protected ItemAttachment<Weapon> createAttachment() {
            ItemMagazine magazine = new ItemMagazine(this.modId, this.model, this.textureName, this.ammo);
            magazine.reloadingTimeout = this.reloadingTimeout;
            magazine.compatibleBullets = new ArrayList<ItemBullet>(this.compatibleBullets);
            magazine.reloadSound = this.modId + ":" + this.reloadSound;
            return magazine;
        }
    }
}

