/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.Weapon;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CustomArmor
extends ItemArmor {
    private static final String ACTIVE_ATTACHMENT_TAG = "ActiveAttachments";
    private String iconName;
    private String textureName;
    private ModelBiped model;
    private String hudTextureName;
    private String modId;
    private Map<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>> compatibleAttachments = new HashMap<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>>();

    private CustomArmor(String modId, ItemArmor.ArmorMaterial material, int renderIndex, int armorType, String iconName, String textureName, ModelBiped model, String hudTextureName) {
        super(material, renderIndex, armorType);
        this.modId = modId;
        this.iconName = iconName;
        this.textureName = textureName;
        this.model = model;
        this.hudTextureName = hudTextureName;
    }

    public String getHudTexture() {
        return this.modId + ":" + "textures/hud/" + this.hudTextureName + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a(this.modId + ":" + this.iconName);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.modId + ":textures/models/" + this.textureName + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelBiped armorModel = null;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof CustomArmor) {
                armorModel = this.model;
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = false;
                armorModel.field_78124_i.field_78806_j = false;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                int n = armorModel.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer) {
                    boolean isAimedWeapon = Weapon.isAimed(entityLiving.func_71124_b(0));
                    armorModel.field_78118_o = ((EntityPlayer)entityLiving).func_71057_bx() > 0 || isAimedWeapon;
                }
                return armorModel;
            }
        }
        return null;
    }

    public void changeAttachment(AttachmentCategory attachmentCategory, ItemStack itemStack, EntityPlayer player) {
        ItemAttachment<CustomArmor> nextAttachment;
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachmentCategory.ordinal()];
        ItemAttachment item = null;
        if (activeAttachmentIdForThisCategory > 0 && (item = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory)) != null && item.getRemove() != null) {
            item.getRemove().apply(item, this, player);
        }
        if ((nextAttachment = this.nextCompatibleAttachment(attachmentCategory, item, player)) != null && nextAttachment.getApply() != null) {
            nextAttachment.getApply().apply(nextAttachment, this, player);
        }
        activeAttachmentsIds[attachmentCategory.ordinal()] = Item.func_150891_b(nextAttachment);
        itemStack.field_77990_d.func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
    }

    private ItemAttachment<CustomArmor> nextCompatibleAttachment(AttachmentCategory category, Item currentAttachment, EntityPlayer player) {
        ItemAttachment nextAttachment = null;
        boolean foundCurrent = false;
        for (int i = 0; i < 36; ++i) {
            ItemAttachment compatibleAttachment;
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemAttachment) || (compatibleAttachment = (ItemAttachment)itemStack.func_77973_b()).getCategory() != category) continue;
            if (foundCurrent || currentAttachment == null) {
                nextAttachment = compatibleAttachment;
                break;
            }
            if (currentAttachment != compatibleAttachment) continue;
            foundCurrent = true;
        }
        return nextAttachment;
    }

    private void ensureItemStack(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
    }

    public ItemAttachment<CustomArmor> getActiveAttachment(ItemStack itemStack, AttachmentCategory category) {
        int[] activeAttachmentsIds;
        this.ensureItemStack(itemStack);
        ItemAttachment<CustomArmor> itemAttachment = null;
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment<CustomArmor> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = this.compatibleAttachments.get(item)) == null || category != compatibleAttachment.getAttachment().getCategory()) continue;
            itemAttachment = compatibleAttachment.getAttachment();
            break;
        }
        return itemAttachment;
    }

    public List<CompatibleAttachment<CustomArmor>> getActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds;
        this.ensureItemStack(itemStack);
        ArrayList<CompatibleAttachment<CustomArmor>> activeAttachments = new ArrayList<CompatibleAttachment<CustomArmor>>();
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment<CustomArmor> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = this.compatibleAttachments.get(item)) == null) continue;
            activeAttachments.add(compatibleAttachment);
        }
        return activeAttachments;
    }

    private int[] ensureActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds = itemStack.field_77990_d.func_74759_k(ACTIVE_ATTACHMENT_TAG);
        if (activeAttachmentsIds == null || activeAttachmentsIds.length != AttachmentCategory.values.length) {
            activeAttachmentsIds = new int[AttachmentCategory.values.length];
            itemStack.field_77990_d.func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
            for (CompatibleAttachment<CustomArmor> attachment : this.compatibleAttachments.values()) {
                if (!attachment.isDefault()) continue;
                activeAttachmentsIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        }
        return activeAttachmentsIds;
    }

    public static boolean isActiveAttachment(ItemStack itemStack, ItemAttachment<CustomArmor> attachment) {
        CustomArmor armor = (CustomArmor)itemStack.func_77973_b();
        int[] activeAttachmentsIds = armor.ensureActiveAttachments(itemStack);
        return Arrays.stream(activeAttachmentsIds).anyMatch(attachmentId -> attachment == Item.func_150899_d((int)attachmentId));
    }

    public static class Builder {
        private String modId;
        private String textureName;
        private String iconName;
        private ItemArmor.ArmorMaterial material;
        private String unlocalizedName;
        private ModelBiped bootsModel;
        private ModelBiped chestModel;
        private String modelClass;
        private String hudTextureName;
        private Map<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>> compatibleAttachments = new HashMap<ItemAttachment<CustomArmor>, CompatibleAttachment<CustomArmor>>();

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName;
            return this;
        }

        public Builder withMaterial(ItemArmor.ArmorMaterial material) {
            this.material = material;
            return this;
        }

        public Builder withUnlocalizedName(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
            return this;
        }

        public Builder withModelClass(String modelClass) {
            this.modelClass = modelClass;
            return this;
        }

        public Builder withHudTextureName(String hudTextureName) {
            this.hudTextureName = hudTextureName;
            return this;
        }

        public Builder withCompatibleAttachment(AttachmentCategory category, ModelBase attachmentModel, String textureName, Consumer<ModelBase> positioner) {
            ItemAttachment item = new ItemAttachment(this.modId, category, attachmentModel, textureName, null);
            this.compatibleAttachments.put(item, new CompatibleAttachment(item, positioner));
            return this;
        }

        public void build(boolean isClient) {
            if (isClient) {
                try {
                    this.chestModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing chest model", e);
                }
                try {
                    this.bootsModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing boots model", e);
                }
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedHelmetName = this.unlocalizedName + "_helmet";
            CustomArmor armorHelmet = new CustomArmor(this.modId, this.material, 4, 0, unlocalizedHelmetName, this.textureName, this.chestModel, this.hudTextureName);
            armorHelmet.func_77655_b(unlocalizedHelmetName);
            GameRegistry.registerItem((Item)armorHelmet, (String)unlocalizedHelmetName);
            String unlocalizedChestName = this.unlocalizedName + "_chest";
            CustomArmor armorChest = new CustomArmor(this.modId, this.material, 4, 1, unlocalizedChestName, this.textureName, this.chestModel, this.hudTextureName);
            armorChest.func_77655_b(unlocalizedChestName);
            GameRegistry.registerItem((Item)armorChest, (String)unlocalizedChestName);
            String unlocalizedBootsName = this.unlocalizedName + "_boots";
            CustomArmor armorBoots = new CustomArmor(this.modId, this.material, 4, 3, unlocalizedBootsName, this.textureName, this.bootsModel, this.hudTextureName);
            armorBoots.func_77655_b(unlocalizedBootsName);
            GameRegistry.registerItem((Item)armorBoots, (String)unlocalizedBootsName);
        }

        public CustomArmor buildHelmet(boolean isClient) {
            if (isClient) {
                if (this.chestModel == null) {
                    try {
                        this.chestModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException("Missing chest model", e);
                    }
                }
                if (this.bootsModel == null) {
                    try {
                        this.bootsModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException("Missing boots model", e);
                    }
                }
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedHelmetName = this.unlocalizedName + "_helmet";
            CustomArmor armorHelmet = new CustomArmor(this.modId, this.material, 4, 0, unlocalizedHelmetName, this.textureName, this.chestModel, this.hudTextureName);
            armorHelmet.func_77655_b(unlocalizedHelmetName);
            GameRegistry.registerItem((Item)armorHelmet, (String)unlocalizedHelmetName);
            return armorHelmet;
        }

        public CustomArmor buildChest(boolean isClient) {
            if (isClient && this.chestModel == null) {
                try {
                    this.chestModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing chest model", e);
                }
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedChestName = this.unlocalizedName + "_chest";
            CustomArmor armorChest = new CustomArmor(this.modId, this.material, 4, 1, unlocalizedChestName, this.textureName, this.chestModel, this.hudTextureName);
            armorChest.func_77655_b(unlocalizedChestName);
            GameRegistry.registerItem((Item)armorChest, (String)unlocalizedChestName);
            return armorChest;
        }

        public CustomArmor buildBoots(boolean isClient) {
            if (isClient && this.bootsModel == null) {
                try {
                    this.bootsModel = (ModelBiped)Class.forName(this.modelClass).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Missing boots model", e);
                }
            }
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            String unlocalizedBootsName = this.unlocalizedName + "_boots";
            CustomArmor armorBoots = new CustomArmor(this.modId, this.material, 4, 3, unlocalizedBootsName, this.textureName, this.bootsModel, this.hudTextureName);
            armorBoots.func_77655_b(unlocalizedBootsName);
            GameRegistry.registerItem((Item)armorBoots, (String)unlocalizedBootsName);
            return armorBoots;
        }
    }
}

