/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientEventHandler;
import com.vicmatskiv.weaponlib.ClientWeaponTicker;
import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.CustomGui;
import com.vicmatskiv.weaponlib.KeyBindings;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.SpawnEntityRenderer;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorageManager;
import com.vicmatskiv.weaponlib.WeaponEventHandler;
import com.vicmatskiv.weaponlib.WeaponResourcePack;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientModContext
extends CommonModContext {
    private ClientEventHandler clientEventHandler;
    private Lock mainLoopLock = new ReentrantLock();
    private int modEntityID;
    private WeaponClientStorageManager weaponClientStorageManager;

    @Override
    public void init(Object mod, SimpleNetworkWrapper channel) {
        super.init(mod, channel);
        List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(new WeaponResourcePack());
        this.weaponClientStorageManager = new WeaponClientStorageManager();
        SafeGlobals safeGlobals = new SafeGlobals();
        MinecraftForge.EVENT_BUS.register((Object)new CustomGui(Minecraft.func_71410_x(), this.attachmentManager));
        MinecraftForge.EVENT_BUS.register((Object)new WeaponEventHandler(safeGlobals));
        KeyBindings.init();
        ClientWeaponTicker clientWeaponTicker = new ClientWeaponTicker(safeGlobals, this.fireManager, this.reloadManager);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> clientWeaponTicker.shutdown()));
        clientWeaponTicker.start();
        this.clientEventHandler = new ClientEventHandler(this.mainLoopLock, safeGlobals);
        FMLCommonHandler.instance().bus().register((Object)this.clientEventHandler);
        EntityRegistry.registerModEntity(WeaponSpawnEntity.class, (String)("Ammo" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10, (boolean)true);
        RenderingRegistry.registerEntityRenderingHandler(WeaponSpawnEntity.class, (Render)new SpawnEntityRenderer());
    }

    @Override
    public void registerWeapon(String name, Weapon weapon, IItemRenderer renderer) {
        super.registerWeapon(name, weapon, renderer);
        MinecraftForgeClient.registerItemRenderer((Item)weapon, (IItemRenderer)renderer);
    }

    @Override
    public void registerRenderableItem(String name, Item item, IItemRenderer renderer) {
        super.registerRenderableItem(name, item, renderer);
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)renderer);
    }

    @Override
    protected EntityPlayer getPlayer(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void runSyncTick(Runnable runnable) {
        this.mainLoopLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.mainLoopLock.unlock();
        }
    }

    @Override
    public WeaponClientStorageManager getWeaponClientStorageManager() {
        return this.weaponClientStorageManager;
    }
}

