/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Weapon;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class WeaponSpawnEntity
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    static final float DEFAULT_INACCURACY = 1.0f;
    private float explosionRadius = 0.1f;
    private float damage = 6.0f;
    private float speed;
    private float gravityVelocity;
    private float inaccuracy = 1.0f;
    private Weapon weapon;

    public WeaponSpawnEntity(World world) {
        super(world);
    }

    public WeaponSpawnEntity(World par1World, EntityLivingBase arg1EntityLivingBase) {
        super(par1World, arg1EntityLivingBase);
    }

    public WeaponSpawnEntity(Weapon weapon, World par1World, EntityLivingBase arg1EntityLivingBase, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, Material ... damageableBlockMaterials) {
        super(par1World, arg1EntityLivingBase);
        this.weapon = weapon;
        this.damage = damage;
        this.explosionRadius = explosionRadius;
        this.speed = speed;
        this.gravityVelocity = gravityVelocity;
        this.inaccuracy = inaccuracy;
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    protected float getInaccuracyWoraround() {
        return this.inaccuracy;
    }

    protected float func_70182_d() {
        return this.speed;
    }

    protected void func_70184_a(MovingObjectPosition position) {
        if (!this.field_70170_p.field_72995_K) {
            if (position.field_72308_g != null) {
                if (this.explosionRadius > 0.0f) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius, true);
                }
                position.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
                position.field_72308_g.field_70172_ad = 0;
                position.field_72308_g.field_70126_B = (float)((double)position.field_72308_g.field_70126_B - 0.3);
            } else if (this.explosionRadius > 0.0f) {
                this.field_70170_p.func_72876_a((Entity)this, (double)position.func_178782_a().func_177958_n(), (double)position.func_178782_a().func_177956_o(), (double)position.func_178782_a().func_177952_p(), this.explosionRadius, true);
            } else if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.weapon.onSpawnEntityBlockImpact(this.field_70170_p, null, this, position);
            }
            this.func_70106_y();
        }
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float velocity, float ignoredInaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        float inaccuracyWorkaround = this.getInaccuracyWoraround();
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracyWorkaround;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracyWorkaround;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracyWorkaround;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Item.func_150891_b((Item)this.weapon));
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.gravityVelocity);
        buffer.writeFloat(this.damage);
        buffer.writeFloat(this.explosionRadius);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.weapon = (Weapon)Item.func_150899_d((int)buffer.readInt());
        this.speed = buffer.readFloat();
        this.gravityVelocity = buffer.readFloat();
        this.damage = buffer.readFloat();
        this.explosionRadius = buffer.readFloat();
    }

    Weapon getWeapon() {
        return this.weapon;
    }

    boolean isDamageableEntity(Entity entity) {
        return false;
    }
}

