/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.AttachmentManager;
import com.vicmatskiv.weaponlib.ChangeAttachmentMessage;
import com.vicmatskiv.weaponlib.ChangeTextureMessage;
import com.vicmatskiv.weaponlib.KeyBindings;
import com.vicmatskiv.weaponlib.LaserSwitchMessage;
import com.vicmatskiv.weaponlib.ReloadManager;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class WeaponKeyInputHandler {
    private SimpleNetworkWrapper channel;
    private Function<MessageContext, EntityPlayer> entityPlayerSupplier;
    private AttachmentManager attachmentManager;
    private ReloadManager reloadManager;

    public WeaponKeyInputHandler(Function<MessageContext, EntityPlayer> entityPlayerSupplier, AttachmentManager attachmentManager, ReloadManager reloadManager, SimpleNetworkWrapper channel) {
        this.entityPlayerSupplier = entityPlayerSupplier;
        this.attachmentManager = attachmentManager;
        this.reloadManager = reloadManager;
        this.channel = channel;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (KeyBindings.reloadKey.func_151468_f()) {
            EntityPlayer player = this.entityPlayerSupplier.apply(null);
            ItemStack itemStack = player.func_70694_bm();
            if (itemStack != null) {
                this.reloadManager.toggleReload(itemStack, player);
            }
        } else if (KeyBindings.laserSwitchKey.func_151468_f()) {
            this.channel.sendToServer((IMessage)new LaserSwitchMessage());
        } else if (KeyBindings.attachmentKey.func_151468_f()) {
            EntityPlayer player = this.entityPlayerSupplier.apply(null);
            ItemStack itemStack = player.func_70694_bm();
            if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
                this.attachmentManager.toggleClientAttachmentSelectionMode(itemStack, player);
            }
        } else if (KeyBindings.upArrowKey.func_151468_f()) {
            this.channel.sendToServer((IMessage)new ChangeAttachmentMessage(AttachmentCategory.SCOPE));
        } else if (KeyBindings.rightArrowKey.func_151468_f()) {
            this.channel.sendToServer((IMessage)new ChangeTextureMessage());
        } else if (KeyBindings.downArrowKey.func_151468_f()) {
            this.channel.sendToServer((IMessage)new ChangeAttachmentMessage(AttachmentCategory.GRIP));
        } else if (KeyBindings.leftArrowKey.func_151468_f()) {
            this.channel.sendToServer((IMessage)new ChangeAttachmentMessage(AttachmentCategory.SILENCER));
        }
    }
}

