/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ModelSource;
import com.vicmatskiv.weaponlib.ModelSourceRenderer;
import com.vicmatskiv.weaponlib.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class StaticModelSourceRenderer
extends ModelSourceRenderer
implements ISmartItemModel,
IPerspectiveAwareModel,
IFlexibleBakedModel {
    private Builder builder;
    protected EntityPlayer owner;
    protected TextureManager textureManager;
    private Pair<? extends IFlexibleBakedModel, Matrix4f> pair;
    protected ModelBiped playerBiped = new ModelBiped();
    protected ItemStack itemStack;
    protected ModelResourceLocation resourceLocation;
    protected ItemCameraTransforms.TransformType transformType;

    private StaticModelSourceRenderer(Builder builder) {
        this.builder = builder;
        this.pair = Pair.of((Object)this, null);
    }

    public final List<BakedQuad> func_177550_a() {
        if (this.itemStack == null) {
            return Collections.emptyList();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        tessellator.func_78381_a();
        GlStateManager.func_179094_E();
        if (this.owner != null && this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON && this.owner.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
        }
        if (this.onGround()) {
            GlStateManager.func_179152_a((float)-3.0f, (float)-3.0f, (float)-3.0f);
        }
        this.renderItem();
        GlStateManager.func_179121_F();
        this.owner = null;
        this.itemStack = null;
        this.transformType = null;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        return Collections.emptyList();
    }

    protected boolean onGround() {
        return this.transformType == null;
    }

    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return Collections.emptyList();
    }

    public final boolean func_177555_b() {
        return true;
    }

    public final boolean func_177556_c() {
        return true;
    }

    public final boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public IBakedModel handleItemState(ItemStack stack) {
        this.itemStack = stack;
        return this;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.transformType = cameraTransformType;
        return this.pair;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem() {
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        switch (this.transformType) {
            case GROUND: {
                this.builder.entityPositioning.accept(this.itemStack);
                break;
            }
            case GUI: {
                GL11.glScaled((double)0.9f, (double)0.9f, (double)0.9f);
                GL11.glTranslatef((float)-1.2f, (float)-1.1f, (float)-0.1f);
                GL11.glRotatef((float)-50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-80.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.builder.inventoryPositioning.accept(this.itemStack);
                break;
            }
            case THIRD_PERSON: {
                this.builder.thirdPersonPositioning.accept(player, this.itemStack);
                break;
            }
            case FIRST_PERSON: {
                this.builder.firstPersonPositioning.accept(player, this.itemStack);
                break;
            }
        }
        this.renderModelSource(this.itemStack, this.transformType, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        GL11.glPopMatrix();
    }

    private void renderModelSource(ItemStack itemStack, ItemCameraTransforms.TransformType type, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (!(itemStack.func_77973_b() instanceof ModelSource)) {
            throw new IllegalArgumentException();
        }
        GL11.glPushMatrix();
        for (Tuple<ModelBase, String> texturedModel : ((ModelSource)itemStack.func_77973_b()).getTexturedModels()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + texturedModel.getV()));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            ModelBase model = texturedModel.getU();
            switch (type) {
                case GROUND: {
                    this.builder.entityModelPositioning.accept(model, itemStack);
                    break;
                }
                case GUI: {
                    this.builder.inventoryModelPositioning.accept(model, itemStack);
                    break;
                }
                case THIRD_PERSON: {
                    this.builder.thirdPersonModelPositioning.accept(model, itemStack);
                    break;
                }
                case FIRST_PERSON: {
                    this.builder.firstPersonModelPositioning.accept(model, itemStack);
                    break;
                }
            }
            model.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public VertexFormat getFormat() {
        return DefaultVertexFormats.field_176599_b;
    }

    public static class Builder {
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning;
        private BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning;
        private BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning;
        private BiConsumer<ModelBase, ItemStack> inventoryModelPositioning;
        private BiConsumer<ModelBase, ItemStack> entityModelPositioning;
        private String modId;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withFirstPersonPositioning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonModelPositioning(BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning) {
            this.firstPersonModelPositioning = firstPersonModelPositioning;
            return this;
        }

        public Builder withEntityModelPositioning(BiConsumer<ModelBase, ItemStack> entityModelPositioning) {
            this.entityModelPositioning = entityModelPositioning;
            return this;
        }

        public Builder withInventoryModelPositioning(BiConsumer<ModelBase, ItemStack> inventoryModelPositioning) {
            this.inventoryModelPositioning = inventoryModelPositioning;
            return this;
        }

        public Builder withThirdPersonModelPositioning(BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning) {
            this.thirdPersonModelPositioning = thirdPersonModelPositioning;
            return this;
        }

        public StaticModelSourceRenderer build() {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            if (this.firstPersonPositioning == null) {
                this.firstPersonPositioning = (player, itemStack) -> {};
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = (player, itemStack) -> {};
            }
            if (this.inventoryModelPositioning == null) {
                this.inventoryModelPositioning = (m, i) -> {};
            }
            if (this.entityModelPositioning == null) {
                this.entityModelPositioning = (m, i) -> {};
            }
            if (this.firstPersonModelPositioning == null) {
                this.firstPersonModelPositioning = (m, i) -> {};
            }
            if (this.thirdPersonModelPositioning == null) {
                this.thirdPersonModelPositioning = (m, i) -> {};
            }
            return new StaticModelSourceRenderer(this);
        }
    }
}

