/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.ReloadManager;
import com.vicmatskiv.weaponlib.ReloadMessage;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WorldHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReloadMessageHandler
implements IMessageHandler<ReloadMessage, IMessage> {
    private Function<MessageContext, EntityPlayer> entityPlayerSupplier;
    private ReloadManager reloadManager;

    public ReloadMessageHandler(ReloadManager reloadManager, Function<MessageContext, EntityPlayer> entityPlayerSupplier) {
        this.reloadManager = reloadManager;
        this.entityPlayerSupplier = entityPlayerSupplier;
    }

    public IMessage onMessage(ReloadMessage message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            EntityPlayer player = this.entityPlayerSupplier.apply(ctx);
            ItemStack itemStack = player.func_70694_bm();
            if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
                IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
                mainThread.func_152344_a(() -> {
                    if (message.getType() == ReloadMessage.Type.LOAD) {
                        this.reloadManager.reload(itemStack, player);
                    } else {
                        this.reloadManager.unload(itemStack, message.getAmmo(), player);
                    }
                });
            } else if (itemStack != null && itemStack.func_77973_b() instanceof ItemMagazine) {
                this.reloadManager.reload(itemStack, player);
            }
        } else {
            this.onClientMessage(message, ctx);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void onClientMessage(ReloadMessage message, MessageContext ctx) {
        EntityPlayer player = this.entityPlayerSupplier.apply(ctx);
        ItemStack itemStack = player.func_70694_bm();
        if (itemStack != null) {
            Weapon targetWeapon = message.getWeapon();
            ItemMagazine targetMagazine = message.getMagazine();
            if (message.getType() == ReloadMessage.Type.LOAD) {
                if (message.getWeapon() != null) {
                    ItemStack targetStack = itemStack.func_77973_b() == targetWeapon ? itemStack : WorldHelper.itemStackForItem(targetWeapon, s -> true, player);
                    Minecraft.func_71410_x().func_152344_a(() -> this.reloadManager.completeReload(targetStack, player, message.getMagazine(), message.getAmmo(), itemStack.func_77973_b() != targetWeapon));
                } else if (targetMagazine != null) {
                    ItemStack targetStack = itemStack.func_77973_b() == targetMagazine ? itemStack : WorldHelper.itemStackForItem(targetMagazine, s -> true, player);
                    Minecraft.func_71410_x().func_152344_a(() -> this.reloadManager.completeReload(targetStack, player, targetMagazine, message.getAmmo(), itemStack.func_77973_b() != targetMagazine));
                }
            } else {
                this.reloadManager.completeUnload(itemStack, player);
            }
        }
    }
}

