/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class LaserBeamRenderer
implements CustomRenderer {
    private float leftOffset = 0.3f;
    private float forwardOffset = 0.1f;

    @Override
    public void render(ItemCameraTransforms.TransformType type, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof Weapon)) {
            throw new IllegalStateException("Item is not weapon");
        }
        if (Tags.isLaserOn(itemStack) && (type == ItemCameraTransforms.TransformType.GROUND || type == ItemCameraTransforms.TransformType.FIRST_PERSON)) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glLineWidth((float)1.5f);
            GL11.glDepthMask((boolean)false);
            GL11.glRotatef((float)-0.1f, (float)0.0f, (float)1.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer renderer = tessellator.func_178180_c();
            renderer.func_181668_a(1, DefaultVertexFormats.field_181710_j);
            long time = System.currentTimeMillis();
            Random random = new Random(time - time % 300L);
            float start = this.forwardOffset;
            float length = 100.0f;
            float end = 0.0f;
            for (int i = 0; i < 100 && start < length && end < length; ++i) {
                renderer.func_181662_b((double)this.leftOffset, 0.0, (double)start);
                int ii = 0xF000F0;
                int j = ii >> 16 & 0xFFFF;
                int k = ii & 0xFFFF;
                renderer.func_181671_a(j, k);
                end = start - (1.0f + random.nextFloat() * 2.0f);
                if (end > length) {
                    end = length;
                }
                renderer.func_181662_b((double)this.leftOffset, 0.0, (double)end);
                renderer.func_181675_d();
                start = end + random.nextFloat() * 0.5f;
            }
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }
}

