/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.EffectManager;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FireManager {
    private static final float FLASH_X_OFFSET_ZOOMED = 0.0f;
    private static final float FLASH_X_OFFSET_NORMAL = 0.0f;
    private ModContext modContext;
    private Random random = new Random();

    FireManager(ModContext modContext) {
        this.modContext = modContext;
    }

    void clientTryFire(EntityPlayer player) {
        boolean readyToShootAccordingToFireRate;
        ItemStack itemStack = player.func_70694_bm();
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() == Weapon.State.PAUSED) {
            if (!Tags.isAimed(itemStack)) {
                storage.setEjectSpentRoundStartedAt(System.currentTimeMillis());
                storage.setState(Weapon.State.EJECT_SPENT_ROUND);
                this.modContext.runSyncTick(() -> player.func_85030_a(weapon.builder.ejectSpentRoundSound, 1.0f, 1.0f));
            }
            return;
        }
        boolean bl = readyToShootAccordingToFireRate = (float)(System.currentTimeMillis() - storage.getLastShotFiredAt()) >= 50.0f / weapon.builder.fireRate;
        if (!player.func_70051_ag() && (storage.getState() == Weapon.State.READY || storage.getState() == Weapon.State.SHOOTING) && readyToShootAccordingToFireRate && storage.getShots() < weapon.builder.maxShots && storage.getCurrentAmmo().getAndAccumulate(0, (current, ignore) -> current > 0 ? current - 1 : 0) > 0) {
            storage.setState(Weapon.State.SHOOTING);
            this.modContext.getChannel().sendToServer((IMessage)new TryFireMessage(true));
            ItemStack heldItem = player.func_70694_bm();
            this.modContext.runSyncTick(() -> player.func_85030_a(this.modContext.getAttachmentManager().isSilencerOn(heldItem) ? weapon.builder.silencedShootSound : weapon.builder.shootSound, 1.0f, 1.0f));
            player.field_70125_A -= storage.getRecoil();
            float rotationYawFactor = -1.0f + this.random.nextFloat() * 2.0f;
            player.field_70177_z += storage.getRecoil() * rotationYawFactor;
            if (weapon.builder.flashIntensity > 0.0f) {
                EffectManager.getInstance().spawnFlashParticle(player, weapon.builder.flashIntensity, Weapon.isZoomed(itemStack) ? 0.0f : 0.0f);
            }
            EffectManager.getInstance().spawnSmokeParticle(player);
            storage.setLastShotFiredAt(System.currentTimeMillis());
            storage.addShot();
        }
    }

    void tryFire(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int currentAmmo = Tags.getAmmo(itemStack);
        if (currentAmmo > 0) {
            if (!Weapon.isZoomed(itemStack)) {
                Tags.setAimed(itemStack, true);
            }
            Tags.setAmmo(itemStack, currentAmmo - 1);
            for (int i = 0; i < weapon.builder.pellets; ++i) {
                player.field_70170_p.func_72838_d((Entity)weapon.builder.spawnEntityWith.apply(weapon, player));
            }
            player.field_70170_p.func_85173_a(player, this.modContext.getAttachmentManager().isSilencerOn(itemStack) ? weapon.builder.silencedShootSound : weapon.builder.shootSound, 1.0f, 1.0f);
        } else {
            System.err.println("Invalid state: attempted to fire a weapon without ammo");
        }
    }

    void tryStopFire(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        if (!Weapon.isZoomed(itemStack)) {
            Tags.setAimed(itemStack, false);
        }
    }

    void clientTryStopFire(EntityPlayer player) {
        ItemStack itemStack = player.func_70694_bm();
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() == Weapon.State.SHOOTING) {
            storage.resetShots();
            if (weapon.ejectSpentRoundRequired()) {
                storage.setState(Weapon.State.PAUSED);
            } else {
                storage.setState(Weapon.State.READY);
            }
            this.modContext.runInMainThread(() -> this.modContext.getChannel().sendToServer((IMessage)new TryFireMessage(false)));
        }
    }

    void update(ItemStack itemStack, EntityPlayer player) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, weapon);
        if (storage == null) {
            return;
        }
        if (storage.getState() == Weapon.State.EJECT_SPENT_ROUND && storage.getEjectSpentRoundStartedAt() + weapon.builder.pumpTimeoutMilliseconds <= System.currentTimeMillis()) {
            storage.setState(Weapon.State.READY);
        }
    }
}

