/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.FireManager;
import com.vicmatskiv.weaponlib.ReloadManager;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;

class ClientWeaponTicker
extends Thread {
    private boolean mouseWasPressed;
    private AtomicBoolean running = new AtomicBoolean(true);
    private SafeGlobals safeGlobals;
    private FireManager fireManager;
    private ReloadManager reloadManager;

    public ClientWeaponTicker(SafeGlobals safeGlobals, FireManager fireManager, ReloadManager reloadManager) {
        this.safeGlobals = safeGlobals;
        this.fireManager = fireManager;
        this.reloadManager = reloadManager;
    }

    void shutdown() {
        this.running.set(false);
    }

    @Override
    public void run() {
        int currentItemIndex = this.safeGlobals.currentItemIndex.get();
        while (this.running.get()) {
            try {
                Weapon currentWeapon = this.getCurrentWeapon();
                EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
                if (Mouse.isCreated() && Mouse.isButtonDown((int)0)) {
                    currentItemIndex = this.safeGlobals.currentItemIndex.get();
                    if (!this.mouseWasPressed) {
                        this.mouseWasPressed = true;
                    }
                    if (currentWeapon != null && !this.safeGlobals.guiOpen.get() && !this.isInteracting()) {
                        this.fireManager.clientTryFire((EntityPlayer)player);
                    }
                } else if (this.mouseWasPressed || currentItemIndex != this.safeGlobals.currentItemIndex.get()) {
                    this.mouseWasPressed = false;
                    currentItemIndex = this.safeGlobals.currentItemIndex.get();
                    if (currentWeapon != null) {
                        this.fireManager.clientTryStopFire((EntityPlayer)player);
                    }
                }
                if (currentWeapon != null) {
                    this.update(player);
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void update(EntityPlayerSP player) {
        this.reloadManager.update(player.func_70694_bm(), (EntityPlayer)player);
        this.fireManager.update(player.func_70694_bm(), (EntityPlayer)player);
    }

    private boolean isInteracting() {
        return false;
    }

    private Weapon getCurrentWeapon() {
        EntityPlayerSP clientPlayerEntity = FMLClientHandler.instance().getClientPlayerEntity();
        if (clientPlayerEntity == null) {
            return null;
        }
        ItemStack heldItem = clientPlayerEntity.func_70694_bm();
        return heldItem != null && heldItem.func_77973_b() instanceof Weapon ? (Weapon)heldItem.func_77973_b() : null;
    }
}

