/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientEventHandler;
import com.vicmatskiv.weaponlib.ClientWeaponTicker;
import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.CustomGui;
import com.vicmatskiv.weaponlib.KeyBindings;
import com.vicmatskiv.weaponlib.ModelSourceRenderer;
import com.vicmatskiv.weaponlib.RenderingRegistry;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.SpawnEntityRenderer;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorageManager;
import com.vicmatskiv.weaponlib.WeaponEventHandler;
import com.vicmatskiv.weaponlib.WeaponResourcePack;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ClientModContext
extends CommonModContext {
    private ClientEventHandler clientEventHandler;
    private Lock mainLoopLock = new ReentrantLock();
    private int modEntityID;
    private WeaponClientStorageManager weaponClientStorageManager;
    private Queue<Runnable> runInClientThreadQueue = new LinkedBlockingQueue<Runnable>();
    private RenderingRegistry rendererRegistry;

    @Override
    public void init(Object mod, String modId, SimpleNetworkWrapper channel) {
        super.init(mod, modId, channel);
        this.rendererRegistry = new RenderingRegistry(modId);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this.rendererRegistry);
        List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(new WeaponResourcePack());
        this.weaponClientStorageManager = new WeaponClientStorageManager();
        SafeGlobals safeGlobals = new SafeGlobals();
        MinecraftForge.EVENT_BUS.register((Object)new CustomGui(Minecraft.func_71410_x(), this.attachmentManager));
        MinecraftForge.EVENT_BUS.register((Object)new WeaponEventHandler(safeGlobals));
        KeyBindings.init();
        ClientWeaponTicker clientWeaponTicker = new ClientWeaponTicker(safeGlobals, this.fireManager, this.reloadManager);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> clientWeaponTicker.shutdown()));
        clientWeaponTicker.start();
        this.clientEventHandler = new ClientEventHandler(this.mainLoopLock, safeGlobals, this.runInClientThreadQueue);
        MinecraftForge.EVENT_BUS.register((Object)this.clientEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.rendererRegistry);
        EntityRegistry.registerModEntity(WeaponSpawnEntity.class, (String)("Ammo" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10, (boolean)true);
        net.minecraftforge.fml.client.registry.RenderingRegistry.registerEntityRenderingHandler(WeaponSpawnEntity.class, (Render)new SpawnEntityRenderer(Minecraft.func_71410_x().func_175598_ae()));
    }

    @Override
    public void registerWeapon(String name, Weapon weapon) {
        super.registerWeapon(name, weapon);
        this.rendererRegistry.register(weapon, weapon.getName(), weapon.getRenderer());
    }

    @Override
    public void registerRenderableItem(String name, Item item, ModelSourceRenderer renderer) {
        this.rendererRegistry.register(item, name, renderer);
    }

    @Override
    protected EntityPlayer getPlayer(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void runSyncTick(Runnable runnable) {
        this.mainLoopLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.mainLoopLock.unlock();
        }
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        this.runInClientThreadQueue.add(runnable);
    }

    @Override
    public WeaponClientStorageManager getWeaponClientStorageManager() {
        return this.weaponClientStorageManager;
    }
}

