/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.SafeGlobals;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEventHandler {
    private Lock mainLoopLock = new ReentrantLock();
    private SafeGlobals safeGlobals;
    private Queue<Runnable> runInClientThreadQueue;

    public ClientEventHandler(Lock mainLoopLock, SafeGlobals safeGlobals, Queue<Runnable> runInClientThreadQueue) {
        this.mainLoopLock = mainLoopLock;
        this.safeGlobals = safeGlobals;
        this.runInClientThreadQueue = runInClientThreadQueue;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.mainLoopLock.lock();
        } else if (event.phase == TickEvent.Phase.END) {
            this.mainLoopLock.unlock();
            this.processRunInClientThreadQueue();
            this.safeGlobals.objectMouseOver.set(Minecraft.func_71410_x().field_71476_x);
            if (Minecraft.func_71410_x().field_71439_g != null) {
                this.safeGlobals.currentItemIndex.set(Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c);
            }
        }
    }

    private void processRunInClientThreadQueue() {
        Runnable r;
        while ((r = this.runInClientThreadQueue.poll()) != null) {
            r.run();
        }
    }
}

