/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.mw;

import com.vicmatskiv.mw.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorEventHandler
implements IWorldGenerator {
    private boolean oreGenerationEnabled;

    public WorldGeneratorEventHandler(boolean oreGenerationEnabled) {
        this.oreGenerationEnabled = oreGenerationEnabled;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (this.oreGenerationEnabled) {
            this.addOreSpawn(CommonProxy.TitaniumOre, 0, Blocks.field_150348_b, world, random, x, z, 8, 8, 3 + random.nextInt(4), 15, 2, 60);
            this.addOreSpawn(CommonProxy.CopperOre, 0, Blocks.field_150348_b, world, random, x, z, 9, 9, 6 + random.nextInt(4), 15, 2, 110);
            this.addOreSpawn(CommonProxy.SulfurOre, 0, Blocks.field_150348_b, world, random, x, z, 13, 13, 6 + random.nextInt(7), 20, 5, 90);
            this.addOreSpawn(CommonProxy.LeadOre, 0, Blocks.field_150348_b, world, random, x, z, 10, 10, 4 + random.nextInt(5), 20, 5, 90);
            this.addOreSpawn(CommonProxy.TitaniumOre, 0, Blocks.field_150348_b, world, random, x, z, 8, 8, 3 + random.nextInt(4), 15, 2, 60);
            this.addOreSpawn(CommonProxy.BauxiteOre, 0, Blocks.field_150348_b, world, random, x, z, 8, 8, 3 + random.nextInt(4), 15, 2, 60);
            this.addOreSpawn(CommonProxy.TitaniumOre, 0, Blocks.field_150348_b, world, random, x, z, 8, 8, 3 + random.nextInt(4), 15, 2, 60);
            this.addOreSpawn(CommonProxy.SiliconOre, 0, Blocks.field_150348_b, world, random, x, z, 7, 7, 4 + random.nextInt(2), 15, 2, 90);
            this.addOreSpawn(CommonProxy.RubyOre, 0, Blocks.field_150348_b, world, random, x, z, 6, 6, 2 + random.nextInt(2), 15, 2, 15);
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
    }

    public void addOreSpawn(Block block, int metadata, Block target, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int diffBetweenMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBetweenMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block.func_176223_P(), maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

