------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                         G N A T . S T R I N G S                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (C) 1995-2005, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--
--
--
--
--
--
--
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  Common String access types and related subprograms

with Unchecked_Deallocation;

package GNAT.Strings is
   pragma Preelaborate;

   type String_Access is access all String;
   --  General purpose string access type. Note that the caller is
   --  responsible for freeing allocated strings to avoid memory leaks.

   procedure Free is new Unchecked_Deallocation
     (Object => String, Name => String_Access);
   --  This procedure is provided for freeing allocated values of type
   --  String_Access.

   type String_List is array (Positive range <>) of String_Access;
   type String_List_Access is access all String_List;
   --  General purpose array and pointer for list of string accesses

   procedure Free (Arg : in out String_List_Access);
   --  Frees the given array and all strings that its elements reference,
   --  and then sets the argument to null. Provided for freeing allocated
   --  values of this type.

end GNAT.Strings;
