# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 10.0.0.  Any changes made here will be lost!

sub TODO_FAILING_BREAKS { 0 }

use strict;
use warnings;

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($@) {
    my ($pass, @msg) = @_;
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parentheses in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}\p{WB=ZWJ}]/';
if (! defined $WB_Extend_or_Format_re) {
    $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';
}

sub _test_break($$) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $template = shift;
    my $break_type = shift;

    my $line   = (caller 1)[2];   # Line number
    my $comment = "";

    if ($template =~ / ( .*? ) \s* \# (.*) /x) {
        $template = $1;
        $comment = $2;

        # Replace leading spaces with a single one.
        $comment =~ s/ ^ \s* / # /x;
    }

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(&POSIX::LC_CTYPE, $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched_text;
            my $matched = $string =~ qr/$pattern/;
            if ($matched) {
                $matched_text = "matched";
            }
            else {
                $matched_text = "failed to match";
                print "not ";

                if (TODO_FAILING_BREAKS) {
                    $comment = " # $comment" unless $comment =~ / ^ \s* \# /x;
                    $comment =~ s/#/# TODO/;
                }
            }
            print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$pattern/$display_upgrade; line $line $display_locale$comment\n";

            # Only print the comment on the first use of this line
            $comment = "";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched_text = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$B_pattern/$display_upgrade; line $line $display_locale";
                print " # TODO" if TODO_FAILING_BREAKS && ! $matched;
                print "\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests -";
                print " # TODO" if TODO_FAILING_BREAKS;
                print " In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line";
            print " # TODO" if TODO_FAILING_BREAKS;
            print "\n";
        }
    }

    return;
}

sub Test_GCB($) {
    _test_break(shift, 'gcb');
}

sub Test_LB($) {
    _test_break(shift, 'lb');
}

sub Test_SB($) {
    _test_break(shift, 'sb');
}

sub Test_WB($) {
    _test_break(shift, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

if (!$::TESTCHUNK or $::TESTCHUNK == 1) {
    Error('\p{Script=InGreek}');    # Bug #69018
    Test_GCB("1100 $nobreak 1161");  # Bug #70940
    Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
    Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
    Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
    
    # Make sure this gets tested; it was not part of the official test suite at
    # the time this was added.  Note that this is as it would appear in the
    # official suite, and gets modified to check for the perl tailoring by
    # Test_WB()
    Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
    Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
    Error('\p{_perllb}');
    Error('\P{_perllb}');
    Error('\p{_perlscx}');
    Error('\P{_perlscx}');
    Error('\p{_perlwb}');
    Error('\P{_perlwb}');
    Error('\p{age}');
    Error('\P{age}');
    Error('\p{Age=_V1_1/a/}');
    Error('\P{Age=_V1_1/a/}');
    Expect(1, 65533, '\p{Age=v11}', "");
    Expect(0, 65533, '\p{^Age=v11}', "");
    Expect(0, 65533, '\P{Age=v11}', "");
    Expect(1, 65533, '\P{^Age=v11}', "");
    Expect(0, 65536, '\p{Age=v11}', "");
    Expect(1, 65536, '\p{^Age=v11}', "");
    Expect(1, 65536, '\P{Age=v11}', "");
    Expect(0, 65536, '\P{^Age=v11}', "");
    Expect(1, 65533, '\p{Age=	v1_1}', "");
    Expect(0, 65533, '\p{^Age=	v1_1}', "");
    Expect(0, 65533, '\P{Age=	v1_1}', "");
    Expect(1, 65533, '\P{^Age=	v1_1}', "");
    Expect(0, 65536, '\p{Age=	v1_1}', "");
    Expect(1, 65536, '\p{^Age=	v1_1}', "");
    Expect(1, 65536, '\P{Age=	v1_1}', "");
    Expect(0, 65536, '\P{^Age=	v1_1}', "");
    Error('\p{Is_Age=:=	 000000001.1}');
    Error('\P{Is_Age=:=	 000000001.1}');
    Expect(1, 65533, '\p{Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\p{^Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\P{Is_Age=+0_1.1}', "");
    Expect(1, 65533, '\P{^Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\p{Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\p{^Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\P{Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\P{^Is_Age=+0_1.1}', "");
    Error('\p{Age=		v10_0:=}');
    Error('\P{Age=		v10_0:=}');
    Expect(1, 191456, '\p{Age=v100}', "");
    Expect(0, 191456, '\p{^Age=v100}', "");
    Expect(0, 191456, '\P{Age=v100}', "");
    Expect(1, 191456, '\P{^Age=v100}', "");
    Expect(0, 191457, '\p{Age=v100}', "");
    Expect(1, 191457, '\p{^Age=v100}', "");
    Expect(1, 191457, '\P{Age=v100}', "");
    Expect(0, 191457, '\P{^Age=v100}', "");
    Expect(1, 191456, '\p{Age=	-V10_0}', "");
    Expect(0, 191456, '\p{^Age=	-V10_0}', "");
    Expect(0, 191456, '\P{Age=	-V10_0}', "");
    Expect(1, 191456, '\P{^Age=	-V10_0}', "");
    Expect(0, 191457, '\p{Age=	-V10_0}', "");
    Expect(1, 191457, '\p{^Age=	-V10_0}', "");
    Expect(1, 191457, '\P{Age=	-V10_0}', "");
    Expect(0, 191457, '\P{^Age=	-V10_0}', "");
    Error('\p{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Error('\P{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Expect(1, 191456, '\p{Is_Age=0000010.0}', "");
    Expect(0, 191456, '\p{^Is_Age=0000010.0}', "");
    Expect(0, 191456, '\P{Is_Age=0000010.0}', "");
    Expect(1, 191456, '\P{^Is_Age=0000010.0}', "");
    Expect(0, 191457, '\p{Is_Age=0000010.0}', "");
    Expect(1, 191457, '\p{^Is_Age=0000010.0}', "");
    Expect(1, 191457, '\P{Is_Age=0000010.0}', "");
    Expect(0, 191457, '\P{^Is_Age=0000010.0}', "");
    Error('\p{Age=/a/V2_0}');
    Error('\P{Age=/a/V2_0}');
    Expect(1, 983040, '\p{Age=v20}', "");
    Expect(0, 983040, '\p{^Age=v20}', "");
    Expect(0, 983040, '\P{Age=v20}', "");
    Expect(1, 983040, '\P{^Age=v20}', "");
    Expect(0, 983037, '\p{Age=v20}', "");
    Expect(1, 983037, '\p{^Age=v20}', "");
    Expect(1, 983037, '\P{Age=v20}', "");
    Expect(0, 983037, '\P{^Age=v20}', "");
    Expect(1, 983040, '\p{Age= _V2_0}', "");
    Expect(0, 983040, '\p{^Age= _V2_0}', "");
    Expect(0, 983040, '\P{Age= _V2_0}', "");
    Expect(1, 983040, '\P{^Age= _V2_0}', "");
    Expect(0, 983037, '\p{Age= _V2_0}', "");
    Expect(1, 983037, '\p{^Age= _V2_0}', "");
    Expect(1, 983037, '\P{Age= _V2_0}', "");
    Expect(0, 983037, '\P{^Age= _V2_0}', "");
    Error('\p{Is_Age=_ +000002.0:=}');
    Error('\P{Is_Age=_ +000002.0:=}');
    Expect(1, 983040, '\p{Is_Age=2.0}', "");
    Expect(0, 983040, '\p{^Is_Age=2.0}', "");
    Expect(0, 983040, '\P{Is_Age=2.0}', "");
    Expect(1, 983040, '\P{^Is_Age=2.0}', "");
    Expect(0, 983037, '\p{Is_Age=2.0}', "");
    Expect(1, 983037, '\p{^Is_Age=2.0}', "");
    Expect(1, 983037, '\P{Is_Age=2.0}', "");
    Expect(0, 983037, '\P{^Is_Age=2.0}', "");
    Error('\p{Age=_:=V2_1}');
    Error('\P{Age=_:=V2_1}');
    Expect(1, 65532, '\p{Age=v21}', "");
    Expect(0, 65532, '\p{^Age=v21}', "");
    Expect(0, 65532, '\P{Age=v21}', "");
    Expect(1, 65532, '\P{^Age=v21}', "");
    Expect(0, 65533, '\p{Age=v21}', "");
    Expect(1, 65533, '\p{^Age=v21}', "");
    Expect(1, 65533, '\P{Age=v21}', "");
    Expect(0, 65533, '\P{^Age=v21}', "");
    Expect(1, 65532, '\p{Age=_-V2_1}', "");
    Expect(0, 65532, '\p{^Age=_-V2_1}', "");
    Expect(0, 65532, '\P{Age=_-V2_1}', "");
    Expect(1, 65532, '\P{^Age=_-V2_1}', "");
    Expect(0, 65533, '\p{Age=_-V2_1}', "");
    Expect(1, 65533, '\p{^Age=_-V2_1}', "");
    Expect(1, 65533, '\P{Age=_-V2_1}', "");
    Expect(0, 65533, '\P{^Age=_-V2_1}', "");
    Error('\p{Is_Age=		0_0_0_02.1/a/}');
    Error('\P{Is_Age=		0_0_0_02.1/a/}');
    Expect(1, 65532, '\p{Is_Age=+0_0_02.1}', "");
    Expect(0, 65532, '\p{^Is_Age=+0_0_02.1}', "");
    Expect(0, 65532, '\P{Is_Age=+0_0_02.1}', "");
    Expect(1, 65532, '\P{^Is_Age=+0_0_02.1}', "");
    Expect(0, 65533, '\p{Is_Age=+0_0_02.1}', "");
    Expect(1, 65533, '\p{^Is_Age=+0_0_02.1}', "");
    Expect(1, 65533, '\P{Is_Age=+0_0_02.1}', "");
    Expect(0, 65533, '\P{^Is_Age=+0_0_02.1}', "");
    Error('\p{Age=_V3_0/a/}');
    Error('\P{Age=_V3_0/a/}');
    Expect(1, 65531, '\p{Age=v30}', "");
    Expect(0, 65531, '\p{^Age=v30}', "");
    Expect(0, 65531, '\P{Age=v30}', "");
    Expect(1, 65531, '\P{^Age=v30}', "");
    Expect(0, 65532, '\p{Age=v30}', "");
    Expect(1, 65532, '\p{^Age=v30}', "");
    Expect(1, 65532, '\P{Age=v30}', "");
    Expect(0, 65532, '\P{^Age=v30}', "");
    Expect(1, 65531, '\p{Age= 	V3_0}', "");
    Expect(0, 65531, '\p{^Age= 	V3_0}', "");
    Expect(0, 65531, '\P{Age= 	V3_0}', "");
    Expect(1, 65531, '\P{^Age= 	V3_0}', "");
    Expect(0, 65532, '\p{Age= 	V3_0}', "");
    Expect(1, 65532, '\p{^Age= 	V3_0}', "");
    Expect(1, 65532, '\P{Age= 	V3_0}', "");
    Expect(0, 65532, '\P{^Age= 	V3_0}', "");
    Error('\p{Is_Age=:=-+03.0}');
    Error('\P{Is_Age=:=-+03.0}');
    Expect(1, 65531, '\p{Is_Age=00000003.0}', "");
    Expect(0, 65531, '\p{^Is_Age=00000003.0}', "");
    Expect(0, 65531, '\P{Is_Age=00000003.0}', "");
    Expect(1, 65531, '\P{^Is_Age=00000003.0}', "");
    Expect(0, 65532, '\p{Is_Age=00000003.0}', "");
    Expect(1, 65532, '\p{^Is_Age=00000003.0}', "");
    Expect(1, 65532, '\P{Is_Age=00000003.0}', "");
    Expect(0, 65532, '\P{^Is_Age=00000003.0}', "");
    Error('\p{Age=--V3_1/a/}');
    Error('\P{Age=--V3_1/a/}');
    Expect(1, 917631, '\p{Age=v31}', "");
    Expect(0, 917631, '\p{^Age=v31}', "");
    Expect(0, 917631, '\P{Age=v31}', "");
    Expect(1, 917631, '\P{^Age=v31}', "");
    Expect(0, 917632, '\p{Age=v31}', "");
    Expect(1, 917632, '\p{^Age=v31}', "");
    Expect(1, 917632, '\P{Age=v31}', "");
    Expect(0, 917632, '\P{^Age=v31}', "");
    Expect(1, 917631, '\p{Age= V3_1}', "");
    Expect(0, 917631, '\p{^Age= V3_1}', "");
    Expect(0, 917631, '\P{Age= V3_1}', "");
    Expect(1, 917631, '\P{^Age= V3_1}', "");
    Expect(0, 917632, '\p{Age= V3_1}', "");
    Expect(1, 917632, '\p{^Age= V3_1}', "");
    Expect(1, 917632, '\P{Age= V3_1}', "");
    Expect(0, 917632, '\P{^Age= V3_1}', "");
    Error('\p{Is_Age=	0_3.1/a/}');
    Error('\P{Is_Age=	0_3.1/a/}');
    Expect(1, 917631, '\p{Is_Age=+0000003.1}', "");
    Expect(0, 917631, '\p{^Is_Age=+0000003.1}', "");
    Expect(0, 917631, '\P{Is_Age=+0000003.1}', "");
    Expect(1, 917631, '\P{^Is_Age=+0000003.1}', "");
    Expect(0, 917632, '\p{Is_Age=+0000003.1}', "");
    Expect(1, 917632, '\p{^Is_Age=+0000003.1}', "");
    Expect(1, 917632, '\P{Is_Age=+0000003.1}', "");
    Expect(0, 917632, '\P{^Is_Age=+0000003.1}', "");
    Error('\p{Age=	V3_2/a/}');
    Error('\P{Age=	V3_2/a/}');
    Expect(1, 65376, '\p{Age=v32}', "");
    Expect(0, 65376, '\p{^Age=v32}', "");
    Expect(0, 65376, '\P{Age=v32}', "");
    Expect(1, 65376, '\P{^Age=v32}', "");
    Expect(0, 65377, '\p{Age=v32}', "");
    Expect(1, 65377, '\p{^Age=v32}', "");
    Expect(1, 65377, '\P{Age=v32}', "");
    Expect(0, 65377, '\P{^Age=v32}', "");
    Expect(1, 65376, '\p{Age=  V3_2}', "");
    Expect(0, 65376, '\p{^Age=  V3_2}', "");
    Expect(0, 65376, '\P{Age=  V3_2}', "");
    Expect(1, 65376, '\P{^Age=  V3_2}', "");
    Expect(0, 65377, '\p{Age=  V3_2}', "");
    Expect(1, 65377, '\p{^Age=  V3_2}', "");
    Expect(1, 65377, '\P{Age=  V3_2}', "");
    Expect(0, 65377, '\P{^Age=  V3_2}', "");
    Error('\p{Is_Age=:=	-+0000003.2}');
    Error('\P{Is_Age=:=	-+0000003.2}');
    Expect(1, 65376, '\p{Is_Age=00_00_00_3.2}', "");
    Expect(0, 65376, '\p{^Is_Age=00_00_00_3.2}', "");
    Expect(0, 65376, '\P{Is_Age=00_00_00_3.2}', "");
    Expect(1, 65376, '\P{^Is_Age=00_00_00_3.2}', "");
    Expect(0, 65377, '\p{Is_Age=00_00_00_3.2}', "");
    Expect(1, 65377, '\p{^Is_Age=00_00_00_3.2}', "");
    Expect(1, 65377, '\P{Is_Age=00_00_00_3.2}', "");
    Expect(0, 65377, '\P{^Is_Age=00_00_00_3.2}', "");
    Error('\p{Age= :=V4_0}');
    Error('\P{Age= :=V4_0}');
    Expect(1, 917999, '\p{Age=v40}', "");
    Expect(0, 917999, '\p{^Age=v40}', "");
    Expect(0, 917999, '\P{Age=v40}', "");
    Expect(1, 917999, '\P{^Age=v40}', "");
    Expect(0, 918000, '\p{Age=v40}', "");
    Expect(1, 918000, '\p{^Age=v40}', "");
    Expect(1, 918000, '\P{Age=v40}', "");
    Expect(0, 918000, '\P{^Age=v40}', "");
    Expect(1, 917999, '\p{Age=V4_0}', "");
    Expect(0, 917999, '\p{^Age=V4_0}', "");
    Expect(0, 917999, '\P{Age=V4_0}', "");
    Expect(1, 917999, '\P{^Age=V4_0}', "");
    Expect(0, 918000, '\p{Age=V4_0}', "");
    Expect(1, 918000, '\p{^Age=V4_0}', "");
    Expect(1, 918000, '\P{Age=V4_0}', "");
    Expect(0, 918000, '\P{^Age=V4_0}', "");
    Error('\p{Is_Age=/a/ -+0000004.0}');
    Error('\P{Is_Age=/a/ -+0000004.0}');
    Expect(1, 917999, '\p{Is_Age=4.0}', "");
    Expect(0, 917999, '\p{^Is_Age=4.0}', "");
    Expect(0, 917999, '\P{Is_Age=4.0}', "");
    Expect(1, 917999, '\P{^Is_Age=4.0}', "");
    Expect(0, 918000, '\p{Is_Age=4.0}', "");
    Expect(1, 918000, '\p{^Is_Age=4.0}', "");
    Expect(1, 918000, '\P{Is_Age=4.0}', "");
    Expect(0, 918000, '\P{^Is_Age=4.0}', "");
    Error('\p{Age: := _V4_1}');
    Error('\P{Age: := _V4_1}');
    Expect(1, 120485, '\p{Age=v41}', "");
    Expect(0, 120485, '\p{^Age=v41}', "");
    Expect(0, 120485, '\P{Age=v41}', "");
    Expect(1, 120485, '\P{^Age=v41}', "");
    Expect(0, 120486, '\p{Age=v41}', "");
    Expect(1, 120486, '\p{^Age=v41}', "");
    Expect(1, 120486, '\P{Age=v41}', "");
    Expect(0, 120486, '\P{^Age=v41}', "");
    Expect(1, 120485, '\p{Age=	_V4_1}', "");
    Expect(0, 120485, '\p{^Age=	_V4_1}', "");
    Expect(0, 120485, '\P{Age=	_V4_1}', "");
    Expect(1, 120485, '\P{^Age=	_V4_1}', "");
    Expect(0, 120486, '\p{Age=	_V4_1}', "");
    Expect(1, 120486, '\p{^Age=	_V4_1}', "");
    Expect(1, 120486, '\P{Age=	_V4_1}', "");
    Expect(0, 120486, '\P{^Age=	_V4_1}', "");
    Error('\p{Is_Age=:=  004.1}');
    Error('\P{Is_Age=:=  004.1}');
    Expect(1, 120485, '\p{Is_Age=+004.1}', "");
    Expect(0, 120485, '\p{^Is_Age=+004.1}', "");
    Expect(0, 120485, '\P{Is_Age=+004.1}', "");
    Expect(1, 120485, '\P{^Is_Age=+004.1}', "");
    Expect(0, 120486, '\p{Is_Age=+004.1}', "");
    Expect(1, 120486, '\p{^Is_Age=+004.1}', "");
    Expect(1, 120486, '\P{Is_Age=+004.1}', "");
    Expect(0, 120486, '\P{^Is_Age=+004.1}', "");
    Error('\p{Age=-/a/v5_0}');
    Error('\P{Age=-/a/v5_0}');
    Expect(1, 120779, '\p{Age=v50}', "");
    Expect(0, 120779, '\p{^Age=v50}', "");
    Expect(0, 120779, '\P{Age=v50}', "");
    Expect(1, 120779, '\P{^Age=v50}', "");
    Expect(0, 120780, '\p{Age=v50}', "");
    Expect(1, 120780, '\p{^Age=v50}', "");
    Expect(1, 120780, '\P{Age=v50}', "");
    Expect(0, 120780, '\P{^Age=v50}', "");
    Expect(1, 120779, '\p{Age=	V5_0}', "");
    Expect(0, 120779, '\p{^Age=	V5_0}', "");
    Expect(0, 120779, '\P{Age=	V5_0}', "");
    Expect(1, 120779, '\P{^Age=	V5_0}', "");
    Expect(0, 120780, '\p{Age=	V5_0}', "");
    Expect(1, 120780, '\p{^Age=	V5_0}', "");
    Expect(1, 120780, '\P{Age=	V5_0}', "");
    Expect(0, 120780, '\P{^Age=	V5_0}', "");
    Error('\p{Is_Age=:= 5.0}');
    Error('\P{Is_Age=:= 5.0}');
    Expect(1, 120779, '\p{Is_Age=5.0}', "");
    Expect(0, 120779, '\p{^Is_Age=5.0}', "");
    Expect(0, 120779, '\P{Is_Age=5.0}', "");
    Expect(1, 120779, '\P{^Is_Age=5.0}', "");
    Expect(0, 120780, '\p{Is_Age=5.0}', "");
    Expect(1, 120780, '\p{^Is_Age=5.0}', "");
    Expect(1, 120780, '\P{Is_Age=5.0}', "");
    Expect(0, 120780, '\P{^Is_Age=5.0}', "");
    Error('\p{Age=-/a/V5_1}');
    Error('\P{Age=-/a/V5_1}');
    Expect(1, 127123, '\p{Age=v51}', "");
    Expect(0, 127123, '\p{^Age=v51}', "");
    Expect(0, 127123, '\P{Age=v51}', "");
    Expect(1, 127123, '\P{^Age=v51}', "");
    Expect(0, 127124, '\p{Age=v51}', "");
    Expect(1, 127124, '\p{^Age=v51}', "");
    Expect(1, 127124, '\P{Age=v51}', "");
    Expect(0, 127124, '\P{^Age=v51}', "");
    Expect(1, 127123, '\p{Age=		V5_1}', "");
    Expect(0, 127123, '\p{^Age=		V5_1}', "");
    Expect(0, 127123, '\P{Age=		V5_1}', "");
    Expect(1, 127123, '\P{^Age=		V5_1}', "");
    Expect(0, 127124, '\p{Age=		V5_1}', "");
    Expect(1, 127124, '\p{^Age=		V5_1}', "");
    Expect(1, 127124, '\P{Age=		V5_1}', "");
    Expect(0, 127124, '\P{^Age=		V5_1}', "");
    Error('\p{Is_Age=:=- 0005.1}');
    Error('\P{Is_Age=:=- 0005.1}');
    Expect(1, 127123, '\p{Is_Age=+000005.1}', "");
    Expect(0, 127123, '\p{^Is_Age=+000005.1}', "");
    Expect(0, 127123, '\P{Is_Age=+000005.1}', "");
    Expect(1, 127123, '\P{^Is_Age=+000005.1}', "");
    Expect(0, 127124, '\p{Is_Age=+000005.1}', "");
    Expect(1, 127124, '\p{^Is_Age=+000005.1}', "");
    Expect(1, 127124, '\P{Is_Age=+000005.1}', "");
    Expect(0, 127124, '\P{^Is_Age=+000005.1}', "");
    Error('\p{Age=/a/__V5_2}');
    Error('\P{Age=/a/__V5_2}');
    Expect(1, 177972, '\p{Age=v52}', "");
    Expect(0, 177972, '\p{^Age=v52}', "");
    Expect(0, 177972, '\P{Age=v52}', "");
    Expect(1, 177972, '\P{^Age=v52}', "");
    Expect(0, 177973, '\p{Age=v52}', "");
    Expect(1, 177973, '\p{^Age=v52}', "");
    Expect(1, 177973, '\P{Age=v52}', "");
    Expect(0, 177973, '\P{^Age=v52}', "");
    Expect(1, 177972, '\p{Age=_	v5_2}', "");
    Expect(0, 177972, '\p{^Age=_	v5_2}', "");
    Expect(0, 177972, '\P{Age=_	v5_2}', "");
    Expect(1, 177972, '\P{^Age=_	v5_2}', "");
    Expect(0, 177973, '\p{Age=_	v5_2}', "");
    Expect(1, 177973, '\p{^Age=_	v5_2}', "");
    Expect(1, 177973, '\P{Age=_	v5_2}', "");
    Expect(0, 177973, '\P{^Age=_	v5_2}', "");
    Error('\p{Is_Age=:=-	0_0_05.2}');
    Error('\P{Is_Age=:=-	0_0_05.2}');
    Expect(1, 177972, '\p{Is_Age=+0000_5.2}', "");
    Expect(0, 177972, '\p{^Is_Age=+0000_5.2}', "");
    Expect(0, 177972, '\P{Is_Age=+0000_5.2}', "");
    Expect(1, 177972, '\P{^Is_Age=+0000_5.2}', "");
    Expect(0, 177973, '\p{Is_Age=+0000_5.2}', "");
    Expect(1, 177973, '\p{^Is_Age=+0000_5.2}', "");
    Expect(1, 177973, '\P{Is_Age=+0000_5.2}', "");
    Expect(0, 177973, '\P{^Is_Age=+0000_5.2}', "");
    Error('\p{Age=:=V6_0}');
    Error('\P{Age=:=V6_0}');
    Expect(1, 178205, '\p{Age:	v60}', "");
    Expect(0, 178205, '\p{^Age:	v60}', "");
    Expect(0, 178205, '\P{Age:	v60}', "");
    Expect(1, 178205, '\P{^Age:	v60}', "");
    Expect(0, 178206, '\p{Age:	v60}', "");
    Expect(1, 178206, '\p{^Age:	v60}', "");
    Expect(1, 178206, '\P{Age:	v60}', "");
    Expect(0, 178206, '\P{^Age:	v60}', "");
    Expect(1, 178205, '\p{Age= -v6_0}', "");
    Expect(0, 178205, '\p{^Age= -v6_0}', "");
    Expect(0, 178205, '\P{Age= -v6_0}', "");
    Expect(1, 178205, '\P{^Age= -v6_0}', "");
    Expect(0, 178206, '\p{Age= -v6_0}', "");
    Expect(1, 178206, '\p{^Age= -v6_0}', "");
    Expect(1, 178206, '\P{Age= -v6_0}', "");
    Expect(0, 178206, '\P{^Age= -v6_0}', "");
    Error('\p{Is_Age=_0_6.0:=}');
    Error('\P{Is_Age=_0_6.0:=}');
    Expect(1, 178205, '\p{Is_Age=+00006.0}', "");
    Expect(0, 178205, '\p{^Is_Age=+00006.0}', "");
    Expect(0, 178205, '\P{Is_Age=+00006.0}', "");
    Expect(1, 178205, '\P{^Is_Age=+00006.0}', "");
    Expect(0, 178206, '\p{Is_Age=+00006.0}', "");
    Expect(1, 178206, '\p{^Is_Age=+00006.0}', "");
    Expect(1, 178206, '\P{Is_Age=+00006.0}', "");
    Expect(0, 178206, '\P{^Is_Age=+00006.0}', "");
    Error('\p{Age=:=_V6_1}');
    Error('\P{Age=:=_V6_1}');
    Expect(1, 128564, '\p{Age:	v61}', "");
    Expect(0, 128564, '\p{^Age:	v61}', "");
    Expect(0, 128564, '\P{Age:	v61}', "");
    Expect(1, 128564, '\P{^Age:	v61}', "");
    Expect(0, 128565, '\p{Age:	v61}', "");
    Expect(1, 128565, '\p{^Age:	v61}', "");
    Expect(1, 128565, '\P{Age:	v61}', "");
    Expect(0, 128565, '\P{^Age:	v61}', "");
    Expect(1, 128564, '\p{Age=		v6_1}', "");
    Expect(0, 128564, '\p{^Age=		v6_1}', "");
    Expect(0, 128564, '\P{Age=		v6_1}', "");
    Expect(1, 128564, '\P{^Age=		v6_1}', "");
    Expect(0, 128565, '\p{Age=		v6_1}', "");
    Expect(1, 128565, '\p{^Age=		v6_1}', "");
    Expect(1, 128565, '\P{Age=		v6_1}', "");
    Expect(0, 128565, '\P{^Age=		v6_1}', "");
    Error('\p{Is_Age=:=00_6.1}');
    Error('\P{Is_Age=:=00_6.1}');
    Expect(1, 128564, '\p{Is_Age=00_00_6.1}', "");
    Expect(0, 128564, '\p{^Is_Age=00_00_6.1}', "");
    Expect(0, 128564, '\P{Is_Age=00_00_6.1}', "");
    Expect(1, 128564, '\P{^Is_Age=00_00_6.1}', "");
    Expect(0, 128565, '\p{Is_Age=00_00_6.1}', "");
    Expect(1, 128565, '\p{^Is_Age=00_00_6.1}', "");
    Expect(1, 128565, '\P{Is_Age=00_00_6.1}', "");
    Expect(0, 128565, '\P{^Is_Age=00_00_6.1}', "");
    Error('\p{Age:/a/_V6_2}');
    Error('\P{Age:/a/_V6_2}');
    Expect(1, 8378, '\p{Age=v62}', "");
    Expect(0, 8378, '\p{^Age=v62}', "");
    Expect(0, 8378, '\P{Age=v62}', "");
    Expect(1, 8378, '\P{^Age=v62}', "");
    Expect(0, 8379, '\p{Age=v62}', "");
    Expect(1, 8379, '\p{^Age=v62}', "");
    Expect(1, 8379, '\P{Age=v62}', "");
    Expect(0, 8379, '\P{^Age=v62}', "");
    Expect(1, 8378, '\p{Age=	-V6_2}', "");
    Expect(0, 8378, '\p{^Age=	-V6_2}', "");
    Expect(0, 8378, '\P{Age=	-V6_2}', "");
    Expect(1, 8378, '\P{^Age=	-V6_2}', "");
    Expect(0, 8379, '\p{Age=	-V6_2}', "");
    Expect(1, 8379, '\p{^Age=	-V6_2}', "");
    Expect(1, 8379, '\P{Age=	-V6_2}', "");
    Expect(0, 8379, '\P{^Age=	-V6_2}', "");
    Error('\p{Is_Age=/a/-_+0_6.2}');
    Error('\P{Is_Age=/a/-_+0_6.2}');
    Expect(1, 8378, '\p{Is_Age=+00_00_00_006.2}', "");
    Expect(0, 8378, '\p{^Is_Age=+00_00_00_006.2}', "");
    Expect(0, 8378, '\P{Is_Age=+00_00_00_006.2}', "");
    Expect(1, 8378, '\P{^Is_Age=+00_00_00_006.2}', "");
    Expect(0, 8379, '\p{Is_Age=+00_00_00_006.2}', "");
    Expect(1, 8379, '\p{^Is_Age=+00_00_00_006.2}', "");
    Expect(1, 8379, '\P{Is_Age=+00_00_00_006.2}', "");
    Expect(0, 8379, '\P{^Is_Age=+00_00_00_006.2}', "");
    Error('\p{Age=V6_3:=}');
    Error('\P{Age=V6_3:=}');
    Expect(1, 8297, '\p{Age=v63}', "");
    Expect(0, 8297, '\p{^Age=v63}', "");
    Expect(0, 8297, '\P{Age=v63}', "");
    Expect(1, 8297, '\P{^Age=v63}', "");
    Expect(0, 8298, '\p{Age=v63}', "");
    Expect(1, 8298, '\p{^Age=v63}', "");
    Expect(1, 8298, '\P{Age=v63}', "");
    Expect(0, 8298, '\P{^Age=v63}', "");
    Expect(1, 8297, '\p{Age=	V6_3}', "");
    Expect(0, 8297, '\p{^Age=	V6_3}', "");
    Expect(0, 8297, '\P{Age=	V6_3}', "");
    Expect(1, 8297, '\P{^Age=	V6_3}', "");
    Expect(0, 8298, '\p{Age=	V6_3}', "");
    Expect(1, 8298, '\p{^Age=	V6_3}', "");
    Expect(1, 8298, '\P{Age=	V6_3}', "");
    Expect(0, 8298, '\P{^Age=	V6_3}', "");
    Error('\p{Is_Age=/a/		6.3}');
    Error('\P{Is_Age=/a/		6.3}');
    Expect(1, 8297, '\p{Is_Age=0_0_0_06.3}', "");
    Expect(0, 8297, '\p{^Is_Age=0_0_0_06.3}', "");
    Expect(0, 8297, '\P{Is_Age=0_0_0_06.3}', "");
    Expect(1, 8297, '\P{^Is_Age=0_0_0_06.3}', "");
    Expect(0, 8298, '\p{Is_Age=0_0_0_06.3}', "");
    Expect(1, 8298, '\p{^Is_Age=0_0_0_06.3}', "");
    Expect(1, 8298, '\P{Is_Age=0_0_0_06.3}', "");
    Expect(0, 8298, '\P{^Is_Age=0_0_0_06.3}', "");
    Error('\p{Age=	:=V7_0}');
    Error('\P{Age=	:=V7_0}');
    Expect(1, 129197, '\p{Age: v70}', "");
    Expect(0, 129197, '\p{^Age: v70}', "");
    Expect(0, 129197, '\P{Age: v70}', "");
    Expect(1, 129197, '\P{^Age: v70}', "");
    Expect(0, 129198, '\p{Age: v70}', "");
    Expect(1, 129198, '\p{^Age: v70}', "");
    Expect(1, 129198, '\P{Age: v70}', "");
    Expect(0, 129198, '\P{^Age: v70}', "");
    Expect(1, 129197, '\p{Age= _V7_0}', "");
    Expect(0, 129197, '\p{^Age= _V7_0}', "");
    Expect(0, 129197, '\P{Age= _V7_0}', "");
    Expect(1, 129197, '\P{^Age= _V7_0}', "");
    Expect(0, 129198, '\p{Age= _V7_0}', "");
    Expect(1, 129198, '\p{^Age= _V7_0}', "");
    Expect(1, 129198, '\P{Age= _V7_0}', "");
    Expect(0, 129198, '\P{^Age= _V7_0}', "");
    Error('\p{Is_Age=_+000007.0:=}');
    Error('\P{Is_Age=_+000007.0:=}');
    Expect(1, 129197, '\p{Is_Age=+0000000007.0}', "");
    Expect(0, 129197, '\p{^Is_Age=+0000000007.0}', "");
    Expect(0, 129197, '\P{Is_Age=+0000000007.0}', "");
    Expect(1, 129197, '\P{^Is_Age=+0000000007.0}', "");
    Expect(0, 129198, '\p{Is_Age=+0000000007.0}', "");
    Expect(1, 129198, '\p{^Is_Age=+0000000007.0}', "");
    Expect(1, 129198, '\P{Is_Age=+0000000007.0}', "");
    Expect(0, 129198, '\P{^Is_Age=+0000000007.0}', "");
    Error('\p{Age:		/a/V8_0}');
    Error('\P{Age:		/a/V8_0}');
    Expect(1, 183969, '\p{Age=v80}', "");
    Expect(0, 183969, '\p{^Age=v80}', "");
    Expect(0, 183969, '\P{Age=v80}', "");
    Expect(1, 183969, '\P{^Age=v80}', "");
    Expect(0, 183970, '\p{Age=v80}', "");
    Expect(1, 183970, '\p{^Age=v80}', "");
    Expect(1, 183970, '\P{Age=v80}', "");
    Expect(0, 183970, '\P{^Age=v80}', "");
    Expect(1, 183969, '\p{Age=_ v8_0}', "");
    Expect(0, 183969, '\p{^Age=_ v8_0}', "");
    Expect(0, 183969, '\P{Age=_ v8_0}', "");
    Expect(1, 183969, '\P{^Age=_ v8_0}', "");
    Expect(0, 183970, '\p{Age=_ v8_0}', "");
    Expect(1, 183970, '\p{^Age=_ v8_0}', "");
    Expect(1, 183970, '\P{Age=_ v8_0}', "");
    Expect(0, 183970, '\P{^Age=_ v8_0}', "");
    Error('\p{Is_Age=- +00_8.0:=}');
    Error('\P{Is_Age=- +00_8.0:=}');
    Expect(1, 183969, '\p{Is_Age:	0_8.0}', "");
    Expect(0, 183969, '\p{^Is_Age:	0_8.0}', "");
    Expect(0, 183969, '\P{Is_Age:	0_8.0}', "");
    Expect(1, 183969, '\P{^Is_Age:	0_8.0}', "");
    Expect(0, 183970, '\p{Is_Age:	0_8.0}', "");
    Expect(1, 183970, '\p{^Is_Age:	0_8.0}', "");
    Expect(1, 183970, '\P{Is_Age:	0_8.0}', "");
    Expect(0, 183970, '\P{^Is_Age:	0_8.0}', "");
    Error('\p{Age=/a/V9_0}');
    Error('\P{Age=/a/V9_0}');
    Expect(1, 129425, '\p{Age=v90}', "");
    Expect(0, 129425, '\p{^Age=v90}', "");
    Expect(0, 129425, '\P{Age=v90}', "");
    Expect(1, 129425, '\P{^Age=v90}', "");
    Expect(0, 129426, '\p{Age=v90}', "");
    Expect(1, 129426, '\p{^Age=v90}', "");
    Expect(1, 129426, '\P{Age=v90}', "");
    Expect(0, 129426, '\P{^Age=v90}', "");
    Expect(1, 129425, '\p{Age=_V9_0}', "");
    Expect(0, 129425, '\p{^Age=_V9_0}', "");
    Expect(0, 129425, '\P{Age=_V9_0}', "");
    Expect(1, 129425, '\P{^Age=_V9_0}', "");
    Expect(0, 129426, '\p{Age=_V9_0}', "");
    Expect(1, 129426, '\p{^Age=_V9_0}', "");
    Expect(1, 129426, '\P{Age=_V9_0}', "");
    Expect(0, 129426, '\P{^Age=_V9_0}', "");
    Error('\p{Is_Age= 00000000_9.0:=}');
    Error('\P{Is_Age= 00000000_9.0:=}');
    Expect(1, 129425, '\p{Is_Age=+0_9.0}', "");
    Expect(0, 129425, '\p{^Is_Age=+0_9.0}', "");
    Expect(0, 129425, '\P{Is_Age=+0_9.0}', "");
    Expect(1, 129425, '\P{^Is_Age=+0_9.0}', "");
    Expect(0, 129426, '\p{Is_Age=+0_9.0}', "");
    Expect(1, 129426, '\p{^Is_Age=+0_9.0}', "");
    Expect(1, 129426, '\P{Is_Age=+0_9.0}', "");
    Expect(0, 129426, '\P{^Is_Age=+0_9.0}', "");
    Error('\p{Age=:= unassigned}');
    Error('\P{Age=:= unassigned}');
    Expect(1, 983037, '\p{Age=unassigned}', "");
    Expect(0, 983037, '\p{^Age=unassigned}', "");
    Expect(0, 983037, '\P{Age=unassigned}', "");
    Expect(1, 983037, '\P{^Age=unassigned}', "");
    Expect(0, 983040, '\p{Age=unassigned}', "");
    Expect(1, 983040, '\p{^Age=unassigned}', "");
    Expect(1, 983040, '\P{Age=unassigned}', "");
    Expect(0, 983040, '\P{^Age=unassigned}', "");
    Expect(1, 983037, '\p{Age=  Unassigned}', "");
    Expect(0, 983037, '\p{^Age=  Unassigned}', "");
    Expect(0, 983037, '\P{Age=  Unassigned}', "");
    Expect(1, 983037, '\P{^Age=  Unassigned}', "");
    Expect(0, 983040, '\p{Age=  Unassigned}', "");
    Expect(1, 983040, '\p{^Age=  Unassigned}', "");
    Expect(1, 983040, '\P{Age=  Unassigned}', "");
    Expect(0, 983040, '\P{^Age=  Unassigned}', "");
    Error('\p{Is_Age=_:=NA}');
    Error('\P{Is_Age=_:=NA}');
    Expect(1, 983037, '\p{Is_Age=na}', "");
    Expect(0, 983037, '\p{^Is_Age=na}', "");
    Expect(0, 983037, '\P{Is_Age=na}', "");
    Expect(1, 983037, '\P{^Is_Age=na}', "");
    Expect(0, 983040, '\p{Is_Age=na}', "");
    Expect(1, 983040, '\p{^Is_Age=na}', "");
    Expect(1, 983040, '\P{Is_Age=na}', "");
    Expect(0, 983040, '\P{^Is_Age=na}', "");
    Expect(1, 983037, '\p{Is_Age= NA}', "");
    Expect(0, 983037, '\p{^Is_Age= NA}', "");
    Expect(0, 983037, '\P{Is_Age= NA}', "");
    Expect(1, 983037, '\P{^Is_Age= NA}', "");
    Expect(0, 983040, '\p{Is_Age= NA}', "");
    Expect(1, 983040, '\p{^Is_Age= NA}', "");
    Expect(1, 983040, '\P{Is_Age= NA}', "");
    Expect(0, 983040, '\P{^Is_Age= NA}', "");
    Error('\p{ASCII_Hex_Digit=__No/a/}');
    Error('\P{ASCII_Hex_Digit=__No/a/}');
    Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\p{ASCII_Hex_Digit= _No}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit= _No}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit= _No}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit= _No}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit= _No}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit= _No}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit= _No}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit= _No}', "");
    Error('\p{AHex:_n:=}');
    Error('\P{AHex:_n:=}');
    Expect(1, 103, '\p{AHex=n}', "");
    Expect(0, 103, '\p{^AHex=n}', "");
    Expect(0, 103, '\P{AHex=n}', "");
    Expect(1, 103, '\P{^AHex=n}', "");
    Expect(0, 102, '\p{AHex=n}', "");
    Expect(1, 102, '\p{^AHex=n}', "");
    Expect(1, 102, '\P{AHex=n}', "");
    Expect(0, 102, '\P{^AHex=n}', "");
    Expect(1, 103, '\p{AHex=  N}', "");
    Expect(0, 103, '\p{^AHex=  N}', "");
    Expect(0, 103, '\P{AHex=  N}', "");
    Expect(1, 103, '\P{^AHex=  N}', "");
    Expect(0, 102, '\p{AHex=  N}', "");
    Expect(1, 102, '\p{^AHex=  N}', "");
    Expect(1, 102, '\P{AHex=  N}', "");
    Expect(0, 102, '\P{^AHex=  N}', "");
    Error('\p{Is_ASCII_Hex_Digit= /a/F}');
    Error('\P{Is_ASCII_Hex_Digit= /a/F}');
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=_F}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=_F}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=_F}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=_F}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=_F}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=_F}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=_F}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=_F}', "");
    Error('\p{Is_AHex=/a/False}');
    Error('\P{Is_AHex=/a/False}');
    Expect(1, 103, '\p{Is_AHex=false}', "");
    Expect(0, 103, '\p{^Is_AHex=false}', "");
    Expect(0, 103, '\P{Is_AHex=false}', "");
    Expect(1, 103, '\P{^Is_AHex=false}', "");
    Expect(0, 102, '\p{Is_AHex=false}', "");
    Expect(1, 102, '\p{^Is_AHex=false}', "");
    Expect(1, 102, '\P{Is_AHex=false}', "");
    Expect(0, 102, '\P{^Is_AHex=false}', "");
    Expect(1, 103, '\p{Is_AHex=-False}', "");
    Expect(0, 103, '\p{^Is_AHex=-False}', "");
    Expect(0, 103, '\P{Is_AHex=-False}', "");
    Expect(1, 103, '\P{^Is_AHex=-False}', "");
    Expect(0, 102, '\p{Is_AHex=-False}', "");
    Expect(1, 102, '\p{^Is_AHex=-False}', "");
    Expect(1, 102, '\P{Is_AHex=-False}', "");
    Expect(0, 102, '\P{^Is_AHex=-False}', "");
    Error('\p{ASCII_Hex_Digit=	_yes:=}');
    Error('\P{ASCII_Hex_Digit=	_yes:=}');
    Expect(1, 102, '\p{ASCII_Hex_Digit:yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit:yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit:yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit:yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit:yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit:yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit:yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit:yes}', "");
    Expect(1, 102, '\p{ASCII_Hex_Digit=--YES}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=--YES}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=--YES}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=--YES}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=--YES}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=--YES}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=--YES}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=--YES}', "");
    Error('\p{AHex=:=_	y}');
    Error('\P{AHex=:=_	y}');
    Expect(1, 102, '\p{AHex=y}', "");
    Expect(0, 102, '\p{^AHex=y}', "");
    Expect(0, 102, '\P{AHex=y}', "");
    Expect(1, 102, '\P{^AHex=y}', "");
    Expect(0, 103, '\p{AHex=y}', "");
    Expect(1, 103, '\p{^AHex=y}', "");
    Expect(1, 103, '\P{AHex=y}', "");
    Expect(0, 103, '\P{^AHex=y}', "");
    Expect(1, 102, '\p{AHex=-Y}', "");
    Expect(0, 102, '\p{^AHex=-Y}', "");
    Expect(0, 102, '\P{AHex=-Y}', "");
    Expect(1, 102, '\P{^AHex=-Y}', "");
    Expect(0, 103, '\p{AHex=-Y}', "");
    Expect(1, 103, '\p{^AHex=-Y}', "");
    Expect(1, 103, '\P{AHex=-Y}', "");
    Expect(0, 103, '\P{^AHex=-Y}', "");
    Error('\p{Is_ASCII_Hex_Digit=/a/--T}');
    Error('\P{Is_ASCII_Hex_Digit=/a/--T}');
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=	 T}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=	 T}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=	 T}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=	 T}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=	 T}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=	 T}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=	 T}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=	 T}', "");
    Error('\p{Is_AHex=/a/		True}');
    Error('\P{Is_AHex=/a/		True}');
    Expect(1, 102, '\p{Is_AHex:true}', "");
    Expect(0, 102, '\p{^Is_AHex:true}', "");
    Expect(0, 102, '\P{Is_AHex:true}', "");
    Expect(1, 102, '\P{^Is_AHex:true}', "");
    Expect(0, 103, '\p{Is_AHex:true}', "");
    Expect(1, 103, '\p{^Is_AHex:true}', "");
    Expect(1, 103, '\P{Is_AHex:true}', "");
    Expect(0, 103, '\P{^Is_AHex:true}', "");
    Expect(1, 102, '\p{Is_AHex= TRUE}', "");
    Expect(0, 102, '\p{^Is_AHex= TRUE}', "");
    Expect(0, 102, '\P{Is_AHex= TRUE}', "");
    Expect(1, 102, '\P{^Is_AHex= TRUE}', "");
    Expect(0, 103, '\p{Is_AHex= TRUE}', "");
    Expect(1, 103, '\p{^Is_AHex= TRUE}', "");
    Expect(1, 103, '\P{Is_AHex= TRUE}', "");
    Expect(0, 103, '\P{^Is_AHex= TRUE}', "");
    Error('\p{Alphabetic=- no/a/}');
    Error('\P{Alphabetic=- no/a/}');
    Expect(1, 195102, '\p{Alphabetic:no}', "");
    Expect(0, 195102, '\p{^Alphabetic:no}', "");
    Expect(0, 195102, '\P{Alphabetic:no}', "");
    Expect(1, 195102, '\P{^Alphabetic:no}', "");
    Expect(0, 195101, '\p{Alphabetic:no}', "");
    Expect(1, 195101, '\p{^Alphabetic:no}', "");
    Expect(1, 195101, '\P{Alphabetic:no}', "");
    Expect(0, 195101, '\P{^Alphabetic:no}', "");
    Expect(1, 195102, '\p{Alphabetic=-	No}', "");
    Expect(0, 195102, '\p{^Alphabetic=-	No}', "");
    Expect(0, 195102, '\P{Alphabetic=-	No}', "");
    Expect(1, 195102, '\P{^Alphabetic=-	No}', "");
    Expect(0, 195101, '\p{Alphabetic=-	No}', "");
    Expect(1, 195101, '\p{^Alphabetic=-	No}', "");
    Expect(1, 195101, '\P{Alphabetic=-	No}', "");
    Expect(0, 195101, '\P{^Alphabetic=-	No}', "");
    Error('\p{Alpha=_ N:=}');
    Error('\P{Alpha=_ N:=}');
    Expect(1, 195102, '\p{Alpha=n}', "");
    Expect(0, 195102, '\p{^Alpha=n}', "");
    Expect(0, 195102, '\P{Alpha=n}', "");
    Expect(1, 195102, '\P{^Alpha=n}', "");
    Expect(0, 195101, '\p{Alpha=n}', "");
    Expect(1, 195101, '\p{^Alpha=n}', "");
    Expect(1, 195101, '\P{Alpha=n}', "");
    Expect(0, 195101, '\P{^Alpha=n}', "");
    Expect(1, 195102, '\p{Alpha=__n}', "");
    Expect(0, 195102, '\p{^Alpha=__n}', "");
    Expect(0, 195102, '\P{Alpha=__n}', "");
    Expect(1, 195102, '\P{^Alpha=__n}', "");
    Expect(0, 195101, '\p{Alpha=__n}', "");
    Expect(1, 195101, '\p{^Alpha=__n}', "");
    Expect(1, 195101, '\P{Alpha=__n}', "");
    Expect(0, 195101, '\P{^Alpha=__n}', "");
    Error('\p{Is_Alphabetic:		_F/a/}');
    Error('\P{Is_Alphabetic:		_F/a/}');
    Expect(1, 195102, '\p{Is_Alphabetic=f}', "");
    Expect(0, 195102, '\p{^Is_Alphabetic=f}', "");
    Expect(0, 195102, '\P{Is_Alphabetic=f}', "");
    Expect(1, 195102, '\P{^Is_Alphabetic=f}', "");
    Expect(0, 195101, '\p{Is_Alphabetic=f}', "");
    Expect(1, 195101, '\p{^Is_Alphabetic=f}', "");
    Expect(1, 195101, '\P{Is_Alphabetic=f}', "");
    Expect(0, 195101, '\P{^Is_Alphabetic=f}', "");
    Expect(1, 195102, '\p{Is_Alphabetic=-_F}', "");
    Expect(0, 195102, '\p{^Is_Alphabetic=-_F}', "");
    Expect(0, 195102, '\P{Is_Alphabetic=-_F}', "");
    Expect(1, 195102, '\P{^Is_Alphabetic=-_F}', "");
    Expect(0, 195101, '\p{Is_Alphabetic=-_F}', "");
    Expect(1, 195101, '\p{^Is_Alphabetic=-_F}', "");
    Expect(1, 195101, '\P{Is_Alphabetic=-_F}', "");
    Expect(0, 195101, '\P{^Is_Alphabetic=-_F}', "");
    Error('\p{Is_Alpha=-	false:=}');
    Error('\P{Is_Alpha=-	false:=}');
    Expect(1, 195102, '\p{Is_Alpha=false}', "");
    Expect(0, 195102, '\p{^Is_Alpha=false}', "");
    Expect(0, 195102, '\P{Is_Alpha=false}', "");
    Expect(1, 195102, '\P{^Is_Alpha=false}', "");
    Expect(0, 195101, '\p{Is_Alpha=false}', "");
    Expect(1, 195101, '\p{^Is_Alpha=false}', "");
    Expect(1, 195101, '\P{Is_Alpha=false}', "");
    Expect(0, 195101, '\P{^Is_Alpha=false}', "");
    Expect(1, 195102, '\p{Is_Alpha=-	False}', "");
    Expect(0, 195102, '\p{^Is_Alpha=-	False}', "");
    Expect(0, 195102, '\P{Is_Alpha=-	False}', "");
    Expect(1, 195102, '\P{^Is_Alpha=-	False}', "");
    Expect(0, 195101, '\p{Is_Alpha=-	False}', "");
    Expect(1, 195101, '\p{^Is_Alpha=-	False}', "");
    Expect(1, 195101, '\P{Is_Alpha=-	False}', "");
    Expect(0, 195101, '\P{^Is_Alpha=-	False}', "");
    Error('\p{Alphabetic=-yes/a/}');
    Error('\P{Alphabetic=-yes/a/}');
    Expect(1, 195101, '\p{Alphabetic:	yes}', "");
    Expect(0, 195101, '\p{^Alphabetic:	yes}', "");
    Expect(0, 195101, '\P{Alphabetic:	yes}', "");
    Expect(1, 195101, '\P{^Alphabetic:	yes}', "");
    Expect(0, 195102, '\p{Alphabetic:	yes}', "");
    Expect(1, 195102, '\p{^Alphabetic:	yes}', "");
    Expect(1, 195102, '\P{Alphabetic:	yes}', "");
    Expect(0, 195102, '\P{^Alphabetic:	yes}', "");
    Expect(1, 195101, '\p{Alphabetic= -yes}', "");
    Expect(0, 195101, '\p{^Alphabetic= -yes}', "");
    Expect(0, 195101, '\P{Alphabetic= -yes}', "");
    Expect(1, 195101, '\P{^Alphabetic= -yes}', "");
    Expect(0, 195102, '\p{Alphabetic= -yes}', "");
    Expect(1, 195102, '\p{^Alphabetic= -yes}', "");
    Expect(1, 195102, '\P{Alphabetic= -yes}', "");
    Expect(0, 195102, '\P{^Alphabetic= -yes}', "");
    Error('\p{Alpha=/a/y}');
    Error('\P{Alpha=/a/y}');
    Expect(1, 195101, '\p{Alpha=y}', "");
    Expect(0, 195101, '\p{^Alpha=y}', "");
    Expect(0, 195101, '\P{Alpha=y}', "");
    Expect(1, 195101, '\P{^Alpha=y}', "");
    Expect(0, 195102, '\p{Alpha=y}', "");
    Expect(1, 195102, '\p{^Alpha=y}', "");
    Expect(1, 195102, '\P{Alpha=y}', "");
    Expect(0, 195102, '\P{^Alpha=y}', "");
    Expect(1, 195101, '\p{Alpha=-y}', "");
    Expect(0, 195101, '\p{^Alpha=-y}', "");
    Expect(0, 195101, '\P{Alpha=-y}', "");
    Expect(1, 195101, '\P{^Alpha=-y}', "");
    Expect(0, 195102, '\p{Alpha=-y}', "");
    Expect(1, 195102, '\p{^Alpha=-y}', "");
    Expect(1, 195102, '\P{Alpha=-y}', "");
    Expect(0, 195102, '\P{^Alpha=-y}', "");
    Error('\p{Is_Alphabetic:   _T:=}');
    Error('\P{Is_Alphabetic:   _T:=}');
    Expect(1, 195101, '\p{Is_Alphabetic:   t}', "");
    Expect(0, 195101, '\p{^Is_Alphabetic:   t}', "");
    Expect(0, 195101, '\P{Is_Alphabetic:   t}', "");
    Expect(1, 195101, '\P{^Is_Alphabetic:   t}', "");
    Expect(0, 195102, '\p{Is_Alphabetic:   t}', "");
    Expect(1, 195102, '\p{^Is_Alphabetic:   t}', "");
    Expect(1, 195102, '\P{Is_Alphabetic:   t}', "");
    Expect(0, 195102, '\P{^Is_Alphabetic:   t}', "");
    Expect(1, 195101, '\p{Is_Alphabetic=		T}', "");
    Expect(0, 195101, '\p{^Is_Alphabetic=		T}', "");
    Expect(0, 195101, '\P{Is_Alphabetic=		T}', "");
    Expect(1, 195101, '\P{^Is_Alphabetic=		T}', "");
    Expect(0, 195102, '\p{Is_Alphabetic=		T}', "");
    Expect(1, 195102, '\p{^Is_Alphabetic=		T}', "");
    Expect(1, 195102, '\P{Is_Alphabetic=		T}', "");
    Expect(0, 195102, '\P{^Is_Alphabetic=		T}', "");
    Error('\p{Is_Alpha=	True:=}');
    Error('\P{Is_Alpha=	True:=}');
    Expect(1, 195101, '\p{Is_Alpha=true}', "");
    Expect(0, 195101, '\p{^Is_Alpha=true}', "");
    Expect(0, 195101, '\P{Is_Alpha=true}', "");
    Expect(1, 195101, '\P{^Is_Alpha=true}', "");
    Expect(0, 195102, '\p{Is_Alpha=true}', "");
    Expect(1, 195102, '\p{^Is_Alpha=true}', "");
    Expect(1, 195102, '\P{Is_Alpha=true}', "");
    Expect(0, 195102, '\P{^Is_Alpha=true}', "");
    Expect(1, 195101, '\p{Is_Alpha= 	true}', "");
    Expect(0, 195101, '\p{^Is_Alpha= 	true}', "");
    Expect(0, 195101, '\P{Is_Alpha= 	true}', "");
    Expect(1, 195101, '\P{^Is_Alpha= 	true}', "");
    Expect(0, 195102, '\p{Is_Alpha= 	true}', "");
    Expect(1, 195102, '\p{^Is_Alpha= 	true}', "");
    Expect(1, 195102, '\P{Is_Alpha= 	true}', "");
    Expect(0, 195102, '\P{^Is_Alpha= 	true}', "");
    Error('\p{bidiclass}');
    Error('\P{bidiclass}');
    Error('\p{bc}');
    Error('\P{bc}');
    Error('\p{Bidi_Class=__Arabic_Letter:=}');
    Error('\P{Bidi_Class=__Arabic_Letter:=}');
    Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Bidi_Class=	Arabic_letter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=	Arabic_letter}', "");
    Expect(0, 126719, '\P{Bidi_Class=	Arabic_letter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=	Arabic_letter}', "");
    Expect(0, 126720, '\p{Bidi_Class=	Arabic_letter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=	Arabic_letter}', "");
    Expect(1, 126720, '\P{Bidi_Class=	Arabic_letter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=	Arabic_letter}', "");
    Error('\p{Bc=	AL/a/}');
    Error('\P{Bc=	AL/a/}');
    Expect(1, 126719, '\p{Bc:   al}', "");
    Expect(0, 126719, '\p{^Bc:   al}', "");
    Expect(0, 126719, '\P{Bc:   al}', "");
    Expect(1, 126719, '\P{^Bc:   al}', "");
    Expect(0, 126720, '\p{Bc:   al}', "");
    Expect(1, 126720, '\p{^Bc:   al}', "");
    Expect(1, 126720, '\P{Bc:   al}', "");
    Expect(0, 126720, '\P{^Bc:   al}', "");
    Expect(1, 126719, '\p{Bc=_ AL}', "");
    Expect(0, 126719, '\p{^Bc=_ AL}', "");
    Expect(0, 126719, '\P{Bc=_ AL}', "");
    Expect(1, 126719, '\P{^Bc=_ AL}', "");
    Expect(0, 126720, '\p{Bc=_ AL}', "");
    Expect(1, 126720, '\p{^Bc=_ AL}', "");
    Expect(1, 126720, '\P{Bc=_ AL}', "");
    Expect(0, 126720, '\P{^Bc=_ AL}', "");
    Error('\p{Is_Bidi_Class=		Arabic_letter/a/}');
    Error('\P{Is_Bidi_Class=		Arabic_letter/a/}');
    Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Is_Bidi_Class=		arabic_Letter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=		arabic_Letter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=		arabic_Letter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=		arabic_Letter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=		arabic_Letter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=		arabic_Letter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=		arabic_Letter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=		arabic_Letter}', "");
    Error('\p{Is_Bc=-al/a/}');
    Error('\P{Is_Bc=-al/a/}');
    Expect(1, 126719, '\p{Is_Bc=al}', "");
    Expect(0, 126719, '\p{^Is_Bc=al}', "");
    Expect(0, 126719, '\P{Is_Bc=al}', "");
    Expect(1, 126719, '\P{^Is_Bc=al}', "");
    Expect(0, 126720, '\p{Is_Bc=al}', "");
    Expect(1, 126720, '\p{^Is_Bc=al}', "");
    Expect(1, 126720, '\P{Is_Bc=al}', "");
    Expect(0, 126720, '\P{^Is_Bc=al}', "");
    Expect(1, 126719, '\p{Is_Bc=		al}', "");
    Expect(0, 126719, '\p{^Is_Bc=		al}', "");
    Expect(0, 126719, '\P{Is_Bc=		al}', "");
    Expect(1, 126719, '\P{^Is_Bc=		al}', "");
    Expect(0, 126720, '\p{Is_Bc=		al}', "");
    Expect(1, 126720, '\p{^Is_Bc=		al}', "");
    Expect(1, 126720, '\P{Is_Bc=		al}', "");
    Expect(0, 126720, '\P{^Is_Bc=		al}', "");
    Error('\p{Bidi_Class= ARABIC_Number:=}');
    Error('\P{Bidi_Class= ARABIC_Number:=}');
    Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Bidi_Class=	-arabic_NUMBER}', "");
    Expect(0, 69246, '\p{^Bidi_Class=	-arabic_NUMBER}', "");
    Expect(0, 69246, '\P{Bidi_Class=	-arabic_NUMBER}', "");
    Expect(1, 69246, '\P{^Bidi_Class=	-arabic_NUMBER}', "");
    Expect(0, 69247, '\p{Bidi_Class=	-arabic_NUMBER}', "");
    Expect(1, 69247, '\p{^Bidi_Class=	-arabic_NUMBER}', "");
    Expect(1, 69247, '\P{Bidi_Class=	-arabic_NUMBER}', "");
    Expect(0, 69247, '\P{^Bidi_Class=	-arabic_NUMBER}', "");
    Error('\p{Bc=	_an:=}');
    Error('\P{Bc=	_an:=}');
    Expect(1, 69246, '\p{Bc=an}', "");
    Expect(0, 69246, '\p{^Bc=an}', "");
    Expect(0, 69246, '\P{Bc=an}', "");
    Expect(1, 69246, '\P{^Bc=an}', "");
    Expect(0, 69247, '\p{Bc=an}', "");
    Expect(1, 69247, '\p{^Bc=an}', "");
    Expect(1, 69247, '\P{Bc=an}', "");
    Expect(0, 69247, '\P{^Bc=an}', "");
    Expect(1, 69246, '\p{Bc=_-AN}', "");
    Expect(0, 69246, '\p{^Bc=_-AN}', "");
    Expect(0, 69246, '\P{Bc=_-AN}', "");
    Expect(1, 69246, '\P{^Bc=_-AN}', "");
    Expect(0, 69247, '\p{Bc=_-AN}', "");
    Expect(1, 69247, '\p{^Bc=_-AN}', "");
    Expect(1, 69247, '\P{Bc=_-AN}', "");
    Expect(0, 69247, '\P{^Bc=_-AN}', "");
    Error('\p{Is_Bidi_Class:_ARABIC_Number:=}');
    Error('\P{Is_Bidi_Class:_ARABIC_Number:=}');
    Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Is_Bidi_Class=_Arabic_Number}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=_Arabic_Number}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=_Arabic_Number}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=_Arabic_Number}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=_Arabic_Number}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=_Arabic_Number}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=_Arabic_Number}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=_Arabic_Number}', "");
    Error('\p{Is_Bc= AN:=}');
    Error('\P{Is_Bc= AN:=}');
    Expect(1, 69246, '\p{Is_Bc=an}', "");
    Expect(0, 69246, '\p{^Is_Bc=an}', "");
    Expect(0, 69246, '\P{Is_Bc=an}', "");
    Expect(1, 69246, '\P{^Is_Bc=an}', "");
    Expect(0, 69247, '\p{Is_Bc=an}', "");
    Expect(1, 69247, '\p{^Is_Bc=an}', "");
    Expect(1, 69247, '\P{Is_Bc=an}', "");
    Expect(0, 69247, '\P{^Is_Bc=an}', "");
    Expect(1, 69246, '\p{Is_Bc=__AN}', "");
    Expect(0, 69246, '\p{^Is_Bc=__AN}', "");
    Expect(0, 69246, '\P{Is_Bc=__AN}', "");
    Expect(1, 69246, '\P{^Is_Bc=__AN}', "");
    Expect(0, 69247, '\p{Is_Bc=__AN}', "");
    Expect(1, 69247, '\p{^Is_Bc=__AN}', "");
    Expect(1, 69247, '\P{Is_Bc=__AN}', "");
    Expect(0, 69247, '\P{^Is_Bc=__AN}', "");
    Error('\p{Bidi_Class=:=--paragraph_SEPARATOR}');
    Error('\P{Bidi_Class=:=--paragraph_SEPARATOR}');
    Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Bidi_Class=-_Paragraph_separator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=-_Paragraph_separator}', "");
    Expect(0, 8233, '\P{Bidi_Class=-_Paragraph_separator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=-_Paragraph_separator}', "");
    Expect(0, 8234, '\p{Bidi_Class=-_Paragraph_separator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=-_Paragraph_separator}', "");
    Expect(1, 8234, '\P{Bidi_Class=-_Paragraph_separator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=-_Paragraph_separator}', "");
    Error('\p{Bc=	:=B}');
    Error('\P{Bc=	:=B}');
    Expect(1, 8233, '\p{Bc=b}', "");
    Expect(0, 8233, '\p{^Bc=b}', "");
    Expect(0, 8233, '\P{Bc=b}', "");
    Expect(1, 8233, '\P{^Bc=b}', "");
    Expect(0, 8234, '\p{Bc=b}', "");
    Expect(1, 8234, '\p{^Bc=b}', "");
    Expect(1, 8234, '\P{Bc=b}', "");
    Expect(0, 8234, '\P{^Bc=b}', "");
    Expect(1, 8233, '\p{Bc: 		b}', "");
    Expect(0, 8233, '\p{^Bc: 		b}', "");
    Expect(0, 8233, '\P{Bc: 		b}', "");
    Expect(1, 8233, '\P{^Bc: 		b}', "");
    Expect(0, 8234, '\p{Bc: 		b}', "");
    Expect(1, 8234, '\p{^Bc: 		b}', "");
    Expect(1, 8234, '\P{Bc: 		b}', "");
    Expect(0, 8234, '\P{^Bc: 		b}', "");
    Error('\p{Is_Bidi_Class= PARAGRAPH_Separator/a/}');
    Error('\P{Is_Bidi_Class= PARAGRAPH_Separator/a/}');
    Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=	_paragraph_SEPARATOR}', "");
    Error('\p{Is_Bc=:=	 b}');
    Error('\P{Is_Bc=:=	 b}');
    Expect(1, 8233, '\p{Is_Bc=b}', "");
    Expect(0, 8233, '\p{^Is_Bc=b}', "");
    Expect(0, 8233, '\P{Is_Bc=b}', "");
    Expect(1, 8233, '\P{^Is_Bc=b}', "");
    Expect(0, 8234, '\p{Is_Bc=b}', "");
    Expect(1, 8234, '\p{^Is_Bc=b}', "");
    Expect(1, 8234, '\P{Is_Bc=b}', "");
    Expect(0, 8234, '\P{^Is_Bc=b}', "");
    Expect(1, 8233, '\p{Is_Bc= B}', "");
    Expect(0, 8233, '\p{^Is_Bc= B}', "");
    Expect(0, 8233, '\P{Is_Bc= B}', "");
    Expect(1, 8233, '\P{^Is_Bc= B}', "");
    Expect(0, 8234, '\p{Is_Bc= B}', "");
    Expect(1, 8234, '\p{^Is_Bc= B}', "");
    Expect(1, 8234, '\P{Is_Bc= B}', "");
    Expect(0, 8234, '\P{^Is_Bc= B}', "");
    Error('\p{Bidi_Class=:=-Boundary_Neutral}');
    Error('\P{Bidi_Class=:=-Boundary_Neutral}');
    Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Bidi_Class= 	boundary_neutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class= 	boundary_neutral}', "");
    Expect(0, 921599, '\P{Bidi_Class= 	boundary_neutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class= 	boundary_neutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class= 	boundary_neutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class= 	boundary_neutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class= 	boundary_neutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class= 	boundary_neutral}', "");
    Error('\p{Bc=_ BN/a/}');
    Error('\P{Bc=_ BN/a/}');
    Expect(1, 921599, '\p{Bc=bn}', "");
    Expect(0, 921599, '\p{^Bc=bn}', "");
    Expect(0, 921599, '\P{Bc=bn}', "");
    Expect(1, 921599, '\P{^Bc=bn}', "");
    Expect(0, 1114109, '\p{Bc=bn}', "");
    Expect(1, 1114109, '\p{^Bc=bn}', "");
    Expect(1, 1114109, '\P{Bc=bn}', "");
    Expect(0, 1114109, '\P{^Bc=bn}', "");
    Error('\p{Is_Bidi_Class=	:=BOUNDARY_neutral}');
    Error('\P{Is_Bidi_Class=	:=BOUNDARY_neutral}');
    Expect(1, 921599, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=- Boundary_Neutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=- Boundary_Neutral}', "");
    Error('\p{Is_Bc:   	/a/bn}');
    Error('\P{Is_Bc:   	/a/bn}');
    Expect(1, 921599, '\p{Is_Bc:   bn}', "");
    Expect(0, 921599, '\p{^Is_Bc:   bn}', "");
    Expect(0, 921599, '\P{Is_Bc:   bn}', "");
    Expect(1, 921599, '\P{^Is_Bc:   bn}', "");
    Expect(0, 1114109, '\p{Is_Bc:   bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc:   bn}', "");
    Expect(1, 1114109, '\P{Is_Bc:   bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc:   bn}', "");
    Expect(1, 921599, '\p{Is_Bc:    	BN}', "");
    Expect(0, 921599, '\p{^Is_Bc:    	BN}', "");
    Expect(0, 921599, '\P{Is_Bc:    	BN}', "");
    Expect(1, 921599, '\P{^Is_Bc:    	BN}', "");
    Expect(0, 1114109, '\p{Is_Bc:    	BN}', "");
    Expect(1, 1114109, '\p{^Is_Bc:    	BN}', "");
    Expect(1, 1114109, '\P{Is_Bc:    	BN}', "");
    Expect(0, 1114109, '\P{^Is_Bc:    	BN}', "");
    Error('\p{Bidi_Class= _Common_Separator:=}');
    Error('\P{Bidi_Class= _Common_Separator:=}');
    Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Bidi_Class=_	COMMON_Separator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=_	COMMON_Separator}', "");
    Expect(0, 65306, '\P{Bidi_Class=_	COMMON_Separator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=_	COMMON_Separator}', "");
    Expect(0, 65307, '\p{Bidi_Class=_	COMMON_Separator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=_	COMMON_Separator}', "");
    Expect(1, 65307, '\P{Bidi_Class=_	COMMON_Separator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=_	COMMON_Separator}', "");
    Error('\p{Bc=_:=CS}');
    Error('\P{Bc=_:=CS}');
    Expect(1, 65306, '\p{Bc=cs}', "");
    Expect(0, 65306, '\p{^Bc=cs}', "");
    Expect(0, 65306, '\P{Bc=cs}', "");
    Expect(1, 65306, '\P{^Bc=cs}', "");
    Expect(0, 65307, '\p{Bc=cs}', "");
    Expect(1, 65307, '\p{^Bc=cs}', "");
    Expect(1, 65307, '\P{Bc=cs}', "");
    Expect(0, 65307, '\P{^Bc=cs}', "");
    Expect(1, 65306, '\p{Bc=  cs}', "");
    Expect(0, 65306, '\p{^Bc=  cs}', "");
    Expect(0, 65306, '\P{Bc=  cs}', "");
    Expect(1, 65306, '\P{^Bc=  cs}', "");
    Expect(0, 65307, '\p{Bc=  cs}', "");
    Expect(1, 65307, '\p{^Bc=  cs}', "");
    Expect(1, 65307, '\P{Bc=  cs}', "");
    Expect(0, 65307, '\P{^Bc=  cs}', "");
    Error('\p{Is_Bidi_Class= common_separator/a/}');
    Error('\P{Is_Bidi_Class= common_separator/a/}');
    Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=_-COMMON_separator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=_-COMMON_separator}', "");
    Error('\p{Is_Bc= _CS/a/}');
    Error('\P{Is_Bc= _CS/a/}');
    Expect(1, 65306, '\p{Is_Bc=cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=cs}', "");
    Expect(0, 65306, '\P{Is_Bc=cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=cs}', "");
    Expect(0, 65307, '\p{Is_Bc=cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=cs}', "");
    Expect(1, 65307, '\P{Is_Bc=cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=cs}', "");
    Expect(1, 65306, '\p{Is_Bc=  CS}', "");
    Expect(0, 65306, '\p{^Is_Bc=  CS}', "");
    Expect(0, 65306, '\P{Is_Bc=  CS}', "");
    Expect(1, 65306, '\P{^Is_Bc=  CS}', "");
    Expect(0, 65307, '\p{Is_Bc=  CS}', "");
    Expect(1, 65307, '\p{^Is_Bc=  CS}', "");
    Expect(1, 65307, '\P{Is_Bc=  CS}', "");
    Expect(0, 65307, '\P{^Is_Bc=  CS}', "");
    Error('\p{Bidi_Class=__European_Number:=}');
    Error('\P{Bidi_Class=__European_Number:=}');
    Expect(1, 127242, '\p{Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\p{^Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\P{Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\P{^Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\p{Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\p{^Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\P{Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\P{^Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\p{Bidi_Class= _EUROPEAN_Number}', "");
    Expect(0, 127242, '\p{^Bidi_Class= _EUROPEAN_Number}', "");
    Expect(0, 127242, '\P{Bidi_Class= _EUROPEAN_Number}', "");
    Expect(1, 127242, '\P{^Bidi_Class= _EUROPEAN_Number}', "");
    Expect(0, 127243, '\p{Bidi_Class= _EUROPEAN_Number}', "");
    Expect(1, 127243, '\p{^Bidi_Class= _EUROPEAN_Number}', "");
    Expect(1, 127243, '\P{Bidi_Class= _EUROPEAN_Number}', "");
    Expect(0, 127243, '\P{^Bidi_Class= _EUROPEAN_Number}', "");
    Error('\p{Bc=/a/en}');
    Error('\P{Bc=/a/en}');
    Expect(1, 127242, '\p{Bc:en}', "");
    Expect(0, 127242, '\p{^Bc:en}', "");
    Expect(0, 127242, '\P{Bc:en}', "");
    Expect(1, 127242, '\P{^Bc:en}', "");
    Expect(0, 127243, '\p{Bc:en}', "");
    Expect(1, 127243, '\p{^Bc:en}', "");
    Expect(1, 127243, '\P{Bc:en}', "");
    Expect(0, 127243, '\P{^Bc:en}', "");
    Expect(1, 127242, '\p{Bc=_-EN}', "");
    Expect(0, 127242, '\p{^Bc=_-EN}', "");
    Expect(0, 127242, '\P{Bc=_-EN}', "");
    Expect(1, 127242, '\P{^Bc=_-EN}', "");
    Expect(0, 127243, '\p{Bc=_-EN}', "");
    Expect(1, 127243, '\p{^Bc=_-EN}', "");
    Expect(1, 127243, '\P{Bc=_-EN}', "");
    Expect(0, 127243, '\P{^Bc=_-EN}', "");
    Error('\p{Is_Bidi_Class=_European_NUMBER:=}');
    Error('\P{Is_Bidi_Class=_European_NUMBER:=}');
    Expect(1, 127242, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127242, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127243, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 127243, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 127242, '\p{Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(0, 127242, '\p{^Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(0, 127242, '\P{Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(1, 127242, '\P{^Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(0, 127243, '\p{Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(1, 127243, '\p{^Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(1, 127243, '\P{Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Expect(0, 127243, '\P{^Is_Bidi_Class= -EUROPEAN_NUMBER}', "");
    Error('\p{Is_Bc=:=	en}');
    Error('\P{Is_Bc=:=	en}');
    Expect(1, 127242, '\p{Is_Bc:	en}', "");
    Expect(0, 127242, '\p{^Is_Bc:	en}', "");
    Expect(0, 127242, '\P{Is_Bc:	en}', "");
    Expect(1, 127242, '\P{^Is_Bc:	en}', "");
    Expect(0, 127243, '\p{Is_Bc:	en}', "");
    Expect(1, 127243, '\p{^Is_Bc:	en}', "");
    Expect(1, 127243, '\P{Is_Bc:	en}', "");
    Expect(0, 127243, '\P{^Is_Bc:	en}', "");
    Expect(1, 127242, '\p{Is_Bc=_	EN}', "");
    Expect(0, 127242, '\p{^Is_Bc=_	EN}', "");
    Expect(0, 127242, '\P{Is_Bc=_	EN}', "");
    Expect(1, 127242, '\P{^Is_Bc=_	EN}', "");
    Expect(0, 127243, '\p{Is_Bc=_	EN}', "");
    Expect(1, 127243, '\p{^Is_Bc=_	EN}', "");
    Expect(1, 127243, '\P{Is_Bc=_	EN}', "");
    Expect(0, 127243, '\P{^Is_Bc=_	EN}', "");
    Error('\p{Bidi_Class:    /a/European_Separator}');
    Error('\P{Bidi_Class:    /a/European_Separator}');
    Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(0, 65293, '\P{Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(0, 65294, '\p{Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(1, 65294, '\P{Bidi_Class=-_EUROPEAN_Separator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=-_EUROPEAN_Separator}', "");
    Error('\p{Bc=:=		ES}');
    Error('\P{Bc=:=		ES}');
    Expect(1, 65293, '\p{Bc=es}', "");
    Expect(0, 65293, '\p{^Bc=es}', "");
    Expect(0, 65293, '\P{Bc=es}', "");
    Expect(1, 65293, '\P{^Bc=es}', "");
    Expect(0, 65294, '\p{Bc=es}', "");
    Expect(1, 65294, '\p{^Bc=es}', "");
    Expect(1, 65294, '\P{Bc=es}', "");
    Expect(0, 65294, '\P{^Bc=es}', "");
    Expect(1, 65293, '\p{Bc= _es}', "");
    Expect(0, 65293, '\p{^Bc= _es}', "");
    Expect(0, 65293, '\P{Bc= _es}', "");
    Expect(1, 65293, '\P{^Bc= _es}', "");
    Expect(0, 65294, '\p{Bc= _es}', "");
    Expect(1, 65294, '\p{^Bc= _es}', "");
    Expect(1, 65294, '\P{Bc= _es}', "");
    Expect(0, 65294, '\P{^Bc= _es}', "");
    Error('\p{Is_Bidi_Class=:=	European_Separator}');
    Error('\P{Is_Bidi_Class=:=	European_Separator}');
    Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=-EUROPEAN_Separator}', "");
    Error('\p{Is_Bc=/a/ _es}');
    Error('\P{Is_Bc=/a/ _es}');
    Expect(1, 65293, '\p{Is_Bc=es}', "");
    Expect(0, 65293, '\p{^Is_Bc=es}', "");
    Expect(0, 65293, '\P{Is_Bc=es}', "");
    Expect(1, 65293, '\P{^Is_Bc=es}', "");
    Expect(0, 65294, '\p{Is_Bc=es}', "");
    Expect(1, 65294, '\p{^Is_Bc=es}', "");
    Expect(1, 65294, '\P{Is_Bc=es}', "");
    Expect(0, 65294, '\P{^Is_Bc=es}', "");
    Expect(1, 65293, '\p{Is_Bc=	-ES}', "");
    Expect(0, 65293, '\p{^Is_Bc=	-ES}', "");
    Expect(0, 65293, '\P{Is_Bc=	-ES}', "");
    Expect(1, 65293, '\P{^Is_Bc=	-ES}', "");
    Expect(0, 65294, '\p{Is_Bc=	-ES}', "");
    Expect(1, 65294, '\p{^Is_Bc=	-ES}', "");
    Expect(1, 65294, '\P{Is_Bc=	-ES}', "");
    Expect(0, 65294, '\P{^Is_Bc=	-ES}', "");
    Error('\p{Bidi_Class=_european_Terminator:=}');
    Error('\P{Bidi_Class=_european_Terminator:=}');
    Expect(1, 65510, '\p{Bidi_Class=europeanterminator}', "");
    Expect(0, 65510, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(0, 65510, '\P{Bidi_Class=europeanterminator}', "");
    Expect(1, 65510, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(0, 65511, '\p{Bidi_Class=europeanterminator}', "");
    Expect(1, 65511, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(1, 65511, '\P{Bidi_Class=europeanterminator}', "");
    Expect(0, 65511, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(1, 65510, '\p{Bidi_Class= european_Terminator}', "");
    Expect(0, 65510, '\p{^Bidi_Class= european_Terminator}', "");
    Expect(0, 65510, '\P{Bidi_Class= european_Terminator}', "");
    Expect(1, 65510, '\P{^Bidi_Class= european_Terminator}', "");
    Expect(0, 65511, '\p{Bidi_Class= european_Terminator}', "");
    Expect(1, 65511, '\p{^Bidi_Class= european_Terminator}', "");
    Expect(1, 65511, '\P{Bidi_Class= european_Terminator}', "");
    Expect(0, 65511, '\P{^Bidi_Class= european_Terminator}', "");
    Error('\p{Bc:   -/a/ET}');
    Error('\P{Bc:   -/a/ET}');
    Expect(1, 65510, '\p{Bc=et}', "");
    Expect(0, 65510, '\p{^Bc=et}', "");
    Expect(0, 65510, '\P{Bc=et}', "");
    Expect(1, 65510, '\P{^Bc=et}', "");
    Expect(0, 65511, '\p{Bc=et}', "");
    Expect(1, 65511, '\p{^Bc=et}', "");
    Expect(1, 65511, '\P{Bc=et}', "");
    Expect(0, 65511, '\P{^Bc=et}', "");
    Expect(1, 65510, '\p{Bc=	_ET}', "");
    Expect(0, 65510, '\p{^Bc=	_ET}', "");
    Expect(0, 65510, '\P{Bc=	_ET}', "");
    Expect(1, 65510, '\P{^Bc=	_ET}', "");
    Expect(0, 65511, '\p{Bc=	_ET}', "");
    Expect(1, 65511, '\p{^Bc=	_ET}', "");
    Expect(1, 65511, '\P{Bc=	_ET}', "");
    Expect(0, 65511, '\P{^Bc=	_ET}', "");
    Error('\p{Is_Bidi_Class=--european_terminator/a/}');
    Error('\P{Is_Bidi_Class=--european_terminator/a/}');
    Expect(1, 65510, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 65510, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 65510, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 65510, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 65511, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 65511, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 65511, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 65511, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 65510, '\p{Is_Bidi_Class=__European_terminator}', "");
    Expect(0, 65510, '\p{^Is_Bidi_Class=__European_terminator}', "");
    Expect(0, 65510, '\P{Is_Bidi_Class=__European_terminator}', "");
    Expect(1, 65510, '\P{^Is_Bidi_Class=__European_terminator}', "");
    Expect(0, 65511, '\p{Is_Bidi_Class=__European_terminator}', "");
    Expect(1, 65511, '\p{^Is_Bidi_Class=__European_terminator}', "");
    Expect(1, 65511, '\P{Is_Bidi_Class=__European_terminator}', "");
    Expect(0, 65511, '\P{^Is_Bidi_Class=__European_terminator}', "");
    Error('\p{Is_Bc=	-et:=}');
    Error('\P{Is_Bc=	-et:=}');
    Expect(1, 65510, '\p{Is_Bc:et}', "");
    Expect(0, 65510, '\p{^Is_Bc:et}', "");
    Expect(0, 65510, '\P{Is_Bc:et}', "");
    Expect(1, 65510, '\P{^Is_Bc:et}', "");
    Expect(0, 65511, '\p{Is_Bc:et}', "");
    Expect(1, 65511, '\p{^Is_Bc:et}', "");
    Expect(1, 65511, '\P{Is_Bc:et}', "");
    Expect(0, 65511, '\P{^Is_Bc:et}', "");
    Expect(1, 65510, '\p{Is_Bc=-_ET}', "");
    Expect(0, 65510, '\p{^Is_Bc=-_ET}', "");
    Expect(0, 65510, '\P{Is_Bc=-_ET}', "");
    Expect(1, 65510, '\P{^Is_Bc=-_ET}', "");
    Expect(0, 65511, '\p{Is_Bc=-_ET}', "");
    Expect(1, 65511, '\p{^Is_Bc=-_ET}', "");
    Expect(1, 65511, '\P{Is_Bc=-_ET}', "");
    Expect(0, 65511, '\P{^Is_Bc=-_ET}', "");
    Error('\p{Bidi_Class=:= -FIRST_Strong_ISOLATE}');
    Error('\P{Bidi_Class=:= -FIRST_Strong_ISOLATE}');
    Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=-FIRST_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=-FIRST_Strong_Isolate}', "");
    Error('\p{Bc=/a/FSI}');
    Error('\P{Bc=/a/FSI}');
    Expect(1, 8296, '\p{Bc=fsi}', "");
    Expect(0, 8296, '\p{^Bc=fsi}', "");
    Expect(0, 8296, '\P{Bc=fsi}', "");
    Expect(1, 8296, '\P{^Bc=fsi}', "");
    Expect(0, 8297, '\p{Bc=fsi}', "");
    Expect(1, 8297, '\p{^Bc=fsi}', "");
    Expect(1, 8297, '\P{Bc=fsi}', "");
    Expect(0, 8297, '\P{^Bc=fsi}', "");
    Expect(1, 8296, '\p{Bc=_ fsi}', "");
    Expect(0, 8296, '\p{^Bc=_ fsi}', "");
    Expect(0, 8296, '\P{Bc=_ fsi}', "");
    Expect(1, 8296, '\P{^Bc=_ fsi}', "");
    Expect(0, 8297, '\p{Bc=_ fsi}', "");
    Expect(1, 8297, '\p{^Bc=_ fsi}', "");
    Expect(1, 8297, '\P{Bc=_ fsi}', "");
    Expect(0, 8297, '\P{^Bc=_ fsi}', "");
    Error('\p{Is_Bidi_Class=/a/__FIRST_Strong_ISOLATE}');
    Error('\P{Is_Bidi_Class=/a/__FIRST_Strong_ISOLATE}');
    Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=_FIRST_Strong_Isolate}', "");
    Error('\p{Is_Bc=	 FSI/a/}');
    Error('\P{Is_Bc=	 FSI/a/}');
    Expect(1, 8296, '\p{Is_Bc=fsi}', "");
    Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
    Expect(0, 8296, '\P{Is_Bc=fsi}', "");
    Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
    Expect(0, 8297, '\p{Is_Bc=fsi}', "");
    Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
    Expect(1, 8297, '\P{Is_Bc=fsi}', "");
    Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
    Expect(1, 8296, '\p{Is_Bc=	_FSI}', "");
    Expect(0, 8296, '\p{^Is_Bc=	_FSI}', "");
    Expect(0, 8296, '\P{Is_Bc=	_FSI}', "");
    Expect(1, 8296, '\P{^Is_Bc=	_FSI}', "");
    Expect(0, 8297, '\p{Is_Bc=	_FSI}', "");
    Expect(1, 8297, '\p{^Is_Bc=	_FSI}', "");
    Expect(1, 8297, '\P{Is_Bc=	_FSI}', "");
    Expect(0, 8297, '\P{^Is_Bc=	_FSI}', "");
    Error('\p{Bidi_Class=_/a/LEFT_to_Right}');
    Error('\P{Bidi_Class=_/a/LEFT_to_Right}');
    Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Bidi_Class=-_LEFT_To_Right}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=-_LEFT_To_Right}', "");
    Expect(0, 1114109, '\P{Bidi_Class=-_LEFT_To_Right}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=-_LEFT_To_Right}', "");
    Expect(0, 921599, '\p{Bidi_Class=-_LEFT_To_Right}', "");
    Expect(1, 921599, '\p{^Bidi_Class=-_LEFT_To_Right}', "");
    Expect(1, 921599, '\P{Bidi_Class=-_LEFT_To_Right}', "");
    Expect(0, 921599, '\P{^Bidi_Class=-_LEFT_To_Right}', "");
    Error('\p{Bc=L:=}');
    Error('\P{Bc=L:=}');
    Expect(1, 1114109, '\p{Bc=l}', "");
    Expect(0, 1114109, '\p{^Bc=l}', "");
    Expect(0, 1114109, '\P{Bc=l}', "");
    Expect(1, 1114109, '\P{^Bc=l}', "");
    Expect(0, 921599, '\p{Bc=l}', "");
    Expect(1, 921599, '\p{^Bc=l}', "");
    Expect(1, 921599, '\P{Bc=l}', "");
    Expect(0, 921599, '\P{^Bc=l}', "");
    Expect(1, 1114109, '\p{Bc=_	l}', "");
    Expect(0, 1114109, '\p{^Bc=_	l}', "");
    Expect(0, 1114109, '\P{Bc=_	l}', "");
    Expect(1, 1114109, '\P{^Bc=_	l}', "");
    Expect(0, 921599, '\p{Bc=_	l}', "");
    Expect(1, 921599, '\p{^Bc=_	l}', "");
    Expect(1, 921599, '\P{Bc=_	l}', "");
    Expect(0, 921599, '\P{^Bc=_	l}', "");
    Error('\p{Is_Bidi_Class:	-LEFT_TO_right/a/}');
    Error('\P{Is_Bidi_Class:	-LEFT_TO_right/a/}');
    Expect(1, 1114109, '\p{Is_Bidi_Class:	lefttoright}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class:	lefttoright}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class:	lefttoright}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class:	lefttoright}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class:	lefttoright}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class:	lefttoright}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class:	lefttoright}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class:	lefttoright}', "");
    Expect(1, 1114109, '\p{Is_Bidi_Class=-Left_To_Right}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=-Left_To_Right}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=-Left_To_Right}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=-Left_To_Right}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=-Left_To_Right}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=-Left_To_Right}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=-Left_To_Right}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=-Left_To_Right}', "");
    Error('\p{Is_Bc=/a/	L}');
    Error('\P{Is_Bc=/a/	L}');
    Expect(1, 1114109, '\p{Is_Bc=l}', "");
    Expect(0, 1114109, '\p{^Is_Bc=l}', "");
    Expect(0, 1114109, '\P{Is_Bc=l}', "");
    Expect(1, 1114109, '\P{^Is_Bc=l}', "");
    Expect(0, 921599, '\p{Is_Bc=l}', "");
    Expect(1, 921599, '\p{^Is_Bc=l}', "");
    Expect(1, 921599, '\P{Is_Bc=l}', "");
    Expect(0, 921599, '\P{^Is_Bc=l}', "");
    Expect(1, 1114109, '\p{Is_Bc=- L}', "");
    Expect(0, 1114109, '\p{^Is_Bc=- L}', "");
    Expect(0, 1114109, '\P{Is_Bc=- L}', "");
    Expect(1, 1114109, '\P{^Is_Bc=- L}', "");
    Expect(0, 921599, '\p{Is_Bc=- L}', "");
    Expect(1, 921599, '\p{^Is_Bc=- L}', "");
    Expect(1, 921599, '\P{Is_Bc=- L}', "");
    Expect(0, 921599, '\P{^Is_Bc=- L}', "");
    Error('\p{Bidi_Class=Left_TO_Right_Embedding/a/}');
    Error('\P{Bidi_Class=Left_TO_Right_Embedding/a/}');
    Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=_Left_To_Right_embedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=_Left_To_Right_embedding}', "");
    Error('\p{Bc=LRE/a/}');
    Error('\P{Bc=LRE/a/}');
    Expect(1, 8234, '\p{Bc=lre}', "");
    Expect(0, 8234, '\p{^Bc=lre}', "");
    Expect(0, 8234, '\P{Bc=lre}', "");
    Expect(1, 8234, '\P{^Bc=lre}', "");
    Expect(0, 8235, '\p{Bc=lre}', "");
    Expect(1, 8235, '\p{^Bc=lre}', "");
    Expect(1, 8235, '\P{Bc=lre}', "");
    Expect(0, 8235, '\P{^Bc=lre}', "");
    Expect(1, 8234, '\p{Bc:	 lre}', "");
    Expect(0, 8234, '\p{^Bc:	 lre}', "");
    Expect(0, 8234, '\P{Bc:	 lre}', "");
    Expect(1, 8234, '\P{^Bc:	 lre}', "");
    Expect(0, 8235, '\p{Bc:	 lre}', "");
    Expect(1, 8235, '\p{^Bc:	 lre}', "");
    Expect(1, 8235, '\P{Bc:	 lre}', "");
    Expect(0, 8235, '\P{^Bc:	 lre}', "");
    Error('\p{Is_Bidi_Class=	Left_To_Right_Embedding:=}');
    Error('\P{Is_Bidi_Class=	Left_To_Right_Embedding:=}');
    Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class= left_To_Right_Embedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class= left_To_Right_Embedding}', "");
    Error('\p{Is_Bc=/a/ _LRE}');
    Error('\P{Is_Bc=/a/ _LRE}');
    Expect(1, 8234, '\p{Is_Bc=lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=lre}', "");
    Expect(0, 8234, '\P{Is_Bc=lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=lre}', "");
    Expect(0, 8235, '\p{Is_Bc=lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=lre}', "");
    Expect(1, 8235, '\P{Is_Bc=lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=lre}', "");
    Expect(1, 8234, '\p{Is_Bc=-LRE}', "");
    Expect(0, 8234, '\p{^Is_Bc=-LRE}', "");
    Expect(0, 8234, '\P{Is_Bc=-LRE}', "");
    Expect(1, 8234, '\P{^Is_Bc=-LRE}', "");
    Expect(0, 8235, '\p{Is_Bc=-LRE}', "");
    Expect(1, 8235, '\p{^Is_Bc=-LRE}', "");
    Expect(1, 8235, '\P{Is_Bc=-LRE}', "");
    Expect(0, 8235, '\P{^Is_Bc=-LRE}', "");
    Error('\p{Bidi_Class=/a/--Left_to_Right_Isolate}');
    Error('\P{Bidi_Class=/a/--Left_to_Right_Isolate}');
    Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=_	Left_To_right_isolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=_	Left_To_right_isolate}', "");
    Error('\p{Bc=:=		LRI}');
    Error('\P{Bc=:=		LRI}');
    Expect(1, 8294, '\p{Bc=lri}', "");
    Expect(0, 8294, '\p{^Bc=lri}', "");
    Expect(0, 8294, '\P{Bc=lri}', "");
    Expect(1, 8294, '\P{^Bc=lri}', "");
    Expect(0, 8295, '\p{Bc=lri}', "");
    Expect(1, 8295, '\p{^Bc=lri}', "");
    Expect(1, 8295, '\P{Bc=lri}', "");
    Expect(0, 8295, '\P{^Bc=lri}', "");
    Expect(1, 8294, '\p{Bc= -LRI}', "");
    Expect(0, 8294, '\p{^Bc= -LRI}', "");
    Expect(0, 8294, '\P{Bc= -LRI}', "");
    Expect(1, 8294, '\P{^Bc= -LRI}', "");
    Expect(0, 8295, '\p{Bc= -LRI}', "");
    Expect(1, 8295, '\p{^Bc= -LRI}', "");
    Expect(1, 8295, '\P{Bc= -LRI}', "");
    Expect(0, 8295, '\P{^Bc= -LRI}', "");
    Error('\p{Is_Bidi_Class=:=_-LEFT_TO_Right_Isolate}');
    Error('\P{Is_Bidi_Class=:=_-LEFT_TO_Right_Isolate}');
    Expect(1, 8294, '\p{Is_Bidi_Class: lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class: lefttorightisolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class: lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class: lefttorightisolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class: lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class: lefttorightisolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class: lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class: lefttorightisolate}', "");
    Expect(1, 8294, '\p{Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=-left_to_Right_ISOLATE}', "");
    Error('\p{Is_Bc=-lri:=}');
    Error('\P{Is_Bc=-lri:=}');
    Expect(1, 8294, '\p{Is_Bc: lri}', "");
    Expect(0, 8294, '\p{^Is_Bc: lri}', "");
    Expect(0, 8294, '\P{Is_Bc: lri}', "");
    Expect(1, 8294, '\P{^Is_Bc: lri}', "");
    Expect(0, 8295, '\p{Is_Bc: lri}', "");
    Expect(1, 8295, '\p{^Is_Bc: lri}', "");
    Expect(1, 8295, '\P{Is_Bc: lri}', "");
    Expect(0, 8295, '\P{^Is_Bc: lri}', "");
    Expect(1, 8294, '\p{Is_Bc=-	LRI}', "");
    Expect(0, 8294, '\p{^Is_Bc=-	LRI}', "");
    Expect(0, 8294, '\P{Is_Bc=-	LRI}', "");
    Expect(1, 8294, '\P{^Is_Bc=-	LRI}', "");
    Expect(0, 8295, '\p{Is_Bc=-	LRI}', "");
    Expect(1, 8295, '\p{^Is_Bc=-	LRI}', "");
    Expect(1, 8295, '\P{Is_Bc=-	LRI}', "");
    Expect(0, 8295, '\P{^Is_Bc=-	LRI}', "");
    Error('\p{Bidi_Class=-/a/Left_TO_right_OVERRIDE}');
    Error('\P{Bidi_Class=-/a/Left_TO_right_OVERRIDE}');
    Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Bidi_Class=	-left_To_Right_override}', "");
    Expect(0, 8237, '\p{^Bidi_Class=	-left_To_Right_override}', "");
    Expect(0, 8237, '\P{Bidi_Class=	-left_To_Right_override}', "");
    Expect(1, 8237, '\P{^Bidi_Class=	-left_To_Right_override}', "");
    Expect(0, 8238, '\p{Bidi_Class=	-left_To_Right_override}', "");
    Expect(1, 8238, '\p{^Bidi_Class=	-left_To_Right_override}', "");
    Expect(1, 8238, '\P{Bidi_Class=	-left_To_Right_override}', "");
    Expect(0, 8238, '\P{^Bidi_Class=	-left_To_Right_override}', "");
    Error('\p{Bc=LRO:=}');
    Error('\P{Bc=LRO:=}');
    Expect(1, 8237, '\p{Bc=lro}', "");
    Expect(0, 8237, '\p{^Bc=lro}', "");
    Expect(0, 8237, '\P{Bc=lro}', "");
    Expect(1, 8237, '\P{^Bc=lro}', "");
    Expect(0, 8238, '\p{Bc=lro}', "");
    Expect(1, 8238, '\p{^Bc=lro}', "");
    Expect(1, 8238, '\P{Bc=lro}', "");
    Expect(0, 8238, '\P{^Bc=lro}', "");
    Expect(1, 8237, '\p{Bc=		LRO}', "");
    Expect(0, 8237, '\p{^Bc=		LRO}', "");
    Expect(0, 8237, '\P{Bc=		LRO}', "");
    Expect(1, 8237, '\P{^Bc=		LRO}', "");
    Expect(0, 8238, '\p{Bc=		LRO}', "");
    Expect(1, 8238, '\p{^Bc=		LRO}', "");
    Expect(1, 8238, '\P{Bc=		LRO}', "");
    Expect(0, 8238, '\P{^Bc=		LRO}', "");
    Error('\p{Is_Bidi_Class=-Left_To_RIGHT_OVERRIDE/a/}');
    Error('\P{Is_Bidi_Class=-Left_To_RIGHT_OVERRIDE/a/}');
    Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=--Left_To_RIGHT_Override}', "");
    Error('\p{Is_Bc=/a/ -LRO}');
    Error('\P{Is_Bc=/a/ -LRO}');
    Expect(1, 8237, '\p{Is_Bc=lro}', "");
    Expect(0, 8237, '\p{^Is_Bc=lro}', "");
    Expect(0, 8237, '\P{Is_Bc=lro}', "");
    Expect(1, 8237, '\P{^Is_Bc=lro}', "");
    Expect(0, 8238, '\p{Is_Bc=lro}', "");
    Expect(1, 8238, '\p{^Is_Bc=lro}', "");
    Expect(1, 8238, '\P{Is_Bc=lro}', "");
    Expect(0, 8238, '\P{^Is_Bc=lro}', "");
    Expect(1, 8237, '\p{Is_Bc=  LRO}', "");
    Expect(0, 8237, '\p{^Is_Bc=  LRO}', "");
    Expect(0, 8237, '\P{Is_Bc=  LRO}', "");
    Expect(1, 8237, '\P{^Is_Bc=  LRO}', "");
    Expect(0, 8238, '\p{Is_Bc=  LRO}', "");
    Expect(1, 8238, '\p{^Is_Bc=  LRO}', "");
    Expect(1, 8238, '\P{Is_Bc=  LRO}', "");
    Expect(0, 8238, '\P{^Is_Bc=  LRO}', "");
    Error('\p{Bidi_Class=		NONSPACING_Mark/a/}');
    Error('\P{Bidi_Class=		NONSPACING_Mark/a/}');
    Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Bidi_Class=-NONSPACING_mark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=-NONSPACING_mark}', "");
    Expect(0, 917999, '\P{Bidi_Class=-NONSPACING_mark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=-NONSPACING_mark}', "");
    Expect(0, 918000, '\p{Bidi_Class=-NONSPACING_mark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=-NONSPACING_mark}', "");
    Expect(1, 918000, '\P{Bidi_Class=-NONSPACING_mark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=-NONSPACING_mark}', "");
    Error('\p{Bc:	_-NSM:=}');
    Error('\P{Bc:	_-NSM:=}');
    Expect(1, 917999, '\p{Bc=nsm}', "");
    Expect(0, 917999, '\p{^Bc=nsm}', "");
    Expect(0, 917999, '\P{Bc=nsm}', "");
    Expect(1, 917999, '\P{^Bc=nsm}', "");
    Expect(0, 918000, '\p{Bc=nsm}', "");
    Expect(1, 918000, '\p{^Bc=nsm}', "");
    Expect(1, 918000, '\P{Bc=nsm}', "");
    Expect(0, 918000, '\P{^Bc=nsm}', "");
    Expect(1, 917999, '\p{Bc= 	NSM}', "");
    Expect(0, 917999, '\p{^Bc= 	NSM}', "");
    Expect(0, 917999, '\P{Bc= 	NSM}', "");
    Expect(1, 917999, '\P{^Bc= 	NSM}', "");
    Expect(0, 918000, '\p{Bc= 	NSM}', "");
    Expect(1, 918000, '\p{^Bc= 	NSM}', "");
    Expect(1, 918000, '\P{Bc= 	NSM}', "");
    Expect(0, 918000, '\P{^Bc= 	NSM}', "");
    Error('\p{Is_Bidi_Class=:= 	Nonspacing_mark}');
    Error('\P{Is_Bidi_Class=:= 	Nonspacing_mark}');
    Expect(1, 917999, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=--nonspacing_Mark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=--nonspacing_Mark}', "");
    Error('\p{Is_Bc=NSM/a/}');
    Error('\P{Is_Bc=NSM/a/}');
    Expect(1, 917999, '\p{Is_Bc=nsm}', "");
    Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
    Expect(0, 917999, '\P{Is_Bc=nsm}', "");
    Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
    Expect(0, 918000, '\p{Is_Bc=nsm}', "");
    Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
    Expect(1, 918000, '\P{Is_Bc=nsm}', "");
    Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
    Expect(1, 917999, '\p{Is_Bc=--NSM}', "");
    Expect(0, 917999, '\p{^Is_Bc=--NSM}', "");
    Expect(0, 917999, '\P{Is_Bc=--NSM}', "");
    Expect(1, 917999, '\P{^Is_Bc=--NSM}', "");
    Expect(0, 918000, '\p{Is_Bc=--NSM}', "");
    Expect(1, 918000, '\p{^Is_Bc=--NSM}', "");
    Expect(1, 918000, '\P{Is_Bc=--NSM}', "");
    Expect(0, 918000, '\P{^Is_Bc=--NSM}', "");
    Error('\p{Bidi_Class:	  OTHER_neutral/a/}');
    Error('\P{Bidi_Class:	  OTHER_neutral/a/}');
    Expect(1, 129510, '\p{Bidi_Class=otherneutral}', "");
    Expect(0, 129510, '\p{^Bidi_Class=otherneutral}', "");
    Expect(0, 129510, '\P{Bidi_Class=otherneutral}', "");
    Expect(1, 129510, '\P{^Bidi_Class=otherneutral}', "");
    Expect(0, 129511, '\p{Bidi_Class=otherneutral}', "");
    Expect(1, 129511, '\p{^Bidi_Class=otherneutral}', "");
    Expect(1, 129511, '\P{Bidi_Class=otherneutral}', "");
    Expect(0, 129511, '\P{^Bidi_Class=otherneutral}', "");
    Expect(1, 129510, '\p{Bidi_Class=-	Other_Neutral}', "");
    Expect(0, 129510, '\p{^Bidi_Class=-	Other_Neutral}', "");
    Expect(0, 129510, '\P{Bidi_Class=-	Other_Neutral}', "");
    Expect(1, 129510, '\P{^Bidi_Class=-	Other_Neutral}', "");
    Expect(0, 129511, '\p{Bidi_Class=-	Other_Neutral}', "");
    Expect(1, 129511, '\p{^Bidi_Class=-	Other_Neutral}', "");
    Expect(1, 129511, '\P{Bidi_Class=-	Other_Neutral}', "");
    Expect(0, 129511, '\P{^Bidi_Class=-	Other_Neutral}', "");
    Error('\p{Bc=:=  ON}');
    Error('\P{Bc=:=  ON}');
    Expect(1, 129510, '\p{Bc=on}', "");
    Expect(0, 129510, '\p{^Bc=on}', "");
    Expect(0, 129510, '\P{Bc=on}', "");
    Expect(1, 129510, '\P{^Bc=on}', "");
    Expect(0, 129511, '\p{Bc=on}', "");
    Expect(1, 129511, '\p{^Bc=on}', "");
    Expect(1, 129511, '\P{Bc=on}', "");
    Expect(0, 129511, '\P{^Bc=on}', "");
    Expect(1, 129510, '\p{Bc=- ON}', "");
    Expect(0, 129510, '\p{^Bc=- ON}', "");
    Expect(0, 129510, '\P{Bc=- ON}', "");
    Expect(1, 129510, '\P{^Bc=- ON}', "");
    Expect(0, 129511, '\p{Bc=- ON}', "");
    Expect(1, 129511, '\p{^Bc=- ON}', "");
    Expect(1, 129511, '\P{Bc=- ON}', "");
    Expect(0, 129511, '\P{^Bc=- ON}', "");
    Error('\p{Is_Bidi_Class=	/a/other_NEUTRAL}');
    Error('\P{Is_Bidi_Class=	/a/other_NEUTRAL}');
    Expect(1, 129510, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129510, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129510, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129510, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129511, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129511, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129511, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129511, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129510, '\p{Is_Bidi_Class=	 other_Neutral}', "");
    Expect(0, 129510, '\p{^Is_Bidi_Class=	 other_Neutral}', "");
    Expect(0, 129510, '\P{Is_Bidi_Class=	 other_Neutral}', "");
    Expect(1, 129510, '\P{^Is_Bidi_Class=	 other_Neutral}', "");
    Expect(0, 129511, '\p{Is_Bidi_Class=	 other_Neutral}', "");
    Expect(1, 129511, '\p{^Is_Bidi_Class=	 other_Neutral}', "");
    Expect(1, 129511, '\P{Is_Bidi_Class=	 other_Neutral}', "");
    Expect(0, 129511, '\P{^Is_Bidi_Class=	 other_Neutral}', "");
    Error('\p{Is_Bc=_/a/ON}');
    Error('\P{Is_Bc=_/a/ON}');
    Expect(1, 129510, '\p{Is_Bc=on}', "");
    Expect(0, 129510, '\p{^Is_Bc=on}', "");
    Expect(0, 129510, '\P{Is_Bc=on}', "");
    Expect(1, 129510, '\P{^Is_Bc=on}', "");
    Expect(0, 129511, '\p{Is_Bc=on}', "");
    Expect(1, 129511, '\p{^Is_Bc=on}', "");
    Expect(1, 129511, '\P{Is_Bc=on}', "");
    Expect(0, 129511, '\P{^Is_Bc=on}', "");
    Expect(1, 129510, '\p{Is_Bc=_ON}', "");
    Expect(0, 129510, '\p{^Is_Bc=_ON}', "");
    Expect(0, 129510, '\P{Is_Bc=_ON}', "");
    Expect(1, 129510, '\P{^Is_Bc=_ON}', "");
    Expect(0, 129511, '\p{Is_Bc=_ON}', "");
    Expect(1, 129511, '\p{^Is_Bc=_ON}', "");
    Expect(1, 129511, '\P{Is_Bc=_ON}', "");
    Expect(0, 129511, '\P{^Is_Bc=_ON}', "");
    Error('\p{Bidi_Class=_	Pop_DIRECTIONAL_Format:=}');
    Error('\P{Bidi_Class=_	Pop_DIRECTIONAL_Format:=}');
    Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(0, 8236, '\p{^Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(0, 8236, '\P{Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(1, 8236, '\P{^Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(0, 8237, '\p{Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(1, 8237, '\p{^Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(1, 8237, '\P{Bidi_Class=	Pop_Directional_FORMAT}', "");
    Expect(0, 8237, '\P{^Bidi_Class=	Pop_Directional_FORMAT}', "");
    Error('\p{Bc:/a/_PDF}');
    Error('\P{Bc:/a/_PDF}');
    Expect(1, 8236, '\p{Bc=pdf}', "");
    Expect(0, 8236, '\p{^Bc=pdf}', "");
    Expect(0, 8236, '\P{Bc=pdf}', "");
    Expect(1, 8236, '\P{^Bc=pdf}', "");
    Expect(0, 8237, '\p{Bc=pdf}', "");
    Expect(1, 8237, '\p{^Bc=pdf}', "");
    Expect(1, 8237, '\P{Bc=pdf}', "");
    Expect(0, 8237, '\P{^Bc=pdf}', "");
    Expect(1, 8236, '\p{Bc=_	PDF}', "");
    Expect(0, 8236, '\p{^Bc=_	PDF}', "");
    Expect(0, 8236, '\P{Bc=_	PDF}', "");
    Expect(1, 8236, '\P{^Bc=_	PDF}', "");
    Expect(0, 8237, '\p{Bc=_	PDF}', "");
    Expect(1, 8237, '\p{^Bc=_	PDF}', "");
    Expect(1, 8237, '\P{Bc=_	PDF}', "");
    Expect(0, 8237, '\P{^Bc=_	PDF}', "");
    Error('\p{Is_Bidi_Class=_:=POP_directional_format}');
    Error('\P{Is_Bidi_Class=_:=POP_directional_format}');
    Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=	 pop_DIRECTIONAL_format}', "");
    Error('\p{Is_Bc=:= 	PDF}');
    Error('\P{Is_Bc=:= 	PDF}');
    Expect(1, 8236, '\p{Is_Bc=pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
    Expect(1, 8236, '\p{Is_Bc=		PDF}', "");
    Expect(0, 8236, '\p{^Is_Bc=		PDF}', "");
    Expect(0, 8236, '\P{Is_Bc=		PDF}', "");
    Expect(1, 8236, '\P{^Is_Bc=		PDF}', "");
    Expect(0, 8237, '\p{Is_Bc=		PDF}', "");
    Expect(1, 8237, '\p{^Is_Bc=		PDF}', "");
    Expect(1, 8237, '\P{Is_Bc=		PDF}', "");
    Expect(0, 8237, '\P{^Is_Bc=		PDF}', "");
    Error('\p{Bidi_Class=/a/	pop_Directional_isolate}');
    Error('\P{Bidi_Class=/a/	pop_Directional_isolate}');
    Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(0, 8297, '\p{^Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(0, 8297, '\P{Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(1, 8297, '\P{^Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(0, 8298, '\p{Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(1, 8298, '\p{^Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(1, 8298, '\P{Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Expect(0, 8298, '\P{^Bidi_Class=_ Pop_Directional_ISOLATE}', "");
    Error('\p{Bc= pdi/a/}');
    Error('\P{Bc= pdi/a/}');
    Expect(1, 8297, '\p{Bc=pdi}', "");
    Expect(0, 8297, '\p{^Bc=pdi}', "");
    Expect(0, 8297, '\P{Bc=pdi}', "");
    Expect(1, 8297, '\P{^Bc=pdi}', "");
    Expect(0, 8298, '\p{Bc=pdi}', "");
    Expect(1, 8298, '\p{^Bc=pdi}', "");
    Expect(1, 8298, '\P{Bc=pdi}', "");
    Expect(0, 8298, '\P{^Bc=pdi}', "");
    Expect(1, 8297, '\p{Bc= PDI}', "");
    Expect(0, 8297, '\p{^Bc= PDI}', "");
    Expect(0, 8297, '\P{Bc= PDI}', "");
    Expect(1, 8297, '\P{^Bc= PDI}', "");
    Expect(0, 8298, '\p{Bc= PDI}', "");
    Expect(1, 8298, '\p{^Bc= PDI}', "");
    Expect(1, 8298, '\P{Bc= PDI}', "");
    Expect(0, 8298, '\P{^Bc= PDI}', "");
    Error('\p{Is_Bidi_Class= POP_Directional_isolate:=}');
    Error('\P{Is_Bidi_Class= POP_Directional_isolate:=}');
    Expect(1, 8297, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class:_Pop_DIRECTIONAL_isolate}', "");
    Error('\p{Is_Bc=:=_-PDI}');
    Error('\P{Is_Bc=:=_-PDI}');
    Expect(1, 8297, '\p{Is_Bc=pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
    Expect(0, 8297, '\P{Is_Bc=pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
    Expect(0, 8298, '\p{Is_Bc=pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
    Expect(1, 8298, '\P{Is_Bc=pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
    Expect(1, 8297, '\p{Is_Bc=-_pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc=-_pdi}', "");
    Expect(0, 8297, '\P{Is_Bc=-_pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc=-_pdi}', "");
    Expect(0, 8298, '\p{Is_Bc=-_pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc=-_pdi}', "");
    Expect(1, 8298, '\P{Is_Bc=-_pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc=-_pdi}', "");
    Error('\p{Bidi_Class=	/a/right_To_LEFT}');
    Error('\P{Bidi_Class=	/a/right_To_LEFT}');
    Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Bidi_Class= right_To_left}', "");
    Expect(0, 126975, '\p{^Bidi_Class= right_To_left}', "");
    Expect(0, 126975, '\P{Bidi_Class= right_To_left}', "");
    Expect(1, 126975, '\P{^Bidi_Class= right_To_left}', "");
    Expect(0, 126976, '\p{Bidi_Class= right_To_left}', "");
    Expect(1, 126976, '\p{^Bidi_Class= right_To_left}', "");
    Expect(1, 126976, '\P{Bidi_Class= right_To_left}', "");
    Expect(0, 126976, '\P{^Bidi_Class= right_To_left}', "");
    Error('\p{Bc=:=R}');
    Error('\P{Bc=:=R}');
    Expect(1, 126975, '\p{Bc=r}', "");
    Expect(0, 126975, '\p{^Bc=r}', "");
    Expect(0, 126975, '\P{Bc=r}', "");
    Expect(1, 126975, '\P{^Bc=r}', "");
    Expect(0, 126976, '\p{Bc=r}', "");
    Expect(1, 126976, '\p{^Bc=r}', "");
    Expect(1, 126976, '\P{Bc=r}', "");
    Expect(0, 126976, '\P{^Bc=r}', "");
    Expect(1, 126975, '\p{Bc=	-R}', "");
    Expect(0, 126975, '\p{^Bc=	-R}', "");
    Expect(0, 126975, '\P{Bc=	-R}', "");
    Expect(1, 126975, '\P{^Bc=	-R}', "");
    Expect(0, 126976, '\p{Bc=	-R}', "");
    Expect(1, 126976, '\p{^Bc=	-R}', "");
    Expect(1, 126976, '\P{Bc=	-R}', "");
    Expect(0, 126976, '\P{^Bc=	-R}', "");
    Error('\p{Is_Bidi_Class=/a/ _Right_to_left}');
    Error('\P{Is_Bidi_Class=/a/ _Right_to_left}');
    Expect(1, 126975, '\p{Is_Bidi_Class:righttoleft}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class:righttoleft}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class:righttoleft}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class:righttoleft}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class:righttoleft}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class:righttoleft}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class:righttoleft}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class:righttoleft}', "");
    Expect(1, 126975, '\p{Is_Bidi_Class=_Right_to_left}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=_Right_to_left}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=_Right_to_left}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=_Right_to_left}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=_Right_to_left}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=_Right_to_left}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=_Right_to_left}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=_Right_to_left}', "");
    Error('\p{Is_Bc=	-r:=}');
    Error('\P{Is_Bc=	-r:=}');
    Expect(1, 126975, '\p{Is_Bc=r}', "");
    Expect(0, 126975, '\p{^Is_Bc=r}', "");
    Expect(0, 126975, '\P{Is_Bc=r}', "");
    Expect(1, 126975, '\P{^Is_Bc=r}', "");
    Expect(0, 126976, '\p{Is_Bc=r}', "");
    Expect(1, 126976, '\p{^Is_Bc=r}', "");
    Expect(1, 126976, '\P{Is_Bc=r}', "");
    Expect(0, 126976, '\P{^Is_Bc=r}', "");
    Expect(1, 126975, '\p{Is_Bc=R}', "");
    Expect(0, 126975, '\p{^Is_Bc=R}', "");
    Expect(0, 126975, '\P{Is_Bc=R}', "");
    Expect(1, 126975, '\P{^Is_Bc=R}', "");
    Expect(0, 126976, '\p{Is_Bc=R}', "");
    Expect(1, 126976, '\p{^Is_Bc=R}', "");
    Expect(1, 126976, '\P{Is_Bc=R}', "");
    Expect(0, 126976, '\P{^Is_Bc=R}', "");
    Error('\p{Bidi_Class=/a/-	Right_To_Left_Embedding}');
    Error('\P{Bidi_Class=/a/-	Right_To_Left_Embedding}');
    Expect(1, 8235, '\p{Bidi_Class:righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class:righttoleftembedding}', "");
    Expect(0, 8235, '\P{Bidi_Class:righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class:righttoleftembedding}', "");
    Expect(0, 8236, '\p{Bidi_Class:righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class:righttoleftembedding}', "");
    Expect(1, 8236, '\P{Bidi_Class:righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class:righttoleftembedding}', "");
    Expect(1, 8235, '\p{Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(0, 8235, '\p{^Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(0, 8235, '\P{Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(1, 8235, '\P{^Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(0, 8236, '\p{Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(1, 8236, '\p{^Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(1, 8236, '\P{Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Expect(0, 8236, '\P{^Bidi_Class= Right_to_LEFT_EMBEDDING}', "");
    Error('\p{Bc=:=	 RLE}');
    Error('\P{Bc=:=	 RLE}');
    Expect(1, 8235, '\p{Bc=rle}', "");
    Expect(0, 8235, '\p{^Bc=rle}', "");
    Expect(0, 8235, '\P{Bc=rle}', "");
    Expect(1, 8235, '\P{^Bc=rle}', "");
    Expect(0, 8236, '\p{Bc=rle}', "");
    Expect(1, 8236, '\p{^Bc=rle}', "");
    Expect(1, 8236, '\P{Bc=rle}', "");
    Expect(0, 8236, '\P{^Bc=rle}', "");
    Expect(1, 8235, '\p{Bc= 	RLE}', "");
    Expect(0, 8235, '\p{^Bc= 	RLE}', "");
    Expect(0, 8235, '\P{Bc= 	RLE}', "");
    Expect(1, 8235, '\P{^Bc= 	RLE}', "");
    Expect(0, 8236, '\p{Bc= 	RLE}', "");
    Expect(1, 8236, '\p{^Bc= 	RLE}', "");
    Expect(1, 8236, '\P{Bc= 	RLE}', "");
    Expect(0, 8236, '\P{^Bc= 	RLE}', "");
    Error('\p{Is_Bidi_Class=:=	right_to_Left_Embedding}');
    Error('\P{Is_Bidi_Class=:=	right_to_Left_Embedding}');
    Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=-Right_To_LEFT_embedding}', "");
    Error('\p{Is_Bc=/a/_ RLE}');
    Error('\P{Is_Bc=/a/_ RLE}');
    Expect(1, 8235, '\p{Is_Bc=rle}', "");
    Expect(0, 8235, '\p{^Is_Bc=rle}', "");
    Expect(0, 8235, '\P{Is_Bc=rle}', "");
    Expect(1, 8235, '\P{^Is_Bc=rle}', "");
    Expect(0, 8236, '\p{Is_Bc=rle}', "");
    Expect(1, 8236, '\p{^Is_Bc=rle}', "");
    Expect(1, 8236, '\P{Is_Bc=rle}', "");
    Expect(0, 8236, '\P{^Is_Bc=rle}', "");
    Expect(1, 8235, '\p{Is_Bc:			RLE}', "");
    Expect(0, 8235, '\p{^Is_Bc:			RLE}', "");
    Expect(0, 8235, '\P{Is_Bc:			RLE}', "");
    Expect(1, 8235, '\P{^Is_Bc:			RLE}', "");
    Expect(0, 8236, '\p{Is_Bc:			RLE}', "");
    Expect(1, 8236, '\p{^Is_Bc:			RLE}', "");
    Expect(1, 8236, '\P{Is_Bc:			RLE}', "");
    Expect(0, 8236, '\P{^Is_Bc:			RLE}', "");
    Error('\p{Bidi_Class=:= Right_TO_left_Isolate}');
    Error('\P{Bidi_Class=:= Right_TO_left_Isolate}');
    Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=-Right_TO_LEFT_Isolate}', "");
    Error('\p{Bc=/a/ RLI}');
    Error('\P{Bc=/a/ RLI}');
    Expect(1, 8295, '\p{Bc=rli}', "");
    Expect(0, 8295, '\p{^Bc=rli}', "");
    Expect(0, 8295, '\P{Bc=rli}', "");
    Expect(1, 8295, '\P{^Bc=rli}', "");
    Expect(0, 8296, '\p{Bc=rli}', "");
    Expect(1, 8296, '\p{^Bc=rli}', "");
    Expect(1, 8296, '\P{Bc=rli}', "");
    Expect(0, 8296, '\P{^Bc=rli}', "");
    Expect(1, 8295, '\p{Bc= 	RLI}', "");
    Expect(0, 8295, '\p{^Bc= 	RLI}', "");
    Expect(0, 8295, '\P{Bc= 	RLI}', "");
    Expect(1, 8295, '\P{^Bc= 	RLI}', "");
    Expect(0, 8296, '\p{Bc= 	RLI}', "");
    Expect(1, 8296, '\p{^Bc= 	RLI}', "");
    Expect(1, 8296, '\P{Bc= 	RLI}', "");
    Expect(0, 8296, '\P{^Bc= 	RLI}', "");
    Error('\p{Is_Bidi_Class= 	Right_TO_left_Isolate/a/}');
    Error('\P{Is_Bidi_Class= 	Right_TO_left_Isolate/a/}');
    Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=__Right_to_LEFT_Isolate}', "");
    Error('\p{Is_Bc=  RLI:=}');
    Error('\P{Is_Bc=  RLI:=}');
    Expect(1, 8295, '\p{Is_Bc=rli}', "");
    Expect(0, 8295, '\p{^Is_Bc=rli}', "");
    Expect(0, 8295, '\P{Is_Bc=rli}', "");
    Expect(1, 8295, '\P{^Is_Bc=rli}', "");
    Expect(0, 8296, '\p{Is_Bc=rli}', "");
    Expect(1, 8296, '\p{^Is_Bc=rli}', "");
    Expect(1, 8296, '\P{Is_Bc=rli}', "");
    Expect(0, 8296, '\P{^Is_Bc=rli}', "");
    Expect(1, 8295, '\p{Is_Bc= -RLI}', "");
    Expect(0, 8295, '\p{^Is_Bc= -RLI}', "");
    Expect(0, 8295, '\P{Is_Bc= -RLI}', "");
    Expect(1, 8295, '\P{^Is_Bc= -RLI}', "");
    Expect(0, 8296, '\p{Is_Bc= -RLI}', "");
    Expect(1, 8296, '\p{^Is_Bc= -RLI}', "");
    Expect(1, 8296, '\P{Is_Bc= -RLI}', "");
    Expect(0, 8296, '\P{^Is_Bc= -RLI}', "");
    Error('\p{Bidi_Class:	 	right_To_Left_OVERRIDE:=}');
    Error('\P{Bidi_Class:	 	right_To_Left_OVERRIDE:=}');
    Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Bidi_Class=__Right_To_left_Override}', "");
    Expect(0, 8238, '\p{^Bidi_Class=__Right_To_left_Override}', "");
    Expect(0, 8238, '\P{Bidi_Class=__Right_To_left_Override}', "");
    Expect(1, 8238, '\P{^Bidi_Class=__Right_To_left_Override}', "");
    Expect(0, 8239, '\p{Bidi_Class=__Right_To_left_Override}', "");
    Expect(1, 8239, '\p{^Bidi_Class=__Right_To_left_Override}', "");
    Expect(1, 8239, '\P{Bidi_Class=__Right_To_left_Override}', "");
    Expect(0, 8239, '\P{^Bidi_Class=__Right_To_left_Override}', "");
    Error('\p{Bc=-/a/RLO}');
    Error('\P{Bc=-/a/RLO}');
    Expect(1, 8238, '\p{Bc=rlo}', "");
    Expect(0, 8238, '\p{^Bc=rlo}', "");
    Expect(0, 8238, '\P{Bc=rlo}', "");
    Expect(1, 8238, '\P{^Bc=rlo}', "");
    Expect(0, 8239, '\p{Bc=rlo}', "");
    Expect(1, 8239, '\p{^Bc=rlo}', "");
    Expect(1, 8239, '\P{Bc=rlo}', "");
    Expect(0, 8239, '\P{^Bc=rlo}', "");
    Expect(1, 8238, '\p{Bc= RLO}', "");
    Expect(0, 8238, '\p{^Bc= RLO}', "");
    Expect(0, 8238, '\P{Bc= RLO}', "");
    Expect(1, 8238, '\P{^Bc= RLO}', "");
    Expect(0, 8239, '\p{Bc= RLO}', "");
    Expect(1, 8239, '\p{^Bc= RLO}', "");
    Expect(1, 8239, '\P{Bc= RLO}', "");
    Expect(0, 8239, '\P{^Bc= RLO}', "");
    Error('\p{Is_Bidi_Class=:=_ Right_To_Left_override}');
    Error('\P{Is_Bidi_Class=:=_ Right_To_Left_override}');
    Expect(1, 8238, '\p{Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class:   righttoleftoverride}', "");
    Expect(1, 8238, '\p{Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class= 	Right_To_left_override}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class= 	Right_To_left_override}', "");
    Error('\p{Is_Bc=	:=RLO}');
    Error('\P{Is_Bc=	:=RLO}');
    Expect(1, 8238, '\p{Is_Bc=rlo}', "");
    Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
    Expect(0, 8238, '\P{Is_Bc=rlo}', "");
    Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
    Expect(0, 8239, '\p{Is_Bc=rlo}', "");
    Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
    Expect(1, 8239, '\P{Is_Bc=rlo}', "");
    Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
    Expect(1, 8238, '\p{Is_Bc=-RLO}', "");
    Expect(0, 8238, '\p{^Is_Bc=-RLO}', "");
    Expect(0, 8238, '\P{Is_Bc=-RLO}', "");
    Expect(1, 8238, '\P{^Is_Bc=-RLO}', "");
    Expect(0, 8239, '\p{Is_Bc=-RLO}', "");
    Expect(1, 8239, '\p{^Is_Bc=-RLO}', "");
    Expect(1, 8239, '\P{Is_Bc=-RLO}', "");
    Expect(0, 8239, '\P{^Is_Bc=-RLO}', "");
    Error('\p{Bidi_Class=	_segment_SEPARATOR/a/}');
    Error('\P{Bidi_Class=	_segment_SEPARATOR/a/}');
    Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Bidi_Class=	 Segment_Separator}', "");
    Expect(0, 31, '\p{^Bidi_Class=	 Segment_Separator}', "");
    Expect(0, 31, '\P{Bidi_Class=	 Segment_Separator}', "");
    Expect(1, 31, '\P{^Bidi_Class=	 Segment_Separator}', "");
    Expect(0, 32, '\p{Bidi_Class=	 Segment_Separator}', "");
    Expect(1, 32, '\p{^Bidi_Class=	 Segment_Separator}', "");
    Expect(1, 32, '\P{Bidi_Class=	 Segment_Separator}', "");
    Expect(0, 32, '\P{^Bidi_Class=	 Segment_Separator}', "");
    Error('\p{Bc=:=_-S}');
    Error('\P{Bc=:=_-S}');
    Expect(1, 31, '\p{Bc=s}', "");
    Expect(0, 31, '\p{^Bc=s}', "");
    Expect(0, 31, '\P{Bc=s}', "");
    Expect(1, 31, '\P{^Bc=s}', "");
    Expect(0, 32, '\p{Bc=s}', "");
    Expect(1, 32, '\p{^Bc=s}', "");
    Expect(1, 32, '\P{Bc=s}', "");
    Expect(0, 32, '\P{^Bc=s}', "");
    Expect(1, 31, '\p{Bc=	S}', "");
    Expect(0, 31, '\p{^Bc=	S}', "");
    Expect(0, 31, '\P{Bc=	S}', "");
    Expect(1, 31, '\P{^Bc=	S}', "");
    Expect(0, 32, '\p{Bc=	S}', "");
    Expect(1, 32, '\p{^Bc=	S}', "");
    Expect(1, 32, '\P{Bc=	S}', "");
    Expect(0, 32, '\P{^Bc=	S}', "");
    Error('\p{Is_Bidi_Class= /a/Segment_Separator}');
    Error('\P{Is_Bidi_Class= /a/Segment_Separator}');
    Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(0, 31, '\P{Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(0, 32, '\p{Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(1, 32, '\P{Is_Bidi_Class= Segment_SEPARATOR}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class= Segment_SEPARATOR}', "");
    Error('\p{Is_Bc:  s/a/}');
    Error('\P{Is_Bc:  s/a/}');
    Expect(1, 31, '\p{Is_Bc:s}', "");
    Expect(0, 31, '\p{^Is_Bc:s}', "");
    Expect(0, 31, '\P{Is_Bc:s}', "");
    Expect(1, 31, '\P{^Is_Bc:s}', "");
    Expect(0, 32, '\p{Is_Bc:s}', "");
    Expect(1, 32, '\p{^Is_Bc:s}', "");
    Expect(1, 32, '\P{Is_Bc:s}', "");
    Expect(0, 32, '\P{^Is_Bc:s}', "");
    Expect(1, 31, '\p{Is_Bc=	S}', "");
    Expect(0, 31, '\p{^Is_Bc=	S}', "");
    Expect(0, 31, '\P{Is_Bc=	S}', "");
    Expect(1, 31, '\P{^Is_Bc=	S}', "");
    Expect(0, 32, '\p{Is_Bc=	S}', "");
    Expect(1, 32, '\p{^Is_Bc=	S}', "");
    Expect(1, 32, '\P{Is_Bc=	S}', "");
    Expect(0, 32, '\P{^Is_Bc=	S}', "");
    Error('\p{Bidi_Class=:=white_space}');
    Error('\P{Bidi_Class=:=white_space}');
    Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Bidi_Class: __White_space}', "");
    Expect(0, 12288, '\p{^Bidi_Class: __White_space}', "");
    Expect(0, 12288, '\P{Bidi_Class: __White_space}', "");
    Expect(1, 12288, '\P{^Bidi_Class: __White_space}', "");
    Expect(0, 12289, '\p{Bidi_Class: __White_space}', "");
    Expect(1, 12289, '\p{^Bidi_Class: __White_space}', "");
    Expect(1, 12289, '\P{Bidi_Class: __White_space}', "");
    Expect(0, 12289, '\P{^Bidi_Class: __White_space}', "");
    Error('\p{Bc=	ws/a/}');
    Error('\P{Bc=	ws/a/}');
    Expect(1, 12288, '\p{Bc=ws}', "");
    Expect(0, 12288, '\p{^Bc=ws}', "");
    Expect(0, 12288, '\P{Bc=ws}', "");
    Expect(1, 12288, '\P{^Bc=ws}', "");
    Expect(0, 12289, '\p{Bc=ws}', "");
    Expect(1, 12289, '\p{^Bc=ws}', "");
    Expect(1, 12289, '\P{Bc=ws}', "");
    Expect(0, 12289, '\P{^Bc=ws}', "");
    Expect(1, 12288, '\p{Bc= 	WS}', "");
    Expect(0, 12288, '\p{^Bc= 	WS}', "");
    Expect(0, 12288, '\P{Bc= 	WS}', "");
    Expect(1, 12288, '\P{^Bc= 	WS}', "");
    Expect(0, 12289, '\p{Bc= 	WS}', "");
    Expect(1, 12289, '\p{^Bc= 	WS}', "");
    Expect(1, 12289, '\P{Bc= 	WS}', "");
    Expect(0, 12289, '\P{^Bc= 	WS}', "");
    Error('\p{Is_Bidi_Class:		/a/white_Space}');
    Error('\P{Is_Bidi_Class:		/a/white_Space}');
    Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Is_Bidi_Class=	white_space}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=	white_space}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=	white_space}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=	white_space}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=	white_space}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=	white_space}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=	white_space}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=	white_space}', "");
    Error('\p{Is_Bc=_/a/ws}');
    Error('\P{Is_Bc=_/a/ws}');
    Expect(1, 12288, '\p{Is_Bc=ws}', "");
    Expect(0, 12288, '\p{^Is_Bc=ws}', "");
    Expect(0, 12288, '\P{Is_Bc=ws}', "");
    Expect(1, 12288, '\P{^Is_Bc=ws}', "");
    Expect(0, 12289, '\p{Is_Bc=ws}', "");
    Expect(1, 12289, '\p{^Is_Bc=ws}', "");
    Expect(1, 12289, '\P{Is_Bc=ws}', "");
    Expect(0, 12289, '\P{^Is_Bc=ws}', "");
    Expect(1, 12288, '\p{Is_Bc=	-WS}', "");
    Expect(0, 12288, '\p{^Is_Bc=	-WS}', "");
    Expect(0, 12288, '\P{Is_Bc=	-WS}', "");
    Expect(1, 12288, '\P{^Is_Bc=	-WS}', "");
    Expect(0, 12289, '\p{Is_Bc=	-WS}', "");
    Expect(1, 12289, '\p{^Is_Bc=	-WS}', "");
    Expect(1, 12289, '\P{Is_Bc=	-WS}', "");
    Expect(0, 12289, '\P{^Is_Bc=	-WS}', "");
    Error('\p{Bidi_Control=__No/a/}');
    Error('\P{Bidi_Control=__No/a/}');
    Expect(1, 8298, '\p{Bidi_Control:   no}', "");
    Expect(0, 8298, '\p{^Bidi_Control:   no}', "");
    Expect(0, 8298, '\P{Bidi_Control:   no}', "");
    Expect(1, 8298, '\P{^Bidi_Control:   no}', "");
    Expect(0, 8297, '\p{Bidi_Control:   no}', "");
    Expect(1, 8297, '\p{^Bidi_Control:   no}', "");
    Expect(1, 8297, '\P{Bidi_Control:   no}', "");
    Expect(0, 8297, '\P{^Bidi_Control:   no}', "");
    Expect(1, 8298, '\p{Bidi_Control=- NO}', "");
    Expect(0, 8298, '\p{^Bidi_Control=- NO}', "");
    Expect(0, 8298, '\P{Bidi_Control=- NO}', "");
    Expect(1, 8298, '\P{^Bidi_Control=- NO}', "");
    Expect(0, 8297, '\p{Bidi_Control=- NO}', "");
    Expect(1, 8297, '\p{^Bidi_Control=- NO}', "");
    Expect(1, 8297, '\P{Bidi_Control=- NO}', "");
    Expect(0, 8297, '\P{^Bidi_Control=- NO}', "");
    Error('\p{Bidi_C=	/a/N}');
    Error('\P{Bidi_C=	/a/N}');
    Expect(1, 8298, '\p{Bidi_C=n}', "");
    Expect(0, 8298, '\p{^Bidi_C=n}', "");
    Expect(0, 8298, '\P{Bidi_C=n}', "");
    Expect(1, 8298, '\P{^Bidi_C=n}', "");
    Expect(0, 8297, '\p{Bidi_C=n}', "");
    Expect(1, 8297, '\p{^Bidi_C=n}', "");
    Expect(1, 8297, '\P{Bidi_C=n}', "");
    Expect(0, 8297, '\P{^Bidi_C=n}', "");
    Expect(1, 8298, '\p{Bidi_C:    N}', "");
    Expect(0, 8298, '\p{^Bidi_C:    N}', "");
    Expect(0, 8298, '\P{Bidi_C:    N}', "");
    Expect(1, 8298, '\P{^Bidi_C:    N}', "");
    Expect(0, 8297, '\p{Bidi_C:    N}', "");
    Expect(1, 8297, '\p{^Bidi_C:    N}', "");
    Expect(1, 8297, '\P{Bidi_C:    N}', "");
    Expect(0, 8297, '\P{^Bidi_C:    N}', "");
    Error('\p{Is_Bidi_Control=/a/	_F}');
    Error('\P{Is_Bidi_Control=/a/	_F}');
    Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\p{Is_Bidi_Control=-F}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=-F}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=-F}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=-F}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=-F}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=-F}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=-F}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=-F}', "");
    Error('\p{Is_Bidi_C=:=_-FALSE}');
    Error('\P{Is_Bidi_C=:=_-FALSE}');
    Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
    Expect(1, 8298, '\p{Is_Bidi_C:	_ false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C:	_ false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C:	_ false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C:	_ false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C:	_ false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C:	_ false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C:	_ false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C:	_ false}', "");
    Error('\p{Bidi_Control=/a/_Yes}');
    Error('\P{Bidi_Control=/a/_Yes}');
    Expect(1, 8297, '\p{Bidi_Control=yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
    Expect(1, 8297, '\p{Bidi_Control=-YES}', "");
    Expect(0, 8297, '\p{^Bidi_Control=-YES}', "");
    Expect(0, 8297, '\P{Bidi_Control=-YES}', "");
    Expect(1, 8297, '\P{^Bidi_Control=-YES}', "");
    Expect(0, 8298, '\p{Bidi_Control=-YES}', "");
    Expect(1, 8298, '\p{^Bidi_Control=-YES}', "");
    Expect(1, 8298, '\P{Bidi_Control=-YES}', "");
    Expect(0, 8298, '\P{^Bidi_Control=-YES}', "");
    Error('\p{Bidi_C=:=-_Y}');
    Error('\P{Bidi_C=:=-_Y}');
    Expect(1, 8297, '\p{Bidi_C=y}', "");
    Expect(0, 8297, '\p{^Bidi_C=y}', "");
    Expect(0, 8297, '\P{Bidi_C=y}', "");
    Expect(1, 8297, '\P{^Bidi_C=y}', "");
    Expect(0, 8298, '\p{Bidi_C=y}', "");
    Expect(1, 8298, '\p{^Bidi_C=y}', "");
    Expect(1, 8298, '\P{Bidi_C=y}', "");
    Expect(0, 8298, '\P{^Bidi_C=y}', "");
    Expect(1, 8297, '\p{Bidi_C=__Y}', "");
    Expect(0, 8297, '\p{^Bidi_C=__Y}', "");
    Expect(0, 8297, '\P{Bidi_C=__Y}', "");
    Expect(1, 8297, '\P{^Bidi_C=__Y}', "");
    Expect(0, 8298, '\p{Bidi_C=__Y}', "");
    Expect(1, 8298, '\p{^Bidi_C=__Y}', "");
    Expect(1, 8298, '\P{Bidi_C=__Y}', "");
    Expect(0, 8298, '\P{^Bidi_C=__Y}', "");
    Error('\p{Is_Bidi_Control= :=T}');
    Error('\P{Is_Bidi_Control= :=T}');
    Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\p{Is_Bidi_Control=	 t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=	 t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=	 t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=	 t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=	 t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=	 t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=	 t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=	 t}', "");
    Error('\p{Is_Bidi_C=:=	True}');
    Error('\P{Is_Bidi_C=:=	True}');
    Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
    Expect(1, 8297, '\p{Is_Bidi_C=-True}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=-True}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=-True}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=-True}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=-True}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=-True}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=-True}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=-True}', "");
    Error('\p{Bidi_Mirrored:	 No/a/}');
    Error('\P{Bidi_Mirrored:	 No/a/}');
    Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\p{Bidi_Mirrored=_-NO}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=_-NO}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=_-NO}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=_-NO}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=_-NO}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=_-NO}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=_-NO}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=_-NO}', "");
    Error('\p{Bidi_M=:=  N}');
    Error('\P{Bidi_M=:=  N}');
    Expect(1, 120772, '\p{Bidi_M=n}', "");
    Expect(0, 120772, '\p{^Bidi_M=n}', "");
    Expect(0, 120772, '\P{Bidi_M=n}', "");
    Expect(1, 120772, '\P{^Bidi_M=n}', "");
    Expect(0, 120771, '\p{Bidi_M=n}', "");
    Expect(1, 120771, '\p{^Bidi_M=n}', "");
    Expect(1, 120771, '\P{Bidi_M=n}', "");
    Expect(0, 120771, '\P{^Bidi_M=n}', "");
    Expect(1, 120772, '\p{Bidi_M=--N}', "");
    Expect(0, 120772, '\p{^Bidi_M=--N}', "");
    Expect(0, 120772, '\P{Bidi_M=--N}', "");
    Expect(1, 120772, '\P{^Bidi_M=--N}', "");
    Expect(0, 120771, '\p{Bidi_M=--N}', "");
    Expect(1, 120771, '\p{^Bidi_M=--N}', "");
    Expect(1, 120771, '\P{Bidi_M=--N}', "");
    Expect(0, 120771, '\P{^Bidi_M=--N}', "");
    Error('\p{Is_Bidi_Mirrored=:= -F}');
    Error('\P{Is_Bidi_Mirrored=:= -F}');
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=F}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=F}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=F}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=F}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=F}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=F}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=F}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=F}', "");
    Error('\p{Is_Bidi_M= /a/FALSE}');
    Error('\P{Is_Bidi_M= /a/FALSE}');
    Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
    Expect(1, 120772, '\p{Is_Bidi_M=_False}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=_False}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=_False}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=_False}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=_False}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=_False}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=_False}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=_False}', "");
    Error('\p{Bidi_Mirrored=-_Yes:=}');
    Error('\P{Bidi_Mirrored=-_Yes:=}');
    Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\p{Bidi_Mirrored= YES}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored= YES}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored= YES}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored= YES}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored= YES}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored= YES}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored= YES}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored= YES}', "");
    Error('\p{Bidi_M=:= _Y}');
    Error('\P{Bidi_M=:= _Y}');
    Expect(1, 120771, '\p{Bidi_M:   y}', "");
    Expect(0, 120771, '\p{^Bidi_M:   y}', "");
    Expect(0, 120771, '\P{Bidi_M:   y}', "");
    Expect(1, 120771, '\P{^Bidi_M:   y}', "");
    Expect(0, 120772, '\p{Bidi_M:   y}', "");
    Expect(1, 120772, '\p{^Bidi_M:   y}', "");
    Expect(1, 120772, '\P{Bidi_M:   y}', "");
    Expect(0, 120772, '\P{^Bidi_M:   y}', "");
    Expect(1, 120771, '\p{Bidi_M=	-Y}', "");
    Expect(0, 120771, '\p{^Bidi_M=	-Y}', "");
    Expect(0, 120771, '\P{Bidi_M=	-Y}', "");
    Expect(1, 120771, '\P{^Bidi_M=	-Y}', "");
    Expect(0, 120772, '\p{Bidi_M=	-Y}', "");
    Expect(1, 120772, '\p{^Bidi_M=	-Y}', "");
    Expect(1, 120772, '\P{Bidi_M=	-Y}', "");
    Expect(0, 120772, '\P{^Bidi_M=	-Y}', "");
    Error('\p{Is_Bidi_Mirrored=:=t}');
    Error('\P{Is_Bidi_Mirrored=:=t}');
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\p{Is_Bidi_Mirrored= T}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored= T}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored= T}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored= T}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored= T}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored= T}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored= T}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored= T}', "");
    Error('\p{Is_Bidi_M=	_TRUE:=}');
    Error('\P{Is_Bidi_M=	_TRUE:=}');
    Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
    Expect(1, 120771, '\p{Is_Bidi_M= -True}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M= -True}', "");
    Expect(0, 120771, '\P{Is_Bidi_M= -True}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M= -True}', "");
    Expect(0, 120772, '\p{Is_Bidi_M= -True}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M= -True}', "");
    Expect(1, 120772, '\P{Is_Bidi_M= -True}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M= -True}', "");
    Error('\p{block}');
    Error('\P{block}');
    Error('\p{blk}');
    Error('\P{blk}');
    Error('\p{Block=/a/--Adlam}');
    Error('\P{Block=/a/--Adlam}');
    Expect(1, 125279, '\p{Block=adlam}', "");
    Expect(0, 125279, '\p{^Block=adlam}', "");
    Expect(0, 125279, '\P{Block=adlam}', "");
    Expect(1, 125279, '\P{^Block=adlam}', "");
    Expect(0, 125280, '\p{Block=adlam}', "");
    Expect(1, 125280, '\p{^Block=adlam}', "");
    Expect(1, 125280, '\P{Block=adlam}', "");
    Expect(0, 125280, '\P{^Block=adlam}', "");
    Expect(1, 125279, '\p{Block=	_Adlam}', "");
    Expect(0, 125279, '\p{^Block=	_Adlam}', "");
    Expect(0, 125279, '\P{Block=	_Adlam}', "");
    Expect(1, 125279, '\P{^Block=	_Adlam}', "");
    Expect(0, 125280, '\p{Block=	_Adlam}', "");
    Expect(1, 125280, '\p{^Block=	_Adlam}', "");
    Expect(1, 125280, '\P{Block=	_Adlam}', "");
    Expect(0, 125280, '\P{^Block=	_Adlam}', "");
    Error('\p{Blk=:=Adlam}');
    Error('\P{Blk=:=Adlam}');
    Expect(1, 125279, '\p{Blk=adlam}', "");
    Expect(0, 125279, '\p{^Blk=adlam}', "");
    Expect(0, 125279, '\P{Blk=adlam}', "");
    Expect(1, 125279, '\P{^Blk=adlam}', "");
    Expect(0, 125280, '\p{Blk=adlam}', "");
    Expect(1, 125280, '\p{^Blk=adlam}', "");
    Expect(1, 125280, '\P{Blk=adlam}', "");
    Expect(0, 125280, '\P{^Blk=adlam}', "");
    Expect(1, 125279, '\p{Blk=_ADLAM}', "");
    Expect(0, 125279, '\p{^Blk=_ADLAM}', "");
    Expect(0, 125279, '\P{Blk=_ADLAM}', "");
    Expect(1, 125279, '\P{^Blk=_ADLAM}', "");
    Expect(0, 125280, '\p{Blk=_ADLAM}', "");
    Expect(1, 125280, '\p{^Blk=_ADLAM}', "");
    Expect(1, 125280, '\P{Blk=_ADLAM}', "");
    Expect(0, 125280, '\P{^Blk=_ADLAM}', "");
    Error('\p{Is_Block=/a/_ Adlam}');
    Error('\P{Is_Block=/a/_ Adlam}');
    Expect(1, 125279, '\p{Is_Block=adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=adlam}', "");
    Expect(0, 125279, '\P{Is_Block=adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=adlam}', "");
    Expect(0, 125280, '\p{Is_Block=adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=adlam}', "");
    Expect(1, 125280, '\P{Is_Block=adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=adlam}', "");
    Expect(1, 125279, '\p{Is_Block=--ADLAM}', "");
    Expect(0, 125279, '\p{^Is_Block=--ADLAM}', "");
    Expect(0, 125279, '\P{Is_Block=--ADLAM}', "");
    Expect(1, 125279, '\P{^Is_Block=--ADLAM}', "");
    Expect(0, 125280, '\p{Is_Block=--ADLAM}', "");
    Expect(1, 125280, '\p{^Is_Block=--ADLAM}', "");
    Expect(1, 125280, '\P{Is_Block=--ADLAM}', "");
    Expect(0, 125280, '\P{^Is_Block=--ADLAM}', "");
    Error('\p{Is_Blk=:=-	ADLAM}');
    Error('\P{Is_Blk=:=-	ADLAM}');
    Expect(1, 125279, '\p{Is_Blk=adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=adlam}', "");
    Expect(1, 125279, '\p{Is_Blk=- Adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=- Adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=- Adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=- Adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=- Adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=- Adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=- Adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=- Adlam}', "");
    Error('\p{Block= -AEGEAN_NUMBERS:=}');
    Error('\P{Block= -AEGEAN_NUMBERS:=}');
    Expect(1, 65855, '\p{Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Block= Aegean_NUMBERS}', "");
    Expect(0, 65855, '\p{^Block= Aegean_NUMBERS}', "");
    Expect(0, 65855, '\P{Block= Aegean_NUMBERS}', "");
    Expect(1, 65855, '\P{^Block= Aegean_NUMBERS}', "");
    Expect(0, 65856, '\p{Block= Aegean_NUMBERS}', "");
    Expect(1, 65856, '\p{^Block= Aegean_NUMBERS}', "");
    Expect(1, 65856, '\P{Block= Aegean_NUMBERS}', "");
    Expect(0, 65856, '\P{^Block= Aegean_NUMBERS}', "");
    Error('\p{Blk=	_Aegean_Numbers/a/}');
    Error('\P{Blk=	_Aegean_Numbers/a/}');
    Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Blk=_AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\p{^Blk=_AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\P{Blk=_AEGEAN_NUMBERS}', "");
    Expect(1, 65855, '\P{^Blk=_AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\p{Blk=_AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\p{^Blk=_AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\P{Blk=_AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\P{^Blk=_AEGEAN_NUMBERS}', "");
    Error('\p{Is_Block=-aegean_Numbers:=}');
    Error('\P{Is_Block=-aegean_Numbers:=}');
    Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Block=_	Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Is_Block=_	Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Is_Block=_	Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Is_Block=_	Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Is_Block=_	Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Is_Block=_	Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Is_Block=_	Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Is_Block=_	Aegean_Numbers}', "");
    Error('\p{Is_Blk=		aegean_Numbers:=}');
    Error('\P{Is_Blk=		aegean_Numbers:=}');
    Expect(1, 65855, '\p{Is_Blk:   aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Blk:   aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Blk:   aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Blk:   aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Blk:   aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Blk:   aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Blk:   aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Blk:   aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Blk= Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Is_Blk= Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Is_Blk= Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Is_Blk= Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Is_Blk= Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Is_Blk= Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Is_Blk= Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Is_Blk= Aegean_Numbers}', "");
    Error('\p{Block=-/a/AHOM}');
    Error('\P{Block=-/a/AHOM}');
    Expect(1, 71487, '\p{Block=ahom}', "");
    Expect(0, 71487, '\p{^Block=ahom}', "");
    Expect(0, 71487, '\P{Block=ahom}', "");
    Expect(1, 71487, '\P{^Block=ahom}', "");
    Expect(0, 71488, '\p{Block=ahom}', "");
    Expect(1, 71488, '\p{^Block=ahom}', "");
    Expect(1, 71488, '\P{Block=ahom}', "");
    Expect(0, 71488, '\P{^Block=ahom}', "");
    Expect(1, 71487, '\p{Block:		-Ahom}', "");
    Expect(0, 71487, '\p{^Block:		-Ahom}', "");
    Expect(0, 71487, '\P{Block:		-Ahom}', "");
    Expect(1, 71487, '\P{^Block:		-Ahom}', "");
    Expect(0, 71488, '\p{Block:		-Ahom}', "");
    Expect(1, 71488, '\p{^Block:		-Ahom}', "");
    Expect(1, 71488, '\P{Block:		-Ahom}', "");
    Expect(0, 71488, '\P{^Block:		-Ahom}', "");
    Error('\p{Blk= :=ahom}');
    Error('\P{Blk= :=ahom}');
    Expect(1, 71487, '\p{Blk=ahom}', "");
    Expect(0, 71487, '\p{^Blk=ahom}', "");
    Expect(0, 71487, '\P{Blk=ahom}', "");
    Expect(1, 71487, '\P{^Blk=ahom}', "");
    Expect(0, 71488, '\p{Blk=ahom}', "");
    Expect(1, 71488, '\p{^Blk=ahom}', "");
    Expect(1, 71488, '\P{Blk=ahom}', "");
    Expect(0, 71488, '\P{^Blk=ahom}', "");
    Expect(1, 71487, '\p{Blk=	_AHOM}', "");
    Expect(0, 71487, '\p{^Blk=	_AHOM}', "");
    Expect(0, 71487, '\P{Blk=	_AHOM}', "");
    Expect(1, 71487, '\P{^Blk=	_AHOM}', "");
    Expect(0, 71488, '\p{Blk=	_AHOM}', "");
    Expect(1, 71488, '\p{^Blk=	_AHOM}', "");
    Expect(1, 71488, '\P{Blk=	_AHOM}', "");
    Expect(0, 71488, '\P{^Blk=	_AHOM}', "");
    Error('\p{Is_Block:   -	ahom/a/}');
    Error('\P{Is_Block:   -	ahom/a/}');
    Expect(1, 71487, '\p{Is_Block=ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=ahom}', "");
    Expect(0, 71487, '\P{Is_Block=ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=ahom}', "");
    Expect(0, 71488, '\p{Is_Block=ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=ahom}', "");
    Expect(1, 71488, '\P{Is_Block=ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=ahom}', "");
    Expect(1, 71487, '\p{Is_Block=	ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=	ahom}', "");
    Expect(0, 71487, '\P{Is_Block=	ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=	ahom}', "");
    Expect(0, 71488, '\p{Is_Block=	ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=	ahom}', "");
    Expect(1, 71488, '\P{Is_Block=	ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=	ahom}', "");
    Error('\p{Is_Blk= _Ahom:=}');
    Error('\P{Is_Blk= _Ahom:=}');
    Expect(1, 71487, '\p{Is_Blk=ahom}', "");
    Expect(0, 71487, '\p{^Is_Blk=ahom}', "");
    Expect(0, 71487, '\P{Is_Blk=ahom}', "");
    Expect(1, 71487, '\P{^Is_Blk=ahom}', "");
    Expect(0, 71488, '\p{Is_Blk=ahom}', "");
    Expect(1, 71488, '\p{^Is_Blk=ahom}', "");
    Expect(1, 71488, '\P{Is_Blk=ahom}', "");
    Expect(0, 71488, '\P{^Is_Blk=ahom}', "");
    Expect(1, 71487, '\p{Is_Blk=_-Ahom}', "");
    Expect(0, 71487, '\p{^Is_Blk=_-Ahom}', "");
    Expect(0, 71487, '\P{Is_Blk=_-Ahom}', "");
    Expect(1, 71487, '\P{^Is_Blk=_-Ahom}', "");
    Expect(0, 71488, '\p{Is_Blk=_-Ahom}', "");
    Expect(1, 71488, '\p{^Is_Blk=_-Ahom}', "");
    Expect(1, 71488, '\P{Is_Blk=_-Ahom}', "");
    Expect(0, 71488, '\P{^Is_Blk=_-Ahom}', "");
    Error('\p{Block=/a/ -ALCHEMICAL_symbols}');
    Error('\P{Block=/a/ -ALCHEMICAL_symbols}');
    Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Block=		alchemical_Symbols}', "");
    Expect(0, 128895, '\p{^Block=		alchemical_Symbols}', "");
    Expect(0, 128895, '\P{Block=		alchemical_Symbols}', "");
    Expect(1, 128895, '\P{^Block=		alchemical_Symbols}', "");
    Expect(0, 128896, '\p{Block=		alchemical_Symbols}', "");
    Expect(1, 128896, '\p{^Block=		alchemical_Symbols}', "");
    Expect(1, 128896, '\P{Block=		alchemical_Symbols}', "");
    Expect(0, 128896, '\P{^Block=		alchemical_Symbols}', "");
    Error('\p{Blk=:=__alchemical}');
    Error('\P{Blk=:=__alchemical}');
    Expect(1, 128895, '\p{Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Blk=alchemical}', "");
    Expect(0, 128895, '\P{Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Blk=alchemical}', "");
    Expect(0, 128896, '\p{Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Blk=alchemical}', "");
    Expect(1, 128896, '\P{Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Blk=alchemical}', "");
    Expect(1, 128895, '\p{Blk= Alchemical}', "");
    Expect(0, 128895, '\p{^Blk= Alchemical}', "");
    Expect(0, 128895, '\P{Blk= Alchemical}', "");
    Expect(1, 128895, '\P{^Blk= Alchemical}', "");
    Expect(0, 128896, '\p{Blk= Alchemical}', "");
    Expect(1, 128896, '\p{^Blk= Alchemical}', "");
    Expect(1, 128896, '\P{Blk= Alchemical}', "");
    Expect(0, 128896, '\P{^Blk= Alchemical}', "");
    Error('\p{Is_Block=_:=alchemical_Symbols}');
    Error('\P{Is_Block=_:=alchemical_Symbols}');
    Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Is_Block= _alchemical_SYMBOLS}', "");
    Expect(0, 128895, '\p{^Is_Block= _alchemical_SYMBOLS}', "");
    Expect(0, 128895, '\P{Is_Block= _alchemical_SYMBOLS}', "");
    Expect(1, 128895, '\P{^Is_Block= _alchemical_SYMBOLS}', "");
    Expect(0, 128896, '\p{Is_Block= _alchemical_SYMBOLS}', "");
    Expect(1, 128896, '\p{^Is_Block= _alchemical_SYMBOLS}', "");
    Expect(1, 128896, '\P{Is_Block= _alchemical_SYMBOLS}', "");
    Expect(0, 128896, '\P{^Is_Block= _alchemical_SYMBOLS}', "");
    Error('\p{Is_Blk:   /a/--Alchemical}');
    Error('\P{Is_Blk:   /a/--Alchemical}');
    Expect(1, 128895, '\p{Is_Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=alchemical}', "");
    Expect(1, 128895, '\p{Is_Blk= Alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk= Alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk= Alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk= Alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk= Alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk= Alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk= Alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk= Alchemical}', "");
    Error('\p{Block=:=Alphabetic_Presentation_forms}');
    Error('\P{Block=:=Alphabetic_Presentation_forms}');
    Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Block=-	Alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\p{^Block=-	Alphabetic_Presentation_forms}', "");
    Expect(0, 64335, '\P{Block=-	Alphabetic_Presentation_forms}', "");
    Expect(1, 64335, '\P{^Block=-	Alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\p{Block=-	Alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\p{^Block=-	Alphabetic_Presentation_forms}', "");
    Expect(1, 64336, '\P{Block=-	Alphabetic_Presentation_forms}', "");
    Expect(0, 64336, '\P{^Block=-	Alphabetic_Presentation_forms}', "");
    Error('\p{Blk=:=-ALPHABETIC_pf}');
    Error('\P{Blk=:=-ALPHABETIC_pf}');
    Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Blk=_alphabetic_pf}', "");
    Expect(0, 64335, '\p{^Blk=_alphabetic_pf}', "");
    Expect(0, 64335, '\P{Blk=_alphabetic_pf}', "");
    Expect(1, 64335, '\P{^Blk=_alphabetic_pf}', "");
    Expect(0, 64336, '\p{Blk=_alphabetic_pf}', "");
    Expect(1, 64336, '\p{^Blk=_alphabetic_pf}', "");
    Expect(1, 64336, '\P{Blk=_alphabetic_pf}', "");
    Expect(0, 64336, '\P{^Blk=_alphabetic_pf}', "");
    Error('\p{Is_Block= _alphabetic_Presentation_forms:=}');
    Error('\P{Is_Block= _alphabetic_Presentation_forms:=}');
    Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(0, 64335, '\p{^Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(0, 64335, '\P{Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(1, 64335, '\P{^Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(0, 64336, '\p{Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(1, 64336, '\p{^Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(1, 64336, '\P{Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Expect(0, 64336, '\P{^Is_Block=-ALPHABETIC_presentation_Forms}', "");
    Error('\p{Is_Blk=	:=Alphabetic_pf}');
    Error('\P{Is_Blk=	:=Alphabetic_pf}');
    Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Is_Blk= Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Is_Blk= Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Is_Blk= Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Is_Blk= Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Is_Blk= Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Is_Blk= Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Is_Blk= Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Is_Blk= Alphabetic_PF}', "");
    Error('\p{Block=Anatolian_Hieroglyphs/a/}');
    Error('\P{Block=Anatolian_Hieroglyphs/a/}');
    Expect(1, 83583, '\p{Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Block=  Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=  Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Block=  Anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=  Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Block=  Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=  Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Block=  Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=  Anatolian_Hieroglyphs}', "");
    Error('\p{Blk=/a/	Anatolian_Hieroglyphs}');
    Error('\P{Blk=/a/	Anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=-ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=-ANATOLIAN_hieroglyphs}', "");
    Error('\p{Is_Block=	/a/Anatolian_HIEROGLYPHS}');
    Error('\P{Is_Block=	/a/Anatolian_HIEROGLYPHS}');
    Expect(1, 83583, '\p{Is_Block:anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block:anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block:anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block:anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block:anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block:anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block:anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block:anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(0, 83583, '\p{^Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(0, 83583, '\P{Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(1, 83583, '\P{^Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(0, 83584, '\p{Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(1, 83584, '\p{^Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(1, 83584, '\P{Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Expect(0, 83584, '\P{^Is_Block:_	anatolian_HIEROGLYPHS}', "");
    Error('\p{Is_Blk=	/a/Anatolian_HIEROGLYPHS}');
    Error('\P{Is_Blk=	/a/Anatolian_HIEROGLYPHS}');
    Expect(1, 83583, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=-Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=-Anatolian_hieroglyphs}', "");
    Error('\p{Block=:=-	ANCIENT_GREEK_Musical_NOTATION}');
    Error('\P{Block=:=-	ANCIENT_GREEK_Musical_NOTATION}');
    Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Block= Ancient_greek_musical_NOTATION}', "");
    Expect(0, 119375, '\p{^Block= Ancient_greek_musical_NOTATION}', "");
    Expect(0, 119375, '\P{Block= Ancient_greek_musical_NOTATION}', "");
    Expect(1, 119375, '\P{^Block= Ancient_greek_musical_NOTATION}', "");
    Expect(0, 119376, '\p{Block= Ancient_greek_musical_NOTATION}', "");
    Expect(1, 119376, '\p{^Block= Ancient_greek_musical_NOTATION}', "");
    Expect(1, 119376, '\P{Block= Ancient_greek_musical_NOTATION}', "");
    Expect(0, 119376, '\P{^Block= Ancient_greek_musical_NOTATION}', "");
    Error('\p{Blk= -Ancient_greek_Music/a/}');
    Error('\P{Blk= -Ancient_greek_Music/a/}');
    Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(0, 119375, '\p{^Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(0, 119375, '\P{Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(1, 119375, '\P{^Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(0, 119376, '\p{Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(1, 119376, '\p{^Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(1, 119376, '\P{Blk=_ANCIENT_GREEK_MUSIC}', "");
    Expect(0, 119376, '\P{^Blk=_ANCIENT_GREEK_MUSIC}', "");
    Error('\p{Is_Block=/a/__ancient_GREEK_Musical_Notation}');
    Error('\P{Is_Block=/a/__ancient_GREEK_Musical_Notation}');
    Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(0, 119375, '\p{^Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(0, 119375, '\P{Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(1, 119375, '\P{^Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(0, 119376, '\p{Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(1, 119376, '\p{^Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(1, 119376, '\P{Is_Block= -ancient_Greek_Musical_Notation}', "");
    Expect(0, 119376, '\P{^Is_Block= -ancient_Greek_Musical_Notation}', "");
    Error('\p{Is_Blk=/a/	_ANCIENT_greek_Music}');
    Error('\P{Is_Blk=/a/	_ANCIENT_greek_Music}');
    Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Is_Blk=	Ancient_greek_Music}', "");
    Expect(0, 119375, '\p{^Is_Blk=	Ancient_greek_Music}', "");
    Expect(0, 119375, '\P{Is_Blk=	Ancient_greek_Music}', "");
    Expect(1, 119375, '\P{^Is_Blk=	Ancient_greek_Music}', "");
    Expect(0, 119376, '\p{Is_Blk=	Ancient_greek_Music}', "");
    Expect(1, 119376, '\p{^Is_Blk=	Ancient_greek_Music}', "");
    Expect(1, 119376, '\P{Is_Blk=	Ancient_greek_Music}', "");
    Expect(0, 119376, '\P{^Is_Blk=	Ancient_greek_Music}', "");
    Error('\p{Block=:=_Ancient_GREEK_Numbers}');
    Error('\P{Block=:=_Ancient_GREEK_Numbers}');
    Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Block=-Ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\p{^Block=-Ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\P{Block=-Ancient_Greek_Numbers}', "");
    Expect(1, 65935, '\P{^Block=-Ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\p{Block=-Ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\p{^Block=-Ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\P{Block=-Ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\P{^Block=-Ancient_Greek_Numbers}', "");
    Error('\p{Blk=- Ancient_Greek_numbers/a/}');
    Error('\P{Blk=- Ancient_Greek_numbers/a/}');
    Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Blk=	ancient_Greek_numbers}', "");
    Expect(0, 65935, '\p{^Blk=	ancient_Greek_numbers}', "");
    Expect(0, 65935, '\P{Blk=	ancient_Greek_numbers}', "");
    Expect(1, 65935, '\P{^Blk=	ancient_Greek_numbers}', "");
    Expect(0, 65936, '\p{Blk=	ancient_Greek_numbers}', "");
    Expect(1, 65936, '\p{^Blk=	ancient_Greek_numbers}', "");
    Expect(1, 65936, '\P{Blk=	ancient_Greek_numbers}', "");
    Expect(0, 65936, '\P{^Blk=	ancient_Greek_numbers}', "");
    Error('\p{Is_Block=-	Ancient_Greek_NUMBERS/a/}');
    Error('\P{Is_Block=-	Ancient_Greek_NUMBERS/a/}');
    Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(0, 65935, '\P{Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\p{Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(1, 65936, '\P{Is_Block=  Ancient_GREEK_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Block=  Ancient_GREEK_Numbers}', "");
    Error('\p{Is_Blk=:=--ancient_Greek_numbers}');
    Error('\P{Is_Blk=:=--ancient_Greek_numbers}');
    Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\P{Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\p{Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\P{Is_Blk=-ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=-ancient_Greek_Numbers}', "");
    Error('\p{Block= _ancient_symbols:=}');
    Error('\P{Block= _ancient_symbols:=}');
    Expect(1, 65999, '\p{Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Block=_	ANCIENT_symbols}', "");
    Expect(0, 65999, '\p{^Block=_	ANCIENT_symbols}', "");
    Expect(0, 65999, '\P{Block=_	ANCIENT_symbols}', "");
    Expect(1, 65999, '\P{^Block=_	ANCIENT_symbols}', "");
    Expect(0, 66000, '\p{Block=_	ANCIENT_symbols}', "");
    Expect(1, 66000, '\p{^Block=_	ANCIENT_symbols}', "");
    Expect(1, 66000, '\P{Block=_	ANCIENT_symbols}', "");
    Expect(0, 66000, '\P{^Block=_	ANCIENT_symbols}', "");
    Error('\p{Blk=:=-	ancient_SYMBOLS}');
    Error('\P{Blk=:=-	ancient_SYMBOLS}');
    Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Blk=	ANCIENT_symbols}', "");
    Expect(0, 65999, '\p{^Blk=	ANCIENT_symbols}', "");
    Expect(0, 65999, '\P{Blk=	ANCIENT_symbols}', "");
    Expect(1, 65999, '\P{^Blk=	ANCIENT_symbols}', "");
    Expect(0, 66000, '\p{Blk=	ANCIENT_symbols}', "");
    Expect(1, 66000, '\p{^Blk=	ANCIENT_symbols}', "");
    Expect(1, 66000, '\P{Blk=	ANCIENT_symbols}', "");
    Expect(0, 66000, '\P{^Blk=	ANCIENT_symbols}', "");
    Error('\p{Is_Block=/a/		ancient_symbols}');
    Error('\P{Is_Block=/a/		ancient_symbols}');
    Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Block:		ANCIENT_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Block:		ANCIENT_Symbols}', "");
    Expect(0, 65999, '\P{Is_Block:		ANCIENT_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Block:		ANCIENT_Symbols}', "");
    Expect(0, 66000, '\p{Is_Block:		ANCIENT_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Block:		ANCIENT_Symbols}', "");
    Expect(1, 66000, '\P{Is_Block:		ANCIENT_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Block:		ANCIENT_Symbols}', "");
    Error('\p{Is_Blk=	_ancient_Symbols/a/}');
    Error('\P{Is_Blk=	_ancient_Symbols/a/}');
    Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Blk=-Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=-Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Is_Blk=-Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=-Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Is_Blk=-Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=-Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Is_Blk=-Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=-Ancient_Symbols}', "");
    Error('\p{Block=:=-_ARABIC}');
    Error('\P{Block=:=-_ARABIC}');
    Expect(1, 1791, '\p{Block=arabic}', "");
    Expect(0, 1791, '\p{^Block=arabic}', "");
    Expect(0, 1791, '\P{Block=arabic}', "");
    Expect(1, 1791, '\P{^Block=arabic}', "");
    Expect(0, 1792, '\p{Block=arabic}', "");
    Expect(1, 1792, '\p{^Block=arabic}', "");
    Expect(1, 1792, '\P{Block=arabic}', "");
    Expect(0, 1792, '\P{^Block=arabic}', "");
    Expect(1, 1791, '\p{Block= _Arabic}', "");
    Expect(0, 1791, '\p{^Block= _Arabic}', "");
    Expect(0, 1791, '\P{Block= _Arabic}', "");
    Expect(1, 1791, '\P{^Block= _Arabic}', "");
    Expect(0, 1792, '\p{Block= _Arabic}', "");
    Expect(1, 1792, '\p{^Block= _Arabic}', "");
    Expect(1, 1792, '\P{Block= _Arabic}', "");
    Expect(0, 1792, '\P{^Block= _Arabic}', "");
    Error('\p{Blk=:=  Arabic}');
    Error('\P{Blk=:=  Arabic}');
    Expect(1, 1791, '\p{Blk=arabic}', "");
    Expect(0, 1791, '\p{^Blk=arabic}', "");
    Expect(0, 1791, '\P{Blk=arabic}', "");
    Expect(1, 1791, '\P{^Blk=arabic}', "");
    Expect(0, 1792, '\p{Blk=arabic}', "");
    Expect(1, 1792, '\p{^Blk=arabic}', "");
    Expect(1, 1792, '\P{Blk=arabic}', "");
    Expect(0, 1792, '\P{^Blk=arabic}', "");
    Expect(1, 1791, '\p{Blk=__arabic}', "");
    Expect(0, 1791, '\p{^Blk=__arabic}', "");
    Expect(0, 1791, '\P{Blk=__arabic}', "");
    Expect(1, 1791, '\P{^Blk=__arabic}', "");
    Expect(0, 1792, '\p{Blk=__arabic}', "");
    Expect(1, 1792, '\p{^Blk=__arabic}', "");
    Expect(1, 1792, '\P{Blk=__arabic}', "");
    Expect(0, 1792, '\P{^Blk=__arabic}', "");
    Error('\p{Is_Block=:=Arabic}');
    Error('\P{Is_Block=:=Arabic}');
    Expect(1, 1791, '\p{Is_Block=arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=arabic}', "");
    Expect(0, 1791, '\P{Is_Block=arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=arabic}', "");
    Expect(0, 1792, '\p{Is_Block=arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=arabic}', "");
    Expect(1, 1792, '\P{Is_Block=arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=arabic}', "");
    Expect(1, 1791, '\p{Is_Block=-_ARABIC}', "");
    Expect(0, 1791, '\p{^Is_Block=-_ARABIC}', "");
    Expect(0, 1791, '\P{Is_Block=-_ARABIC}', "");
    Expect(1, 1791, '\P{^Is_Block=-_ARABIC}', "");
    Expect(0, 1792, '\p{Is_Block=-_ARABIC}', "");
    Expect(1, 1792, '\p{^Is_Block=-_ARABIC}', "");
    Expect(1, 1792, '\P{Is_Block=-_ARABIC}', "");
    Expect(0, 1792, '\P{^Is_Block=-_ARABIC}', "");
    Error('\p{Is_Blk=	-Arabic/a/}');
    Error('\P{Is_Blk=	-Arabic/a/}');
    Expect(1, 1791, '\p{Is_Blk=arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
    Expect(1, 1791, '\p{Is_Blk:_Arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk:_Arabic}', "");
    Expect(0, 1791, '\P{Is_Blk:_Arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk:_Arabic}', "");
    Expect(0, 1792, '\p{Is_Blk:_Arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk:_Arabic}', "");
    Expect(1, 1792, '\P{Is_Blk:_Arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk:_Arabic}', "");
    Error('\p{Block=-arabic_EXTENDED_a:=}');
    Error('\P{Block=-arabic_EXTENDED_a:=}');
    Expect(1, 2303, '\p{Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Block:	 Arabic_Extended_a}', "");
    Expect(0, 2303, '\p{^Block:	 Arabic_Extended_a}', "");
    Expect(0, 2303, '\P{Block:	 Arabic_Extended_a}', "");
    Expect(1, 2303, '\P{^Block:	 Arabic_Extended_a}', "");
    Expect(0, 2304, '\p{Block:	 Arabic_Extended_a}', "");
    Expect(1, 2304, '\p{^Block:	 Arabic_Extended_a}', "");
    Expect(1, 2304, '\P{Block:	 Arabic_Extended_a}', "");
    Expect(0, 2304, '\P{^Block:	 Arabic_Extended_a}', "");
    Error('\p{Blk=	-arabic_Ext_A:=}');
    Error('\P{Blk=	-arabic_Ext_A:=}');
    Expect(1, 2303, '\p{Blk:   arabicexta}', "");
    Expect(0, 2303, '\p{^Blk:   arabicexta}', "");
    Expect(0, 2303, '\P{Blk:   arabicexta}', "");
    Expect(1, 2303, '\P{^Blk:   arabicexta}', "");
    Expect(0, 2304, '\p{Blk:   arabicexta}', "");
    Expect(1, 2304, '\p{^Blk:   arabicexta}', "");
    Expect(1, 2304, '\P{Blk:   arabicexta}', "");
    Expect(0, 2304, '\P{^Blk:   arabicexta}', "");
    Expect(1, 2303, '\p{Blk=_-arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Blk=_-arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Blk=_-arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Blk=_-arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Blk=_-arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Blk=_-arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Blk=_-arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Blk=_-arabic_Ext_A}', "");
    Error('\p{Is_Block=	/a/Arabic_Extended_A}');
    Error('\P{Is_Block=	/a/Arabic_Extended_A}');
    Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Is_Block= ARABIC_extended_A}', "");
    Expect(0, 2303, '\p{^Is_Block= ARABIC_extended_A}', "");
    Expect(0, 2303, '\P{Is_Block= ARABIC_extended_A}', "");
    Expect(1, 2303, '\P{^Is_Block= ARABIC_extended_A}', "");
    Expect(0, 2304, '\p{Is_Block= ARABIC_extended_A}', "");
    Expect(1, 2304, '\p{^Is_Block= ARABIC_extended_A}', "");
    Expect(1, 2304, '\P{Is_Block= ARABIC_extended_A}', "");
    Expect(0, 2304, '\P{^Is_Block= ARABIC_extended_A}', "");
    Error('\p{Is_Blk= /a/ARABIC_EXT_A}');
    Error('\P{Is_Blk= /a/ARABIC_EXT_A}');
    Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Is_Blk=_Arabic_ext_A}', "");
    Expect(0, 2303, '\p{^Is_Blk=_Arabic_ext_A}', "");
    Expect(0, 2303, '\P{Is_Blk=_Arabic_ext_A}', "");
    Expect(1, 2303, '\P{^Is_Blk=_Arabic_ext_A}', "");
    Expect(0, 2304, '\p{Is_Blk=_Arabic_ext_A}', "");
    Expect(1, 2304, '\p{^Is_Blk=_Arabic_ext_A}', "");
    Expect(1, 2304, '\P{Is_Blk=_Arabic_ext_A}', "");
    Expect(0, 2304, '\P{^Is_Blk=_Arabic_ext_A}', "");
    Error('\p{Block=	ARABIC_Mathematical_alphabetic_symbols/a/}');
    Error('\P{Block=	ARABIC_Mathematical_alphabetic_symbols/a/}');
    Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\p{^Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\P{Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126719, '\P{^Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\p{Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\p{^Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\P{Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\P{^Block=		ARABIC_mathematical_Alphabetic_Symbols}', "");
    Error('\p{Blk=	/a/Arabic_Math}');
    Error('\P{Blk=	/a/Arabic_Math}');
    Expect(1, 126719, '\p{Blk:   arabicmath}', "");
    Expect(0, 126719, '\p{^Blk:   arabicmath}', "");
    Expect(0, 126719, '\P{Blk:   arabicmath}', "");
    Expect(1, 126719, '\P{^Blk:   arabicmath}', "");
    Expect(0, 126720, '\p{Blk:   arabicmath}', "");
    Expect(1, 126720, '\p{^Blk:   arabicmath}', "");
    Expect(1, 126720, '\P{Blk:   arabicmath}', "");
    Expect(0, 126720, '\P{^Blk:   arabicmath}', "");
    Expect(1, 126719, '\p{Blk:	_-arabic_Math}', "");
    Expect(0, 126719, '\p{^Blk:	_-arabic_Math}', "");
    Expect(0, 126719, '\P{Blk:	_-arabic_Math}', "");
    Expect(1, 126719, '\P{^Blk:	_-arabic_Math}', "");
    Expect(0, 126720, '\p{Blk:	_-arabic_Math}', "");
    Expect(1, 126720, '\p{^Blk:	_-arabic_Math}', "");
    Expect(1, 126720, '\P{Blk:	_-arabic_Math}', "");
    Expect(0, 126720, '\P{^Blk:	_-arabic_Math}', "");
    Error('\p{Is_Block=	ARABIC_Mathematical_Alphabetic_SYMBOLS/a/}');
    Error('\P{Is_Block=	ARABIC_Mathematical_Alphabetic_SYMBOLS/a/}');
    Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(0, 126719, '\p{^Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(0, 126719, '\P{Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(1, 126719, '\P{^Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(0, 126720, '\p{Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(1, 126720, '\p{^Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(1, 126720, '\P{Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Expect(0, 126720, '\P{^Is_Block=_	ARABIC_Mathematical_Alphabetic_SYMBOLS}', "");
    Error('\p{Is_Blk=--ARABIC_Math:=}');
    Error('\P{Is_Blk=--ARABIC_Math:=}');
    Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Is_Blk=_arabic_MATH}', "");
    Expect(0, 126719, '\p{^Is_Blk=_arabic_MATH}', "");
    Expect(0, 126719, '\P{Is_Blk=_arabic_MATH}', "");
    Expect(1, 126719, '\P{^Is_Blk=_arabic_MATH}', "");
    Expect(0, 126720, '\p{Is_Blk=_arabic_MATH}', "");
    Expect(1, 126720, '\p{^Is_Blk=_arabic_MATH}', "");
    Expect(1, 126720, '\P{Is_Blk=_arabic_MATH}', "");
    Expect(0, 126720, '\P{^Is_Blk=_arabic_MATH}', "");
    Error('\p{Block=/a/		ARABIC_PRESENTATION_Forms_a}');
    Error('\P{Block=/a/		ARABIC_PRESENTATION_Forms_a}');
    Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65023, '\p{^Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65023, '\P{Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65023, '\P{^Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65024, '\p{Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65024, '\p{^Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(1, 65024, '\P{Block= _ARABIC_Presentation_Forms_A}', "");
    Expect(0, 65024, '\P{^Block= _ARABIC_Presentation_Forms_A}', "");
    Error('\p{Blk=	Arabic_pf_A:=}');
    Error('\P{Blk=	Arabic_pf_A:=}');
    Expect(1, 65023, '\p{Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Blk= arabic_PF_A}', "");
    Expect(0, 65023, '\p{^Blk= arabic_PF_A}', "");
    Expect(0, 65023, '\P{Blk= arabic_PF_A}', "");
    Expect(1, 65023, '\P{^Blk= arabic_PF_A}', "");
    Expect(0, 65024, '\p{Blk= arabic_PF_A}', "");
    Expect(1, 65024, '\p{^Blk= arabic_PF_A}', "");
    Expect(1, 65024, '\P{Blk= arabic_PF_A}', "");
    Expect(0, 65024, '\P{^Blk= arabic_PF_A}', "");
    Error('\p{Is_Block=:=Arabic_presentation_Forms_A}');
    Error('\P{Is_Block=:=Arabic_presentation_Forms_A}');
    Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(0, 65023, '\p{^Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(0, 65023, '\P{Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(1, 65023, '\P{^Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(0, 65024, '\p{Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(1, 65024, '\p{^Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(1, 65024, '\P{Is_Block=--Arabic_Presentation_Forms_A}', "");
    Expect(0, 65024, '\P{^Is_Block=--Arabic_Presentation_Forms_A}', "");
    Error('\p{Is_Blk=/a/ _Arabic_PF_A}');
    Error('\P{Is_Blk=/a/ _Arabic_PF_A}');
    Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Is_Blk=	Arabic_pf_A}', "");
    Expect(0, 65023, '\p{^Is_Blk=	Arabic_pf_A}', "");
    Expect(0, 65023, '\P{Is_Blk=	Arabic_pf_A}', "");
    Expect(1, 65023, '\P{^Is_Blk=	Arabic_pf_A}', "");
    Expect(0, 65024, '\p{Is_Blk=	Arabic_pf_A}', "");
    Expect(1, 65024, '\p{^Is_Blk=	Arabic_pf_A}', "");
    Expect(1, 65024, '\P{Is_Blk=	Arabic_pf_A}', "");
    Expect(0, 65024, '\P{^Is_Blk=	Arabic_pf_A}', "");
    Error('\p{Block=  ARABIC_presentation_FORMS_b:=}');
    Error('\P{Block=  ARABIC_presentation_FORMS_b:=}');
    Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(0, 65279, '\p{^Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(0, 65279, '\P{Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(1, 65279, '\P{^Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(0, 65280, '\p{Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(1, 65280, '\p{^Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(1, 65280, '\P{Block:		Arabic_PRESENTATION_forms_B}', "");
    Expect(0, 65280, '\P{^Block:		Arabic_PRESENTATION_forms_B}', "");
    Error('\p{Blk=:=--Arabic_pf_B}');
    Error('\P{Blk=:=--Arabic_pf_B}');
    Expect(1, 65279, '\p{Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Blk=_ Arabic_pf_B}', "");
    Expect(0, 65279, '\p{^Blk=_ Arabic_pf_B}', "");
    Expect(0, 65279, '\P{Blk=_ Arabic_pf_B}', "");
    Expect(1, 65279, '\P{^Blk=_ Arabic_pf_B}', "");
    Expect(0, 65280, '\p{Blk=_ Arabic_pf_B}', "");
    Expect(1, 65280, '\p{^Blk=_ Arabic_pf_B}', "");
    Expect(1, 65280, '\P{Blk=_ Arabic_pf_B}', "");
    Expect(0, 65280, '\P{^Blk=_ Arabic_pf_B}', "");
    Error('\p{Is_Block=/a/-_arabic_PRESENTATION_Forms_B}');
    Error('\P{Is_Block=/a/-_arabic_PRESENTATION_Forms_B}');
    Expect(1, 65279, '\p{Is_Block:arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Is_Block:arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Is_Block:arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Is_Block:arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Is_Block:arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Is_Block:arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Is_Block:arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Is_Block:arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(0, 65279, '\p{^Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(0, 65279, '\P{Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(1, 65279, '\P{^Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(0, 65280, '\p{Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(1, 65280, '\p{^Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(1, 65280, '\P{Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Expect(0, 65280, '\P{^Is_Block=-_ARABIC_presentation_FORMS_B}', "");
    Error('\p{Is_Blk: /a/__Arabic_PF_b}');
    Error('\P{Is_Blk: /a/__Arabic_PF_b}');
    Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Is_Blk=_ARABIC_pf_B}', "");
    Expect(0, 65279, '\p{^Is_Blk=_ARABIC_pf_B}', "");
    Expect(0, 65279, '\P{Is_Blk=_ARABIC_pf_B}', "");
    Expect(1, 65279, '\P{^Is_Blk=_ARABIC_pf_B}', "");
    Expect(0, 65280, '\p{Is_Blk=_ARABIC_pf_B}', "");
    Expect(1, 65280, '\p{^Is_Blk=_ARABIC_pf_B}', "");
    Expect(1, 65280, '\P{Is_Blk=_ARABIC_pf_B}', "");
    Expect(0, 65280, '\P{^Is_Blk=_ARABIC_pf_B}', "");
    Error('\p{Block=-:=arabic_Supplement}');
    Error('\P{Block=-:=arabic_Supplement}');
    Expect(1, 1919, '\p{Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Block=	-ARABIC_Supplement}', "");
    Expect(0, 1919, '\p{^Block=	-ARABIC_Supplement}', "");
    Expect(0, 1919, '\P{Block=	-ARABIC_Supplement}', "");
    Expect(1, 1919, '\P{^Block=	-ARABIC_Supplement}', "");
    Expect(0, 1920, '\p{Block=	-ARABIC_Supplement}', "");
    Expect(1, 1920, '\p{^Block=	-ARABIC_Supplement}', "");
    Expect(1, 1920, '\P{Block=	-ARABIC_Supplement}', "");
    Expect(0, 1920, '\P{^Block=	-ARABIC_Supplement}', "");
    Error('\p{Blk=:=-	arabic_Sup}');
    Error('\P{Blk=:=-	arabic_Sup}');
    Expect(1, 1919, '\p{Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Blk:	_arabic_sup}', "");
    Expect(0, 1919, '\p{^Blk:	_arabic_sup}', "");
    Expect(0, 1919, '\P{Blk:	_arabic_sup}', "");
    Expect(1, 1919, '\P{^Blk:	_arabic_sup}', "");
    Expect(0, 1920, '\p{Blk:	_arabic_sup}', "");
    Expect(1, 1920, '\p{^Blk:	_arabic_sup}', "");
    Expect(1, 1920, '\P{Blk:	_arabic_sup}', "");
    Expect(0, 1920, '\P{^Blk:	_arabic_sup}', "");
    Error('\p{Is_Block=/a/ARABIC_supplement}');
    Error('\P{Is_Block=/a/ARABIC_supplement}');
    Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(0, 1919, '\p{^Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(0, 1919, '\P{Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(1, 1919, '\P{^Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(0, 1920, '\p{Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(1, 1920, '\p{^Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(1, 1920, '\P{Is_Block=-Arabic_SUPPLEMENT}', "");
    Expect(0, 1920, '\P{^Is_Block=-Arabic_SUPPLEMENT}', "");
    Error('\p{Is_Blk:    _Arabic_Sup:=}');
    Error('\P{Is_Blk:    _Arabic_Sup:=}');
    Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Is_Blk:	-ARABIC_SUP}', "");
    Expect(0, 1919, '\p{^Is_Blk:	-ARABIC_SUP}', "");
    Expect(0, 1919, '\P{Is_Blk:	-ARABIC_SUP}', "");
    Expect(1, 1919, '\P{^Is_Blk:	-ARABIC_SUP}', "");
    Expect(0, 1920, '\p{Is_Blk:	-ARABIC_SUP}', "");
    Expect(1, 1920, '\p{^Is_Blk:	-ARABIC_SUP}', "");
    Expect(1, 1920, '\P{Is_Blk:	-ARABIC_SUP}', "");
    Expect(0, 1920, '\P{^Is_Blk:	-ARABIC_SUP}', "");
    Error('\p{Block=/a/	-armenian}');
    Error('\P{Block=/a/	-armenian}');
    Expect(1, 1423, '\p{Block=armenian}', "");
    Expect(0, 1423, '\p{^Block=armenian}', "");
    Expect(0, 1423, '\P{Block=armenian}', "");
    Expect(1, 1423, '\P{^Block=armenian}', "");
    Expect(0, 1424, '\p{Block=armenian}', "");
    Expect(1, 1424, '\p{^Block=armenian}', "");
    Expect(1, 1424, '\P{Block=armenian}', "");
    Expect(0, 1424, '\P{^Block=armenian}', "");
    Expect(1, 1423, '\p{Block= 	Armenian}', "");
    Expect(0, 1423, '\p{^Block= 	Armenian}', "");
    Expect(0, 1423, '\P{Block= 	Armenian}', "");
    Expect(1, 1423, '\P{^Block= 	Armenian}', "");
    Expect(0, 1424, '\p{Block= 	Armenian}', "");
    Expect(1, 1424, '\p{^Block= 	Armenian}', "");
    Expect(1, 1424, '\P{Block= 	Armenian}', "");
    Expect(0, 1424, '\P{^Block= 	Armenian}', "");
    Error('\p{Blk=	_ARMENIAN:=}');
    Error('\P{Blk=	_ARMENIAN:=}');
    Expect(1, 1423, '\p{Blk=armenian}', "");
    Expect(0, 1423, '\p{^Blk=armenian}', "");
    Expect(0, 1423, '\P{Blk=armenian}', "");
    Expect(1, 1423, '\P{^Blk=armenian}', "");
    Expect(0, 1424, '\p{Blk=armenian}', "");
    Expect(1, 1424, '\p{^Blk=armenian}', "");
    Expect(1, 1424, '\P{Blk=armenian}', "");
    Expect(0, 1424, '\P{^Blk=armenian}', "");
    Expect(1, 1423, '\p{Blk= -Armenian}', "");
    Expect(0, 1423, '\p{^Blk= -Armenian}', "");
    Expect(0, 1423, '\P{Blk= -Armenian}', "");
    Expect(1, 1423, '\P{^Blk= -Armenian}', "");
    Expect(0, 1424, '\p{Blk= -Armenian}', "");
    Expect(1, 1424, '\p{^Blk= -Armenian}', "");
    Expect(1, 1424, '\P{Blk= -Armenian}', "");
    Expect(0, 1424, '\P{^Blk= -Armenian}', "");
    Error('\p{Is_Block=- Armenian/a/}');
    Error('\P{Is_Block=- Armenian/a/}');
    Expect(1, 1423, '\p{Is_Block=armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=armenian}', "");
    Expect(0, 1423, '\P{Is_Block=armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=armenian}', "");
    Expect(0, 1424, '\p{Is_Block=armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=armenian}', "");
    Expect(1, 1424, '\P{Is_Block=armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=armenian}', "");
    Error('\p{Is_Blk=	-Armenian/a/}');
    Error('\P{Is_Blk=	-Armenian/a/}');
    Expect(1, 1423, '\p{Is_Blk=armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
    Expect(0, 1423, '\P{Is_Blk=armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
    Expect(0, 1424, '\p{Is_Blk=armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk=armenian}', "");
    Expect(1, 1424, '\P{Is_Blk=armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk=armenian}', "");
    Expect(1, 1423, '\p{Is_Blk=	-Armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk=	-Armenian}', "");
    Expect(0, 1423, '\P{Is_Blk=	-Armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk=	-Armenian}', "");
    Expect(0, 1424, '\p{Is_Blk=	-Armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk=	-Armenian}', "");
    Expect(1, 1424, '\P{Is_Blk=	-Armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk=	-Armenian}', "");
    Error('\p{Block=	:=Arrows}');
    Error('\P{Block=	:=Arrows}');
    Expect(1, 8703, '\p{Block=arrows}', "");
    Expect(0, 8703, '\p{^Block=arrows}', "");
    Expect(0, 8703, '\P{Block=arrows}', "");
    Expect(1, 8703, '\P{^Block=arrows}', "");
    Expect(0, 8704, '\p{Block=arrows}', "");
    Expect(1, 8704, '\p{^Block=arrows}', "");
    Expect(1, 8704, '\P{Block=arrows}', "");
    Expect(0, 8704, '\P{^Block=arrows}', "");
    Expect(1, 8703, '\p{Block=_	arrows}', "");
    Expect(0, 8703, '\p{^Block=_	arrows}', "");
    Expect(0, 8703, '\P{Block=_	arrows}', "");
    Expect(1, 8703, '\P{^Block=_	arrows}', "");
    Expect(0, 8704, '\p{Block=_	arrows}', "");
    Expect(1, 8704, '\p{^Block=_	arrows}', "");
    Expect(1, 8704, '\P{Block=_	arrows}', "");
    Expect(0, 8704, '\P{^Block=_	arrows}', "");
    Error('\p{Blk=- ARROWS:=}');
    Error('\P{Blk=- ARROWS:=}');
    Expect(1, 8703, '\p{Blk=arrows}', "");
    Expect(0, 8703, '\p{^Blk=arrows}', "");
    Expect(0, 8703, '\P{Blk=arrows}', "");
    Expect(1, 8703, '\P{^Blk=arrows}', "");
    Expect(0, 8704, '\p{Blk=arrows}', "");
    Expect(1, 8704, '\p{^Blk=arrows}', "");
    Expect(1, 8704, '\P{Blk=arrows}', "");
    Expect(0, 8704, '\P{^Blk=arrows}', "");
    Expect(1, 8703, '\p{Blk:   	Arrows}', "");
    Expect(0, 8703, '\p{^Blk:   	Arrows}', "");
    Expect(0, 8703, '\P{Blk:   	Arrows}', "");
    Expect(1, 8703, '\P{^Blk:   	Arrows}', "");
    Expect(0, 8704, '\p{Blk:   	Arrows}', "");
    Expect(1, 8704, '\p{^Blk:   	Arrows}', "");
    Expect(1, 8704, '\P{Blk:   	Arrows}', "");
    Expect(0, 8704, '\P{^Blk:   	Arrows}', "");
    Error('\p{Is_Block=:=_Arrows}');
    Error('\P{Is_Block=:=_Arrows}');
    Expect(1, 8703, '\p{Is_Block=arrows}', "");
    Expect(0, 8703, '\p{^Is_Block=arrows}', "");
    Expect(0, 8703, '\P{Is_Block=arrows}', "");
    Expect(1, 8703, '\P{^Is_Block=arrows}', "");
    Expect(0, 8704, '\p{Is_Block=arrows}', "");
    Expect(1, 8704, '\p{^Is_Block=arrows}', "");
    Expect(1, 8704, '\P{Is_Block=arrows}', "");
    Expect(0, 8704, '\P{^Is_Block=arrows}', "");
    Expect(1, 8703, '\p{Is_Block=-_ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Block=-_ARROWS}', "");
    Expect(0, 8703, '\P{Is_Block=-_ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Block=-_ARROWS}', "");
    Expect(0, 8704, '\p{Is_Block=-_ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Block=-_ARROWS}', "");
    Expect(1, 8704, '\P{Is_Block=-_ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Block=-_ARROWS}', "");
    Error('\p{Is_Blk=:=  Arrows}');
    Error('\P{Is_Blk=:=  Arrows}');
    Expect(1, 8703, '\p{Is_Blk=arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
    Expect(1, 8703, '\p{Is_Blk= 	ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Blk= 	ARROWS}', "");
    Expect(0, 8703, '\P{Is_Blk= 	ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Blk= 	ARROWS}', "");
    Expect(0, 8704, '\p{Is_Blk= 	ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Blk= 	ARROWS}', "");
    Expect(1, 8704, '\P{Is_Blk= 	ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Blk= 	ARROWS}', "");
    Error('\p{Block=		BASIC_Latin:=}');
    Error('\P{Block=		BASIC_Latin:=}');
    Expect(1, 127, '\p{Block=basiclatin}', "");
    Expect(0, 127, '\p{^Block=basiclatin}', "");
    Expect(0, 127, '\P{Block=basiclatin}', "");
    Expect(1, 127, '\P{^Block=basiclatin}', "");
    Expect(0, 128, '\p{Block=basiclatin}', "");
    Expect(1, 128, '\p{^Block=basiclatin}', "");
    Expect(1, 128, '\P{Block=basiclatin}', "");
    Expect(0, 128, '\P{^Block=basiclatin}', "");
    Expect(1, 127, '\p{Block=	 basic_Latin}', "");
    Expect(0, 127, '\p{^Block=	 basic_Latin}', "");
    Expect(0, 127, '\P{Block=	 basic_Latin}', "");
    Expect(1, 127, '\P{^Block=	 basic_Latin}', "");
    Expect(0, 128, '\p{Block=	 basic_Latin}', "");
    Expect(1, 128, '\p{^Block=	 basic_Latin}', "");
    Expect(1, 128, '\P{Block=	 basic_Latin}', "");
    Expect(0, 128, '\P{^Block=	 basic_Latin}', "");
    Error('\p{Blk=	 ascii/a/}');
    Error('\P{Blk=	 ascii/a/}');
    Expect(1, 127, '\p{Blk=ascii}', "");
    Expect(0, 127, '\p{^Blk=ascii}', "");
    Expect(0, 127, '\P{Blk=ascii}', "");
    Expect(1, 127, '\P{^Blk=ascii}', "");
    Expect(0, 128, '\p{Blk=ascii}', "");
    Expect(1, 128, '\p{^Blk=ascii}', "");
    Expect(1, 128, '\P{Blk=ascii}', "");
    Expect(0, 128, '\P{^Blk=ascii}', "");
    Expect(1, 127, '\p{Blk=- ASCII}', "");
    Expect(0, 127, '\p{^Blk=- ASCII}', "");
    Expect(0, 127, '\P{Blk=- ASCII}', "");
    Expect(1, 127, '\P{^Blk=- ASCII}', "");
    Expect(0, 128, '\p{Blk=- ASCII}', "");
    Expect(1, 128, '\p{^Blk=- ASCII}', "");
    Expect(1, 128, '\P{Blk=- ASCII}', "");
    Expect(0, 128, '\P{^Blk=- ASCII}', "");
    Error('\p{Is_Block= :=basic_Latin}');
    Error('\P{Is_Block= :=basic_Latin}');
    Expect(1, 127, '\p{Is_Block: basiclatin}', "");
    Expect(0, 127, '\p{^Is_Block: basiclatin}', "");
    Expect(0, 127, '\P{Is_Block: basiclatin}', "");
    Expect(1, 127, '\P{^Is_Block: basiclatin}', "");
    Expect(0, 128, '\p{Is_Block: basiclatin}', "");
    Expect(1, 128, '\p{^Is_Block: basiclatin}', "");
    Expect(1, 128, '\P{Is_Block: basiclatin}', "");
    Expect(0, 128, '\P{^Is_Block: basiclatin}', "");
    Expect(1, 127, '\p{Is_Block=  basic_LATIN}', "");
    Expect(0, 127, '\p{^Is_Block=  basic_LATIN}', "");
    Expect(0, 127, '\P{Is_Block=  basic_LATIN}', "");
    Expect(1, 127, '\P{^Is_Block=  basic_LATIN}', "");
    Expect(0, 128, '\p{Is_Block=  basic_LATIN}', "");
    Expect(1, 128, '\p{^Is_Block=  basic_LATIN}', "");
    Expect(1, 128, '\P{Is_Block=  basic_LATIN}', "");
    Expect(0, 128, '\P{^Is_Block=  basic_LATIN}', "");
    Error('\p{Is_Blk:	 ASCII/a/}');
    Error('\P{Is_Blk:	 ASCII/a/}');
    Expect(1, 127, '\p{Is_Blk=ascii}', "");
    Expect(0, 127, '\p{^Is_Blk=ascii}', "");
    Expect(0, 127, '\P{Is_Blk=ascii}', "");
    Expect(1, 127, '\P{^Is_Blk=ascii}', "");
    Expect(0, 128, '\p{Is_Blk=ascii}', "");
    Expect(1, 128, '\p{^Is_Blk=ascii}', "");
    Expect(1, 128, '\P{Is_Blk=ascii}', "");
    Expect(0, 128, '\P{^Is_Blk=ascii}', "");
    Expect(1, 127, '\p{Is_Blk=-ASCII}', "");
    Expect(0, 127, '\p{^Is_Blk=-ASCII}', "");
    Expect(0, 127, '\P{Is_Blk=-ASCII}', "");
    Expect(1, 127, '\P{^Is_Blk=-ASCII}', "");
    Expect(0, 128, '\p{Is_Blk=-ASCII}', "");
    Expect(1, 128, '\p{^Is_Blk=-ASCII}', "");
    Expect(1, 128, '\P{Is_Blk=-ASCII}', "");
    Expect(0, 128, '\P{^Is_Blk=-ASCII}', "");
    Error('\p{Block=_/a/AVESTAN}');
    Error('\P{Block=_/a/AVESTAN}');
    Expect(1, 68415, '\p{Block=avestan}', "");
    Expect(0, 68415, '\p{^Block=avestan}', "");
    Expect(0, 68415, '\P{Block=avestan}', "");
    Expect(1, 68415, '\P{^Block=avestan}', "");
    Expect(0, 68416, '\p{Block=avestan}', "");
    Expect(1, 68416, '\p{^Block=avestan}', "");
    Expect(1, 68416, '\P{Block=avestan}', "");
    Expect(0, 68416, '\P{^Block=avestan}', "");
    Expect(1, 68415, '\p{Block=-AVESTAN}', "");
    Expect(0, 68415, '\p{^Block=-AVESTAN}', "");
    Expect(0, 68415, '\P{Block=-AVESTAN}', "");
    Expect(1, 68415, '\P{^Block=-AVESTAN}', "");
    Expect(0, 68416, '\p{Block=-AVESTAN}', "");
    Expect(1, 68416, '\p{^Block=-AVESTAN}', "");
    Expect(1, 68416, '\P{Block=-AVESTAN}', "");
    Expect(0, 68416, '\P{^Block=-AVESTAN}', "");
    Error('\p{Blk=:=Avestan}');
    Error('\P{Blk=:=Avestan}');
    Expect(1, 68415, '\p{Blk=avestan}', "");
    Expect(0, 68415, '\p{^Blk=avestan}', "");
    Expect(0, 68415, '\P{Blk=avestan}', "");
    Expect(1, 68415, '\P{^Blk=avestan}', "");
    Expect(0, 68416, '\p{Blk=avestan}', "");
    Expect(1, 68416, '\p{^Blk=avestan}', "");
    Expect(1, 68416, '\P{Blk=avestan}', "");
    Expect(0, 68416, '\P{^Blk=avestan}', "");
    Expect(1, 68415, '\p{Blk=	AVESTAN}', "");
    Expect(0, 68415, '\p{^Blk=	AVESTAN}', "");
    Expect(0, 68415, '\P{Blk=	AVESTAN}', "");
    Expect(1, 68415, '\P{^Blk=	AVESTAN}', "");
    Expect(0, 68416, '\p{Blk=	AVESTAN}', "");
    Expect(1, 68416, '\p{^Blk=	AVESTAN}', "");
    Expect(1, 68416, '\P{Blk=	AVESTAN}', "");
    Expect(0, 68416, '\P{^Blk=	AVESTAN}', "");
    Error('\p{Is_Block: _	AVESTAN/a/}');
    Error('\P{Is_Block: _	AVESTAN/a/}');
    Expect(1, 68415, '\p{Is_Block=avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=avestan}', "");
    Expect(0, 68415, '\P{Is_Block=avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=avestan}', "");
    Expect(0, 68416, '\p{Is_Block=avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=avestan}', "");
    Expect(1, 68416, '\P{Is_Block=avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=avestan}', "");
    Expect(1, 68415, '\p{Is_Block= 	avestan}', "");
    Expect(0, 68415, '\p{^Is_Block= 	avestan}', "");
    Expect(0, 68415, '\P{Is_Block= 	avestan}', "");
    Expect(1, 68415, '\P{^Is_Block= 	avestan}', "");
    Expect(0, 68416, '\p{Is_Block= 	avestan}', "");
    Expect(1, 68416, '\p{^Is_Block= 	avestan}', "");
    Expect(1, 68416, '\P{Is_Block= 	avestan}', "");
    Expect(0, 68416, '\P{^Is_Block= 	avestan}', "");
    Error('\p{Is_Blk=	/a/avestan}');
    Error('\P{Is_Blk=	/a/avestan}');
    Expect(1, 68415, '\p{Is_Blk=avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
    Expect(0, 68415, '\P{Is_Blk=avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
    Expect(0, 68416, '\p{Is_Blk=avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk=avestan}', "");
    Expect(1, 68416, '\P{Is_Blk=avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk=avestan}', "");
    Expect(1, 68415, '\p{Is_Blk=-	avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk=-	avestan}', "");
    Expect(0, 68415, '\P{Is_Blk=-	avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk=-	avestan}', "");
    Expect(0, 68416, '\p{Is_Blk=-	avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk=-	avestan}', "");
    Expect(1, 68416, '\P{Is_Blk=-	avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk=-	avestan}', "");
    Error('\p{Block: _balinese/a/}');
    Error('\P{Block: _balinese/a/}');
    Expect(1, 7039, '\p{Block=balinese}', "");
    Expect(0, 7039, '\p{^Block=balinese}', "");
    Expect(0, 7039, '\P{Block=balinese}', "");
    Expect(1, 7039, '\P{^Block=balinese}', "");
    Expect(0, 7040, '\p{Block=balinese}', "");
    Expect(1, 7040, '\p{^Block=balinese}', "");
    Expect(1, 7040, '\P{Block=balinese}', "");
    Expect(0, 7040, '\P{^Block=balinese}', "");
    Expect(1, 7039, '\p{Block=BALINESE}', "");
    Expect(0, 7039, '\p{^Block=BALINESE}', "");
    Expect(0, 7039, '\P{Block=BALINESE}', "");
    Expect(1, 7039, '\P{^Block=BALINESE}', "");
    Expect(0, 7040, '\p{Block=BALINESE}', "");
    Expect(1, 7040, '\p{^Block=BALINESE}', "");
    Expect(1, 7040, '\P{Block=BALINESE}', "");
    Expect(0, 7040, '\P{^Block=BALINESE}', "");
    Error('\p{Blk=_-Balinese:=}');
    Error('\P{Blk=_-Balinese:=}');
    Expect(1, 7039, '\p{Blk=balinese}', "");
    Expect(0, 7039, '\p{^Blk=balinese}', "");
    Expect(0, 7039, '\P{Blk=balinese}', "");
    Expect(1, 7039, '\P{^Blk=balinese}', "");
    Expect(0, 7040, '\p{Blk=balinese}', "");
    Expect(1, 7040, '\p{^Blk=balinese}', "");
    Expect(1, 7040, '\P{Blk=balinese}', "");
    Expect(0, 7040, '\P{^Blk=balinese}', "");
    Expect(1, 7039, '\p{Blk= _Balinese}', "");
    Expect(0, 7039, '\p{^Blk= _Balinese}', "");
    Expect(0, 7039, '\P{Blk= _Balinese}', "");
    Expect(1, 7039, '\P{^Blk= _Balinese}', "");
    Expect(0, 7040, '\p{Blk= _Balinese}', "");
    Expect(1, 7040, '\p{^Blk= _Balinese}', "");
    Expect(1, 7040, '\P{Blk= _Balinese}', "");
    Expect(0, 7040, '\P{^Blk= _Balinese}', "");
    Error('\p{Is_Block=  balinese/a/}');
    Error('\P{Is_Block=  balinese/a/}');
    Expect(1, 7039, '\p{Is_Block=balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=balinese}', "");
    Expect(0, 7039, '\P{Is_Block=balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=balinese}', "");
    Expect(0, 7040, '\p{Is_Block=balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=balinese}', "");
    Expect(1, 7040, '\P{Is_Block=balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=balinese}', "");
    Expect(1, 7039, '\p{Is_Block=	Balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=	Balinese}', "");
    Expect(0, 7039, '\P{Is_Block=	Balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=	Balinese}', "");
    Expect(0, 7040, '\p{Is_Block=	Balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=	Balinese}', "");
    Expect(1, 7040, '\P{Is_Block=	Balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=	Balinese}', "");
    Error('\p{Is_Blk=/a/Balinese}');
    Error('\P{Is_Blk=/a/Balinese}');
    Expect(1, 7039, '\p{Is_Blk=balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
    Expect(1, 7039, '\p{Is_Blk=_ Balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=_ Balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=_ Balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=_ Balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=_ Balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=_ Balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=_ Balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=_ Balinese}', "");
    Error('\p{Block:   :=__Bamum}');
    Error('\P{Block:   :=__Bamum}');
    Expect(1, 42751, '\p{Block=bamum}', "");
    Expect(0, 42751, '\p{^Block=bamum}', "");
    Expect(0, 42751, '\P{Block=bamum}', "");
    Expect(1, 42751, '\P{^Block=bamum}', "");
    Expect(0, 42752, '\p{Block=bamum}', "");
    Expect(1, 42752, '\p{^Block=bamum}', "");
    Expect(1, 42752, '\P{Block=bamum}', "");
    Expect(0, 42752, '\P{^Block=bamum}', "");
    Expect(1, 42751, '\p{Block=-_bamum}', "");
    Expect(0, 42751, '\p{^Block=-_bamum}', "");
    Expect(0, 42751, '\P{Block=-_bamum}', "");
    Expect(1, 42751, '\P{^Block=-_bamum}', "");
    Expect(0, 42752, '\p{Block=-_bamum}', "");
    Expect(1, 42752, '\p{^Block=-_bamum}', "");
    Expect(1, 42752, '\P{Block=-_bamum}', "");
    Expect(0, 42752, '\P{^Block=-_bamum}', "");
    Error('\p{Blk: 	_BAMUM:=}');
    Error('\P{Blk: 	_BAMUM:=}');
    Expect(1, 42751, '\p{Blk=bamum}', "");
    Expect(0, 42751, '\p{^Blk=bamum}', "");
    Expect(0, 42751, '\P{Blk=bamum}', "");
    Expect(1, 42751, '\P{^Blk=bamum}', "");
    Expect(0, 42752, '\p{Blk=bamum}', "");
    Expect(1, 42752, '\p{^Blk=bamum}', "");
    Expect(1, 42752, '\P{Blk=bamum}', "");
    Expect(0, 42752, '\P{^Blk=bamum}', "");
    Expect(1, 42751, '\p{Blk=-Bamum}', "");
    Expect(0, 42751, '\p{^Blk=-Bamum}', "");
    Expect(0, 42751, '\P{Blk=-Bamum}', "");
    Expect(1, 42751, '\P{^Blk=-Bamum}', "");
    Expect(0, 42752, '\p{Blk=-Bamum}', "");
    Expect(1, 42752, '\p{^Blk=-Bamum}', "");
    Expect(1, 42752, '\P{Blk=-Bamum}', "");
    Expect(0, 42752, '\P{^Blk=-Bamum}', "");
    Error('\p{Is_Block:	-	BAMUM:=}');
    Error('\P{Is_Block:	-	BAMUM:=}');
    Expect(1, 42751, '\p{Is_Block=bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=bamum}', "");
    Expect(0, 42751, '\P{Is_Block=bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=bamum}', "");
    Expect(0, 42752, '\p{Is_Block=bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=bamum}', "");
    Expect(1, 42752, '\P{Is_Block=bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=bamum}', "");
    Expect(1, 42751, '\p{Is_Block=-	Bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=-	Bamum}', "");
    Expect(0, 42751, '\P{Is_Block=-	Bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=-	Bamum}', "");
    Expect(0, 42752, '\p{Is_Block=-	Bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=-	Bamum}', "");
    Expect(1, 42752, '\P{Is_Block=-	Bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=-	Bamum}', "");
    Error('\p{Is_Blk=/a/-BAMUM}');
    Error('\P{Is_Blk=/a/-BAMUM}');
    Expect(1, 42751, '\p{Is_Blk=bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
    Expect(1, 42751, '\p{Is_Blk=-Bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=-Bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=-Bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=-Bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=-Bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=-Bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=-Bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=-Bamum}', "");
    Error('\p{Block: :=	Bamum_SUPPLEMENT}');
    Error('\P{Block: :=	Bamum_SUPPLEMENT}');
    Expect(1, 92735, '\p{Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Block=Bamum_Supplement}', "");
    Expect(0, 92735, '\p{^Block=Bamum_Supplement}', "");
    Expect(0, 92735, '\P{Block=Bamum_Supplement}', "");
    Expect(1, 92735, '\P{^Block=Bamum_Supplement}', "");
    Expect(0, 92736, '\p{Block=Bamum_Supplement}', "");
    Expect(1, 92736, '\p{^Block=Bamum_Supplement}', "");
    Expect(1, 92736, '\P{Block=Bamum_Supplement}', "");
    Expect(0, 92736, '\P{^Block=Bamum_Supplement}', "");
    Error('\p{Blk=_/a/BAMUM_Sup}');
    Error('\P{Blk=_/a/BAMUM_Sup}');
    Expect(1, 92735, '\p{Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Blk:   -Bamum_SUP}', "");
    Expect(0, 92735, '\p{^Blk:   -Bamum_SUP}', "");
    Expect(0, 92735, '\P{Blk:   -Bamum_SUP}', "");
    Expect(1, 92735, '\P{^Blk:   -Bamum_SUP}', "");
    Expect(0, 92736, '\p{Blk:   -Bamum_SUP}', "");
    Expect(1, 92736, '\p{^Blk:   -Bamum_SUP}', "");
    Expect(1, 92736, '\P{Blk:   -Bamum_SUP}', "");
    Expect(0, 92736, '\P{^Blk:   -Bamum_SUP}', "");
    Error('\p{Is_Block=:=	 bamum_Supplement}');
    Error('\P{Is_Block=:=	 bamum_Supplement}');
    Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(0, 92735, '\p{^Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(0, 92735, '\P{Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(1, 92735, '\P{^Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(0, 92736, '\p{Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(1, 92736, '\p{^Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(1, 92736, '\P{Is_Block=-Bamum_SUPPLEMENT}', "");
    Expect(0, 92736, '\P{^Is_Block=-Bamum_SUPPLEMENT}', "");
    Error('\p{Is_Blk=		bamum_Sup:=}');
    Error('\P{Is_Blk=		bamum_Sup:=}');
    Expect(1, 92735, '\p{Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Is_Blk=-BAMUM_Sup}', "");
    Expect(0, 92735, '\p{^Is_Blk=-BAMUM_Sup}', "");
    Expect(0, 92735, '\P{Is_Blk=-BAMUM_Sup}', "");
    Expect(1, 92735, '\P{^Is_Blk=-BAMUM_Sup}', "");
    Expect(0, 92736, '\p{Is_Blk=-BAMUM_Sup}', "");
    Expect(1, 92736, '\p{^Is_Blk=-BAMUM_Sup}', "");
    Expect(1, 92736, '\P{Is_Blk=-BAMUM_Sup}', "");
    Expect(0, 92736, '\P{^Is_Blk=-BAMUM_Sup}', "");
    Error('\p{Block=:=__Bassa_Vah}');
    Error('\P{Block=:=__Bassa_Vah}');
    Expect(1, 92927, '\p{Block=bassavah}', "");
    Expect(0, 92927, '\p{^Block=bassavah}', "");
    Expect(0, 92927, '\P{Block=bassavah}', "");
    Expect(1, 92927, '\P{^Block=bassavah}', "");
    Expect(0, 92928, '\p{Block=bassavah}', "");
    Expect(1, 92928, '\p{^Block=bassavah}', "");
    Expect(1, 92928, '\P{Block=bassavah}', "");
    Expect(0, 92928, '\P{^Block=bassavah}', "");
    Expect(1, 92927, '\p{Block=- Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Block=- Bassa_Vah}', "");
    Expect(0, 92927, '\P{Block=- Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Block=- Bassa_Vah}', "");
    Expect(0, 92928, '\p{Block=- Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Block=- Bassa_Vah}', "");
    Expect(1, 92928, '\P{Block=- Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Block=- Bassa_Vah}', "");
    Error('\p{Blk=-:=bassa_VAH}');
    Error('\P{Blk=-:=bassa_VAH}');
    Expect(1, 92927, '\p{Blk:	bassavah}', "");
    Expect(0, 92927, '\p{^Blk:	bassavah}', "");
    Expect(0, 92927, '\P{Blk:	bassavah}', "");
    Expect(1, 92927, '\P{^Blk:	bassavah}', "");
    Expect(0, 92928, '\p{Blk:	bassavah}', "");
    Expect(1, 92928, '\p{^Blk:	bassavah}', "");
    Expect(1, 92928, '\P{Blk:	bassavah}', "");
    Expect(0, 92928, '\P{^Blk:	bassavah}', "");
    Expect(1, 92927, '\p{Blk=	_Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Blk=	_Bassa_Vah}', "");
    Expect(0, 92927, '\P{Blk=	_Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Blk=	_Bassa_Vah}', "");
    Expect(0, 92928, '\p{Blk=	_Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Blk=	_Bassa_Vah}', "");
    Expect(1, 92928, '\P{Blk=	_Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Blk=	_Bassa_Vah}', "");
    Error('\p{Is_Block= /a/Bassa_vah}');
    Error('\P{Is_Block= /a/Bassa_vah}');
    Expect(1, 92927, '\p{Is_Block=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
    Expect(0, 92927, '\P{Is_Block=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
    Expect(0, 92928, '\p{Is_Block=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
    Expect(1, 92928, '\P{Is_Block=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
    Expect(1, 92927, '\p{Is_Block=__bassa_VAH}', "");
    Expect(0, 92927, '\p{^Is_Block=__bassa_VAH}', "");
    Expect(0, 92927, '\P{Is_Block=__bassa_VAH}', "");
    Expect(1, 92927, '\P{^Is_Block=__bassa_VAH}', "");
    Expect(0, 92928, '\p{Is_Block=__bassa_VAH}', "");
    Expect(1, 92928, '\p{^Is_Block=__bassa_VAH}', "");
    Expect(1, 92928, '\P{Is_Block=__bassa_VAH}', "");
    Expect(0, 92928, '\P{^Is_Block=__bassa_VAH}', "");
    Error('\p{Is_Blk=-	Bassa_Vah:=}');
    Error('\P{Is_Blk=-	Bassa_Vah:=}');
    Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
    Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
    Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
    Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
    Expect(1, 92927, '\p{Is_Blk=_ Bassa_VAH}', "");
    Expect(0, 92927, '\p{^Is_Blk=_ Bassa_VAH}', "");
    Expect(0, 92927, '\P{Is_Blk=_ Bassa_VAH}', "");
    Expect(1, 92927, '\P{^Is_Blk=_ Bassa_VAH}', "");
    Expect(0, 92928, '\p{Is_Blk=_ Bassa_VAH}', "");
    Expect(1, 92928, '\p{^Is_Blk=_ Bassa_VAH}', "");
    Expect(1, 92928, '\P{Is_Blk=_ Bassa_VAH}', "");
    Expect(0, 92928, '\P{^Is_Blk=_ Bassa_VAH}', "");
    Error('\p{Block=/a/	_BATAK}');
    Error('\P{Block=/a/	_BATAK}');
    Expect(1, 7167, '\p{Block=batak}', "");
    Expect(0, 7167, '\p{^Block=batak}', "");
    Expect(0, 7167, '\P{Block=batak}', "");
    Expect(1, 7167, '\P{^Block=batak}', "");
    Expect(0, 7168, '\p{Block=batak}', "");
    Expect(1, 7168, '\p{^Block=batak}', "");
    Expect(1, 7168, '\P{Block=batak}', "");
    Expect(0, 7168, '\P{^Block=batak}', "");
    Expect(1, 7167, '\p{Block= Batak}', "");
    Expect(0, 7167, '\p{^Block= Batak}', "");
    Expect(0, 7167, '\P{Block= Batak}', "");
    Expect(1, 7167, '\P{^Block= Batak}', "");
    Expect(0, 7168, '\p{Block= Batak}', "");
    Expect(1, 7168, '\p{^Block= Batak}', "");
    Expect(1, 7168, '\P{Block= Batak}', "");
    Expect(0, 7168, '\P{^Block= Batak}', "");
    Error('\p{Blk:_ Batak/a/}');
    Error('\P{Blk:_ Batak/a/}');
    Expect(1, 7167, '\p{Blk=batak}', "");
    Expect(0, 7167, '\p{^Blk=batak}', "");
    Expect(0, 7167, '\P{Blk=batak}', "");
    Expect(1, 7167, '\P{^Blk=batak}', "");
    Expect(0, 7168, '\p{Blk=batak}', "");
    Expect(1, 7168, '\p{^Blk=batak}', "");
    Expect(1, 7168, '\P{Blk=batak}', "");
    Expect(0, 7168, '\P{^Blk=batak}', "");
    Expect(1, 7167, '\p{Blk=-	Batak}', "");
    Expect(0, 7167, '\p{^Blk=-	Batak}', "");
    Expect(0, 7167, '\P{Blk=-	Batak}', "");
    Expect(1, 7167, '\P{^Blk=-	Batak}', "");
    Expect(0, 7168, '\p{Blk=-	Batak}', "");
    Expect(1, 7168, '\p{^Blk=-	Batak}', "");
    Expect(1, 7168, '\P{Blk=-	Batak}', "");
    Expect(0, 7168, '\P{^Blk=-	Batak}', "");
    Error('\p{Is_Block=/a/Batak}');
    Error('\P{Is_Block=/a/Batak}');
    Expect(1, 7167, '\p{Is_Block=batak}', "");
    Expect(0, 7167, '\p{^Is_Block=batak}', "");
    Expect(0, 7167, '\P{Is_Block=batak}', "");
    Expect(1, 7167, '\P{^Is_Block=batak}', "");
    Expect(0, 7168, '\p{Is_Block=batak}', "");
    Expect(1, 7168, '\p{^Is_Block=batak}', "");
    Expect(1, 7168, '\P{Is_Block=batak}', "");
    Expect(0, 7168, '\P{^Is_Block=batak}', "");
    Expect(1, 7167, '\p{Is_Block= -BATAK}', "");
    Expect(0, 7167, '\p{^Is_Block= -BATAK}', "");
    Expect(0, 7167, '\P{Is_Block= -BATAK}', "");
    Expect(1, 7167, '\P{^Is_Block= -BATAK}', "");
    Expect(0, 7168, '\p{Is_Block= -BATAK}', "");
    Expect(1, 7168, '\p{^Is_Block= -BATAK}', "");
    Expect(1, 7168, '\P{Is_Block= -BATAK}', "");
    Expect(0, 7168, '\P{^Is_Block= -BATAK}', "");
    Error('\p{Is_Blk=-:=batak}');
    Error('\P{Is_Blk=-:=batak}');
    Expect(1, 7167, '\p{Is_Blk=batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=batak}', "");
    Expect(0, 7167, '\P{Is_Blk=batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=batak}', "");
    Expect(0, 7168, '\p{Is_Blk=batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=batak}', "");
    Expect(1, 7168, '\P{Is_Blk=batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=batak}', "");
    Expect(1, 7167, '\p{Is_Blk=-_Batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=-_Batak}', "");
    Expect(0, 7167, '\P{Is_Blk=-_Batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=-_Batak}', "");
    Expect(0, 7168, '\p{Is_Blk=-_Batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=-_Batak}', "");
    Expect(1, 7168, '\P{Is_Blk=-_Batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=-_Batak}', "");
    Error('\p{Block=-_BENGALI:=}');
    Error('\P{Block=-_BENGALI:=}');
    Expect(1, 2559, '\p{Block=bengali}', "");
    Expect(0, 2559, '\p{^Block=bengali}', "");
    Expect(0, 2559, '\P{Block=bengali}', "");
    Expect(1, 2559, '\P{^Block=bengali}', "");
    Expect(0, 2560, '\p{Block=bengali}', "");
    Expect(1, 2560, '\p{^Block=bengali}', "");
    Expect(1, 2560, '\P{Block=bengali}', "");
    Expect(0, 2560, '\P{^Block=bengali}', "");
    Expect(1, 2559, '\p{Block=-_BENGALI}', "");
    Expect(0, 2559, '\p{^Block=-_BENGALI}', "");
    Expect(0, 2559, '\P{Block=-_BENGALI}', "");
    Expect(1, 2559, '\P{^Block=-_BENGALI}', "");
    Expect(0, 2560, '\p{Block=-_BENGALI}', "");
    Expect(1, 2560, '\p{^Block=-_BENGALI}', "");
    Expect(1, 2560, '\P{Block=-_BENGALI}', "");
    Expect(0, 2560, '\P{^Block=-_BENGALI}', "");
    Error('\p{Blk=__BENGALI/a/}');
    Error('\P{Blk=__BENGALI/a/}');
    Expect(1, 2559, '\p{Blk=bengali}', "");
    Expect(0, 2559, '\p{^Blk=bengali}', "");
    Expect(0, 2559, '\P{Blk=bengali}', "");
    Expect(1, 2559, '\P{^Blk=bengali}', "");
    Expect(0, 2560, '\p{Blk=bengali}', "");
    Expect(1, 2560, '\p{^Blk=bengali}', "");
    Expect(1, 2560, '\P{Blk=bengali}', "");
    Expect(0, 2560, '\P{^Blk=bengali}', "");
    Expect(1, 2559, '\p{Blk=_	BENGALI}', "");
    Expect(0, 2559, '\p{^Blk=_	BENGALI}', "");
    Expect(0, 2559, '\P{Blk=_	BENGALI}', "");
    Expect(1, 2559, '\P{^Blk=_	BENGALI}', "");
    Expect(0, 2560, '\p{Blk=_	BENGALI}', "");
    Expect(1, 2560, '\p{^Blk=_	BENGALI}', "");
    Expect(1, 2560, '\P{Blk=_	BENGALI}', "");
    Expect(0, 2560, '\P{^Blk=_	BENGALI}', "");
    Error('\p{Is_Block=/a/ _Bengali}');
    Error('\P{Is_Block=/a/ _Bengali}');
    Expect(1, 2559, '\p{Is_Block=bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=bengali}', "");
    Expect(0, 2559, '\P{Is_Block=bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=bengali}', "");
    Expect(0, 2560, '\p{Is_Block=bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=bengali}', "");
    Expect(1, 2560, '\P{Is_Block=bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=bengali}', "");
    Expect(1, 2559, '\p{Is_Block=-Bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=-Bengali}', "");
    Expect(0, 2559, '\P{Is_Block=-Bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=-Bengali}', "");
    Expect(0, 2560, '\p{Is_Block=-Bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=-Bengali}', "");
    Expect(1, 2560, '\P{Is_Block=-Bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=-Bengali}', "");
    Error('\p{Is_Blk=:=_bengali}');
    Error('\P{Is_Blk=:=_bengali}');
    Expect(1, 2559, '\p{Is_Blk:	bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk:	bengali}', "");
    Expect(0, 2559, '\P{Is_Blk:	bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk:	bengali}', "");
    Expect(0, 2560, '\p{Is_Blk:	bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk:	bengali}', "");
    Expect(1, 2560, '\P{Is_Blk:	bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk:	bengali}', "");
    Expect(1, 2559, '\p{Is_Blk:  Bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk:  Bengali}', "");
    Expect(0, 2559, '\P{Is_Blk:  Bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk:  Bengali}', "");
    Expect(0, 2560, '\p{Is_Blk:  Bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk:  Bengali}', "");
    Expect(1, 2560, '\P{Is_Blk:  Bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk:  Bengali}', "");
    Error('\p{Block=/a/  Bhaiksuki}');
    Error('\P{Block=/a/  Bhaiksuki}');
    Expect(1, 72815, '\p{Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Block= bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block= bhaiksuki}', "");
    Expect(0, 72815, '\P{Block= bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block= bhaiksuki}', "");
    Expect(0, 72816, '\p{Block= bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block= bhaiksuki}', "");
    Expect(1, 72816, '\P{Block= bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block= bhaiksuki}', "");
    Error('\p{Blk=:=		bhaiksuki}');
    Error('\P{Blk=:=		bhaiksuki}');
    Expect(1, 72815, '\p{Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Blk= Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk= Bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk= Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk= Bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk= Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk= Bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk= Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk= Bhaiksuki}', "");
    Error('\p{Is_Block= /a/bhaiksuki}');
    Error('\P{Is_Block= /a/bhaiksuki}');
    Expect(1, 72815, '\p{Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Block= BHAIKSUKI}', "");
    Expect(0, 72815, '\p{^Is_Block= BHAIKSUKI}', "");
    Expect(0, 72815, '\P{Is_Block= BHAIKSUKI}', "");
    Expect(1, 72815, '\P{^Is_Block= BHAIKSUKI}', "");
    Expect(0, 72816, '\p{Is_Block= BHAIKSUKI}', "");
    Expect(1, 72816, '\p{^Is_Block= BHAIKSUKI}', "");
    Expect(1, 72816, '\P{Is_Block= BHAIKSUKI}', "");
    Expect(0, 72816, '\P{^Is_Block= BHAIKSUKI}', "");
    Error('\p{Is_Blk=:= 	Bhaiksuki}');
    Error('\P{Is_Blk=:= 	Bhaiksuki}');
    Expect(1, 72815, '\p{Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Blk=_-BHAIKSUKI}', "");
    Expect(0, 72815, '\p{^Is_Blk=_-BHAIKSUKI}', "");
    Expect(0, 72815, '\P{Is_Blk=_-BHAIKSUKI}', "");
    Expect(1, 72815, '\P{^Is_Blk=_-BHAIKSUKI}', "");
    Expect(0, 72816, '\p{Is_Blk=_-BHAIKSUKI}', "");
    Expect(1, 72816, '\p{^Is_Blk=_-BHAIKSUKI}', "");
    Expect(1, 72816, '\P{Is_Blk=_-BHAIKSUKI}', "");
    Expect(0, 72816, '\P{^Is_Blk=_-BHAIKSUKI}', "");
    Error('\p{Block: /a/	-Block_Elements}');
    Error('\P{Block: /a/	-Block_Elements}');
    Expect(1, 9631, '\p{Block=blockelements}', "");
    Expect(0, 9631, '\p{^Block=blockelements}', "");
    Expect(0, 9631, '\P{Block=blockelements}', "");
    Expect(1, 9631, '\P{^Block=blockelements}', "");
    Expect(0, 9632, '\p{Block=blockelements}', "");
    Expect(1, 9632, '\p{^Block=blockelements}', "");
    Expect(1, 9632, '\P{Block=blockelements}', "");
    Expect(0, 9632, '\P{^Block=blockelements}', "");
    Expect(1, 9631, '\p{Block=block_elements}', "");
    Expect(0, 9631, '\p{^Block=block_elements}', "");
    Expect(0, 9631, '\P{Block=block_elements}', "");
    Expect(1, 9631, '\P{^Block=block_elements}', "");
    Expect(0, 9632, '\p{Block=block_elements}', "");
    Expect(1, 9632, '\p{^Block=block_elements}', "");
    Expect(1, 9632, '\P{Block=block_elements}', "");
    Expect(0, 9632, '\P{^Block=block_elements}', "");
    Error('\p{Blk= :=Block_Elements}');
    Error('\P{Blk= :=Block_Elements}');
    Expect(1, 9631, '\p{Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Blk=blockelements}', "");
    Expect(0, 9631, '\P{Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Blk=blockelements}', "");
    Expect(0, 9632, '\p{Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Blk=blockelements}', "");
    Expect(1, 9632, '\P{Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Blk=blockelements}', "");
    Expect(1, 9631, '\p{Blk=		block_elements}', "");
    Expect(0, 9631, '\p{^Blk=		block_elements}', "");
    Expect(0, 9631, '\P{Blk=		block_elements}', "");
    Expect(1, 9631, '\P{^Blk=		block_elements}', "");
    Expect(0, 9632, '\p{Blk=		block_elements}', "");
    Expect(1, 9632, '\p{^Blk=		block_elements}', "");
    Expect(1, 9632, '\P{Blk=		block_elements}', "");
    Expect(0, 9632, '\P{^Blk=		block_elements}', "");
    Error('\p{Is_Block= /a/BLOCK_elements}');
    Error('\P{Is_Block= /a/BLOCK_elements}');
    Expect(1, 9631, '\p{Is_Block=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
    Expect(0, 9631, '\P{Is_Block=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
    Expect(0, 9632, '\p{Is_Block=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
    Expect(1, 9632, '\P{Is_Block=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
    Expect(1, 9631, '\p{Is_Block=-_Block_elements}', "");
    Expect(0, 9631, '\p{^Is_Block=-_Block_elements}', "");
    Expect(0, 9631, '\P{Is_Block=-_Block_elements}', "");
    Expect(1, 9631, '\P{^Is_Block=-_Block_elements}', "");
    Expect(0, 9632, '\p{Is_Block=-_Block_elements}', "");
    Expect(1, 9632, '\p{^Is_Block=-_Block_elements}', "");
    Expect(1, 9632, '\P{Is_Block=-_Block_elements}', "");
    Expect(0, 9632, '\P{^Is_Block=-_Block_elements}', "");
    Error('\p{Is_Blk=/a/_-Block_elements}');
    Error('\P{Is_Blk=/a/_-Block_elements}');
    Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
    Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
    Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
    Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
    Expect(1, 9631, '\p{Is_Blk= block_ELEMENTS}', "");
    Expect(0, 9631, '\p{^Is_Blk= block_ELEMENTS}', "");
    Expect(0, 9631, '\P{Is_Blk= block_ELEMENTS}', "");
    Expect(1, 9631, '\P{^Is_Blk= block_ELEMENTS}', "");
    Expect(0, 9632, '\p{Is_Blk= block_ELEMENTS}', "");
    Expect(1, 9632, '\p{^Is_Blk= block_ELEMENTS}', "");
    Expect(1, 9632, '\P{Is_Blk= block_ELEMENTS}', "");
    Expect(0, 9632, '\P{^Is_Blk= block_ELEMENTS}', "");
    Error('\p{Block=	/a/Bopomofo}');
    Error('\P{Block=	/a/Bopomofo}');
    Expect(1, 12591, '\p{Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Block=bopomofo}', "");
    Expect(0, 12591, '\P{Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Block=bopomofo}', "");
    Expect(0, 12592, '\p{Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Block=bopomofo}', "");
    Expect(1, 12592, '\P{Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Block=bopomofo}', "");
    Expect(1, 12591, '\p{Block=__bopomofo}', "");
    Expect(0, 12591, '\p{^Block=__bopomofo}', "");
    Expect(0, 12591, '\P{Block=__bopomofo}', "");
    Expect(1, 12591, '\P{^Block=__bopomofo}', "");
    Expect(0, 12592, '\p{Block=__bopomofo}', "");
    Expect(1, 12592, '\p{^Block=__bopomofo}', "");
    Expect(1, 12592, '\P{Block=__bopomofo}', "");
    Expect(0, 12592, '\P{^Block=__bopomofo}', "");
    Error('\p{Blk=_/a/Bopomofo}');
    Error('\P{Blk=_/a/Bopomofo}');
    Expect(1, 12591, '\p{Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Blk=_	Bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=_	Bopomofo}', "");
    Expect(0, 12591, '\P{Blk=_	Bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=_	Bopomofo}', "");
    Expect(0, 12592, '\p{Blk=_	Bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=_	Bopomofo}', "");
    Expect(1, 12592, '\P{Blk=_	Bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=_	Bopomofo}', "");
    Error('\p{Is_Block=:=	-bopomofo}');
    Error('\P{Is_Block=:=	-bopomofo}');
    Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Block=-	BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Is_Block=-	BOPOMOFO}', "");
    Expect(0, 12591, '\P{Is_Block=-	BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Is_Block=-	BOPOMOFO}', "");
    Expect(0, 12592, '\p{Is_Block=-	BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Is_Block=-	BOPOMOFO}', "");
    Expect(1, 12592, '\P{Is_Block=-	BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Is_Block=-	BOPOMOFO}', "");
    Error('\p{Is_Blk:   -/a/Bopomofo}');
    Error('\P{Is_Blk:   -/a/Bopomofo}');
    Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Blk= -BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Is_Blk= -BOPOMOFO}', "");
    Expect(0, 12591, '\P{Is_Blk= -BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Is_Blk= -BOPOMOFO}', "");
    Expect(0, 12592, '\p{Is_Blk= -BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Is_Blk= -BOPOMOFO}', "");
    Expect(1, 12592, '\P{Is_Blk= -BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Is_Blk= -BOPOMOFO}', "");
    Error('\p{Block=/a/Bopomofo_Extended}');
    Error('\P{Block=/a/Bopomofo_Extended}');
    Expect(1, 12735, '\p{Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Block=		Bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Block=		Bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Block=		Bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Block=		Bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Block=		Bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Block=		Bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Block=		Bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Block=		Bopomofo_Extended}', "");
    Error('\p{Blk=- BOPOMOFO_EXT/a/}');
    Error('\P{Blk=- BOPOMOFO_EXT/a/}');
    Expect(1, 12735, '\p{Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Blk=-	Bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Blk=-	Bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Blk=-	Bopomofo_Ext}', "");
    Error('\p{Is_Block=:=_BOPOMOFO_Extended}');
    Error('\P{Is_Block=:=_BOPOMOFO_Extended}');
    Expect(1, 12735, '\p{Is_Block:   bopomofoextended}', "");
    Expect(0, 12735, '\p{^Is_Block:   bopomofoextended}', "");
    Expect(0, 12735, '\P{Is_Block:   bopomofoextended}', "");
    Expect(1, 12735, '\P{^Is_Block:   bopomofoextended}', "");
    Expect(0, 12736, '\p{Is_Block:   bopomofoextended}', "");
    Expect(1, 12736, '\p{^Is_Block:   bopomofoextended}', "");
    Expect(1, 12736, '\P{Is_Block:   bopomofoextended}', "");
    Expect(0, 12736, '\P{^Is_Block:   bopomofoextended}', "");
    Expect(1, 12735, '\p{Is_Block=- bopomofo_EXTENDED}', "");
    Expect(0, 12735, '\p{^Is_Block=- bopomofo_EXTENDED}', "");
    Expect(0, 12735, '\P{Is_Block=- bopomofo_EXTENDED}', "");
    Expect(1, 12735, '\P{^Is_Block=- bopomofo_EXTENDED}', "");
    Expect(0, 12736, '\p{Is_Block=- bopomofo_EXTENDED}', "");
    Expect(1, 12736, '\p{^Is_Block=- bopomofo_EXTENDED}', "");
    Expect(1, 12736, '\P{Is_Block=- bopomofo_EXTENDED}', "");
    Expect(0, 12736, '\P{^Is_Block=- bopomofo_EXTENDED}', "");
    Error('\p{Is_Blk=-/a/Bopomofo_Ext}');
    Error('\P{Is_Blk=-/a/Bopomofo_Ext}');
    Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Is_Blk=-Bopomofo_EXT}', "");
    Expect(0, 12735, '\p{^Is_Blk=-Bopomofo_EXT}', "");
    Expect(0, 12735, '\P{Is_Blk=-Bopomofo_EXT}', "");
    Expect(1, 12735, '\P{^Is_Blk=-Bopomofo_EXT}', "");
    Expect(0, 12736, '\p{Is_Blk=-Bopomofo_EXT}', "");
    Expect(1, 12736, '\p{^Is_Blk=-Bopomofo_EXT}', "");
    Expect(1, 12736, '\P{Is_Blk=-Bopomofo_EXT}', "");
    Expect(0, 12736, '\P{^Is_Blk=-Bopomofo_EXT}', "");
    Error('\p{Block=Box_Drawing/a/}');
    Error('\P{Block=Box_Drawing/a/}');
    Expect(1, 9599, '\p{Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Block=_Box_Drawing}', "");
    Expect(0, 9599, '\p{^Block=_Box_Drawing}', "");
    Expect(0, 9599, '\P{Block=_Box_Drawing}', "");
    Expect(1, 9599, '\P{^Block=_Box_Drawing}', "");
    Expect(0, 9600, '\p{Block=_Box_Drawing}', "");
    Expect(1, 9600, '\p{^Block=_Box_Drawing}', "");
    Expect(1, 9600, '\P{Block=_Box_Drawing}', "");
    Expect(0, 9600, '\P{^Block=_Box_Drawing}', "");
    Error('\p{Blk=_Box_DRAWING:=}');
    Error('\P{Blk=_Box_DRAWING:=}');
    Expect(1, 9599, '\p{Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Blk:-_Box_Drawing}', "");
    Expect(0, 9599, '\p{^Blk:-_Box_Drawing}', "");
    Expect(0, 9599, '\P{Blk:-_Box_Drawing}', "");
    Expect(1, 9599, '\P{^Blk:-_Box_Drawing}', "");
    Expect(0, 9600, '\p{Blk:-_Box_Drawing}', "");
    Expect(1, 9600, '\p{^Blk:-_Box_Drawing}', "");
    Expect(1, 9600, '\P{Blk:-_Box_Drawing}', "");
    Expect(0, 9600, '\P{^Blk:-_Box_Drawing}', "");
    Error('\p{Is_Block= 	box_drawing:=}');
    Error('\P{Is_Block= 	box_drawing:=}');
    Expect(1, 9599, '\p{Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Block:--BOX_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Block:--BOX_Drawing}', "");
    Expect(0, 9599, '\P{Is_Block:--BOX_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Block:--BOX_Drawing}', "");
    Expect(0, 9600, '\p{Is_Block:--BOX_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Block:--BOX_Drawing}', "");
    Expect(1, 9600, '\P{Is_Block:--BOX_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Block:--BOX_Drawing}', "");
    Error('\p{Is_Blk= -Box_drawing/a/}');
    Error('\P{Is_Blk= -Box_drawing/a/}');
    Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Blk=	_box_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=	_box_Drawing}', "");
    Expect(0, 9599, '\P{Is_Blk=	_box_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=	_box_Drawing}', "");
    Expect(0, 9600, '\p{Is_Blk=	_box_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=	_box_Drawing}', "");
    Expect(1, 9600, '\P{Is_Blk=	_box_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=	_box_Drawing}', "");
    Error('\p{Block=-:=Brahmi}');
    Error('\P{Block=-:=Brahmi}');
    Expect(1, 69759, '\p{Block=brahmi}', "");
    Expect(0, 69759, '\p{^Block=brahmi}', "");
    Expect(0, 69759, '\P{Block=brahmi}', "");
    Expect(1, 69759, '\P{^Block=brahmi}', "");
    Expect(0, 69760, '\p{Block=brahmi}', "");
    Expect(1, 69760, '\p{^Block=brahmi}', "");
    Expect(1, 69760, '\P{Block=brahmi}', "");
    Expect(0, 69760, '\P{^Block=brahmi}', "");
    Expect(1, 69759, '\p{Block=	BRAHMI}', "");
    Expect(0, 69759, '\p{^Block=	BRAHMI}', "");
    Expect(0, 69759, '\P{Block=	BRAHMI}', "");
    Expect(1, 69759, '\P{^Block=	BRAHMI}', "");
    Expect(0, 69760, '\p{Block=	BRAHMI}', "");
    Expect(1, 69760, '\p{^Block=	BRAHMI}', "");
    Expect(1, 69760, '\P{Block=	BRAHMI}', "");
    Expect(0, 69760, '\P{^Block=	BRAHMI}', "");
    Error('\p{Blk:   /a/ Brahmi}');
    Error('\P{Blk:   /a/ Brahmi}');
    Expect(1, 69759, '\p{Blk:brahmi}', "");
    Expect(0, 69759, '\p{^Blk:brahmi}', "");
    Expect(0, 69759, '\P{Blk:brahmi}', "");
    Expect(1, 69759, '\P{^Blk:brahmi}', "");
    Expect(0, 69760, '\p{Blk:brahmi}', "");
    Expect(1, 69760, '\p{^Blk:brahmi}', "");
    Expect(1, 69760, '\P{Blk:brahmi}', "");
    Expect(0, 69760, '\P{^Blk:brahmi}', "");
    Expect(1, 69759, '\p{Blk=	BRAHMI}', "");
    Expect(0, 69759, '\p{^Blk=	BRAHMI}', "");
    Expect(0, 69759, '\P{Blk=	BRAHMI}', "");
    Expect(1, 69759, '\P{^Blk=	BRAHMI}', "");
    Expect(0, 69760, '\p{Blk=	BRAHMI}', "");
    Expect(1, 69760, '\p{^Blk=	BRAHMI}', "");
    Expect(1, 69760, '\P{Blk=	BRAHMI}', "");
    Expect(0, 69760, '\P{^Blk=	BRAHMI}', "");
    Error('\p{Is_Block=-/a/Brahmi}');
    Error('\P{Is_Block=-/a/Brahmi}');
    Expect(1, 69759, '\p{Is_Block=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
    Expect(1, 69759, '\p{Is_Block=-BRAHMI}', "");
    Expect(0, 69759, '\p{^Is_Block=-BRAHMI}', "");
    Expect(0, 69759, '\P{Is_Block=-BRAHMI}', "");
    Expect(1, 69759, '\P{^Is_Block=-BRAHMI}', "");
    Expect(0, 69760, '\p{Is_Block=-BRAHMI}', "");
    Expect(1, 69760, '\p{^Is_Block=-BRAHMI}', "");
    Expect(1, 69760, '\P{Is_Block=-BRAHMI}', "");
    Expect(0, 69760, '\P{^Is_Block=-BRAHMI}', "");
    Error('\p{Is_Blk=/a/Brahmi}');
    Error('\P{Is_Blk=/a/Brahmi}');
    Expect(1, 69759, '\p{Is_Blk:brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk:brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk:brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk:brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk:brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk:brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk:brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk:brahmi}', "");
    Expect(1, 69759, '\p{Is_Blk=_ brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=_ brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=_ brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=_ brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=_ brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=_ brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=_ brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=_ brahmi}', "");
    Error('\p{Block=:=-	braille_patterns}');
    Error('\P{Block=:=-	braille_patterns}');
    Expect(1, 10495, '\p{Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Block=_braille_Patterns}', "");
    Expect(0, 10495, '\p{^Block=_braille_Patterns}', "");
    Expect(0, 10495, '\P{Block=_braille_Patterns}', "");
    Expect(1, 10495, '\P{^Block=_braille_Patterns}', "");
    Expect(0, 10496, '\p{Block=_braille_Patterns}', "");
    Expect(1, 10496, '\p{^Block=_braille_Patterns}', "");
    Expect(1, 10496, '\P{Block=_braille_Patterns}', "");
    Expect(0, 10496, '\P{^Block=_braille_Patterns}', "");
    Error('\p{Blk=:=Braille}');
    Error('\P{Blk=:=Braille}');
    Expect(1, 10495, '\p{Blk=braille}', "");
    Expect(0, 10495, '\p{^Blk=braille}', "");
    Expect(0, 10495, '\P{Blk=braille}', "");
    Expect(1, 10495, '\P{^Blk=braille}', "");
    Expect(0, 10496, '\p{Blk=braille}', "");
    Expect(1, 10496, '\p{^Blk=braille}', "");
    Expect(1, 10496, '\P{Blk=braille}', "");
    Expect(0, 10496, '\P{^Blk=braille}', "");
    Expect(1, 10495, '\p{Blk=		Braille}', "");
    Expect(0, 10495, '\p{^Blk=		Braille}', "");
    Expect(0, 10495, '\P{Blk=		Braille}', "");
    Expect(1, 10495, '\P{^Blk=		Braille}', "");
    Expect(0, 10496, '\p{Blk=		Braille}', "");
    Expect(1, 10496, '\p{^Blk=		Braille}', "");
    Expect(1, 10496, '\P{Blk=		Braille}', "");
    Expect(0, 10496, '\P{^Blk=		Braille}', "");
    Error('\p{Is_Block=__braille_Patterns:=}');
    Error('\P{Is_Block=__braille_Patterns:=}');
    Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Is_Block= BRAILLE_Patterns}', "");
    Expect(0, 10495, '\p{^Is_Block= BRAILLE_Patterns}', "");
    Expect(0, 10495, '\P{Is_Block= BRAILLE_Patterns}', "");
    Expect(1, 10495, '\P{^Is_Block= BRAILLE_Patterns}', "");
    Expect(0, 10496, '\p{Is_Block= BRAILLE_Patterns}', "");
    Expect(1, 10496, '\p{^Is_Block= BRAILLE_Patterns}', "");
    Expect(1, 10496, '\P{Is_Block= BRAILLE_Patterns}', "");
    Expect(0, 10496, '\P{^Is_Block= BRAILLE_Patterns}', "");
    Error('\p{Is_Blk: --Braille/a/}');
    Error('\P{Is_Blk: --Braille/a/}');
    Expect(1, 10495, '\p{Is_Blk=braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=braille}', "");
    Expect(0, 10495, '\P{Is_Blk=braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=braille}', "");
    Expect(0, 10496, '\p{Is_Blk=braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=braille}', "");
    Expect(1, 10496, '\P{Is_Blk=braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=braille}', "");
    Expect(1, 10495, '\p{Is_Blk=_BRAILLE}', "");
    Expect(0, 10495, '\p{^Is_Blk=_BRAILLE}', "");
    Expect(0, 10495, '\P{Is_Blk=_BRAILLE}', "");
    Expect(1, 10495, '\P{^Is_Blk=_BRAILLE}', "");
    Expect(0, 10496, '\p{Is_Blk=_BRAILLE}', "");
    Expect(1, 10496, '\p{^Is_Blk=_BRAILLE}', "");
    Expect(1, 10496, '\P{Is_Blk=_BRAILLE}', "");
    Expect(0, 10496, '\P{^Is_Blk=_BRAILLE}', "");
    Error('\p{Block=_/a/buginese}');
    Error('\P{Block=_/a/buginese}');
    Expect(1, 6687, '\p{Block:buginese}', "");
    Expect(0, 6687, '\p{^Block:buginese}', "");
    Expect(0, 6687, '\P{Block:buginese}', "");
    Expect(1, 6687, '\P{^Block:buginese}', "");
    Expect(0, 6688, '\p{Block:buginese}', "");
    Expect(1, 6688, '\p{^Block:buginese}', "");
    Expect(1, 6688, '\P{Block:buginese}', "");
    Expect(0, 6688, '\P{^Block:buginese}', "");
    Expect(1, 6687, '\p{Block:   	Buginese}', "");
    Expect(0, 6687, '\p{^Block:   	Buginese}', "");
    Expect(0, 6687, '\P{Block:   	Buginese}', "");
    Expect(1, 6687, '\P{^Block:   	Buginese}', "");
    Expect(0, 6688, '\p{Block:   	Buginese}', "");
    Expect(1, 6688, '\p{^Block:   	Buginese}', "");
    Expect(1, 6688, '\P{Block:   	Buginese}', "");
    Expect(0, 6688, '\P{^Block:   	Buginese}', "");
    Error('\p{Blk=_BUGINESE:=}');
    Error('\P{Blk=_BUGINESE:=}');
    Expect(1, 6687, '\p{Blk=buginese}', "");
    Expect(0, 6687, '\p{^Blk=buginese}', "");
    Expect(0, 6687, '\P{Blk=buginese}', "");
    Expect(1, 6687, '\P{^Blk=buginese}', "");
    Expect(0, 6688, '\p{Blk=buginese}', "");
    Expect(1, 6688, '\p{^Blk=buginese}', "");
    Expect(1, 6688, '\P{Blk=buginese}', "");
    Expect(0, 6688, '\P{^Blk=buginese}', "");
    Expect(1, 6687, '\p{Blk=	BUGINESE}', "");
    Expect(0, 6687, '\p{^Blk=	BUGINESE}', "");
    Expect(0, 6687, '\P{Blk=	BUGINESE}', "");
    Expect(1, 6687, '\P{^Blk=	BUGINESE}', "");
    Expect(0, 6688, '\p{Blk=	BUGINESE}', "");
    Expect(1, 6688, '\p{^Blk=	BUGINESE}', "");
    Expect(1, 6688, '\P{Blk=	BUGINESE}', "");
    Expect(0, 6688, '\P{^Blk=	BUGINESE}', "");
    Error('\p{Is_Block:   	BUGINESE/a/}');
    Error('\P{Is_Block:   	BUGINESE/a/}');
    Expect(1, 6687, '\p{Is_Block: buginese}', "");
    Expect(0, 6687, '\p{^Is_Block: buginese}', "");
    Expect(0, 6687, '\P{Is_Block: buginese}', "");
    Expect(1, 6687, '\P{^Is_Block: buginese}', "");
    Expect(0, 6688, '\p{Is_Block: buginese}', "");
    Expect(1, 6688, '\p{^Is_Block: buginese}', "");
    Expect(1, 6688, '\P{Is_Block: buginese}', "");
    Expect(0, 6688, '\P{^Is_Block: buginese}', "");
    Expect(1, 6687, '\p{Is_Block=	buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=	buginese}', "");
    Expect(0, 6687, '\P{Is_Block=	buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=	buginese}', "");
    Expect(0, 6688, '\p{Is_Block=	buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=	buginese}', "");
    Expect(1, 6688, '\P{Is_Block=	buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=	buginese}', "");
    Error('\p{Is_Blk=:=-_Buginese}');
    Error('\P{Is_Blk=:=-_Buginese}');
    Expect(1, 6687, '\p{Is_Blk=buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
    Expect(1, 6687, '\p{Is_Blk: _ Buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk: _ Buginese}', "");
    Expect(0, 6687, '\P{Is_Blk: _ Buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk: _ Buginese}', "");
    Expect(0, 6688, '\p{Is_Blk: _ Buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk: _ Buginese}', "");
    Expect(1, 6688, '\P{Is_Blk: _ Buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk: _ Buginese}', "");
    Error('\p{Block=:=_-Buhid}');
    Error('\P{Block=:=_-Buhid}');
    Expect(1, 5983, '\p{Block=buhid}', "");
    Expect(0, 5983, '\p{^Block=buhid}', "");
    Expect(0, 5983, '\P{Block=buhid}', "");
    Expect(1, 5983, '\P{^Block=buhid}', "");
    Expect(0, 5984, '\p{Block=buhid}', "");
    Expect(1, 5984, '\p{^Block=buhid}', "");
    Expect(1, 5984, '\P{Block=buhid}', "");
    Expect(0, 5984, '\P{^Block=buhid}', "");
    Expect(1, 5983, '\p{Block=- Buhid}', "");
    Expect(0, 5983, '\p{^Block=- Buhid}', "");
    Expect(0, 5983, '\P{Block=- Buhid}', "");
    Expect(1, 5983, '\P{^Block=- Buhid}', "");
    Expect(0, 5984, '\p{Block=- Buhid}', "");
    Expect(1, 5984, '\p{^Block=- Buhid}', "");
    Expect(1, 5984, '\P{Block=- Buhid}', "");
    Expect(0, 5984, '\P{^Block=- Buhid}', "");
    Error('\p{Blk: _ buhid/a/}');
    Error('\P{Blk: _ buhid/a/}');
    Expect(1, 5983, '\p{Blk=buhid}', "");
    Expect(0, 5983, '\p{^Blk=buhid}', "");
    Expect(0, 5983, '\P{Blk=buhid}', "");
    Expect(1, 5983, '\P{^Blk=buhid}', "");
    Expect(0, 5984, '\p{Blk=buhid}', "");
    Expect(1, 5984, '\p{^Blk=buhid}', "");
    Expect(1, 5984, '\P{Blk=buhid}', "");
    Expect(0, 5984, '\P{^Blk=buhid}', "");
    Expect(1, 5983, '\p{Blk=-	buhid}', "");
    Expect(0, 5983, '\p{^Blk=-	buhid}', "");
    Expect(0, 5983, '\P{Blk=-	buhid}', "");
    Expect(1, 5983, '\P{^Blk=-	buhid}', "");
    Expect(0, 5984, '\p{Blk=-	buhid}', "");
    Expect(1, 5984, '\p{^Blk=-	buhid}', "");
    Expect(1, 5984, '\P{Blk=-	buhid}', "");
    Expect(0, 5984, '\P{^Blk=-	buhid}', "");
    Error('\p{Is_Block=		buhid/a/}');
    Error('\P{Is_Block=		buhid/a/}');
    Expect(1, 5983, '\p{Is_Block=buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=buhid}', "");
    Expect(0, 5983, '\P{Is_Block=buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=buhid}', "");
    Expect(0, 5984, '\p{Is_Block=buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=buhid}', "");
    Expect(1, 5984, '\P{Is_Block=buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=buhid}', "");
    Expect(1, 5983, '\p{Is_Block=		BUHID}', "");
    Expect(0, 5983, '\p{^Is_Block=		BUHID}', "");
    Expect(0, 5983, '\P{Is_Block=		BUHID}', "");
    Expect(1, 5983, '\P{^Is_Block=		BUHID}', "");
    Expect(0, 5984, '\p{Is_Block=		BUHID}', "");
    Expect(1, 5984, '\p{^Is_Block=		BUHID}', "");
    Expect(1, 5984, '\P{Is_Block=		BUHID}', "");
    Expect(0, 5984, '\P{^Is_Block=		BUHID}', "");
    Error('\p{Is_Blk:_-buhid:=}');
    Error('\P{Is_Blk:_-buhid:=}');
    Expect(1, 5983, '\p{Is_Blk=buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
    Expect(1, 5983, '\p{Is_Blk= BUHID}', "");
    Expect(0, 5983, '\p{^Is_Blk= BUHID}', "");
    Expect(0, 5983, '\P{Is_Blk= BUHID}', "");
    Expect(1, 5983, '\P{^Is_Blk= BUHID}', "");
    Expect(0, 5984, '\p{Is_Blk= BUHID}', "");
    Expect(1, 5984, '\p{^Is_Blk= BUHID}', "");
    Expect(1, 5984, '\P{Is_Blk= BUHID}', "");
    Expect(0, 5984, '\P{^Is_Blk= BUHID}', "");
    Error('\p{Block=:=-_BYZANTINE_Musical_Symbols}');
    Error('\P{Block=:=-_BYZANTINE_Musical_Symbols}');
    Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Block= Byzantine_Musical_symbols}', "");
    Expect(0, 119039, '\p{^Block= Byzantine_Musical_symbols}', "");
    Expect(0, 119039, '\P{Block= Byzantine_Musical_symbols}', "");
    Expect(1, 119039, '\P{^Block= Byzantine_Musical_symbols}', "");
    Expect(0, 119040, '\p{Block= Byzantine_Musical_symbols}', "");
    Expect(1, 119040, '\p{^Block= Byzantine_Musical_symbols}', "");
    Expect(1, 119040, '\P{Block= Byzantine_Musical_symbols}', "");
    Expect(0, 119040, '\P{^Block= Byzantine_Musical_symbols}', "");
    Error('\p{Blk: :=BYZANTINE_Music}');
    Error('\P{Blk: :=BYZANTINE_Music}');
    Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Blk=-_byzantine_MUSIC}', "");
    Expect(0, 119039, '\p{^Blk=-_byzantine_MUSIC}', "");
    Expect(0, 119039, '\P{Blk=-_byzantine_MUSIC}', "");
    Expect(1, 119039, '\P{^Blk=-_byzantine_MUSIC}', "");
    Expect(0, 119040, '\p{Blk=-_byzantine_MUSIC}', "");
    Expect(1, 119040, '\p{^Blk=-_byzantine_MUSIC}', "");
    Expect(1, 119040, '\P{Blk=-_byzantine_MUSIC}', "");
    Expect(0, 119040, '\P{^Blk=-_byzantine_MUSIC}', "");
    Error('\p{Is_Block=/a/	Byzantine_Musical_symbols}');
    Error('\P{Is_Block=/a/	Byzantine_Musical_symbols}');
    Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\p{^Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\P{Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119039, '\P{^Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\p{Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\p{^Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\P{Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\P{^Is_Block=_	byzantine_Musical_SYMBOLS}', "");
    Error('\p{Is_Blk=_:=byzantine_MUSIC}');
    Error('\P{Is_Blk=_:=byzantine_MUSIC}');
    Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Is_Blk=	-Byzantine_Music}', "");
    Expect(0, 119039, '\p{^Is_Blk=	-Byzantine_Music}', "");
    Expect(0, 119039, '\P{Is_Blk=	-Byzantine_Music}', "");
    Expect(1, 119039, '\P{^Is_Blk=	-Byzantine_Music}', "");
    Expect(0, 119040, '\p{Is_Blk=	-Byzantine_Music}', "");
    Expect(1, 119040, '\p{^Is_Blk=	-Byzantine_Music}', "");
    Expect(1, 119040, '\P{Is_Blk=	-Byzantine_Music}', "");
    Expect(0, 119040, '\P{^Is_Blk=	-Byzantine_Music}', "");
    Error('\p{Block=--CARIAN:=}');
    Error('\P{Block=--CARIAN:=}');
    Expect(1, 66271, '\p{Block=carian}', "");
    Expect(0, 66271, '\p{^Block=carian}', "");
    Expect(0, 66271, '\P{Block=carian}', "");
    Expect(1, 66271, '\P{^Block=carian}', "");
    Expect(0, 66272, '\p{Block=carian}', "");
    Expect(1, 66272, '\p{^Block=carian}', "");
    Expect(1, 66272, '\P{Block=carian}', "");
    Expect(0, 66272, '\P{^Block=carian}', "");
    Expect(1, 66271, '\p{Block=		Carian}', "");
    Expect(0, 66271, '\p{^Block=		Carian}', "");
    Expect(0, 66271, '\P{Block=		Carian}', "");
    Expect(1, 66271, '\P{^Block=		Carian}', "");
    Expect(0, 66272, '\p{Block=		Carian}', "");
    Expect(1, 66272, '\p{^Block=		Carian}', "");
    Expect(1, 66272, '\P{Block=		Carian}', "");
    Expect(0, 66272, '\P{^Block=		Carian}', "");
    Error('\p{Blk:   /a/- carian}');
    Error('\P{Blk:   /a/- carian}');
    Expect(1, 66271, '\p{Blk=carian}', "");
    Expect(0, 66271, '\p{^Blk=carian}', "");
    Expect(0, 66271, '\P{Blk=carian}', "");
    Expect(1, 66271, '\P{^Blk=carian}', "");
    Expect(0, 66272, '\p{Blk=carian}', "");
    Expect(1, 66272, '\p{^Blk=carian}', "");
    Expect(1, 66272, '\P{Blk=carian}', "");
    Expect(0, 66272, '\P{^Blk=carian}', "");
    Expect(1, 66271, '\p{Blk=- CARIAN}', "");
    Expect(0, 66271, '\p{^Blk=- CARIAN}', "");
    Expect(0, 66271, '\P{Blk=- CARIAN}', "");
    Expect(1, 66271, '\P{^Blk=- CARIAN}', "");
    Expect(0, 66272, '\p{Blk=- CARIAN}', "");
    Expect(1, 66272, '\p{^Blk=- CARIAN}', "");
    Expect(1, 66272, '\P{Blk=- CARIAN}', "");
    Expect(0, 66272, '\P{^Blk=- CARIAN}', "");
    Error('\p{Is_Block=:=	Carian}');
    Error('\P{Is_Block=:=	Carian}');
    Expect(1, 66271, '\p{Is_Block: carian}', "");
    Expect(0, 66271, '\p{^Is_Block: carian}', "");
    Expect(0, 66271, '\P{Is_Block: carian}', "");
    Expect(1, 66271, '\P{^Is_Block: carian}', "");
    Expect(0, 66272, '\p{Is_Block: carian}', "");
    Expect(1, 66272, '\p{^Is_Block: carian}', "");
    Expect(1, 66272, '\P{Is_Block: carian}', "");
    Expect(0, 66272, '\P{^Is_Block: carian}', "");
    Expect(1, 66271, '\p{Is_Block=  Carian}', "");
    Expect(0, 66271, '\p{^Is_Block=  Carian}', "");
    Expect(0, 66271, '\P{Is_Block=  Carian}', "");
    Expect(1, 66271, '\P{^Is_Block=  Carian}', "");
    Expect(0, 66272, '\p{Is_Block=  Carian}', "");
    Expect(1, 66272, '\p{^Is_Block=  Carian}', "");
    Expect(1, 66272, '\P{Is_Block=  Carian}', "");
    Expect(0, 66272, '\P{^Is_Block=  Carian}', "");
    Error('\p{Is_Blk=:=	-Carian}');
    Error('\P{Is_Blk=:=	-Carian}');
    Expect(1, 66271, '\p{Is_Blk=carian}', "");
    Expect(0, 66271, '\p{^Is_Blk=carian}', "");
    Expect(0, 66271, '\P{Is_Blk=carian}', "");
    Expect(1, 66271, '\P{^Is_Blk=carian}', "");
    Expect(0, 66272, '\p{Is_Blk=carian}', "");
    Expect(1, 66272, '\p{^Is_Blk=carian}', "");
    Expect(1, 66272, '\P{Is_Blk=carian}', "");
    Expect(0, 66272, '\P{^Is_Blk=carian}', "");
    Expect(1, 66271, '\p{Is_Blk=_	CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Blk=_	CARIAN}', "");
    Expect(0, 66271, '\P{Is_Blk=_	CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Blk=_	CARIAN}', "");
    Expect(0, 66272, '\p{Is_Blk=_	CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Blk=_	CARIAN}', "");
    Expect(1, 66272, '\P{Is_Blk=_	CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Blk=_	CARIAN}', "");
    Error('\p{Block=-:=CAUCASIAN_Albanian}');
    Error('\P{Block=-:=CAUCASIAN_Albanian}');
    Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Block=_ caucasian_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Block=_ caucasian_ALBANIAN}', "");
    Expect(0, 66927, '\P{Block=_ caucasian_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Block=_ caucasian_ALBANIAN}', "");
    Expect(0, 66928, '\p{Block=_ caucasian_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Block=_ caucasian_ALBANIAN}', "");
    Expect(1, 66928, '\P{Block=_ caucasian_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Block=_ caucasian_ALBANIAN}', "");
    Error('\p{Blk:   :=		Caucasian_Albanian}');
    Error('\P{Blk:   :=		Caucasian_Albanian}');
    Expect(1, 66927, '\p{Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Blk=-_caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Blk=-_caucasian_albanian}', "");
    Expect(0, 66927, '\P{Blk=-_caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Blk=-_caucasian_albanian}', "");
    Expect(0, 66928, '\p{Blk=-_caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Blk=-_caucasian_albanian}', "");
    Expect(1, 66928, '\P{Blk=-_caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Blk=-_caucasian_albanian}', "");
    Error('\p{Is_Block=-:=caucasian_Albanian}');
    Error('\P{Is_Block=-:=caucasian_Albanian}');
    Expect(1, 66927, '\p{Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(0, 66927, '\P{Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(0, 66928, '\p{Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(1, 66928, '\P{Is_Block=	Caucasian_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Is_Block=	Caucasian_ALBANIAN}', "");
    Error('\p{Is_Blk=	:=caucasian_Albanian}');
    Error('\P{Is_Blk=	:=caucasian_Albanian}');
    Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(0, 66927, '\P{Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(0, 66928, '\p{Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(1, 66928, '\P{Is_Blk=-_CAUCASIAN_albanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=-_CAUCASIAN_albanian}', "");
    Error('\p{Block=_	Chakma:=}');
    Error('\P{Block=_	Chakma:=}');
    Expect(1, 69967, '\p{Block=chakma}', "");
    Expect(0, 69967, '\p{^Block=chakma}', "");
    Expect(0, 69967, '\P{Block=chakma}', "");
    Expect(1, 69967, '\P{^Block=chakma}', "");
    Expect(0, 69968, '\p{Block=chakma}', "");
    Expect(1, 69968, '\p{^Block=chakma}', "");
    Expect(1, 69968, '\P{Block=chakma}', "");
    Expect(0, 69968, '\P{^Block=chakma}', "");
    Expect(1, 69967, '\p{Block=_-chakma}', "");
    Expect(0, 69967, '\p{^Block=_-chakma}', "");
    Expect(0, 69967, '\P{Block=_-chakma}', "");
    Expect(1, 69967, '\P{^Block=_-chakma}', "");
    Expect(0, 69968, '\p{Block=_-chakma}', "");
    Expect(1, 69968, '\p{^Block=_-chakma}', "");
    Expect(1, 69968, '\P{Block=_-chakma}', "");
    Expect(0, 69968, '\P{^Block=_-chakma}', "");
    Error('\p{Blk=/a/_Chakma}');
    Error('\P{Blk=/a/_Chakma}');
    Expect(1, 69967, '\p{Blk=chakma}', "");
    Expect(0, 69967, '\p{^Blk=chakma}', "");
    Expect(0, 69967, '\P{Blk=chakma}', "");
    Expect(1, 69967, '\P{^Blk=chakma}', "");
    Expect(0, 69968, '\p{Blk=chakma}', "");
    Expect(1, 69968, '\p{^Blk=chakma}', "");
    Expect(1, 69968, '\P{Blk=chakma}', "");
    Expect(0, 69968, '\P{^Blk=chakma}', "");
    Expect(1, 69967, '\p{Blk=_-CHAKMA}', "");
    Expect(0, 69967, '\p{^Blk=_-CHAKMA}', "");
    Expect(0, 69967, '\P{Blk=_-CHAKMA}', "");
    Expect(1, 69967, '\P{^Blk=_-CHAKMA}', "");
    Expect(0, 69968, '\p{Blk=_-CHAKMA}', "");
    Expect(1, 69968, '\p{^Blk=_-CHAKMA}', "");
    Expect(1, 69968, '\P{Blk=_-CHAKMA}', "");
    Expect(0, 69968, '\P{^Blk=_-CHAKMA}', "");
    Error('\p{Is_Block=_:=CHAKMA}');
    Error('\P{Is_Block=_:=CHAKMA}');
    Expect(1, 69967, '\p{Is_Block=chakma}', "");
    Expect(0, 69967, '\p{^Is_Block=chakma}', "");
    Expect(0, 69967, '\P{Is_Block=chakma}', "");
    Expect(1, 69967, '\P{^Is_Block=chakma}', "");
    Expect(0, 69968, '\p{Is_Block=chakma}', "");
    Expect(1, 69968, '\p{^Is_Block=chakma}', "");
    Expect(1, 69968, '\P{Is_Block=chakma}', "");
    Expect(0, 69968, '\P{^Is_Block=chakma}', "");
    Expect(1, 69967, '\p{Is_Block: _	Chakma}', "");
    Expect(0, 69967, '\p{^Is_Block: _	Chakma}', "");
    Expect(0, 69967, '\P{Is_Block: _	Chakma}', "");
    Expect(1, 69967, '\P{^Is_Block: _	Chakma}', "");
    Expect(0, 69968, '\p{Is_Block: _	Chakma}', "");
    Expect(1, 69968, '\p{^Is_Block: _	Chakma}', "");
    Expect(1, 69968, '\P{Is_Block: _	Chakma}', "");
    Expect(0, 69968, '\P{^Is_Block: _	Chakma}', "");
    Error('\p{Is_Blk=-/a/CHAKMA}');
    Error('\P{Is_Blk=-/a/CHAKMA}');
    Expect(1, 69967, '\p{Is_Blk=chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
    Expect(1, 69967, '\p{Is_Blk:CHAKMA}', "");
    Expect(0, 69967, '\p{^Is_Blk:CHAKMA}', "");
    Expect(0, 69967, '\P{Is_Blk:CHAKMA}', "");
    Expect(1, 69967, '\P{^Is_Blk:CHAKMA}', "");
    Expect(0, 69968, '\p{Is_Blk:CHAKMA}', "");
    Expect(1, 69968, '\p{^Is_Blk:CHAKMA}', "");
    Expect(1, 69968, '\P{Is_Blk:CHAKMA}', "");
    Expect(0, 69968, '\P{^Is_Blk:CHAKMA}', "");
    Error('\p{Block: Cham:=}');
    Error('\P{Block: Cham:=}');
    Expect(1, 43615, '\p{Block=cham}', "");
    Expect(0, 43615, '\p{^Block=cham}', "");
    Expect(0, 43615, '\P{Block=cham}', "");
    Expect(1, 43615, '\P{^Block=cham}', "");
    Expect(0, 43616, '\p{Block=cham}', "");
    Expect(1, 43616, '\p{^Block=cham}', "");
    Expect(1, 43616, '\P{Block=cham}', "");
    Expect(0, 43616, '\P{^Block=cham}', "");
    Expect(1, 43615, '\p{Block=_-CHAM}', "");
    Expect(0, 43615, '\p{^Block=_-CHAM}', "");
    Expect(0, 43615, '\P{Block=_-CHAM}', "");
    Expect(1, 43615, '\P{^Block=_-CHAM}', "");
    Expect(0, 43616, '\p{Block=_-CHAM}', "");
    Expect(1, 43616, '\p{^Block=_-CHAM}', "");
    Expect(1, 43616, '\P{Block=_-CHAM}', "");
    Expect(0, 43616, '\P{^Block=_-CHAM}', "");
    Error('\p{Blk: /a/		Cham}');
    Error('\P{Blk: /a/		Cham}');
    Expect(1, 43615, '\p{Blk=cham}', "");
    Expect(0, 43615, '\p{^Blk=cham}', "");
    Expect(0, 43615, '\P{Blk=cham}', "");
    Expect(1, 43615, '\P{^Blk=cham}', "");
    Expect(0, 43616, '\p{Blk=cham}', "");
    Expect(1, 43616, '\p{^Blk=cham}', "");
    Expect(1, 43616, '\P{Blk=cham}', "");
    Expect(0, 43616, '\P{^Blk=cham}', "");
    Expect(1, 43615, '\p{Blk= 	cham}', "");
    Expect(0, 43615, '\p{^Blk= 	cham}', "");
    Expect(0, 43615, '\P{Blk= 	cham}', "");
    Expect(1, 43615, '\P{^Blk= 	cham}', "");
    Expect(0, 43616, '\p{Blk= 	cham}', "");
    Expect(1, 43616, '\p{^Blk= 	cham}', "");
    Expect(1, 43616, '\P{Blk= 	cham}', "");
    Expect(0, 43616, '\P{^Blk= 	cham}', "");
    Error('\p{Is_Block= cham:=}');
    Error('\P{Is_Block= cham:=}');
    Expect(1, 43615, '\p{Is_Block=cham}', "");
    Expect(0, 43615, '\p{^Is_Block=cham}', "");
    Expect(0, 43615, '\P{Is_Block=cham}', "");
    Expect(1, 43615, '\P{^Is_Block=cham}', "");
    Expect(0, 43616, '\p{Is_Block=cham}', "");
    Expect(1, 43616, '\p{^Is_Block=cham}', "");
    Expect(1, 43616, '\P{Is_Block=cham}', "");
    Expect(0, 43616, '\P{^Is_Block=cham}', "");
    Expect(1, 43615, '\p{Is_Block=CHAM}', "");
    Expect(0, 43615, '\p{^Is_Block=CHAM}', "");
    Expect(0, 43615, '\P{Is_Block=CHAM}', "");
    Expect(1, 43615, '\P{^Is_Block=CHAM}', "");
    Expect(0, 43616, '\p{Is_Block=CHAM}', "");
    Expect(1, 43616, '\p{^Is_Block=CHAM}', "");
    Expect(1, 43616, '\P{Is_Block=CHAM}', "");
    Expect(0, 43616, '\P{^Is_Block=CHAM}', "");
    Error('\p{Is_Blk= :=cham}');
    Error('\P{Is_Blk= :=cham}');
    Expect(1, 43615, '\p{Is_Blk=cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=cham}', "");
    Expect(0, 43615, '\P{Is_Blk=cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=cham}', "");
    Expect(0, 43616, '\p{Is_Blk=cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=cham}', "");
    Expect(1, 43616, '\P{Is_Blk=cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=cham}', "");
    Expect(1, 43615, '\p{Is_Blk: _CHAM}', "");
    Expect(0, 43615, '\p{^Is_Blk: _CHAM}', "");
    Expect(0, 43615, '\P{Is_Blk: _CHAM}', "");
    Expect(1, 43615, '\P{^Is_Blk: _CHAM}', "");
    Expect(0, 43616, '\p{Is_Blk: _CHAM}', "");
    Expect(1, 43616, '\p{^Is_Blk: _CHAM}', "");
    Expect(1, 43616, '\P{Is_Blk: _CHAM}', "");
    Expect(0, 43616, '\P{^Is_Blk: _CHAM}', "");
    Error('\p{Block: :=_-cherokee}');
    Error('\P{Block: :=_-cherokee}');
    Expect(1, 5119, '\p{Block=cherokee}', "");
    Expect(0, 5119, '\p{^Block=cherokee}', "");
    Expect(0, 5119, '\P{Block=cherokee}', "");
    Expect(1, 5119, '\P{^Block=cherokee}', "");
    Expect(0, 5120, '\p{Block=cherokee}', "");
    Expect(1, 5120, '\p{^Block=cherokee}', "");
    Expect(1, 5120, '\P{Block=cherokee}', "");
    Expect(0, 5120, '\P{^Block=cherokee}', "");
    Expect(1, 5119, '\p{Block=_-Cherokee}', "");
    Expect(0, 5119, '\p{^Block=_-Cherokee}', "");
    Expect(0, 5119, '\P{Block=_-Cherokee}', "");
    Expect(1, 5119, '\P{^Block=_-Cherokee}', "");
    Expect(0, 5120, '\p{Block=_-Cherokee}', "");
    Expect(1, 5120, '\p{^Block=_-Cherokee}', "");
    Expect(1, 5120, '\P{Block=_-Cherokee}', "");
    Expect(0, 5120, '\P{^Block=_-Cherokee}', "");
    Error('\p{Blk=/a/CHEROKEE}');
    Error('\P{Blk=/a/CHEROKEE}');
    Expect(1, 5119, '\p{Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Blk=cherokee}', "");
    Expect(0, 5119, '\P{Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Blk=cherokee}', "");
    Expect(0, 5120, '\p{Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Blk=cherokee}', "");
    Expect(1, 5120, '\P{Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Blk=cherokee}', "");
    Expect(1, 5119, '\p{Blk=_CHEROKEE}', "");
    Expect(0, 5119, '\p{^Blk=_CHEROKEE}', "");
    Expect(0, 5119, '\P{Blk=_CHEROKEE}', "");
    Expect(1, 5119, '\P{^Blk=_CHEROKEE}', "");
    Expect(0, 5120, '\p{Blk=_CHEROKEE}', "");
    Expect(1, 5120, '\p{^Blk=_CHEROKEE}', "");
    Expect(1, 5120, '\P{Blk=_CHEROKEE}', "");
    Expect(0, 5120, '\P{^Blk=_CHEROKEE}', "");
    Error('\p{Is_Block= cherokee:=}');
    Error('\P{Is_Block= cherokee:=}');
    Expect(1, 5119, '\p{Is_Block=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
    Expect(1, 5119, '\p{Is_Block=_-cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=_-cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=_-cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=_-cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=_-cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=_-cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=_-cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=_-cherokee}', "");
    Error('\p{Is_Blk=/a/ Cherokee}');
    Error('\P{Is_Blk=/a/ Cherokee}');
    Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk=cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk=cherokee}', "");
    Expect(1, 5119, '\p{Is_Blk= _CHEROKEE}', "");
    Expect(0, 5119, '\p{^Is_Blk= _CHEROKEE}', "");
    Expect(0, 5119, '\P{Is_Blk= _CHEROKEE}', "");
    Expect(1, 5119, '\P{^Is_Blk= _CHEROKEE}', "");
    Expect(0, 5120, '\p{Is_Blk= _CHEROKEE}', "");
    Expect(1, 5120, '\p{^Is_Blk= _CHEROKEE}', "");
    Expect(1, 5120, '\P{Is_Blk= _CHEROKEE}', "");
    Expect(0, 5120, '\P{^Is_Blk= _CHEROKEE}', "");
    Error('\p{Block=/a/  Cherokee_Supplement}');
    Error('\P{Block=/a/  Cherokee_Supplement}');
    Expect(1, 43967, '\p{Block: cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Block: cherokeesupplement}', "");
    Expect(0, 43967, '\P{Block: cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Block: cherokeesupplement}', "");
    Expect(0, 43968, '\p{Block: cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Block: cherokeesupplement}', "");
    Expect(1, 43968, '\P{Block: cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Block: cherokeesupplement}', "");
    Expect(1, 43967, '\p{Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(0, 43967, '\p{^Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(0, 43967, '\P{Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(1, 43967, '\P{^Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(0, 43968, '\p{Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(1, 43968, '\p{^Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(1, 43968, '\P{Block=-CHEROKEE_SUPPLEMENT}', "");
    Expect(0, 43968, '\P{^Block=-CHEROKEE_SUPPLEMENT}', "");
    Error('\p{Blk:	/a/_	cherokee_SUP}');
    Error('\P{Blk:	/a/_	cherokee_SUP}');
    Expect(1, 43967, '\p{Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Blk=_Cherokee_sup}', "");
    Expect(0, 43967, '\p{^Blk=_Cherokee_sup}', "");
    Expect(0, 43967, '\P{Blk=_Cherokee_sup}', "");
    Expect(1, 43967, '\P{^Blk=_Cherokee_sup}', "");
    Expect(0, 43968, '\p{Blk=_Cherokee_sup}', "");
    Expect(1, 43968, '\p{^Blk=_Cherokee_sup}', "");
    Expect(1, 43968, '\P{Blk=_Cherokee_sup}', "");
    Expect(0, 43968, '\P{^Blk=_Cherokee_sup}', "");
    Error('\p{Is_Block: Cherokee_supplement/a/}');
    Error('\P{Is_Block: Cherokee_supplement/a/}');
    Expect(1, 43967, '\p{Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Is_Block:   - Cherokee_Supplement}', "");
    Expect(0, 43967, '\p{^Is_Block:   - Cherokee_Supplement}', "");
    Expect(0, 43967, '\P{Is_Block:   - Cherokee_Supplement}', "");
    Expect(1, 43967, '\P{^Is_Block:   - Cherokee_Supplement}', "");
    Expect(0, 43968, '\p{Is_Block:   - Cherokee_Supplement}', "");
    Expect(1, 43968, '\p{^Is_Block:   - Cherokee_Supplement}', "");
    Expect(1, 43968, '\P{Is_Block:   - Cherokee_Supplement}', "");
    Expect(0, 43968, '\P{^Is_Block:   - Cherokee_Supplement}', "");
    Error('\p{Is_Blk=/a/-CHEROKEE_SUP}');
    Error('\P{Is_Blk=/a/-CHEROKEE_SUP}');
    Expect(1, 43967, '\p{Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Is_Blk= Cherokee_sup}', "");
    Expect(0, 43967, '\p{^Is_Blk= Cherokee_sup}', "");
    Expect(0, 43967, '\P{Is_Blk= Cherokee_sup}', "");
    Expect(1, 43967, '\P{^Is_Blk= Cherokee_sup}', "");
    Expect(0, 43968, '\p{Is_Blk= Cherokee_sup}', "");
    Expect(1, 43968, '\p{^Is_Blk= Cherokee_sup}', "");
    Expect(1, 43968, '\P{Is_Blk= Cherokee_sup}', "");
    Expect(0, 43968, '\P{^Is_Blk= Cherokee_sup}', "");
    Error('\p{Block=_	CJK_Unified_Ideographs/a/}');
    Error('\P{Block=_	CJK_Unified_Ideographs/a/}');
    Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Block=	 CJK_unified_ideographs}', "");
    Expect(0, 40959, '\p{^Block=	 CJK_unified_ideographs}', "");
    Expect(0, 40959, '\P{Block=	 CJK_unified_ideographs}', "");
    Expect(1, 40959, '\P{^Block=	 CJK_unified_ideographs}', "");
    Expect(0, 40960, '\p{Block=	 CJK_unified_ideographs}', "");
    Expect(1, 40960, '\p{^Block=	 CJK_unified_ideographs}', "");
    Expect(1, 40960, '\P{Block=	 CJK_unified_ideographs}', "");
    Expect(0, 40960, '\P{^Block=	 CJK_unified_ideographs}', "");
    Error('\p{Blk=:=	 cjk}');
    Error('\P{Blk=:=	 cjk}');
    Expect(1, 40959, '\p{Blk=cjk}', "");
    Expect(0, 40959, '\p{^Blk=cjk}', "");
    Expect(0, 40959, '\P{Blk=cjk}', "");
    Expect(1, 40959, '\P{^Blk=cjk}', "");
    Expect(0, 40960, '\p{Blk=cjk}', "");
    Expect(1, 40960, '\p{^Blk=cjk}', "");
    Expect(1, 40960, '\P{Blk=cjk}', "");
    Expect(0, 40960, '\P{^Blk=cjk}', "");
    Expect(1, 40959, '\p{Blk=-_CJK}', "");
    Expect(0, 40959, '\p{^Blk=-_CJK}', "");
    Expect(0, 40959, '\P{Blk=-_CJK}', "");
    Expect(1, 40959, '\P{^Blk=-_CJK}', "");
    Expect(0, 40960, '\p{Blk=-_CJK}', "");
    Expect(1, 40960, '\p{^Blk=-_CJK}', "");
    Expect(1, 40960, '\P{Blk=-_CJK}', "");
    Expect(0, 40960, '\P{^Blk=-_CJK}', "");
    Error('\p{Is_Block=	-CJK_Unified_Ideographs/a/}');
    Error('\P{Is_Block=	-CJK_Unified_Ideographs/a/}');
    Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(0, 40959, '\P{Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\p{Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(1, 40960, '\P{Is_Block=_CJK_Unified_Ideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=_CJK_Unified_Ideographs}', "");
    Error('\p{Is_Blk=/a/-CJK}');
    Error('\P{Is_Blk=/a/-CJK}');
    Expect(1, 40959, '\p{Is_Blk=cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk=cjk}', "");
    Expect(0, 40959, '\P{Is_Blk=cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk=cjk}', "");
    Expect(0, 40960, '\p{Is_Blk=cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk=cjk}', "");
    Expect(1, 40960, '\P{Is_Blk=cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk=cjk}', "");
    Expect(1, 40959, '\p{Is_Blk=-	CJK}', "");
    Expect(0, 40959, '\p{^Is_Blk=-	CJK}', "");
    Expect(0, 40959, '\P{Is_Blk=-	CJK}', "");
    Expect(1, 40959, '\P{^Is_Blk=-	CJK}', "");
    Expect(0, 40960, '\p{Is_Blk=-	CJK}', "");
    Expect(1, 40960, '\p{^Is_Blk=-	CJK}', "");
    Expect(1, 40960, '\P{Is_Blk=-	CJK}', "");
    Expect(0, 40960, '\P{^Is_Blk=-	CJK}', "");
    Error('\p{Block=/a/_ cjk_Compatibility}');
    Error('\P{Block=/a/_ cjk_Compatibility}');
    Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Block=- cjk_Compatibility}', "");
    Expect(0, 13311, '\p{^Block=- cjk_Compatibility}', "");
    Expect(0, 13311, '\P{Block=- cjk_Compatibility}', "");
    Expect(1, 13311, '\P{^Block=- cjk_Compatibility}', "");
    Expect(0, 13312, '\p{Block=- cjk_Compatibility}', "");
    Expect(1, 13312, '\p{^Block=- cjk_Compatibility}', "");
    Expect(1, 13312, '\P{Block=- cjk_Compatibility}', "");
    Expect(0, 13312, '\P{^Block=- cjk_Compatibility}', "");
    Error('\p{Blk=  cjk_COMPAT:=}');
    Error('\P{Blk=  cjk_COMPAT:=}');
    Expect(1, 13311, '\p{Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Blk=_CJK_Compat}', "");
    Expect(0, 13311, '\p{^Blk=_CJK_Compat}', "");
    Expect(0, 13311, '\P{Blk=_CJK_Compat}', "");
    Expect(1, 13311, '\P{^Blk=_CJK_Compat}', "");
    Expect(0, 13312, '\p{Blk=_CJK_Compat}', "");
    Expect(1, 13312, '\p{^Blk=_CJK_Compat}', "");
    Expect(1, 13312, '\P{Blk=_CJK_Compat}', "");
    Expect(0, 13312, '\P{^Blk=_CJK_Compat}', "");
    Error('\p{Is_Block=/a/  cjk_Compatibility}');
    Error('\P{Is_Block=/a/  cjk_Compatibility}');
    Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(0, 13311, '\p{^Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(0, 13311, '\P{Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(1, 13311, '\P{^Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(0, 13312, '\p{Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(1, 13312, '\p{^Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(1, 13312, '\P{Is_Block=_CJK_COMPATIBILITY}', "");
    Expect(0, 13312, '\P{^Is_Block=_CJK_COMPATIBILITY}', "");
    Error('\p{Is_Blk=/a/ 	CJK_COMPAT}');
    Error('\P{Is_Blk=/a/ 	CJK_COMPAT}');
    Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Is_Blk= _cjk_compat}', "");
    Expect(0, 13311, '\p{^Is_Blk= _cjk_compat}', "");
    Expect(0, 13311, '\P{Is_Blk= _cjk_compat}', "");
    Expect(1, 13311, '\P{^Is_Blk= _cjk_compat}', "");
    Expect(0, 13312, '\p{Is_Blk= _cjk_compat}', "");
    Expect(1, 13312, '\p{^Is_Blk= _cjk_compat}', "");
    Expect(1, 13312, '\P{Is_Blk= _cjk_compat}', "");
    Expect(0, 13312, '\P{^Is_Blk= _cjk_compat}', "");
    Error('\p{Block=_:=CJK_Compatibility_FORMS}');
    Error('\P{Block=_:=CJK_Compatibility_FORMS}');
    Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(0, 65103, '\p{^Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(0, 65103, '\P{Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(1, 65103, '\P{^Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(0, 65104, '\p{Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(1, 65104, '\p{^Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(1, 65104, '\P{Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Expect(0, 65104, '\P{^Block:   _-CJK_COMPATIBILITY_Forms}', "");
    Error('\p{Blk=	:=CJK_Compat_FORMS}');
    Error('\P{Blk=	:=CJK_Compat_FORMS}');
    Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Blk=		cjk_Compat_Forms}', "");
    Expect(0, 65103, '\p{^Blk=		cjk_Compat_Forms}', "");
    Expect(0, 65103, '\P{Blk=		cjk_Compat_Forms}', "");
    Expect(1, 65103, '\P{^Blk=		cjk_Compat_Forms}', "");
    Expect(0, 65104, '\p{Blk=		cjk_Compat_Forms}', "");
    Expect(1, 65104, '\p{^Blk=		cjk_Compat_Forms}', "");
    Expect(1, 65104, '\P{Blk=		cjk_Compat_Forms}', "");
    Expect(0, 65104, '\P{^Blk=		cjk_Compat_Forms}', "");
    Error('\p{Is_Block=-:=CJK_Compatibility_Forms}');
    Error('\P{Is_Block=-:=CJK_Compatibility_Forms}');
    Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Is_Block= CJK_compatibility_Forms}', "");
    Expect(0, 65103, '\p{^Is_Block= CJK_compatibility_Forms}', "");
    Expect(0, 65103, '\P{Is_Block= CJK_compatibility_Forms}', "");
    Expect(1, 65103, '\P{^Is_Block= CJK_compatibility_Forms}', "");
    Expect(0, 65104, '\p{Is_Block= CJK_compatibility_Forms}', "");
    Expect(1, 65104, '\p{^Is_Block= CJK_compatibility_Forms}', "");
    Expect(1, 65104, '\P{Is_Block= CJK_compatibility_Forms}', "");
    Expect(0, 65104, '\P{^Is_Block= CJK_compatibility_Forms}', "");
    Error('\p{Is_Blk=/a/- CJK_Compat_Forms}');
    Error('\P{Is_Blk=/a/- CJK_Compat_Forms}');
    Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Is_Blk= CJK_Compat_forms}', "");
    Expect(0, 65103, '\p{^Is_Blk= CJK_Compat_forms}', "");
    Expect(0, 65103, '\P{Is_Blk= CJK_Compat_forms}', "");
    Expect(1, 65103, '\P{^Is_Blk= CJK_Compat_forms}', "");
    Expect(0, 65104, '\p{Is_Blk= CJK_Compat_forms}', "");
    Expect(1, 65104, '\p{^Is_Blk= CJK_Compat_forms}', "");
    Expect(1, 65104, '\P{Is_Blk= CJK_Compat_forms}', "");
    Expect(0, 65104, '\P{^Is_Blk= CJK_Compat_forms}', "");
    Error('\p{Block=:=-	cjk_compatibility_IDEOGRAPHS}');
    Error('\P{Block=:=-	cjk_compatibility_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Block=-cjk_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\p{^Block=-cjk_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\P{Block=-cjk_Compatibility_Ideographs}', "");
    Expect(1, 64255, '\P{^Block=-cjk_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\p{Block=-cjk_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\p{^Block=-cjk_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\P{Block=-cjk_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\P{^Block=-cjk_Compatibility_Ideographs}', "");
    Error('\p{Blk=/a/CJK_compat_IDEOGRAPHS}');
    Error('\P{Blk=/a/CJK_compat_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\p{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\P{Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64255, '\P{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\p{Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\p{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\P{Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\P{^Blk=		CJK_Compat_Ideographs}', "");
    Error('\p{Is_Block=_	CJK_compatibility_Ideographs:=}');
    Error('\P{Is_Block=_	CJK_compatibility_Ideographs:=}');
    Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(0, 64255, '\p{^Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(0, 64255, '\P{Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(1, 64255, '\P{^Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(0, 64256, '\p{Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(1, 64256, '\p{^Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(1, 64256, '\P{Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Expect(0, 64256, '\P{^Is_Block=CJK_compatibility_IDEOGRAPHS}', "");
    Error('\p{Is_Blk=- CJK_COMPAT_Ideographs:=}');
    Error('\P{Is_Blk=- CJK_COMPAT_Ideographs:=}');
    Expect(1, 64255, '\p{Is_Blk:	cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk:	cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Is_Blk:	cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk:	cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Is_Blk:	cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk:	cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Is_Blk:	cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk:	cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Is_Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=CJK_Compat_ideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=CJK_Compat_ideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=CJK_Compat_ideographs}', "");
    Error('\p{Block=/a/-CJK_compatibility_IDEOGRAPHS_Supplement}');
    Error('\P{Block=/a/-CJK_compatibility_IDEOGRAPHS_Supplement}');
    Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195103, '\p{^Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195103, '\P{Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195103, '\P{^Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195104, '\p{Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195104, '\p{^Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195104, '\P{Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195104, '\P{^Block=-cjk_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT}', "");
    Error('\p{Blk=/a/ CJK_COMPAT_Ideographs_SUP}');
    Error('\P{Blk=/a/ CJK_COMPAT_Ideographs_SUP}');
    Expect(1, 195103, '\p{Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(0, 195103, '\p{^Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(0, 195103, '\P{Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(1, 195103, '\P{^Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(0, 195104, '\p{Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(1, 195104, '\p{^Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(1, 195104, '\P{Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Expect(0, 195104, '\P{^Blk= -CJK_Compat_IDEOGRAPHS_Sup}', "");
    Error('\p{Is_Block:	:= _cjk_Compatibility_IDEOGRAPHS_Supplement}');
    Error('\P{Is_Block:	:= _cjk_Compatibility_IDEOGRAPHS_Supplement}');
    Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195103, '\p{^Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195103, '\P{Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195103, '\P{^Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195104, '\p{Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195104, '\p{^Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195104, '\P{Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195104, '\P{^Is_Block= _CJK_Compatibility_Ideographs_Supplement}', "");
    Error('\p{Is_Blk=/a/--CJK_Compat_IDEOGRAPHS_SUP}');
    Error('\P{Is_Blk=/a/--CJK_Compat_IDEOGRAPHS_SUP}');
    Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195103, '\p{^Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195103, '\P{Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195103, '\P{^Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195104, '\p{Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195104, '\p{^Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195104, '\P{Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195104, '\P{^Is_Blk: --cjk_compat_Ideographs_Sup}', "");
    Error('\p{Block=:=CJK_unified_Ideographs_Extension_A}');
    Error('\P{Block=:=CJK_unified_Ideographs_Extension_A}');
    Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(0, 19903, '\p{^Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(0, 19903, '\P{Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(1, 19903, '\P{^Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(0, 19904, '\p{Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(1, 19904, '\p{^Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(1, 19904, '\P{Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Expect(0, 19904, '\P{^Block=_	CJK_Unified_Ideographs_EXTENSION_A}', "");
    Error('\p{Blk=-/a/CJK_EXT_A}');
    Error('\P{Blk=-/a/CJK_EXT_A}');
    Expect(1, 19903, '\p{Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Blk= _CJK_Ext_a}', "");
    Expect(0, 19903, '\p{^Blk= _CJK_Ext_a}', "");
    Expect(0, 19903, '\P{Blk= _CJK_Ext_a}', "");
    Expect(1, 19903, '\P{^Blk= _CJK_Ext_a}', "");
    Expect(0, 19904, '\p{Blk= _CJK_Ext_a}', "");
    Expect(1, 19904, '\p{^Blk= _CJK_Ext_a}', "");
    Expect(1, 19904, '\P{Blk= _CJK_Ext_a}', "");
    Expect(0, 19904, '\P{^Blk= _CJK_Ext_a}', "");
    Error('\p{Is_Block=-	CJK_Unified_Ideographs_EXTENSION_a/a/}');
    Error('\P{Is_Block=-	CJK_Unified_Ideographs_EXTENSION_a/a/}');
    Expect(1, 19903, '\p{Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Is_Block:	cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19903, '\p{^Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19903, '\P{Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19903, '\P{^Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19904, '\p{Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19904, '\p{^Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19904, '\P{Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19904, '\P{^Is_Block=	 CJK_unified_Ideographs_EXTENSION_a}', "");
    Error('\p{Is_Blk:	 /a/CJK_EXT_a}');
    Error('\P{Is_Blk:	 /a/CJK_EXT_a}');
    Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Is_Blk=_	CJK_EXT_A}', "");
    Expect(0, 19903, '\p{^Is_Blk=_	CJK_EXT_A}', "");
    Expect(0, 19903, '\P{Is_Blk=_	CJK_EXT_A}', "");
    Expect(1, 19903, '\P{^Is_Blk=_	CJK_EXT_A}', "");
    Expect(0, 19904, '\p{Is_Blk=_	CJK_EXT_A}', "");
    Expect(1, 19904, '\p{^Is_Blk=_	CJK_EXT_A}', "");
    Expect(1, 19904, '\P{Is_Blk=_	CJK_EXT_A}', "");
    Expect(0, 19904, '\P{^Is_Blk=_	CJK_EXT_A}', "");
    Error('\p{Block=:=-_CJK_Unified_ideographs_Extension_b}');
    Error('\P{Block=:=-_CJK_Unified_ideographs_Extension_b}');
    Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(0, 173791, '\p{^Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(0, 173791, '\P{Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(1, 173791, '\P{^Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(0, 173792, '\p{Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(1, 173792, '\p{^Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(1, 173792, '\P{Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Expect(0, 173792, '\P{^Block=-	CJK_Unified_Ideographs_EXTENSION_b}', "");
    Error('\p{Blk: -:=cjk_Ext_B}');
    Error('\P{Blk: -:=cjk_Ext_B}');
    Expect(1, 173791, '\p{Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Blk=_	CJK_Ext_B}', "");
    Expect(0, 173791, '\p{^Blk=_	CJK_Ext_B}', "");
    Expect(0, 173791, '\P{Blk=_	CJK_Ext_B}', "");
    Expect(1, 173791, '\P{^Blk=_	CJK_Ext_B}', "");
    Expect(0, 173792, '\p{Blk=_	CJK_Ext_B}', "");
    Expect(1, 173792, '\p{^Blk=_	CJK_Ext_B}', "");
    Expect(1, 173792, '\P{Blk=_	CJK_Ext_B}', "");
    Expect(0, 173792, '\P{^Blk=_	CJK_Ext_B}', "");
    Error('\p{Is_Block=	/a/CJK_Unified_IDEOGRAPHS_Extension_B}');
    Error('\P{Is_Block=	/a/CJK_Unified_IDEOGRAPHS_Extension_B}');
    Expect(1, 173791, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\p{^Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\P{Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173791, '\P{^Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\p{Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\p{^Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\P{Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\P{^Is_Block=-cjk_Unified_Ideographs_Extension_B}', "");
    Error('\p{Is_Blk=	/a/CJK_Ext_B}');
    Error('\P{Is_Blk=	/a/CJK_Ext_B}');
    Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Is_Blk= -CJK_EXT_B}', "");
    Expect(0, 173791, '\p{^Is_Blk= -CJK_EXT_B}', "");
    Expect(0, 173791, '\P{Is_Blk= -CJK_EXT_B}', "");
    Expect(1, 173791, '\P{^Is_Blk= -CJK_EXT_B}', "");
    Expect(0, 173792, '\p{Is_Blk= -CJK_EXT_B}', "");
    Expect(1, 173792, '\p{^Is_Blk= -CJK_EXT_B}', "");
    Expect(1, 173792, '\P{Is_Blk= -CJK_EXT_B}', "");
    Expect(0, 173792, '\P{^Is_Blk= -CJK_EXT_B}', "");
    Error('\p{Block=:=-	CJK_UNIFIED_Ideographs_Extension_c}');
    Error('\P{Block=:=-	CJK_UNIFIED_Ideographs_Extension_c}');
    Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(0, 177983, '\p{^Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(0, 177983, '\P{Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(1, 177983, '\P{^Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(0, 177984, '\p{Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(1, 177984, '\p{^Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(1, 177984, '\P{Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Expect(0, 177984, '\P{^Block=	_CJK_UNIFIED_ideographs_extension_C}', "");
    Error('\p{Blk=/a/CJK_ext_c}');
    Error('\P{Blk=/a/CJK_ext_c}');
    Expect(1, 177983, '\p{Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Blk=	-CJK_Ext_C}', "");
    Expect(0, 177983, '\p{^Blk=	-CJK_Ext_C}', "");
    Expect(0, 177983, '\P{Blk=	-CJK_Ext_C}', "");
    Expect(1, 177983, '\P{^Blk=	-CJK_Ext_C}', "");
    Expect(0, 177984, '\p{Blk=	-CJK_Ext_C}', "");
    Expect(1, 177984, '\p{^Blk=	-CJK_Ext_C}', "");
    Expect(1, 177984, '\P{Blk=	-CJK_Ext_C}', "");
    Expect(0, 177984, '\P{^Blk=	-CJK_Ext_C}', "");
    Error('\p{Is_Block= 	CJK_Unified_IDEOGRAPHS_Extension_C/a/}');
    Error('\P{Is_Block= 	CJK_Unified_IDEOGRAPHS_Extension_C/a/}');
    Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(0, 177983, '\p{^Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(0, 177983, '\P{Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(1, 177983, '\P{^Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(0, 177984, '\p{Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(1, 177984, '\p{^Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(1, 177984, '\P{Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Expect(0, 177984, '\P{^Is_Block=__cjk_Unified_Ideographs_EXTENSION_C}', "");
    Error('\p{Is_Blk=:= -CJK_ext_C}');
    Error('\P{Is_Blk=:= -CJK_ext_C}');
    Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Is_Blk=--CJK_Ext_C}', "");
    Expect(0, 177983, '\p{^Is_Blk=--CJK_Ext_C}', "");
    Expect(0, 177983, '\P{Is_Blk=--CJK_Ext_C}', "");
    Expect(1, 177983, '\P{^Is_Blk=--CJK_Ext_C}', "");
    Expect(0, 177984, '\p{Is_Blk=--CJK_Ext_C}', "");
    Expect(1, 177984, '\p{^Is_Blk=--CJK_Ext_C}', "");
    Expect(1, 177984, '\P{Is_Blk=--CJK_Ext_C}', "");
    Expect(0, 177984, '\P{^Is_Blk=--CJK_Ext_C}', "");
    Error('\p{Block= /a/CJK_Unified_IDEOGRAPHS_EXTENSION_D}');
    Error('\P{Block= /a/CJK_Unified_IDEOGRAPHS_EXTENSION_D}');
    Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(0, 178207, '\p{^Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(0, 178207, '\P{Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(1, 178207, '\P{^Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(0, 178208, '\p{Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(1, 178208, '\p{^Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(1, 178208, '\P{Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Expect(0, 178208, '\P{^Block=--CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
    Error('\p{Blk=		CJK_EXT_D/a/}');
    Error('\P{Blk=		CJK_EXT_D/a/}');
    Expect(1, 178207, '\p{Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Blk=-CJK_Ext_D}', "");
    Expect(0, 178207, '\p{^Blk=-CJK_Ext_D}', "");
    Expect(0, 178207, '\P{Blk=-CJK_Ext_D}', "");
    Expect(1, 178207, '\P{^Blk=-CJK_Ext_D}', "");
    Expect(0, 178208, '\p{Blk=-CJK_Ext_D}', "");
    Expect(1, 178208, '\p{^Blk=-CJK_Ext_D}', "");
    Expect(1, 178208, '\P{Blk=-CJK_Ext_D}', "");
    Expect(0, 178208, '\P{^Blk=-CJK_Ext_D}', "");
    Error('\p{Is_Block= :=CJK_Unified_IDEOGRAPHS_extension_D}');
    Error('\P{Is_Block= :=CJK_Unified_IDEOGRAPHS_extension_D}');
    Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(0, 178207, '\p{^Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(0, 178207, '\P{Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(1, 178207, '\P{^Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(0, 178208, '\p{Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(1, 178208, '\p{^Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(1, 178208, '\P{Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Expect(0, 178208, '\P{^Is_Block=-CJK_unified_IDEOGRAPHS_EXTENSION_D}', "");
    Error('\p{Is_Blk=/a/ -CJK_EXT_D}');
    Error('\P{Is_Blk=/a/ -CJK_EXT_D}');
    Expect(1, 178207, '\p{Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Is_Blk=	 CJK_ext_D}', "");
    Expect(0, 178207, '\p{^Is_Blk=	 CJK_ext_D}', "");
    Expect(0, 178207, '\P{Is_Blk=	 CJK_ext_D}', "");
    Expect(1, 178207, '\P{^Is_Blk=	 CJK_ext_D}', "");
    Expect(0, 178208, '\p{Is_Blk=	 CJK_ext_D}', "");
    Expect(1, 178208, '\p{^Is_Blk=	 CJK_ext_D}', "");
    Expect(1, 178208, '\P{Is_Blk=	 CJK_ext_D}', "");
    Expect(0, 178208, '\P{^Is_Blk=	 CJK_ext_D}', "");
    Error('\p{Block=	/a/cjk_unified_IDEOGRAPHS_EXTENSION_E}');
    Error('\P{Block=	/a/cjk_unified_IDEOGRAPHS_EXTENSION_E}');
    Expect(1, 183983, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(0, 183983, '\p{^Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(0, 183983, '\P{Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(1, 183983, '\P{^Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(0, 183984, '\p{Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(1, 183984, '\p{^Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(1, 183984, '\P{Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Expect(0, 183984, '\P{^Block=--CJK_Unified_IDEOGRAPHS_EXTENSION_E}', "");
    Error('\p{Blk=:=	 CJK_ext_e}');
    Error('\P{Blk=:=	 CJK_ext_e}');
    Expect(1, 183983, '\p{Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Blk=-CJK_ext_E}', "");
    Expect(0, 183983, '\p{^Blk=-CJK_ext_E}', "");
    Expect(0, 183983, '\P{Blk=-CJK_ext_E}', "");
    Expect(1, 183983, '\P{^Blk=-CJK_ext_E}', "");
    Expect(0, 183984, '\p{Blk=-CJK_ext_E}', "");
    Expect(1, 183984, '\p{^Blk=-CJK_ext_E}', "");
    Expect(1, 183984, '\P{Blk=-CJK_ext_E}', "");
    Expect(0, 183984, '\P{^Blk=-CJK_ext_E}', "");
    Error('\p{Is_Block: :=-CJK_UNIFIED_ideographs_extension_E}');
    Error('\P{Is_Block: :=-CJK_UNIFIED_ideographs_extension_E}');
    Expect(1, 183983, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(0, 183983, '\p{^Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(0, 183983, '\P{Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(1, 183983, '\P{^Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(0, 183984, '\p{Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(1, 183984, '\p{^Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(1, 183984, '\P{Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Expect(0, 183984, '\P{^Is_Block=	-cjk_unified_Ideographs_Extension_E}', "");
    Error('\p{Is_Blk=/a/	 CJK_Ext_E}');
    Error('\P{Is_Blk=/a/	 CJK_Ext_E}');
    Expect(1, 183983, '\p{Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Is_Blk=	CJK_ext_E}', "");
    Expect(0, 183983, '\p{^Is_Blk=	CJK_ext_E}', "");
    Expect(0, 183983, '\P{Is_Blk=	CJK_ext_E}', "");
    Expect(1, 183983, '\P{^Is_Blk=	CJK_ext_E}', "");
    Expect(0, 183984, '\p{Is_Blk=	CJK_ext_E}', "");
    Expect(1, 183984, '\p{^Is_Blk=	CJK_ext_E}', "");
    Expect(1, 183984, '\P{Is_Blk=	CJK_ext_E}', "");
    Expect(0, 183984, '\P{^Is_Blk=	CJK_ext_E}', "");
    Error('\p{Block=/a/		CJK_Unified_Ideographs_Extension_f}');
    Error('\P{Block=/a/		CJK_Unified_Ideographs_Extension_f}');
    Expect(1, 191471, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(0, 191471, '\p{^Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(0, 191471, '\P{Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(1, 191471, '\P{^Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(0, 191472, '\p{Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(1, 191472, '\p{^Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(1, 191472, '\P{Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Expect(0, 191472, '\P{^Block=	CJK_Unified_IDEOGRAPHS_extension_f}', "");
    Error('\p{Blk: 	_cjk_Ext_F/a/}');
    Error('\P{Blk: 	_cjk_Ext_F/a/}');
    Expect(1, 191471, '\p{Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Blk=-cjk_ext_f}', "");
    Expect(0, 191471, '\p{^Blk=-cjk_ext_f}', "");
    Expect(0, 191471, '\P{Blk=-cjk_ext_f}', "");
    Expect(1, 191471, '\P{^Blk=-cjk_ext_f}', "");
    Expect(0, 191472, '\p{Blk=-cjk_ext_f}', "");
    Expect(1, 191472, '\p{^Blk=-cjk_ext_f}', "");
    Expect(1, 191472, '\P{Blk=-cjk_ext_f}', "");
    Expect(0, 191472, '\P{^Blk=-cjk_ext_f}', "");
    Error('\p{Is_Block=	/a/CJK_UNIFIED_IDEOGRAPHS_Extension_F}');
    Error('\P{Is_Block=	/a/CJK_UNIFIED_IDEOGRAPHS_Extension_F}');
    Expect(1, 191471, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Is_Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(0, 191471, '\p{^Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(0, 191471, '\P{Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(1, 191471, '\P{^Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(0, 191472, '\p{Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(1, 191472, '\p{^Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(1, 191472, '\P{Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Expect(0, 191472, '\P{^Is_Block: _-CJK_Unified_Ideographs_Extension_F}', "");
    Error('\p{Is_Blk= CJK_Ext_F:=}');
    Error('\P{Is_Blk= CJK_Ext_F:=}');
    Expect(1, 191471, '\p{Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Is_Blk=_	CJK_EXT_f}', "");
    Expect(0, 191471, '\p{^Is_Blk=_	CJK_EXT_f}', "");
    Expect(0, 191471, '\P{Is_Blk=_	CJK_EXT_f}', "");
    Expect(1, 191471, '\P{^Is_Blk=_	CJK_EXT_f}', "");
    Expect(0, 191472, '\p{Is_Blk=_	CJK_EXT_f}', "");
    Expect(1, 191472, '\p{^Is_Blk=_	CJK_EXT_f}', "");
    Expect(1, 191472, '\P{Is_Blk=_	CJK_EXT_f}', "");
    Expect(0, 191472, '\P{^Is_Blk=_	CJK_EXT_f}', "");
    Error('\p{Block=	CJK_Radicals_Supplement:=}');
    Error('\P{Block=	CJK_Radicals_Supplement:=}');
    Expect(1, 12031, '\p{Block:	cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Block:	cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Block:	cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Block:	cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Block:	cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Block:	cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Block:	cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Block:	cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12031, '\p{^Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12031, '\P{Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12031, '\P{^Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12032, '\p{Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12032, '\p{^Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12032, '\P{Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12032, '\P{^Block=	CJK_RADICALS_supplement}', "");
    Error('\p{Blk=- CJK_radicals_sup:=}');
    Error('\P{Blk=- CJK_radicals_sup:=}');
    Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Blk: - CJK_RADICALS_sup}', "");
    Expect(0, 12031, '\p{^Blk: - CJK_RADICALS_sup}', "");
    Expect(0, 12031, '\P{Blk: - CJK_RADICALS_sup}', "");
    Expect(1, 12031, '\P{^Blk: - CJK_RADICALS_sup}', "");
    Expect(0, 12032, '\p{Blk: - CJK_RADICALS_sup}', "");
    Expect(1, 12032, '\p{^Blk: - CJK_RADICALS_sup}', "");
    Expect(1, 12032, '\P{Blk: - CJK_RADICALS_sup}', "");
    Expect(0, 12032, '\P{^Blk: - CJK_RADICALS_sup}', "");
    Error('\p{Is_Block=-/a/CJK_Radicals_SUPPLEMENT}');
    Error('\P{Is_Block=-/a/CJK_Radicals_SUPPLEMENT}');
    Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\p{^Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\P{Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(1, 12031, '\P{^Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\p{Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\p{^Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\P{Is_Block=-CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\P{^Is_Block=-CJK_Radicals_Supplement}', "");
    Error('\p{Is_Blk=_:=CJK_RADICALS_SUP}');
    Error('\P{Is_Blk=_:=CJK_RADICALS_SUP}');
    Expect(1, 12031, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12031, '\p{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12031, '\P{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12031, '\P{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12032, '\p{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12032, '\p{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12032, '\P{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12032, '\P{^Is_Blk= cjk_Radicals_Sup}', "");
    Error('\p{Block=:=__CJK_Strokes}');
    Error('\P{Block=:=__CJK_Strokes}');
    Expect(1, 12783, '\p{Block: cjkstrokes}', "");
    Expect(0, 12783, '\p{^Block: cjkstrokes}', "");
    Expect(0, 12783, '\P{Block: cjkstrokes}', "");
    Expect(1, 12783, '\P{^Block: cjkstrokes}', "");
    Expect(0, 12784, '\p{Block: cjkstrokes}', "");
    Expect(1, 12784, '\p{^Block: cjkstrokes}', "");
    Expect(1, 12784, '\P{Block: cjkstrokes}', "");
    Expect(0, 12784, '\P{^Block: cjkstrokes}', "");
    Expect(1, 12783, '\p{Block=	 CJK_STROKES}', "");
    Expect(0, 12783, '\p{^Block=	 CJK_STROKES}', "");
    Expect(0, 12783, '\P{Block=	 CJK_STROKES}', "");
    Expect(1, 12783, '\P{^Block=	 CJK_STROKES}', "");
    Expect(0, 12784, '\p{Block=	 CJK_STROKES}', "");
    Expect(1, 12784, '\p{^Block=	 CJK_STROKES}', "");
    Expect(1, 12784, '\P{Block=	 CJK_STROKES}', "");
    Expect(0, 12784, '\P{^Block=	 CJK_STROKES}', "");
    Error('\p{Blk=-CJK_Strokes/a/}');
    Error('\P{Blk=-CJK_Strokes/a/}');
    Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Blk=		cjk_STROKES}', "");
    Expect(0, 12783, '\p{^Blk=		cjk_STROKES}', "");
    Expect(0, 12783, '\P{Blk=		cjk_STROKES}', "");
    Expect(1, 12783, '\P{^Blk=		cjk_STROKES}', "");
    Expect(0, 12784, '\p{Blk=		cjk_STROKES}', "");
    Expect(1, 12784, '\p{^Blk=		cjk_STROKES}', "");
    Expect(1, 12784, '\P{Blk=		cjk_STROKES}', "");
    Expect(0, 12784, '\P{^Blk=		cjk_STROKES}', "");
    Error('\p{Is_Block=	CJK_strokes:=}');
    Error('\P{Is_Block=	CJK_strokes:=}');
    Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Block=	 CJK_STROKES}', "");
    Expect(0, 12783, '\p{^Is_Block=	 CJK_STROKES}', "");
    Expect(0, 12783, '\P{Is_Block=	 CJK_STROKES}', "");
    Expect(1, 12783, '\P{^Is_Block=	 CJK_STROKES}', "");
    Expect(0, 12784, '\p{Is_Block=	 CJK_STROKES}', "");
    Expect(1, 12784, '\p{^Is_Block=	 CJK_STROKES}', "");
    Expect(1, 12784, '\P{Is_Block=	 CJK_STROKES}', "");
    Expect(0, 12784, '\P{^Is_Block=	 CJK_STROKES}', "");
    Error('\p{Is_Blk=_cjk_strokes/a/}');
    Error('\P{Is_Blk=_cjk_strokes/a/}');
    Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Blk=--CJK_STROKES}', "");
    Expect(0, 12783, '\p{^Is_Blk=--CJK_STROKES}', "");
    Expect(0, 12783, '\P{Is_Blk=--CJK_STROKES}', "");
    Expect(1, 12783, '\P{^Is_Blk=--CJK_STROKES}', "");
    Expect(0, 12784, '\p{Is_Blk=--CJK_STROKES}', "");
    Expect(1, 12784, '\p{^Is_Blk=--CJK_STROKES}', "");
    Expect(1, 12784, '\P{Is_Blk=--CJK_STROKES}', "");
    Expect(0, 12784, '\P{^Is_Blk=--CJK_STROKES}', "");
    Error('\p{Block=	-CJK_SYMBOLS_AND_PUNCTUATION:=}');
    Error('\P{Block=	-CJK_SYMBOLS_AND_PUNCTUATION:=}');
    Expect(1, 12351, '\p{Block:cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Block:cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Block:cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Block:cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Block:cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Block:cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Block:cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Block:cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(0, 12351, '\p{^Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(0, 12351, '\P{Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(1, 12351, '\P{^Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(0, 12352, '\p{Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(1, 12352, '\p{^Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(1, 12352, '\P{Block=	-CJK_Symbols_AND_Punctuation}', "");
    Expect(0, 12352, '\P{^Block=	-CJK_Symbols_AND_Punctuation}', "");
    Error('\p{Blk=	/a/CJK_Symbols}');
    Error('\P{Blk=	/a/CJK_Symbols}');
    Expect(1, 12351, '\p{Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Blk= 	CJK_SYMBOLS}', "");
    Expect(0, 12351, '\p{^Blk= 	CJK_SYMBOLS}', "");
    Expect(0, 12351, '\P{Blk= 	CJK_SYMBOLS}', "");
    Expect(1, 12351, '\P{^Blk= 	CJK_SYMBOLS}', "");
    Expect(0, 12352, '\p{Blk= 	CJK_SYMBOLS}', "");
    Expect(1, 12352, '\p{^Blk= 	CJK_SYMBOLS}', "");
    Expect(1, 12352, '\P{Blk= 	CJK_SYMBOLS}', "");
    Expect(0, 12352, '\P{^Blk= 	CJK_SYMBOLS}', "");
    Error('\p{Is_Block: :=_	CJK_Symbols_and_Punctuation}');
    Error('\P{Is_Block: :=_	CJK_Symbols_and_Punctuation}');
    Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12351, '\p{^Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12351, '\P{Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12351, '\P{^Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12352, '\p{Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12352, '\p{^Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12352, '\P{Is_Block= CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12352, '\P{^Is_Block= CJK_Symbols_and_Punctuation}', "");
    Error('\p{Is_Blk=/a/  cjk_symbols}');
    Error('\P{Is_Blk=/a/  cjk_symbols}');
    Expect(1, 12351, '\p{Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Is_Blk:   _CJK_Symbols}', "");
    Expect(0, 12351, '\p{^Is_Blk:   _CJK_Symbols}', "");
    Expect(0, 12351, '\P{Is_Blk:   _CJK_Symbols}', "");
    Expect(1, 12351, '\P{^Is_Blk:   _CJK_Symbols}', "");
    Expect(0, 12352, '\p{Is_Blk:   _CJK_Symbols}', "");
    Expect(1, 12352, '\p{^Is_Blk:   _CJK_Symbols}', "");
    Expect(1, 12352, '\P{Is_Blk:   _CJK_Symbols}', "");
    Expect(0, 12352, '\P{^Is_Blk:   _CJK_Symbols}', "");
    Error('\p{Block:   :=__Hangul_Compatibility_Jamo}');
    Error('\P{Block:   :=__Hangul_Compatibility_Jamo}');
    Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\p{^Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\P{Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12687, '\P{^Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\p{Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\p{^Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\P{Block= Hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\P{^Block= Hangul_COMPATIBILITY_Jamo}', "");
    Error('\p{Blk:-_Compat_Jamo/a/}');
    Error('\P{Blk:-_Compat_Jamo/a/}');
    Expect(1, 12687, '\p{Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Blk= _COMPAT_jamo}', "");
    Expect(0, 12687, '\p{^Blk= _COMPAT_jamo}', "");
    Expect(0, 12687, '\P{Blk= _COMPAT_jamo}', "");
    Expect(1, 12687, '\P{^Blk= _COMPAT_jamo}', "");
    Expect(0, 12688, '\p{Blk= _COMPAT_jamo}', "");
    Expect(1, 12688, '\p{^Blk= _COMPAT_jamo}', "");
    Expect(1, 12688, '\P{Blk= _COMPAT_jamo}', "");
    Expect(0, 12688, '\P{^Blk= _COMPAT_jamo}', "");
    Error('\p{Is_Block: _:=hangul_compatibility_Jamo}');
    Error('\P{Is_Block: _:=hangul_compatibility_Jamo}');
    Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(0, 12687, '\p{^Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(0, 12687, '\P{Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(1, 12687, '\P{^Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(0, 12688, '\p{Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(1, 12688, '\p{^Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(1, 12688, '\P{Is_Block=HANGUL_compatibility_Jamo}', "");
    Expect(0, 12688, '\P{^Is_Block=HANGUL_compatibility_Jamo}', "");
    Error('\p{Is_Blk=-/a/Compat_JAMO}');
    Error('\P{Is_Blk=-/a/Compat_JAMO}');
    Expect(1, 12687, '\p{Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Is_Blk=	 COMPAT_jamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=	 COMPAT_jamo}', "");
    Expect(0, 12687, '\P{Is_Blk=	 COMPAT_jamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=	 COMPAT_jamo}', "");
    Expect(0, 12688, '\p{Is_Blk=	 COMPAT_jamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=	 COMPAT_jamo}', "");
    Expect(1, 12688, '\P{Is_Blk=	 COMPAT_jamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=	 COMPAT_jamo}', "");
    Error('\p{Block=control_pictures:=}');
    Error('\P{Block=control_pictures:=}');
    Expect(1, 9279, '\p{Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Block=controlpictures}', "");
    Expect(0, 9279, '\P{Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Block=controlpictures}', "");
    Expect(0, 9280, '\p{Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Block=controlpictures}', "");
    Expect(1, 9280, '\P{Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Block=controlpictures}', "");
    Expect(1, 9279, '\p{Block=		Control_Pictures}', "");
    Expect(0, 9279, '\p{^Block=		Control_Pictures}', "");
    Expect(0, 9279, '\P{Block=		Control_Pictures}', "");
    Expect(1, 9279, '\P{^Block=		Control_Pictures}', "");
    Expect(0, 9280, '\p{Block=		Control_Pictures}', "");
    Expect(1, 9280, '\p{^Block=		Control_Pictures}', "");
    Expect(1, 9280, '\P{Block=		Control_Pictures}', "");
    Expect(0, 9280, '\P{^Block=		Control_Pictures}', "");
    Error('\p{Blk=_Control_pictures:=}');
    Error('\P{Blk=_Control_pictures:=}');
    Expect(1, 9279, '\p{Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Blk:   CONTROL_PICTURES}', "");
    Expect(0, 9279, '\p{^Blk:   CONTROL_PICTURES}', "");
    Expect(0, 9279, '\P{Blk:   CONTROL_PICTURES}', "");
    Expect(1, 9279, '\P{^Blk:   CONTROL_PICTURES}', "");
    Expect(0, 9280, '\p{Blk:   CONTROL_PICTURES}', "");
    Expect(1, 9280, '\p{^Blk:   CONTROL_PICTURES}', "");
    Expect(1, 9280, '\P{Blk:   CONTROL_PICTURES}', "");
    Expect(0, 9280, '\P{^Blk:   CONTROL_PICTURES}', "");
    Error('\p{Is_Block=:=-_Control_Pictures}');
    Error('\P{Is_Block=:=-_Control_Pictures}');
    Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Block= -CONTROL_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Block= -CONTROL_Pictures}', "");
    Expect(0, 9279, '\P{Is_Block= -CONTROL_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Block= -CONTROL_Pictures}', "");
    Expect(0, 9280, '\p{Is_Block= -CONTROL_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Block= -CONTROL_Pictures}', "");
    Expect(1, 9280, '\P{Is_Block= -CONTROL_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Block= -CONTROL_Pictures}', "");
    Error('\p{Is_Blk=/a/_Control_pictures}');
    Error('\P{Is_Blk=/a/_Control_pictures}');
    Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Blk=_Control_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=_Control_Pictures}', "");
    Expect(0, 9279, '\P{Is_Blk=_Control_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=_Control_Pictures}', "");
    Expect(0, 9280, '\p{Is_Blk=_Control_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=_Control_Pictures}', "");
    Expect(1, 9280, '\P{Is_Blk=_Control_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=_Control_Pictures}', "");
    Error('\p{Block= :=Coptic}');
    Error('\P{Block= :=Coptic}');
    Expect(1, 11519, '\p{Block=coptic}', "");
    Expect(0, 11519, '\p{^Block=coptic}', "");
    Expect(0, 11519, '\P{Block=coptic}', "");
    Expect(1, 11519, '\P{^Block=coptic}', "");
    Expect(0, 11520, '\p{Block=coptic}', "");
    Expect(1, 11520, '\p{^Block=coptic}', "");
    Expect(1, 11520, '\P{Block=coptic}', "");
    Expect(0, 11520, '\P{^Block=coptic}', "");
    Expect(1, 11519, '\p{Block=-_coptic}', "");
    Expect(0, 11519, '\p{^Block=-_coptic}', "");
    Expect(0, 11519, '\P{Block=-_coptic}', "");
    Expect(1, 11519, '\P{^Block=-_coptic}', "");
    Expect(0, 11520, '\p{Block=-_coptic}', "");
    Expect(1, 11520, '\p{^Block=-_coptic}', "");
    Expect(1, 11520, '\P{Block=-_coptic}', "");
    Expect(0, 11520, '\P{^Block=-_coptic}', "");
    Error('\p{Blk=:=_-Coptic}');
    Error('\P{Blk=:=_-Coptic}');
    Expect(1, 11519, '\p{Blk=coptic}', "");
    Expect(0, 11519, '\p{^Blk=coptic}', "");
    Expect(0, 11519, '\P{Blk=coptic}', "");
    Expect(1, 11519, '\P{^Blk=coptic}', "");
    Expect(0, 11520, '\p{Blk=coptic}', "");
    Expect(1, 11520, '\p{^Blk=coptic}', "");
    Expect(1, 11520, '\P{Blk=coptic}', "");
    Expect(0, 11520, '\P{^Blk=coptic}', "");
    Error('\p{Is_Block= COPTIC:=}');
    Error('\P{Is_Block= COPTIC:=}');
    Expect(1, 11519, '\p{Is_Block:   coptic}', "");
    Expect(0, 11519, '\p{^Is_Block:   coptic}', "");
    Expect(0, 11519, '\P{Is_Block:   coptic}', "");
    Expect(1, 11519, '\P{^Is_Block:   coptic}', "");
    Expect(0, 11520, '\p{Is_Block:   coptic}', "");
    Expect(1, 11520, '\p{^Is_Block:   coptic}', "");
    Expect(1, 11520, '\P{Is_Block:   coptic}', "");
    Expect(0, 11520, '\P{^Is_Block:   coptic}', "");
    Expect(1, 11519, '\p{Is_Block=--coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=--coptic}', "");
    Expect(0, 11519, '\P{Is_Block=--coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=--coptic}', "");
    Expect(0, 11520, '\p{Is_Block=--coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=--coptic}', "");
    Expect(1, 11520, '\P{Is_Block=--coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=--coptic}', "");
    Error('\p{Is_Blk=	_coptic:=}');
    Error('\P{Is_Blk=	_coptic:=}');
    Expect(1, 11519, '\p{Is_Blk=coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
    Expect(1, 11519, '\p{Is_Blk=--coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=--coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=--coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=--coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=--coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=--coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=--coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=--coptic}', "");
    Error('\p{Block= Coptic_epact_Numbers:=}');
    Error('\P{Block= Coptic_epact_Numbers:=}');
    Expect(1, 66303, '\p{Block: copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Block: copticepactnumbers}', "");
    Expect(0, 66303, '\P{Block: copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Block: copticepactnumbers}', "");
    Expect(0, 66304, '\p{Block: copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Block: copticepactnumbers}', "");
    Expect(1, 66304, '\P{Block: copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Block: copticepactnumbers}', "");
    Expect(1, 66303, '\p{Block:	--coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Block:	--coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Block:	--coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Block:	--coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Block:	--coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Block:	--coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Block:	--coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Block:	--coptic_Epact_Numbers}', "");
    Error('\p{Blk=:=- Coptic_Epact_Numbers}');
    Error('\P{Blk=:=- Coptic_Epact_Numbers}');
    Expect(1, 66303, '\p{Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(0, 66303, '\p{^Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(0, 66303, '\P{Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(1, 66303, '\P{^Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(0, 66304, '\p{Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(1, 66304, '\p{^Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(1, 66304, '\P{Blk=	COPTIC_EPACT_Numbers}', "");
    Expect(0, 66304, '\P{^Blk=	COPTIC_EPACT_Numbers}', "");
    Error('\p{Is_Block=:=--Coptic_epact_NUMBERS}');
    Error('\P{Is_Block=:=--Coptic_epact_NUMBERS}');
    Expect(1, 66303, '\p{Is_Block:	copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Block:	copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Block:	copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Block:	copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Block:	copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Block:	copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Block:	copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Block:	copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\p{^Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\P{Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(1, 66303, '\P{^Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\p{Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\p{^Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\P{Is_Block=		coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\P{^Is_Block=		coptic_Epact_NUMBERS}', "");
    Error('\p{Is_Blk:	-:=Coptic_EPACT_NUMBERS}');
    Error('\P{Is_Blk:	-:=Coptic_EPACT_NUMBERS}');
    Expect(1, 66303, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Blk=_COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=_COPTIC_Epact_Numbers}', "");
    Error('\p{Block=:= 	Counting_Rod_Numerals}');
    Error('\P{Block=:= 	Counting_Rod_Numerals}');
    Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Block=_counting_Rod_NUMERALS}', "");
    Expect(0, 119679, '\p{^Block=_counting_Rod_NUMERALS}', "");
    Expect(0, 119679, '\P{Block=_counting_Rod_NUMERALS}', "");
    Expect(1, 119679, '\P{^Block=_counting_Rod_NUMERALS}', "");
    Expect(0, 119680, '\p{Block=_counting_Rod_NUMERALS}', "");
    Expect(1, 119680, '\p{^Block=_counting_Rod_NUMERALS}', "");
    Expect(1, 119680, '\P{Block=_counting_Rod_NUMERALS}', "");
    Expect(0, 119680, '\P{^Block=_counting_Rod_NUMERALS}', "");
    Error('\p{Blk= Counting_Rod:=}');
    Error('\P{Blk= Counting_Rod:=}');
    Expect(1, 119679, '\p{Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Blk=countingrod}', "");
    Expect(0, 119679, '\P{Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Blk=countingrod}', "");
    Expect(0, 119680, '\p{Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Blk=countingrod}', "");
    Expect(1, 119680, '\P{Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Blk=countingrod}', "");
    Expect(1, 119679, '\p{Blk=	counting_Rod}', "");
    Expect(0, 119679, '\p{^Blk=	counting_Rod}', "");
    Expect(0, 119679, '\P{Blk=	counting_Rod}', "");
    Expect(1, 119679, '\P{^Blk=	counting_Rod}', "");
    Expect(0, 119680, '\p{Blk=	counting_Rod}', "");
    Expect(1, 119680, '\p{^Blk=	counting_Rod}', "");
    Expect(1, 119680, '\P{Blk=	counting_Rod}', "");
    Expect(0, 119680, '\P{^Blk=	counting_Rod}', "");
    Error('\p{Is_Block:	:=	COUNTING_rod_numerals}');
    Error('\P{Is_Block:	:=	COUNTING_rod_numerals}');
    Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Is_Block=counting_ROD_Numerals}', "");
    Expect(0, 119679, '\p{^Is_Block=counting_ROD_Numerals}', "");
    Expect(0, 119679, '\P{Is_Block=counting_ROD_Numerals}', "");
    Expect(1, 119679, '\P{^Is_Block=counting_ROD_Numerals}', "");
    Expect(0, 119680, '\p{Is_Block=counting_ROD_Numerals}', "");
    Expect(1, 119680, '\p{^Is_Block=counting_ROD_Numerals}', "");
    Expect(1, 119680, '\P{Is_Block=counting_ROD_Numerals}', "");
    Expect(0, 119680, '\P{^Is_Block=counting_ROD_Numerals}', "");
    Error('\p{Is_Blk=	Counting_ROD/a/}');
    Error('\P{Is_Blk=	Counting_ROD/a/}');
    Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
    Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
    Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
    Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
    Expect(1, 119679, '\p{Is_Blk=-_counting_Rod}', "");
    Expect(0, 119679, '\p{^Is_Blk=-_counting_Rod}', "");
    Expect(0, 119679, '\P{Is_Blk=-_counting_Rod}', "");
    Expect(1, 119679, '\P{^Is_Blk=-_counting_Rod}', "");
    Expect(0, 119680, '\p{Is_Blk=-_counting_Rod}', "");
    Expect(1, 119680, '\p{^Is_Blk=-_counting_Rod}', "");
    Expect(1, 119680, '\P{Is_Blk=-_counting_Rod}', "");
    Expect(0, 119680, '\P{^Is_Blk=-_counting_Rod}', "");
    Error('\p{Block=__CUNEIFORM/a/}');
    Error('\P{Block=__CUNEIFORM/a/}');
    Expect(1, 74751, '\p{Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Block=cuneiform}', "");
    Expect(0, 74751, '\P{Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Block=cuneiform}', "");
    Expect(0, 74752, '\p{Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Block=cuneiform}', "");
    Expect(1, 74752, '\P{Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Block=cuneiform}', "");
    Expect(1, 74751, '\p{Block=Cuneiform}', "");
    Expect(0, 74751, '\p{^Block=Cuneiform}', "");
    Expect(0, 74751, '\P{Block=Cuneiform}', "");
    Expect(1, 74751, '\P{^Block=Cuneiform}', "");
    Expect(0, 74752, '\p{Block=Cuneiform}', "");
    Expect(1, 74752, '\p{^Block=Cuneiform}', "");
    Expect(1, 74752, '\P{Block=Cuneiform}', "");
    Expect(0, 74752, '\P{^Block=Cuneiform}', "");
    Error('\p{Blk=	:=cuneiform}');
    Error('\P{Blk=	:=cuneiform}');
    Expect(1, 74751, '\p{Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Blk= cuneiform}', "");
    Expect(0, 74751, '\p{^Blk= cuneiform}', "");
    Expect(0, 74751, '\P{Blk= cuneiform}', "");
    Expect(1, 74751, '\P{^Blk= cuneiform}', "");
    Expect(0, 74752, '\p{Blk= cuneiform}', "");
    Expect(1, 74752, '\p{^Blk= cuneiform}', "");
    Expect(1, 74752, '\P{Blk= cuneiform}', "");
    Expect(0, 74752, '\P{^Blk= cuneiform}', "");
    Error('\p{Is_Block=/a/ 	Cuneiform}');
    Error('\P{Is_Block=/a/ 	Cuneiform}');
    Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Block=-cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block=-cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block=-cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block=-cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block=-cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block=-cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block=-cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block=-cuneiform}', "");
    Error('\p{Is_Blk=:=-cuneiform}');
    Error('\P{Is_Blk=:=-cuneiform}');
    Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Blk=_-cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=_-cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=_-cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=_-cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=_-cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=_-cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=_-cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=_-cuneiform}', "");
    Error('\p{Block=_-Cuneiform_NUMBERS_and_Punctuation/a/}');
    Error('\P{Block=_-Cuneiform_NUMBERS_and_Punctuation/a/}');
    Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74879, '\p{^Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74879, '\P{Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74879, '\P{^Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74880, '\p{Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74880, '\p{^Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74880, '\P{Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74880, '\P{^Block:   _CUNEIFORM_Numbers_And_Punctuation}', "");
    Error('\p{Blk=_/a/Cuneiform_Numbers}');
    Error('\P{Blk=_/a/Cuneiform_Numbers}');
    Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Blk=__cuneiform_Numbers}', "");
    Expect(0, 74879, '\p{^Blk=__cuneiform_Numbers}', "");
    Expect(0, 74879, '\P{Blk=__cuneiform_Numbers}', "");
    Expect(1, 74879, '\P{^Blk=__cuneiform_Numbers}', "");
    Expect(0, 74880, '\p{Blk=__cuneiform_Numbers}', "");
    Expect(1, 74880, '\p{^Blk=__cuneiform_Numbers}', "");
    Expect(1, 74880, '\P{Blk=__cuneiform_Numbers}', "");
    Expect(0, 74880, '\P{^Blk=__cuneiform_Numbers}', "");
    Error('\p{Is_Block=	/a/CUNEIFORM_NUMBERS_And_PUNCTUATION}');
    Error('\P{Is_Block=	/a/CUNEIFORM_NUMBERS_And_PUNCTUATION}');
    Expect(1, 74879, '\p{Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Is_Block:	cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(0, 74879, '\P{Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(0, 74880, '\p{Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(1, 74880, '\P{Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=_CUNEIFORM_Numbers_and_punctuation}', "");
    Error('\p{Is_Blk=	Cuneiform_Numbers:=}');
    Error('\P{Is_Blk=	Cuneiform_Numbers:=}');
    Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(0, 74879, '\P{Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(0, 74880, '\p{Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(1, 74880, '\P{Is_Blk=_ Cuneiform_Numbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=_ Cuneiform_Numbers}', "");
    Error('\p{Block=__currency_Symbols/a/}');
    Error('\P{Block=__currency_Symbols/a/}');
    Expect(1, 8399, '\p{Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Block=--Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Block=--Currency_Symbols}', "");
    Expect(0, 8399, '\P{Block=--Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Block=--Currency_Symbols}', "");
    Expect(0, 8400, '\p{Block=--Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Block=--Currency_Symbols}', "");
    Expect(1, 8400, '\P{Block=--Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Block=--Currency_Symbols}', "");
    Error('\p{Blk=	CURRENCY_Symbols/a/}');
    Error('\P{Blk=	CURRENCY_Symbols/a/}');
    Expect(1, 8399, '\p{Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Blk= Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Blk= Currency_Symbols}', "");
    Expect(0, 8399, '\P{Blk= Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Blk= Currency_Symbols}', "");
    Expect(0, 8400, '\p{Blk= Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Blk= Currency_Symbols}', "");
    Expect(1, 8400, '\P{Blk= Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Blk= Currency_Symbols}', "");
    Error('\p{Is_Block= /a/CURRENCY_symbols}');
    Error('\P{Is_Block= /a/CURRENCY_symbols}');
    Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Block=_	currency_symbols}', "");
    Expect(0, 8399, '\p{^Is_Block=_	currency_symbols}', "");
    Expect(0, 8399, '\P{Is_Block=_	currency_symbols}', "");
    Expect(1, 8399, '\P{^Is_Block=_	currency_symbols}', "");
    Expect(0, 8400, '\p{Is_Block=_	currency_symbols}', "");
    Expect(1, 8400, '\p{^Is_Block=_	currency_symbols}', "");
    Expect(1, 8400, '\P{Is_Block=_	currency_symbols}', "");
    Expect(0, 8400, '\P{^Is_Block=_	currency_symbols}', "");
    Error('\p{Is_Blk:   _	Currency_symbols/a/}');
    Error('\P{Is_Blk:   _	Currency_symbols/a/}');
    Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Blk=_CURRENCY_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=_CURRENCY_Symbols}', "");
    Expect(0, 8399, '\P{Is_Blk=_CURRENCY_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=_CURRENCY_Symbols}', "");
    Expect(0, 8400, '\p{Is_Blk=_CURRENCY_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=_CURRENCY_Symbols}', "");
    Expect(1, 8400, '\P{Is_Blk=_CURRENCY_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=_CURRENCY_Symbols}', "");
    Error('\p{Block= _Cypriot_Syllabary/a/}');
    Error('\P{Block= _Cypriot_Syllabary/a/}');
    Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Block=	_cypriot_Syllabary}', "");
    Expect(0, 67647, '\p{^Block=	_cypriot_Syllabary}', "");
    Expect(0, 67647, '\P{Block=	_cypriot_Syllabary}', "");
    Expect(1, 67647, '\P{^Block=	_cypriot_Syllabary}', "");
    Expect(0, 67648, '\p{Block=	_cypriot_Syllabary}', "");
    Expect(1, 67648, '\p{^Block=	_cypriot_Syllabary}', "");
    Expect(1, 67648, '\P{Block=	_cypriot_Syllabary}', "");
    Expect(0, 67648, '\P{^Block=	_cypriot_Syllabary}', "");
    Error('\p{Blk=:=Cypriot_Syllabary}');
    Error('\P{Blk=:=Cypriot_Syllabary}');
    Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Blk: 	_CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\p{^Blk: 	_CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\P{Blk: 	_CYPRIOT_syllabary}', "");
    Expect(1, 67647, '\P{^Blk: 	_CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\p{Blk: 	_CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\p{^Blk: 	_CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\P{Blk: 	_CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\P{^Blk: 	_CYPRIOT_syllabary}', "");
    Error('\p{Is_Block= cypriot_syllabary/a/}');
    Error('\P{Is_Block= cypriot_syllabary/a/}');
    Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Block=-_Cypriot_Syllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=-_Cypriot_Syllabary}', "");
    Expect(0, 67647, '\P{Is_Block=-_Cypriot_Syllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=-_Cypriot_Syllabary}', "");
    Expect(0, 67648, '\p{Is_Block=-_Cypriot_Syllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=-_Cypriot_Syllabary}', "");
    Expect(1, 67648, '\P{Is_Block=-_Cypriot_Syllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=-_Cypriot_Syllabary}', "");
    Error('\p{Is_Blk=-/a/Cypriot_SYLLABARY}');
    Error('\P{Is_Blk=-/a/Cypriot_SYLLABARY}');
    Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Blk=CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=CYPRIOT_syllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=CYPRIOT_syllabary}', "");
    Error('\p{Block=	:=cyrillic}');
    Error('\P{Block=	:=cyrillic}');
    Expect(1, 1279, '\p{Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Block=cyrillic}', "");
    Expect(0, 1279, '\P{Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Block=cyrillic}', "");
    Expect(0, 1280, '\p{Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Block=cyrillic}', "");
    Expect(1, 1280, '\P{Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Block=cyrillic}', "");
    Expect(1, 1279, '\p{Block=-	CYRILLIC}', "");
    Expect(0, 1279, '\p{^Block=-	CYRILLIC}', "");
    Expect(0, 1279, '\P{Block=-	CYRILLIC}', "");
    Expect(1, 1279, '\P{^Block=-	CYRILLIC}', "");
    Expect(0, 1280, '\p{Block=-	CYRILLIC}', "");
    Expect(1, 1280, '\p{^Block=-	CYRILLIC}', "");
    Expect(1, 1280, '\P{Block=-	CYRILLIC}', "");
    Expect(0, 1280, '\P{^Block=-	CYRILLIC}', "");
    Error('\p{Blk:		:=Cyrillic}');
    Error('\P{Blk:		:=Cyrillic}');
    Expect(1, 1279, '\p{Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Blk=_CYRILLIC}', "");
    Expect(0, 1279, '\p{^Blk=_CYRILLIC}', "");
    Expect(0, 1279, '\P{Blk=_CYRILLIC}', "");
    Expect(1, 1279, '\P{^Blk=_CYRILLIC}', "");
    Expect(0, 1280, '\p{Blk=_CYRILLIC}', "");
    Expect(1, 1280, '\p{^Blk=_CYRILLIC}', "");
    Expect(1, 1280, '\P{Blk=_CYRILLIC}', "");
    Expect(0, 1280, '\P{^Blk=_CYRILLIC}', "");
    Error('\p{Is_Block=-/a/cyrillic}');
    Error('\P{Is_Block=-/a/cyrillic}');
    Expect(1, 1279, '\p{Is_Block:	cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block:	cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block:	cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block:	cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block:	cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block:	cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block:	cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block:	cyrillic}', "");
    Expect(1, 1279, '\p{Is_Block= -Cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block= -Cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block= -Cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block= -Cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block= -Cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block= -Cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block= -Cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block= -Cyrillic}', "");
    Error('\p{Is_Blk= 	Cyrillic/a/}');
    Error('\P{Is_Blk= 	Cyrillic/a/}');
    Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Blk=--cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=--cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=--cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=--cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=--cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=--cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=--cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=--cyrillic}', "");
    Error('\p{Block:   :=_-cyrillic_extended_A}');
    Error('\P{Block:   :=_-cyrillic_extended_A}');
    Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Block=- Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\p{^Block=- Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\P{Block=- Cyrillic_Extended_A}', "");
    Expect(1, 11775, '\P{^Block=- Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\p{Block=- Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\p{^Block=- Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\P{Block=- Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\P{^Block=- Cyrillic_Extended_A}', "");
    Error('\p{Blk=-	CYRILLIC_ext_A:=}');
    Error('\P{Blk=-	CYRILLIC_ext_A:=}');
    Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Blk=	 cyrillic_EXT_a}', "");
    Expect(0, 11775, '\p{^Blk=	 cyrillic_EXT_a}', "");
    Expect(0, 11775, '\P{Blk=	 cyrillic_EXT_a}', "");
    Expect(1, 11775, '\P{^Blk=	 cyrillic_EXT_a}', "");
    Expect(0, 11776, '\p{Blk=	 cyrillic_EXT_a}', "");
    Expect(1, 11776, '\p{^Blk=	 cyrillic_EXT_a}', "");
    Expect(1, 11776, '\P{Blk=	 cyrillic_EXT_a}', "");
    Expect(0, 11776, '\P{^Blk=	 cyrillic_EXT_a}', "");
    Error('\p{Is_Block:   _	CYRILLIC_Extended_A:=}');
    Error('\P{Is_Block:   _	CYRILLIC_Extended_A:=}');
    Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(0, 11775, '\p{^Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(0, 11775, '\P{Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(1, 11775, '\P{^Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(0, 11776, '\p{Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(1, 11776, '\p{^Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(1, 11776, '\P{Is_Block= -CYRILLIC_Extended_A}', "");
    Expect(0, 11776, '\P{^Is_Block= -CYRILLIC_Extended_A}', "");
    Error('\p{Is_Blk=	/a/CYRILLIC_Ext_A}');
    Error('\P{Is_Blk=	/a/CYRILLIC_Ext_A}');
    Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Is_Blk=		cyrillic_ext_A}', "");
    Expect(0, 11775, '\p{^Is_Blk=		cyrillic_ext_A}', "");
    Expect(0, 11775, '\P{Is_Blk=		cyrillic_ext_A}', "");
    Expect(1, 11775, '\P{^Is_Blk=		cyrillic_ext_A}', "");
    Expect(0, 11776, '\p{Is_Blk=		cyrillic_ext_A}', "");
    Expect(1, 11776, '\p{^Is_Blk=		cyrillic_ext_A}', "");
    Expect(1, 11776, '\P{Is_Blk=		cyrillic_ext_A}', "");
    Expect(0, 11776, '\P{^Is_Blk=		cyrillic_ext_A}', "");
    Error('\p{Block=-_Cyrillic_extended_B/a/}');
    Error('\P{Block=-_Cyrillic_extended_B/a/}');
    Expect(1, 42655, '\p{Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Block:-	Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\p{^Block:-	Cyrillic_Extended_B}', "");
    Expect(0, 42655, '\P{Block:-	Cyrillic_Extended_B}', "");
    Expect(1, 42655, '\P{^Block:-	Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\p{Block:-	Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\p{^Block:-	Cyrillic_Extended_B}', "");
    Expect(1, 42656, '\P{Block:-	Cyrillic_Extended_B}', "");
    Expect(0, 42656, '\P{^Block:-	Cyrillic_Extended_B}', "");
    Error('\p{Blk=:=	CYRILLIC_Ext_b}');
    Error('\P{Blk=:=	CYRILLIC_Ext_b}');
    Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Blk=_ CYRILLIC_Ext_B}', "");
    Expect(0, 42655, '\p{^Blk=_ CYRILLIC_Ext_B}', "");
    Expect(0, 42655, '\P{Blk=_ CYRILLIC_Ext_B}', "");
    Expect(1, 42655, '\P{^Blk=_ CYRILLIC_Ext_B}', "");
    Expect(0, 42656, '\p{Blk=_ CYRILLIC_Ext_B}', "");
    Expect(1, 42656, '\p{^Blk=_ CYRILLIC_Ext_B}', "");
    Expect(1, 42656, '\P{Blk=_ CYRILLIC_Ext_B}', "");
    Expect(0, 42656, '\P{^Blk=_ CYRILLIC_Ext_B}', "");
    Error('\p{Is_Block=	:=Cyrillic_EXTENDED_B}');
    Error('\P{Is_Block=	:=Cyrillic_EXTENDED_B}');
    Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(0, 42655, '\p{^Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(0, 42655, '\P{Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(1, 42655, '\P{^Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(0, 42656, '\p{Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(1, 42656, '\p{^Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(1, 42656, '\P{Is_Block=		Cyrillic_EXTENDED_B}', "");
    Expect(0, 42656, '\P{^Is_Block=		Cyrillic_EXTENDED_B}', "");
    Error('\p{Is_Blk=:=	_Cyrillic_EXT_b}');
    Error('\P{Is_Blk=:=	_Cyrillic_EXT_b}');
    Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(0, 42655, '\p{^Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(0, 42655, '\P{Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(1, 42655, '\P{^Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(0, 42656, '\p{Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(1, 42656, '\p{^Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(1, 42656, '\P{Is_Blk=-_Cyrillic_EXT_B}', "");
    Expect(0, 42656, '\P{^Is_Blk=-_Cyrillic_EXT_B}', "");
    Error('\p{Block=:= -CYRILLIC_Extended_C}');
    Error('\P{Block=:= -CYRILLIC_Extended_C}');
    Expect(1, 7311, '\p{Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Block=_-CYRILLIC_extended_c}', "");
    Expect(0, 7311, '\p{^Block=_-CYRILLIC_extended_c}', "");
    Expect(0, 7311, '\P{Block=_-CYRILLIC_extended_c}', "");
    Expect(1, 7311, '\P{^Block=_-CYRILLIC_extended_c}', "");
    Expect(0, 7312, '\p{Block=_-CYRILLIC_extended_c}', "");
    Expect(1, 7312, '\p{^Block=_-CYRILLIC_extended_c}', "");
    Expect(1, 7312, '\P{Block=_-CYRILLIC_extended_c}', "");
    Expect(0, 7312, '\P{^Block=_-CYRILLIC_extended_c}', "");
    Error('\p{Blk=:= cyrillic_EXT_c}');
    Error('\P{Blk=:= cyrillic_EXT_c}');
    Expect(1, 7311, '\p{Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Blk=		CYRILLIC_EXT_C}', "");
    Expect(0, 7311, '\p{^Blk=		CYRILLIC_EXT_C}', "");
    Expect(0, 7311, '\P{Blk=		CYRILLIC_EXT_C}', "");
    Expect(1, 7311, '\P{^Blk=		CYRILLIC_EXT_C}', "");
    Expect(0, 7312, '\p{Blk=		CYRILLIC_EXT_C}', "");
    Expect(1, 7312, '\p{^Blk=		CYRILLIC_EXT_C}', "");
    Expect(1, 7312, '\P{Blk=		CYRILLIC_EXT_C}', "");
    Expect(0, 7312, '\P{^Blk=		CYRILLIC_EXT_C}', "");
    Error('\p{Is_Block=:=Cyrillic_Extended_C}');
    Error('\P{Is_Block=:=Cyrillic_Extended_C}');
    Expect(1, 7311, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(0, 7311, '\p{^Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(0, 7311, '\P{Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(1, 7311, '\P{^Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(0, 7312, '\p{Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(1, 7312, '\p{^Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(1, 7312, '\P{Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Expect(0, 7312, '\P{^Is_Block:   	CYRILLIC_EXTENDED_C}', "");
    Error('\p{Is_Blk= _Cyrillic_EXT_c/a/}');
    Error('\P{Is_Blk= _Cyrillic_EXT_c/a/}');
    Expect(1, 7311, '\p{Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(0, 7311, '\p{^Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(0, 7311, '\P{Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(1, 7311, '\P{^Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(0, 7312, '\p{Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(1, 7312, '\p{^Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(1, 7312, '\P{Is_Blk= 	Cyrillic_Ext_C}', "");
    Expect(0, 7312, '\P{^Is_Blk= 	Cyrillic_Ext_C}', "");
    Error('\p{Block=-/a/Cyrillic_supplement}');
    Error('\P{Block=-/a/Cyrillic_supplement}');
    Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Block= cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Block= cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Block= cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Block= cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Block= cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Block= cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Block= cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Block= cyrillic_Supplement}', "");
    Error('\p{Blk=/a/_	cyrillic_Sup}');
    Error('\P{Blk=/a/_	cyrillic_Sup}');
    Expect(1, 1327, '\p{Blk:cyrillicsup}', "");
    Expect(0, 1327, '\p{^Blk:cyrillicsup}', "");
    Expect(0, 1327, '\P{Blk:cyrillicsup}', "");
    Expect(1, 1327, '\P{^Blk:cyrillicsup}', "");
    Expect(0, 1328, '\p{Blk:cyrillicsup}', "");
    Expect(1, 1328, '\p{^Blk:cyrillicsup}', "");
    Expect(1, 1328, '\P{Blk:cyrillicsup}', "");
    Expect(0, 1328, '\P{^Blk:cyrillicsup}', "");
    Expect(1, 1327, '\p{Blk=_cyrillic_SUP}', "");
    Expect(0, 1327, '\p{^Blk=_cyrillic_SUP}', "");
    Expect(0, 1327, '\P{Blk=_cyrillic_SUP}', "");
    Expect(1, 1327, '\P{^Blk=_cyrillic_SUP}', "");
    Expect(0, 1328, '\p{Blk=_cyrillic_SUP}', "");
    Expect(1, 1328, '\p{^Blk=_cyrillic_SUP}', "");
    Expect(1, 1328, '\P{Blk=_cyrillic_SUP}', "");
    Expect(0, 1328, '\P{^Blk=_cyrillic_SUP}', "");
    Error('\p{Is_Block=:=	 cyrillic_Supplementary}');
    Error('\P{Is_Block=:=	 cyrillic_Supplementary}');
    Expect(1, 1327, '\p{Is_Block:   cyrillicsupplementary}', "");
    Expect(0, 1327, '\p{^Is_Block:   cyrillicsupplementary}', "");
    Expect(0, 1327, '\P{Is_Block:   cyrillicsupplementary}', "");
    Expect(1, 1327, '\P{^Is_Block:   cyrillicsupplementary}', "");
    Expect(0, 1328, '\p{Is_Block:   cyrillicsupplementary}', "");
    Expect(1, 1328, '\p{^Is_Block:   cyrillicsupplementary}', "");
    Expect(1, 1328, '\P{Is_Block:   cyrillicsupplementary}', "");
    Expect(0, 1328, '\P{^Is_Block:   cyrillicsupplementary}', "");
    Expect(1, 1327, '\p{Is_Block= -Cyrillic_supplementary}', "");
    Expect(0, 1327, '\p{^Is_Block= -Cyrillic_supplementary}', "");
    Expect(0, 1327, '\P{Is_Block= -Cyrillic_supplementary}', "");
    Expect(1, 1327, '\P{^Is_Block= -Cyrillic_supplementary}', "");
    Expect(0, 1328, '\p{Is_Block= -Cyrillic_supplementary}', "");
    Expect(1, 1328, '\p{^Is_Block= -Cyrillic_supplementary}', "");
    Expect(1, 1328, '\P{Is_Block= -Cyrillic_supplementary}', "");
    Expect(0, 1328, '\P{^Is_Block= -Cyrillic_supplementary}', "");
    Error('\p{Is_Blk= :=cyrillic_Supplement}');
    Error('\P{Is_Blk= :=cyrillic_Supplement}');
    Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(0, 1327, '\p{^Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(0, 1327, '\P{Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(1, 1327, '\P{^Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(0, 1328, '\p{Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(1, 1328, '\p{^Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(1, 1328, '\P{Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Expect(0, 1328, '\P{^Is_Blk=_ Cyrillic_SUPPLEMENT}', "");
    Error('\p{Block=:=_-Deseret}');
    Error('\P{Block=:=_-Deseret}');
    Expect(1, 66639, '\p{Block=deseret}', "");
    Expect(0, 66639, '\p{^Block=deseret}', "");
    Expect(0, 66639, '\P{Block=deseret}', "");
    Expect(1, 66639, '\P{^Block=deseret}', "");
    Expect(0, 66640, '\p{Block=deseret}', "");
    Expect(1, 66640, '\p{^Block=deseret}', "");
    Expect(1, 66640, '\P{Block=deseret}', "");
    Expect(0, 66640, '\P{^Block=deseret}', "");
    Expect(1, 66639, '\p{Block=_-Deseret}', "");
    Expect(0, 66639, '\p{^Block=_-Deseret}', "");
    Expect(0, 66639, '\P{Block=_-Deseret}', "");
    Expect(1, 66639, '\P{^Block=_-Deseret}', "");
    Expect(0, 66640, '\p{Block=_-Deseret}', "");
    Expect(1, 66640, '\p{^Block=_-Deseret}', "");
    Expect(1, 66640, '\P{Block=_-Deseret}', "");
    Expect(0, 66640, '\P{^Block=_-Deseret}', "");
    Error('\p{Blk=/a/ Deseret}');
    Error('\P{Blk=/a/ Deseret}');
    Expect(1, 66639, '\p{Blk=deseret}', "");
    Expect(0, 66639, '\p{^Blk=deseret}', "");
    Expect(0, 66639, '\P{Blk=deseret}', "");
    Expect(1, 66639, '\P{^Blk=deseret}', "");
    Expect(0, 66640, '\p{Blk=deseret}', "");
    Expect(1, 66640, '\p{^Blk=deseret}', "");
    Expect(1, 66640, '\P{Blk=deseret}', "");
    Expect(0, 66640, '\P{^Blk=deseret}', "");
    Expect(1, 66639, '\p{Blk=__DESERET}', "");
    Expect(0, 66639, '\p{^Blk=__DESERET}', "");
    Expect(0, 66639, '\P{Blk=__DESERET}', "");
    Expect(1, 66639, '\P{^Blk=__DESERET}', "");
    Expect(0, 66640, '\p{Blk=__DESERET}', "");
    Expect(1, 66640, '\p{^Blk=__DESERET}', "");
    Expect(1, 66640, '\P{Blk=__DESERET}', "");
    Expect(0, 66640, '\P{^Blk=__DESERET}', "");
    Error('\p{Is_Block=_-deseret/a/}');
    Error('\P{Is_Block=_-deseret/a/}');
    Expect(1, 66639, '\p{Is_Block=deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=deseret}', "");
    Expect(0, 66639, '\P{Is_Block=deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=deseret}', "");
    Expect(0, 66640, '\p{Is_Block=deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=deseret}', "");
    Expect(1, 66640, '\P{Is_Block=deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=deseret}', "");
    Expect(1, 66639, '\p{Is_Block=-	deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=-	deseret}', "");
    Expect(0, 66639, '\P{Is_Block=-	deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=-	deseret}', "");
    Expect(0, 66640, '\p{Is_Block=-	deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=-	deseret}', "");
    Expect(1, 66640, '\P{Is_Block=-	deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=-	deseret}', "");
    Error('\p{Is_Blk=-:=Deseret}');
    Error('\P{Is_Blk=-:=Deseret}');
    Expect(1, 66639, '\p{Is_Blk=deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=deseret}', "");
    Expect(1, 66639, '\p{Is_Blk:   DESERET}', "");
    Expect(0, 66639, '\p{^Is_Blk:   DESERET}', "");
    Expect(0, 66639, '\P{Is_Blk:   DESERET}', "");
    Expect(1, 66639, '\P{^Is_Blk:   DESERET}', "");
    Expect(0, 66640, '\p{Is_Blk:   DESERET}', "");
    Expect(1, 66640, '\p{^Is_Blk:   DESERET}', "");
    Expect(1, 66640, '\P{Is_Blk:   DESERET}', "");
    Expect(0, 66640, '\P{^Is_Blk:   DESERET}', "");
    Error('\p{Block=/a/_	DEVANAGARI}');
    Error('\P{Block=/a/_	DEVANAGARI}');
    Expect(1, 2431, '\p{Block=devanagari}', "");
    Expect(0, 2431, '\p{^Block=devanagari}', "");
    Expect(0, 2431, '\P{Block=devanagari}', "");
    Expect(1, 2431, '\P{^Block=devanagari}', "");
    Expect(0, 2432, '\p{Block=devanagari}', "");
    Expect(1, 2432, '\p{^Block=devanagari}', "");
    Expect(1, 2432, '\P{Block=devanagari}', "");
    Expect(0, 2432, '\P{^Block=devanagari}', "");
    Expect(1, 2431, '\p{Block:   - Devanagari}', "");
    Expect(0, 2431, '\p{^Block:   - Devanagari}', "");
    Expect(0, 2431, '\P{Block:   - Devanagari}', "");
    Expect(1, 2431, '\P{^Block:   - Devanagari}', "");
    Expect(0, 2432, '\p{Block:   - Devanagari}', "");
    Expect(1, 2432, '\p{^Block:   - Devanagari}', "");
    Expect(1, 2432, '\P{Block:   - Devanagari}', "");
    Expect(0, 2432, '\P{^Block:   - Devanagari}', "");
    Error('\p{Blk=--DEVANAGARI:=}');
    Error('\P{Blk=--DEVANAGARI:=}');
    Expect(1, 2431, '\p{Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Blk=devanagari}', "");
    Expect(0, 2431, '\P{Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Blk=devanagari}', "");
    Expect(0, 2432, '\p{Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Blk=devanagari}', "");
    Expect(1, 2432, '\P{Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Blk=devanagari}', "");
    Expect(1, 2431, '\p{Blk=_	Devanagari}', "");
    Expect(0, 2431, '\p{^Blk=_	Devanagari}', "");
    Expect(0, 2431, '\P{Blk=_	Devanagari}', "");
    Expect(1, 2431, '\P{^Blk=_	Devanagari}', "");
    Expect(0, 2432, '\p{Blk=_	Devanagari}', "");
    Expect(1, 2432, '\p{^Blk=_	Devanagari}', "");
    Expect(1, 2432, '\P{Blk=_	Devanagari}', "");
    Expect(0, 2432, '\P{^Blk=_	Devanagari}', "");
    Error('\p{Is_Block=-:=devanagari}');
    Error('\P{Is_Block=-:=devanagari}');
    Expect(1, 2431, '\p{Is_Block=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
    Expect(1, 2431, '\p{Is_Block=_Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=_Devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=_Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=_Devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=_Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=_Devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=_Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=_Devanagari}', "");
    Error('\p{Is_Blk=/a/	-DEVANAGARI}');
    Error('\P{Is_Blk=/a/	-DEVANAGARI}');
    Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
    Expect(1, 2431, '\p{Is_Blk=-_Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=-_Devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=-_Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=-_Devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=-_Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=-_Devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=-_Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=-_Devanagari}', "");
    Error('\p{Block=:= devanagari_extended}');
    Error('\P{Block=:= devanagari_extended}');
    Expect(1, 43263, '\p{Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Block:_-Devanagari_Extended}', "");
    Expect(0, 43263, '\p{^Block:_-Devanagari_Extended}', "");
    Expect(0, 43263, '\P{Block:_-Devanagari_Extended}', "");
    Expect(1, 43263, '\P{^Block:_-Devanagari_Extended}', "");
    Expect(0, 43264, '\p{Block:_-Devanagari_Extended}', "");
    Expect(1, 43264, '\p{^Block:_-Devanagari_Extended}', "");
    Expect(1, 43264, '\P{Block:_-Devanagari_Extended}', "");
    Expect(0, 43264, '\P{^Block:_-Devanagari_Extended}', "");
    Error('\p{Blk=_DEVANAGARI_Ext/a/}');
    Error('\P{Blk=_DEVANAGARI_Ext/a/}');
    Expect(1, 43263, '\p{Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Blk=	_Devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Blk=	_Devanagari_Ext}', "");
    Expect(0, 43263, '\P{Blk=	_Devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Blk=	_Devanagari_Ext}', "");
    Expect(0, 43264, '\p{Blk=	_Devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Blk=	_Devanagari_Ext}', "");
    Expect(1, 43264, '\P{Blk=	_Devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Blk=	_Devanagari_Ext}', "");
    Error('\p{Is_Block: 	 devanagari_Extended:=}');
    Error('\P{Is_Block: 	 devanagari_Extended:=}');
    Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Is_Block:--Devanagari_Extended}', "");
    Expect(0, 43263, '\p{^Is_Block:--Devanagari_Extended}', "");
    Expect(0, 43263, '\P{Is_Block:--Devanagari_Extended}', "");
    Expect(1, 43263, '\P{^Is_Block:--Devanagari_Extended}', "");
    Expect(0, 43264, '\p{Is_Block:--Devanagari_Extended}', "");
    Expect(1, 43264, '\p{^Is_Block:--Devanagari_Extended}', "");
    Expect(1, 43264, '\P{Is_Block:--Devanagari_Extended}', "");
    Expect(0, 43264, '\P{^Is_Block:--Devanagari_Extended}', "");
    Error('\p{Is_Blk:   :=_Devanagari_EXT}');
    Error('\P{Is_Blk:   :=_Devanagari_EXT}');
    Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Is_Blk=	-devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Is_Blk=	-devanagari_Ext}', "");
    Expect(0, 43263, '\P{Is_Blk=	-devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Is_Blk=	-devanagari_Ext}', "");
    Expect(0, 43264, '\p{Is_Blk=	-devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Is_Blk=	-devanagari_Ext}', "");
    Expect(1, 43264, '\P{Is_Blk=	-devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Is_Blk=	-devanagari_Ext}', "");
    Error('\p{Block=/a/-COMBINING_Diacritical_Marks}');
    Error('\P{Block=/a/-COMBINING_Diacritical_Marks}');
    Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Block=_ Combining_diacritical_Marks}', "");
    Expect(0, 879, '\p{^Block=_ Combining_diacritical_Marks}', "");
    Expect(0, 879, '\P{Block=_ Combining_diacritical_Marks}', "");
    Expect(1, 879, '\P{^Block=_ Combining_diacritical_Marks}', "");
    Expect(0, 880, '\p{Block=_ Combining_diacritical_Marks}', "");
    Expect(1, 880, '\p{^Block=_ Combining_diacritical_Marks}', "");
    Expect(1, 880, '\P{Block=_ Combining_diacritical_Marks}', "");
    Expect(0, 880, '\P{^Block=_ Combining_diacritical_Marks}', "");
    Error('\p{Blk=	-Diacriticals/a/}');
    Error('\P{Blk=	-Diacriticals/a/}');
    Expect(1, 879, '\p{Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Blk=diacriticals}', "");
    Expect(0, 879, '\P{Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Blk=diacriticals}', "");
    Expect(0, 880, '\p{Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Blk=diacriticals}', "");
    Expect(1, 880, '\P{Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Blk=diacriticals}', "");
    Expect(1, 879, '\p{Blk= Diacriticals}', "");
    Expect(0, 879, '\p{^Blk= Diacriticals}', "");
    Expect(0, 879, '\P{Blk= Diacriticals}', "");
    Expect(1, 879, '\P{^Blk= Diacriticals}', "");
    Expect(0, 880, '\p{Blk= Diacriticals}', "");
    Expect(1, 880, '\p{^Blk= Diacriticals}', "");
    Expect(1, 880, '\P{Blk= Diacriticals}', "");
    Expect(0, 880, '\P{^Blk= Diacriticals}', "");
    Error('\p{Is_Block= _combining_diacritical_Marks/a/}');
    Error('\P{Is_Block= _combining_diacritical_Marks/a/}');
    Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\p{^Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\P{Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(1, 879, '\P{^Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\p{Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\p{^Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\P{Is_Block=_Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\P{^Is_Block=_Combining_Diacritical_Marks}', "");
    Error('\p{Is_Blk=/a/Diacriticals}');
    Error('\P{Is_Blk=/a/Diacriticals}');
    Expect(1, 879, '\p{Is_Blk:diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk:diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk:diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk:diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk:diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk:diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk:diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk:diacriticals}', "");
    Expect(1, 879, '\p{Is_Blk=_DIACRITICALS}', "");
    Expect(0, 879, '\p{^Is_Blk=_DIACRITICALS}', "");
    Expect(0, 879, '\P{Is_Blk=_DIACRITICALS}', "");
    Expect(1, 879, '\P{^Is_Blk=_DIACRITICALS}', "");
    Expect(0, 880, '\p{Is_Blk=_DIACRITICALS}', "");
    Expect(1, 880, '\p{^Is_Blk=_DIACRITICALS}', "");
    Expect(1, 880, '\P{Is_Blk=_DIACRITICALS}', "");
    Expect(0, 880, '\P{^Is_Blk=_DIACRITICALS}', "");
    Error('\p{Block=:=combining_DIACRITICAL_MARKS_extended}');
    Error('\P{Block=:=combining_DIACRITICAL_MARKS_extended}');
    Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Block:--combining_Diacritical_marks_Extended}', "");
    Expect(0, 6911, '\p{^Block:--combining_Diacritical_marks_Extended}', "");
    Expect(0, 6911, '\P{Block:--combining_Diacritical_marks_Extended}', "");
    Expect(1, 6911, '\P{^Block:--combining_Diacritical_marks_Extended}', "");
    Expect(0, 6912, '\p{Block:--combining_Diacritical_marks_Extended}', "");
    Expect(1, 6912, '\p{^Block:--combining_Diacritical_marks_Extended}', "");
    Expect(1, 6912, '\P{Block:--combining_Diacritical_marks_Extended}', "");
    Expect(0, 6912, '\P{^Block:--combining_Diacritical_marks_Extended}', "");
    Error('\p{Blk=:= Diacriticals_EXT}');
    Error('\P{Blk=:= Diacriticals_EXT}');
    Expect(1, 6911, '\p{Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Blk=  Diacriticals_Ext}', "");
    Expect(0, 6911, '\p{^Blk=  Diacriticals_Ext}', "");
    Expect(0, 6911, '\P{Blk=  Diacriticals_Ext}', "");
    Expect(1, 6911, '\P{^Blk=  Diacriticals_Ext}', "");
    Expect(0, 6912, '\p{Blk=  Diacriticals_Ext}', "");
    Expect(1, 6912, '\p{^Blk=  Diacriticals_Ext}', "");
    Expect(1, 6912, '\P{Blk=  Diacriticals_Ext}', "");
    Expect(0, 6912, '\P{^Blk=  Diacriticals_Ext}', "");
    Error('\p{Is_Block=-	Combining_DIACRITICAL_MARKS_Extended/a/}');
    Error('\P{Is_Block=-	Combining_DIACRITICAL_MARKS_Extended/a/}');
    Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(0, 6911, '\p{^Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(0, 6911, '\P{Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(1, 6911, '\P{^Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(0, 6912, '\p{Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(1, 6912, '\p{^Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(1, 6912, '\P{Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Expect(0, 6912, '\P{^Is_Block=	Combining_DIACRITICAL_marks_EXTENDED}', "");
    Error('\p{Is_Blk=-/a/Diacriticals_Ext}');
    Error('\P{Is_Blk=-/a/Diacriticals_Ext}');
    Expect(1, 6911, '\p{Is_Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\p{^Is_Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\P{Is_Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\P{^Is_Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\p{Is_Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\p{^Is_Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\P{Is_Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\P{^Is_Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\p{Is_Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6911, '\p{^Is_Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6911, '\P{Is_Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6911, '\P{^Is_Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6912, '\p{Is_Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6912, '\p{^Is_Blk=_-Diacriticals_EXT}', "");
    Expect(1, 6912, '\P{Is_Blk=_-Diacriticals_EXT}', "");
    Expect(0, 6912, '\P{^Is_Blk=_-Diacriticals_EXT}', "");
    Error('\p{Block=-_COMBINING_diacritical_MARKS_For_symbols:=}');
    Error('\P{Block=-_COMBINING_diacritical_MARKS_For_symbols:=}');
    Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(0, 8447, '\p{^Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(0, 8447, '\P{Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(1, 8447, '\P{^Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(0, 8448, '\p{Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(1, 8448, '\p{^Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(1, 8448, '\P{Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Expect(0, 8448, '\P{^Block=-	COMBINING_DIACRITICAL_MARKS_for_symbols}', "");
    Error('\p{Blk=:=Diacriticals_FOR_Symbols}');
    Error('\P{Blk=:=Diacriticals_FOR_Symbols}');
    Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\p{Blk=-_diacriticals_For_symbols}', "");
    Expect(0, 8447, '\p{^Blk=-_diacriticals_For_symbols}', "");
    Expect(0, 8447, '\P{Blk=-_diacriticals_For_symbols}', "");
    Expect(1, 8447, '\P{^Blk=-_diacriticals_For_symbols}', "");
    Expect(0, 8448, '\p{Blk=-_diacriticals_For_symbols}', "");
    Expect(1, 8448, '\p{^Blk=-_diacriticals_For_symbols}', "");
    Expect(1, 8448, '\P{Blk=-_diacriticals_For_symbols}', "");
    Expect(0, 8448, '\P{^Blk=-_diacriticals_For_symbols}', "");
    Error('\p{Is_Block=  Combining_MARKS_For_SYMBOLS:=}');
    Error('\P{Is_Block=  Combining_MARKS_For_SYMBOLS:=}');
    Expect(1, 8447, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(0, 8447, '\p{^Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(0, 8447, '\P{Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(1, 8447, '\P{^Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(0, 8448, '\p{Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(1, 8448, '\p{^Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(1, 8448, '\P{Is_Block=_combining_marks_FOR_Symbols}', "");
    Expect(0, 8448, '\P{^Is_Block=_combining_marks_FOR_Symbols}', "");
    Error('\p{Is_Blk= Combining_Diacritical_marks_For_Symbols:=}');
    Error('\P{Is_Blk= Combining_Diacritical_marks_For_Symbols:=}');
    Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8447, '\p{^Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8447, '\P{Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8447, '\P{^Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8448, '\p{Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8448, '\p{^Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(1, 8448, '\P{Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Expect(0, 8448, '\P{^Is_Blk=	Combining_Diacritical_Marks_FOR_SYMBOLS}', "");
    Error('\p{Block=-_Combining_DIACRITICAL_Marks_Supplement/a/}');
    Error('\P{Block=-_Combining_DIACRITICAL_Marks_Supplement/a/}');
    Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(0, 7679, '\p{^Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(0, 7679, '\P{Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(1, 7679, '\P{^Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(0, 7680, '\p{Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(1, 7680, '\p{^Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(1, 7680, '\P{Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Expect(0, 7680, '\P{^Block:	_	Combining_DIACRITICAL_Marks_Supplement}', "");
    Error('\p{Blk= :=Diacriticals_Sup}');
    Error('\P{Blk= :=Diacriticals_Sup}');
    Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Blk=__Diacriticals_Sup}', "");
    Expect(0, 7679, '\p{^Blk=__Diacriticals_Sup}', "");
    Expect(0, 7679, '\P{Blk=__Diacriticals_Sup}', "");
    Expect(1, 7679, '\P{^Blk=__Diacriticals_Sup}', "");
    Expect(0, 7680, '\p{Blk=__Diacriticals_Sup}', "");
    Expect(1, 7680, '\p{^Blk=__Diacriticals_Sup}', "");
    Expect(1, 7680, '\P{Blk=__Diacriticals_Sup}', "");
    Expect(0, 7680, '\P{^Blk=__Diacriticals_Sup}', "");
    Error('\p{Is_Block:	_combining_DIACRITICAL_marks_supplement/a/}');
    Error('\P{Is_Block:	_combining_DIACRITICAL_marks_supplement/a/}');
    Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(0, 7679, '\p{^Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(0, 7679, '\P{Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(1, 7679, '\P{^Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(0, 7680, '\p{Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(1, 7680, '\p{^Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(1, 7680, '\P{Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Expect(0, 7680, '\P{^Is_Block: 	COMBINING_diacritical_marks_Supplement}', "");
    Error('\p{Is_Blk:-_diacriticals_Sup/a/}');
    Error('\P{Is_Blk:-_diacriticals_Sup/a/}');
    Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Is_Blk=- Diacriticals_Sup}', "");
    Expect(0, 7679, '\p{^Is_Blk=- Diacriticals_Sup}', "");
    Expect(0, 7679, '\P{Is_Blk=- Diacriticals_Sup}', "");
    Expect(1, 7679, '\P{^Is_Blk=- Diacriticals_Sup}', "");
    Expect(0, 7680, '\p{Is_Blk=- Diacriticals_Sup}', "");
    Expect(1, 7680, '\p{^Is_Blk=- Diacriticals_Sup}', "");
    Expect(1, 7680, '\P{Is_Blk=- Diacriticals_Sup}', "");
    Expect(0, 7680, '\P{^Is_Blk=- Diacriticals_Sup}', "");
    Error('\p{Block=	/a/dingbats}');
    Error('\P{Block=	/a/dingbats}');
    Expect(1, 10175, '\p{Block=dingbats}', "");
    Expect(0, 10175, '\p{^Block=dingbats}', "");
    Expect(0, 10175, '\P{Block=dingbats}', "");
    Expect(1, 10175, '\P{^Block=dingbats}', "");
    Expect(0, 10176, '\p{Block=dingbats}', "");
    Expect(1, 10176, '\p{^Block=dingbats}', "");
    Expect(1, 10176, '\P{Block=dingbats}', "");
    Expect(0, 10176, '\P{^Block=dingbats}', "");
    Expect(1, 10175, '\p{Block= _Dingbats}', "");
    Expect(0, 10175, '\p{^Block= _Dingbats}', "");
    Expect(0, 10175, '\P{Block= _Dingbats}', "");
    Expect(1, 10175, '\P{^Block= _Dingbats}', "");
    Expect(0, 10176, '\p{Block= _Dingbats}', "");
    Expect(1, 10176, '\p{^Block= _Dingbats}', "");
    Expect(1, 10176, '\P{Block= _Dingbats}', "");
    Expect(0, 10176, '\P{^Block= _Dingbats}', "");
    Error('\p{Blk=/a/Dingbats}');
    Error('\P{Blk=/a/Dingbats}');
    Expect(1, 10175, '\p{Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Blk=dingbats}', "");
    Expect(0, 10175, '\P{Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Blk=dingbats}', "");
    Expect(0, 10176, '\p{Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Blk=dingbats}', "");
    Expect(1, 10176, '\P{Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Blk=dingbats}', "");
    Expect(1, 10175, '\p{Blk=	 DINGBATS}', "");
    Expect(0, 10175, '\p{^Blk=	 DINGBATS}', "");
    Expect(0, 10175, '\P{Blk=	 DINGBATS}', "");
    Expect(1, 10175, '\P{^Blk=	 DINGBATS}', "");
    Expect(0, 10176, '\p{Blk=	 DINGBATS}', "");
    Expect(1, 10176, '\p{^Blk=	 DINGBATS}', "");
    Expect(1, 10176, '\P{Blk=	 DINGBATS}', "");
    Expect(0, 10176, '\P{^Blk=	 DINGBATS}', "");
    Error('\p{Is_Block=--Dingbats/a/}');
    Error('\P{Is_Block=--Dingbats/a/}');
    Expect(1, 10175, '\p{Is_Block=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=dingbats}', "");
    Expect(1, 10175, '\p{Is_Block=_Dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=_Dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=_Dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=_Dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=_Dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=_Dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=_Dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=_Dingbats}', "");
    Error('\p{Is_Blk=:=dingbats}');
    Error('\P{Is_Blk=:=dingbats}');
    Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=dingbats}', "");
    Expect(1, 10175, '\p{Is_Blk=- dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=- dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=- dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=- dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=- dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=- dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=- dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=- dingbats}', "");
    Error('\p{Block=/a/		DOMINO_Tiles}');
    Error('\P{Block=/a/		DOMINO_Tiles}');
    Expect(1, 127135, '\p{Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Block=dominotiles}', "");
    Expect(0, 127135, '\P{Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Block=dominotiles}', "");
    Expect(0, 127136, '\p{Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Block=dominotiles}', "");
    Expect(1, 127136, '\P{Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Block=dominotiles}', "");
    Expect(1, 127135, '\p{Block=		domino_Tiles}', "");
    Expect(0, 127135, '\p{^Block=		domino_Tiles}', "");
    Expect(0, 127135, '\P{Block=		domino_Tiles}', "");
    Expect(1, 127135, '\P{^Block=		domino_Tiles}', "");
    Expect(0, 127136, '\p{Block=		domino_Tiles}', "");
    Expect(1, 127136, '\p{^Block=		domino_Tiles}', "");
    Expect(1, 127136, '\P{Block=		domino_Tiles}', "");
    Expect(0, 127136, '\P{^Block=		domino_Tiles}', "");
    Error('\p{Blk=Domino:=}');
    Error('\P{Blk=Domino:=}');
    Expect(1, 127135, '\p{Blk=domino}', "");
    Expect(0, 127135, '\p{^Blk=domino}', "");
    Expect(0, 127135, '\P{Blk=domino}', "");
    Expect(1, 127135, '\P{^Blk=domino}', "");
    Expect(0, 127136, '\p{Blk=domino}', "");
    Expect(1, 127136, '\p{^Blk=domino}', "");
    Expect(1, 127136, '\P{Blk=domino}', "");
    Expect(0, 127136, '\P{^Blk=domino}', "");
    Expect(1, 127135, '\p{Blk=		Domino}', "");
    Expect(0, 127135, '\p{^Blk=		Domino}', "");
    Expect(0, 127135, '\P{Blk=		Domino}', "");
    Expect(1, 127135, '\P{^Blk=		Domino}', "");
    Expect(0, 127136, '\p{Blk=		Domino}', "");
    Expect(1, 127136, '\p{^Blk=		Domino}', "");
    Expect(1, 127136, '\P{Blk=		Domino}', "");
    Expect(0, 127136, '\P{^Blk=		Domino}', "");
    Error('\p{Is_Block=:=_	DOMINO_TILES}');
    Error('\P{Is_Block=:=_	DOMINO_TILES}');
    Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
    Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
    Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
    Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
    Expect(1, 127135, '\p{Is_Block:    	DOMINO_TILES}', "");
    Expect(0, 127135, '\p{^Is_Block:    	DOMINO_TILES}', "");
    Expect(0, 127135, '\P{Is_Block:    	DOMINO_TILES}', "");
    Expect(1, 127135, '\P{^Is_Block:    	DOMINO_TILES}', "");
    Expect(0, 127136, '\p{Is_Block:    	DOMINO_TILES}', "");
    Expect(1, 127136, '\p{^Is_Block:    	DOMINO_TILES}', "");
    Expect(1, 127136, '\P{Is_Block:    	DOMINO_TILES}', "");
    Expect(0, 127136, '\P{^Is_Block:    	DOMINO_TILES}', "");
    Error('\p{Is_Blk= /a/DOMINO}');
    Error('\P{Is_Blk= /a/DOMINO}');
    Expect(1, 127135, '\p{Is_Blk=domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=domino}', "");
    Expect(0, 127135, '\P{Is_Blk=domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=domino}', "");
    Expect(0, 127136, '\p{Is_Blk=domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=domino}', "");
    Expect(1, 127136, '\P{Is_Blk=domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=domino}', "");
    Expect(1, 127135, '\p{Is_Blk:   _-Domino}', "");
    Expect(0, 127135, '\p{^Is_Blk:   _-Domino}', "");
    Expect(0, 127135, '\P{Is_Blk:   _-Domino}', "");
    Expect(1, 127135, '\P{^Is_Blk:   _-Domino}', "");
    Expect(0, 127136, '\p{Is_Blk:   _-Domino}', "");
    Expect(1, 127136, '\p{^Is_Blk:   _-Domino}', "");
    Expect(1, 127136, '\P{Is_Blk:   _-Domino}', "");
    Expect(0, 127136, '\P{^Is_Blk:   _-Domino}', "");
    Error('\p{Block=/a/ Duployan}');
    Error('\P{Block=/a/ Duployan}');
    Expect(1, 113823, '\p{Block=duployan}', "");
    Expect(0, 113823, '\p{^Block=duployan}', "");
    Expect(0, 113823, '\P{Block=duployan}', "");
    Expect(1, 113823, '\P{^Block=duployan}', "");
    Expect(0, 113824, '\p{Block=duployan}', "");
    Expect(1, 113824, '\p{^Block=duployan}', "");
    Expect(1, 113824, '\P{Block=duployan}', "");
    Expect(0, 113824, '\P{^Block=duployan}', "");
    Expect(1, 113823, '\p{Block= 	DUPLOYAN}', "");
    Expect(0, 113823, '\p{^Block= 	DUPLOYAN}', "");
    Expect(0, 113823, '\P{Block= 	DUPLOYAN}', "");
    Expect(1, 113823, '\P{^Block= 	DUPLOYAN}', "");
    Expect(0, 113824, '\p{Block= 	DUPLOYAN}', "");
    Expect(1, 113824, '\p{^Block= 	DUPLOYAN}', "");
    Expect(1, 113824, '\P{Block= 	DUPLOYAN}', "");
    Expect(0, 113824, '\P{^Block= 	DUPLOYAN}', "");
    Error('\p{Blk:	:=duployan}');
    Error('\P{Blk:	:=duployan}');
    Expect(1, 113823, '\p{Blk=duployan}', "");
    Expect(0, 113823, '\p{^Blk=duployan}', "");
    Expect(0, 113823, '\P{Blk=duployan}', "");
    Expect(1, 113823, '\P{^Blk=duployan}', "");
    Expect(0, 113824, '\p{Blk=duployan}', "");
    Expect(1, 113824, '\p{^Blk=duployan}', "");
    Expect(1, 113824, '\P{Blk=duployan}', "");
    Expect(0, 113824, '\P{^Blk=duployan}', "");
    Expect(1, 113823, '\p{Blk=_ Duployan}', "");
    Expect(0, 113823, '\p{^Blk=_ Duployan}', "");
    Expect(0, 113823, '\P{Blk=_ Duployan}', "");
    Expect(1, 113823, '\P{^Blk=_ Duployan}', "");
    Expect(0, 113824, '\p{Blk=_ Duployan}', "");
    Expect(1, 113824, '\p{^Blk=_ Duployan}', "");
    Expect(1, 113824, '\P{Blk=_ Duployan}', "");
    Expect(0, 113824, '\P{^Blk=_ Duployan}', "");
    Error('\p{Is_Block=	/a/duployan}');
    Error('\P{Is_Block=	/a/duployan}');
    Expect(1, 113823, '\p{Is_Block=duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=duployan}', "");
    Expect(0, 113823, '\P{Is_Block=duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=duployan}', "");
    Expect(0, 113824, '\p{Is_Block=duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=duployan}', "");
    Expect(1, 113824, '\P{Is_Block=duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=duployan}', "");
    Expect(1, 113823, '\p{Is_Block=-DUPLOYAN}', "");
    Expect(0, 113823, '\p{^Is_Block=-DUPLOYAN}', "");
    Expect(0, 113823, '\P{Is_Block=-DUPLOYAN}', "");
    Expect(1, 113823, '\P{^Is_Block=-DUPLOYAN}', "");
    Expect(0, 113824, '\p{Is_Block=-DUPLOYAN}', "");
    Expect(1, 113824, '\p{^Is_Block=-DUPLOYAN}', "");
    Expect(1, 113824, '\P{Is_Block=-DUPLOYAN}', "");
    Expect(0, 113824, '\P{^Is_Block=-DUPLOYAN}', "");
    Error('\p{Is_Blk:	:= Duployan}');
    Error('\P{Is_Blk:	:= Duployan}');
    Expect(1, 113823, '\p{Is_Blk:duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk:duployan}', "");
    Expect(0, 113823, '\P{Is_Blk:duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk:duployan}', "");
    Expect(0, 113824, '\p{Is_Blk:duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk:duployan}', "");
    Expect(1, 113824, '\P{Is_Blk:duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk:duployan}', "");
    Expect(1, 113823, '\p{Is_Blk=	 duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk=	 duployan}', "");
    Expect(0, 113823, '\P{Is_Blk=	 duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk=	 duployan}', "");
    Expect(0, 113824, '\p{Is_Blk=	 duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk=	 duployan}', "");
    Expect(1, 113824, '\P{Is_Blk=	 duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk=	 duployan}', "");
    Error('\p{Block= :=Early_dynastic_CUNEIFORM}');
    Error('\P{Block= :=Early_dynastic_CUNEIFORM}');
    Expect(1, 75087, '\p{Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\p{^Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\P{Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75087, '\P{^Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\p{Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\p{^Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\P{Block= Early_Dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\P{^Block= Early_Dynastic_CUNEIFORM}', "");
    Error('\p{Blk=-:=early_Dynastic_cuneiform}');
    Error('\P{Blk=-:=early_Dynastic_cuneiform}');
    Expect(1, 75087, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\p{^Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(0, 75087, '\P{Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(1, 75087, '\P{^Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\p{Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\p{^Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(1, 75088, '\P{Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Expect(0, 75088, '\P{^Blk=- EARLY_dynastic_CUNEIFORM}', "");
    Error('\p{Is_Block=:=Early_DYNASTIC_cuneiform}');
    Error('\P{Is_Block=:=Early_DYNASTIC_cuneiform}');
    Expect(1, 75087, '\p{Is_Block:	earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block:	earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Block:	earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block:	earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Block:	earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block:	earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Block:	earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block:	earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=--Early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=--Early_Dynastic_Cuneiform}', "");
    Error('\p{Is_Blk=/a/_Early_Dynastic_Cuneiform}');
    Error('\P{Is_Blk=/a/_Early_Dynastic_Cuneiform}');
    Expect(1, 75087, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk: -EARLY_dynastic_cuneiform}', "");
    Error('\p{Block= :=egyptian_HIEROGLYPHS}');
    Error('\P{Block= :=egyptian_HIEROGLYPHS}');
    Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Block=_ Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=_ Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Block=_ Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=_ Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Block=_ Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=_ Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Block=_ Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=_ Egyptian_Hieroglyphs}', "");
    Error('\p{Blk=_-Egyptian_Hieroglyphs/a/}');
    Error('\P{Blk=_-Egyptian_Hieroglyphs/a/}');
    Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Blk=  egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=  egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=  egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=  egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=  egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=  egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=  egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=  egyptian_Hieroglyphs}', "");
    Error('\p{Is_Block=/a/-_Egyptian_HIEROGLYPHS}');
    Error('\P{Is_Block=/a/-_Egyptian_HIEROGLYPHS}');
    Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=_	EGYPTIAN_Hieroglyphs}', "");
    Error('\p{Is_Blk=:= egyptian_hieroglyphs}');
    Error('\P{Is_Blk=:= egyptian_hieroglyphs}');
    Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk= -Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk= -Egyptian_hieroglyphs}', "");
    Error('\p{Block=/a/ 	Elbasan}');
    Error('\P{Block=/a/ 	Elbasan}');
    Expect(1, 66863, '\p{Block=elbasan}', "");
    Expect(0, 66863, '\p{^Block=elbasan}', "");
    Expect(0, 66863, '\P{Block=elbasan}', "");
    Expect(1, 66863, '\P{^Block=elbasan}', "");
    Expect(0, 66864, '\p{Block=elbasan}', "");
    Expect(1, 66864, '\p{^Block=elbasan}', "");
    Expect(1, 66864, '\P{Block=elbasan}', "");
    Expect(0, 66864, '\P{^Block=elbasan}', "");
    Expect(1, 66863, '\p{Block=-_elbasan}', "");
    Expect(0, 66863, '\p{^Block=-_elbasan}', "");
    Expect(0, 66863, '\P{Block=-_elbasan}', "");
    Expect(1, 66863, '\P{^Block=-_elbasan}', "");
    Expect(0, 66864, '\p{Block=-_elbasan}', "");
    Expect(1, 66864, '\p{^Block=-_elbasan}', "");
    Expect(1, 66864, '\P{Block=-_elbasan}', "");
    Expect(0, 66864, '\P{^Block=-_elbasan}', "");
    Error('\p{Blk=:=	elbasan}');
    Error('\P{Blk=:=	elbasan}');
    Expect(1, 66863, '\p{Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Blk=elbasan}', "");
    Expect(0, 66863, '\P{Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Blk=elbasan}', "");
    Expect(0, 66864, '\p{Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Blk=elbasan}', "");
    Expect(1, 66864, '\P{Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Blk=elbasan}', "");
    Expect(1, 66863, '\p{Blk=	-Elbasan}', "");
    Expect(0, 66863, '\p{^Blk=	-Elbasan}', "");
    Expect(0, 66863, '\P{Blk=	-Elbasan}', "");
    Expect(1, 66863, '\P{^Blk=	-Elbasan}', "");
    Expect(0, 66864, '\p{Blk=	-Elbasan}', "");
    Expect(1, 66864, '\p{^Blk=	-Elbasan}', "");
    Expect(1, 66864, '\P{Blk=	-Elbasan}', "");
    Expect(0, 66864, '\P{^Blk=	-Elbasan}', "");
    Error('\p{Is_Block=:=	 ELBASAN}');
    Error('\P{Is_Block=:=	 ELBASAN}');
    Expect(1, 66863, '\p{Is_Block=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
    Expect(1, 66863, '\p{Is_Block=	_Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=	_Elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=	_Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=	_Elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=	_Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=	_Elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=	_Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=	_Elbasan}', "");
    Error('\p{Is_Blk=:= elbasan}');
    Error('\P{Is_Blk=:= elbasan}');
    Expect(1, 66863, '\p{Is_Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=elbasan}', "");
    Expect(1, 66863, '\p{Is_Blk=		Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=		Elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=		Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=		Elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=		Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=		Elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=		Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=		Elbasan}', "");
    Error('\p{Block=/a/Emoticons}');
    Error('\P{Block=/a/Emoticons}');
    Expect(1, 128591, '\p{Block=emoticons}', "");
    Expect(0, 128591, '\p{^Block=emoticons}', "");
    Expect(0, 128591, '\P{Block=emoticons}', "");
    Expect(1, 128591, '\P{^Block=emoticons}', "");
    Expect(0, 128592, '\p{Block=emoticons}', "");
    Expect(1, 128592, '\p{^Block=emoticons}', "");
    Expect(1, 128592, '\P{Block=emoticons}', "");
    Expect(0, 128592, '\P{^Block=emoticons}', "");
    Expect(1, 128591, '\p{Block= -Emoticons}', "");
    Expect(0, 128591, '\p{^Block= -Emoticons}', "");
    Expect(0, 128591, '\P{Block= -Emoticons}', "");
    Expect(1, 128591, '\P{^Block= -Emoticons}', "");
    Expect(0, 128592, '\p{Block= -Emoticons}', "");
    Expect(1, 128592, '\p{^Block= -Emoticons}', "");
    Expect(1, 128592, '\P{Block= -Emoticons}', "");
    Expect(0, 128592, '\P{^Block= -Emoticons}', "");
    Error('\p{Blk=_	EMOTICONS:=}');
    Error('\P{Blk=_	EMOTICONS:=}');
    Expect(1, 128591, '\p{Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Blk=emoticons}', "");
    Expect(0, 128591, '\P{Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Blk=emoticons}', "");
    Expect(0, 128592, '\p{Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Blk=emoticons}', "");
    Expect(1, 128592, '\P{Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Blk=emoticons}', "");
    Expect(1, 128591, '\p{Blk=_-Emoticons}', "");
    Expect(0, 128591, '\p{^Blk=_-Emoticons}', "");
    Expect(0, 128591, '\P{Blk=_-Emoticons}', "");
    Expect(1, 128591, '\P{^Blk=_-Emoticons}', "");
    Expect(0, 128592, '\p{Blk=_-Emoticons}', "");
    Expect(1, 128592, '\p{^Blk=_-Emoticons}', "");
    Expect(1, 128592, '\P{Blk=_-Emoticons}', "");
    Expect(0, 128592, '\P{^Blk=_-Emoticons}', "");
    Error('\p{Is_Block=-	EMOTICONS/a/}');
    Error('\P{Is_Block=-	EMOTICONS/a/}');
    Expect(1, 128591, '\p{Is_Block=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
    Expect(1, 128591, '\p{Is_Block=	Emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=	Emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=	Emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=	Emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=	Emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=	Emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=	Emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=	Emoticons}', "");
    Error('\p{Is_Blk=:=Emoticons}');
    Error('\P{Is_Blk=:=Emoticons}');
    Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
    Expect(1, 128591, '\p{Is_Blk=-emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=-emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=-emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=-emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=-emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=-emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=-emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=-emoticons}', "");
    Error('\p{Block= :=ENCLOSED_Alphanumerics}');
    Error('\P{Block= :=ENCLOSED_Alphanumerics}');
    Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Block= Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\p{^Block= Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\P{Block= Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9471, '\P{^Block= Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\p{Block= Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\p{^Block= Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\P{Block= Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\P{^Block= Enclosed_ALPHANUMERICS}', "");
    Error('\p{Blk: /a/Enclosed_Alphanum}');
    Error('\P{Blk: /a/Enclosed_Alphanum}');
    Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Blk: _Enclosed_alphanum}', "");
    Expect(0, 9471, '\p{^Blk: _Enclosed_alphanum}', "");
    Expect(0, 9471, '\P{Blk: _Enclosed_alphanum}', "");
    Expect(1, 9471, '\P{^Blk: _Enclosed_alphanum}', "");
    Expect(0, 9472, '\p{Blk: _Enclosed_alphanum}', "");
    Expect(1, 9472, '\p{^Blk: _Enclosed_alphanum}', "");
    Expect(1, 9472, '\P{Blk: _Enclosed_alphanum}', "");
    Expect(0, 9472, '\P{^Blk: _Enclosed_alphanum}', "");
    Error('\p{Is_Block=/a/ Enclosed_Alphanumerics}');
    Error('\P{Is_Block=/a/ Enclosed_Alphanumerics}');
    Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Is_Block=	enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=	enclosed_Alphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=	enclosed_Alphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=	enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=	enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=	enclosed_Alphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=	enclosed_Alphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=	enclosed_Alphanumerics}', "");
    Error('\p{Is_Blk: 	ENCLOSED_Alphanum/a/}');
    Error('\P{Is_Blk: 	ENCLOSED_Alphanum/a/}');
    Expect(1, 9471, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\p{^Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\P{Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(1, 9471, '\P{^Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\p{Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\p{^Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\P{Is_Blk=Enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\P{^Is_Blk=Enclosed_ALPHANUM}', "");
    Error('\p{Block=_/a/enclosed_alphanumeric_SUPPLEMENT}');
    Error('\P{Block=_/a/enclosed_alphanumeric_SUPPLEMENT}');
    Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\p{^Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\P{Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127487, '\P{^Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\p{Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\p{^Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\P{Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\P{^Block=  Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Error('\p{Blk=_-ENCLOSED_Alphanum_Sup/a/}');
    Error('\P{Blk=_-ENCLOSED_Alphanum_Sup/a/}');
    Expect(1, 127487, '\p{Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Blk=- Enclosed_Alphanum_sup}', "");
    Expect(0, 127487, '\p{^Blk=- Enclosed_Alphanum_sup}', "");
    Expect(0, 127487, '\P{Blk=- Enclosed_Alphanum_sup}', "");
    Expect(1, 127487, '\P{^Blk=- Enclosed_Alphanum_sup}', "");
    Expect(0, 127488, '\p{Blk=- Enclosed_Alphanum_sup}', "");
    Expect(1, 127488, '\p{^Blk=- Enclosed_Alphanum_sup}', "");
    Expect(1, 127488, '\P{Blk=- Enclosed_Alphanum_sup}', "");
    Expect(0, 127488, '\P{^Blk=- Enclosed_Alphanum_sup}', "");
    Error('\p{Is_Block=:=Enclosed_alphanumeric_Supplement}');
    Error('\P{Is_Block=:=Enclosed_alphanumeric_Supplement}');
    Expect(1, 127487, '\p{Is_Block:enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Is_Block:enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Is_Block:enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Is_Block:enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Is_Block:enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Is_Block:enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Is_Block:enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Is_Block:enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\p{^Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\P{Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127487, '\P{^Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\p{Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\p{^Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\P{Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\P{^Is_Block:  	Enclosed_Alphanumeric_SUPPLEMENT}', "");
    Error('\p{Is_Blk=:= _ENCLOSED_Alphanum_Sup}');
    Error('\P{Is_Blk=:= _ENCLOSED_Alphanum_Sup}');
    Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(0, 127487, '\p{^Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(0, 127487, '\P{Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(1, 127487, '\P{^Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(0, 127488, '\p{Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(1, 127488, '\p{^Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(1, 127488, '\P{Is_Blk= -enclosed_Alphanum_sup}', "");
    Expect(0, 127488, '\P{^Is_Blk= -enclosed_Alphanum_sup}', "");
    Error('\p{Block=_-Enclosed_CJK_LETTERS_AND_Months/a/}');
    Error('\P{Block=_-Enclosed_CJK_LETTERS_AND_Months/a/}');
    Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(0, 13055, '\p{^Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(0, 13055, '\P{Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(1, 13055, '\P{^Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(0, 13056, '\p{Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(1, 13056, '\p{^Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(1, 13056, '\P{Block= -enclosed_cjk_Letters_And_Months}', "");
    Expect(0, 13056, '\P{^Block= -enclosed_cjk_Letters_And_Months}', "");
    Error('\p{Blk=/a/ENCLOSED_CJK}');
    Error('\P{Blk=/a/ENCLOSED_CJK}');
    Expect(1, 13055, '\p{Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Blk=-	Enclosed_cjk}', "");
    Expect(0, 13055, '\p{^Blk=-	Enclosed_cjk}', "");
    Expect(0, 13055, '\P{Blk=-	Enclosed_cjk}', "");
    Expect(1, 13055, '\P{^Blk=-	Enclosed_cjk}', "");
    Expect(0, 13056, '\p{Blk=-	Enclosed_cjk}', "");
    Expect(1, 13056, '\p{^Blk=-	Enclosed_cjk}', "");
    Expect(1, 13056, '\P{Blk=-	Enclosed_cjk}', "");
    Expect(0, 13056, '\P{^Blk=-	Enclosed_cjk}', "");
    Error('\p{Is_Block= _Enclosed_CJK_letters_AND_MONTHS:=}');
    Error('\P{Is_Block= _Enclosed_CJK_letters_AND_MONTHS:=}');
    Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(0, 13055, '\p{^Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(0, 13055, '\P{Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(1, 13055, '\P{^Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(0, 13056, '\p{Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(1, 13056, '\p{^Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(1, 13056, '\P{Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Expect(0, 13056, '\P{^Is_Block=	-enclosed_CJK_Letters_And_MONTHS}', "");
    Error('\p{Is_Blk=_ ENCLOSED_cjk/a/}');
    Error('\P{Is_Blk=_ ENCLOSED_cjk/a/}');
    Expect(1, 13055, '\p{Is_Blk: enclosedcjk}', "");
    Expect(0, 13055, '\p{^Is_Blk: enclosedcjk}', "");
    Expect(0, 13055, '\P{Is_Blk: enclosedcjk}', "");
    Expect(1, 13055, '\P{^Is_Blk: enclosedcjk}', "");
    Expect(0, 13056, '\p{Is_Blk: enclosedcjk}', "");
    Expect(1, 13056, '\p{^Is_Blk: enclosedcjk}', "");
    Expect(1, 13056, '\P{Is_Blk: enclosedcjk}', "");
    Expect(0, 13056, '\P{^Is_Blk: enclosedcjk}', "");
    Expect(1, 13055, '\p{Is_Blk=_ENCLOSED_cjk}', "");
    Expect(0, 13055, '\p{^Is_Blk=_ENCLOSED_cjk}', "");
    Expect(0, 13055, '\P{Is_Blk=_ENCLOSED_cjk}', "");
    Expect(1, 13055, '\P{^Is_Blk=_ENCLOSED_cjk}', "");
    Expect(0, 13056, '\p{Is_Blk=_ENCLOSED_cjk}', "");
    Expect(1, 13056, '\p{^Is_Blk=_ENCLOSED_cjk}', "");
    Expect(1, 13056, '\P{Is_Blk=_ENCLOSED_cjk}', "");
    Expect(0, 13056, '\P{^Is_Blk=_ENCLOSED_cjk}', "");
    Error('\p{Block= -enclosed_IDEOGRAPHIC_supplement/a/}');
    Error('\P{Block= -enclosed_IDEOGRAPHIC_supplement/a/}');
    Expect(1, 127743, '\p{Block: enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Block: enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Block: enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Block: enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Block: enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Block: enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Block: enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Block: enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127743, '\p{^Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127743, '\P{Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127743, '\P{^Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127744, '\p{Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127744, '\p{^Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127744, '\P{Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127744, '\P{^Block=_	Enclosed_Ideographic_SUPPLEMENT}', "");
    Error('\p{Blk=_enclosed_Ideographic_sup:=}');
    Error('\P{Blk=_enclosed_Ideographic_sup:=}');
    Expect(1, 127743, '\p{Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\P{Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\p{Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\P{Blk: 	Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Blk: 	Enclosed_Ideographic_Sup}', "");
    Error('\p{Is_Block=	:=Enclosed_Ideographic_supplement}');
    Error('\P{Is_Block=	:=Enclosed_Ideographic_supplement}');
    Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(0, 127743, '\p{^Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(0, 127743, '\P{Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(1, 127743, '\P{^Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(0, 127744, '\p{Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(1, 127744, '\p{^Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(1, 127744, '\P{Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Expect(0, 127744, '\P{^Is_Block= 	Enclosed_Ideographic_Supplement}', "");
    Error('\p{Is_Blk=_ ENCLOSED_ideographic_Sup/a/}');
    Error('\P{Is_Blk=_ ENCLOSED_ideographic_Sup/a/}');
    Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\P{Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\p{Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\P{Is_Blk= Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Is_Blk= Enclosed_Ideographic_Sup}', "");
    Error('\p{Block=-	ETHIOPIC:=}');
    Error('\P{Block=-	ETHIOPIC:=}');
    Expect(1, 4991, '\p{Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Block=ethiopic}', "");
    Expect(0, 4991, '\P{Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Block=ethiopic}', "");
    Expect(0, 4992, '\p{Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Block=ethiopic}', "");
    Expect(1, 4992, '\P{Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Block=ethiopic}', "");
    Expect(1, 4991, '\p{Block=-	ETHIOPIC}', "");
    Expect(0, 4991, '\p{^Block=-	ETHIOPIC}', "");
    Expect(0, 4991, '\P{Block=-	ETHIOPIC}', "");
    Expect(1, 4991, '\P{^Block=-	ETHIOPIC}', "");
    Expect(0, 4992, '\p{Block=-	ETHIOPIC}', "");
    Expect(1, 4992, '\p{^Block=-	ETHIOPIC}', "");
    Expect(1, 4992, '\P{Block=-	ETHIOPIC}', "");
    Expect(0, 4992, '\P{^Block=-	ETHIOPIC}', "");
    Error('\p{Blk=_Ethiopic:=}');
    Error('\P{Blk=_Ethiopic:=}');
    Expect(1, 4991, '\p{Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Blk=-	ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=-	ethiopic}', "");
    Expect(0, 4991, '\P{Blk=-	ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=-	ethiopic}', "");
    Expect(0, 4992, '\p{Blk=-	ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=-	ethiopic}', "");
    Expect(1, 4992, '\P{Blk=-	ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=-	ethiopic}', "");
    Error('\p{Is_Block=/a/ 	ETHIOPIC}');
    Error('\P{Is_Block=/a/ 	ETHIOPIC}');
    Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Block=__Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=__Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=__Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=__Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=__Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=__Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=__Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=__Ethiopic}', "");
    Error('\p{Is_Blk=	/a/Ethiopic}');
    Error('\P{Is_Blk=	/a/Ethiopic}');
    Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Blk=- Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=- Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=- Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=- Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=- Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=- Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=- Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=- Ethiopic}', "");
    Error('\p{Block=:=	 Ethiopic_extended}');
    Error('\P{Block=:=	 Ethiopic_extended}');
    Expect(1, 11743, '\p{Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Block=_	Ethiopic_extended}', "");
    Expect(0, 11743, '\p{^Block=_	Ethiopic_extended}', "");
    Expect(0, 11743, '\P{Block=_	Ethiopic_extended}', "");
    Expect(1, 11743, '\P{^Block=_	Ethiopic_extended}', "");
    Expect(0, 11744, '\p{Block=_	Ethiopic_extended}', "");
    Expect(1, 11744, '\p{^Block=_	Ethiopic_extended}', "");
    Expect(1, 11744, '\P{Block=_	Ethiopic_extended}', "");
    Expect(0, 11744, '\P{^Block=_	Ethiopic_extended}', "");
    Error('\p{Blk=:=	 Ethiopic_Ext}');
    Error('\P{Blk=:=	 Ethiopic_Ext}');
    Expect(1, 11743, '\p{Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Blk=--Ethiopic_Ext}', "");
    Expect(0, 11743, '\p{^Blk=--Ethiopic_Ext}', "");
    Expect(0, 11743, '\P{Blk=--Ethiopic_Ext}', "");
    Expect(1, 11743, '\P{^Blk=--Ethiopic_Ext}', "");
    Expect(0, 11744, '\p{Blk=--Ethiopic_Ext}', "");
    Expect(1, 11744, '\p{^Blk=--Ethiopic_Ext}', "");
    Expect(1, 11744, '\P{Blk=--Ethiopic_Ext}', "");
    Expect(0, 11744, '\P{^Blk=--Ethiopic_Ext}', "");
    Error('\p{Is_Block=:=Ethiopic_Extended}');
    Error('\P{Is_Block=:=Ethiopic_Extended}');
    Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(0, 11743, '\p{^Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(0, 11743, '\P{Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(1, 11743, '\P{^Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(0, 11744, '\p{Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(1, 11744, '\p{^Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(1, 11744, '\P{Is_Block=_-Ethiopic_EXTENDED}', "");
    Expect(0, 11744, '\P{^Is_Block=_-Ethiopic_EXTENDED}', "");
    Error('\p{Is_Blk= :=ethiopic_EXT}');
    Error('\P{Is_Blk= :=ethiopic_EXT}');
    Expect(1, 11743, '\p{Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Is_Blk=_-ethiopic_EXT}', "");
    Expect(0, 11743, '\p{^Is_Blk=_-ethiopic_EXT}', "");
    Expect(0, 11743, '\P{Is_Blk=_-ethiopic_EXT}', "");
    Expect(1, 11743, '\P{^Is_Blk=_-ethiopic_EXT}', "");
    Expect(0, 11744, '\p{Is_Blk=_-ethiopic_EXT}', "");
    Expect(1, 11744, '\p{^Is_Blk=_-ethiopic_EXT}', "");
    Expect(1, 11744, '\P{Is_Blk=_-ethiopic_EXT}', "");
    Expect(0, 11744, '\P{^Is_Blk=_-ethiopic_EXT}', "");
    Error('\p{Block:   /a/ _Ethiopic_extended_a}');
    Error('\P{Block:   /a/ _Ethiopic_extended_a}');
    Expect(1, 43823, '\p{Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Block= ethiopic_EXTENDED_a}', "");
    Expect(0, 43823, '\p{^Block= ethiopic_EXTENDED_a}', "");
    Expect(0, 43823, '\P{Block= ethiopic_EXTENDED_a}', "");
    Expect(1, 43823, '\P{^Block= ethiopic_EXTENDED_a}', "");
    Expect(0, 43824, '\p{Block= ethiopic_EXTENDED_a}', "");
    Expect(1, 43824, '\p{^Block= ethiopic_EXTENDED_a}', "");
    Expect(1, 43824, '\P{Block= ethiopic_EXTENDED_a}', "");
    Expect(0, 43824, '\P{^Block= ethiopic_EXTENDED_a}', "");
    Error('\p{Blk:	:=- ethiopic_EXT_a}');
    Error('\P{Blk:	:=- ethiopic_EXT_a}');
    Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Blk=_ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\p{^Blk=_ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\P{Blk=_ETHIOPIC_EXT_A}', "");
    Expect(1, 43823, '\P{^Blk=_ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\p{Blk=_ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\p{^Blk=_ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\P{Blk=_ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\P{^Blk=_ETHIOPIC_EXT_A}', "");
    Error('\p{Is_Block=_/a/Ethiopic_Extended_a}');
    Error('\P{Is_Block=_/a/Ethiopic_Extended_a}');
    Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(0, 43823, '\p{^Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(0, 43823, '\P{Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(1, 43823, '\P{^Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(0, 43824, '\p{Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(1, 43824, '\p{^Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(1, 43824, '\P{Is_Block=	Ethiopic_EXTENDED_A}', "");
    Expect(0, 43824, '\P{^Is_Block=	Ethiopic_EXTENDED_A}', "");
    Error('\p{Is_Blk=/a/ ETHIOPIC_Ext_a}');
    Error('\P{Is_Blk=/a/ ETHIOPIC_Ext_a}');
    Expect(1, 43823, '\p{Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\p{^Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(0, 43823, '\P{Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(1, 43823, '\P{^Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\p{Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\p{^Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(1, 43824, '\P{Is_Blk=--ETHIOPIC_EXT_A}', "");
    Expect(0, 43824, '\P{^Is_Blk=--ETHIOPIC_EXT_A}', "");
    Error('\p{Block: /a/	-ethiopic_Supplement}');
    Error('\P{Block: /a/	-ethiopic_Supplement}');
    Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Block=_-Ethiopic_Supplement}', "");
    Expect(0, 5023, '\p{^Block=_-Ethiopic_Supplement}', "");
    Expect(0, 5023, '\P{Block=_-Ethiopic_Supplement}', "");
    Expect(1, 5023, '\P{^Block=_-Ethiopic_Supplement}', "");
    Expect(0, 5024, '\p{Block=_-Ethiopic_Supplement}', "");
    Expect(1, 5024, '\p{^Block=_-Ethiopic_Supplement}', "");
    Expect(1, 5024, '\P{Block=_-Ethiopic_Supplement}', "");
    Expect(0, 5024, '\P{^Block=_-Ethiopic_Supplement}', "");
    Error('\p{Blk= _ethiopic_sup/a/}');
    Error('\P{Blk= _ethiopic_sup/a/}');
    Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Blk=--Ethiopic_Sup}', "");
    Expect(0, 5023, '\p{^Blk=--Ethiopic_Sup}', "");
    Expect(0, 5023, '\P{Blk=--Ethiopic_Sup}', "");
    Expect(1, 5023, '\P{^Blk=--Ethiopic_Sup}', "");
    Expect(0, 5024, '\p{Blk=--Ethiopic_Sup}', "");
    Expect(1, 5024, '\p{^Blk=--Ethiopic_Sup}', "");
    Expect(1, 5024, '\P{Blk=--Ethiopic_Sup}', "");
    Expect(0, 5024, '\P{^Blk=--Ethiopic_Sup}', "");
    Error('\p{Is_Block=	-Ethiopic_supplement:=}');
    Error('\P{Is_Block=	-Ethiopic_supplement:=}');
    Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Is_Block= _Ethiopic_Supplement}', "");
    Expect(0, 5023, '\p{^Is_Block= _Ethiopic_Supplement}', "");
    Expect(0, 5023, '\P{Is_Block= _Ethiopic_Supplement}', "");
    Expect(1, 5023, '\P{^Is_Block= _Ethiopic_Supplement}', "");
    Expect(0, 5024, '\p{Is_Block= _Ethiopic_Supplement}', "");
    Expect(1, 5024, '\p{^Is_Block= _Ethiopic_Supplement}', "");
    Expect(1, 5024, '\P{Is_Block= _Ethiopic_Supplement}', "");
    Expect(0, 5024, '\P{^Is_Block= _Ethiopic_Supplement}', "");
    Error('\p{Is_Blk=:=Ethiopic_Sup}');
    Error('\P{Is_Blk=:=Ethiopic_Sup}');
    Expect(1, 5023, '\p{Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Is_Blk= 	Ethiopic_sup}', "");
    Expect(0, 5023, '\p{^Is_Blk= 	Ethiopic_sup}', "");
    Expect(0, 5023, '\P{Is_Blk= 	Ethiopic_sup}', "");
    Expect(1, 5023, '\P{^Is_Blk= 	Ethiopic_sup}', "");
    Expect(0, 5024, '\p{Is_Blk= 	Ethiopic_sup}', "");
    Expect(1, 5024, '\p{^Is_Blk= 	Ethiopic_sup}', "");
    Expect(1, 5024, '\P{Is_Blk= 	Ethiopic_sup}', "");
    Expect(0, 5024, '\P{^Is_Blk= 	Ethiopic_sup}', "");
    Error('\p{Block=	geometric_Shapes/a/}');
    Error('\P{Block=	geometric_Shapes/a/}');
    Expect(1, 9727, '\p{Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Block= Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Block= Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Block= Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Block= Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Block= Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Block= Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Block= Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Block= Geometric_Shapes}', "");
    Error('\p{Blk:		Geometric_Shapes/a/}');
    Error('\P{Blk:		Geometric_Shapes/a/}');
    Expect(1, 9727, '\p{Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Blk:   -_GEOMETRIC_shapes}', "");
    Expect(0, 9727, '\p{^Blk:   -_GEOMETRIC_shapes}', "");
    Expect(0, 9727, '\P{Blk:   -_GEOMETRIC_shapes}', "");
    Expect(1, 9727, '\P{^Blk:   -_GEOMETRIC_shapes}', "");
    Expect(0, 9728, '\p{Blk:   -_GEOMETRIC_shapes}', "");
    Expect(1, 9728, '\p{^Blk:   -_GEOMETRIC_shapes}', "");
    Expect(1, 9728, '\P{Blk:   -_GEOMETRIC_shapes}', "");
    Expect(0, 9728, '\P{^Blk:   -_GEOMETRIC_shapes}', "");
    Error('\p{Is_Block: :=	_GEOMETRIC_Shapes}');
    Error('\P{Is_Block: :=	_GEOMETRIC_Shapes}');
    Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Block=	geometric_shapes}', "");
    Expect(0, 9727, '\p{^Is_Block=	geometric_shapes}', "");
    Expect(0, 9727, '\P{Is_Block=	geometric_shapes}', "");
    Expect(1, 9727, '\P{^Is_Block=	geometric_shapes}', "");
    Expect(0, 9728, '\p{Is_Block=	geometric_shapes}', "");
    Expect(1, 9728, '\p{^Is_Block=	geometric_shapes}', "");
    Expect(1, 9728, '\P{Is_Block=	geometric_shapes}', "");
    Expect(0, 9728, '\P{^Is_Block=	geometric_shapes}', "");
    Error('\p{Is_Blk=:=_GEOMETRIC_shapes}');
    Error('\P{Is_Blk=:=_GEOMETRIC_shapes}');
    Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Blk=geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometric_Shapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometric_Shapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometric_Shapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometric_Shapes}', "");
    Error('\p{Block=_/a/Geometric_Shapes_extended}');
    Error('\P{Block=_/a/Geometric_Shapes_extended}');
    Expect(1, 129023, '\p{Block: geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Block: geometricshapesextended}', "");
    Expect(0, 129023, '\P{Block: geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Block: geometricshapesextended}', "");
    Expect(0, 129024, '\p{Block: geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Block: geometricshapesextended}', "");
    Expect(1, 129024, '\P{Block: geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Block: geometricshapesextended}', "");
    Expect(1, 129023, '\p{Block=	-Geometric_SHAPES_Extended}', "");
    Expect(0, 129023, '\p{^Block=	-Geometric_SHAPES_Extended}', "");
    Expect(0, 129023, '\P{Block=	-Geometric_SHAPES_Extended}', "");
    Expect(1, 129023, '\P{^Block=	-Geometric_SHAPES_Extended}', "");
    Expect(0, 129024, '\p{Block=	-Geometric_SHAPES_Extended}', "");
    Expect(1, 129024, '\p{^Block=	-Geometric_SHAPES_Extended}', "");
    Expect(1, 129024, '\P{Block=	-Geometric_SHAPES_Extended}', "");
    Expect(0, 129024, '\P{^Block=	-Geometric_SHAPES_Extended}', "");
    Error('\p{Blk: --Geometric_shapes_Ext/a/}');
    Error('\P{Blk: --Geometric_shapes_Ext/a/}');
    Expect(1, 129023, '\p{Blk:   geometricshapesext}', "");
    Expect(0, 129023, '\p{^Blk:   geometricshapesext}', "");
    Expect(0, 129023, '\P{Blk:   geometricshapesext}', "");
    Expect(1, 129023, '\P{^Blk:   geometricshapesext}', "");
    Expect(0, 129024, '\p{Blk:   geometricshapesext}', "");
    Expect(1, 129024, '\p{^Blk:   geometricshapesext}', "");
    Expect(1, 129024, '\P{Blk:   geometricshapesext}', "");
    Expect(0, 129024, '\P{^Blk:   geometricshapesext}', "");
    Expect(1, 129023, '\p{Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(0, 129023, '\p{^Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(0, 129023, '\P{Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(1, 129023, '\P{^Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(0, 129024, '\p{Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(1, 129024, '\p{^Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(1, 129024, '\P{Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Expect(0, 129024, '\P{^Blk= 	GEOMETRIC_Shapes_EXT}', "");
    Error('\p{Is_Block= /a/geometric_Shapes_Extended}');
    Error('\P{Is_Block= /a/geometric_Shapes_Extended}');
    Expect(1, 129023, '\p{Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\p{^Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(0, 129023, '\P{Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(1, 129023, '\P{^Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\p{Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\p{^Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(1, 129024, '\P{Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Expect(0, 129024, '\P{^Is_Block=_GEOMETRIC_Shapes_EXTENDED}', "");
    Error('\p{Is_Blk=- Geometric_SHAPES_Ext/a/}');
    Error('\P{Is_Blk=- Geometric_SHAPES_Ext/a/}');
    Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Is_Blk= Geometric_Shapes_ext}', "");
    Expect(0, 129023, '\p{^Is_Blk= Geometric_Shapes_ext}', "");
    Expect(0, 129023, '\P{Is_Blk= Geometric_Shapes_ext}', "");
    Expect(1, 129023, '\P{^Is_Blk= Geometric_Shapes_ext}', "");
    Expect(0, 129024, '\p{Is_Blk= Geometric_Shapes_ext}', "");
    Expect(1, 129024, '\p{^Is_Blk= Geometric_Shapes_ext}', "");
    Expect(1, 129024, '\P{Is_Blk= Geometric_Shapes_ext}', "");
    Expect(0, 129024, '\P{^Is_Blk= Geometric_Shapes_ext}', "");
    Error('\p{Block:	/a/-_Georgian}');
    Error('\P{Block:	/a/-_Georgian}');
    Expect(1, 4351, '\p{Block=georgian}', "");
    Expect(0, 4351, '\p{^Block=georgian}', "");
    Expect(0, 4351, '\P{Block=georgian}', "");
    Expect(1, 4351, '\P{^Block=georgian}', "");
    Expect(0, 4352, '\p{Block=georgian}', "");
    Expect(1, 4352, '\p{^Block=georgian}', "");
    Expect(1, 4352, '\P{Block=georgian}', "");
    Expect(0, 4352, '\P{^Block=georgian}', "");
    Expect(1, 4351, '\p{Block=__GEORGIAN}', "");
    Expect(0, 4351, '\p{^Block=__GEORGIAN}', "");
    Expect(0, 4351, '\P{Block=__GEORGIAN}', "");
    Expect(1, 4351, '\P{^Block=__GEORGIAN}', "");
    Expect(0, 4352, '\p{Block=__GEORGIAN}', "");
    Expect(1, 4352, '\p{^Block=__GEORGIAN}', "");
    Expect(1, 4352, '\P{Block=__GEORGIAN}', "");
    Expect(0, 4352, '\P{^Block=__GEORGIAN}', "");
    Error('\p{Blk=:= -Georgian}');
    Error('\P{Blk=:= -Georgian}');
    Expect(1, 4351, '\p{Blk=georgian}', "");
    Expect(0, 4351, '\p{^Blk=georgian}', "");
    Expect(0, 4351, '\P{Blk=georgian}', "");
    Expect(1, 4351, '\P{^Blk=georgian}', "");
    Expect(0, 4352, '\p{Blk=georgian}', "");
    Expect(1, 4352, '\p{^Blk=georgian}', "");
    Expect(1, 4352, '\P{Blk=georgian}', "");
    Expect(0, 4352, '\P{^Blk=georgian}', "");
    Expect(1, 4351, '\p{Blk=-Georgian}', "");
    Expect(0, 4351, '\p{^Blk=-Georgian}', "");
    Expect(0, 4351, '\P{Blk=-Georgian}', "");
    Expect(1, 4351, '\P{^Blk=-Georgian}', "");
    Expect(0, 4352, '\p{Blk=-Georgian}', "");
    Expect(1, 4352, '\p{^Blk=-Georgian}', "");
    Expect(1, 4352, '\P{Blk=-Georgian}', "");
    Expect(0, 4352, '\P{^Blk=-Georgian}', "");
    Error('\p{Is_Block=/a/ georgian}');
    Error('\P{Is_Block=/a/ georgian}');
    Expect(1, 4351, '\p{Is_Block=georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=georgian}', "");
    Expect(0, 4351, '\P{Is_Block=georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=georgian}', "");
    Expect(0, 4352, '\p{Is_Block=georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=georgian}', "");
    Expect(1, 4352, '\P{Is_Block=georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=georgian}', "");
    Expect(1, 4351, '\p{Is_Block=_ Georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=_ Georgian}', "");
    Expect(0, 4351, '\P{Is_Block=_ Georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=_ Georgian}', "");
    Expect(0, 4352, '\p{Is_Block=_ Georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=_ Georgian}', "");
    Expect(1, 4352, '\P{Is_Block=_ Georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=_ Georgian}', "");
    Error('\p{Is_Blk=/a/--Georgian}');
    Error('\P{Is_Blk=/a/--Georgian}');
    Expect(1, 4351, '\p{Is_Blk=georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
    Expect(1, 4351, '\p{Is_Blk:   georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk:   georgian}', "");
    Expect(0, 4351, '\P{Is_Blk:   georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk:   georgian}', "");
    Expect(0, 4352, '\p{Is_Blk:   georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk:   georgian}', "");
    Expect(1, 4352, '\P{Is_Blk:   georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk:   georgian}', "");
    Error('\p{Block:   /a/ _Georgian_Supplement}');
    Error('\P{Block:   /a/ _Georgian_Supplement}');
    Expect(1, 11567, '\p{Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Block:	 georgian_SUPPLEMENT}', "");
    Expect(0, 11567, '\p{^Block:	 georgian_SUPPLEMENT}', "");
    Expect(0, 11567, '\P{Block:	 georgian_SUPPLEMENT}', "");
    Expect(1, 11567, '\P{^Block:	 georgian_SUPPLEMENT}', "");
    Expect(0, 11568, '\p{Block:	 georgian_SUPPLEMENT}', "");
    Expect(1, 11568, '\p{^Block:	 georgian_SUPPLEMENT}', "");
    Expect(1, 11568, '\P{Block:	 georgian_SUPPLEMENT}', "");
    Expect(0, 11568, '\P{^Block:	 georgian_SUPPLEMENT}', "");
    Error('\p{Blk=-/a/GEORGIAN_sup}');
    Error('\P{Blk=-/a/GEORGIAN_sup}');
    Expect(1, 11567, '\p{Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Blk=	_Georgian_Sup}', "");
    Expect(0, 11567, '\p{^Blk=	_Georgian_Sup}', "");
    Expect(0, 11567, '\P{Blk=	_Georgian_Sup}', "");
    Expect(1, 11567, '\P{^Blk=	_Georgian_Sup}', "");
    Expect(0, 11568, '\p{Blk=	_Georgian_Sup}', "");
    Expect(1, 11568, '\p{^Blk=	_Georgian_Sup}', "");
    Expect(1, 11568, '\P{Blk=	_Georgian_Sup}', "");
    Expect(0, 11568, '\P{^Blk=	_Georgian_Sup}', "");
    Error('\p{Is_Block= georgian_SUPPLEMENT/a/}');
    Error('\P{Is_Block= georgian_SUPPLEMENT/a/}');
    Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Is_Block=GEORGIAN_supplement}', "");
    Expect(0, 11567, '\p{^Is_Block=GEORGIAN_supplement}', "");
    Expect(0, 11567, '\P{Is_Block=GEORGIAN_supplement}', "");
    Expect(1, 11567, '\P{^Is_Block=GEORGIAN_supplement}', "");
    Expect(0, 11568, '\p{Is_Block=GEORGIAN_supplement}', "");
    Expect(1, 11568, '\p{^Is_Block=GEORGIAN_supplement}', "");
    Expect(1, 11568, '\P{Is_Block=GEORGIAN_supplement}', "");
    Expect(0, 11568, '\P{^Is_Block=GEORGIAN_supplement}', "");
    Error('\p{Is_Blk=	/a/GEORGIAN_Sup}');
    Error('\P{Is_Blk=	/a/GEORGIAN_Sup}');
    Expect(1, 11567, '\p{Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Is_Blk:   -_Georgian_sup}', "");
    Expect(0, 11567, '\p{^Is_Blk:   -_Georgian_sup}', "");
    Expect(0, 11567, '\P{Is_Blk:   -_Georgian_sup}', "");
    Expect(1, 11567, '\P{^Is_Blk:   -_Georgian_sup}', "");
    Expect(0, 11568, '\p{Is_Blk:   -_Georgian_sup}', "");
    Expect(1, 11568, '\p{^Is_Blk:   -_Georgian_sup}', "");
    Expect(1, 11568, '\P{Is_Blk:   -_Georgian_sup}', "");
    Expect(0, 11568, '\P{^Is_Blk:   -_Georgian_sup}', "");
    Error('\p{Block=:=_ GLAGOLITIC}');
    Error('\P{Block=:=_ GLAGOLITIC}');
    Expect(1, 11359, '\p{Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Block=glagolitic}', "");
    Expect(0, 11359, '\P{Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Block=glagolitic}', "");
    Expect(0, 11360, '\p{Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Block=glagolitic}', "");
    Expect(1, 11360, '\P{Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Block=glagolitic}', "");
    Expect(1, 11359, '\p{Block:  GLAGOLITIC}', "");
    Expect(0, 11359, '\p{^Block:  GLAGOLITIC}', "");
    Expect(0, 11359, '\P{Block:  GLAGOLITIC}', "");
    Expect(1, 11359, '\P{^Block:  GLAGOLITIC}', "");
    Expect(0, 11360, '\p{Block:  GLAGOLITIC}', "");
    Expect(1, 11360, '\p{^Block:  GLAGOLITIC}', "");
    Expect(1, 11360, '\P{Block:  GLAGOLITIC}', "");
    Expect(0, 11360, '\P{^Block:  GLAGOLITIC}', "");
    Error('\p{Blk=-Glagolitic/a/}');
    Error('\P{Blk=-Glagolitic/a/}');
    Expect(1, 11359, '\p{Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Blk=-glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=-glagolitic}', "");
    Expect(0, 11359, '\P{Blk=-glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=-glagolitic}', "");
    Expect(0, 11360, '\p{Blk=-glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=-glagolitic}', "");
    Expect(1, 11360, '\P{Blk=-glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=-glagolitic}', "");
    Error('\p{Is_Block=/a/	GLAGOLITIC}');
    Error('\P{Is_Block=/a/	GLAGOLITIC}');
    Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Block=_Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=_Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=_Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=_Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=_Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=_Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=_Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=_Glagolitic}', "");
    Error('\p{Is_Blk=/a/  glagolitic}');
    Error('\P{Is_Blk=/a/  glagolitic}');
    Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Blk=		Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=		Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=		Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=		Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=		Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=		Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=		Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=		Glagolitic}', "");
    Error('\p{Block=:=_	GLAGOLITIC_Supplement}');
    Error('\P{Block=:=_	GLAGOLITIC_Supplement}');
    Expect(1, 122927, '\p{Block:glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Block:glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Block:glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Block:glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Block:glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Block:glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Block:glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Block:glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Block= GLAGOLITIC_Supplement}', "");
    Expect(0, 122927, '\p{^Block= GLAGOLITIC_Supplement}', "");
    Expect(0, 122927, '\P{Block= GLAGOLITIC_Supplement}', "");
    Expect(1, 122927, '\P{^Block= GLAGOLITIC_Supplement}', "");
    Expect(0, 122928, '\p{Block= GLAGOLITIC_Supplement}', "");
    Expect(1, 122928, '\p{^Block= GLAGOLITIC_Supplement}', "");
    Expect(1, 122928, '\P{Block= GLAGOLITIC_Supplement}', "");
    Expect(0, 122928, '\P{^Block= GLAGOLITIC_Supplement}', "");
    Error('\p{Blk=/a/--GLAGOLITIC_sup}');
    Error('\P{Blk=/a/--GLAGOLITIC_sup}');
    Expect(1, 122927, '\p{Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Blk=	_glagolitic_Sup}', "");
    Expect(0, 122927, '\p{^Blk=	_glagolitic_Sup}', "");
    Expect(0, 122927, '\P{Blk=	_glagolitic_Sup}', "");
    Expect(1, 122927, '\P{^Blk=	_glagolitic_Sup}', "");
    Expect(0, 122928, '\p{Blk=	_glagolitic_Sup}', "");
    Expect(1, 122928, '\p{^Blk=	_glagolitic_Sup}', "");
    Expect(1, 122928, '\P{Blk=	_glagolitic_Sup}', "");
    Expect(0, 122928, '\P{^Blk=	_glagolitic_Sup}', "");
    Error('\p{Is_Block=	_glagolitic_supplement/a/}');
    Error('\P{Is_Block=	_glagolitic_supplement/a/}');
    Expect(1, 122927, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(0, 122927, '\p{^Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(0, 122927, '\P{Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(1, 122927, '\P{^Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(0, 122928, '\p{Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(1, 122928, '\p{^Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(1, 122928, '\P{Is_Block:			GLAGOLITIC_Supplement}', "");
    Expect(0, 122928, '\P{^Is_Block:			GLAGOLITIC_Supplement}', "");
    Error('\p{Is_Blk= GLAGOLITIC_sup/a/}');
    Error('\P{Is_Blk= GLAGOLITIC_sup/a/}');
    Expect(1, 122927, '\p{Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\p{^Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\P{Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(1, 122927, '\P{^Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\p{Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\p{^Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\P{Is_Blk= GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\P{^Is_Blk= GLAGOLITIC_Sup}', "");
    Error('\p{Block=-gothic/a/}');
    Error('\P{Block=-gothic/a/}');
    Expect(1, 66383, '\p{Block=gothic}', "");
    Expect(0, 66383, '\p{^Block=gothic}', "");
    Expect(0, 66383, '\P{Block=gothic}', "");
    Expect(1, 66383, '\P{^Block=gothic}', "");
    Expect(0, 66384, '\p{Block=gothic}', "");
    Expect(1, 66384, '\p{^Block=gothic}', "");
    Expect(1, 66384, '\P{Block=gothic}', "");
    Expect(0, 66384, '\P{^Block=gothic}', "");
    Expect(1, 66383, '\p{Block=  gothic}', "");
    Expect(0, 66383, '\p{^Block=  gothic}', "");
    Expect(0, 66383, '\P{Block=  gothic}', "");
    Expect(1, 66383, '\P{^Block=  gothic}', "");
    Expect(0, 66384, '\p{Block=  gothic}', "");
    Expect(1, 66384, '\p{^Block=  gothic}', "");
    Expect(1, 66384, '\P{Block=  gothic}', "");
    Expect(0, 66384, '\P{^Block=  gothic}', "");
    Error('\p{Blk=:=	-GOTHIC}');
    Error('\P{Blk=:=	-GOTHIC}');
    Expect(1, 66383, '\p{Blk=gothic}', "");
    Expect(0, 66383, '\p{^Blk=gothic}', "");
    Expect(0, 66383, '\P{Blk=gothic}', "");
    Expect(1, 66383, '\P{^Blk=gothic}', "");
    Expect(0, 66384, '\p{Blk=gothic}', "");
    Expect(1, 66384, '\p{^Blk=gothic}', "");
    Expect(1, 66384, '\P{Blk=gothic}', "");
    Expect(0, 66384, '\P{^Blk=gothic}', "");
    Expect(1, 66383, '\p{Blk=- gothic}', "");
    Expect(0, 66383, '\p{^Blk=- gothic}', "");
    Expect(0, 66383, '\P{Blk=- gothic}', "");
    Expect(1, 66383, '\P{^Blk=- gothic}', "");
    Expect(0, 66384, '\p{Blk=- gothic}', "");
    Expect(1, 66384, '\p{^Blk=- gothic}', "");
    Expect(1, 66384, '\P{Blk=- gothic}', "");
    Expect(0, 66384, '\P{^Blk=- gothic}', "");
    Error('\p{Is_Block=:= -Gothic}');
    Error('\P{Is_Block=:= -Gothic}');
    Expect(1, 66383, '\p{Is_Block=gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=gothic}', "");
    Expect(0, 66383, '\P{Is_Block=gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=gothic}', "");
    Expect(0, 66384, '\p{Is_Block=gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=gothic}', "");
    Expect(1, 66384, '\P{Is_Block=gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=gothic}', "");
    Expect(1, 66383, '\p{Is_Block=_	GOTHIC}', "");
    Expect(0, 66383, '\p{^Is_Block=_	GOTHIC}', "");
    Expect(0, 66383, '\P{Is_Block=_	GOTHIC}', "");
    Expect(1, 66383, '\P{^Is_Block=_	GOTHIC}', "");
    Expect(0, 66384, '\p{Is_Block=_	GOTHIC}', "");
    Expect(1, 66384, '\p{^Is_Block=_	GOTHIC}', "");
    Expect(1, 66384, '\P{Is_Block=_	GOTHIC}', "");
    Expect(0, 66384, '\P{^Is_Block=_	GOTHIC}', "");
    Error('\p{Is_Blk=:= _GOTHIC}');
    Error('\P{Is_Blk=:= _GOTHIC}');
    Expect(1, 66383, '\p{Is_Blk=gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
    Expect(1, 66383, '\p{Is_Blk=_GOTHIC}', "");
    Expect(0, 66383, '\p{^Is_Blk=_GOTHIC}', "");
    Expect(0, 66383, '\P{Is_Blk=_GOTHIC}', "");
    Expect(1, 66383, '\P{^Is_Blk=_GOTHIC}', "");
    Expect(0, 66384, '\p{Is_Blk=_GOTHIC}', "");
    Expect(1, 66384, '\p{^Is_Blk=_GOTHIC}', "");
    Expect(1, 66384, '\P{Is_Blk=_GOTHIC}', "");
    Expect(0, 66384, '\P{^Is_Blk=_GOTHIC}', "");
    Error('\p{Block:/a/		Grantha}');
    Error('\P{Block:/a/		Grantha}');
    Expect(1, 70527, '\p{Block=grantha}', "");
    Expect(0, 70527, '\p{^Block=grantha}', "");
    Expect(0, 70527, '\P{Block=grantha}', "");
    Expect(1, 70527, '\P{^Block=grantha}', "");
    Expect(0, 70528, '\p{Block=grantha}', "");
    Expect(1, 70528, '\p{^Block=grantha}', "");
    Expect(1, 70528, '\P{Block=grantha}', "");
    Expect(0, 70528, '\P{^Block=grantha}', "");
    Expect(1, 70527, '\p{Block=-_GRANTHA}', "");
    Expect(0, 70527, '\p{^Block=-_GRANTHA}', "");
    Expect(0, 70527, '\P{Block=-_GRANTHA}', "");
    Expect(1, 70527, '\P{^Block=-_GRANTHA}', "");
    Expect(0, 70528, '\p{Block=-_GRANTHA}', "");
    Expect(1, 70528, '\p{^Block=-_GRANTHA}', "");
    Expect(1, 70528, '\P{Block=-_GRANTHA}', "");
    Expect(0, 70528, '\P{^Block=-_GRANTHA}', "");
    Error('\p{Blk=_Grantha/a/}');
    Error('\P{Blk=_Grantha/a/}');
    Expect(1, 70527, '\p{Blk=grantha}', "");
    Expect(0, 70527, '\p{^Blk=grantha}', "");
    Expect(0, 70527, '\P{Blk=grantha}', "");
    Expect(1, 70527, '\P{^Blk=grantha}', "");
    Expect(0, 70528, '\p{Blk=grantha}', "");
    Expect(1, 70528, '\p{^Blk=grantha}', "");
    Expect(1, 70528, '\P{Blk=grantha}', "");
    Expect(0, 70528, '\P{^Blk=grantha}', "");
    Expect(1, 70527, '\p{Blk:   -_GRANTHA}', "");
    Expect(0, 70527, '\p{^Blk:   -_GRANTHA}', "");
    Expect(0, 70527, '\P{Blk:   -_GRANTHA}', "");
    Expect(1, 70527, '\P{^Blk:   -_GRANTHA}', "");
    Expect(0, 70528, '\p{Blk:   -_GRANTHA}', "");
    Expect(1, 70528, '\p{^Blk:   -_GRANTHA}', "");
    Expect(1, 70528, '\P{Blk:   -_GRANTHA}', "");
    Expect(0, 70528, '\P{^Blk:   -_GRANTHA}', "");
    Error('\p{Is_Block= :=Grantha}');
    Error('\P{Is_Block= :=Grantha}');
    Expect(1, 70527, '\p{Is_Block: grantha}', "");
    Expect(0, 70527, '\p{^Is_Block: grantha}', "");
    Expect(0, 70527, '\P{Is_Block: grantha}', "");
    Expect(1, 70527, '\P{^Is_Block: grantha}', "");
    Expect(0, 70528, '\p{Is_Block: grantha}', "");
    Expect(1, 70528, '\p{^Is_Block: grantha}', "");
    Expect(1, 70528, '\P{Is_Block: grantha}', "");
    Expect(0, 70528, '\P{^Is_Block: grantha}', "");
    Expect(1, 70527, '\p{Is_Block=--Grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=--Grantha}', "");
    Expect(0, 70527, '\P{Is_Block=--Grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=--Grantha}', "");
    Expect(0, 70528, '\p{Is_Block=--Grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=--Grantha}', "");
    Expect(1, 70528, '\P{Is_Block=--Grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=--Grantha}', "");
    Error('\p{Is_Blk=/a/-grantha}');
    Error('\P{Is_Blk=/a/-grantha}');
    Expect(1, 70527, '\p{Is_Blk=grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk=grantha}', "");
    Expect(0, 70527, '\P{Is_Blk=grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk=grantha}', "");
    Expect(0, 70528, '\p{Is_Blk=grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk=grantha}', "");
    Expect(1, 70528, '\P{Is_Blk=grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk=grantha}', "");
    Expect(1, 70527, '\p{Is_Blk:__Grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk:__Grantha}', "");
    Expect(0, 70527, '\P{Is_Blk:__Grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk:__Grantha}', "");
    Expect(0, 70528, '\p{Is_Blk:__Grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk:__Grantha}', "");
    Expect(1, 70528, '\P{Is_Blk:__Grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk:__Grantha}', "");
    Error('\p{Block=:=Greek_and_coptic}');
    Error('\P{Block=:=Greek_and_coptic}');
    Expect(1, 1023, '\p{Block:	greekandcoptic}', "");
    Expect(0, 1023, '\p{^Block:	greekandcoptic}', "");
    Expect(0, 1023, '\P{Block:	greekandcoptic}', "");
    Expect(1, 1023, '\P{^Block:	greekandcoptic}', "");
    Expect(0, 1024, '\p{Block:	greekandcoptic}', "");
    Expect(1, 1024, '\p{^Block:	greekandcoptic}', "");
    Expect(1, 1024, '\P{Block:	greekandcoptic}', "");
    Expect(0, 1024, '\P{^Block:	greekandcoptic}', "");
    Expect(1, 1023, '\p{Block= -greek_and_Coptic}', "");
    Expect(0, 1023, '\p{^Block= -greek_and_Coptic}', "");
    Expect(0, 1023, '\P{Block= -greek_and_Coptic}', "");
    Expect(1, 1023, '\P{^Block= -greek_and_Coptic}', "");
    Expect(0, 1024, '\p{Block= -greek_and_Coptic}', "");
    Expect(1, 1024, '\p{^Block= -greek_and_Coptic}', "");
    Expect(1, 1024, '\P{Block= -greek_and_Coptic}', "");
    Expect(0, 1024, '\P{^Block= -greek_and_Coptic}', "");
    Error('\p{Blk=-_Greek:=}');
    Error('\P{Blk=-_Greek:=}');
    Expect(1, 1023, '\p{Blk=greek}', "");
    Expect(0, 1023, '\p{^Blk=greek}', "");
    Expect(0, 1023, '\P{Blk=greek}', "");
    Expect(1, 1023, '\P{^Blk=greek}', "");
    Expect(0, 1024, '\p{Blk=greek}', "");
    Expect(1, 1024, '\p{^Blk=greek}', "");
    Expect(1, 1024, '\P{Blk=greek}', "");
    Expect(0, 1024, '\P{^Blk=greek}', "");
    Expect(1, 1023, '\p{Blk=	_GREEK}', "");
    Expect(0, 1023, '\p{^Blk=	_GREEK}', "");
    Expect(0, 1023, '\P{Blk=	_GREEK}', "");
    Expect(1, 1023, '\P{^Blk=	_GREEK}', "");
    Expect(0, 1024, '\p{Blk=	_GREEK}', "");
    Expect(1, 1024, '\p{^Blk=	_GREEK}', "");
    Expect(1, 1024, '\P{Blk=	_GREEK}', "");
    Expect(0, 1024, '\P{^Blk=	_GREEK}', "");
    Error('\p{Is_Block=-greek_And_Coptic:=}');
    Error('\P{Is_Block=-greek_And_Coptic:=}');
    Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Is_Block= -Greek_And_Coptic}', "");
    Expect(0, 1023, '\p{^Is_Block= -Greek_And_Coptic}', "");
    Expect(0, 1023, '\P{Is_Block= -Greek_And_Coptic}', "");
    Expect(1, 1023, '\P{^Is_Block= -Greek_And_Coptic}', "");
    Expect(0, 1024, '\p{Is_Block= -Greek_And_Coptic}', "");
    Expect(1, 1024, '\p{^Is_Block= -Greek_And_Coptic}', "");
    Expect(1, 1024, '\P{Is_Block= -Greek_And_Coptic}', "");
    Expect(0, 1024, '\P{^Is_Block= -Greek_And_Coptic}', "");
    Error('\p{Is_Blk=:= GREEK}');
    Error('\P{Is_Blk=:= GREEK}');
    Expect(1, 1023, '\p{Is_Blk=greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=greek}', "");
    Expect(0, 1023, '\P{Is_Blk=greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=greek}', "");
    Expect(0, 1024, '\p{Is_Blk=greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=greek}', "");
    Expect(1, 1024, '\P{Is_Blk=greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=greek}', "");
    Expect(1, 1023, '\p{Is_Blk=  GREEK}', "");
    Expect(0, 1023, '\p{^Is_Blk=  GREEK}', "");
    Expect(0, 1023, '\P{Is_Blk=  GREEK}', "");
    Expect(1, 1023, '\P{^Is_Blk=  GREEK}', "");
    Expect(0, 1024, '\p{Is_Blk=  GREEK}', "");
    Expect(1, 1024, '\p{^Is_Blk=  GREEK}', "");
    Expect(1, 1024, '\P{Is_Blk=  GREEK}', "");
    Expect(0, 1024, '\P{^Is_Blk=  GREEK}', "");
    Error('\p{Block= GREEK_Extended:=}');
    Error('\P{Block= GREEK_Extended:=}');
    Expect(1, 8191, '\p{Block=greekextended}', "");
    Expect(0, 8191, '\p{^Block=greekextended}', "");
    Expect(0, 8191, '\P{Block=greekextended}', "");
    Expect(1, 8191, '\P{^Block=greekextended}', "");
    Expect(0, 8192, '\p{Block=greekextended}', "");
    Expect(1, 8192, '\p{^Block=greekextended}', "");
    Expect(1, 8192, '\P{Block=greekextended}', "");
    Expect(0, 8192, '\P{^Block=greekextended}', "");
    Expect(1, 8191, '\p{Block=_-Greek_Extended}', "");
    Expect(0, 8191, '\p{^Block=_-Greek_Extended}', "");
    Expect(0, 8191, '\P{Block=_-Greek_Extended}', "");
    Expect(1, 8191, '\P{^Block=_-Greek_Extended}', "");
    Expect(0, 8192, '\p{Block=_-Greek_Extended}', "");
    Expect(1, 8192, '\p{^Block=_-Greek_Extended}', "");
    Expect(1, 8192, '\P{Block=_-Greek_Extended}', "");
    Expect(0, 8192, '\P{^Block=_-Greek_Extended}', "");
    Error('\p{Blk=/a/GREEK_Ext}');
    Error('\P{Blk=/a/GREEK_Ext}');
    Expect(1, 8191, '\p{Blk=greekext}', "");
    Expect(0, 8191, '\p{^Blk=greekext}', "");
    Expect(0, 8191, '\P{Blk=greekext}', "");
    Expect(1, 8191, '\P{^Blk=greekext}', "");
    Expect(0, 8192, '\p{Blk=greekext}', "");
    Expect(1, 8192, '\p{^Blk=greekext}', "");
    Expect(1, 8192, '\P{Blk=greekext}', "");
    Expect(0, 8192, '\P{^Blk=greekext}', "");
    Expect(1, 8191, '\p{Blk=_Greek_EXT}', "");
    Expect(0, 8191, '\p{^Blk=_Greek_EXT}', "");
    Expect(0, 8191, '\P{Blk=_Greek_EXT}', "");
    Expect(1, 8191, '\P{^Blk=_Greek_EXT}', "");
    Expect(0, 8192, '\p{Blk=_Greek_EXT}', "");
    Expect(1, 8192, '\p{^Blk=_Greek_EXT}', "");
    Expect(1, 8192, '\P{Blk=_Greek_EXT}', "");
    Expect(0, 8192, '\P{^Blk=_Greek_EXT}', "");
    Error('\p{Is_Block=_/a/greek_EXTENDED}');
    Error('\P{Is_Block=_/a/greek_EXTENDED}');
    Expect(1, 8191, '\p{Is_Block=greekextended}', "");
    Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
    Expect(0, 8191, '\P{Is_Block=greekextended}', "");
    Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
    Expect(0, 8192, '\p{Is_Block=greekextended}', "");
    Expect(1, 8192, '\p{^Is_Block=greekextended}', "");
    Expect(1, 8192, '\P{Is_Block=greekextended}', "");
    Expect(0, 8192, '\P{^Is_Block=greekextended}', "");
    Expect(1, 8191, '\p{Is_Block=  Greek_Extended}', "");
    Expect(0, 8191, '\p{^Is_Block=  Greek_Extended}', "");
    Expect(0, 8191, '\P{Is_Block=  Greek_Extended}', "");
    Expect(1, 8191, '\P{^Is_Block=  Greek_Extended}', "");
    Expect(0, 8192, '\p{Is_Block=  Greek_Extended}', "");
    Expect(1, 8192, '\p{^Is_Block=  Greek_Extended}', "");
    Expect(1, 8192, '\P{Is_Block=  Greek_Extended}', "");
    Expect(0, 8192, '\P{^Is_Block=  Greek_Extended}', "");
    Error('\p{Is_Blk:  _Greek_ext/a/}');
    Error('\P{Is_Blk:  _Greek_ext/a/}');
    Expect(1, 8191, '\p{Is_Blk=greekext}', "");
    Expect(0, 8191, '\p{^Is_Blk=greekext}', "");
    Expect(0, 8191, '\P{Is_Blk=greekext}', "");
    Expect(1, 8191, '\P{^Is_Blk=greekext}', "");
    Expect(0, 8192, '\p{Is_Blk=greekext}', "");
    Expect(1, 8192, '\p{^Is_Blk=greekext}', "");
    Expect(1, 8192, '\P{Is_Blk=greekext}', "");
    Expect(0, 8192, '\P{^Is_Blk=greekext}', "");
    Expect(1, 8191, '\p{Is_Blk= Greek_EXT}', "");
    Expect(0, 8191, '\p{^Is_Blk= Greek_EXT}', "");
    Expect(0, 8191, '\P{Is_Blk= Greek_EXT}', "");
    Expect(1, 8191, '\P{^Is_Blk= Greek_EXT}', "");
    Expect(0, 8192, '\p{Is_Blk= Greek_EXT}', "");
    Expect(1, 8192, '\p{^Is_Blk= Greek_EXT}', "");
    Expect(1, 8192, '\P{Is_Blk= Greek_EXT}', "");
    Expect(0, 8192, '\P{^Is_Blk= Greek_EXT}', "");
    Error('\p{Block=/a/Gujarati}');
    Error('\P{Block=/a/Gujarati}');
    Expect(1, 2815, '\p{Block=gujarati}', "");
    Expect(0, 2815, '\p{^Block=gujarati}', "");
    Expect(0, 2815, '\P{Block=gujarati}', "");
    Expect(1, 2815, '\P{^Block=gujarati}', "");
    Expect(0, 2816, '\p{Block=gujarati}', "");
    Expect(1, 2816, '\p{^Block=gujarati}', "");
    Expect(1, 2816, '\P{Block=gujarati}', "");
    Expect(0, 2816, '\P{^Block=gujarati}', "");
    Expect(1, 2815, '\p{Block=_-Gujarati}', "");
    Expect(0, 2815, '\p{^Block=_-Gujarati}', "");
    Expect(0, 2815, '\P{Block=_-Gujarati}', "");
    Expect(1, 2815, '\P{^Block=_-Gujarati}', "");
    Expect(0, 2816, '\p{Block=_-Gujarati}', "");
    Expect(1, 2816, '\p{^Block=_-Gujarati}', "");
    Expect(1, 2816, '\P{Block=_-Gujarati}', "");
    Expect(0, 2816, '\P{^Block=_-Gujarati}', "");
    Error('\p{Blk= -gujarati/a/}');
    Error('\P{Blk= -gujarati/a/}');
    Expect(1, 2815, '\p{Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Blk=gujarati}', "");
    Expect(0, 2815, '\P{Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Blk=gujarati}', "");
    Expect(0, 2816, '\p{Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Blk=gujarati}', "");
    Expect(1, 2816, '\P{Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Blk=gujarati}', "");
    Expect(1, 2815, '\p{Blk= Gujarati}', "");
    Expect(0, 2815, '\p{^Blk= Gujarati}', "");
    Expect(0, 2815, '\P{Blk= Gujarati}', "");
    Expect(1, 2815, '\P{^Blk= Gujarati}', "");
    Expect(0, 2816, '\p{Blk= Gujarati}', "");
    Expect(1, 2816, '\p{^Blk= Gujarati}', "");
    Expect(1, 2816, '\P{Blk= Gujarati}', "");
    Expect(0, 2816, '\P{^Blk= Gujarati}', "");
    Error('\p{Is_Block=/a/-gujarati}');
    Error('\P{Is_Block=/a/-gujarati}');
    Expect(1, 2815, '\p{Is_Block:	gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block:	gujarati}', "");
    Expect(0, 2815, '\P{Is_Block:	gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block:	gujarati}', "");
    Expect(0, 2816, '\p{Is_Block:	gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block:	gujarati}', "");
    Expect(1, 2816, '\P{Is_Block:	gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block:	gujarati}', "");
    Expect(1, 2815, '\p{Is_Block=	Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=	Gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=	Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=	Gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=	Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=	Gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=	Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=	Gujarati}', "");
    Error('\p{Is_Blk=  Gujarati:=}');
    Error('\P{Is_Blk=  Gujarati:=}');
    Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=gujarati}', "");
    Expect(1, 2815, '\p{Is_Blk=  Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=  Gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=  Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=  Gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=  Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=  Gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=  Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=  Gujarati}', "");
    Error('\p{Block=:=__gurmukhi}');
    Error('\P{Block=:=__gurmukhi}');
    Expect(1, 2687, '\p{Block:   gurmukhi}', "");
    Expect(0, 2687, '\p{^Block:   gurmukhi}', "");
    Expect(0, 2687, '\P{Block:   gurmukhi}', "");
    Expect(1, 2687, '\P{^Block:   gurmukhi}', "");
    Expect(0, 2688, '\p{Block:   gurmukhi}', "");
    Expect(1, 2688, '\p{^Block:   gurmukhi}', "");
    Expect(1, 2688, '\P{Block:   gurmukhi}', "");
    Expect(0, 2688, '\P{^Block:   gurmukhi}', "");
    Expect(1, 2687, '\p{Block:   	_GURMUKHI}', "");
    Expect(0, 2687, '\p{^Block:   	_GURMUKHI}', "");
    Expect(0, 2687, '\P{Block:   	_GURMUKHI}', "");
    Expect(1, 2687, '\P{^Block:   	_GURMUKHI}', "");
    Expect(0, 2688, '\p{Block:   	_GURMUKHI}', "");
    Expect(1, 2688, '\p{^Block:   	_GURMUKHI}', "");
    Expect(1, 2688, '\P{Block:   	_GURMUKHI}', "");
    Expect(0, 2688, '\P{^Block:   	_GURMUKHI}', "");
    Error('\p{Blk=-Gurmukhi:=}');
    Error('\P{Blk=-Gurmukhi:=}');
    Expect(1, 2687, '\p{Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Blk=	Gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=	Gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=	Gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=	Gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=	Gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=	Gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=	Gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=	Gurmukhi}', "");
    Error('\p{Is_Block= /a/Gurmukhi}');
    Error('\P{Is_Block= /a/Gurmukhi}');
    Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Block=_	GURMUKHI}', "");
    Expect(0, 2687, '\p{^Is_Block=_	GURMUKHI}', "");
    Expect(0, 2687, '\P{Is_Block=_	GURMUKHI}', "");
    Expect(1, 2687, '\P{^Is_Block=_	GURMUKHI}', "");
    Expect(0, 2688, '\p{Is_Block=_	GURMUKHI}', "");
    Expect(1, 2688, '\p{^Is_Block=_	GURMUKHI}', "");
    Expect(1, 2688, '\P{Is_Block=_	GURMUKHI}', "");
    Expect(0, 2688, '\P{^Is_Block=_	GURMUKHI}', "");
    Error('\p{Is_Blk=:=	 Gurmukhi}');
    Error('\P{Is_Blk=:=	 Gurmukhi}');
    Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=_Gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=_Gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=_Gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=_Gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=_Gurmukhi}', "");
    Error('\p{Block=	Halfwidth_AND_Fullwidth_Forms:=}');
    Error('\P{Block=	Halfwidth_AND_Fullwidth_Forms:=}');
    Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65519, '\p{^Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65519, '\P{Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65519, '\P{^Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65520, '\p{Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65520, '\p{^Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(1, 65520, '\P{Block=_halfwidth_And_Fullwidth_Forms}', "");
    Expect(0, 65520, '\P{^Block=_halfwidth_And_Fullwidth_Forms}', "");
    Error('\p{Blk=_/a/half_And_Full_Forms}');
    Error('\P{Blk=_/a/half_And_Full_Forms}');
    Expect(1, 65519, '\p{Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Blk=	_half_And_full_Forms}', "");
    Expect(0, 65519, '\p{^Blk=	_half_And_full_Forms}', "");
    Expect(0, 65519, '\P{Blk=	_half_And_full_Forms}', "");
    Expect(1, 65519, '\P{^Blk=	_half_And_full_Forms}', "");
    Expect(0, 65520, '\p{Blk=	_half_And_full_Forms}', "");
    Expect(1, 65520, '\p{^Blk=	_half_And_full_Forms}', "");
    Expect(1, 65520, '\P{Blk=	_half_And_full_Forms}', "");
    Expect(0, 65520, '\P{^Blk=	_half_And_full_Forms}', "");
    Error('\p{Is_Block= :=halfwidth_and_fullwidth_Forms}');
    Error('\P{Is_Block= :=halfwidth_and_fullwidth_Forms}');
    Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(0, 65519, '\p{^Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(0, 65519, '\P{Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(1, 65519, '\P{^Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(0, 65520, '\p{Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(1, 65520, '\p{^Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(1, 65520, '\P{Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Expect(0, 65520, '\P{^Is_Block:   -Halfwidth_and_fullwidth_FORMS}', "");
    Error('\p{Is_Blk= /a/HALF_AND_Full_forms}');
    Error('\P{Is_Blk= /a/HALF_AND_Full_forms}');
    Expect(1, 65519, '\p{Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Is_Blk= -half_and_Full_FORMS}', "");
    Expect(0, 65519, '\p{^Is_Blk= -half_and_Full_FORMS}', "");
    Expect(0, 65519, '\P{Is_Blk= -half_and_Full_FORMS}', "");
    Expect(1, 65519, '\P{^Is_Blk= -half_and_Full_FORMS}', "");
    Expect(0, 65520, '\p{Is_Blk= -half_and_Full_FORMS}', "");
    Expect(1, 65520, '\p{^Is_Blk= -half_and_Full_FORMS}', "");
    Expect(1, 65520, '\P{Is_Blk= -half_and_Full_FORMS}', "");
    Expect(0, 65520, '\P{^Is_Blk= -half_and_Full_FORMS}', "");
    Error('\p{Block=-Combining_HALF_Marks:=}');
    Error('\P{Block=-Combining_HALF_Marks:=}');
    Expect(1, 65071, '\p{Block:   combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Block:   combininghalfmarks}', "");
    Expect(0, 65071, '\P{Block:   combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Block:   combininghalfmarks}', "");
    Expect(0, 65072, '\p{Block:   combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Block:   combininghalfmarks}', "");
    Expect(1, 65072, '\P{Block:   combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Block:   combininghalfmarks}', "");
    Expect(1, 65071, '\p{Block:		Combining_half_Marks}', "");
    Expect(0, 65071, '\p{^Block:		Combining_half_Marks}', "");
    Expect(0, 65071, '\P{Block:		Combining_half_Marks}', "");
    Expect(1, 65071, '\P{^Block:		Combining_half_Marks}', "");
    Expect(0, 65072, '\p{Block:		Combining_half_Marks}', "");
    Expect(1, 65072, '\p{^Block:		Combining_half_Marks}', "");
    Expect(1, 65072, '\P{Block:		Combining_half_Marks}', "");
    Expect(0, 65072, '\P{^Block:		Combining_half_Marks}', "");
    Error('\p{Blk=:= 	Half_Marks}');
    Error('\P{Blk=:= 	Half_Marks}');
    Expect(1, 65071, '\p{Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Blk=	 half_marks}', "");
    Expect(0, 65071, '\p{^Blk=	 half_marks}', "");
    Expect(0, 65071, '\P{Blk=	 half_marks}', "");
    Expect(1, 65071, '\P{^Blk=	 half_marks}', "");
    Expect(0, 65072, '\p{Blk=	 half_marks}', "");
    Expect(1, 65072, '\p{^Blk=	 half_marks}', "");
    Expect(1, 65072, '\P{Blk=	 half_marks}', "");
    Expect(0, 65072, '\P{^Blk=	 half_marks}', "");
    Error('\p{Is_Block=/a/combining_Half_MARKS}');
    Error('\P{Is_Block=/a/combining_Half_MARKS}');
    Expect(1, 65071, '\p{Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Is_Block:   -Combining_Half_marks}', "");
    Expect(0, 65071, '\p{^Is_Block:   -Combining_Half_marks}', "");
    Expect(0, 65071, '\P{Is_Block:   -Combining_Half_marks}', "");
    Expect(1, 65071, '\P{^Is_Block:   -Combining_Half_marks}', "");
    Expect(0, 65072, '\p{Is_Block:   -Combining_Half_marks}', "");
    Expect(1, 65072, '\p{^Is_Block:   -Combining_Half_marks}', "");
    Expect(1, 65072, '\P{Is_Block:   -Combining_Half_marks}', "");
    Expect(0, 65072, '\P{^Is_Block:   -Combining_Half_marks}', "");
    Error('\p{Is_Blk=_	Half_Marks:=}');
    Error('\P{Is_Blk=_	Half_Marks:=}');
    Expect(1, 65071, '\p{Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Is_Blk=-Half_marks}', "");
    Expect(0, 65071, '\p{^Is_Blk=-Half_marks}', "");
    Expect(0, 65071, '\P{Is_Blk=-Half_marks}', "");
    Expect(1, 65071, '\P{^Is_Blk=-Half_marks}', "");
    Expect(0, 65072, '\p{Is_Blk=-Half_marks}', "");
    Expect(1, 65072, '\p{^Is_Blk=-Half_marks}', "");
    Expect(1, 65072, '\P{Is_Blk=-Half_marks}', "");
    Expect(0, 65072, '\P{^Is_Blk=-Half_marks}', "");
    Error('\p{Block=-/a/HANGUL_syllables}');
    Error('\P{Block=-/a/HANGUL_syllables}');
    Expect(1, 55215, '\p{Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Block=-	HANGUL_Syllables}', "");
    Expect(0, 55215, '\p{^Block=-	HANGUL_Syllables}', "");
    Expect(0, 55215, '\P{Block=-	HANGUL_Syllables}', "");
    Expect(1, 55215, '\P{^Block=-	HANGUL_Syllables}', "");
    Expect(0, 55216, '\p{Block=-	HANGUL_Syllables}', "");
    Expect(1, 55216, '\p{^Block=-	HANGUL_Syllables}', "");
    Expect(1, 55216, '\P{Block=-	HANGUL_Syllables}', "");
    Expect(0, 55216, '\P{^Block=-	HANGUL_Syllables}', "");
    Error('\p{Blk=:=HANGUL}');
    Error('\P{Blk=:=HANGUL}');
    Expect(1, 55215, '\p{Blk=hangul}', "");
    Expect(0, 55215, '\p{^Blk=hangul}', "");
    Expect(0, 55215, '\P{Blk=hangul}', "");
    Expect(1, 55215, '\P{^Blk=hangul}', "");
    Expect(0, 55216, '\p{Blk=hangul}', "");
    Expect(1, 55216, '\p{^Blk=hangul}', "");
    Expect(1, 55216, '\P{Blk=hangul}', "");
    Expect(0, 55216, '\P{^Blk=hangul}', "");
    Expect(1, 55215, '\p{Blk=- HANGUL}', "");
    Expect(0, 55215, '\p{^Blk=- HANGUL}', "");
    Expect(0, 55215, '\P{Blk=- HANGUL}', "");
    Expect(1, 55215, '\P{^Blk=- HANGUL}', "");
    Expect(0, 55216, '\p{Blk=- HANGUL}', "");
    Expect(1, 55216, '\p{^Blk=- HANGUL}', "");
    Expect(1, 55216, '\P{Blk=- HANGUL}', "");
    Expect(0, 55216, '\P{^Blk=- HANGUL}', "");
    Error('\p{Is_Block=/a/-_Hangul_syllables}');
    Error('\P{Is_Block=/a/-_Hangul_syllables}');
    Expect(1, 55215, '\p{Is_Block:	hangulsyllables}', "");
    Expect(0, 55215, '\p{^Is_Block:	hangulsyllables}', "");
    Expect(0, 55215, '\P{Is_Block:	hangulsyllables}', "");
    Expect(1, 55215, '\P{^Is_Block:	hangulsyllables}', "");
    Expect(0, 55216, '\p{Is_Block:	hangulsyllables}', "");
    Expect(1, 55216, '\p{^Is_Block:	hangulsyllables}', "");
    Expect(1, 55216, '\P{Is_Block:	hangulsyllables}', "");
    Expect(0, 55216, '\P{^Is_Block:	hangulsyllables}', "");
    Expect(1, 55215, '\p{Is_Block=_Hangul_Syllables}', "");
    Expect(0, 55215, '\p{^Is_Block=_Hangul_Syllables}', "");
    Expect(0, 55215, '\P{Is_Block=_Hangul_Syllables}', "");
    Expect(1, 55215, '\P{^Is_Block=_Hangul_Syllables}', "");
    Expect(0, 55216, '\p{Is_Block=_Hangul_Syllables}', "");
    Expect(1, 55216, '\p{^Is_Block=_Hangul_Syllables}', "");
    Expect(1, 55216, '\P{Is_Block=_Hangul_Syllables}', "");
    Expect(0, 55216, '\P{^Is_Block=_Hangul_Syllables}', "");
    Error('\p{Is_Blk=	hangul/a/}');
    Error('\P{Is_Blk=	hangul/a/}');
    Expect(1, 55215, '\p{Is_Blk=hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=hangul}', "");
    Expect(1, 55215, '\p{Is_Blk=--HANGUL}', "");
    Expect(0, 55215, '\p{^Is_Blk=--HANGUL}', "");
    Expect(0, 55215, '\P{Is_Blk=--HANGUL}', "");
    Expect(1, 55215, '\P{^Is_Blk=--HANGUL}', "");
    Expect(0, 55216, '\p{Is_Blk=--HANGUL}', "");
    Expect(1, 55216, '\p{^Is_Blk=--HANGUL}', "");
    Expect(1, 55216, '\P{Is_Blk=--HANGUL}', "");
    Expect(0, 55216, '\P{^Is_Blk=--HANGUL}', "");
    Error('\p{Block: := HANUNOO}');
    Error('\P{Block: := HANUNOO}');
    Expect(1, 5951, '\p{Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Block=hanunoo}', "");
    Expect(0, 5951, '\P{Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Block=hanunoo}', "");
    Expect(0, 5952, '\p{Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Block=hanunoo}', "");
    Expect(1, 5952, '\P{Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Block=hanunoo}', "");
    Expect(1, 5951, '\p{Block= _HANUNOO}', "");
    Expect(0, 5951, '\p{^Block= _HANUNOO}', "");
    Expect(0, 5951, '\P{Block= _HANUNOO}', "");
    Expect(1, 5951, '\P{^Block= _HANUNOO}', "");
    Expect(0, 5952, '\p{Block= _HANUNOO}', "");
    Expect(1, 5952, '\p{^Block= _HANUNOO}', "");
    Expect(1, 5952, '\P{Block= _HANUNOO}', "");
    Expect(0, 5952, '\P{^Block= _HANUNOO}', "");
    Error('\p{Blk=/a/	_hanunoo}');
    Error('\P{Blk=/a/	_hanunoo}');
    Expect(1, 5951, '\p{Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Blk=-	Hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=-	Hanunoo}', "");
    Expect(0, 5951, '\P{Blk=-	Hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=-	Hanunoo}', "");
    Expect(0, 5952, '\p{Blk=-	Hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=-	Hanunoo}', "");
    Expect(1, 5952, '\P{Blk=-	Hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=-	Hanunoo}', "");
    Error('\p{Is_Block:		hanunoo/a/}');
    Error('\P{Is_Block:		hanunoo/a/}');
    Expect(1, 5951, '\p{Is_Block: hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block: hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block: hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block: hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block: hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block: hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block: hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block: hanunoo}', "");
    Expect(1, 5951, '\p{Is_Block=  Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block=  Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block=  Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block=  Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block=  Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block=  Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block=  Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block=  Hanunoo}', "");
    Error('\p{Is_Blk=	/a/Hanunoo}');
    Error('\P{Is_Blk=	/a/Hanunoo}');
    Expect(1, 5951, '\p{Is_Blk:	hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk:	hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk:	hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk:	hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk:	hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk:	hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk:	hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk:	hanunoo}', "");
    Expect(1, 5951, '\p{Is_Blk= -Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk= -Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk= -Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk= -Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk= -Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk= -Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk= -Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk= -Hanunoo}', "");
    Error('\p{Block=_/a/Hatran}');
    Error('\P{Block=_/a/Hatran}');
    Expect(1, 67839, '\p{Block=hatran}', "");
    Expect(0, 67839, '\p{^Block=hatran}', "");
    Expect(0, 67839, '\P{Block=hatran}', "");
    Expect(1, 67839, '\P{^Block=hatran}', "");
    Expect(0, 67840, '\p{Block=hatran}', "");
    Expect(1, 67840, '\p{^Block=hatran}', "");
    Expect(1, 67840, '\P{Block=hatran}', "");
    Expect(0, 67840, '\P{^Block=hatran}', "");
    Expect(1, 67839, '\p{Block=-HATRAN}', "");
    Expect(0, 67839, '\p{^Block=-HATRAN}', "");
    Expect(0, 67839, '\P{Block=-HATRAN}', "");
    Expect(1, 67839, '\P{^Block=-HATRAN}', "");
    Expect(0, 67840, '\p{Block=-HATRAN}', "");
    Expect(1, 67840, '\p{^Block=-HATRAN}', "");
    Expect(1, 67840, '\P{Block=-HATRAN}', "");
    Expect(0, 67840, '\P{^Block=-HATRAN}', "");
    Error('\p{Blk=-:=hatran}');
    Error('\P{Blk=-:=hatran}');
    Expect(1, 67839, '\p{Blk=hatran}', "");
    Expect(0, 67839, '\p{^Blk=hatran}', "");
    Expect(0, 67839, '\P{Blk=hatran}', "");
    Expect(1, 67839, '\P{^Blk=hatran}', "");
    Expect(0, 67840, '\p{Blk=hatran}', "");
    Expect(1, 67840, '\p{^Blk=hatran}', "");
    Expect(1, 67840, '\P{Blk=hatran}', "");
    Expect(0, 67840, '\P{^Blk=hatran}', "");
    Expect(1, 67839, '\p{Blk=_ Hatran}', "");
    Expect(0, 67839, '\p{^Blk=_ Hatran}', "");
    Expect(0, 67839, '\P{Blk=_ Hatran}', "");
    Expect(1, 67839, '\P{^Blk=_ Hatran}', "");
    Expect(0, 67840, '\p{Blk=_ Hatran}', "");
    Expect(1, 67840, '\p{^Blk=_ Hatran}', "");
    Expect(1, 67840, '\P{Blk=_ Hatran}', "");
    Expect(0, 67840, '\P{^Blk=_ Hatran}', "");
    Error('\p{Is_Block: 	HATRAN:=}');
    Error('\P{Is_Block: 	HATRAN:=}');
    Expect(1, 67839, '\p{Is_Block: hatran}', "");
    Expect(0, 67839, '\p{^Is_Block: hatran}', "");
    Expect(0, 67839, '\P{Is_Block: hatran}', "");
    Expect(1, 67839, '\P{^Is_Block: hatran}', "");
    Expect(0, 67840, '\p{Is_Block: hatran}', "");
    Expect(1, 67840, '\p{^Is_Block: hatran}', "");
    Expect(1, 67840, '\P{Is_Block: hatran}', "");
    Expect(0, 67840, '\P{^Is_Block: hatran}', "");
    Expect(1, 67839, '\p{Is_Block=_Hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=_Hatran}', "");
    Expect(0, 67839, '\P{Is_Block=_Hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=_Hatran}', "");
    Expect(0, 67840, '\p{Is_Block=_Hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=_Hatran}', "");
    Expect(1, 67840, '\P{Is_Block=_Hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=_Hatran}', "");
    Error('\p{Is_Blk=/a/Hatran}');
    Error('\P{Is_Blk=/a/Hatran}');
    Expect(1, 67839, '\p{Is_Blk=hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=hatran}', "");
    Expect(1, 67839, '\p{Is_Blk=_-HATRAN}', "");
    Expect(0, 67839, '\p{^Is_Blk=_-HATRAN}', "");
    Expect(0, 67839, '\P{Is_Blk=_-HATRAN}', "");
    Expect(1, 67839, '\P{^Is_Blk=_-HATRAN}', "");
    Expect(0, 67840, '\p{Is_Blk=_-HATRAN}', "");
    Expect(1, 67840, '\p{^Is_Blk=_-HATRAN}', "");
    Expect(1, 67840, '\P{Is_Blk=_-HATRAN}', "");
    Expect(0, 67840, '\P{^Is_Blk=_-HATRAN}', "");
    Error('\p{Block=:=_	Hebrew}');
    Error('\P{Block=:=_	Hebrew}');
    Expect(1, 1535, '\p{Block=hebrew}', "");
    Expect(0, 1535, '\p{^Block=hebrew}', "");
    Expect(0, 1535, '\P{Block=hebrew}', "");
    Expect(1, 1535, '\P{^Block=hebrew}', "");
    Expect(0, 1536, '\p{Block=hebrew}', "");
    Expect(1, 1536, '\p{^Block=hebrew}', "");
    Expect(1, 1536, '\P{Block=hebrew}', "");
    Expect(0, 1536, '\P{^Block=hebrew}', "");
    Expect(1, 1535, '\p{Block=--HEBREW}', "");
    Expect(0, 1535, '\p{^Block=--HEBREW}', "");
    Expect(0, 1535, '\P{Block=--HEBREW}', "");
    Expect(1, 1535, '\P{^Block=--HEBREW}', "");
    Expect(0, 1536, '\p{Block=--HEBREW}', "");
    Expect(1, 1536, '\p{^Block=--HEBREW}', "");
    Expect(1, 1536, '\P{Block=--HEBREW}', "");
    Expect(0, 1536, '\P{^Block=--HEBREW}', "");
    Error('\p{Blk=_/a/hebrew}');
    Error('\P{Blk=_/a/hebrew}');
    Expect(1, 1535, '\p{Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Blk=hebrew}', "");
    Expect(0, 1535, '\P{Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Blk=hebrew}', "");
    Expect(0, 1536, '\p{Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Blk=hebrew}', "");
    Expect(1, 1536, '\P{Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Blk=hebrew}', "");
    Expect(1, 1535, '\p{Blk=	_hebrew}', "");
    Expect(0, 1535, '\p{^Blk=	_hebrew}', "");
    Expect(0, 1535, '\P{Blk=	_hebrew}', "");
    Expect(1, 1535, '\P{^Blk=	_hebrew}', "");
    Expect(0, 1536, '\p{Blk=	_hebrew}', "");
    Expect(1, 1536, '\p{^Blk=	_hebrew}', "");
    Expect(1, 1536, '\P{Blk=	_hebrew}', "");
    Expect(0, 1536, '\P{^Blk=	_hebrew}', "");
    Error('\p{Is_Block=-:=Hebrew}');
    Error('\P{Is_Block=-:=Hebrew}');
    Expect(1, 1535, '\p{Is_Block=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=hebrew}', "");
    Expect(1, 1535, '\p{Is_Block= Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block= Hebrew}', "");
    Expect(0, 1535, '\P{Is_Block= Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block= Hebrew}', "");
    Expect(0, 1536, '\p{Is_Block= Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block= Hebrew}', "");
    Expect(1, 1536, '\P{Is_Block= Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block= Hebrew}', "");
    Error('\p{Is_Blk=	/a/HEBREW}');
    Error('\P{Is_Blk=	/a/HEBREW}');
    Expect(1, 1535, '\p{Is_Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=hebrew}', "");
    Expect(1, 1535, '\p{Is_Blk=	hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=	hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=	hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=	hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=	hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=	hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=	hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=	hebrew}', "");
    Error('\p{Block=-/a/High_Private_use_surrogates}');
    Error('\P{Block=-/a/High_Private_use_surrogates}');
    Expect(1, 56319, '\p{Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(0, 56319, '\p{^Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(0, 56319, '\P{Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(1, 56319, '\P{^Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(0, 57344, '\p{Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(1, 57344, '\P{Block=  HIGH_Private_Use_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=  HIGH_Private_Use_Surrogates}', "");
    Error('\p{Blk=:=_	High_pu_surrogates}');
    Error('\P{Blk=:=_	High_pu_surrogates}');
    Expect(1, 56319, '\p{Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Blk=_-High_pu_Surrogates}', "");
    Expect(0, 56319, '\p{^Blk=_-High_pu_Surrogates}', "");
    Expect(0, 56319, '\P{Blk=_-High_pu_Surrogates}', "");
    Expect(1, 56319, '\P{^Blk=_-High_pu_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=_-High_pu_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=_-High_pu_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=_-High_pu_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=_-High_pu_Surrogates}', "");
    Error('\p{Is_Block=/a/HIGH_PRIVATE_Use_surrogates}');
    Error('\P{Is_Block=/a/HIGH_PRIVATE_Use_surrogates}');
    Expect(1, 56319, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(0, 56319, '\P{Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=_-HIGH_Private_Use_surrogates}', "");
    Error('\p{Is_Blk=_/a/High_pu_SURROGATES}');
    Error('\P{Is_Blk=_/a/High_pu_SURROGATES}');
    Expect(1, 56319, '\p{Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(0, 56319, '\p{^Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(0, 56319, '\P{Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(1, 56319, '\P{^Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Blk:   -	high_pu_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Blk:   -	high_pu_SURROGATES}', "");
    Error('\p{Block= /a/high_Surrogates}');
    Error('\P{Block= /a/high_Surrogates}');
    Expect(1, 56191, '\p{Block: highsurrogates}', "");
    Expect(0, 56191, '\p{^Block: highsurrogates}', "");
    Expect(0, 56191, '\P{Block: highsurrogates}', "");
    Expect(1, 56191, '\P{^Block: highsurrogates}', "");
    Expect(0, 57344, '\p{Block: highsurrogates}', "");
    Expect(1, 57344, '\p{^Block: highsurrogates}', "");
    Expect(1, 57344, '\P{Block: highsurrogates}', "");
    Expect(0, 57344, '\P{^Block: highsurrogates}', "");
    Expect(1, 56191, '\p{Block=High_Surrogates}', "");
    Expect(0, 56191, '\p{^Block=High_Surrogates}', "");
    Expect(0, 56191, '\P{Block=High_Surrogates}', "");
    Expect(1, 56191, '\P{^Block=High_Surrogates}', "");
    Expect(0, 57344, '\p{Block=High_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=High_Surrogates}', "");
    Expect(1, 57344, '\P{Block=High_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=High_Surrogates}', "");
    Error('\p{Blk= HIGH_SURROGATES:=}');
    Error('\P{Blk= HIGH_SURROGATES:=}');
    Expect(1, 56191, '\p{Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Blk=-High_surrogates}', "");
    Expect(0, 56191, '\p{^Blk=-High_surrogates}', "");
    Expect(0, 56191, '\P{Blk=-High_surrogates}', "");
    Expect(1, 56191, '\P{^Blk=-High_surrogates}', "");
    Expect(0, 57344, '\p{Blk=-High_surrogates}', "");
    Expect(1, 57344, '\p{^Blk=-High_surrogates}', "");
    Expect(1, 57344, '\P{Blk=-High_surrogates}', "");
    Expect(0, 57344, '\P{^Blk=-High_surrogates}', "");
    Error('\p{Is_Block=/a/-	High_Surrogates}');
    Error('\P{Is_Block=/a/-	High_Surrogates}');
    Expect(1, 56191, '\p{Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Block= High_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Block= High_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Block= High_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Block= High_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block= High_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block= High_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block= High_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block= High_Surrogates}', "");
    Error('\p{Is_Blk: 	High_surrogates:=}');
    Error('\P{Is_Blk: 	High_surrogates:=}');
    Expect(1, 56191, '\p{Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Blk=-high_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=-high_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=-high_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=-high_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=-high_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=-high_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=-high_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=-high_Surrogates}', "");
    Error('\p{Block=/a/_HIRAGANA}');
    Error('\P{Block=/a/_HIRAGANA}');
    Expect(1, 12447, '\p{Block=hiragana}', "");
    Expect(0, 12447, '\p{^Block=hiragana}', "");
    Expect(0, 12447, '\P{Block=hiragana}', "");
    Expect(1, 12447, '\P{^Block=hiragana}', "");
    Expect(0, 12448, '\p{Block=hiragana}', "");
    Expect(1, 12448, '\p{^Block=hiragana}', "");
    Expect(1, 12448, '\P{Block=hiragana}', "");
    Expect(0, 12448, '\P{^Block=hiragana}', "");
    Expect(1, 12447, '\p{Block=__Hiragana}', "");
    Expect(0, 12447, '\p{^Block=__Hiragana}', "");
    Expect(0, 12447, '\P{Block=__Hiragana}', "");
    Expect(1, 12447, '\P{^Block=__Hiragana}', "");
    Expect(0, 12448, '\p{Block=__Hiragana}', "");
    Expect(1, 12448, '\p{^Block=__Hiragana}', "");
    Expect(1, 12448, '\P{Block=__Hiragana}', "");
    Expect(0, 12448, '\P{^Block=__Hiragana}', "");
    Error('\p{Blk= Hiragana:=}');
    Error('\P{Blk= Hiragana:=}');
    Expect(1, 12447, '\p{Blk:hiragana}', "");
    Expect(0, 12447, '\p{^Blk:hiragana}', "");
    Expect(0, 12447, '\P{Blk:hiragana}', "");
    Expect(1, 12447, '\P{^Blk:hiragana}', "");
    Expect(0, 12448, '\p{Blk:hiragana}', "");
    Expect(1, 12448, '\p{^Blk:hiragana}', "");
    Expect(1, 12448, '\P{Blk:hiragana}', "");
    Expect(0, 12448, '\P{^Blk:hiragana}', "");
    Expect(1, 12447, '\p{Blk=	HIRAGANA}', "");
    Expect(0, 12447, '\p{^Blk=	HIRAGANA}', "");
    Expect(0, 12447, '\P{Blk=	HIRAGANA}', "");
    Expect(1, 12447, '\P{^Blk=	HIRAGANA}', "");
    Expect(0, 12448, '\p{Blk=	HIRAGANA}', "");
    Expect(1, 12448, '\p{^Blk=	HIRAGANA}', "");
    Expect(1, 12448, '\P{Blk=	HIRAGANA}', "");
    Expect(0, 12448, '\P{^Blk=	HIRAGANA}', "");
    Error('\p{Is_Block=:=	-hiragana}');
    Error('\P{Is_Block=:=	-hiragana}');
    Expect(1, 12447, '\p{Is_Block=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=hiragana}', "");
    Expect(1, 12447, '\p{Is_Block=	-Hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=	-Hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=	-Hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=	-Hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=	-Hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=	-Hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=	-Hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=	-Hiragana}', "");
    Error('\p{Is_Blk=--HIRAGANA:=}');
    Error('\P{Is_Blk=--HIRAGANA:=}');
    Expect(1, 12447, '\p{Is_Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=hiragana}', "");
    Expect(1, 12447, '\p{Is_Blk= hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk= hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk= hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk= hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk= hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk= hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk= hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk= hiragana}', "");
    Error('\p{Block=_Ideographic_Description_characters/a/}');
    Error('\P{Block=_Ideographic_Description_characters/a/}');
    Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12287, '\p{^Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12287, '\P{Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12287, '\P{^Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12288, '\p{Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12288, '\p{^Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12288, '\P{Block=	 IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12288, '\P{^Block=	 IDEOGRAPHIC_Description_characters}', "");
    Error('\p{Blk:	:= 	IDC}');
    Error('\P{Blk:	:= 	IDC}');
    Expect(1, 12287, '\p{Blk=idc}', "");
    Expect(0, 12287, '\p{^Blk=idc}', "");
    Expect(0, 12287, '\P{Blk=idc}', "");
    Expect(1, 12287, '\P{^Blk=idc}', "");
    Expect(0, 12288, '\p{Blk=idc}', "");
    Expect(1, 12288, '\p{^Blk=idc}', "");
    Expect(1, 12288, '\P{Blk=idc}', "");
    Expect(0, 12288, '\P{^Blk=idc}', "");
    Expect(1, 12287, '\p{Blk=_idc}', "");
    Expect(0, 12287, '\p{^Blk=_idc}', "");
    Expect(0, 12287, '\P{Blk=_idc}', "");
    Expect(1, 12287, '\P{^Blk=_idc}', "");
    Expect(0, 12288, '\p{Blk=_idc}', "");
    Expect(1, 12288, '\p{^Blk=_idc}', "");
    Expect(1, 12288, '\P{Blk=_idc}', "");
    Expect(0, 12288, '\P{^Blk=_idc}', "");
    Error('\p{Is_Block=--Ideographic_description_Characters:=}');
    Error('\P{Is_Block=--Ideographic_description_Characters:=}');
    Expect(1, 12287, '\p{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Is_Block: ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(0, 12287, '\p{^Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(0, 12287, '\P{Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(1, 12287, '\P{^Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(0, 12288, '\p{Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(1, 12288, '\p{^Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(1, 12288, '\P{Is_Block=  ideographic_Description_CHARACTERS}', "");
    Expect(0, 12288, '\P{^Is_Block=  ideographic_Description_CHARACTERS}', "");
    Error('\p{Is_Blk=_IDC:=}');
    Error('\P{Is_Blk=_IDC:=}');
    Expect(1, 12287, '\p{Is_Blk=idc}', "");
    Expect(0, 12287, '\p{^Is_Blk=idc}', "");
    Expect(0, 12287, '\P{Is_Blk=idc}', "");
    Expect(1, 12287, '\P{^Is_Blk=idc}', "");
    Expect(0, 12288, '\p{Is_Blk=idc}', "");
    Expect(1, 12288, '\p{^Is_Blk=idc}', "");
    Expect(1, 12288, '\P{Is_Blk=idc}', "");
    Expect(0, 12288, '\P{^Is_Blk=idc}', "");
    Expect(1, 12287, '\p{Is_Blk=_IDC}', "");
    Expect(0, 12287, '\p{^Is_Blk=_IDC}', "");
    Expect(0, 12287, '\P{Is_Blk=_IDC}', "");
    Expect(1, 12287, '\P{^Is_Blk=_IDC}', "");
    Expect(0, 12288, '\p{Is_Blk=_IDC}', "");
    Expect(1, 12288, '\p{^Is_Blk=_IDC}', "");
    Expect(1, 12288, '\P{Is_Blk=_IDC}', "");
    Expect(0, 12288, '\P{^Is_Blk=_IDC}', "");
    Error('\p{Block=-/a/ideographic_Symbols_and_Punctuation}');
    Error('\P{Block=-/a/ideographic_Symbols_and_Punctuation}');
    Expect(1, 94207, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Block=  Ideographic_SYMBOLS_And_PUNCTUATION}', "");
    Error('\p{Blk= -ideographic_SYMBOLS:=}');
    Error('\P{Blk= -ideographic_SYMBOLS:=}');
    Expect(1, 94207, '\p{Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(0, 94207, '\p{^Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(0, 94207, '\P{Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(1, 94207, '\P{^Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(0, 94208, '\p{Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(1, 94208, '\p{^Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(1, 94208, '\P{Blk=	-IDEOGRAPHIC_symbols}', "");
    Expect(0, 94208, '\P{^Blk=	-IDEOGRAPHIC_symbols}', "");
    Error('\p{Is_Block=:=_ Ideographic_Symbols_AND_Punctuation}');
    Error('\P{Is_Block=:=_ Ideographic_Symbols_AND_Punctuation}');
    Expect(1, 94207, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(0, 94207, '\p{^Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(0, 94207, '\P{Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(1, 94207, '\P{^Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(0, 94208, '\p{Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(1, 94208, '\p{^Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(1, 94208, '\P{Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Expect(0, 94208, '\P{^Is_Block:	_IDEOGRAPHIC_Symbols_And_Punctuation}', "");
    Error('\p{Is_Blk=:=-Ideographic_Symbols}');
    Error('\P{Is_Blk=:=-Ideographic_Symbols}');
    Expect(1, 94207, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\p{^Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\P{Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94207, '\P{^Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\p{Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\p{^Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\P{Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\P{^Is_Blk= -IDEOGRAPHIC_Symbols}', "");
    Error('\p{Block=	-imperial_ARAMAIC/a/}');
    Error('\P{Block=	-imperial_ARAMAIC/a/}');
    Expect(1, 67679, '\p{Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Block=_	Imperial_aramaic}', "");
    Expect(0, 67679, '\p{^Block=_	Imperial_aramaic}', "");
    Expect(0, 67679, '\P{Block=_	Imperial_aramaic}', "");
    Expect(1, 67679, '\P{^Block=_	Imperial_aramaic}', "");
    Expect(0, 67680, '\p{Block=_	Imperial_aramaic}', "");
    Expect(1, 67680, '\p{^Block=_	Imperial_aramaic}', "");
    Expect(1, 67680, '\P{Block=_	Imperial_aramaic}', "");
    Expect(0, 67680, '\P{^Block=_	Imperial_aramaic}', "");
    Error('\p{Blk= /a/imperial_aramaic}');
    Error('\P{Blk= /a/imperial_aramaic}');
    Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Blk= IMPERIAL_aramaic}', "");
    Expect(0, 67679, '\p{^Blk= IMPERIAL_aramaic}', "");
    Expect(0, 67679, '\P{Blk= IMPERIAL_aramaic}', "");
    Expect(1, 67679, '\P{^Blk= IMPERIAL_aramaic}', "");
    Expect(0, 67680, '\p{Blk= IMPERIAL_aramaic}', "");
    Expect(1, 67680, '\p{^Blk= IMPERIAL_aramaic}', "");
    Expect(1, 67680, '\P{Blk= IMPERIAL_aramaic}', "");
    Expect(0, 67680, '\P{^Blk= IMPERIAL_aramaic}', "");
    Error('\p{Is_Block=-	Imperial_ARAMAIC/a/}');
    Error('\P{Is_Block=-	Imperial_ARAMAIC/a/}');
    Expect(1, 67679, '\p{Is_Block: imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Block: imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Block: imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Block: imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Block: imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Block: imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Block: imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Block: imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Block=_ Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=_ Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Block=_ Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=_ Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Block=_ Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=_ Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Block=_ Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=_ Imperial_Aramaic}', "");
    Error('\p{Is_Blk=-/a/Imperial_Aramaic}');
    Error('\P{Is_Blk=-/a/Imperial_Aramaic}');
    Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Is_Blk=_Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Is_Blk=_Imperial_ARAMAIC}', "");
    Error('\p{Block=-/a/common_Indic_number_forms}');
    Error('\P{Block=-/a/common_Indic_number_forms}');
    Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Block=__common_Indic_Number_Forms}', "");
    Expect(0, 43071, '\p{^Block=__common_Indic_Number_Forms}', "");
    Expect(0, 43071, '\P{Block=__common_Indic_Number_Forms}', "");
    Expect(1, 43071, '\P{^Block=__common_Indic_Number_Forms}', "");
    Expect(0, 43072, '\p{Block=__common_Indic_Number_Forms}', "");
    Expect(1, 43072, '\p{^Block=__common_Indic_Number_Forms}', "");
    Expect(1, 43072, '\P{Block=__common_Indic_Number_Forms}', "");
    Expect(0, 43072, '\P{^Block=__common_Indic_Number_Forms}', "");
    Error('\p{Blk=	:=Indic_Number_Forms}');
    Error('\P{Blk=	:=Indic_Number_Forms}');
    Expect(1, 43071, '\p{Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Blk=__INDIC_Number_Forms}', "");
    Expect(0, 43071, '\p{^Blk=__INDIC_Number_Forms}', "");
    Expect(0, 43071, '\P{Blk=__INDIC_Number_Forms}', "");
    Expect(1, 43071, '\P{^Blk=__INDIC_Number_Forms}', "");
    Expect(0, 43072, '\p{Blk=__INDIC_Number_Forms}', "");
    Expect(1, 43072, '\p{^Blk=__INDIC_Number_Forms}', "");
    Expect(1, 43072, '\P{Blk=__INDIC_Number_Forms}', "");
    Expect(0, 43072, '\P{^Blk=__INDIC_Number_Forms}', "");
    Error('\p{Is_Block=/a/_ Common_Indic_NUMBER_Forms}');
    Error('\P{Is_Block=/a/_ Common_Indic_NUMBER_Forms}');
    Expect(1, 43071, '\p{Is_Block: commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Block: commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Block: commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Block: commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Block: commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Block: commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Block: commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Block: commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(0, 43071, '\p{^Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(0, 43071, '\P{Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(1, 43071, '\P{^Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(0, 43072, '\p{Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(1, 43072, '\p{^Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(1, 43072, '\P{Is_Block=_Common_INDIC_Number_Forms}', "");
    Expect(0, 43072, '\P{^Is_Block=_Common_INDIC_Number_Forms}', "");
    Error('\p{Is_Blk=- indic_number_Forms:=}');
    Error('\P{Is_Blk=- indic_number_Forms:=}');
    Expect(1, 43071, '\p{Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Blk=_INDIC_number_forms}', "");
    Expect(0, 43071, '\p{^Is_Blk=_INDIC_number_forms}', "");
    Expect(0, 43071, '\P{Is_Blk=_INDIC_number_forms}', "");
    Expect(1, 43071, '\P{^Is_Blk=_INDIC_number_forms}', "");
    Expect(0, 43072, '\p{Is_Blk=_INDIC_number_forms}', "");
    Expect(1, 43072, '\p{^Is_Blk=_INDIC_number_forms}', "");
    Expect(1, 43072, '\P{Is_Blk=_INDIC_number_forms}', "");
    Expect(0, 43072, '\P{^Is_Blk=_INDIC_number_forms}', "");
    Error('\p{Block= /a/INSCRIPTIONAL_Pahlavi}');
    Error('\P{Block= /a/INSCRIPTIONAL_Pahlavi}');
    Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Block=-inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Block=-inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Block=-inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Block=-inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Block=-inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Block=-inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Block=-inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Block=-inscriptional_Pahlavi}', "");
    Error('\p{Blk=/a/	inscriptional_pahlavi}');
    Error('\P{Blk=/a/	inscriptional_pahlavi}');
    Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68479, '\P{Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68480, '\p{Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68480, '\P{Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Blk=  INSCRIPTIONAL_PAHLAVI}', "");
    Error('\p{Is_Block=:=-_INSCRIPTIONAL_PAHLAVI}');
    Error('\P{Is_Block=:=-_INSCRIPTIONAL_PAHLAVI}');
    Expect(1, 68479, '\p{Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Block=_inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=_inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=_inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=_inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=_inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=_inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=_inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=_inscriptional_Pahlavi}', "");
    Error('\p{Is_Blk=:=_-inscriptional_Pahlavi}');
    Error('\P{Is_Blk=:=_-inscriptional_Pahlavi}');
    Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk:  	Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk:  	Inscriptional_Pahlavi}', "");
    Error('\p{Block=/a/Inscriptional_parthian}');
    Error('\P{Block=/a/Inscriptional_parthian}');
    Expect(1, 68447, '\p{Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Block:	-Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\p{^Block:	-Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\P{Block:	-Inscriptional_PARTHIAN}', "");
    Expect(1, 68447, '\P{^Block:	-Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\p{Block:	-Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\p{^Block:	-Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\P{Block:	-Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\P{^Block:	-Inscriptional_PARTHIAN}', "");
    Error('\p{Blk=_:=inscriptional_parthian}');
    Error('\P{Blk=_:=inscriptional_parthian}');
    Expect(1, 68447, '\p{Blk: inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Blk: inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Blk: inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Blk: inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Blk: inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Blk: inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Blk: inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Blk: inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Blk=	_Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Blk=	_Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Blk=	_Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Blk=	_Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Blk=	_Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Blk=	_Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Blk=	_Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Blk=	_Inscriptional_Parthian}', "");
    Error('\p{Is_Block= :=Inscriptional_Parthian}');
    Error('\P{Is_Block= :=Inscriptional_Parthian}');
    Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Block:  -Inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Block:  -Inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Is_Block:  -Inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Block:  -Inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Is_Block:  -Inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Block:  -Inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Is_Block:  -Inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Block:  -Inscriptional_Parthian}', "");
    Error('\p{Is_Blk=:=-_INSCRIPTIONAL_PARTHIAN}');
    Error('\P{Is_Blk=:=-_INSCRIPTIONAL_PARTHIAN}');
    Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Blk=	-Inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=	-Inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Is_Blk=	-Inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=	-Inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Is_Blk=	-Inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=	-Inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Is_Blk=	-Inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=	-Inscriptional_parthian}', "");
    Error('\p{Block:	 :=IPA_Extensions}');
    Error('\P{Block:	 :=IPA_Extensions}');
    Expect(1, 687, '\p{Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Block=ipaextensions}', "");
    Expect(0, 687, '\P{Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Block=ipaextensions}', "");
    Expect(0, 688, '\p{Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Block=ipaextensions}', "");
    Expect(1, 688, '\P{Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Block=ipaextensions}', "");
    Expect(1, 687, '\p{Block=--ipa_Extensions}', "");
    Expect(0, 687, '\p{^Block=--ipa_Extensions}', "");
    Expect(0, 687, '\P{Block=--ipa_Extensions}', "");
    Expect(1, 687, '\P{^Block=--ipa_Extensions}', "");
    Expect(0, 688, '\p{Block=--ipa_Extensions}', "");
    Expect(1, 688, '\p{^Block=--ipa_Extensions}', "");
    Expect(1, 688, '\P{Block=--ipa_Extensions}', "");
    Expect(0, 688, '\P{^Block=--ipa_Extensions}', "");
    Error('\p{Blk=:=- IPA_EXT}');
    Error('\P{Blk=:=- IPA_EXT}');
    Expect(1, 687, '\p{Blk=ipaext}', "");
    Expect(0, 687, '\p{^Blk=ipaext}', "");
    Expect(0, 687, '\P{Blk=ipaext}', "");
    Expect(1, 687, '\P{^Blk=ipaext}', "");
    Expect(0, 688, '\p{Blk=ipaext}', "");
    Expect(1, 688, '\p{^Blk=ipaext}', "");
    Expect(1, 688, '\P{Blk=ipaext}', "");
    Expect(0, 688, '\P{^Blk=ipaext}', "");
    Expect(1, 687, '\p{Blk=_-IPA_Ext}', "");
    Expect(0, 687, '\p{^Blk=_-IPA_Ext}', "");
    Expect(0, 687, '\P{Blk=_-IPA_Ext}', "");
    Expect(1, 687, '\P{^Blk=_-IPA_Ext}', "");
    Expect(0, 688, '\p{Blk=_-IPA_Ext}', "");
    Expect(1, 688, '\p{^Blk=_-IPA_Ext}', "");
    Expect(1, 688, '\P{Blk=_-IPA_Ext}', "");
    Expect(0, 688, '\P{^Blk=_-IPA_Ext}', "");
    Error('\p{Is_Block=/a/ -IPA_extensions}');
    Error('\P{Is_Block=/a/ -IPA_extensions}');
    Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
    Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
    Expect(0, 688, '\p{Is_Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Is_Block=ipaextensions}', "");
    Expect(1, 688, '\P{Is_Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Is_Block=ipaextensions}', "");
    Expect(1, 687, '\p{Is_Block=-ipa_EXTENSIONS}', "");
    Expect(0, 687, '\p{^Is_Block=-ipa_EXTENSIONS}', "");
    Expect(0, 687, '\P{Is_Block=-ipa_EXTENSIONS}', "");
    Expect(1, 687, '\P{^Is_Block=-ipa_EXTENSIONS}', "");
    Expect(0, 688, '\p{Is_Block=-ipa_EXTENSIONS}', "");
    Expect(1, 688, '\p{^Is_Block=-ipa_EXTENSIONS}', "");
    Expect(1, 688, '\P{Is_Block=-ipa_EXTENSIONS}', "");
    Expect(0, 688, '\P{^Is_Block=-ipa_EXTENSIONS}', "");
    Error('\p{Is_Blk=:=	IPA_ext}');
    Error('\P{Is_Blk=:=	IPA_ext}');
    Expect(1, 687, '\p{Is_Blk:   ipaext}', "");
    Expect(0, 687, '\p{^Is_Blk:   ipaext}', "");
    Expect(0, 687, '\P{Is_Blk:   ipaext}', "");
    Expect(1, 687, '\P{^Is_Blk:   ipaext}', "");
    Expect(0, 688, '\p{Is_Blk:   ipaext}', "");
    Expect(1, 688, '\p{^Is_Blk:   ipaext}', "");
    Expect(1, 688, '\P{Is_Blk:   ipaext}', "");
    Expect(0, 688, '\P{^Is_Blk:   ipaext}', "");
    Expect(1, 687, '\p{Is_Blk=_	ipa_ext}', "");
    Expect(0, 687, '\p{^Is_Blk=_	ipa_ext}', "");
    Expect(0, 687, '\P{Is_Blk=_	ipa_ext}', "");
    Expect(1, 687, '\P{^Is_Blk=_	ipa_ext}', "");
    Expect(0, 688, '\p{Is_Blk=_	ipa_ext}', "");
    Expect(1, 688, '\p{^Is_Blk=_	ipa_ext}', "");
    Expect(1, 688, '\P{Is_Blk=_	ipa_ext}', "");
    Expect(0, 688, '\P{^Is_Blk=_	ipa_ext}', "");
    Error('\p{Block=	:=HANGUL_jamo}');
    Error('\P{Block=	:=HANGUL_jamo}');
    Expect(1, 4607, '\p{Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Block=__hangul_Jamo}', "");
    Expect(0, 4607, '\p{^Block=__hangul_Jamo}', "");
    Expect(0, 4607, '\P{Block=__hangul_Jamo}', "");
    Expect(1, 4607, '\P{^Block=__hangul_Jamo}', "");
    Expect(0, 4608, '\p{Block=__hangul_Jamo}', "");
    Expect(1, 4608, '\p{^Block=__hangul_Jamo}', "");
    Expect(1, 4608, '\P{Block=__hangul_Jamo}', "");
    Expect(0, 4608, '\P{^Block=__hangul_Jamo}', "");
    Error('\p{Blk=_ Jamo:=}');
    Error('\P{Blk=_ Jamo:=}');
    Expect(1, 4607, '\p{Blk=jamo}', "");
    Expect(0, 4607, '\p{^Blk=jamo}', "");
    Expect(0, 4607, '\P{Blk=jamo}', "");
    Expect(1, 4607, '\P{^Blk=jamo}', "");
    Expect(0, 4608, '\p{Blk=jamo}', "");
    Expect(1, 4608, '\p{^Blk=jamo}', "");
    Expect(1, 4608, '\P{Blk=jamo}', "");
    Expect(0, 4608, '\P{^Blk=jamo}', "");
    Expect(1, 4607, '\p{Blk=Jamo}', "");
    Expect(0, 4607, '\p{^Blk=Jamo}', "");
    Expect(0, 4607, '\P{Blk=Jamo}', "");
    Expect(1, 4607, '\P{^Blk=Jamo}', "");
    Expect(0, 4608, '\p{Blk=Jamo}', "");
    Expect(1, 4608, '\p{^Blk=Jamo}', "");
    Expect(1, 4608, '\P{Blk=Jamo}', "");
    Expect(0, 4608, '\P{^Blk=Jamo}', "");
    Error('\p{Is_Block=_Hangul_JAMO:=}');
    Error('\P{Is_Block=_Hangul_JAMO:=}');
    Expect(1, 4607, '\p{Is_Block: hanguljamo}', "");
    Expect(0, 4607, '\p{^Is_Block: hanguljamo}', "");
    Expect(0, 4607, '\P{Is_Block: hanguljamo}', "");
    Expect(1, 4607, '\P{^Is_Block: hanguljamo}', "");
    Expect(0, 4608, '\p{Is_Block: hanguljamo}', "");
    Expect(1, 4608, '\p{^Is_Block: hanguljamo}', "");
    Expect(1, 4608, '\P{Is_Block: hanguljamo}', "");
    Expect(0, 4608, '\P{^Is_Block: hanguljamo}', "");
    Expect(1, 4607, '\p{Is_Block=		HANGUL_JAMO}', "");
    Expect(0, 4607, '\p{^Is_Block=		HANGUL_JAMO}', "");
    Expect(0, 4607, '\P{Is_Block=		HANGUL_JAMO}', "");
    Expect(1, 4607, '\P{^Is_Block=		HANGUL_JAMO}', "");
    Expect(0, 4608, '\p{Is_Block=		HANGUL_JAMO}', "");
    Expect(1, 4608, '\p{^Is_Block=		HANGUL_JAMO}', "");
    Expect(1, 4608, '\P{Is_Block=		HANGUL_JAMO}', "");
    Expect(0, 4608, '\P{^Is_Block=		HANGUL_JAMO}', "");
    Error('\p{Is_Blk= -Jamo/a/}');
    Error('\P{Is_Blk= -Jamo/a/}');
    Expect(1, 4607, '\p{Is_Blk: jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk: jamo}', "");
    Expect(0, 4607, '\P{Is_Blk: jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk: jamo}', "");
    Expect(0, 4608, '\p{Is_Blk: jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk: jamo}', "");
    Expect(1, 4608, '\P{Is_Blk: jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk: jamo}', "");
    Expect(1, 4607, '\p{Is_Blk=_jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk=_jamo}', "");
    Expect(0, 4607, '\P{Is_Blk=_jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk=_jamo}', "");
    Expect(0, 4608, '\p{Is_Blk=_jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk=_jamo}', "");
    Expect(1, 4608, '\P{Is_Blk=_jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk=_jamo}', "");
    Error('\p{Block=/a/--HANGUL_JAMO_Extended_A}');
    Error('\P{Block=/a/--HANGUL_JAMO_Extended_A}');
    Expect(1, 43391, '\p{Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(0, 43391, '\p{^Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(0, 43391, '\P{Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(1, 43391, '\P{^Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(0, 43392, '\p{Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(1, 43392, '\p{^Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(1, 43392, '\P{Block=	Hangul_jamo_EXTENDED_A}', "");
    Expect(0, 43392, '\P{^Block=	Hangul_jamo_EXTENDED_A}', "");
    Error('\p{Blk= -Jamo_ext_A:=}');
    Error('\P{Blk= -Jamo_ext_A:=}');
    Expect(1, 43391, '\p{Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Blk=_jamo_ext_A}', "");
    Expect(0, 43391, '\p{^Blk=_jamo_ext_A}', "");
    Expect(0, 43391, '\P{Blk=_jamo_ext_A}', "");
    Expect(1, 43391, '\P{^Blk=_jamo_ext_A}', "");
    Expect(0, 43392, '\p{Blk=_jamo_ext_A}', "");
    Expect(1, 43392, '\p{^Blk=_jamo_ext_A}', "");
    Expect(1, 43392, '\P{Blk=_jamo_ext_A}', "");
    Expect(0, 43392, '\P{^Blk=_jamo_ext_A}', "");
    Error('\p{Is_Block=/a/_	hangul_jamo_EXTENDED_A}');
    Error('\P{Is_Block=/a/_	hangul_jamo_EXTENDED_A}');
    Expect(1, 43391, '\p{Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(0, 43391, '\p{^Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(0, 43391, '\P{Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(1, 43391, '\P{^Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(0, 43392, '\p{Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(1, 43392, '\p{^Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(1, 43392, '\P{Is_Block:    Hangul_Jamo_Extended_a}', "");
    Expect(0, 43392, '\P{^Is_Block:    Hangul_Jamo_Extended_a}', "");
    Error('\p{Is_Blk=_	Jamo_ext_A:=}');
    Error('\P{Is_Blk=_	Jamo_ext_A:=}');
    Expect(1, 43391, '\p{Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Is_Blk=_-Jamo_Ext_A}', "");
    Expect(0, 43391, '\p{^Is_Blk=_-Jamo_Ext_A}', "");
    Expect(0, 43391, '\P{Is_Blk=_-Jamo_Ext_A}', "");
    Expect(1, 43391, '\P{^Is_Blk=_-Jamo_Ext_A}', "");
    Expect(0, 43392, '\p{Is_Blk=_-Jamo_Ext_A}', "");
    Expect(1, 43392, '\p{^Is_Blk=_-Jamo_Ext_A}', "");
    Expect(1, 43392, '\P{Is_Blk=_-Jamo_Ext_A}', "");
    Expect(0, 43392, '\P{^Is_Blk=_-Jamo_Ext_A}', "");
    Error('\p{Block:-_hangul_Jamo_extended_b/a/}');
    Error('\P{Block:-_hangul_Jamo_extended_b/a/}');
    Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\p{^Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\P{Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(1, 55295, '\P{^Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\p{Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\p{^Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\P{Block=-_Hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\P{^Block=-_Hangul_Jamo_Extended_B}', "");
    Error('\p{Blk=_ Jamo_EXT_B/a/}');
    Error('\P{Blk=_ Jamo_EXT_B/a/}');
    Expect(1, 55295, '\p{Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Blk=	_JAMO_Ext_b}', "");
    Expect(0, 55295, '\p{^Blk=	_JAMO_Ext_b}', "");
    Expect(0, 55295, '\P{Blk=	_JAMO_Ext_b}', "");
    Expect(1, 55295, '\P{^Blk=	_JAMO_Ext_b}', "");
    Expect(0, 57344, '\p{Blk=	_JAMO_Ext_b}', "");
    Expect(1, 57344, '\p{^Blk=	_JAMO_Ext_b}', "");
    Expect(1, 57344, '\P{Blk=	_JAMO_Ext_b}', "");
    Expect(0, 57344, '\P{^Blk=	_JAMO_Ext_b}', "");
    Error('\p{Is_Block:    :=Hangul_Jamo_Extended_B}');
    Error('\P{Is_Block:    :=Hangul_Jamo_Extended_B}');
    Expect(1, 55295, '\p{Is_Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Is_Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Is_Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Is_Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Is_Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Is_Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Is_Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Is_Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(0, 55295, '\p{^Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(0, 55295, '\P{Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(1, 55295, '\P{^Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(0, 57344, '\p{Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(1, 57344, '\p{^Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(1, 57344, '\P{Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Expect(0, 57344, '\P{^Is_Block=_ HANGUL_Jamo_extended_B}', "");
    Error('\p{Is_Blk: :=jamo_Ext_B}');
    Error('\P{Is_Blk: :=jamo_Ext_B}');
    Expect(1, 55295, '\p{Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Is_Blk=-jamo_ext_B}', "");
    Expect(0, 55295, '\p{^Is_Blk=-jamo_ext_B}', "");
    Expect(0, 55295, '\P{Is_Blk=-jamo_ext_B}', "");
    Expect(1, 55295, '\P{^Is_Blk=-jamo_ext_B}', "");
    Expect(0, 57344, '\p{Is_Blk=-jamo_ext_B}', "");
    Expect(1, 57344, '\p{^Is_Blk=-jamo_ext_B}', "");
    Expect(1, 57344, '\P{Is_Blk=-jamo_ext_B}', "");
    Expect(0, 57344, '\P{^Is_Blk=-jamo_ext_B}', "");
    Error('\p{Block=_ Javanese/a/}');
    Error('\P{Block=_ Javanese/a/}');
    Expect(1, 43487, '\p{Block:javanese}', "");
    Expect(0, 43487, '\p{^Block:javanese}', "");
    Expect(0, 43487, '\P{Block:javanese}', "");
    Expect(1, 43487, '\P{^Block:javanese}', "");
    Expect(0, 43488, '\p{Block:javanese}', "");
    Expect(1, 43488, '\p{^Block:javanese}', "");
    Expect(1, 43488, '\P{Block:javanese}', "");
    Expect(0, 43488, '\P{^Block:javanese}', "");
    Expect(1, 43487, '\p{Block=  javanese}', "");
    Expect(0, 43487, '\p{^Block=  javanese}', "");
    Expect(0, 43487, '\P{Block=  javanese}', "");
    Expect(1, 43487, '\P{^Block=  javanese}', "");
    Expect(0, 43488, '\p{Block=  javanese}', "");
    Expect(1, 43488, '\p{^Block=  javanese}', "");
    Expect(1, 43488, '\P{Block=  javanese}', "");
    Expect(0, 43488, '\P{^Block=  javanese}', "");
    Error('\p{Blk=_:=JAVANESE}');
    Error('\P{Blk=_:=JAVANESE}');
    Expect(1, 43487, '\p{Blk=javanese}', "");
    Expect(0, 43487, '\p{^Blk=javanese}', "");
    Expect(0, 43487, '\P{Blk=javanese}', "");
    Expect(1, 43487, '\P{^Blk=javanese}', "");
    Expect(0, 43488, '\p{Blk=javanese}', "");
    Expect(1, 43488, '\p{^Blk=javanese}', "");
    Expect(1, 43488, '\P{Blk=javanese}', "");
    Expect(0, 43488, '\P{^Blk=javanese}', "");
    Expect(1, 43487, '\p{Blk=Javanese}', "");
    Expect(0, 43487, '\p{^Blk=Javanese}', "");
    Expect(0, 43487, '\P{Blk=Javanese}', "");
    Expect(1, 43487, '\P{^Blk=Javanese}', "");
    Expect(0, 43488, '\p{Blk=Javanese}', "");
    Expect(1, 43488, '\p{^Blk=Javanese}', "");
    Expect(1, 43488, '\P{Blk=Javanese}', "");
    Expect(0, 43488, '\P{^Blk=Javanese}', "");
    Error('\p{Is_Block=:= _JAVANESE}');
    Error('\P{Is_Block=:= _JAVANESE}');
    Expect(1, 43487, '\p{Is_Block=javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=javanese}', "");
    Expect(0, 43487, '\P{Is_Block=javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=javanese}', "");
    Expect(0, 43488, '\p{Is_Block=javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=javanese}', "");
    Expect(1, 43488, '\P{Is_Block=javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=javanese}', "");
    Expect(1, 43487, '\p{Is_Block= javanese}', "");
    Expect(0, 43487, '\p{^Is_Block= javanese}', "");
    Expect(0, 43487, '\P{Is_Block= javanese}', "");
    Expect(1, 43487, '\P{^Is_Block= javanese}', "");
    Expect(0, 43488, '\p{Is_Block= javanese}', "");
    Expect(1, 43488, '\p{^Is_Block= javanese}', "");
    Expect(1, 43488, '\P{Is_Block= javanese}', "");
    Expect(0, 43488, '\P{^Is_Block= javanese}', "");
    Error('\p{Is_Blk=:=__JAVANESE}');
    Error('\P{Is_Blk=:=__JAVANESE}');
    Expect(1, 43487, '\p{Is_Blk=javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=javanese}', "");
    Expect(1, 43487, '\p{Is_Blk= Javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk= Javanese}', "");
    Expect(0, 43487, '\P{Is_Blk= Javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk= Javanese}', "");
    Expect(0, 43488, '\p{Is_Blk= Javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk= Javanese}', "");
    Expect(1, 43488, '\P{Is_Blk= Javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk= Javanese}', "");
    Error('\p{Block=/a/  Kaithi}');
    Error('\P{Block=/a/  Kaithi}');
    Expect(1, 69839, '\p{Block=kaithi}', "");
    Expect(0, 69839, '\p{^Block=kaithi}', "");
    Expect(0, 69839, '\P{Block=kaithi}', "");
    Expect(1, 69839, '\P{^Block=kaithi}', "");
    Expect(0, 69840, '\p{Block=kaithi}', "");
    Expect(1, 69840, '\p{^Block=kaithi}', "");
    Expect(1, 69840, '\P{Block=kaithi}', "");
    Expect(0, 69840, '\P{^Block=kaithi}', "");
    Expect(1, 69839, '\p{Block=		Kaithi}', "");
    Expect(0, 69839, '\p{^Block=		Kaithi}', "");
    Expect(0, 69839, '\P{Block=		Kaithi}', "");
    Expect(1, 69839, '\P{^Block=		Kaithi}', "");
    Expect(0, 69840, '\p{Block=		Kaithi}', "");
    Expect(1, 69840, '\p{^Block=		Kaithi}', "");
    Expect(1, 69840, '\P{Block=		Kaithi}', "");
    Expect(0, 69840, '\P{^Block=		Kaithi}', "");
    Error('\p{Blk= -KAITHI:=}');
    Error('\P{Blk= -KAITHI:=}');
    Expect(1, 69839, '\p{Blk:kaithi}', "");
    Expect(0, 69839, '\p{^Blk:kaithi}', "");
    Expect(0, 69839, '\P{Blk:kaithi}', "");
    Expect(1, 69839, '\P{^Blk:kaithi}', "");
    Expect(0, 69840, '\p{Blk:kaithi}', "");
    Expect(1, 69840, '\p{^Blk:kaithi}', "");
    Expect(1, 69840, '\P{Blk:kaithi}', "");
    Expect(0, 69840, '\P{^Blk:kaithi}', "");
    Expect(1, 69839, '\p{Blk= 	kaithi}', "");
    Expect(0, 69839, '\p{^Blk= 	kaithi}', "");
    Expect(0, 69839, '\P{Blk= 	kaithi}', "");
    Expect(1, 69839, '\P{^Blk= 	kaithi}', "");
    Expect(0, 69840, '\p{Blk= 	kaithi}', "");
    Expect(1, 69840, '\p{^Blk= 	kaithi}', "");
    Expect(1, 69840, '\P{Blk= 	kaithi}', "");
    Expect(0, 69840, '\P{^Blk= 	kaithi}', "");
    Error('\p{Is_Block=__KAITHI:=}');
    Error('\P{Is_Block=__KAITHI:=}');
    Expect(1, 69839, '\p{Is_Block=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=kaithi}', "");
    Expect(1, 69839, '\p{Is_Block= -KAITHI}', "");
    Expect(0, 69839, '\p{^Is_Block= -KAITHI}', "");
    Expect(0, 69839, '\P{Is_Block= -KAITHI}', "");
    Expect(1, 69839, '\P{^Is_Block= -KAITHI}', "");
    Expect(0, 69840, '\p{Is_Block= -KAITHI}', "");
    Expect(1, 69840, '\p{^Is_Block= -KAITHI}', "");
    Expect(1, 69840, '\P{Is_Block= -KAITHI}', "");
    Expect(0, 69840, '\P{^Is_Block= -KAITHI}', "");
    Error('\p{Is_Blk=:=-Kaithi}');
    Error('\P{Is_Blk=:=-Kaithi}');
    Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=kaithi}', "");
    Expect(1, 69839, '\p{Is_Blk=		Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=		Kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=		Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=		Kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=		Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=		Kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=		Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=		Kaithi}', "");
    Error('\p{Block=:= 	Kana_extended_A}');
    Error('\P{Block=:= 	Kana_extended_A}');
    Expect(1, 110895, '\p{Block:   kanaextendeda}', "");
    Expect(0, 110895, '\p{^Block:   kanaextendeda}', "");
    Expect(0, 110895, '\P{Block:   kanaextendeda}', "");
    Expect(1, 110895, '\P{^Block:   kanaextendeda}', "");
    Expect(0, 110896, '\p{Block:   kanaextendeda}', "");
    Expect(1, 110896, '\p{^Block:   kanaextendeda}', "");
    Expect(1, 110896, '\P{Block:   kanaextendeda}', "");
    Expect(0, 110896, '\P{^Block:   kanaextendeda}', "");
    Expect(1, 110895, '\p{Block=	 Kana_EXTENDED_a}', "");
    Expect(0, 110895, '\p{^Block=	 Kana_EXTENDED_a}', "");
    Expect(0, 110895, '\P{Block=	 Kana_EXTENDED_a}', "");
    Expect(1, 110895, '\P{^Block=	 Kana_EXTENDED_a}', "");
    Expect(0, 110896, '\p{Block=	 Kana_EXTENDED_a}', "");
    Expect(1, 110896, '\p{^Block=	 Kana_EXTENDED_a}', "");
    Expect(1, 110896, '\P{Block=	 Kana_EXTENDED_a}', "");
    Expect(0, 110896, '\P{^Block=	 Kana_EXTENDED_a}', "");
    Error('\p{Blk=-	Kana_Ext_a:=}');
    Error('\P{Blk=-	Kana_Ext_a:=}');
    Expect(1, 110895, '\p{Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Blk=_	Kana_Ext_a}', "");
    Expect(0, 110895, '\p{^Blk=_	Kana_Ext_a}', "");
    Expect(0, 110895, '\P{Blk=_	Kana_Ext_a}', "");
    Expect(1, 110895, '\P{^Blk=_	Kana_Ext_a}', "");
    Expect(0, 110896, '\p{Blk=_	Kana_Ext_a}', "");
    Expect(1, 110896, '\p{^Blk=_	Kana_Ext_a}', "");
    Expect(1, 110896, '\P{Blk=_	Kana_Ext_a}', "");
    Expect(0, 110896, '\P{^Blk=_	Kana_Ext_a}', "");
    Error('\p{Is_Block=/a/_	Kana_EXTENDED_a}');
    Error('\P{Is_Block=/a/_	Kana_EXTENDED_a}');
    Expect(1, 110895, '\p{Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\p{^Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\P{Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(1, 110895, '\P{^Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\p{Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\p{^Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\P{Is_Block:   -Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\P{^Is_Block:   -Kana_EXTENDED_A}', "");
    Error('\p{Is_Blk: _/a/KANA_ext_A}');
    Error('\P{Is_Blk: _/a/KANA_ext_A}');
    Expect(1, 110895, '\p{Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Is_Blk= _Kana_Ext_A}', "");
    Expect(0, 110895, '\p{^Is_Blk= _Kana_Ext_A}', "");
    Expect(0, 110895, '\P{Is_Blk= _Kana_Ext_A}', "");
    Expect(1, 110895, '\P{^Is_Blk= _Kana_Ext_A}', "");
    Expect(0, 110896, '\p{Is_Blk= _Kana_Ext_A}', "");
    Expect(1, 110896, '\p{^Is_Blk= _Kana_Ext_A}', "");
    Expect(1, 110896, '\P{Is_Blk= _Kana_Ext_A}', "");
    Expect(0, 110896, '\P{^Is_Blk= _Kana_Ext_A}', "");
    Error('\p{Block=_/a/kana_Supplement}');
    Error('\P{Block=_/a/kana_Supplement}');
    Expect(1, 110847, '\p{Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Block=-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Block=-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Block=-kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Block=-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Block=-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Block=-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Block=-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Block=-kana_SUPPLEMENT}', "");
    Error('\p{Blk=/a/  KANA_sup}');
    Error('\P{Blk=/a/  KANA_sup}');
    Expect(1, 110847, '\p{Blk:   kanasup}', "");
    Expect(0, 110847, '\p{^Blk:   kanasup}', "");
    Expect(0, 110847, '\P{Blk:   kanasup}', "");
    Expect(1, 110847, '\P{^Blk:   kanasup}', "");
    Expect(0, 110848, '\p{Blk:   kanasup}', "");
    Expect(1, 110848, '\p{^Blk:   kanasup}', "");
    Expect(1, 110848, '\P{Blk:   kanasup}', "");
    Expect(0, 110848, '\P{^Blk:   kanasup}', "");
    Expect(1, 110847, '\p{Blk=-Kana_Sup}', "");
    Expect(0, 110847, '\p{^Blk=-Kana_Sup}', "");
    Expect(0, 110847, '\P{Blk=-Kana_Sup}', "");
    Expect(1, 110847, '\P{^Blk=-Kana_Sup}', "");
    Expect(0, 110848, '\p{Blk=-Kana_Sup}', "");
    Expect(1, 110848, '\p{^Blk=-Kana_Sup}', "");
    Expect(1, 110848, '\P{Blk=-Kana_Sup}', "");
    Expect(0, 110848, '\P{^Blk=-Kana_Sup}', "");
    Error('\p{Is_Block=-kana_SUPPLEMENT:=}');
    Error('\P{Is_Block=-kana_SUPPLEMENT:=}');
    Expect(1, 110847, '\p{Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Is_Block= 	kana_Supplement}', "");
    Expect(0, 110847, '\p{^Is_Block= 	kana_Supplement}', "");
    Expect(0, 110847, '\P{Is_Block= 	kana_Supplement}', "");
    Expect(1, 110847, '\P{^Is_Block= 	kana_Supplement}', "");
    Expect(0, 110848, '\p{Is_Block= 	kana_Supplement}', "");
    Expect(1, 110848, '\p{^Is_Block= 	kana_Supplement}', "");
    Expect(1, 110848, '\P{Is_Block= 	kana_Supplement}', "");
    Expect(0, 110848, '\P{^Is_Block= 	kana_Supplement}', "");
    Error('\p{Is_Blk=:=-KANA_Sup}');
    Error('\P{Is_Blk=:=-KANA_Sup}');
    Expect(1, 110847, '\p{Is_Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Is_Blk=kanasup}', "");
    Expect(0, 110847, '\P{Is_Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Is_Blk=kanasup}', "");
    Expect(0, 110848, '\p{Is_Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Is_Blk=kanasup}', "");
    Expect(1, 110848, '\P{Is_Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Is_Blk=kanasup}', "");
    Expect(1, 110847, '\p{Is_Blk= _Kana_Sup}', "");
    Expect(0, 110847, '\p{^Is_Blk= _Kana_Sup}', "");
    Expect(0, 110847, '\P{Is_Blk= _Kana_Sup}', "");
    Expect(1, 110847, '\P{^Is_Blk= _Kana_Sup}', "");
    Expect(0, 110848, '\p{Is_Blk= _Kana_Sup}', "");
    Expect(1, 110848, '\p{^Is_Blk= _Kana_Sup}', "");
    Expect(1, 110848, '\P{Is_Blk= _Kana_Sup}', "");
    Expect(0, 110848, '\P{^Is_Blk= _Kana_Sup}', "");
    Error('\p{Block:  	kanbun:=}');
    Error('\P{Block:  	kanbun:=}');
    Expect(1, 12703, '\p{Block=kanbun}', "");
    Expect(0, 12703, '\p{^Block=kanbun}', "");
    Expect(0, 12703, '\P{Block=kanbun}', "");
    Expect(1, 12703, '\P{^Block=kanbun}', "");
    Expect(0, 12704, '\p{Block=kanbun}', "");
    Expect(1, 12704, '\p{^Block=kanbun}', "");
    Expect(1, 12704, '\P{Block=kanbun}', "");
    Expect(0, 12704, '\P{^Block=kanbun}', "");
    Expect(1, 12703, '\p{Block=-_kanbun}', "");
    Expect(0, 12703, '\p{^Block=-_kanbun}', "");
    Expect(0, 12703, '\P{Block=-_kanbun}', "");
    Expect(1, 12703, '\P{^Block=-_kanbun}', "");
    Expect(0, 12704, '\p{Block=-_kanbun}', "");
    Expect(1, 12704, '\p{^Block=-_kanbun}', "");
    Expect(1, 12704, '\P{Block=-_kanbun}', "");
    Expect(0, 12704, '\P{^Block=-_kanbun}', "");
    Error('\p{Blk=/a/ _Kanbun}');
    Error('\P{Blk=/a/ _Kanbun}');
    Expect(1, 12703, '\p{Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Blk=kanbun}', "");
    Expect(0, 12703, '\P{Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Blk=kanbun}', "");
    Expect(0, 12704, '\p{Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Blk=kanbun}', "");
    Expect(1, 12704, '\P{Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Blk=kanbun}', "");
    Expect(1, 12703, '\p{Blk:-Kanbun}', "");
    Expect(0, 12703, '\p{^Blk:-Kanbun}', "");
    Expect(0, 12703, '\P{Blk:-Kanbun}', "");
    Expect(1, 12703, '\P{^Blk:-Kanbun}', "");
    Expect(0, 12704, '\p{Blk:-Kanbun}', "");
    Expect(1, 12704, '\p{^Blk:-Kanbun}', "");
    Expect(1, 12704, '\P{Blk:-Kanbun}', "");
    Expect(0, 12704, '\P{^Blk:-Kanbun}', "");
    Error('\p{Is_Block= /a/kanbun}');
    Error('\P{Is_Block= /a/kanbun}');
    Expect(1, 12703, '\p{Is_Block=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=kanbun}', "");
    Expect(1, 12703, '\p{Is_Block=_-Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=_-Kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=_-Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=_-Kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=_-Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=_-Kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=_-Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=_-Kanbun}', "");
    Error('\p{Is_Blk=_:=KANBUN}');
    Error('\P{Is_Blk=_:=KANBUN}');
    Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=kanbun}', "");
    Expect(1, 12703, '\p{Is_Blk=	KANBUN}', "");
    Expect(0, 12703, '\p{^Is_Blk=	KANBUN}', "");
    Expect(0, 12703, '\P{Is_Blk=	KANBUN}', "");
    Expect(1, 12703, '\P{^Is_Blk=	KANBUN}', "");
    Expect(0, 12704, '\p{Is_Blk=	KANBUN}', "");
    Expect(1, 12704, '\p{^Is_Blk=	KANBUN}', "");
    Expect(1, 12704, '\P{Is_Blk=	KANBUN}', "");
    Expect(0, 12704, '\P{^Is_Blk=	KANBUN}', "");
    Error('\p{Block= :=kangxi_Radicals}');
    Error('\P{Block= :=kangxi_Radicals}');
    Expect(1, 12255, '\p{Block:kangxiradicals}', "");
    Expect(0, 12255, '\p{^Block:kangxiradicals}', "");
    Expect(0, 12255, '\P{Block:kangxiradicals}', "");
    Expect(1, 12255, '\P{^Block:kangxiradicals}', "");
    Expect(0, 12256, '\p{Block:kangxiradicals}', "");
    Expect(1, 12256, '\p{^Block:kangxiradicals}', "");
    Expect(1, 12256, '\P{Block:kangxiradicals}', "");
    Expect(0, 12256, '\P{^Block:kangxiradicals}', "");
    Expect(1, 12255, '\p{Block:	-Kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Block:	-Kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Block:	-Kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Block:	-Kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Block:	-Kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Block:	-Kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Block:	-Kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Block:	-Kangxi_Radicals}', "");
    Error('\p{Blk=:= -kangxi}');
    Error('\P{Blk=:= -kangxi}');
    Expect(1, 12255, '\p{Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Blk=kangxi}', "");
    Expect(0, 12255, '\P{Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Blk=kangxi}', "");
    Expect(0, 12256, '\p{Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Blk=kangxi}', "");
    Expect(1, 12256, '\P{Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Blk=kangxi}', "");
    Expect(1, 12255, '\p{Blk= 	Kangxi}', "");
    Expect(0, 12255, '\p{^Blk= 	Kangxi}', "");
    Expect(0, 12255, '\P{Blk= 	Kangxi}', "");
    Expect(1, 12255, '\P{^Blk= 	Kangxi}', "");
    Expect(0, 12256, '\p{Blk= 	Kangxi}', "");
    Expect(1, 12256, '\p{^Blk= 	Kangxi}', "");
    Expect(1, 12256, '\P{Blk= 	Kangxi}', "");
    Expect(0, 12256, '\P{^Blk= 	Kangxi}', "");
    Error('\p{Is_Block:   :=	KANGXI_Radicals}');
    Error('\P{Is_Block:   :=	KANGXI_Radicals}');
    Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Is_Block=- KANGXI_radicals}', "");
    Expect(0, 12255, '\p{^Is_Block=- KANGXI_radicals}', "");
    Expect(0, 12255, '\P{Is_Block=- KANGXI_radicals}', "");
    Expect(1, 12255, '\P{^Is_Block=- KANGXI_radicals}', "");
    Expect(0, 12256, '\p{Is_Block=- KANGXI_radicals}', "");
    Expect(1, 12256, '\p{^Is_Block=- KANGXI_radicals}', "");
    Expect(1, 12256, '\P{Is_Block=- KANGXI_radicals}', "");
    Expect(0, 12256, '\P{^Is_Block=- KANGXI_radicals}', "");
    Error('\p{Is_Blk=:=-	kangxi}');
    Error('\P{Is_Blk=:=-	kangxi}');
    Expect(1, 12255, '\p{Is_Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=kangxi}', "");
    Expect(1, 12255, '\p{Is_Blk= _Kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk= _Kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk= _Kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk= _Kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk= _Kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk= _Kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk= _Kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk= _Kangxi}', "");
    Error('\p{Block: Kannada:=}');
    Error('\P{Block: Kannada:=}');
    Expect(1, 3327, '\p{Block=kannada}', "");
    Expect(0, 3327, '\p{^Block=kannada}', "");
    Expect(0, 3327, '\P{Block=kannada}', "");
    Expect(1, 3327, '\P{^Block=kannada}', "");
    Expect(0, 3328, '\p{Block=kannada}', "");
    Expect(1, 3328, '\p{^Block=kannada}', "");
    Expect(1, 3328, '\P{Block=kannada}', "");
    Expect(0, 3328, '\P{^Block=kannada}', "");
    Expect(1, 3327, '\p{Block:-KANNADA}', "");
    Expect(0, 3327, '\p{^Block:-KANNADA}', "");
    Expect(0, 3327, '\P{Block:-KANNADA}', "");
    Expect(1, 3327, '\P{^Block:-KANNADA}', "");
    Expect(0, 3328, '\p{Block:-KANNADA}', "");
    Expect(1, 3328, '\p{^Block:-KANNADA}', "");
    Expect(1, 3328, '\P{Block:-KANNADA}', "");
    Expect(0, 3328, '\P{^Block:-KANNADA}', "");
    Error('\p{Blk= :=Kannada}');
    Error('\P{Blk= :=Kannada}');
    Expect(1, 3327, '\p{Blk=kannada}', "");
    Expect(0, 3327, '\p{^Blk=kannada}', "");
    Expect(0, 3327, '\P{Blk=kannada}', "");
    Expect(1, 3327, '\P{^Blk=kannada}', "");
    Expect(0, 3328, '\p{Blk=kannada}', "");
    Expect(1, 3328, '\p{^Blk=kannada}', "");
    Expect(1, 3328, '\P{Blk=kannada}', "");
    Expect(0, 3328, '\P{^Blk=kannada}', "");
    Expect(1, 3327, '\p{Blk= _Kannada}', "");
    Expect(0, 3327, '\p{^Blk= _Kannada}', "");
    Expect(0, 3327, '\P{Blk= _Kannada}', "");
    Expect(1, 3327, '\P{^Blk= _Kannada}', "");
    Expect(0, 3328, '\p{Blk= _Kannada}', "");
    Expect(1, 3328, '\p{^Blk= _Kannada}', "");
    Expect(1, 3328, '\P{Blk= _Kannada}', "");
    Expect(0, 3328, '\P{^Blk= _Kannada}', "");
    Error('\p{Is_Block=_kannada/a/}');
    Error('\P{Is_Block=_kannada/a/}');
    Expect(1, 3327, '\p{Is_Block=kannada}', "");
    Expect(0, 3327, '\p{^Is_Block=kannada}', "");
    Expect(0, 3327, '\P{Is_Block=kannada}', "");
    Expect(1, 3327, '\P{^Is_Block=kannada}', "");
    Expect(0, 3328, '\p{Is_Block=kannada}', "");
    Expect(1, 3328, '\p{^Is_Block=kannada}', "");
    Expect(1, 3328, '\P{Is_Block=kannada}', "");
    Expect(0, 3328, '\P{^Is_Block=kannada}', "");
    Expect(1, 3327, '\p{Is_Block=-KANNADA}', "");
    Expect(0, 3327, '\p{^Is_Block=-KANNADA}', "");
    Expect(0, 3327, '\P{Is_Block=-KANNADA}', "");
    Expect(1, 3327, '\P{^Is_Block=-KANNADA}', "");
    Expect(0, 3328, '\p{Is_Block=-KANNADA}', "");
    Expect(1, 3328, '\p{^Is_Block=-KANNADA}', "");
    Expect(1, 3328, '\P{Is_Block=-KANNADA}', "");
    Expect(0, 3328, '\P{^Is_Block=-KANNADA}', "");
    Error('\p{Is_Blk=/a/-KANNADA}');
    Error('\P{Is_Blk=/a/-KANNADA}');
    Expect(1, 3327, '\p{Is_Blk=kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=kannada}', "");
    Expect(1, 3327, '\p{Is_Blk=		Kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=		Kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=		Kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=		Kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=		Kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=		Kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=		Kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=		Kannada}', "");
    Error('\p{Block:	 /a/Katakana}');
    Error('\P{Block:	 /a/Katakana}');
    Expect(1, 12543, '\p{Block:	katakana}', "");
    Expect(0, 12543, '\p{^Block:	katakana}', "");
    Expect(0, 12543, '\P{Block:	katakana}', "");
    Expect(1, 12543, '\P{^Block:	katakana}', "");
    Expect(0, 12544, '\p{Block:	katakana}', "");
    Expect(1, 12544, '\p{^Block:	katakana}', "");
    Expect(1, 12544, '\P{Block:	katakana}', "");
    Expect(0, 12544, '\P{^Block:	katakana}', "");
    Expect(1, 12543, '\p{Block=		KATAKANA}', "");
    Expect(0, 12543, '\p{^Block=		KATAKANA}', "");
    Expect(0, 12543, '\P{Block=		KATAKANA}', "");
    Expect(1, 12543, '\P{^Block=		KATAKANA}', "");
    Expect(0, 12544, '\p{Block=		KATAKANA}', "");
    Expect(1, 12544, '\p{^Block=		KATAKANA}', "");
    Expect(1, 12544, '\P{Block=		KATAKANA}', "");
    Expect(0, 12544, '\P{^Block=		KATAKANA}', "");
    Error('\p{Blk=:=KATAKANA}');
    Error('\P{Blk=:=KATAKANA}');
    Expect(1, 12543, '\p{Blk=katakana}', "");
    Expect(0, 12543, '\p{^Blk=katakana}', "");
    Expect(0, 12543, '\P{Blk=katakana}', "");
    Expect(1, 12543, '\P{^Blk=katakana}', "");
    Expect(0, 12544, '\p{Blk=katakana}', "");
    Expect(1, 12544, '\p{^Blk=katakana}', "");
    Expect(1, 12544, '\P{Blk=katakana}', "");
    Expect(0, 12544, '\P{^Blk=katakana}', "");
    Expect(1, 12543, '\p{Blk=		KATAKANA}', "");
    Expect(0, 12543, '\p{^Blk=		KATAKANA}', "");
    Expect(0, 12543, '\P{Blk=		KATAKANA}', "");
    Expect(1, 12543, '\P{^Blk=		KATAKANA}', "");
    Expect(0, 12544, '\p{Blk=		KATAKANA}', "");
    Expect(1, 12544, '\p{^Blk=		KATAKANA}', "");
    Expect(1, 12544, '\P{Blk=		KATAKANA}', "");
    Expect(0, 12544, '\P{^Blk=		KATAKANA}', "");
    Error('\p{Is_Block=--KATAKANA:=}');
    Error('\P{Is_Block=--KATAKANA:=}');
    Expect(1, 12543, '\p{Is_Block=katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=katakana}', "");
    Expect(0, 12543, '\P{Is_Block=katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=katakana}', "");
    Expect(0, 12544, '\p{Is_Block=katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=katakana}', "");
    Expect(1, 12544, '\P{Is_Block=katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=katakana}', "");
    Expect(1, 12543, '\p{Is_Block:   	katakana}', "");
    Expect(0, 12543, '\p{^Is_Block:   	katakana}', "");
    Expect(0, 12543, '\P{Is_Block:   	katakana}', "");
    Expect(1, 12543, '\P{^Is_Block:   	katakana}', "");
    Expect(0, 12544, '\p{Is_Block:   	katakana}', "");
    Expect(1, 12544, '\p{^Is_Block:   	katakana}', "");
    Expect(1, 12544, '\P{Is_Block:   	katakana}', "");
    Expect(0, 12544, '\P{^Is_Block:   	katakana}', "");
    Error('\p{Is_Blk:-	KATAKANA:=}');
    Error('\P{Is_Blk:-	KATAKANA:=}');
    Expect(1, 12543, '\p{Is_Blk=katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=katakana}', "");
    Expect(1, 12543, '\p{Is_Blk=		Katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=		Katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=		Katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=		Katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=		Katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=		Katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=		Katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=		Katakana}', "");
    Error('\p{Block=KATAKANA_PHONETIC_EXTENSIONS:=}');
    Error('\P{Block=KATAKANA_PHONETIC_EXTENSIONS:=}');
    Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(0, 12799, '\p{^Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(0, 12799, '\P{Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(1, 12799, '\P{^Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(0, 12800, '\p{Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(1, 12800, '\p{^Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(1, 12800, '\P{Block=_-Katakana_PHONETIC_Extensions}', "");
    Expect(0, 12800, '\P{^Block=_-Katakana_PHONETIC_Extensions}', "");
    Error('\p{Blk=_	katakana_Ext:=}');
    Error('\P{Blk=_	katakana_Ext:=}');
    Expect(1, 12799, '\p{Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Blk:    katakana_Ext}', "");
    Expect(0, 12799, '\p{^Blk:    katakana_Ext}', "");
    Expect(0, 12799, '\P{Blk:    katakana_Ext}', "");
    Expect(1, 12799, '\P{^Blk:    katakana_Ext}', "");
    Expect(0, 12800, '\p{Blk:    katakana_Ext}', "");
    Expect(1, 12800, '\p{^Blk:    katakana_Ext}', "");
    Expect(1, 12800, '\P{Blk:    katakana_Ext}', "");
    Expect(0, 12800, '\P{^Blk:    katakana_Ext}', "");
    Error('\p{Is_Block=	KATAKANA_Phonetic_Extensions/a/}');
    Error('\P{Is_Block=	KATAKANA_Phonetic_Extensions/a/}');
    Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(0, 12799, '\p{^Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(0, 12799, '\P{Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(1, 12799, '\P{^Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(0, 12800, '\p{Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(1, 12800, '\p{^Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(1, 12800, '\P{Is_Block= Katakana_Phonetic_Extensions}', "");
    Expect(0, 12800, '\P{^Is_Block= Katakana_Phonetic_Extensions}', "");
    Error('\p{Is_Blk=/a/_KATAKANA_Ext}');
    Error('\P{Is_Blk=/a/_KATAKANA_Ext}');
    Expect(1, 12799, '\p{Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Is_Blk=	katakana_ext}', "");
    Expect(0, 12799, '\p{^Is_Blk=	katakana_ext}', "");
    Expect(0, 12799, '\P{Is_Blk=	katakana_ext}', "");
    Expect(1, 12799, '\P{^Is_Blk=	katakana_ext}', "");
    Expect(0, 12800, '\p{Is_Blk=	katakana_ext}', "");
    Expect(1, 12800, '\p{^Is_Blk=	katakana_ext}', "");
    Expect(1, 12800, '\P{Is_Blk=	katakana_ext}', "");
    Expect(0, 12800, '\P{^Is_Blk=	katakana_ext}', "");
    Error('\p{Block=/a/--kayah_li}');
    Error('\P{Block=/a/--kayah_li}');
    Expect(1, 43311, '\p{Block=kayahli}', "");
    Expect(0, 43311, '\p{^Block=kayahli}', "");
    Expect(0, 43311, '\P{Block=kayahli}', "");
    Expect(1, 43311, '\P{^Block=kayahli}', "");
    Expect(0, 43312, '\p{Block=kayahli}', "");
    Expect(1, 43312, '\p{^Block=kayahli}', "");
    Expect(1, 43312, '\P{Block=kayahli}', "");
    Expect(0, 43312, '\P{^Block=kayahli}', "");
    Expect(1, 43311, '\p{Block= Kayah_LI}', "");
    Expect(0, 43311, '\p{^Block= Kayah_LI}', "");
    Expect(0, 43311, '\P{Block= Kayah_LI}', "");
    Expect(1, 43311, '\P{^Block= Kayah_LI}', "");
    Expect(0, 43312, '\p{Block= Kayah_LI}', "");
    Expect(1, 43312, '\p{^Block= Kayah_LI}', "");
    Expect(1, 43312, '\P{Block= Kayah_LI}', "");
    Expect(0, 43312, '\P{^Block= Kayah_LI}', "");
    Error('\p{Blk=:= 	KAYAH_li}');
    Error('\P{Blk=:= 	KAYAH_li}');
    Expect(1, 43311, '\p{Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Blk=kayahli}', "");
    Expect(0, 43311, '\P{Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Blk=kayahli}', "");
    Expect(0, 43312, '\p{Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Blk=kayahli}', "");
    Expect(1, 43312, '\P{Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Blk=kayahli}', "");
    Expect(1, 43311, '\p{Blk=		KAYAH_LI}', "");
    Expect(0, 43311, '\p{^Blk=		KAYAH_LI}', "");
    Expect(0, 43311, '\P{Blk=		KAYAH_LI}', "");
    Expect(1, 43311, '\P{^Blk=		KAYAH_LI}', "");
    Expect(0, 43312, '\p{Blk=		KAYAH_LI}', "");
    Expect(1, 43312, '\p{^Blk=		KAYAH_LI}', "");
    Expect(1, 43312, '\P{Blk=		KAYAH_LI}', "");
    Expect(0, 43312, '\P{^Blk=		KAYAH_LI}', "");
    Error('\p{Is_Block=:=_-Kayah_LI}');
    Error('\P{Is_Block=:=_-Kayah_LI}');
    Expect(1, 43311, '\p{Is_Block=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
    Expect(0, 43311, '\P{Is_Block=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
    Expect(0, 43312, '\p{Is_Block=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Block=kayahli}', "");
    Expect(1, 43312, '\P{Is_Block=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Block=kayahli}', "");
    Expect(1, 43311, '\p{Is_Block=	kayah_li}', "");
    Expect(0, 43311, '\p{^Is_Block=	kayah_li}', "");
    Expect(0, 43311, '\P{Is_Block=	kayah_li}', "");
    Expect(1, 43311, '\P{^Is_Block=	kayah_li}', "");
    Expect(0, 43312, '\p{Is_Block=	kayah_li}', "");
    Expect(1, 43312, '\p{^Is_Block=	kayah_li}', "");
    Expect(1, 43312, '\P{Is_Block=	kayah_li}', "");
    Expect(0, 43312, '\P{^Is_Block=	kayah_li}', "");
    Error('\p{Is_Blk:   :=_-Kayah_LI}');
    Error('\P{Is_Blk:   :=_-Kayah_LI}');
    Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
    Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
    Expect(0, 43312, '\p{Is_Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Blk=kayahli}', "");
    Expect(1, 43312, '\P{Is_Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Blk=kayahli}', "");
    Expect(1, 43311, '\p{Is_Blk=_ kayah_Li}', "");
    Expect(0, 43311, '\p{^Is_Blk=_ kayah_Li}', "");
    Expect(0, 43311, '\P{Is_Blk=_ kayah_Li}', "");
    Expect(1, 43311, '\P{^Is_Blk=_ kayah_Li}', "");
    Expect(0, 43312, '\p{Is_Blk=_ kayah_Li}', "");
    Expect(1, 43312, '\p{^Is_Blk=_ kayah_Li}', "");
    Expect(1, 43312, '\P{Is_Blk=_ kayah_Li}', "");
    Expect(0, 43312, '\P{^Is_Blk=_ kayah_Li}', "");
    Error('\p{Block=Kharoshthi:=}');
    Error('\P{Block=Kharoshthi:=}');
    Expect(1, 68191, '\p{Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Block=		Kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=		Kharoshthi}', "");
    Expect(0, 68191, '\P{Block=		Kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=		Kharoshthi}', "");
    Expect(0, 68192, '\p{Block=		Kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=		Kharoshthi}', "");
    Expect(1, 68192, '\P{Block=		Kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=		Kharoshthi}', "");
    Error('\p{Blk:	:=	_KHAROSHTHI}');
    Error('\P{Blk:	:=	_KHAROSHTHI}');
    Expect(1, 68191, '\p{Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Blk= kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk= kharoshthi}', "");
    Expect(0, 68191, '\P{Blk= kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk= kharoshthi}', "");
    Expect(0, 68192, '\p{Blk= kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk= kharoshthi}', "");
    Expect(1, 68192, '\P{Blk= kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk= kharoshthi}', "");
    Error('\p{Is_Block=-/a/KHAROSHTHI}');
    Error('\P{Is_Block=-/a/KHAROSHTHI}');
    Expect(1, 68191, '\p{Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Block:  Kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block:  Kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block:  Kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block:  Kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block:  Kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block:  Kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block:  Kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block:  Kharoshthi}', "");
    Error('\p{Is_Blk= /a/kharoshthi}');
    Error('\P{Is_Blk= /a/kharoshthi}');
    Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Blk=  KHAROSHTHI}', "");
    Expect(0, 68191, '\p{^Is_Blk=  KHAROSHTHI}', "");
    Expect(0, 68191, '\P{Is_Blk=  KHAROSHTHI}', "");
    Expect(1, 68191, '\P{^Is_Blk=  KHAROSHTHI}', "");
    Expect(0, 68192, '\p{Is_Blk=  KHAROSHTHI}', "");
    Expect(1, 68192, '\p{^Is_Blk=  KHAROSHTHI}', "");
    Expect(1, 68192, '\P{Is_Blk=  KHAROSHTHI}', "");
    Expect(0, 68192, '\P{^Is_Blk=  KHAROSHTHI}', "");
    Error('\p{Block= :=KHMER}');
    Error('\P{Block= :=KHMER}');
    Expect(1, 6143, '\p{Block=khmer}', "");
    Expect(0, 6143, '\p{^Block=khmer}', "");
    Expect(0, 6143, '\P{Block=khmer}', "");
    Expect(1, 6143, '\P{^Block=khmer}', "");
    Expect(0, 6144, '\p{Block=khmer}', "");
    Expect(1, 6144, '\p{^Block=khmer}', "");
    Expect(1, 6144, '\P{Block=khmer}', "");
    Expect(0, 6144, '\P{^Block=khmer}', "");
    Expect(1, 6143, '\p{Block= KHMER}', "");
    Expect(0, 6143, '\p{^Block= KHMER}', "");
    Expect(0, 6143, '\P{Block= KHMER}', "");
    Expect(1, 6143, '\P{^Block= KHMER}', "");
    Expect(0, 6144, '\p{Block= KHMER}', "");
    Expect(1, 6144, '\p{^Block= KHMER}', "");
    Expect(1, 6144, '\P{Block= KHMER}', "");
    Expect(0, 6144, '\P{^Block= KHMER}', "");
    Error('\p{Blk=_:=khmer}');
    Error('\P{Blk=_:=khmer}');
    Expect(1, 6143, '\p{Blk=khmer}', "");
    Expect(0, 6143, '\p{^Blk=khmer}', "");
    Expect(0, 6143, '\P{Blk=khmer}', "");
    Expect(1, 6143, '\P{^Blk=khmer}', "");
    Expect(0, 6144, '\p{Blk=khmer}', "");
    Expect(1, 6144, '\p{^Blk=khmer}', "");
    Expect(1, 6144, '\P{Blk=khmer}', "");
    Expect(0, 6144, '\P{^Blk=khmer}', "");
    Expect(1, 6143, '\p{Blk=_Khmer}', "");
    Expect(0, 6143, '\p{^Blk=_Khmer}', "");
    Expect(0, 6143, '\P{Blk=_Khmer}', "");
    Expect(1, 6143, '\P{^Blk=_Khmer}', "");
    Expect(0, 6144, '\p{Blk=_Khmer}', "");
    Expect(1, 6144, '\p{^Blk=_Khmer}', "");
    Expect(1, 6144, '\P{Blk=_Khmer}', "");
    Expect(0, 6144, '\P{^Blk=_Khmer}', "");
    Error('\p{Is_Block= _KHMER/a/}');
    Error('\P{Is_Block= _KHMER/a/}');
    Expect(1, 6143, '\p{Is_Block=khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=khmer}', "");
    Expect(0, 6143, '\P{Is_Block=khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=khmer}', "");
    Expect(0, 6144, '\p{Is_Block=khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=khmer}', "");
    Expect(1, 6144, '\P{Is_Block=khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=khmer}', "");
    Expect(1, 6143, '\p{Is_Block=	Khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=	Khmer}', "");
    Expect(0, 6143, '\P{Is_Block=	Khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=	Khmer}', "");
    Expect(0, 6144, '\p{Is_Block=	Khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=	Khmer}', "");
    Expect(1, 6144, '\P{Is_Block=	Khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=	Khmer}', "");
    Error('\p{Is_Blk= Khmer/a/}');
    Error('\P{Is_Blk= Khmer/a/}');
    Expect(1, 6143, '\p{Is_Blk=khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=khmer}', "");
    Expect(1, 6143, '\p{Is_Blk= 	Khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk= 	Khmer}', "");
    Expect(0, 6143, '\P{Is_Blk= 	Khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk= 	Khmer}', "");
    Expect(0, 6144, '\p{Is_Blk= 	Khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk= 	Khmer}', "");
    Expect(1, 6144, '\P{Is_Blk= 	Khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk= 	Khmer}', "");
    Error('\p{Block: -	khmer_Symbols:=}');
    Error('\P{Block: -	khmer_Symbols:=}');
    Expect(1, 6655, '\p{Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Block=	-Khmer_symbols}', "");
    Expect(0, 6655, '\p{^Block=	-Khmer_symbols}', "");
    Expect(0, 6655, '\P{Block=	-Khmer_symbols}', "");
    Expect(1, 6655, '\P{^Block=	-Khmer_symbols}', "");
    Expect(0, 6656, '\p{Block=	-Khmer_symbols}', "");
    Expect(1, 6656, '\p{^Block=	-Khmer_symbols}', "");
    Expect(1, 6656, '\P{Block=	-Khmer_symbols}', "");
    Expect(0, 6656, '\P{^Block=	-Khmer_symbols}', "");
    Error('\p{Blk:	 /a/Khmer_Symbols}');
    Error('\P{Blk:	 /a/Khmer_Symbols}');
    Expect(1, 6655, '\p{Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Blk=-KHMER_symbols}', "");
    Expect(0, 6655, '\p{^Blk=-KHMER_symbols}', "");
    Expect(0, 6655, '\P{Blk=-KHMER_symbols}', "");
    Expect(1, 6655, '\P{^Blk=-KHMER_symbols}', "");
    Expect(0, 6656, '\p{Blk=-KHMER_symbols}', "");
    Expect(1, 6656, '\p{^Blk=-KHMER_symbols}', "");
    Expect(1, 6656, '\P{Blk=-KHMER_symbols}', "");
    Expect(0, 6656, '\P{^Blk=-KHMER_symbols}', "");
    Error('\p{Is_Block=-:=Khmer_Symbols}');
    Error('\P{Is_Block=-:=Khmer_Symbols}');
    Expect(1, 6655, '\p{Is_Block:khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Block:khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Block:khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Block:khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Block:khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Block:khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Block:khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Block:khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Block=		khmer_symbols}', "");
    Expect(0, 6655, '\p{^Is_Block=		khmer_symbols}', "");
    Expect(0, 6655, '\P{Is_Block=		khmer_symbols}', "");
    Expect(1, 6655, '\P{^Is_Block=		khmer_symbols}', "");
    Expect(0, 6656, '\p{Is_Block=		khmer_symbols}', "");
    Expect(1, 6656, '\p{^Is_Block=		khmer_symbols}', "");
    Expect(1, 6656, '\P{Is_Block=		khmer_symbols}', "");
    Expect(0, 6656, '\P{^Is_Block=		khmer_symbols}', "");
    Error('\p{Is_Blk:		 Khmer_symbols:=}');
    Error('\P{Is_Blk:		 Khmer_symbols:=}');
    Expect(1, 6655, '\p{Is_Blk:	khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Blk:	khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Blk:	khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Blk:	khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Blk:	khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Blk:	khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Blk:	khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Blk:	khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Is_Blk=-Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Is_Blk=-Khmer_SYMBOLS}', "");
    Error('\p{Block=:=_Khojki}');
    Error('\P{Block=:=_Khojki}');
    Expect(1, 70223, '\p{Block=khojki}', "");
    Expect(0, 70223, '\p{^Block=khojki}', "");
    Expect(0, 70223, '\P{Block=khojki}', "");
    Expect(1, 70223, '\P{^Block=khojki}', "");
    Expect(0, 70224, '\p{Block=khojki}', "");
    Expect(1, 70224, '\p{^Block=khojki}', "");
    Expect(1, 70224, '\P{Block=khojki}', "");
    Expect(0, 70224, '\P{^Block=khojki}', "");
    Expect(1, 70223, '\p{Block=	-khojki}', "");
    Expect(0, 70223, '\p{^Block=	-khojki}', "");
    Expect(0, 70223, '\P{Block=	-khojki}', "");
    Expect(1, 70223, '\P{^Block=	-khojki}', "");
    Expect(0, 70224, '\p{Block=	-khojki}', "");
    Expect(1, 70224, '\p{^Block=	-khojki}', "");
    Expect(1, 70224, '\P{Block=	-khojki}', "");
    Expect(0, 70224, '\P{^Block=	-khojki}', "");
    Error('\p{Blk=/a/__KHOJKI}');
    Error('\P{Blk=/a/__KHOJKI}');
    Expect(1, 70223, '\p{Blk=khojki}', "");
    Expect(0, 70223, '\p{^Blk=khojki}', "");
    Expect(0, 70223, '\P{Blk=khojki}', "");
    Expect(1, 70223, '\P{^Blk=khojki}', "");
    Expect(0, 70224, '\p{Blk=khojki}', "");
    Expect(1, 70224, '\p{^Blk=khojki}', "");
    Expect(1, 70224, '\P{Blk=khojki}', "");
    Expect(0, 70224, '\P{^Blk=khojki}', "");
    Expect(1, 70223, '\p{Blk:-Khojki}', "");
    Expect(0, 70223, '\p{^Blk:-Khojki}', "");
    Expect(0, 70223, '\P{Blk:-Khojki}', "");
    Expect(1, 70223, '\P{^Blk:-Khojki}', "");
    Expect(0, 70224, '\p{Blk:-Khojki}', "");
    Expect(1, 70224, '\p{^Blk:-Khojki}', "");
    Expect(1, 70224, '\P{Blk:-Khojki}', "");
    Expect(0, 70224, '\P{^Blk:-Khojki}', "");
    Error('\p{Is_Block=/a/_khojki}');
    Error('\P{Is_Block=/a/_khojki}');
    Expect(1, 70223, '\p{Is_Block=khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=khojki}', "");
    Expect(0, 70223, '\P{Is_Block=khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=khojki}', "");
    Expect(0, 70224, '\p{Is_Block=khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=khojki}', "");
    Expect(1, 70224, '\P{Is_Block=khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=khojki}', "");
    Expect(1, 70223, '\p{Is_Block=		KHOJKI}', "");
    Expect(0, 70223, '\p{^Is_Block=		KHOJKI}', "");
    Expect(0, 70223, '\P{Is_Block=		KHOJKI}', "");
    Expect(1, 70223, '\P{^Is_Block=		KHOJKI}', "");
    Expect(0, 70224, '\p{Is_Block=		KHOJKI}', "");
    Expect(1, 70224, '\p{^Is_Block=		KHOJKI}', "");
    Expect(1, 70224, '\P{Is_Block=		KHOJKI}', "");
    Expect(0, 70224, '\P{^Is_Block=		KHOJKI}', "");
    Error('\p{Is_Blk=:=KHOJKI}');
    Error('\P{Is_Blk=:=KHOJKI}');
    Expect(1, 70223, '\p{Is_Blk=khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=khojki}', "");
    Expect(1, 70223, '\p{Is_Blk:   	 Khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk:   	 Khojki}', "");
    Expect(0, 70223, '\P{Is_Blk:   	 Khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk:   	 Khojki}', "");
    Expect(0, 70224, '\p{Is_Blk:   	 Khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk:   	 Khojki}', "");
    Expect(1, 70224, '\P{Is_Blk:   	 Khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk:   	 Khojki}', "");
    Error('\p{Block=:=_ khudawadi}');
    Error('\P{Block=:=_ khudawadi}');
    Expect(1, 70399, '\p{Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Block=khudawadi}', "");
    Expect(0, 70399, '\P{Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Block=khudawadi}', "");
    Expect(0, 70400, '\p{Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Block=khudawadi}', "");
    Expect(1, 70400, '\P{Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Block=khudawadi}', "");
    Expect(1, 70399, '\p{Block=--khudawadi}', "");
    Expect(0, 70399, '\p{^Block=--khudawadi}', "");
    Expect(0, 70399, '\P{Block=--khudawadi}', "");
    Expect(1, 70399, '\P{^Block=--khudawadi}', "");
    Expect(0, 70400, '\p{Block=--khudawadi}', "");
    Expect(1, 70400, '\p{^Block=--khudawadi}', "");
    Expect(1, 70400, '\P{Block=--khudawadi}', "");
    Expect(0, 70400, '\P{^Block=--khudawadi}', "");
    Error('\p{Blk=		Khudawadi/a/}');
    Error('\P{Blk=		Khudawadi/a/}');
    Expect(1, 70399, '\p{Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Blk=-KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Blk=-KHUDAWADI}', "");
    Expect(0, 70399, '\P{Blk=-KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Blk=-KHUDAWADI}', "");
    Expect(0, 70400, '\p{Blk=-KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Blk=-KHUDAWADI}', "");
    Expect(1, 70400, '\P{Blk=-KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Blk=-KHUDAWADI}', "");
    Error('\p{Is_Block=__Khudawadi/a/}');
    Error('\P{Is_Block=__Khudawadi/a/}');
    Expect(1, 70399, '\p{Is_Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Block=_Khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=_Khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=_Khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=_Khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=_Khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=_Khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=_Khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=_Khudawadi}', "");
    Error('\p{Is_Blk=	_KHUDAWADI:=}');
    Error('\P{Is_Blk=	_KHUDAWADI:=}');
    Expect(1, 70399, '\p{Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Blk=- Khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=- Khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=- Khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=- Khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=- Khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=- Khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=- Khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=- Khudawadi}', "");
    Error('\p{Block=	 LAO:=}');
    Error('\P{Block=	 LAO:=}');
    Expect(1, 3839, '\p{Block=lao}', "");
    Expect(0, 3839, '\p{^Block=lao}', "");
    Expect(0, 3839, '\P{Block=lao}', "");
    Expect(1, 3839, '\P{^Block=lao}', "");
    Expect(0, 3840, '\p{Block=lao}', "");
    Expect(1, 3840, '\p{^Block=lao}', "");
    Expect(1, 3840, '\P{Block=lao}', "");
    Expect(0, 3840, '\P{^Block=lao}', "");
    Expect(1, 3839, '\p{Block=	Lao}', "");
    Expect(0, 3839, '\p{^Block=	Lao}', "");
    Expect(0, 3839, '\P{Block=	Lao}', "");
    Expect(1, 3839, '\P{^Block=	Lao}', "");
    Expect(0, 3840, '\p{Block=	Lao}', "");
    Expect(1, 3840, '\p{^Block=	Lao}', "");
    Expect(1, 3840, '\P{Block=	Lao}', "");
    Expect(0, 3840, '\P{^Block=	Lao}', "");
    Error('\p{Blk=/a/Lao}');
    Error('\P{Blk=/a/Lao}');
    Expect(1, 3839, '\p{Blk:   lao}', "");
    Expect(0, 3839, '\p{^Blk:   lao}', "");
    Expect(0, 3839, '\P{Blk:   lao}', "");
    Expect(1, 3839, '\P{^Blk:   lao}', "");
    Expect(0, 3840, '\p{Blk:   lao}', "");
    Expect(1, 3840, '\p{^Blk:   lao}', "");
    Expect(1, 3840, '\P{Blk:   lao}', "");
    Expect(0, 3840, '\P{^Blk:   lao}', "");
    Expect(1, 3839, '\p{Blk= 	lao}', "");
    Expect(0, 3839, '\p{^Blk= 	lao}', "");
    Expect(0, 3839, '\P{Blk= 	lao}', "");
    Expect(1, 3839, '\P{^Blk= 	lao}', "");
    Expect(0, 3840, '\p{Blk= 	lao}', "");
    Expect(1, 3840, '\p{^Blk= 	lao}', "");
    Expect(1, 3840, '\P{Blk= 	lao}', "");
    Expect(0, 3840, '\P{^Blk= 	lao}', "");
    Error('\p{Is_Block=:=	_lao}');
    Error('\P{Is_Block=:=	_lao}');
    Expect(1, 3839, '\p{Is_Block=lao}', "");
    Expect(0, 3839, '\p{^Is_Block=lao}', "");
    Expect(0, 3839, '\P{Is_Block=lao}', "");
    Expect(1, 3839, '\P{^Is_Block=lao}', "");
    Expect(0, 3840, '\p{Is_Block=lao}', "");
    Expect(1, 3840, '\p{^Is_Block=lao}', "");
    Expect(1, 3840, '\P{Is_Block=lao}', "");
    Expect(0, 3840, '\P{^Is_Block=lao}', "");
    Expect(1, 3839, '\p{Is_Block=Lao}', "");
    Expect(0, 3839, '\p{^Is_Block=Lao}', "");
    Expect(0, 3839, '\P{Is_Block=Lao}', "");
    Expect(1, 3839, '\P{^Is_Block=Lao}', "");
    Expect(0, 3840, '\p{Is_Block=Lao}', "");
    Expect(1, 3840, '\p{^Is_Block=Lao}', "");
    Expect(1, 3840, '\P{Is_Block=Lao}', "");
    Expect(0, 3840, '\P{^Is_Block=Lao}', "");
    Error('\p{Is_Blk: --Lao/a/}');
    Error('\P{Is_Blk: --Lao/a/}');
    Expect(1, 3839, '\p{Is_Blk=lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=lao}', "");
    Expect(0, 3839, '\P{Is_Blk=lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=lao}', "");
    Expect(0, 3840, '\p{Is_Blk=lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=lao}', "");
    Expect(1, 3840, '\P{Is_Blk=lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=lao}', "");
    Expect(1, 3839, '\p{Is_Blk= 	Lao}', "");
    Expect(0, 3839, '\p{^Is_Blk= 	Lao}', "");
    Expect(0, 3839, '\P{Is_Blk= 	Lao}', "");
    Expect(1, 3839, '\P{^Is_Blk= 	Lao}', "");
    Expect(0, 3840, '\p{Is_Blk= 	Lao}', "");
    Expect(1, 3840, '\p{^Is_Blk= 	Lao}', "");
    Expect(1, 3840, '\P{Is_Blk= 	Lao}', "");
    Expect(0, 3840, '\P{^Is_Blk= 	Lao}', "");
    Error('\p{Block=-/a/Latin_1_Supplement}');
    Error('\P{Block=-/a/Latin_1_Supplement}');
    Expect(1, 255, '\p{Block=latin1supplement}', "");
    Expect(0, 255, '\p{^Block=latin1supplement}', "");
    Expect(0, 255, '\P{Block=latin1supplement}', "");
    Expect(1, 255, '\P{^Block=latin1supplement}', "");
    Expect(0, 256, '\p{Block=latin1supplement}', "");
    Expect(1, 256, '\p{^Block=latin1supplement}', "");
    Expect(1, 256, '\P{Block=latin1supplement}', "");
    Expect(0, 256, '\P{^Block=latin1supplement}', "");
    Expect(1, 255, '\p{Block=-	Latin_1_Supplement}', "");
    Expect(0, 255, '\p{^Block=-	Latin_1_Supplement}', "");
    Expect(0, 255, '\P{Block=-	Latin_1_Supplement}', "");
    Expect(1, 255, '\P{^Block=-	Latin_1_Supplement}', "");
    Expect(0, 256, '\p{Block=-	Latin_1_Supplement}', "");
    Expect(1, 256, '\p{^Block=-	Latin_1_Supplement}', "");
    Expect(1, 256, '\P{Block=-	Latin_1_Supplement}', "");
    Expect(0, 256, '\P{^Block=-	Latin_1_Supplement}', "");
    Error('\p{Blk= /a/LATIN_1_SUP}');
    Error('\P{Blk= /a/LATIN_1_SUP}');
    Expect(1, 255, '\p{Blk=latin1sup}', "");
    Expect(0, 255, '\p{^Blk=latin1sup}', "");
    Expect(0, 255, '\P{Blk=latin1sup}', "");
    Expect(1, 255, '\P{^Blk=latin1sup}', "");
    Expect(0, 256, '\p{Blk=latin1sup}', "");
    Expect(1, 256, '\p{^Blk=latin1sup}', "");
    Expect(1, 256, '\P{Blk=latin1sup}', "");
    Expect(0, 256, '\P{^Blk=latin1sup}', "");
    Expect(1, 255, '\p{Blk:	 Latin_1_sup}', "");
    Expect(0, 255, '\p{^Blk:	 Latin_1_sup}', "");
    Expect(0, 255, '\P{Blk:	 Latin_1_sup}', "");
    Expect(1, 255, '\P{^Blk:	 Latin_1_sup}', "");
    Expect(0, 256, '\p{Blk:	 Latin_1_sup}', "");
    Expect(1, 256, '\p{^Blk:	 Latin_1_sup}', "");
    Expect(1, 256, '\P{Blk:	 Latin_1_sup}', "");
    Expect(0, 256, '\P{^Blk:	 Latin_1_sup}', "");
    Error('\p{Is_Block=:=_Latin_1}');
    Error('\P{Is_Block=:=_Latin_1}');
    Expect(1, 255, '\p{Is_Block=latin1}', "");
    Expect(0, 255, '\p{^Is_Block=latin1}', "");
    Expect(0, 255, '\P{Is_Block=latin1}', "");
    Expect(1, 255, '\P{^Is_Block=latin1}', "");
    Expect(0, 256, '\p{Is_Block=latin1}', "");
    Expect(1, 256, '\p{^Is_Block=latin1}', "");
    Expect(1, 256, '\P{Is_Block=latin1}', "");
    Expect(0, 256, '\P{^Is_Block=latin1}', "");
    Expect(1, 255, '\p{Is_Block=_ latin_1}', "");
    Expect(0, 255, '\p{^Is_Block=_ latin_1}', "");
    Expect(0, 255, '\P{Is_Block=_ latin_1}', "");
    Expect(1, 255, '\P{^Is_Block=_ latin_1}', "");
    Expect(0, 256, '\p{Is_Block=_ latin_1}', "");
    Expect(1, 256, '\p{^Is_Block=_ latin_1}', "");
    Expect(1, 256, '\P{Is_Block=_ latin_1}', "");
    Expect(0, 256, '\P{^Is_Block=_ latin_1}', "");
    Error('\p{Is_Blk:   /a/LATIN_1_SUPPLEMENT}');
    Error('\P{Is_Blk:   /a/LATIN_1_SUPPLEMENT}');
    Expect(1, 255, '\p{Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\P{Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\p{Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\P{Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\p{Is_Blk=_ Latin_1_Supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=_ Latin_1_Supplement}', "");
    Expect(0, 255, '\P{Is_Blk=_ Latin_1_Supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=_ Latin_1_Supplement}', "");
    Expect(0, 256, '\p{Is_Blk=_ Latin_1_Supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=_ Latin_1_Supplement}', "");
    Expect(1, 256, '\P{Is_Blk=_ Latin_1_Supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=_ Latin_1_Supplement}', "");
    Error('\p{Block=:= -LATIN_Extended_A}');
    Error('\P{Block=:= -LATIN_Extended_A}');
    Expect(1, 383, '\p{Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Block=latinextendeda}', "");
    Expect(0, 383, '\P{Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Block=latinextendeda}', "");
    Expect(0, 384, '\p{Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Block=latinextendeda}', "");
    Expect(1, 384, '\P{Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Block=latinextendeda}', "");
    Expect(1, 383, '\p{Block=		LATIN_extended_A}', "");
    Expect(0, 383, '\p{^Block=		LATIN_extended_A}', "");
    Expect(0, 383, '\P{Block=		LATIN_extended_A}', "");
    Expect(1, 383, '\P{^Block=		LATIN_extended_A}', "");
    Expect(0, 384, '\p{Block=		LATIN_extended_A}', "");
    Expect(1, 384, '\p{^Block=		LATIN_extended_A}', "");
    Expect(1, 384, '\P{Block=		LATIN_extended_A}', "");
    Expect(0, 384, '\P{^Block=		LATIN_extended_A}', "");
    Error('\p{Blk=_LATIN_Ext_a/a/}');
    Error('\P{Blk=_LATIN_Ext_a/a/}');
    Expect(1, 383, '\p{Blk=latinexta}', "");
    Expect(0, 383, '\p{^Blk=latinexta}', "");
    Expect(0, 383, '\P{Blk=latinexta}', "");
    Expect(1, 383, '\P{^Blk=latinexta}', "");
    Expect(0, 384, '\p{Blk=latinexta}', "");
    Expect(1, 384, '\p{^Blk=latinexta}', "");
    Expect(1, 384, '\P{Blk=latinexta}', "");
    Expect(0, 384, '\P{^Blk=latinexta}', "");
    Expect(1, 383, '\p{Blk= -Latin_ext_A}', "");
    Expect(0, 383, '\p{^Blk= -Latin_ext_A}', "");
    Expect(0, 383, '\P{Blk= -Latin_ext_A}', "");
    Expect(1, 383, '\P{^Blk= -Latin_ext_A}', "");
    Expect(0, 384, '\p{Blk= -Latin_ext_A}', "");
    Expect(1, 384, '\p{^Blk= -Latin_ext_A}', "");
    Expect(1, 384, '\P{Blk= -Latin_ext_A}', "");
    Expect(0, 384, '\P{^Blk= -Latin_ext_A}', "");
    Error('\p{Is_Block: 	-latin_extended_a:=}');
    Error('\P{Is_Block: 	-latin_extended_a:=}');
    Expect(1, 383, '\p{Is_Block:	latinextendeda}', "");
    Expect(0, 383, '\p{^Is_Block:	latinextendeda}', "");
    Expect(0, 383, '\P{Is_Block:	latinextendeda}', "");
    Expect(1, 383, '\P{^Is_Block:	latinextendeda}', "");
    Expect(0, 384, '\p{Is_Block:	latinextendeda}', "");
    Expect(1, 384, '\p{^Is_Block:	latinextendeda}', "");
    Expect(1, 384, '\P{Is_Block:	latinextendeda}', "");
    Expect(0, 384, '\P{^Is_Block:	latinextendeda}', "");
    Expect(1, 383, '\p{Is_Block=- LATIN_Extended_A}', "");
    Expect(0, 383, '\p{^Is_Block=- LATIN_Extended_A}', "");
    Expect(0, 383, '\P{Is_Block=- LATIN_Extended_A}', "");
    Expect(1, 383, '\P{^Is_Block=- LATIN_Extended_A}', "");
    Expect(0, 384, '\p{Is_Block=- LATIN_Extended_A}', "");
    Expect(1, 384, '\p{^Is_Block=- LATIN_Extended_A}', "");
    Expect(1, 384, '\P{Is_Block=- LATIN_Extended_A}', "");
    Expect(0, 384, '\P{^Is_Block=- LATIN_Extended_A}', "");
    Error('\p{Is_Blk=	/a/Latin_Ext_A}');
    Error('\P{Is_Blk=	/a/Latin_Ext_A}');
    Expect(1, 383, '\p{Is_Blk=latinexta}', "");
    Expect(0, 383, '\p{^Is_Blk=latinexta}', "");
    Expect(0, 383, '\P{Is_Blk=latinexta}', "");
    Expect(1, 383, '\P{^Is_Blk=latinexta}', "");
    Expect(0, 384, '\p{Is_Blk=latinexta}', "");
    Expect(1, 384, '\p{^Is_Blk=latinexta}', "");
    Expect(1, 384, '\P{Is_Blk=latinexta}', "");
    Expect(0, 384, '\P{^Is_Blk=latinexta}', "");
    Expect(1, 383, '\p{Is_Blk=-Latin_EXT_A}', "");
    Expect(0, 383, '\p{^Is_Blk=-Latin_EXT_A}', "");
    Expect(0, 383, '\P{Is_Blk=-Latin_EXT_A}', "");
    Expect(1, 383, '\P{^Is_Blk=-Latin_EXT_A}', "");
    Expect(0, 384, '\p{Is_Blk=-Latin_EXT_A}', "");
    Expect(1, 384, '\p{^Is_Blk=-Latin_EXT_A}', "");
    Expect(1, 384, '\P{Is_Blk=-Latin_EXT_A}', "");
    Expect(0, 384, '\P{^Is_Blk=-Latin_EXT_A}', "");
    Error('\p{Block=Latin_Extended_Additional:=}');
    Error('\P{Block=Latin_Extended_Additional:=}');
    Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Block=__latin_EXTENDED_Additional}', "");
    Expect(0, 7935, '\p{^Block=__latin_EXTENDED_Additional}', "");
    Expect(0, 7935, '\P{Block=__latin_EXTENDED_Additional}', "");
    Expect(1, 7935, '\P{^Block=__latin_EXTENDED_Additional}', "");
    Expect(0, 7936, '\p{Block=__latin_EXTENDED_Additional}', "");
    Expect(1, 7936, '\p{^Block=__latin_EXTENDED_Additional}', "");
    Expect(1, 7936, '\P{Block=__latin_EXTENDED_Additional}', "");
    Expect(0, 7936, '\P{^Block=__latin_EXTENDED_Additional}', "");
    Error('\p{Blk=	LATIN_Ext_ADDITIONAL:=}');
    Error('\P{Blk=	LATIN_Ext_ADDITIONAL:=}');
    Expect(1, 7935, '\p{Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Blk=-Latin_Ext_Additional}', "");
    Expect(0, 7935, '\p{^Blk=-Latin_Ext_Additional}', "");
    Expect(0, 7935, '\P{Blk=-Latin_Ext_Additional}', "");
    Expect(1, 7935, '\P{^Blk=-Latin_Ext_Additional}', "");
    Expect(0, 7936, '\p{Blk=-Latin_Ext_Additional}', "");
    Expect(1, 7936, '\p{^Blk=-Latin_Ext_Additional}', "");
    Expect(1, 7936, '\P{Blk=-Latin_Ext_Additional}', "");
    Expect(0, 7936, '\P{^Blk=-Latin_Ext_Additional}', "");
    Error('\p{Is_Block:	/a/-latin_EXTENDED_Additional}');
    Error('\P{Is_Block:	/a/-latin_EXTENDED_Additional}');
    Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Is_Block=	Latin_extended_Additional}', "");
    Expect(0, 7935, '\p{^Is_Block=	Latin_extended_Additional}', "");
    Expect(0, 7935, '\P{Is_Block=	Latin_extended_Additional}', "");
    Expect(1, 7935, '\P{^Is_Block=	Latin_extended_Additional}', "");
    Expect(0, 7936, '\p{Is_Block=	Latin_extended_Additional}', "");
    Expect(1, 7936, '\p{^Is_Block=	Latin_extended_Additional}', "");
    Expect(1, 7936, '\P{Is_Block=	Latin_extended_Additional}', "");
    Expect(0, 7936, '\P{^Is_Block=	Latin_extended_Additional}', "");
    Error('\p{Is_Blk=:= 	LATIN_ext_additional}');
    Error('\P{Is_Blk=:= 	LATIN_ext_additional}');
    Expect(1, 7935, '\p{Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Is_Blk=_Latin_ext_Additional}', "");
    Expect(0, 7935, '\p{^Is_Blk=_Latin_ext_Additional}', "");
    Expect(0, 7935, '\P{Is_Blk=_Latin_ext_Additional}', "");
    Expect(1, 7935, '\P{^Is_Blk=_Latin_ext_Additional}', "");
    Expect(0, 7936, '\p{Is_Blk=_Latin_ext_Additional}', "");
    Expect(1, 7936, '\p{^Is_Blk=_Latin_ext_Additional}', "");
    Expect(1, 7936, '\P{Is_Blk=_Latin_ext_Additional}', "");
    Expect(0, 7936, '\P{^Is_Blk=_Latin_ext_Additional}', "");
    Error('\p{Block=-/a/LATIN_EXTENDED_B}');
    Error('\P{Block=-/a/LATIN_EXTENDED_B}');
    Expect(1, 591, '\p{Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Block=latinextendedb}', "");
    Expect(0, 591, '\P{Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Block=latinextendedb}', "");
    Expect(0, 592, '\p{Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Block=latinextendedb}', "");
    Expect(1, 592, '\P{Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Block=latinextendedb}', "");
    Expect(1, 591, '\p{Block= _latin_extended_b}', "");
    Expect(0, 591, '\p{^Block= _latin_extended_b}', "");
    Expect(0, 591, '\P{Block= _latin_extended_b}', "");
    Expect(1, 591, '\P{^Block= _latin_extended_b}', "");
    Expect(0, 592, '\p{Block= _latin_extended_b}', "");
    Expect(1, 592, '\p{^Block= _latin_extended_b}', "");
    Expect(1, 592, '\P{Block= _latin_extended_b}', "");
    Expect(0, 592, '\P{^Block= _latin_extended_b}', "");
    Error('\p{Blk=:=-latin_ext_B}');
    Error('\P{Blk=:=-latin_ext_B}');
    Expect(1, 591, '\p{Blk=latinextb}', "");
    Expect(0, 591, '\p{^Blk=latinextb}', "");
    Expect(0, 591, '\P{Blk=latinextb}', "");
    Expect(1, 591, '\P{^Blk=latinextb}', "");
    Expect(0, 592, '\p{Blk=latinextb}', "");
    Expect(1, 592, '\p{^Blk=latinextb}', "");
    Expect(1, 592, '\P{Blk=latinextb}', "");
    Expect(0, 592, '\P{^Blk=latinextb}', "");
    Expect(1, 591, '\p{Blk=		LATIN_ext_B}', "");
    Expect(0, 591, '\p{^Blk=		LATIN_ext_B}', "");
    Expect(0, 591, '\P{Blk=		LATIN_ext_B}', "");
    Expect(1, 591, '\P{^Blk=		LATIN_ext_B}', "");
    Expect(0, 592, '\p{Blk=		LATIN_ext_B}', "");
    Expect(1, 592, '\p{^Blk=		LATIN_ext_B}', "");
    Expect(1, 592, '\P{Blk=		LATIN_ext_B}', "");
    Expect(0, 592, '\P{^Blk=		LATIN_ext_B}', "");
    Error('\p{Is_Block= -latin_Extended_B/a/}');
    Error('\P{Is_Block= -latin_Extended_B/a/}');
    Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
    Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
    Expect(0, 592, '\p{Is_Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Is_Block=latinextendedb}', "");
    Expect(1, 592, '\P{Is_Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Is_Block=latinextendedb}', "");
    Expect(1, 591, '\p{Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 591, '\p{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 591, '\P{Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 591, '\P{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 592, '\p{Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 592, '\p{^Is_Block=-_LATIN_Extended_B}', "");
    Expect(1, 592, '\P{Is_Block=-_LATIN_Extended_B}', "");
    Expect(0, 592, '\P{^Is_Block=-_LATIN_Extended_B}', "");
    Error('\p{Is_Blk::= _latin_ext_B}');
    Error('\P{Is_Blk::= _latin_ext_B}');
    Expect(1, 591, '\p{Is_Blk=latinextb}', "");
    Expect(0, 591, '\p{^Is_Blk=latinextb}', "");
    Expect(0, 591, '\P{Is_Blk=latinextb}', "");
    Expect(1, 591, '\P{^Is_Blk=latinextb}', "");
    Expect(0, 592, '\p{Is_Blk=latinextb}', "");
    Expect(1, 592, '\p{^Is_Blk=latinextb}', "");
    Expect(1, 592, '\P{Is_Blk=latinextb}', "");
    Expect(0, 592, '\P{^Is_Blk=latinextb}', "");
    Expect(1, 591, '\p{Is_Blk=-latin_Ext_B}', "");
    Expect(0, 591, '\p{^Is_Blk=-latin_Ext_B}', "");
    Expect(0, 591, '\P{Is_Blk=-latin_Ext_B}', "");
    Expect(1, 591, '\P{^Is_Blk=-latin_Ext_B}', "");
    Expect(0, 592, '\p{Is_Blk=-latin_Ext_B}', "");
    Expect(1, 592, '\p{^Is_Blk=-latin_Ext_B}', "");
    Expect(1, 592, '\P{Is_Blk=-latin_Ext_B}', "");
    Expect(0, 592, '\P{^Is_Blk=-latin_Ext_B}', "");
    Error('\p{Block=	-latin_extended_c/a/}');
    Error('\P{Block=	-latin_extended_c/a/}');
    Expect(1, 11391, '\p{Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Block=		LATIN_Extended_C}', "");
    Expect(0, 11391, '\p{^Block=		LATIN_Extended_C}', "");
    Expect(0, 11391, '\P{Block=		LATIN_Extended_C}', "");
    Expect(1, 11391, '\P{^Block=		LATIN_Extended_C}', "");
    Expect(0, 11392, '\p{Block=		LATIN_Extended_C}', "");
    Expect(1, 11392, '\p{^Block=		LATIN_Extended_C}', "");
    Expect(1, 11392, '\P{Block=		LATIN_Extended_C}', "");
    Expect(0, 11392, '\P{^Block=		LATIN_Extended_C}', "");
    Error('\p{Blk=_/a/Latin_ext_C}');
    Error('\P{Blk=_/a/Latin_ext_C}');
    Expect(1, 11391, '\p{Blk:   latinextc}', "");
    Expect(0, 11391, '\p{^Blk:   latinextc}', "");
    Expect(0, 11391, '\P{Blk:   latinextc}', "");
    Expect(1, 11391, '\P{^Blk:   latinextc}', "");
    Expect(0, 11392, '\p{Blk:   latinextc}', "");
    Expect(1, 11392, '\p{^Blk:   latinextc}', "");
    Expect(1, 11392, '\P{Blk:   latinextc}', "");
    Expect(0, 11392, '\P{^Blk:   latinextc}', "");
    Expect(1, 11391, '\p{Blk=_ Latin_Ext_c}', "");
    Expect(0, 11391, '\p{^Blk=_ Latin_Ext_c}', "");
    Expect(0, 11391, '\P{Blk=_ Latin_Ext_c}', "");
    Expect(1, 11391, '\P{^Blk=_ Latin_Ext_c}', "");
    Expect(0, 11392, '\p{Blk=_ Latin_Ext_c}', "");
    Expect(1, 11392, '\p{^Blk=_ Latin_Ext_c}', "");
    Expect(1, 11392, '\P{Blk=_ Latin_Ext_c}', "");
    Expect(0, 11392, '\P{^Blk=_ Latin_Ext_c}', "");
    Error('\p{Is_Block=/a/latin_Extended_C}');
    Error('\P{Is_Block=/a/latin_Extended_C}');
    Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Is_Block=	Latin_EXTENDED_C}', "");
    Expect(0, 11391, '\p{^Is_Block=	Latin_EXTENDED_C}', "");
    Expect(0, 11391, '\P{Is_Block=	Latin_EXTENDED_C}', "");
    Expect(1, 11391, '\P{^Is_Block=	Latin_EXTENDED_C}', "");
    Expect(0, 11392, '\p{Is_Block=	Latin_EXTENDED_C}', "");
    Expect(1, 11392, '\p{^Is_Block=	Latin_EXTENDED_C}', "");
    Expect(1, 11392, '\P{Is_Block=	Latin_EXTENDED_C}', "");
    Expect(0, 11392, '\P{^Is_Block=	Latin_EXTENDED_C}', "");
    Error('\p{Is_Blk= :=LATIN_Ext_c}');
    Error('\P{Is_Blk= :=LATIN_Ext_c}');
    Expect(1, 11391, '\p{Is_Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Is_Blk=latinextc}', "");
    Expect(0, 11391, '\P{Is_Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Is_Blk=latinextc}', "");
    Expect(0, 11392, '\p{Is_Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Is_Blk=latinextc}', "");
    Expect(1, 11392, '\P{Is_Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Is_Blk=latinextc}', "");
    Expect(1, 11391, '\p{Is_Blk=		Latin_ext_C}', "");
    Expect(0, 11391, '\p{^Is_Blk=		Latin_ext_C}', "");
    Expect(0, 11391, '\P{Is_Blk=		Latin_ext_C}', "");
    Expect(1, 11391, '\P{^Is_Blk=		Latin_ext_C}', "");
    Expect(0, 11392, '\p{Is_Blk=		Latin_ext_C}', "");
    Expect(1, 11392, '\p{^Is_Blk=		Latin_ext_C}', "");
    Expect(1, 11392, '\P{Is_Blk=		Latin_ext_C}', "");
    Expect(0, 11392, '\P{^Is_Blk=		Latin_ext_C}', "");
    Error('\p{Block=:=	_Latin_Extended_d}');
    Error('\P{Block=:=	_Latin_Extended_d}');
    Expect(1, 43007, '\p{Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Block= Latin_Extended_d}', "");
    Expect(0, 43007, '\p{^Block= Latin_Extended_d}', "");
    Expect(0, 43007, '\P{Block= Latin_Extended_d}', "");
    Expect(1, 43007, '\P{^Block= Latin_Extended_d}', "");
    Expect(0, 43008, '\p{Block= Latin_Extended_d}', "");
    Expect(1, 43008, '\p{^Block= Latin_Extended_d}', "");
    Expect(1, 43008, '\P{Block= Latin_Extended_d}', "");
    Expect(0, 43008, '\P{^Block= Latin_Extended_d}', "");
    Error('\p{Blk=/a/ _LATIN_Ext_d}');
    Error('\P{Blk=/a/ _LATIN_Ext_d}');
    Expect(1, 43007, '\p{Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Blk=latinextd}', "");
    Expect(0, 43007, '\P{Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Blk=latinextd}', "");
    Expect(0, 43008, '\p{Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Blk=latinextd}', "");
    Expect(1, 43008, '\P{Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Blk=latinextd}', "");
    Expect(1, 43007, '\p{Blk=-Latin_ext_D}', "");
    Expect(0, 43007, '\p{^Blk=-Latin_ext_D}', "");
    Expect(0, 43007, '\P{Blk=-Latin_ext_D}', "");
    Expect(1, 43007, '\P{^Blk=-Latin_ext_D}', "");
    Expect(0, 43008, '\p{Blk=-Latin_ext_D}', "");
    Expect(1, 43008, '\p{^Blk=-Latin_ext_D}', "");
    Expect(1, 43008, '\P{Blk=-Latin_ext_D}', "");
    Expect(0, 43008, '\P{^Blk=-Latin_ext_D}', "");
    Error('\p{Is_Block:	 /a/Latin_Extended_d}');
    Error('\P{Is_Block:	 /a/Latin_Extended_d}');
    Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Is_Block=_	latin_Extended_d}', "");
    Expect(0, 43007, '\p{^Is_Block=_	latin_Extended_d}', "");
    Expect(0, 43007, '\P{Is_Block=_	latin_Extended_d}', "");
    Expect(1, 43007, '\P{^Is_Block=_	latin_Extended_d}', "");
    Expect(0, 43008, '\p{Is_Block=_	latin_Extended_d}', "");
    Expect(1, 43008, '\p{^Is_Block=_	latin_Extended_d}', "");
    Expect(1, 43008, '\P{Is_Block=_	latin_Extended_d}', "");
    Expect(0, 43008, '\P{^Is_Block=_	latin_Extended_d}', "");
    Error('\p{Is_Blk=	_Latin_EXT_D/a/}');
    Error('\P{Is_Blk=	_Latin_EXT_D/a/}');
    Expect(1, 43007, '\p{Is_Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Is_Blk=latinextd}', "");
    Expect(0, 43007, '\P{Is_Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Is_Blk=latinextd}', "");
    Expect(0, 43008, '\p{Is_Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Is_Blk=latinextd}', "");
    Expect(1, 43008, '\P{Is_Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Is_Blk=latinextd}', "");
    Expect(1, 43007, '\p{Is_Blk=-latin_ext_D}', "");
    Expect(0, 43007, '\p{^Is_Blk=-latin_ext_D}', "");
    Expect(0, 43007, '\P{Is_Blk=-latin_ext_D}', "");
    Expect(1, 43007, '\P{^Is_Blk=-latin_ext_D}', "");
    Expect(0, 43008, '\p{Is_Blk=-latin_ext_D}', "");
    Expect(1, 43008, '\p{^Is_Blk=-latin_ext_D}', "");
    Expect(1, 43008, '\P{Is_Blk=-latin_ext_D}', "");
    Expect(0, 43008, '\P{^Is_Blk=-latin_ext_D}', "");
    Error('\p{Block:/a/_	Latin_EXTENDED_e}');
    Error('\P{Block:/a/_	Latin_EXTENDED_e}');
    Expect(1, 43887, '\p{Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Block=latinextendede}', "");
    Expect(0, 43887, '\P{Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Block=latinextendede}', "");
    Expect(0, 43888, '\p{Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Block=latinextendede}', "");
    Expect(1, 43888, '\P{Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Block=latinextendede}', "");
    Expect(1, 43887, '\p{Block=  Latin_extended_e}', "");
    Expect(0, 43887, '\p{^Block=  Latin_extended_e}', "");
    Expect(0, 43887, '\P{Block=  Latin_extended_e}', "");
    Expect(1, 43887, '\P{^Block=  Latin_extended_e}', "");
    Expect(0, 43888, '\p{Block=  Latin_extended_e}', "");
    Expect(1, 43888, '\p{^Block=  Latin_extended_e}', "");
    Expect(1, 43888, '\P{Block=  Latin_extended_e}', "");
    Expect(0, 43888, '\P{^Block=  Latin_extended_e}', "");
    Error('\p{Blk= :=Latin_ext_E}');
    Error('\P{Blk= :=Latin_ext_E}');
    Expect(1, 43887, '\p{Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Blk=latinexte}', "");
    Expect(0, 43887, '\P{Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Blk=latinexte}', "");
    Expect(0, 43888, '\p{Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Blk=latinexte}', "");
    Expect(1, 43888, '\P{Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Blk=latinexte}', "");
    Expect(1, 43887, '\p{Blk=LATIN_EXT_E}', "");
    Expect(0, 43887, '\p{^Blk=LATIN_EXT_E}', "");
    Expect(0, 43887, '\P{Blk=LATIN_EXT_E}', "");
    Expect(1, 43887, '\P{^Blk=LATIN_EXT_E}', "");
    Expect(0, 43888, '\p{Blk=LATIN_EXT_E}', "");
    Expect(1, 43888, '\p{^Blk=LATIN_EXT_E}', "");
    Expect(1, 43888, '\P{Blk=LATIN_EXT_E}', "");
    Expect(0, 43888, '\P{^Blk=LATIN_EXT_E}', "");
    Error('\p{Is_Block=/a/	_Latin_EXTENDED_E}');
    Error('\P{Is_Block=/a/	_Latin_EXTENDED_E}');
    Expect(1, 43887, '\p{Is_Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Is_Block=latinextendede}', "");
    Expect(0, 43887, '\P{Is_Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Is_Block=latinextendede}', "");
    Expect(0, 43888, '\p{Is_Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Is_Block=latinextendede}', "");
    Expect(1, 43888, '\P{Is_Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Is_Block=latinextendede}', "");
    Expect(1, 43887, '\p{Is_Block=	LATIN_extended_E}', "");
    Expect(0, 43887, '\p{^Is_Block=	LATIN_extended_E}', "");
    Expect(0, 43887, '\P{Is_Block=	LATIN_extended_E}', "");
    Expect(1, 43887, '\P{^Is_Block=	LATIN_extended_E}', "");
    Expect(0, 43888, '\p{Is_Block=	LATIN_extended_E}', "");
    Expect(1, 43888, '\p{^Is_Block=	LATIN_extended_E}', "");
    Expect(1, 43888, '\P{Is_Block=	LATIN_extended_E}', "");
    Expect(0, 43888, '\P{^Is_Block=	LATIN_extended_E}', "");
    Error('\p{Is_Blk=/a/Latin_ext_e}');
    Error('\P{Is_Blk=/a/Latin_ext_e}');
    Expect(1, 43887, '\p{Is_Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Is_Blk=latinexte}', "");
    Expect(0, 43887, '\P{Is_Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Is_Blk=latinexte}', "");
    Expect(0, 43888, '\p{Is_Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Is_Blk=latinexte}', "");
    Expect(1, 43888, '\P{Is_Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Is_Blk=latinexte}', "");
    Expect(1, 43887, '\p{Is_Blk=_LATIN_Ext_E}', "");
    Expect(0, 43887, '\p{^Is_Blk=_LATIN_Ext_E}', "");
    Expect(0, 43887, '\P{Is_Blk=_LATIN_Ext_E}', "");
    Expect(1, 43887, '\P{^Is_Blk=_LATIN_Ext_E}', "");
    Expect(0, 43888, '\p{Is_Blk=_LATIN_Ext_E}', "");
    Expect(1, 43888, '\p{^Is_Blk=_LATIN_Ext_E}', "");
    Expect(1, 43888, '\P{Is_Blk=_LATIN_Ext_E}', "");
    Expect(0, 43888, '\P{^Is_Blk=_LATIN_Ext_E}', "");
    Error('\p{Block=	_Lepcha/a/}');
    Error('\P{Block=	_Lepcha/a/}');
    Expect(1, 7247, '\p{Block=lepcha}', "");
    Expect(0, 7247, '\p{^Block=lepcha}', "");
    Expect(0, 7247, '\P{Block=lepcha}', "");
    Expect(1, 7247, '\P{^Block=lepcha}', "");
    Expect(0, 7248, '\p{Block=lepcha}', "");
    Expect(1, 7248, '\p{^Block=lepcha}', "");
    Expect(1, 7248, '\P{Block=lepcha}', "");
    Expect(0, 7248, '\P{^Block=lepcha}', "");
    Expect(1, 7247, '\p{Block=_	Lepcha}', "");
    Expect(0, 7247, '\p{^Block=_	Lepcha}', "");
    Expect(0, 7247, '\P{Block=_	Lepcha}', "");
    Expect(1, 7247, '\P{^Block=_	Lepcha}', "");
    Expect(0, 7248, '\p{Block=_	Lepcha}', "");
    Expect(1, 7248, '\p{^Block=_	Lepcha}', "");
    Expect(1, 7248, '\P{Block=_	Lepcha}', "");
    Expect(0, 7248, '\P{^Block=_	Lepcha}', "");
    Error('\p{Blk=:= -LEPCHA}');
    Error('\P{Blk=:= -LEPCHA}');
    Expect(1, 7247, '\p{Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Blk=lepcha}', "");
    Expect(0, 7247, '\P{Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Blk=lepcha}', "");
    Expect(0, 7248, '\p{Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Blk=lepcha}', "");
    Expect(1, 7248, '\P{Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Blk=lepcha}', "");
    Expect(1, 7247, '\p{Blk= Lepcha}', "");
    Expect(0, 7247, '\p{^Blk= Lepcha}', "");
    Expect(0, 7247, '\P{Blk= Lepcha}', "");
    Expect(1, 7247, '\P{^Blk= Lepcha}', "");
    Expect(0, 7248, '\p{Blk= Lepcha}', "");
    Expect(1, 7248, '\p{^Blk= Lepcha}', "");
    Expect(1, 7248, '\P{Blk= Lepcha}', "");
    Expect(0, 7248, '\P{^Blk= Lepcha}', "");
    Error('\p{Is_Block= :=LEPCHA}');
    Error('\P{Is_Block= :=LEPCHA}');
    Expect(1, 7247, '\p{Is_Block=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=lepcha}', "");
    Expect(1, 7247, '\p{Is_Block= _LEPCHA}', "");
    Expect(0, 7247, '\p{^Is_Block= _LEPCHA}', "");
    Expect(0, 7247, '\P{Is_Block= _LEPCHA}', "");
    Expect(1, 7247, '\P{^Is_Block= _LEPCHA}', "");
    Expect(0, 7248, '\p{Is_Block= _LEPCHA}', "");
    Expect(1, 7248, '\p{^Is_Block= _LEPCHA}', "");
    Expect(1, 7248, '\P{Is_Block= _LEPCHA}', "");
    Expect(0, 7248, '\P{^Is_Block= _LEPCHA}', "");
    Error('\p{Is_Blk=/a/	_Lepcha}');
    Error('\P{Is_Blk=/a/	_Lepcha}');
    Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=lepcha}', "");
    Expect(1, 7247, '\p{Is_Blk=_	LEPCHA}', "");
    Expect(0, 7247, '\p{^Is_Blk=_	LEPCHA}', "");
    Expect(0, 7247, '\P{Is_Blk=_	LEPCHA}', "");
    Expect(1, 7247, '\P{^Is_Blk=_	LEPCHA}', "");
    Expect(0, 7248, '\p{Is_Blk=_	LEPCHA}', "");
    Expect(1, 7248, '\p{^Is_Blk=_	LEPCHA}', "");
    Expect(1, 7248, '\P{Is_Blk=_	LEPCHA}', "");
    Expect(0, 7248, '\P{^Is_Blk=_	LEPCHA}', "");
    Error('\p{Block=:=Letterlike_symbols}');
    Error('\P{Block=:=Letterlike_symbols}');
    Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Block=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\p{^Block=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\P{Block=-LETTERLIKE_Symbols}', "");
    Expect(1, 8527, '\P{^Block=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\p{Block=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\p{^Block=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\P{Block=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\P{^Block=-LETTERLIKE_Symbols}', "");
    Error('\p{Blk=:=--letterlike_Symbols}');
    Error('\P{Blk=:=--letterlike_Symbols}');
    Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Blk=LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\p{^Blk=LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\P{Blk=LETTERLIKE_symbols}', "");
    Expect(1, 8527, '\P{^Blk=LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\p{Blk=LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\p{^Blk=LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\P{Blk=LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\P{^Blk=LETTERLIKE_symbols}', "");
    Error('\p{Is_Block=_Letterlike_Symbols:=}');
    Error('\P{Is_Block=_Letterlike_Symbols:=}');
    Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Block=		letterlike_symbols}', "");
    Expect(0, 8527, '\p{^Is_Block=		letterlike_symbols}', "");
    Expect(0, 8527, '\P{Is_Block=		letterlike_symbols}', "");
    Expect(1, 8527, '\P{^Is_Block=		letterlike_symbols}', "");
    Expect(0, 8528, '\p{Is_Block=		letterlike_symbols}', "");
    Expect(1, 8528, '\p{^Is_Block=		letterlike_symbols}', "");
    Expect(1, 8528, '\P{Is_Block=		letterlike_symbols}', "");
    Expect(0, 8528, '\P{^Is_Block=		letterlike_symbols}', "");
    Error('\p{Is_Blk=  Letterlike_symbols/a/}');
    Error('\P{Is_Blk=  Letterlike_symbols/a/}');
    Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\P{Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\p{Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\P{Is_Blk=	_LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=	_LETTERLIKE_Symbols}', "");
    Error('\p{Block=:=-Limbu}');
    Error('\P{Block=:=-Limbu}');
    Expect(1, 6479, '\p{Block:	limbu}', "");
    Expect(0, 6479, '\p{^Block:	limbu}', "");
    Expect(0, 6479, '\P{Block:	limbu}', "");
    Expect(1, 6479, '\P{^Block:	limbu}', "");
    Expect(0, 6480, '\p{Block:	limbu}', "");
    Expect(1, 6480, '\p{^Block:	limbu}', "");
    Expect(1, 6480, '\P{Block:	limbu}', "");
    Expect(0, 6480, '\P{^Block:	limbu}', "");
    Expect(1, 6479, '\p{Block=_ Limbu}', "");
    Expect(0, 6479, '\p{^Block=_ Limbu}', "");
    Expect(0, 6479, '\P{Block=_ Limbu}', "");
    Expect(1, 6479, '\P{^Block=_ Limbu}', "");
    Expect(0, 6480, '\p{Block=_ Limbu}', "");
    Expect(1, 6480, '\p{^Block=_ Limbu}', "");
    Expect(1, 6480, '\P{Block=_ Limbu}', "");
    Expect(0, 6480, '\P{^Block=_ Limbu}', "");
    Error('\p{Blk=_LIMBU:=}');
    Error('\P{Blk=_LIMBU:=}');
    Expect(1, 6479, '\p{Blk=limbu}', "");
    Expect(0, 6479, '\p{^Blk=limbu}', "");
    Expect(0, 6479, '\P{Blk=limbu}', "");
    Expect(1, 6479, '\P{^Blk=limbu}', "");
    Expect(0, 6480, '\p{Blk=limbu}', "");
    Expect(1, 6480, '\p{^Blk=limbu}', "");
    Expect(1, 6480, '\P{Blk=limbu}', "");
    Expect(0, 6480, '\P{^Blk=limbu}', "");
    Expect(1, 6479, '\p{Blk=-limbu}', "");
    Expect(0, 6479, '\p{^Blk=-limbu}', "");
    Expect(0, 6479, '\P{Blk=-limbu}', "");
    Expect(1, 6479, '\P{^Blk=-limbu}', "");
    Expect(0, 6480, '\p{Blk=-limbu}', "");
    Expect(1, 6480, '\p{^Blk=-limbu}', "");
    Expect(1, 6480, '\P{Blk=-limbu}', "");
    Expect(0, 6480, '\P{^Blk=-limbu}', "");
    Error('\p{Is_Block=__Limbu/a/}');
    Error('\P{Is_Block=__Limbu/a/}');
    Expect(1, 6479, '\p{Is_Block=limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=limbu}', "");
    Expect(0, 6479, '\P{Is_Block=limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=limbu}', "");
    Expect(0, 6480, '\p{Is_Block=limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=limbu}', "");
    Expect(1, 6480, '\P{Is_Block=limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=limbu}', "");
    Expect(1, 6479, '\p{Is_Block=- limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=- limbu}', "");
    Expect(0, 6479, '\P{Is_Block=- limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=- limbu}', "");
    Expect(0, 6480, '\p{Is_Block=- limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=- limbu}', "");
    Expect(1, 6480, '\P{Is_Block=- limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=- limbu}', "");
    Error('\p{Is_Blk=/a/Limbu}');
    Error('\P{Is_Blk=/a/Limbu}');
    Expect(1, 6479, '\p{Is_Blk=limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=limbu}', "");
    Expect(1, 6479, '\p{Is_Blk=_ LIMBU}', "");
    Expect(0, 6479, '\p{^Is_Blk=_ LIMBU}', "");
    Expect(0, 6479, '\P{Is_Blk=_ LIMBU}', "");
    Expect(1, 6479, '\P{^Is_Blk=_ LIMBU}', "");
    Expect(0, 6480, '\p{Is_Blk=_ LIMBU}', "");
    Expect(1, 6480, '\p{^Is_Blk=_ LIMBU}', "");
    Expect(1, 6480, '\P{Is_Blk=_ LIMBU}', "");
    Expect(0, 6480, '\P{^Is_Blk=_ LIMBU}', "");
    Error('\p{Block:   	_Linear_a/a/}');
    Error('\P{Block:   	_Linear_a/a/}');
    Expect(1, 67455, '\p{Block=lineara}', "");
    Expect(0, 67455, '\p{^Block=lineara}', "");
    Expect(0, 67455, '\P{Block=lineara}', "");
    Expect(1, 67455, '\P{^Block=lineara}', "");
    Expect(0, 67456, '\p{Block=lineara}', "");
    Expect(1, 67456, '\p{^Block=lineara}', "");
    Expect(1, 67456, '\P{Block=lineara}', "");
    Expect(0, 67456, '\P{^Block=lineara}', "");
    Expect(1, 67455, '\p{Block:   	Linear_A}', "");
    Expect(0, 67455, '\p{^Block:   	Linear_A}', "");
    Expect(0, 67455, '\P{Block:   	Linear_A}', "");
    Expect(1, 67455, '\P{^Block:   	Linear_A}', "");
    Expect(0, 67456, '\p{Block:   	Linear_A}', "");
    Expect(1, 67456, '\p{^Block:   	Linear_A}', "");
    Expect(1, 67456, '\P{Block:   	Linear_A}', "");
    Expect(0, 67456, '\P{^Block:   	Linear_A}', "");
    Error('\p{Blk:  	Linear_A:=}');
    Error('\P{Blk:  	Linear_A:=}');
    Expect(1, 67455, '\p{Blk=lineara}', "");
    Expect(0, 67455, '\p{^Blk=lineara}', "");
    Expect(0, 67455, '\P{Blk=lineara}', "");
    Expect(1, 67455, '\P{^Blk=lineara}', "");
    Expect(0, 67456, '\p{Blk=lineara}', "");
    Expect(1, 67456, '\p{^Blk=lineara}', "");
    Expect(1, 67456, '\P{Blk=lineara}', "");
    Expect(0, 67456, '\P{^Blk=lineara}', "");
    Expect(1, 67455, '\p{Blk=Linear_A}', "");
    Expect(0, 67455, '\p{^Blk=Linear_A}', "");
    Expect(0, 67455, '\P{Blk=Linear_A}', "");
    Expect(1, 67455, '\P{^Blk=Linear_A}', "");
    Expect(0, 67456, '\p{Blk=Linear_A}', "");
    Expect(1, 67456, '\p{^Blk=Linear_A}', "");
    Expect(1, 67456, '\P{Blk=Linear_A}', "");
    Expect(0, 67456, '\P{^Blk=Linear_A}', "");
    Error('\p{Is_Block: 	-LINEAR_A:=}');
    Error('\P{Is_Block: 	-LINEAR_A:=}');
    Expect(1, 67455, '\p{Is_Block=lineara}', "");
    Expect(0, 67455, '\p{^Is_Block=lineara}', "");
    Expect(0, 67455, '\P{Is_Block=lineara}', "");
    Expect(1, 67455, '\P{^Is_Block=lineara}', "");
    Expect(0, 67456, '\p{Is_Block=lineara}', "");
    Expect(1, 67456, '\p{^Is_Block=lineara}', "");
    Expect(1, 67456, '\P{Is_Block=lineara}', "");
    Expect(0, 67456, '\P{^Is_Block=lineara}', "");
    Expect(1, 67455, '\p{Is_Block=	_linear_a}', "");
    Expect(0, 67455, '\p{^Is_Block=	_linear_a}', "");
    Expect(0, 67455, '\P{Is_Block=	_linear_a}', "");
    Expect(1, 67455, '\P{^Is_Block=	_linear_a}', "");
    Expect(0, 67456, '\p{Is_Block=	_linear_a}', "");
    Expect(1, 67456, '\p{^Is_Block=	_linear_a}', "");
    Expect(1, 67456, '\P{Is_Block=	_linear_a}', "");
    Expect(0, 67456, '\P{^Is_Block=	_linear_a}', "");
    Error('\p{Is_Blk=:=	Linear_a}');
    Error('\P{Is_Blk=:=	Linear_a}');
    Expect(1, 67455, '\p{Is_Blk=lineara}', "");
    Expect(0, 67455, '\p{^Is_Blk=lineara}', "");
    Expect(0, 67455, '\P{Is_Blk=lineara}', "");
    Expect(1, 67455, '\P{^Is_Blk=lineara}', "");
    Expect(0, 67456, '\p{Is_Blk=lineara}', "");
    Expect(1, 67456, '\p{^Is_Blk=lineara}', "");
    Expect(1, 67456, '\P{Is_Blk=lineara}', "");
    Expect(0, 67456, '\P{^Is_Blk=lineara}', "");
    Expect(1, 67455, '\p{Is_Blk:   -	Linear_a}', "");
    Expect(0, 67455, '\p{^Is_Blk:   -	Linear_a}', "");
    Expect(0, 67455, '\P{Is_Blk:   -	Linear_a}', "");
    Expect(1, 67455, '\P{^Is_Blk:   -	Linear_a}', "");
    Expect(0, 67456, '\p{Is_Blk:   -	Linear_a}', "");
    Expect(1, 67456, '\p{^Is_Blk:   -	Linear_a}', "");
    Expect(1, 67456, '\P{Is_Blk:   -	Linear_a}', "");
    Expect(0, 67456, '\P{^Is_Blk:   -	Linear_a}', "");
    Error('\p{Block:	_ LINEAR_B_Ideograms/a/}');
    Error('\P{Block:	_ LINEAR_B_Ideograms/a/}');
    Expect(1, 65791, '\p{Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Block=-Linear_B_ideograms}', "");
    Expect(0, 65791, '\p{^Block=-Linear_B_ideograms}', "");
    Expect(0, 65791, '\P{Block=-Linear_B_ideograms}', "");
    Expect(1, 65791, '\P{^Block=-Linear_B_ideograms}', "");
    Expect(0, 65792, '\p{Block=-Linear_B_ideograms}', "");
    Expect(1, 65792, '\p{^Block=-Linear_B_ideograms}', "");
    Expect(1, 65792, '\P{Block=-Linear_B_ideograms}', "");
    Expect(0, 65792, '\P{^Block=-Linear_B_ideograms}', "");
    Error('\p{Blk:-_LINEAR_b_IDEOGRAMS:=}');
    Error('\P{Blk:-_LINEAR_b_IDEOGRAMS:=}');
    Expect(1, 65791, '\p{Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Blk=	 linear_B_Ideograms}', "");
    Expect(0, 65791, '\p{^Blk=	 linear_B_Ideograms}', "");
    Expect(0, 65791, '\P{Blk=	 linear_B_Ideograms}', "");
    Expect(1, 65791, '\P{^Blk=	 linear_B_Ideograms}', "");
    Expect(0, 65792, '\p{Blk=	 linear_B_Ideograms}', "");
    Expect(1, 65792, '\p{^Blk=	 linear_B_Ideograms}', "");
    Expect(1, 65792, '\P{Blk=	 linear_B_Ideograms}', "");
    Expect(0, 65792, '\P{^Blk=	 linear_B_Ideograms}', "");
    Error('\p{Is_Block= LINEAR_B_Ideograms:=}');
    Error('\P{Is_Block= LINEAR_B_Ideograms:=}');
    Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(0, 65791, '\P{Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(0, 65792, '\p{Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(1, 65792, '\P{Is_Block=	_LINEAR_B_Ideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=	_LINEAR_B_Ideograms}', "");
    Error('\p{Is_Blk=_/a/Linear_B_Ideograms}');
    Error('\P{Is_Blk=_/a/Linear_B_Ideograms}');
    Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Blk= _Linear_B_Ideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk= _Linear_B_Ideograms}', "");
    Expect(0, 65791, '\P{Is_Blk= _Linear_B_Ideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk= _Linear_B_Ideograms}', "");
    Expect(0, 65792, '\p{Is_Blk= _Linear_B_Ideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk= _Linear_B_Ideograms}', "");
    Expect(1, 65792, '\P{Is_Blk= _Linear_B_Ideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk= _Linear_B_Ideograms}', "");
    Error('\p{Block= LINEAR_B_Syllabary/a/}');
    Error('\P{Block= LINEAR_B_Syllabary/a/}');
    Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Block=	Linear_b_Syllabary}', "");
    Expect(0, 65663, '\p{^Block=	Linear_b_Syllabary}', "");
    Expect(0, 65663, '\P{Block=	Linear_b_Syllabary}', "");
    Expect(1, 65663, '\P{^Block=	Linear_b_Syllabary}', "");
    Expect(0, 65664, '\p{Block=	Linear_b_Syllabary}', "");
    Expect(1, 65664, '\p{^Block=	Linear_b_Syllabary}', "");
    Expect(1, 65664, '\P{Block=	Linear_b_Syllabary}', "");
    Expect(0, 65664, '\P{^Block=	Linear_b_Syllabary}', "");
    Error('\p{Blk=-	LINEAR_B_syllabary:=}');
    Error('\P{Blk=-	LINEAR_B_syllabary:=}');
    Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\p{^Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\P{Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(1, 65663, '\P{^Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\p{Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\p{^Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\P{Blk= -LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\P{^Blk= -LINEAR_B_SYLLABARY}', "");
    Error('\p{Is_Block=	:=Linear_B_Syllabary}');
    Error('\P{Is_Block=	:=Linear_B_Syllabary}');
    Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(0, 65663, '\p{^Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(0, 65663, '\P{Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(1, 65663, '\P{^Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(0, 65664, '\p{Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(1, 65664, '\p{^Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(1, 65664, '\P{Is_Block=-	linear_B_SYLLABARY}', "");
    Expect(0, 65664, '\P{^Is_Block=-	linear_B_SYLLABARY}', "");
    Error('\p{Is_Blk= -Linear_B_SYLLABARY/a/}');
    Error('\P{Is_Blk= -Linear_B_SYLLABARY/a/}');
    Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\p{^Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(0, 65663, '\P{Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(1, 65663, '\P{^Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\p{Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\p{^Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(1, 65664, '\P{Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Expect(0, 65664, '\P{^Is_Blk=__LINEAR_B_SYLLABARY}', "");
    Error('\p{Block=-	LISU/a/}');
    Error('\P{Block=-	LISU/a/}');
    Expect(1, 42239, '\p{Block=lisu}', "");
    Expect(0, 42239, '\p{^Block=lisu}', "");
    Expect(0, 42239, '\P{Block=lisu}', "");
    Expect(1, 42239, '\P{^Block=lisu}', "");
    Expect(0, 42240, '\p{Block=lisu}', "");
    Expect(1, 42240, '\p{^Block=lisu}', "");
    Expect(1, 42240, '\P{Block=lisu}', "");
    Expect(0, 42240, '\P{^Block=lisu}', "");
    Expect(1, 42239, '\p{Block=	 LISU}', "");
    Expect(0, 42239, '\p{^Block=	 LISU}', "");
    Expect(0, 42239, '\P{Block=	 LISU}', "");
    Expect(1, 42239, '\P{^Block=	 LISU}', "");
    Expect(0, 42240, '\p{Block=	 LISU}', "");
    Expect(1, 42240, '\p{^Block=	 LISU}', "");
    Expect(1, 42240, '\P{Block=	 LISU}', "");
    Expect(0, 42240, '\P{^Block=	 LISU}', "");
    Error('\p{Blk=_/a/Lisu}');
    Error('\P{Blk=_/a/Lisu}');
    Expect(1, 42239, '\p{Blk:	lisu}', "");
    Expect(0, 42239, '\p{^Blk:	lisu}', "");
    Expect(0, 42239, '\P{Blk:	lisu}', "");
    Expect(1, 42239, '\P{^Blk:	lisu}', "");
    Expect(0, 42240, '\p{Blk:	lisu}', "");
    Expect(1, 42240, '\p{^Blk:	lisu}', "");
    Expect(1, 42240, '\P{Blk:	lisu}', "");
    Expect(0, 42240, '\P{^Blk:	lisu}', "");
    Expect(1, 42239, '\p{Blk=_lisu}', "");
    Expect(0, 42239, '\p{^Blk=_lisu}', "");
    Expect(0, 42239, '\P{Blk=_lisu}', "");
    Expect(1, 42239, '\P{^Blk=_lisu}', "");
    Expect(0, 42240, '\p{Blk=_lisu}', "");
    Expect(1, 42240, '\p{^Blk=_lisu}', "");
    Expect(1, 42240, '\P{Blk=_lisu}', "");
    Expect(0, 42240, '\P{^Blk=_lisu}', "");
    Error('\p{Is_Block=/a/--LISU}');
    Error('\P{Is_Block=/a/--LISU}');
    Expect(1, 42239, '\p{Is_Block=lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=lisu}', "");
    Expect(0, 42239, '\P{Is_Block=lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=lisu}', "");
    Expect(0, 42240, '\p{Is_Block=lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=lisu}', "");
    Expect(1, 42240, '\P{Is_Block=lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=lisu}', "");
    Expect(1, 42239, '\p{Is_Block=_-Lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=_-Lisu}', "");
    Expect(0, 42239, '\P{Is_Block=_-Lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=_-Lisu}', "");
    Expect(0, 42240, '\p{Is_Block=_-Lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=_-Lisu}', "");
    Expect(1, 42240, '\P{Is_Block=_-Lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=_-Lisu}', "");
    Error('\p{Is_Blk=:=_ Lisu}');
    Error('\P{Is_Blk=:=_ Lisu}');
    Expect(1, 42239, '\p{Is_Blk: lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk: lisu}', "");
    Expect(0, 42239, '\P{Is_Blk: lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk: lisu}', "");
    Expect(0, 42240, '\p{Is_Blk: lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk: lisu}', "");
    Expect(1, 42240, '\P{Is_Blk: lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk: lisu}', "");
    Expect(1, 42239, '\p{Is_Blk= _Lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk= _Lisu}', "");
    Expect(0, 42239, '\P{Is_Blk= _Lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk= _Lisu}', "");
    Expect(0, 42240, '\p{Is_Blk= _Lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk= _Lisu}', "");
    Expect(1, 42240, '\P{Is_Blk= _Lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk= _Lisu}', "");
    Error('\p{Block:-LOW_Surrogates:=}');
    Error('\P{Block:-LOW_Surrogates:=}');
    Expect(1, 57343, '\p{Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Block=	-low_Surrogates}', "");
    Expect(0, 57343, '\p{^Block=	-low_Surrogates}', "");
    Expect(0, 57343, '\P{Block=	-low_Surrogates}', "");
    Expect(1, 57343, '\P{^Block=	-low_Surrogates}', "");
    Expect(0, 57344, '\p{Block=	-low_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=	-low_Surrogates}', "");
    Expect(1, 57344, '\P{Block=	-low_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=	-low_Surrogates}', "");
    Error('\p{Blk=- low_SURROGATES/a/}');
    Error('\P{Blk=- low_SURROGATES/a/}');
    Expect(1, 57343, '\p{Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Blk=		low_SURROGATES}', "");
    Expect(0, 57343, '\p{^Blk=		low_SURROGATES}', "");
    Expect(0, 57343, '\P{Blk=		low_SURROGATES}', "");
    Expect(1, 57343, '\P{^Blk=		low_SURROGATES}', "");
    Expect(0, 57344, '\p{Blk=		low_SURROGATES}', "");
    Expect(1, 57344, '\p{^Blk=		low_SURROGATES}', "");
    Expect(1, 57344, '\P{Blk=		low_SURROGATES}', "");
    Expect(0, 57344, '\P{^Blk=		low_SURROGATES}', "");
    Error('\p{Is_Block: 	Low_Surrogates:=}');
    Error('\P{Is_Block: 	Low_Surrogates:=}');
    Expect(1, 57343, '\p{Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Block=  Low_SURROGATES}', "");
    Expect(0, 57343, '\p{^Is_Block=  Low_SURROGATES}', "");
    Expect(0, 57343, '\P{Is_Block=  Low_SURROGATES}', "");
    Expect(1, 57343, '\P{^Is_Block=  Low_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block=  Low_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block=  Low_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block=  Low_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block=  Low_SURROGATES}', "");
    Error('\p{Is_Blk:/a/- Low_SURROGATES}');
    Error('\P{Is_Blk:/a/- Low_SURROGATES}');
    Expect(1, 57343, '\p{Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Blk=	-Low_SURROGATES}', "");
    Expect(0, 57343, '\p{^Is_Blk=	-Low_SURROGATES}', "");
    Expect(0, 57343, '\P{Is_Blk=	-Low_SURROGATES}', "");
    Expect(1, 57343, '\P{^Is_Blk=	-Low_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Blk=	-Low_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Blk=	-Low_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Blk=	-Low_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Blk=	-Low_SURROGATES}', "");
    Error('\p{Block=-/a/Lycian}');
    Error('\P{Block=-/a/Lycian}');
    Expect(1, 66207, '\p{Block=lycian}', "");
    Expect(0, 66207, '\p{^Block=lycian}', "");
    Expect(0, 66207, '\P{Block=lycian}', "");
    Expect(1, 66207, '\P{^Block=lycian}', "");
    Expect(0, 66208, '\p{Block=lycian}', "");
    Expect(1, 66208, '\p{^Block=lycian}', "");
    Expect(1, 66208, '\P{Block=lycian}', "");
    Expect(0, 66208, '\P{^Block=lycian}', "");
    Expect(1, 66207, '\p{Block=	Lycian}', "");
    Expect(0, 66207, '\p{^Block=	Lycian}', "");
    Expect(0, 66207, '\P{Block=	Lycian}', "");
    Expect(1, 66207, '\P{^Block=	Lycian}', "");
    Expect(0, 66208, '\p{Block=	Lycian}', "");
    Expect(1, 66208, '\p{^Block=	Lycian}', "");
    Expect(1, 66208, '\P{Block=	Lycian}', "");
    Expect(0, 66208, '\P{^Block=	Lycian}', "");
    Error('\p{Blk=	-Lycian:=}');
    Error('\P{Blk=	-Lycian:=}');
    Expect(1, 66207, '\p{Blk=lycian}', "");
    Expect(0, 66207, '\p{^Blk=lycian}', "");
    Expect(0, 66207, '\P{Blk=lycian}', "");
    Expect(1, 66207, '\P{^Blk=lycian}', "");
    Expect(0, 66208, '\p{Blk=lycian}', "");
    Expect(1, 66208, '\p{^Blk=lycian}', "");
    Expect(1, 66208, '\P{Blk=lycian}', "");
    Expect(0, 66208, '\P{^Blk=lycian}', "");
    Expect(1, 66207, '\p{Blk=-	Lycian}', "");
    Expect(0, 66207, '\p{^Blk=-	Lycian}', "");
    Expect(0, 66207, '\P{Blk=-	Lycian}', "");
    Expect(1, 66207, '\P{^Blk=-	Lycian}', "");
    Expect(0, 66208, '\p{Blk=-	Lycian}', "");
    Expect(1, 66208, '\p{^Blk=-	Lycian}', "");
    Expect(1, 66208, '\P{Blk=-	Lycian}', "");
    Expect(0, 66208, '\P{^Blk=-	Lycian}', "");
    Error('\p{Is_Block=:=_ Lycian}');
    Error('\P{Is_Block=:=_ Lycian}');
    Expect(1, 66207, '\p{Is_Block=lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=lycian}', "");
    Expect(0, 66207, '\P{Is_Block=lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=lycian}', "");
    Expect(0, 66208, '\p{Is_Block=lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=lycian}', "");
    Expect(1, 66208, '\P{Is_Block=lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=lycian}', "");
    Expect(1, 66207, '\p{Is_Block=  Lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=  Lycian}', "");
    Expect(0, 66207, '\P{Is_Block=  Lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=  Lycian}', "");
    Expect(0, 66208, '\p{Is_Block=  Lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=  Lycian}', "");
    Expect(1, 66208, '\P{Is_Block=  Lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=  Lycian}', "");
    Error('\p{Is_Blk=_/a/lycian}');
    Error('\P{Is_Blk=_/a/lycian}');
    Expect(1, 66207, '\p{Is_Blk=lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=lycian}', "");
    Expect(1, 66207, '\p{Is_Blk=-Lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=-Lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=-Lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=-Lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=-Lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=-Lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=-Lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=-Lycian}', "");
    Error('\p{Block=	LYDIAN:=}');
    Error('\P{Block=	LYDIAN:=}');
    Expect(1, 67903, '\p{Block=lydian}', "");
    Expect(0, 67903, '\p{^Block=lydian}', "");
    Expect(0, 67903, '\P{Block=lydian}', "");
    Expect(1, 67903, '\P{^Block=lydian}', "");
    Expect(0, 67904, '\p{Block=lydian}', "");
    Expect(1, 67904, '\p{^Block=lydian}', "");
    Expect(1, 67904, '\P{Block=lydian}', "");
    Expect(0, 67904, '\P{^Block=lydian}', "");
    Expect(1, 67903, '\p{Block=- Lydian}', "");
    Expect(0, 67903, '\p{^Block=- Lydian}', "");
    Expect(0, 67903, '\P{Block=- Lydian}', "");
    Expect(1, 67903, '\P{^Block=- Lydian}', "");
    Expect(0, 67904, '\p{Block=- Lydian}', "");
    Expect(1, 67904, '\p{^Block=- Lydian}', "");
    Expect(1, 67904, '\P{Block=- Lydian}', "");
    Expect(0, 67904, '\P{^Block=- Lydian}', "");
    Error('\p{Blk=/a/ -LYDIAN}');
    Error('\P{Blk=/a/ -LYDIAN}');
    Expect(1, 67903, '\p{Blk=lydian}', "");
    Expect(0, 67903, '\p{^Blk=lydian}', "");
    Expect(0, 67903, '\P{Blk=lydian}', "");
    Expect(1, 67903, '\P{^Blk=lydian}', "");
    Expect(0, 67904, '\p{Blk=lydian}', "");
    Expect(1, 67904, '\p{^Blk=lydian}', "");
    Expect(1, 67904, '\P{Blk=lydian}', "");
    Expect(0, 67904, '\P{^Blk=lydian}', "");
    Expect(1, 67903, '\p{Blk=	Lydian}', "");
    Expect(0, 67903, '\p{^Blk=	Lydian}', "");
    Expect(0, 67903, '\P{Blk=	Lydian}', "");
    Expect(1, 67903, '\P{^Blk=	Lydian}', "");
    Expect(0, 67904, '\p{Blk=	Lydian}', "");
    Expect(1, 67904, '\p{^Blk=	Lydian}', "");
    Expect(1, 67904, '\P{Blk=	Lydian}', "");
    Expect(0, 67904, '\P{^Blk=	Lydian}', "");
    Error('\p{Is_Block=_Lydian:=}');
    Error('\P{Is_Block=_Lydian:=}');
    Expect(1, 67903, '\p{Is_Block=lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=lydian}', "");
    Expect(0, 67903, '\P{Is_Block=lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=lydian}', "");
    Expect(0, 67904, '\p{Is_Block=lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=lydian}', "");
    Expect(1, 67904, '\P{Is_Block=lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=lydian}', "");
    Expect(1, 67903, '\p{Is_Block=_	Lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=_	Lydian}', "");
    Expect(0, 67903, '\P{Is_Block=_	Lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=_	Lydian}', "");
    Expect(0, 67904, '\p{Is_Block=_	Lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=_	Lydian}', "");
    Expect(1, 67904, '\P{Is_Block=_	Lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=_	Lydian}', "");
    Error('\p{Is_Blk=/a/-	LYDIAN}');
    Error('\P{Is_Blk=/a/-	LYDIAN}');
    Expect(1, 67903, '\p{Is_Blk: lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk: lydian}', "");
    Expect(0, 67903, '\P{Is_Blk: lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk: lydian}', "");
    Expect(0, 67904, '\p{Is_Blk: lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk: lydian}', "");
    Expect(1, 67904, '\P{Is_Blk: lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk: lydian}', "");
    Expect(1, 67903, '\p{Is_Blk= 	Lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk= 	Lydian}', "");
    Expect(0, 67903, '\P{Is_Blk= 	Lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk= 	Lydian}', "");
    Expect(0, 67904, '\p{Is_Blk= 	Lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk= 	Lydian}', "");
    Expect(1, 67904, '\P{Is_Blk= 	Lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk= 	Lydian}', "");
    Error('\p{Block: Mahajani/a/}');
    Error('\P{Block: Mahajani/a/}');
    Expect(1, 70015, '\p{Block: mahajani}', "");
    Expect(0, 70015, '\p{^Block: mahajani}', "");
    Expect(0, 70015, '\P{Block: mahajani}', "");
    Expect(1, 70015, '\P{^Block: mahajani}', "");
    Expect(0, 70016, '\p{Block: mahajani}', "");
    Expect(1, 70016, '\p{^Block: mahajani}', "");
    Expect(1, 70016, '\P{Block: mahajani}', "");
    Expect(0, 70016, '\P{^Block: mahajani}', "");
    Expect(1, 70015, '\p{Block=_ Mahajani}', "");
    Expect(0, 70015, '\p{^Block=_ Mahajani}', "");
    Expect(0, 70015, '\P{Block=_ Mahajani}', "");
    Expect(1, 70015, '\P{^Block=_ Mahajani}', "");
    Expect(0, 70016, '\p{Block=_ Mahajani}', "");
    Expect(1, 70016, '\p{^Block=_ Mahajani}', "");
    Expect(1, 70016, '\P{Block=_ Mahajani}', "");
    Expect(0, 70016, '\P{^Block=_ Mahajani}', "");
    Error('\p{Blk::=  Mahajani}');
    Error('\P{Blk::=  Mahajani}');
    Expect(1, 70015, '\p{Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Blk=mahajani}', "");
    Expect(0, 70015, '\P{Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Blk=mahajani}', "");
    Expect(0, 70016, '\p{Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Blk=mahajani}', "");
    Expect(1, 70016, '\P{Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Blk=mahajani}', "");
    Expect(1, 70015, '\p{Blk=	 Mahajani}', "");
    Expect(0, 70015, '\p{^Blk=	 Mahajani}', "");
    Expect(0, 70015, '\P{Blk=	 Mahajani}', "");
    Expect(1, 70015, '\P{^Blk=	 Mahajani}', "");
    Expect(0, 70016, '\p{Blk=	 Mahajani}', "");
    Expect(1, 70016, '\p{^Blk=	 Mahajani}', "");
    Expect(1, 70016, '\P{Blk=	 Mahajani}', "");
    Expect(0, 70016, '\P{^Blk=	 Mahajani}', "");
    Error('\p{Is_Block=_/a/MAHAJANI}');
    Error('\P{Is_Block=_/a/MAHAJANI}');
    Expect(1, 70015, '\p{Is_Block=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=mahajani}', "");
    Expect(1, 70015, '\p{Is_Block=__Mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=__Mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=__Mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=__Mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=__Mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=__Mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=__Mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=__Mahajani}', "");
    Error('\p{Is_Blk=/a/	Mahajani}');
    Error('\P{Is_Blk=/a/	Mahajani}');
    Expect(1, 70015, '\p{Is_Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=mahajani}', "");
    Expect(1, 70015, '\p{Is_Blk=- Mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=- Mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=- Mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=- Mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=- Mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=- Mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=- Mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=- Mahajani}', "");
    Error('\p{Block=:=		mahjong_Tiles}');
    Error('\P{Block=:=		mahjong_Tiles}');
    Expect(1, 127023, '\p{Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Block= _Mahjong_tiles}', "");
    Expect(0, 127023, '\p{^Block= _Mahjong_tiles}', "");
    Expect(0, 127023, '\P{Block= _Mahjong_tiles}', "");
    Expect(1, 127023, '\P{^Block= _Mahjong_tiles}', "");
    Expect(0, 127024, '\p{Block= _Mahjong_tiles}', "");
    Expect(1, 127024, '\p{^Block= _Mahjong_tiles}', "");
    Expect(1, 127024, '\P{Block= _Mahjong_tiles}', "");
    Expect(0, 127024, '\P{^Block= _Mahjong_tiles}', "");
    Error('\p{Blk=_Mahjong:=}');
    Error('\P{Blk=_Mahjong:=}');
    Expect(1, 127023, '\p{Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Blk=mahjong}', "");
    Expect(0, 127023, '\P{Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Blk=mahjong}', "");
    Expect(0, 127024, '\p{Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Blk=mahjong}', "");
    Expect(1, 127024, '\P{Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Blk=mahjong}', "");
    Expect(1, 127023, '\p{Blk=	_mahjong}', "");
    Expect(0, 127023, '\p{^Blk=	_mahjong}', "");
    Expect(0, 127023, '\P{Blk=	_mahjong}', "");
    Expect(1, 127023, '\P{^Blk=	_mahjong}', "");
    Expect(0, 127024, '\p{Blk=	_mahjong}', "");
    Expect(1, 127024, '\p{^Blk=	_mahjong}', "");
    Expect(1, 127024, '\P{Blk=	_mahjong}', "");
    Expect(0, 127024, '\P{^Blk=	_mahjong}', "");
    Error('\p{Is_Block=-MAHJONG_TILES/a/}');
    Error('\P{Is_Block=-MAHJONG_TILES/a/}');
    Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Is_Block=_Mahjong_tiles}', "");
    Expect(0, 127023, '\p{^Is_Block=_Mahjong_tiles}', "");
    Expect(0, 127023, '\P{Is_Block=_Mahjong_tiles}', "");
    Expect(1, 127023, '\P{^Is_Block=_Mahjong_tiles}', "");
    Expect(0, 127024, '\p{Is_Block=_Mahjong_tiles}', "");
    Expect(1, 127024, '\p{^Is_Block=_Mahjong_tiles}', "");
    Expect(1, 127024, '\P{Is_Block=_Mahjong_tiles}', "");
    Expect(0, 127024, '\P{^Is_Block=_Mahjong_tiles}', "");
    Error('\p{Is_Blk=:= Mahjong}');
    Error('\P{Is_Blk=:= Mahjong}');
    Expect(1, 127023, '\p{Is_Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk=mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk=mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk=mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk=mahjong}', "");
    Expect(1, 127023, '\p{Is_Blk:	 MAHJONG}', "");
    Expect(0, 127023, '\p{^Is_Blk:	 MAHJONG}', "");
    Expect(0, 127023, '\P{Is_Blk:	 MAHJONG}', "");
    Expect(1, 127023, '\P{^Is_Blk:	 MAHJONG}', "");
    Expect(0, 127024, '\p{Is_Blk:	 MAHJONG}', "");
    Expect(1, 127024, '\p{^Is_Blk:	 MAHJONG}', "");
    Expect(1, 127024, '\P{Is_Blk:	 MAHJONG}', "");
    Expect(0, 127024, '\P{^Is_Blk:	 MAHJONG}', "");
    Error('\p{Block=	malayalam/a/}');
    Error('\P{Block=	malayalam/a/}');
    Expect(1, 3455, '\p{Block=malayalam}', "");
    Expect(0, 3455, '\p{^Block=malayalam}', "");
    Expect(0, 3455, '\P{Block=malayalam}', "");
    Expect(1, 3455, '\P{^Block=malayalam}', "");
    Expect(0, 3456, '\p{Block=malayalam}', "");
    Expect(1, 3456, '\p{^Block=malayalam}', "");
    Expect(1, 3456, '\P{Block=malayalam}', "");
    Expect(0, 3456, '\P{^Block=malayalam}', "");
    Expect(1, 3455, '\p{Block= _malayalam}', "");
    Expect(0, 3455, '\p{^Block= _malayalam}', "");
    Expect(0, 3455, '\P{Block= _malayalam}', "");
    Expect(1, 3455, '\P{^Block= _malayalam}', "");
    Expect(0, 3456, '\p{Block= _malayalam}', "");
    Expect(1, 3456, '\p{^Block= _malayalam}', "");
    Expect(1, 3456, '\P{Block= _malayalam}', "");
    Expect(0, 3456, '\P{^Block= _malayalam}', "");
    Error('\p{Blk=		malayalam:=}');
    Error('\P{Blk=		malayalam:=}');
    Expect(1, 3455, '\p{Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Blk=malayalam}', "");
    Expect(0, 3455, '\P{Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Blk=malayalam}', "");
    Expect(0, 3456, '\p{Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Blk=malayalam}', "");
    Expect(1, 3456, '\P{Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Blk=malayalam}', "");
    Expect(1, 3455, '\p{Blk=	-Malayalam}', "");
    Expect(0, 3455, '\p{^Blk=	-Malayalam}', "");
    Expect(0, 3455, '\P{Blk=	-Malayalam}', "");
    Expect(1, 3455, '\P{^Blk=	-Malayalam}', "");
    Expect(0, 3456, '\p{Blk=	-Malayalam}', "");
    Expect(1, 3456, '\p{^Blk=	-Malayalam}', "");
    Expect(1, 3456, '\P{Blk=	-Malayalam}', "");
    Expect(0, 3456, '\P{^Blk=	-Malayalam}', "");
    Error('\p{Is_Block=:=MALAYALAM}');
    Error('\P{Is_Block=:=MALAYALAM}');
    Expect(1, 3455, '\p{Is_Block=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=malayalam}', "");
    Expect(1, 3455, '\p{Is_Block=		Malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=		Malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=		Malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=		Malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=		Malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=		Malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=		Malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=		Malayalam}', "");
    Error('\p{Is_Blk=:=	-Malayalam}');
    Error('\P{Is_Blk=:=	-Malayalam}');
    Expect(1, 3455, '\p{Is_Blk:malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk:malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk:malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk:malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk:malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk:malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk:malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk:malayalam}', "");
    Expect(1, 3455, '\p{Is_Blk=_-MALAYALAM}', "");
    Expect(0, 3455, '\p{^Is_Blk=_-MALAYALAM}', "");
    Expect(0, 3455, '\P{Is_Blk=_-MALAYALAM}', "");
    Expect(1, 3455, '\P{^Is_Blk=_-MALAYALAM}', "");
    Expect(0, 3456, '\p{Is_Blk=_-MALAYALAM}', "");
    Expect(1, 3456, '\p{^Is_Blk=_-MALAYALAM}', "");
    Expect(1, 3456, '\P{Is_Blk=_-MALAYALAM}', "");
    Expect(0, 3456, '\P{^Is_Blk=_-MALAYALAM}', "");
    Error('\p{Block=-Mandaic:=}');
    Error('\P{Block=-Mandaic:=}');
    Expect(1, 2143, '\p{Block=mandaic}', "");
    Expect(0, 2143, '\p{^Block=mandaic}', "");
    Expect(0, 2143, '\P{Block=mandaic}', "");
    Expect(1, 2143, '\P{^Block=mandaic}', "");
    Expect(0, 2144, '\p{Block=mandaic}', "");
    Expect(1, 2144, '\p{^Block=mandaic}', "");
    Expect(1, 2144, '\P{Block=mandaic}', "");
    Expect(0, 2144, '\P{^Block=mandaic}', "");
    Expect(1, 2143, '\p{Block=	_MANDAIC}', "");
    Expect(0, 2143, '\p{^Block=	_MANDAIC}', "");
    Expect(0, 2143, '\P{Block=	_MANDAIC}', "");
    Expect(1, 2143, '\P{^Block=	_MANDAIC}', "");
    Expect(0, 2144, '\p{Block=	_MANDAIC}', "");
    Expect(1, 2144, '\p{^Block=	_MANDAIC}', "");
    Expect(1, 2144, '\P{Block=	_MANDAIC}', "");
    Expect(0, 2144, '\P{^Block=	_MANDAIC}', "");
    Error('\p{Blk:	 mandaic/a/}');
    Error('\P{Blk:	 mandaic/a/}');
    Expect(1, 2143, '\p{Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Blk=mandaic}', "");
    Expect(0, 2143, '\P{Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Blk=mandaic}', "");
    Expect(0, 2144, '\p{Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Blk=mandaic}', "");
    Expect(1, 2144, '\P{Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Blk=mandaic}', "");
    Expect(1, 2143, '\p{Blk= 	Mandaic}', "");
    Expect(0, 2143, '\p{^Blk= 	Mandaic}', "");
    Expect(0, 2143, '\P{Blk= 	Mandaic}', "");
    Expect(1, 2143, '\P{^Blk= 	Mandaic}', "");
    Expect(0, 2144, '\p{Blk= 	Mandaic}', "");
    Expect(1, 2144, '\p{^Blk= 	Mandaic}', "");
    Expect(1, 2144, '\P{Blk= 	Mandaic}', "");
    Expect(0, 2144, '\P{^Blk= 	Mandaic}', "");
    Error('\p{Is_Block=__mandaic:=}');
    Error('\P{Is_Block=__mandaic:=}');
    Expect(1, 2143, '\p{Is_Block=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=mandaic}', "");
    Expect(1, 2143, '\p{Is_Block:	 Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block:	 Mandaic}', "");
    Expect(0, 2143, '\P{Is_Block:	 Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block:	 Mandaic}', "");
    Expect(0, 2144, '\p{Is_Block:	 Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block:	 Mandaic}', "");
    Expect(1, 2144, '\P{Is_Block:	 Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block:	 Mandaic}', "");
    Error('\p{Is_Blk:	:=Mandaic}');
    Error('\P{Is_Blk:	:=Mandaic}');
    Expect(1, 2143, '\p{Is_Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=mandaic}', "");
    Expect(1, 2143, '\p{Is_Blk: 	_Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk: 	_Mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk: 	_Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk: 	_Mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk: 	_Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk: 	_Mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk: 	_Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk: 	_Mandaic}', "");
    Error('\p{Block=:=manichaean}');
    Error('\P{Block=:=manichaean}');
    Expect(1, 68351, '\p{Block=manichaean}', "");
    Expect(0, 68351, '\p{^Block=manichaean}', "");
    Expect(0, 68351, '\P{Block=manichaean}', "");
    Expect(1, 68351, '\P{^Block=manichaean}', "");
    Expect(0, 68352, '\p{Block=manichaean}', "");
    Expect(1, 68352, '\p{^Block=manichaean}', "");
    Expect(1, 68352, '\P{Block=manichaean}', "");
    Expect(0, 68352, '\P{^Block=manichaean}', "");
    Expect(1, 68351, '\p{Block=__Manichaean}', "");
    Expect(0, 68351, '\p{^Block=__Manichaean}', "");
    Expect(0, 68351, '\P{Block=__Manichaean}', "");
    Expect(1, 68351, '\P{^Block=__Manichaean}', "");
    Expect(0, 68352, '\p{Block=__Manichaean}', "");
    Expect(1, 68352, '\p{^Block=__Manichaean}', "");
    Expect(1, 68352, '\P{Block=__Manichaean}', "");
    Expect(0, 68352, '\P{^Block=__Manichaean}', "");
    Error('\p{Blk=:=	manichaean}');
    Error('\P{Blk=:=	manichaean}');
    Expect(1, 68351, '\p{Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Blk=manichaean}', "");
    Expect(0, 68351, '\P{Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Blk=manichaean}', "");
    Expect(0, 68352, '\p{Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Blk=manichaean}', "");
    Expect(1, 68352, '\P{Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Blk=manichaean}', "");
    Expect(1, 68351, '\p{Blk=	 manichaean}', "");
    Expect(0, 68351, '\p{^Blk=	 manichaean}', "");
    Expect(0, 68351, '\P{Blk=	 manichaean}', "");
    Expect(1, 68351, '\P{^Blk=	 manichaean}', "");
    Expect(0, 68352, '\p{Blk=	 manichaean}', "");
    Expect(1, 68352, '\p{^Blk=	 manichaean}', "");
    Expect(1, 68352, '\P{Blk=	 manichaean}', "");
    Expect(0, 68352, '\P{^Blk=	 manichaean}', "");
    Error('\p{Is_Block=/a/MANICHAEAN}');
    Error('\P{Is_Block=/a/MANICHAEAN}');
    Expect(1, 68351, '\p{Is_Block:manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block:manichaean}', "");
    Expect(0, 68351, '\P{Is_Block:manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block:manichaean}', "");
    Expect(0, 68352, '\p{Is_Block:manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block:manichaean}', "");
    Expect(1, 68352, '\P{Is_Block:manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block:manichaean}', "");
    Expect(1, 68351, '\p{Is_Block= manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block= manichaean}', "");
    Expect(0, 68351, '\P{Is_Block= manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block= manichaean}', "");
    Expect(0, 68352, '\p{Is_Block= manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block= manichaean}', "");
    Expect(1, 68352, '\P{Is_Block= manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block= manichaean}', "");
    Error('\p{Is_Blk=/a/ _Manichaean}');
    Error('\P{Is_Blk=/a/ _Manichaean}');
    Expect(1, 68351, '\p{Is_Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=manichaean}', "");
    Expect(1, 68351, '\p{Is_Blk=-_MANICHAEAN}', "");
    Expect(0, 68351, '\p{^Is_Blk=-_MANICHAEAN}', "");
    Expect(0, 68351, '\P{Is_Blk=-_MANICHAEAN}', "");
    Expect(1, 68351, '\P{^Is_Blk=-_MANICHAEAN}', "");
    Expect(0, 68352, '\p{Is_Blk=-_MANICHAEAN}', "");
    Expect(1, 68352, '\p{^Is_Blk=-_MANICHAEAN}', "");
    Expect(1, 68352, '\P{Is_Blk=-_MANICHAEAN}', "");
    Expect(0, 68352, '\P{^Is_Blk=-_MANICHAEAN}', "");
    Error('\p{Block=:=	-Marchen}');
    Error('\P{Block=:=	-Marchen}');
    Expect(1, 72895, '\p{Block=marchen}', "");
    Expect(0, 72895, '\p{^Block=marchen}', "");
    Expect(0, 72895, '\P{Block=marchen}', "");
    Expect(1, 72895, '\P{^Block=marchen}', "");
    Expect(0, 72896, '\p{Block=marchen}', "");
    Expect(1, 72896, '\p{^Block=marchen}', "");
    Expect(1, 72896, '\P{Block=marchen}', "");
    Expect(0, 72896, '\P{^Block=marchen}', "");
    Expect(1, 72895, '\p{Block=_	marchen}', "");
    Expect(0, 72895, '\p{^Block=_	marchen}', "");
    Expect(0, 72895, '\P{Block=_	marchen}', "");
    Expect(1, 72895, '\P{^Block=_	marchen}', "");
    Expect(0, 72896, '\p{Block=_	marchen}', "");
    Expect(1, 72896, '\p{^Block=_	marchen}', "");
    Expect(1, 72896, '\P{Block=_	marchen}', "");
    Expect(0, 72896, '\P{^Block=_	marchen}', "");
    Error('\p{Blk:   	_marchen/a/}');
    Error('\P{Blk:   	_marchen/a/}');
    Expect(1, 72895, '\p{Blk=marchen}', "");
    Expect(0, 72895, '\p{^Blk=marchen}', "");
    Expect(0, 72895, '\P{Blk=marchen}', "");
    Expect(1, 72895, '\P{^Blk=marchen}', "");
    Expect(0, 72896, '\p{Blk=marchen}', "");
    Expect(1, 72896, '\p{^Blk=marchen}', "");
    Expect(1, 72896, '\P{Blk=marchen}', "");
    Expect(0, 72896, '\P{^Blk=marchen}', "");
    Expect(1, 72895, '\p{Blk=_ marchen}', "");
    Expect(0, 72895, '\p{^Blk=_ marchen}', "");
    Expect(0, 72895, '\P{Blk=_ marchen}', "");
    Expect(1, 72895, '\P{^Blk=_ marchen}', "");
    Expect(0, 72896, '\p{Blk=_ marchen}', "");
    Expect(1, 72896, '\p{^Blk=_ marchen}', "");
    Expect(1, 72896, '\P{Blk=_ marchen}', "");
    Expect(0, 72896, '\P{^Blk=_ marchen}', "");
    Error('\p{Is_Block= /a/MARCHEN}');
    Error('\P{Is_Block= /a/MARCHEN}');
    Expect(1, 72895, '\p{Is_Block=marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=marchen}', "");
    Expect(0, 72895, '\P{Is_Block=marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=marchen}', "");
    Expect(0, 72896, '\p{Is_Block=marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=marchen}', "");
    Expect(1, 72896, '\P{Is_Block=marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=marchen}', "");
    Expect(1, 72895, '\p{Is_Block:  -marchen}', "");
    Expect(0, 72895, '\p{^Is_Block:  -marchen}', "");
    Expect(0, 72895, '\P{Is_Block:  -marchen}', "");
    Expect(1, 72895, '\P{^Is_Block:  -marchen}', "");
    Expect(0, 72896, '\p{Is_Block:  -marchen}', "");
    Expect(1, 72896, '\p{^Is_Block:  -marchen}', "");
    Expect(1, 72896, '\P{Is_Block:  -marchen}', "");
    Expect(0, 72896, '\P{^Is_Block:  -marchen}', "");
    Error('\p{Is_Blk=/a/Marchen}');
    Error('\P{Is_Blk=/a/Marchen}');
    Expect(1, 72895, '\p{Is_Blk=marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=marchen}', "");
    Expect(1, 72895, '\p{Is_Blk=	 marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=	 marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=	 marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=	 marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=	 marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=	 marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=	 marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=	 marchen}', "");
    Error('\p{Block=:=-masaram_Gondi}');
    Error('\P{Block=:=-masaram_Gondi}');
    Expect(1, 73055, '\p{Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Block=-Masaram_GONDI}', "");
    Expect(0, 73055, '\p{^Block=-Masaram_GONDI}', "");
    Expect(0, 73055, '\P{Block=-Masaram_GONDI}', "");
    Expect(1, 73055, '\P{^Block=-Masaram_GONDI}', "");
    Expect(0, 73056, '\p{Block=-Masaram_GONDI}', "");
    Expect(1, 73056, '\p{^Block=-Masaram_GONDI}', "");
    Expect(1, 73056, '\P{Block=-Masaram_GONDI}', "");
    Expect(0, 73056, '\P{^Block=-Masaram_GONDI}', "");
    Error('\p{Blk=		MASARAM_gondi/a/}');
    Error('\P{Blk=		MASARAM_gondi/a/}');
    Expect(1, 73055, '\p{Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Blk= Masaram_gondi}', "");
    Expect(0, 73055, '\p{^Blk= Masaram_gondi}', "");
    Expect(0, 73055, '\P{Blk= Masaram_gondi}', "");
    Expect(1, 73055, '\P{^Blk= Masaram_gondi}', "");
    Expect(0, 73056, '\p{Blk= Masaram_gondi}', "");
    Expect(1, 73056, '\p{^Blk= Masaram_gondi}', "");
    Expect(1, 73056, '\P{Blk= Masaram_gondi}', "");
    Expect(0, 73056, '\P{^Blk= Masaram_gondi}', "");
    Error('\p{Is_Block=/a/ masaram_Gondi}');
    Error('\P{Is_Block=/a/ masaram_Gondi}');
    Expect(1, 73055, '\p{Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Block=__Masaram_GONDI}', "");
    Expect(0, 73055, '\p{^Is_Block=__Masaram_GONDI}', "");
    Expect(0, 73055, '\P{Is_Block=__Masaram_GONDI}', "");
    Expect(1, 73055, '\P{^Is_Block=__Masaram_GONDI}', "");
    Expect(0, 73056, '\p{Is_Block=__Masaram_GONDI}', "");
    Expect(1, 73056, '\p{^Is_Block=__Masaram_GONDI}', "");
    Expect(1, 73056, '\P{Is_Block=__Masaram_GONDI}', "");
    Expect(0, 73056, '\P{^Is_Block=__Masaram_GONDI}', "");
    Error('\p{Is_Blk=	-masaram_Gondi/a/}');
    Error('\P{Is_Blk=	-masaram_Gondi/a/}');
    Expect(1, 73055, '\p{Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Blk=-Masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=-Masaram_Gondi}', "");
    Expect(0, 73055, '\P{Is_Blk=-Masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=-Masaram_Gondi}', "");
    Expect(0, 73056, '\p{Is_Blk=-Masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=-Masaram_Gondi}', "");
    Expect(1, 73056, '\P{Is_Blk=-Masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=-Masaram_Gondi}', "");
    Error('\p{Block=:=--Mathematical_ALPHANUMERIC_symbols}');
    Error('\P{Block=:=--Mathematical_ALPHANUMERIC_symbols}');
    Expect(1, 120831, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(0, 120831, '\p{^Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(0, 120831, '\P{Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(1, 120831, '\P{^Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(0, 120832, '\p{Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(1, 120832, '\p{^Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(1, 120832, '\P{Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Expect(0, 120832, '\P{^Block=_Mathematical_ALPHANUMERIC_Symbols}', "");
    Error('\p{Blk=/a/--Math_Alphanum}');
    Error('\P{Blk=/a/--Math_Alphanum}');
    Expect(1, 120831, '\p{Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Blk:   	_Math_alphanum}', "");
    Expect(0, 120831, '\p{^Blk:   	_Math_alphanum}', "");
    Expect(0, 120831, '\P{Blk:   	_Math_alphanum}', "");
    Expect(1, 120831, '\P{^Blk:   	_Math_alphanum}', "");
    Expect(0, 120832, '\p{Blk:   	_Math_alphanum}', "");
    Expect(1, 120832, '\p{^Blk:   	_Math_alphanum}', "");
    Expect(1, 120832, '\P{Blk:   	_Math_alphanum}', "");
    Expect(0, 120832, '\P{^Blk:   	_Math_alphanum}', "");
    Error('\p{Is_Block=	:=Mathematical_Alphanumeric_Symbols}');
    Error('\P{Is_Block=	:=Mathematical_Alphanumeric_Symbols}');
    Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(0, 120831, '\p{^Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(0, 120831, '\P{Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(1, 120831, '\P{^Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(0, 120832, '\p{Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(1, 120832, '\p{^Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(1, 120832, '\P{Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Expect(0, 120832, '\P{^Is_Block=- mathematical_alphanumeric_SYMBOLS}', "");
    Error('\p{Is_Blk=		MATH_Alphanum:=}');
    Error('\P{Is_Blk=		MATH_Alphanum:=}');
    Expect(1, 120831, '\p{Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Is_Blk=	Math_Alphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=	Math_Alphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=	Math_Alphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=	Math_Alphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=	Math_Alphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=	Math_Alphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=	Math_Alphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=	Math_Alphanum}', "");
    Error('\p{Block=/a/mathematical_Operators}');
    Error('\P{Block=/a/mathematical_Operators}');
    Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Block:   -Mathematical_Operators}', "");
    Expect(0, 8959, '\p{^Block:   -Mathematical_Operators}', "");
    Expect(0, 8959, '\P{Block:   -Mathematical_Operators}', "");
    Expect(1, 8959, '\P{^Block:   -Mathematical_Operators}', "");
    Expect(0, 8960, '\p{Block:   -Mathematical_Operators}', "");
    Expect(1, 8960, '\p{^Block:   -Mathematical_Operators}', "");
    Expect(1, 8960, '\P{Block:   -Mathematical_Operators}', "");
    Expect(0, 8960, '\P{^Block:   -Mathematical_Operators}', "");
    Error('\p{Blk=:=	MATH_operators}');
    Error('\P{Blk=:=	MATH_operators}');
    Expect(1, 8959, '\p{Blk: mathoperators}', "");
    Expect(0, 8959, '\p{^Blk: mathoperators}', "");
    Expect(0, 8959, '\P{Blk: mathoperators}', "");
    Expect(1, 8959, '\P{^Blk: mathoperators}', "");
    Expect(0, 8960, '\p{Blk: mathoperators}', "");
    Expect(1, 8960, '\p{^Blk: mathoperators}', "");
    Expect(1, 8960, '\P{Blk: mathoperators}', "");
    Expect(0, 8960, '\P{^Blk: mathoperators}', "");
    Expect(1, 8959, '\p{Blk=_-Math_operators}', "");
    Expect(0, 8959, '\p{^Blk=_-Math_operators}', "");
    Expect(0, 8959, '\P{Blk=_-Math_operators}', "");
    Expect(1, 8959, '\P{^Blk=_-Math_operators}', "");
    Expect(0, 8960, '\p{Blk=_-Math_operators}', "");
    Expect(1, 8960, '\p{^Blk=_-Math_operators}', "");
    Expect(1, 8960, '\P{Blk=_-Math_operators}', "");
    Expect(0, 8960, '\P{^Blk=_-Math_operators}', "");
    Error('\p{Is_Block=_	Mathematical_OPERATORS:=}');
    Error('\P{Is_Block=_	Mathematical_OPERATORS:=}');
    Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(0, 8959, '\p{^Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(0, 8959, '\P{Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(1, 8959, '\P{^Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(0, 8960, '\p{Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(1, 8960, '\p{^Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(1, 8960, '\P{Is_Block=	MATHEMATICAL_Operators}', "");
    Expect(0, 8960, '\P{^Is_Block=	MATHEMATICAL_Operators}', "");
    Error('\p{Is_Blk= _MATH_Operators/a/}');
    Error('\P{Is_Blk= _MATH_Operators/a/}');
    Expect(1, 8959, '\p{Is_Blk=mathoperators}', "");
    Expect(0, 8959, '\p{^Is_Blk=mathoperators}', "");
    Expect(0, 8959, '\P{Is_Blk=mathoperators}', "");
    Expect(1, 8959, '\P{^Is_Blk=mathoperators}', "");
    Expect(0, 8960, '\p{Is_Blk=mathoperators}', "");
    Expect(1, 8960, '\p{^Is_Blk=mathoperators}', "");
    Expect(1, 8960, '\P{Is_Blk=mathoperators}', "");
    Expect(0, 8960, '\P{^Is_Blk=mathoperators}', "");
    Expect(1, 8959, '\p{Is_Blk=-_Math_operators}', "");
    Expect(0, 8959, '\p{^Is_Blk=-_Math_operators}', "");
    Expect(0, 8959, '\P{Is_Blk=-_Math_operators}', "");
    Expect(1, 8959, '\P{^Is_Blk=-_Math_operators}', "");
    Expect(0, 8960, '\p{Is_Blk=-_Math_operators}', "");
    Expect(1, 8960, '\p{^Is_Blk=-_Math_operators}', "");
    Expect(1, 8960, '\P{Is_Blk=-_Math_operators}', "");
    Expect(0, 8960, '\P{^Is_Blk=-_Math_operators}', "");
    Error('\p{Block=:=_	meetei_MAYEK}');
    Error('\P{Block=:=_	meetei_MAYEK}');
    Expect(1, 44031, '\p{Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Block=	Meetei_mayek}', "");
    Expect(0, 44031, '\p{^Block=	Meetei_mayek}', "");
    Expect(0, 44031, '\P{Block=	Meetei_mayek}', "");
    Expect(1, 44031, '\P{^Block=	Meetei_mayek}', "");
    Expect(0, 44032, '\p{Block=	Meetei_mayek}', "");
    Expect(1, 44032, '\p{^Block=	Meetei_mayek}', "");
    Expect(1, 44032, '\P{Block=	Meetei_mayek}', "");
    Expect(0, 44032, '\P{^Block=	Meetei_mayek}', "");
    Error('\p{Blk=meetei_Mayek/a/}');
    Error('\P{Blk=meetei_Mayek/a/}');
    Expect(1, 44031, '\p{Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Blk=--MEETEI_Mayek}', "");
    Expect(0, 44031, '\p{^Blk=--MEETEI_Mayek}', "");
    Expect(0, 44031, '\P{Blk=--MEETEI_Mayek}', "");
    Expect(1, 44031, '\P{^Blk=--MEETEI_Mayek}', "");
    Expect(0, 44032, '\p{Blk=--MEETEI_Mayek}', "");
    Expect(1, 44032, '\p{^Blk=--MEETEI_Mayek}', "");
    Expect(1, 44032, '\P{Blk=--MEETEI_Mayek}', "");
    Expect(0, 44032, '\P{^Blk=--MEETEI_Mayek}', "");
    Error('\p{Is_Block: :=	 Meetei_mayek}');
    Error('\P{Is_Block: :=	 Meetei_mayek}');
    Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Block= 	meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Is_Block= 	meetei_Mayek}', "");
    Expect(0, 44031, '\P{Is_Block= 	meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Is_Block= 	meetei_Mayek}', "");
    Expect(0, 44032, '\p{Is_Block= 	meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Is_Block= 	meetei_Mayek}', "");
    Expect(1, 44032, '\P{Is_Block= 	meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Is_Block= 	meetei_Mayek}', "");
    Error('\p{Is_Blk=	:=MEETEI_Mayek}');
    Error('\P{Is_Blk=	:=MEETEI_Mayek}');
    Expect(1, 44031, '\p{Is_Blk:meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Blk:meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Blk:meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Blk:meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Blk:meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Blk:meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Blk:meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Blk:meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Blk=		meetei_mayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=		meetei_mayek}', "");
    Expect(0, 44031, '\P{Is_Blk=		meetei_mayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=		meetei_mayek}', "");
    Expect(0, 44032, '\p{Is_Blk=		meetei_mayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=		meetei_mayek}', "");
    Expect(1, 44032, '\P{Is_Blk=		meetei_mayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=		meetei_mayek}', "");
    Error('\p{Block=_MEETEI_mayek_Extensions:=}');
    Error('\P{Block=_MEETEI_mayek_Extensions:=}');
    Expect(1, 43775, '\p{Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Block=_ MEETEI_mayek_Extensions}', "");
    Expect(0, 43775, '\p{^Block=_ MEETEI_mayek_Extensions}', "");
    Expect(0, 43775, '\P{Block=_ MEETEI_mayek_Extensions}', "");
    Expect(1, 43775, '\P{^Block=_ MEETEI_mayek_Extensions}', "");
    Expect(0, 43776, '\p{Block=_ MEETEI_mayek_Extensions}', "");
    Expect(1, 43776, '\p{^Block=_ MEETEI_mayek_Extensions}', "");
    Expect(1, 43776, '\P{Block=_ MEETEI_mayek_Extensions}', "");
    Expect(0, 43776, '\P{^Block=_ MEETEI_mayek_Extensions}', "");
    Error('\p{Blk=	:=Meetei_Mayek_Ext}');
    Error('\P{Blk=	:=Meetei_Mayek_Ext}');
    Expect(1, 43775, '\p{Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Blk=	_Meetei_mayek_ext}', "");
    Expect(0, 43775, '\p{^Blk=	_Meetei_mayek_ext}', "");
    Expect(0, 43775, '\P{Blk=	_Meetei_mayek_ext}', "");
    Expect(1, 43775, '\P{^Blk=	_Meetei_mayek_ext}', "");
    Expect(0, 43776, '\p{Blk=	_Meetei_mayek_ext}', "");
    Expect(1, 43776, '\p{^Blk=	_Meetei_mayek_ext}', "");
    Expect(1, 43776, '\P{Blk=	_Meetei_mayek_ext}', "");
    Expect(0, 43776, '\P{^Blk=	_Meetei_mayek_ext}', "");
    Error('\p{Is_Block=_ Meetei_MAYEK_extensions:=}');
    Error('\P{Is_Block=_ Meetei_MAYEK_extensions:=}');
    Expect(1, 43775, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\p{^Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\P{Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(1, 43775, '\P{^Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\p{Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\p{^Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\P{Is_Block=	_meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\P{^Is_Block=	_meetei_Mayek_Extensions}', "");
    Error('\p{Is_Blk:	/a/ Meetei_Mayek_Ext}');
    Error('\P{Is_Blk:	/a/ Meetei_Mayek_Ext}');
    Expect(1, 43775, '\p{Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(0, 43775, '\p{^Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(0, 43775, '\P{Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(1, 43775, '\P{^Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(0, 43776, '\p{Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(1, 43776, '\p{^Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(1, 43776, '\P{Is_Blk=_ meetei_MAYEK_ext}', "");
    Expect(0, 43776, '\P{^Is_Blk=_ meetei_MAYEK_ext}', "");
    Error('\p{Block:-/a/MENDE_Kikakui}');
    Error('\P{Block:-/a/MENDE_Kikakui}');
    Expect(1, 125151, '\p{Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Block=-	MENDE_Kikakui}', "");
    Expect(0, 125151, '\p{^Block=-	MENDE_Kikakui}', "");
    Expect(0, 125151, '\P{Block=-	MENDE_Kikakui}', "");
    Expect(1, 125151, '\P{^Block=-	MENDE_Kikakui}', "");
    Expect(0, 125152, '\p{Block=-	MENDE_Kikakui}', "");
    Expect(1, 125152, '\p{^Block=-	MENDE_Kikakui}', "");
    Expect(1, 125152, '\P{Block=-	MENDE_Kikakui}', "");
    Expect(0, 125152, '\P{^Block=-	MENDE_Kikakui}', "");
    Error('\p{Blk=	 Mende_Kikakui/a/}');
    Error('\P{Blk=	 Mende_Kikakui/a/}');
    Expect(1, 125151, '\p{Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Blk:   	_mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Blk:   	_mende_Kikakui}', "");
    Expect(0, 125151, '\P{Blk:   	_mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Blk:   	_mende_Kikakui}', "");
    Expect(0, 125152, '\p{Blk:   	_mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Blk:   	_mende_Kikakui}', "");
    Expect(1, 125152, '\P{Blk:   	_mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Blk:   	_mende_Kikakui}', "");
    Error('\p{Is_Block=:=-_Mende_Kikakui}');
    Error('\P{Is_Block=:=-_Mende_Kikakui}');
    Expect(1, 125151, '\p{Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Block=_-Mende_KIKAKUI}', "");
    Expect(0, 125151, '\p{^Is_Block=_-Mende_KIKAKUI}', "");
    Expect(0, 125151, '\P{Is_Block=_-Mende_KIKAKUI}', "");
    Expect(1, 125151, '\P{^Is_Block=_-Mende_KIKAKUI}', "");
    Expect(0, 125152, '\p{Is_Block=_-Mende_KIKAKUI}', "");
    Expect(1, 125152, '\p{^Is_Block=_-Mende_KIKAKUI}', "");
    Expect(1, 125152, '\P{Is_Block=_-Mende_KIKAKUI}', "");
    Expect(0, 125152, '\P{^Is_Block=_-Mende_KIKAKUI}', "");
    Error('\p{Is_Blk:   /a/_ MENDE_kikakui}');
    Error('\P{Is_Blk:   /a/_ MENDE_kikakui}');
    Expect(1, 125151, '\p{Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Blk= Mende_KIKAKUI}', "");
    Expect(0, 125151, '\p{^Is_Blk= Mende_KIKAKUI}', "");
    Expect(0, 125151, '\P{Is_Blk= Mende_KIKAKUI}', "");
    Expect(1, 125151, '\P{^Is_Blk= Mende_KIKAKUI}', "");
    Expect(0, 125152, '\p{Is_Blk= Mende_KIKAKUI}', "");
    Expect(1, 125152, '\p{^Is_Blk= Mende_KIKAKUI}', "");
    Expect(1, 125152, '\P{Is_Blk= Mende_KIKAKUI}', "");
    Expect(0, 125152, '\P{^Is_Blk= Mende_KIKAKUI}', "");
    Error('\p{Block=/a/--Meroitic_Cursive}');
    Error('\P{Block=/a/--Meroitic_Cursive}');
    Expect(1, 68095, '\p{Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Block=	Meroitic_Cursive}', "");
    Expect(0, 68095, '\p{^Block=	Meroitic_Cursive}', "");
    Expect(0, 68095, '\P{Block=	Meroitic_Cursive}', "");
    Expect(1, 68095, '\P{^Block=	Meroitic_Cursive}', "");
    Expect(0, 68096, '\p{Block=	Meroitic_Cursive}', "");
    Expect(1, 68096, '\p{^Block=	Meroitic_Cursive}', "");
    Expect(1, 68096, '\P{Block=	Meroitic_Cursive}', "");
    Expect(0, 68096, '\P{^Block=	Meroitic_Cursive}', "");
    Error('\p{Blk=	/a/MEROITIC_cursive}');
    Error('\P{Blk=	/a/MEROITIC_cursive}');
    Expect(1, 68095, '\p{Blk:meroiticcursive}', "");
    Expect(0, 68095, '\p{^Blk:meroiticcursive}', "");
    Expect(0, 68095, '\P{Blk:meroiticcursive}', "");
    Expect(1, 68095, '\P{^Blk:meroiticcursive}', "");
    Expect(0, 68096, '\p{Blk:meroiticcursive}', "");
    Expect(1, 68096, '\p{^Blk:meroiticcursive}', "");
    Expect(1, 68096, '\P{Blk:meroiticcursive}', "");
    Expect(0, 68096, '\P{^Blk:meroiticcursive}', "");
    Expect(1, 68095, '\p{Blk=		meroitic_CURSIVE}', "");
    Expect(0, 68095, '\p{^Blk=		meroitic_CURSIVE}', "");
    Expect(0, 68095, '\P{Blk=		meroitic_CURSIVE}', "");
    Expect(1, 68095, '\P{^Blk=		meroitic_CURSIVE}', "");
    Expect(0, 68096, '\p{Blk=		meroitic_CURSIVE}', "");
    Expect(1, 68096, '\p{^Blk=		meroitic_CURSIVE}', "");
    Expect(1, 68096, '\P{Blk=		meroitic_CURSIVE}', "");
    Expect(0, 68096, '\P{^Blk=		meroitic_CURSIVE}', "");
    Error('\p{Is_Block=:=-	meroitic_CURSIVE}');
    Error('\P{Is_Block=:=-	meroitic_CURSIVE}');
    Expect(1, 68095, '\p{Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Block=	 meroitic_Cursive}', "");
    Expect(0, 68095, '\p{^Is_Block=	 meroitic_Cursive}', "");
    Expect(0, 68095, '\P{Is_Block=	 meroitic_Cursive}', "");
    Expect(1, 68095, '\P{^Is_Block=	 meroitic_Cursive}', "");
    Expect(0, 68096, '\p{Is_Block=	 meroitic_Cursive}', "");
    Expect(1, 68096, '\p{^Is_Block=	 meroitic_Cursive}', "");
    Expect(1, 68096, '\P{Is_Block=	 meroitic_Cursive}', "");
    Expect(0, 68096, '\P{^Is_Block=	 meroitic_Cursive}', "");
    Error('\p{Is_Blk=:= _MEROITIC_CURSIVE}');
    Error('\P{Is_Blk=:= _MEROITIC_CURSIVE}');
    Expect(1, 68095, '\p{Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Blk=-_Meroitic_Cursive}', "");
    Expect(0, 68095, '\p{^Is_Blk=-_Meroitic_Cursive}', "");
    Expect(0, 68095, '\P{Is_Blk=-_Meroitic_Cursive}', "");
    Expect(1, 68095, '\P{^Is_Blk=-_Meroitic_Cursive}', "");
    Expect(0, 68096, '\p{Is_Blk=-_Meroitic_Cursive}', "");
    Expect(1, 68096, '\p{^Is_Blk=-_Meroitic_Cursive}', "");
    Expect(1, 68096, '\P{Is_Blk=-_Meroitic_Cursive}', "");
    Expect(0, 68096, '\P{^Is_Blk=-_Meroitic_Cursive}', "");
    Error('\p{Block=:=__meroitic_hieroglyphs}');
    Error('\P{Block=:=__meroitic_hieroglyphs}');
    Expect(1, 67999, '\p{Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(0, 67999, '\p{^Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(0, 67999, '\P{Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(1, 67999, '\P{^Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(0, 68000, '\p{Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(1, 68000, '\p{^Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(1, 68000, '\P{Block=		Meroitic_HIEROGLYPHS}', "");
    Expect(0, 68000, '\P{^Block=		Meroitic_HIEROGLYPHS}', "");
    Error('\p{Blk=	_meroitic_Hieroglyphs:=}');
    Error('\P{Blk=	_meroitic_Hieroglyphs:=}');
    Expect(1, 67999, '\p{Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Blk=_meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk=_meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Blk=_meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk=_meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Blk=_meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk=_meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Blk=_meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk=_meroitic_Hieroglyphs}', "");
    Error('\p{Is_Block=:=	-meroitic_HIEROGLYPHS}');
    Error('\P{Is_Block=:=	-meroitic_HIEROGLYPHS}');
    Expect(1, 67999, '\p{Is_Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block=-meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block=-meroitic_Hieroglyphs}', "");
    Error('\p{Is_Blk=:=Meroitic_Hieroglyphs}');
    Error('\P{Is_Blk=:=Meroitic_Hieroglyphs}');
    Expect(1, 67999, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk=__Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk=__Meroitic_Hieroglyphs}', "");
    Error('\p{Block:	 miao/a/}');
    Error('\P{Block:	 miao/a/}');
    Expect(1, 94111, '\p{Block=miao}', "");
    Expect(0, 94111, '\p{^Block=miao}', "");
    Expect(0, 94111, '\P{Block=miao}', "");
    Expect(1, 94111, '\P{^Block=miao}', "");
    Expect(0, 94112, '\p{Block=miao}', "");
    Expect(1, 94112, '\p{^Block=miao}', "");
    Expect(1, 94112, '\P{Block=miao}', "");
    Expect(0, 94112, '\P{^Block=miao}', "");
    Expect(1, 94111, '\p{Block: Miao}', "");
    Expect(0, 94111, '\p{^Block: Miao}', "");
    Expect(0, 94111, '\P{Block: Miao}', "");
    Expect(1, 94111, '\P{^Block: Miao}', "");
    Expect(0, 94112, '\p{Block: Miao}', "");
    Expect(1, 94112, '\p{^Block: Miao}', "");
    Expect(1, 94112, '\P{Block: Miao}', "");
    Expect(0, 94112, '\P{^Block: Miao}', "");
    Error('\p{Blk: /a/Miao}');
    Error('\P{Blk: /a/Miao}');
    Expect(1, 94111, '\p{Blk=miao}', "");
    Expect(0, 94111, '\p{^Blk=miao}', "");
    Expect(0, 94111, '\P{Blk=miao}', "");
    Expect(1, 94111, '\P{^Blk=miao}', "");
    Expect(0, 94112, '\p{Blk=miao}', "");
    Expect(1, 94112, '\p{^Blk=miao}', "");
    Expect(1, 94112, '\P{Blk=miao}', "");
    Expect(0, 94112, '\P{^Blk=miao}', "");
    Expect(1, 94111, '\p{Blk=_	Miao}', "");
    Expect(0, 94111, '\p{^Blk=_	Miao}', "");
    Expect(0, 94111, '\P{Blk=_	Miao}', "");
    Expect(1, 94111, '\P{^Blk=_	Miao}', "");
    Expect(0, 94112, '\p{Blk=_	Miao}', "");
    Expect(1, 94112, '\p{^Blk=_	Miao}', "");
    Expect(1, 94112, '\P{Blk=_	Miao}', "");
    Expect(0, 94112, '\P{^Blk=_	Miao}', "");
    Error('\p{Is_Block=	:=Miao}');
    Error('\P{Is_Block=	:=Miao}');
    Expect(1, 94111, '\p{Is_Block=miao}', "");
    Expect(0, 94111, '\p{^Is_Block=miao}', "");
    Expect(0, 94111, '\P{Is_Block=miao}', "");
    Expect(1, 94111, '\P{^Is_Block=miao}', "");
    Expect(0, 94112, '\p{Is_Block=miao}', "");
    Expect(1, 94112, '\p{^Is_Block=miao}', "");
    Expect(1, 94112, '\P{Is_Block=miao}', "");
    Expect(0, 94112, '\P{^Is_Block=miao}', "");
    Expect(1, 94111, '\p{Is_Block:	_-Miao}', "");
    Expect(0, 94111, '\p{^Is_Block:	_-Miao}', "");
    Expect(0, 94111, '\P{Is_Block:	_-Miao}', "");
    Expect(1, 94111, '\P{^Is_Block:	_-Miao}', "");
    Expect(0, 94112, '\p{Is_Block:	_-Miao}', "");
    Expect(1, 94112, '\p{^Is_Block:	_-Miao}', "");
    Expect(1, 94112, '\P{Is_Block:	_-Miao}', "");
    Expect(0, 94112, '\P{^Is_Block:	_-Miao}', "");
    Error('\p{Is_Blk=:=miao}');
    Error('\P{Is_Blk=:=miao}');
    Expect(1, 94111, '\p{Is_Blk=miao}', "");
    Expect(0, 94111, '\p{^Is_Blk=miao}', "");
    Expect(0, 94111, '\P{Is_Blk=miao}', "");
    Expect(1, 94111, '\P{^Is_Blk=miao}', "");
    Expect(0, 94112, '\p{Is_Blk=miao}', "");
    Expect(1, 94112, '\p{^Is_Blk=miao}', "");
    Expect(1, 94112, '\P{Is_Blk=miao}', "");
    Expect(0, 94112, '\P{^Is_Blk=miao}', "");
    Expect(1, 94111, '\p{Is_Blk=		miao}', "");
    Expect(0, 94111, '\p{^Is_Blk=		miao}', "");
    Expect(0, 94111, '\P{Is_Blk=		miao}', "");
    Expect(1, 94111, '\P{^Is_Blk=		miao}', "");
    Expect(0, 94112, '\p{Is_Blk=		miao}', "");
    Expect(1, 94112, '\p{^Is_Blk=		miao}', "");
    Expect(1, 94112, '\P{Is_Blk=		miao}', "");
    Expect(0, 94112, '\P{^Is_Blk=		miao}', "");
    Error('\p{Block=	:=Miscellaneous_symbols_And_arrows}');
    Error('\P{Block=	:=Miscellaneous_symbols_And_arrows}');
    Expect(1, 11263, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(0, 11263, '\p{^Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(0, 11263, '\P{Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(1, 11263, '\P{^Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(0, 11264, '\p{Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(1, 11264, '\p{^Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(1, 11264, '\P{Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Expect(0, 11264, '\P{^Block=-	miscellaneous_Symbols_AND_arrows}', "");
    Error('\p{Blk=:=	misc_Arrows}');
    Error('\P{Blk=:=	misc_Arrows}');
    Expect(1, 11263, '\p{Blk:   miscarrows}', "");
    Expect(0, 11263, '\p{^Blk:   miscarrows}', "");
    Expect(0, 11263, '\P{Blk:   miscarrows}', "");
    Expect(1, 11263, '\P{^Blk:   miscarrows}', "");
    Expect(0, 11264, '\p{Blk:   miscarrows}', "");
    Expect(1, 11264, '\p{^Blk:   miscarrows}', "");
    Expect(1, 11264, '\P{Blk:   miscarrows}', "");
    Expect(0, 11264, '\P{^Blk:   miscarrows}', "");
    Expect(1, 11263, '\p{Blk=		Misc_arrows}', "");
    Expect(0, 11263, '\p{^Blk=		Misc_arrows}', "");
    Expect(0, 11263, '\P{Blk=		Misc_arrows}', "");
    Expect(1, 11263, '\P{^Blk=		Misc_arrows}', "");
    Expect(0, 11264, '\p{Blk=		Misc_arrows}', "");
    Expect(1, 11264, '\p{^Blk=		Misc_arrows}', "");
    Expect(1, 11264, '\P{Blk=		Misc_arrows}', "");
    Expect(0, 11264, '\P{^Blk=		Misc_arrows}', "");
    Error('\p{Is_Block=-:=miscellaneous_Symbols_AND_ARROWS}');
    Error('\P{Is_Block=-:=miscellaneous_Symbols_AND_ARROWS}');
    Expect(1, 11263, '\p{Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Is_Block:miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(0, 11263, '\p{^Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(0, 11263, '\P{Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(1, 11263, '\P{^Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(0, 11264, '\p{Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(1, 11264, '\p{^Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(1, 11264, '\P{Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Expect(0, 11264, '\P{^Is_Block=--MISCELLANEOUS_SYMBOLS_And_Arrows}', "");
    Error('\p{Is_Blk=/a/misc_Arrows}');
    Error('\P{Is_Blk=/a/misc_Arrows}');
    Expect(1, 11263, '\p{Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\p{^Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\P{Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\P{^Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\p{Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\p{^Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\P{Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\P{^Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\p{Is_Blk=_	Misc_Arrows}', "");
    Expect(0, 11263, '\p{^Is_Blk=_	Misc_Arrows}', "");
    Expect(0, 11263, '\P{Is_Blk=_	Misc_Arrows}', "");
    Expect(1, 11263, '\P{^Is_Blk=_	Misc_Arrows}', "");
    Expect(0, 11264, '\p{Is_Blk=_	Misc_Arrows}', "");
    Expect(1, 11264, '\p{^Is_Blk=_	Misc_Arrows}', "");
    Expect(1, 11264, '\P{Is_Blk=_	Misc_Arrows}', "");
    Expect(0, 11264, '\P{^Is_Blk=_	Misc_Arrows}', "");
    Error('\p{Block=-_miscellaneous_mathematical_SYMBOLS_a/a/}');
    Error('\P{Block=-_miscellaneous_mathematical_SYMBOLS_a/a/}');
    Expect(1, 10223, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(0, 10223, '\p{^Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(0, 10223, '\P{Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(1, 10223, '\P{^Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(0, 10224, '\p{Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(1, 10224, '\p{^Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(1, 10224, '\P{Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Expect(0, 10224, '\P{^Block:	 	miscellaneous_Mathematical_SYMBOLS_A}', "");
    Error('\p{Blk=_:=MISC_math_symbols_A}');
    Error('\P{Blk=_:=MISC_math_symbols_A}');
    Expect(1, 10223, '\p{Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(0, 10223, '\p{^Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(0, 10223, '\P{Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(1, 10223, '\P{^Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(0, 10224, '\p{Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(1, 10224, '\p{^Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(1, 10224, '\P{Blk=	 MISC_MATH_Symbols_A}', "");
    Expect(0, 10224, '\P{^Blk=	 MISC_MATH_Symbols_A}', "");
    Error('\p{Is_Block= :=Miscellaneous_MATHEMATICAL_Symbols_A}');
    Error('\P{Is_Block= :=Miscellaneous_MATHEMATICAL_Symbols_A}');
    Expect(1, 10223, '\p{Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Block:miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(0, 10223, '\p{^Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(0, 10223, '\P{Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(1, 10223, '\P{^Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(0, 10224, '\p{Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(1, 10224, '\p{^Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(1, 10224, '\P{Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Expect(0, 10224, '\P{^Is_Block= MISCELLANEOUS_mathematical_Symbols_A}', "");
    Error('\p{Is_Blk=	/a/MISC_Math_SYMBOLS_A}');
    Error('\P{Is_Blk=	/a/MISC_Math_SYMBOLS_A}');
    Expect(1, 10223, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10223, '\p{^Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10223, '\P{Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10223, '\P{^Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10224, '\p{Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10224, '\p{^Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10224, '\P{Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10224, '\P{^Is_Blk=- Misc_Math_SYMBOLS_A}', "");
    Error('\p{Block=_/a/MISCELLANEOUS_Mathematical_Symbols_B}');
    Error('\P{Block=_/a/MISCELLANEOUS_Mathematical_Symbols_B}');
    Expect(1, 10751, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(0, 10751, '\p{^Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(0, 10751, '\P{Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(1, 10751, '\P{^Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(0, 10752, '\p{Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(1, 10752, '\p{^Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(1, 10752, '\P{Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Expect(0, 10752, '\P{^Block=_-miscellaneous_MATHEMATICAL_symbols_b}', "");
    Error('\p{Blk=:=	 Misc_math_SYMBOLS_B}');
    Error('\P{Blk=:=	 Misc_math_SYMBOLS_B}');
    Expect(1, 10751, '\p{Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(0, 10751, '\p{^Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(0, 10751, '\P{Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(1, 10751, '\P{^Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(0, 10752, '\p{Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(1, 10752, '\p{^Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(1, 10752, '\P{Blk=	 MISC_math_SYMBOLS_B}', "");
    Expect(0, 10752, '\P{^Blk=	 MISC_math_SYMBOLS_B}', "");
    Error('\p{Is_Block=MISCELLANEOUS_mathematical_Symbols_B/a/}');
    Error('\P{Is_Block=MISCELLANEOUS_mathematical_Symbols_B/a/}');
    Expect(1, 10751, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10751, '\p{^Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10751, '\P{Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10751, '\P{^Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10752, '\p{Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10752, '\p{^Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10752, '\P{Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10752, '\P{^Is_Block: -miscellaneous_Mathematical_SYMBOLS_B}', "");
    Error('\p{Is_Blk: -Misc_math_symbols_B/a/}');
    Error('\P{Is_Blk: -Misc_math_symbols_B/a/}');
    Expect(1, 10751, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(0, 10751, '\p{^Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(0, 10751, '\P{Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(1, 10751, '\P{^Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(0, 10752, '\p{Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(1, 10752, '\p{^Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(1, 10752, '\P{Is_Blk=_	MISC_math_symbols_B}', "");
    Expect(0, 10752, '\P{^Is_Blk=_	MISC_math_symbols_B}', "");
    Error('\p{Block=/a/Miscellaneous_Symbols_And_Pictographs}');
    Error('\P{Block=/a/Miscellaneous_Symbols_And_Pictographs}');
    Expect(1, 128511, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\p{Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(0, 128511, '\p{^Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(0, 128511, '\P{Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(1, 128511, '\P{^Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(0, 128512, '\p{Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(1, 128512, '\p{^Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(1, 128512, '\P{Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Expect(0, 128512, '\P{^Block=- miscellaneous_Symbols_And_PICTOGRAPHS}', "");
    Error('\p{Blk=	/a/Misc_pictographs}');
    Error('\P{Blk=	/a/Misc_pictographs}');
    Expect(1, 128511, '\p{Blk=miscpictographs}', "");
    Expect(0, 128511, '\p{^Blk=miscpictographs}', "");
    Expect(0, 128511, '\P{Blk=miscpictographs}', "");
    Expect(1, 128511, '\P{^Blk=miscpictographs}', "");
    Expect(0, 128512, '\p{Blk=miscpictographs}', "");
    Expect(1, 128512, '\p{^Blk=miscpictographs}', "");
    Expect(1, 128512, '\P{Blk=miscpictographs}', "");
    Expect(0, 128512, '\P{^Blk=miscpictographs}', "");
    Expect(1, 128511, '\p{Blk: -misc_Pictographs}', "");
    Expect(0, 128511, '\p{^Blk: -misc_Pictographs}', "");
    Expect(0, 128511, '\P{Blk: -misc_Pictographs}', "");
    Expect(1, 128511, '\P{^Blk: -misc_Pictographs}', "");
    Expect(0, 128512, '\p{Blk: -misc_Pictographs}', "");
    Expect(1, 128512, '\p{^Blk: -misc_Pictographs}', "");
    Expect(1, 128512, '\P{Blk: -misc_Pictographs}', "");
    Expect(0, 128512, '\P{^Blk: -misc_Pictographs}', "");
    Error('\p{Is_Block=-:=miscellaneous_SYMBOLS_AND_PICTOGRAPHS}');
    Error('\P{Is_Block=-:=miscellaneous_SYMBOLS_AND_PICTOGRAPHS}');
    Expect(1, 128511, '\p{Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\p{^Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\P{Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\P{^Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\p{Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\p{^Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\P{Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\P{^Is_Block:   miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\p{Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(0, 128511, '\p{^Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(0, 128511, '\P{Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(1, 128511, '\P{^Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(0, 128512, '\p{Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(1, 128512, '\p{^Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(1, 128512, '\P{Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Expect(0, 128512, '\P{^Is_Block=-	Miscellaneous_SYMBOLS_And_PICTOGRAPHS}', "");
    Error('\p{Is_Blk: :=	-misc_Pictographs}');
    Error('\P{Is_Blk: :=	-misc_Pictographs}');
    Expect(1, 128511, '\p{Is_Blk=miscpictographs}', "");
    Expect(0, 128511, '\p{^Is_Blk=miscpictographs}', "");
    Expect(0, 128511, '\P{Is_Blk=miscpictographs}', "");
    Expect(1, 128511, '\P{^Is_Blk=miscpictographs}', "");
    Expect(0, 128512, '\p{Is_Blk=miscpictographs}', "");
    Expect(1, 128512, '\p{^Is_Blk=miscpictographs}', "");
    Expect(1, 128512, '\P{Is_Blk=miscpictographs}', "");
    Expect(0, 128512, '\P{^Is_Blk=miscpictographs}', "");
    Expect(1, 128511, '\p{Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(0, 128511, '\p{^Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(0, 128511, '\P{Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(1, 128511, '\P{^Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(0, 128512, '\p{Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(1, 128512, '\p{^Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(1, 128512, '\P{Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Expect(0, 128512, '\P{^Is_Blk=	-MISC_PICTOGRAPHS}', "");
    Error('\p{Block=_Miscellaneous_Symbols:=}');
    Error('\P{Block=_Miscellaneous_Symbols:=}');
    Expect(1, 9983, '\p{Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\p{^Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\P{Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\P{^Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\p{Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\p{^Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\P{Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\P{^Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\p{Block=  miscellaneous_Symbols}', "");
    Expect(0, 9983, '\p{^Block=  miscellaneous_Symbols}', "");
    Expect(0, 9983, '\P{Block=  miscellaneous_Symbols}', "");
    Expect(1, 9983, '\P{^Block=  miscellaneous_Symbols}', "");
    Expect(0, 9984, '\p{Block=  miscellaneous_Symbols}', "");
    Expect(1, 9984, '\p{^Block=  miscellaneous_Symbols}', "");
    Expect(1, 9984, '\P{Block=  miscellaneous_Symbols}', "");
    Expect(0, 9984, '\P{^Block=  miscellaneous_Symbols}', "");
    Error('\p{Blk=:=  Misc_Symbols}');
    Error('\P{Blk=:=  Misc_Symbols}');
    Expect(1, 9983, '\p{Blk=miscsymbols}', "");
    Expect(0, 9983, '\p{^Blk=miscsymbols}', "");
    Expect(0, 9983, '\P{Blk=miscsymbols}', "");
    Expect(1, 9983, '\P{^Blk=miscsymbols}', "");
    Expect(0, 9984, '\p{Blk=miscsymbols}', "");
    Expect(1, 9984, '\p{^Blk=miscsymbols}', "");
    Expect(1, 9984, '\P{Blk=miscsymbols}', "");
    Expect(0, 9984, '\P{^Blk=miscsymbols}', "");
    Expect(1, 9983, '\p{Blk=_-MISC_Symbols}', "");
    Expect(0, 9983, '\p{^Blk=_-MISC_Symbols}', "");
    Expect(0, 9983, '\P{Blk=_-MISC_Symbols}', "");
    Expect(1, 9983, '\P{^Blk=_-MISC_Symbols}', "");
    Expect(0, 9984, '\p{Blk=_-MISC_Symbols}', "");
    Expect(1, 9984, '\p{^Blk=_-MISC_Symbols}', "");
    Expect(1, 9984, '\P{Blk=_-MISC_Symbols}', "");
    Expect(0, 9984, '\P{^Blk=_-MISC_Symbols}', "");
    Error('\p{Is_Block=:= 	MISCELLANEOUS_symbols}');
    Error('\P{Is_Block=:= 	MISCELLANEOUS_symbols}');
    Expect(1, 9983, '\p{Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\p{^Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9983, '\P{Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\P{^Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\p{Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\p{^Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9984, '\P{Is_Block=miscellaneoussymbols}', "");
    Expect(0, 9984, '\P{^Is_Block=miscellaneoussymbols}', "");
    Expect(1, 9983, '\p{Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(0, 9983, '\p{^Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(0, 9983, '\P{Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(1, 9983, '\P{^Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(0, 9984, '\p{Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(1, 9984, '\p{^Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(1, 9984, '\P{Is_Block:   _ Miscellaneous_Symbols}', "");
    Expect(0, 9984, '\P{^Is_Block:   _ Miscellaneous_Symbols}', "");
    Error('\p{Is_Blk=:=_Misc_SYMBOLS}');
    Error('\P{Is_Blk=:=_Misc_SYMBOLS}');
    Expect(1, 9983, '\p{Is_Blk=miscsymbols}', "");
    Expect(0, 9983, '\p{^Is_Blk=miscsymbols}', "");
    Expect(0, 9983, '\P{Is_Blk=miscsymbols}', "");
    Expect(1, 9983, '\P{^Is_Blk=miscsymbols}', "");
    Expect(0, 9984, '\p{Is_Blk=miscsymbols}', "");
    Expect(1, 9984, '\p{^Is_Blk=miscsymbols}', "");
    Expect(1, 9984, '\P{Is_Blk=miscsymbols}', "");
    Expect(0, 9984, '\P{^Is_Blk=miscsymbols}', "");
    Expect(1, 9983, '\p{Is_Blk= _Misc_Symbols}', "");
    Expect(0, 9983, '\p{^Is_Blk= _Misc_Symbols}', "");
    Expect(0, 9983, '\P{Is_Blk= _Misc_Symbols}', "");
    Expect(1, 9983, '\P{^Is_Blk= _Misc_Symbols}', "");
    Expect(0, 9984, '\p{Is_Blk= _Misc_Symbols}', "");
    Expect(1, 9984, '\p{^Is_Blk= _Misc_Symbols}', "");
    Expect(1, 9984, '\P{Is_Blk= _Misc_Symbols}', "");
    Expect(0, 9984, '\P{^Is_Blk= _Misc_Symbols}', "");
    Error('\p{Block=:=	miscellaneous_TECHNICAL}');
    Error('\P{Block=:=	miscellaneous_TECHNICAL}');
    Expect(1, 9215, '\p{Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\p{^Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\P{Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\P{^Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\p{Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\p{^Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\P{Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\P{^Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\p{Block:	__Miscellaneous_technical}', "");
    Expect(0, 9215, '\p{^Block:	__Miscellaneous_technical}', "");
    Expect(0, 9215, '\P{Block:	__Miscellaneous_technical}', "");
    Expect(1, 9215, '\P{^Block:	__Miscellaneous_technical}', "");
    Expect(0, 9216, '\p{Block:	__Miscellaneous_technical}', "");
    Expect(1, 9216, '\p{^Block:	__Miscellaneous_technical}', "");
    Expect(1, 9216, '\P{Block:	__Miscellaneous_technical}', "");
    Expect(0, 9216, '\P{^Block:	__Miscellaneous_technical}', "");
    Error('\p{Blk=_Misc_TECHNICAL/a/}');
    Error('\P{Blk=_Misc_TECHNICAL/a/}');
    Expect(1, 9215, '\p{Blk=misctechnical}', "");
    Expect(0, 9215, '\p{^Blk=misctechnical}', "");
    Expect(0, 9215, '\P{Blk=misctechnical}', "");
    Expect(1, 9215, '\P{^Blk=misctechnical}', "");
    Expect(0, 9216, '\p{Blk=misctechnical}', "");
    Expect(1, 9216, '\p{^Blk=misctechnical}', "");
    Expect(1, 9216, '\P{Blk=misctechnical}', "");
    Expect(0, 9216, '\P{^Blk=misctechnical}', "");
    Expect(1, 9215, '\p{Blk=-MISC_TECHNICAL}', "");
    Expect(0, 9215, '\p{^Blk=-MISC_TECHNICAL}', "");
    Expect(0, 9215, '\P{Blk=-MISC_TECHNICAL}', "");
    Expect(1, 9215, '\P{^Blk=-MISC_TECHNICAL}', "");
    Expect(0, 9216, '\p{Blk=-MISC_TECHNICAL}', "");
    Expect(1, 9216, '\p{^Blk=-MISC_TECHNICAL}', "");
    Expect(1, 9216, '\P{Blk=-MISC_TECHNICAL}', "");
    Expect(0, 9216, '\P{^Blk=-MISC_TECHNICAL}', "");
    Error('\p{Is_Block=:=-_miscellaneous_TECHNICAL}');
    Error('\P{Is_Block=:=-_miscellaneous_TECHNICAL}');
    Expect(1, 9215, '\p{Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\p{^Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9215, '\P{Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\P{^Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\p{Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\p{^Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9216, '\P{Is_Block=miscellaneoustechnical}', "");
    Expect(0, 9216, '\P{^Is_Block=miscellaneoustechnical}', "");
    Expect(1, 9215, '\p{Is_Block=-Miscellaneous_Technical}', "");
    Expect(0, 9215, '\p{^Is_Block=-Miscellaneous_Technical}', "");
    Expect(0, 9215, '\P{Is_Block=-Miscellaneous_Technical}', "");
    Expect(1, 9215, '\P{^Is_Block=-Miscellaneous_Technical}', "");
    Expect(0, 9216, '\p{Is_Block=-Miscellaneous_Technical}', "");
    Expect(1, 9216, '\p{^Is_Block=-Miscellaneous_Technical}', "");
    Expect(1, 9216, '\P{Is_Block=-Miscellaneous_Technical}', "");
    Expect(0, 9216, '\P{^Is_Block=-Miscellaneous_Technical}', "");
    Error('\p{Is_Blk:	/a/misc_Technical}');
    Error('\P{Is_Blk:	/a/misc_Technical}');
    Expect(1, 9215, '\p{Is_Blk=misctechnical}', "");
    Expect(0, 9215, '\p{^Is_Blk=misctechnical}', "");
    Expect(0, 9215, '\P{Is_Blk=misctechnical}', "");
    Expect(1, 9215, '\P{^Is_Blk=misctechnical}', "");
    Expect(0, 9216, '\p{Is_Blk=misctechnical}', "");
    Expect(1, 9216, '\p{^Is_Blk=misctechnical}', "");
    Expect(1, 9216, '\P{Is_Blk=misctechnical}', "");
    Expect(0, 9216, '\P{^Is_Blk=misctechnical}', "");
    Expect(1, 9215, '\p{Is_Blk=-	Misc_technical}', "");
    Expect(0, 9215, '\p{^Is_Blk=-	Misc_technical}', "");
    Expect(0, 9215, '\P{Is_Blk=-	Misc_technical}', "");
    Expect(1, 9215, '\P{^Is_Blk=-	Misc_technical}', "");
    Expect(0, 9216, '\p{Is_Blk=-	Misc_technical}', "");
    Expect(1, 9216, '\p{^Is_Blk=-	Misc_technical}', "");
    Expect(1, 9216, '\P{Is_Blk=-	Misc_technical}', "");
    Expect(0, 9216, '\P{^Is_Blk=-	Misc_technical}', "");
    Error('\p{Block: _/a/Modi}');
    Error('\P{Block: _/a/Modi}');
    Expect(1, 71263, '\p{Block=modi}', "");
    Expect(0, 71263, '\p{^Block=modi}', "");
    Expect(0, 71263, '\P{Block=modi}', "");
    Expect(1, 71263, '\P{^Block=modi}', "");
    Expect(0, 71264, '\p{Block=modi}', "");
    Expect(1, 71264, '\p{^Block=modi}', "");
    Expect(1, 71264, '\P{Block=modi}', "");
    Expect(0, 71264, '\P{^Block=modi}', "");
    Expect(1, 71263, '\p{Block: 	_MODI}', "");
    Expect(0, 71263, '\p{^Block: 	_MODI}', "");
    Expect(0, 71263, '\P{Block: 	_MODI}', "");
    Expect(1, 71263, '\P{^Block: 	_MODI}', "");
    Expect(0, 71264, '\p{Block: 	_MODI}', "");
    Expect(1, 71264, '\p{^Block: 	_MODI}', "");
    Expect(1, 71264, '\P{Block: 	_MODI}', "");
    Expect(0, 71264, '\P{^Block: 	_MODI}', "");
    Error('\p{Blk=_modi:=}');
    Error('\P{Blk=_modi:=}');
    Expect(1, 71263, '\p{Blk=modi}', "");
    Expect(0, 71263, '\p{^Blk=modi}', "");
    Expect(0, 71263, '\P{Blk=modi}', "");
    Expect(1, 71263, '\P{^Blk=modi}', "");
    Expect(0, 71264, '\p{Blk=modi}', "");
    Expect(1, 71264, '\p{^Blk=modi}', "");
    Expect(1, 71264, '\P{Blk=modi}', "");
    Expect(0, 71264, '\P{^Blk=modi}', "");
    Expect(1, 71263, '\p{Blk=- Modi}', "");
    Expect(0, 71263, '\p{^Blk=- Modi}', "");
    Expect(0, 71263, '\P{Blk=- Modi}', "");
    Expect(1, 71263, '\P{^Blk=- Modi}', "");
    Expect(0, 71264, '\p{Blk=- Modi}', "");
    Expect(1, 71264, '\p{^Blk=- Modi}', "");
    Expect(1, 71264, '\P{Blk=- Modi}', "");
    Expect(0, 71264, '\P{^Blk=- Modi}', "");
    Error('\p{Is_Block= _Modi/a/}');
    Error('\P{Is_Block= _Modi/a/}');
    Expect(1, 71263, '\p{Is_Block=modi}', "");
    Expect(0, 71263, '\p{^Is_Block=modi}', "");
    Expect(0, 71263, '\P{Is_Block=modi}', "");
    Expect(1, 71263, '\P{^Is_Block=modi}', "");
    Expect(0, 71264, '\p{Is_Block=modi}', "");
    Expect(1, 71264, '\p{^Is_Block=modi}', "");
    Expect(1, 71264, '\P{Is_Block=modi}', "");
    Expect(0, 71264, '\P{^Is_Block=modi}', "");
    Expect(1, 71263, '\p{Is_Block= modi}', "");
    Expect(0, 71263, '\p{^Is_Block= modi}', "");
    Expect(0, 71263, '\P{Is_Block= modi}', "");
    Expect(1, 71263, '\P{^Is_Block= modi}', "");
    Expect(0, 71264, '\p{Is_Block= modi}', "");
    Expect(1, 71264, '\p{^Is_Block= modi}', "");
    Expect(1, 71264, '\P{Is_Block= modi}', "");
    Expect(0, 71264, '\P{^Is_Block= modi}', "");
    Error('\p{Is_Blk=_MODI/a/}');
    Error('\P{Is_Blk=_MODI/a/}');
    Expect(1, 71263, '\p{Is_Blk=modi}', "");
    Expect(0, 71263, '\p{^Is_Blk=modi}', "");
    Expect(0, 71263, '\P{Is_Blk=modi}', "");
    Expect(1, 71263, '\P{^Is_Blk=modi}', "");
    Expect(0, 71264, '\p{Is_Blk=modi}', "");
    Expect(1, 71264, '\p{^Is_Blk=modi}', "");
    Expect(1, 71264, '\P{Is_Blk=modi}', "");
    Expect(0, 71264, '\P{^Is_Blk=modi}', "");
    Expect(1, 71263, '\p{Is_Blk=--Modi}', "");
    Expect(0, 71263, '\p{^Is_Blk=--Modi}', "");
    Expect(0, 71263, '\P{Is_Blk=--Modi}', "");
    Expect(1, 71263, '\P{^Is_Blk=--Modi}', "");
    Expect(0, 71264, '\p{Is_Blk=--Modi}', "");
    Expect(1, 71264, '\p{^Is_Blk=--Modi}', "");
    Expect(1, 71264, '\P{Is_Blk=--Modi}', "");
    Expect(0, 71264, '\P{^Is_Blk=--Modi}', "");
    Error('\p{Block=_:=SPACING_modifier_letters}');
    Error('\P{Block=_:=SPACING_modifier_letters}');
    Expect(1, 767, '\p{Block=spacingmodifierletters}', "");
    Expect(0, 767, '\p{^Block=spacingmodifierletters}', "");
    Expect(0, 767, '\P{Block=spacingmodifierletters}', "");
    Expect(1, 767, '\P{^Block=spacingmodifierletters}', "");
    Expect(0, 768, '\p{Block=spacingmodifierletters}', "");
    Expect(1, 768, '\p{^Block=spacingmodifierletters}', "");
    Expect(1, 768, '\P{Block=spacingmodifierletters}', "");
    Expect(0, 768, '\P{^Block=spacingmodifierletters}', "");
    Expect(1, 767, '\p{Block=_spacing_modifier_LETTERS}', "");
    Expect(0, 767, '\p{^Block=_spacing_modifier_LETTERS}', "");
    Expect(0, 767, '\P{Block=_spacing_modifier_LETTERS}', "");
    Expect(1, 767, '\P{^Block=_spacing_modifier_LETTERS}', "");
    Expect(0, 768, '\p{Block=_spacing_modifier_LETTERS}', "");
    Expect(1, 768, '\p{^Block=_spacing_modifier_LETTERS}', "");
    Expect(1, 768, '\P{Block=_spacing_modifier_LETTERS}', "");
    Expect(0, 768, '\P{^Block=_spacing_modifier_LETTERS}', "");
    Error('\p{Blk=/a/--Modifier_letters}');
    Error('\P{Blk=/a/--Modifier_letters}');
    Expect(1, 767, '\p{Blk=modifierletters}', "");
    Expect(0, 767, '\p{^Blk=modifierletters}', "");
    Expect(0, 767, '\P{Blk=modifierletters}', "");
    Expect(1, 767, '\P{^Blk=modifierletters}', "");
    Expect(0, 768, '\p{Blk=modifierletters}', "");
    Expect(1, 768, '\p{^Blk=modifierletters}', "");
    Expect(1, 768, '\P{Blk=modifierletters}', "");
    Expect(0, 768, '\P{^Blk=modifierletters}', "");
    Expect(1, 767, '\p{Blk=Modifier_letters}', "");
    Expect(0, 767, '\p{^Blk=Modifier_letters}', "");
    Expect(0, 767, '\P{Blk=Modifier_letters}', "");
    Expect(1, 767, '\P{^Blk=Modifier_letters}', "");
    Expect(0, 768, '\p{Blk=Modifier_letters}', "");
    Expect(1, 768, '\p{^Blk=Modifier_letters}', "");
    Expect(1, 768, '\P{Blk=Modifier_letters}', "");
    Expect(0, 768, '\P{^Blk=Modifier_letters}', "");
    Error('\p{Is_Block=- SPACING_Modifier_LETTERS:=}');
    Error('\P{Is_Block=- SPACING_Modifier_LETTERS:=}');
    Expect(1, 767, '\p{Is_Block=spacingmodifierletters}', "");
    Expect(0, 767, '\p{^Is_Block=spacingmodifierletters}', "");
    Expect(0, 767, '\P{Is_Block=spacingmodifierletters}', "");
    Expect(1, 767, '\P{^Is_Block=spacingmodifierletters}', "");
    Expect(0, 768, '\p{Is_Block=spacingmodifierletters}', "");
    Expect(1, 768, '\p{^Is_Block=spacingmodifierletters}', "");
    Expect(1, 768, '\P{Is_Block=spacingmodifierletters}', "");
    Expect(0, 768, '\P{^Is_Block=spacingmodifierletters}', "");
    Expect(1, 767, '\p{Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(0, 767, '\p{^Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(0, 767, '\P{Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(1, 767, '\P{^Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(0, 768, '\p{Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(1, 768, '\p{^Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(1, 768, '\P{Is_Block=Spacing_MODIFIER_letters}', "");
    Expect(0, 768, '\P{^Is_Block=Spacing_MODIFIER_letters}', "");
    Error('\p{Is_Blk=-_modifier_Letters:=}');
    Error('\P{Is_Blk=-_modifier_Letters:=}');
    Expect(1, 767, '\p{Is_Blk: modifierletters}', "");
    Expect(0, 767, '\p{^Is_Blk: modifierletters}', "");
    Expect(0, 767, '\P{Is_Blk: modifierletters}', "");
    Expect(1, 767, '\P{^Is_Blk: modifierletters}', "");
    Expect(0, 768, '\p{Is_Blk: modifierletters}', "");
    Expect(1, 768, '\p{^Is_Blk: modifierletters}', "");
    Expect(1, 768, '\P{Is_Blk: modifierletters}', "");
    Expect(0, 768, '\P{^Is_Blk: modifierletters}', "");
    Expect(1, 767, '\p{Is_Blk=	-Modifier_Letters}', "");
    Expect(0, 767, '\p{^Is_Blk=	-Modifier_Letters}', "");
    Expect(0, 767, '\P{Is_Blk=	-Modifier_Letters}', "");
    Expect(1, 767, '\P{^Is_Blk=	-Modifier_Letters}', "");
    Expect(0, 768, '\p{Is_Blk=	-Modifier_Letters}', "");
    Expect(1, 768, '\p{^Is_Blk=	-Modifier_Letters}', "");
    Expect(1, 768, '\P{Is_Blk=	-Modifier_Letters}', "");
    Expect(0, 768, '\P{^Is_Blk=	-Modifier_Letters}', "");
    Error('\p{Block=/a/modifier_Tone_LETTERS}');
    Error('\P{Block=/a/modifier_Tone_LETTERS}');
    Expect(1, 42783, '\p{Block=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Block=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Block=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Block=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Block=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Block=modifiertoneletters}', "");
    Expect(1, 42784, '\P{Block=modifiertoneletters}', "");
    Expect(0, 42784, '\P{^Block=modifiertoneletters}', "");
    Expect(1, 42783, '\p{Block= modifier_TONE_LETTERS}', "");
    Expect(0, 42783, '\p{^Block= modifier_TONE_LETTERS}', "");
    Expect(0, 42783, '\P{Block= modifier_TONE_LETTERS}', "");
    Expect(1, 42783, '\P{^Block= modifier_TONE_LETTERS}', "");
    Expect(0, 42784, '\p{Block= modifier_TONE_LETTERS}', "");
    Expect(1, 42784, '\p{^Block= modifier_TONE_LETTERS}', "");
    Expect(1, 42784, '\P{Block= modifier_TONE_LETTERS}', "");
    Expect(0, 42784, '\P{^Block= modifier_TONE_LETTERS}', "");
    Error('\p{Blk=:= _Modifier_Tone_letters}');
    Error('\P{Blk=:= _Modifier_Tone_letters}');
    Expect(1, 42783, '\p{Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Blk=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Blk=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Blk=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Blk=modifiertoneletters}', "");
    Expect(1, 42784, '\P{Blk=modifiertoneletters}', "");
    Expect(0, 42784, '\P{^Blk=modifiertoneletters}', "");
    Expect(1, 42783, '\p{Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(0, 42783, '\p{^Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(0, 42783, '\P{Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(1, 42783, '\P{^Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(0, 42784, '\p{Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(1, 42784, '\p{^Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(1, 42784, '\P{Blk=-	MODIFIER_Tone_Letters}', "");
    Expect(0, 42784, '\P{^Blk=-	MODIFIER_Tone_Letters}', "");
    Error('\p{Is_Block=_	modifier_TONE_Letters:=}');
    Error('\P{Is_Block=_	modifier_TONE_Letters:=}');
    Expect(1, 42783, '\p{Is_Block=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Is_Block=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Is_Block=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Is_Block=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Is_Block=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Is_Block=modifiertoneletters}', "");
    Expect(1, 42784, '\P{Is_Block=modifiertoneletters}', "");
    Expect(0, 42784, '\P{^Is_Block=modifiertoneletters}', "");
    Expect(1, 42783, '\p{Is_Block= -Modifier_tone_Letters}', "");
    Expect(0, 42783, '\p{^Is_Block= -Modifier_tone_Letters}', "");
    Expect(0, 42783, '\P{Is_Block= -Modifier_tone_Letters}', "");
    Expect(1, 42783, '\P{^Is_Block= -Modifier_tone_Letters}', "");
    Expect(0, 42784, '\p{Is_Block= -Modifier_tone_Letters}', "");
    Expect(1, 42784, '\p{^Is_Block= -Modifier_tone_Letters}', "");
    Expect(1, 42784, '\P{Is_Block= -Modifier_tone_Letters}', "");
    Expect(0, 42784, '\P{^Is_Block= -Modifier_tone_Letters}', "");
    Error('\p{Is_Blk=:=	MODIFIER_TONE_Letters}');
    Error('\P{Is_Blk=:=	MODIFIER_TONE_Letters}');
    Expect(1, 42783, '\p{Is_Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\p{^Is_Blk=modifiertoneletters}', "");
    Expect(0, 42783, '\P{Is_Blk=modifiertoneletters}', "");
    Expect(1, 42783, '\P{^Is_Blk=modifiertoneletters}', "");
    Expect(0, 42784, '\p{Is_Blk=modifiertoneletters}', "");
    Expect(1, 42784, '\p{^Is_Blk=modifiertoneletters}', "");
    Expect(1, 42784, '\P{Is_Blk=modifiertoneletters}', "");
    Expect(0, 42784, '\P{^Is_Blk=modifiertoneletters}', "");
    Expect(1, 42783, '\p{Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(0, 42783, '\p{^Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(0, 42783, '\P{Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(1, 42783, '\P{^Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(0, 42784, '\p{Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(1, 42784, '\p{^Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(1, 42784, '\P{Is_Blk=_modifier_Tone_LETTERS}', "");
    Expect(0, 42784, '\P{^Is_Blk=_modifier_Tone_LETTERS}', "");
    Error('\p{Block=:=MONGOLIAN}');
    Error('\P{Block=:=MONGOLIAN}');
    Expect(1, 6319, '\p{Block=mongolian}', "");
    Expect(0, 6319, '\p{^Block=mongolian}', "");
    Expect(0, 6319, '\P{Block=mongolian}', "");
    Expect(1, 6319, '\P{^Block=mongolian}', "");
    Expect(0, 6320, '\p{Block=mongolian}', "");
    Expect(1, 6320, '\p{^Block=mongolian}', "");
    Expect(1, 6320, '\P{Block=mongolian}', "");
    Expect(0, 6320, '\P{^Block=mongolian}', "");
    Expect(1, 6319, '\p{Block= 	Mongolian}', "");
    Expect(0, 6319, '\p{^Block= 	Mongolian}', "");
    Expect(0, 6319, '\P{Block= 	Mongolian}', "");
    Expect(1, 6319, '\P{^Block= 	Mongolian}', "");
    Expect(0, 6320, '\p{Block= 	Mongolian}', "");
    Expect(1, 6320, '\p{^Block= 	Mongolian}', "");
    Expect(1, 6320, '\P{Block= 	Mongolian}', "");
    Expect(0, 6320, '\P{^Block= 	Mongolian}', "");
    Error('\p{Blk: :=- mongolian}');
    Error('\P{Blk: :=- mongolian}');
    Expect(1, 6319, '\p{Blk=mongolian}', "");
    Expect(0, 6319, '\p{^Blk=mongolian}', "");
    Expect(0, 6319, '\P{Blk=mongolian}', "");
    Expect(1, 6319, '\P{^Blk=mongolian}', "");
    Expect(0, 6320, '\p{Blk=mongolian}', "");
    Expect(1, 6320, '\p{^Blk=mongolian}', "");
    Expect(1, 6320, '\P{Blk=mongolian}', "");
    Expect(0, 6320, '\P{^Blk=mongolian}', "");
    Expect(1, 6319, '\p{Blk=- mongolian}', "");
    Expect(0, 6319, '\p{^Blk=- mongolian}', "");
    Expect(0, 6319, '\P{Blk=- mongolian}', "");
    Expect(1, 6319, '\P{^Blk=- mongolian}', "");
    Expect(0, 6320, '\p{Blk=- mongolian}', "");
    Expect(1, 6320, '\p{^Blk=- mongolian}', "");
    Expect(1, 6320, '\P{Blk=- mongolian}', "");
    Expect(0, 6320, '\P{^Blk=- mongolian}', "");
    Error('\p{Is_Block= /a/Mongolian}');
    Error('\P{Is_Block= /a/Mongolian}');
    Expect(1, 6319, '\p{Is_Block=mongolian}', "");
    Expect(0, 6319, '\p{^Is_Block=mongolian}', "");
    Expect(0, 6319, '\P{Is_Block=mongolian}', "");
    Expect(1, 6319, '\P{^Is_Block=mongolian}', "");
    Expect(0, 6320, '\p{Is_Block=mongolian}', "");
    Expect(1, 6320, '\p{^Is_Block=mongolian}', "");
    Expect(1, 6320, '\P{Is_Block=mongolian}', "");
    Expect(0, 6320, '\P{^Is_Block=mongolian}', "");
    Expect(1, 6319, '\p{Is_Block=	-mongolian}', "");
    Expect(0, 6319, '\p{^Is_Block=	-mongolian}', "");
    Expect(0, 6319, '\P{Is_Block=	-mongolian}', "");
    Expect(1, 6319, '\P{^Is_Block=	-mongolian}', "");
    Expect(0, 6320, '\p{Is_Block=	-mongolian}', "");
    Expect(1, 6320, '\p{^Is_Block=	-mongolian}', "");
    Expect(1, 6320, '\P{Is_Block=	-mongolian}', "");
    Expect(0, 6320, '\P{^Is_Block=	-mongolian}', "");
    Error('\p{Is_Blk=	/a/Mongolian}');
    Error('\P{Is_Blk=	/a/Mongolian}');
    Expect(1, 6319, '\p{Is_Blk=mongolian}', "");
    Expect(0, 6319, '\p{^Is_Blk=mongolian}', "");
    Expect(0, 6319, '\P{Is_Blk=mongolian}', "");
    Expect(1, 6319, '\P{^Is_Blk=mongolian}', "");
    Expect(0, 6320, '\p{Is_Blk=mongolian}', "");
    Expect(1, 6320, '\p{^Is_Blk=mongolian}', "");
    Expect(1, 6320, '\P{Is_Blk=mongolian}', "");
    Expect(0, 6320, '\P{^Is_Blk=mongolian}', "");
    Expect(1, 6319, '\p{Is_Blk:_Mongolian}', "");
    Expect(0, 6319, '\p{^Is_Blk:_Mongolian}', "");
    Expect(0, 6319, '\P{Is_Blk:_Mongolian}', "");
    Expect(1, 6319, '\P{^Is_Blk:_Mongolian}', "");
    Expect(0, 6320, '\p{Is_Blk:_Mongolian}', "");
    Expect(1, 6320, '\p{^Is_Blk:_Mongolian}', "");
    Expect(1, 6320, '\P{Is_Blk:_Mongolian}', "");
    Expect(0, 6320, '\P{^Is_Blk:_Mongolian}', "");
    Error('\p{Block=_	mongolian_SUPPLEMENT/a/}');
    Error('\P{Block=_	mongolian_SUPPLEMENT/a/}');
    Expect(1, 71295, '\p{Block=mongoliansupplement}', "");
    Expect(0, 71295, '\p{^Block=mongoliansupplement}', "");
    Expect(0, 71295, '\P{Block=mongoliansupplement}', "");
    Expect(1, 71295, '\P{^Block=mongoliansupplement}', "");
    Expect(0, 71296, '\p{Block=mongoliansupplement}', "");
    Expect(1, 71296, '\p{^Block=mongoliansupplement}', "");
    Expect(1, 71296, '\P{Block=mongoliansupplement}', "");
    Expect(0, 71296, '\P{^Block=mongoliansupplement}', "");
    Expect(1, 71295, '\p{Block=MONGOLIAN_Supplement}', "");
    Expect(0, 71295, '\p{^Block=MONGOLIAN_Supplement}', "");
    Expect(0, 71295, '\P{Block=MONGOLIAN_Supplement}', "");
    Expect(1, 71295, '\P{^Block=MONGOLIAN_Supplement}', "");
    Expect(0, 71296, '\p{Block=MONGOLIAN_Supplement}', "");
    Expect(1, 71296, '\p{^Block=MONGOLIAN_Supplement}', "");
    Expect(1, 71296, '\P{Block=MONGOLIAN_Supplement}', "");
    Expect(0, 71296, '\P{^Block=MONGOLIAN_Supplement}', "");
    Error('\p{Blk=	Mongolian_SUP:=}');
    Error('\P{Blk=	Mongolian_SUP:=}');
    Expect(1, 71295, '\p{Blk=mongoliansup}', "");
    Expect(0, 71295, '\p{^Blk=mongoliansup}', "");
    Expect(0, 71295, '\P{Blk=mongoliansup}', "");
    Expect(1, 71295, '\P{^Blk=mongoliansup}', "");
    Expect(0, 71296, '\p{Blk=mongoliansup}', "");
    Expect(1, 71296, '\p{^Blk=mongoliansup}', "");
    Expect(1, 71296, '\P{Blk=mongoliansup}', "");
    Expect(0, 71296, '\P{^Blk=mongoliansup}', "");
    Expect(1, 71295, '\p{Blk= 	MONGOLIAN_Sup}', "");
    Expect(0, 71295, '\p{^Blk= 	MONGOLIAN_Sup}', "");
    Expect(0, 71295, '\P{Blk= 	MONGOLIAN_Sup}', "");
    Expect(1, 71295, '\P{^Blk= 	MONGOLIAN_Sup}', "");
    Expect(0, 71296, '\p{Blk= 	MONGOLIAN_Sup}', "");
    Expect(1, 71296, '\p{^Blk= 	MONGOLIAN_Sup}', "");
    Expect(1, 71296, '\P{Blk= 	MONGOLIAN_Sup}', "");
    Expect(0, 71296, '\P{^Blk= 	MONGOLIAN_Sup}', "");
    Error('\p{Is_Block=_/a/MONGOLIAN_SUPPLEMENT}');
    Error('\P{Is_Block=_/a/MONGOLIAN_SUPPLEMENT}');
    Expect(1, 71295, '\p{Is_Block=mongoliansupplement}', "");
    Expect(0, 71295, '\p{^Is_Block=mongoliansupplement}', "");
    Expect(0, 71295, '\P{Is_Block=mongoliansupplement}', "");
    Expect(1, 71295, '\P{^Is_Block=mongoliansupplement}', "");
    Expect(0, 71296, '\p{Is_Block=mongoliansupplement}', "");
    Expect(1, 71296, '\p{^Is_Block=mongoliansupplement}', "");
    Expect(1, 71296, '\P{Is_Block=mongoliansupplement}', "");
    Expect(0, 71296, '\P{^Is_Block=mongoliansupplement}', "");
    Expect(1, 71295, '\p{Is_Block=-_Mongolian_supplement}', "");
    Expect(0, 71295, '\p{^Is_Block=-_Mongolian_supplement}', "");
    Expect(0, 71295, '\P{Is_Block=-_Mongolian_supplement}', "");
    Expect(1, 71295, '\P{^Is_Block=-_Mongolian_supplement}', "");
    Expect(0, 71296, '\p{Is_Block=-_Mongolian_supplement}', "");
    Expect(1, 71296, '\p{^Is_Block=-_Mongolian_supplement}', "");
    Expect(1, 71296, '\P{Is_Block=-_Mongolian_supplement}', "");
    Expect(0, 71296, '\P{^Is_Block=-_Mongolian_supplement}', "");
    Error('\p{Is_Blk:	/a/	-Mongolian_sup}');
    Error('\P{Is_Blk:	/a/	-Mongolian_sup}');
    Expect(1, 71295, '\p{Is_Blk=mongoliansup}', "");
    Expect(0, 71295, '\p{^Is_Blk=mongoliansup}', "");
    Expect(0, 71295, '\P{Is_Blk=mongoliansup}', "");
    Expect(1, 71295, '\P{^Is_Blk=mongoliansup}', "");
    Expect(0, 71296, '\p{Is_Blk=mongoliansup}', "");
    Expect(1, 71296, '\p{^Is_Blk=mongoliansup}', "");
    Expect(1, 71296, '\P{Is_Blk=mongoliansup}', "");
    Expect(0, 71296, '\P{^Is_Blk=mongoliansup}', "");
    Expect(1, 71295, '\p{Is_Blk=_ Mongolian_sup}', "");
    Expect(0, 71295, '\p{^Is_Blk=_ Mongolian_sup}', "");
    Expect(0, 71295, '\P{Is_Blk=_ Mongolian_sup}', "");
    Expect(1, 71295, '\P{^Is_Blk=_ Mongolian_sup}', "");
    Expect(0, 71296, '\p{Is_Blk=_ Mongolian_sup}', "");
    Expect(1, 71296, '\p{^Is_Blk=_ Mongolian_sup}', "");
    Expect(1, 71296, '\P{Is_Blk=_ Mongolian_sup}', "");
    Expect(0, 71296, '\P{^Is_Blk=_ Mongolian_sup}', "");
    Error('\p{Block=	MRO/a/}');
    Error('\P{Block=	MRO/a/}');
    Expect(1, 92783, '\p{Block=mro}', "");
    Expect(0, 92783, '\p{^Block=mro}', "");
    Expect(0, 92783, '\P{Block=mro}', "");
    Expect(1, 92783, '\P{^Block=mro}', "");
    Expect(0, 92784, '\p{Block=mro}', "");
    Expect(1, 92784, '\p{^Block=mro}', "");
    Expect(1, 92784, '\P{Block=mro}', "");
    Expect(0, 92784, '\P{^Block=mro}', "");
    Expect(1, 92783, '\p{Block=	Mro}', "");
    Expect(0, 92783, '\p{^Block=	Mro}', "");
    Expect(0, 92783, '\P{Block=	Mro}', "");
    Expect(1, 92783, '\P{^Block=	Mro}', "");
    Expect(0, 92784, '\p{Block=	Mro}', "");
    Expect(1, 92784, '\p{^Block=	Mro}', "");
    Expect(1, 92784, '\P{Block=	Mro}', "");
    Expect(0, 92784, '\P{^Block=	Mro}', "");
    Error('\p{Blk:  -mro:=}');
    Error('\P{Blk:  -mro:=}');
    Expect(1, 92783, '\p{Blk=mro}', "");
    Expect(0, 92783, '\p{^Blk=mro}', "");
    Expect(0, 92783, '\P{Blk=mro}', "");
    Expect(1, 92783, '\P{^Blk=mro}', "");
    Expect(0, 92784, '\p{Blk=mro}', "");
    Expect(1, 92784, '\p{^Blk=mro}', "");
    Expect(1, 92784, '\P{Blk=mro}', "");
    Expect(0, 92784, '\P{^Blk=mro}', "");
    Expect(1, 92783, '\p{Blk= _MRO}', "");
    Expect(0, 92783, '\p{^Blk= _MRO}', "");
    Expect(0, 92783, '\P{Blk= _MRO}', "");
    Expect(1, 92783, '\P{^Blk= _MRO}', "");
    Expect(0, 92784, '\p{Blk= _MRO}', "");
    Expect(1, 92784, '\p{^Blk= _MRO}', "");
    Expect(1, 92784, '\P{Blk= _MRO}', "");
    Expect(0, 92784, '\P{^Blk= _MRO}', "");
    Error('\p{Is_Block=-:=MRO}');
    Error('\P{Is_Block=-:=MRO}');
    Expect(1, 92783, '\p{Is_Block=mro}', "");
    Expect(0, 92783, '\p{^Is_Block=mro}', "");
    Expect(0, 92783, '\P{Is_Block=mro}', "");
    Expect(1, 92783, '\P{^Is_Block=mro}', "");
    Expect(0, 92784, '\p{Is_Block=mro}', "");
    Expect(1, 92784, '\p{^Is_Block=mro}', "");
    Expect(1, 92784, '\P{Is_Block=mro}', "");
    Expect(0, 92784, '\P{^Is_Block=mro}', "");
    Expect(1, 92783, '\p{Is_Block=-_Mro}', "");
    Expect(0, 92783, '\p{^Is_Block=-_Mro}', "");
    Expect(0, 92783, '\P{Is_Block=-_Mro}', "");
    Expect(1, 92783, '\P{^Is_Block=-_Mro}', "");
    Expect(0, 92784, '\p{Is_Block=-_Mro}', "");
    Expect(1, 92784, '\p{^Is_Block=-_Mro}', "");
    Expect(1, 92784, '\P{Is_Block=-_Mro}', "");
    Expect(0, 92784, '\P{^Is_Block=-_Mro}', "");
    Error('\p{Is_Blk=	:=mro}');
    Error('\P{Is_Blk=	:=mro}');
    Expect(1, 92783, '\p{Is_Blk=mro}', "");
    Expect(0, 92783, '\p{^Is_Blk=mro}', "");
    Expect(0, 92783, '\P{Is_Blk=mro}', "");
    Expect(1, 92783, '\P{^Is_Blk=mro}', "");
    Expect(0, 92784, '\p{Is_Blk=mro}', "");
    Expect(1, 92784, '\p{^Is_Blk=mro}', "");
    Expect(1, 92784, '\P{Is_Blk=mro}', "");
    Expect(0, 92784, '\P{^Is_Blk=mro}', "");
    Expect(1, 92783, '\p{Is_Blk=  Mro}', "");
    Expect(0, 92783, '\p{^Is_Blk=  Mro}', "");
    Expect(0, 92783, '\P{Is_Blk=  Mro}', "");
    Expect(1, 92783, '\P{^Is_Blk=  Mro}', "");
    Expect(0, 92784, '\p{Is_Blk=  Mro}', "");
    Expect(1, 92784, '\p{^Is_Blk=  Mro}', "");
    Expect(1, 92784, '\P{Is_Blk=  Mro}', "");
    Expect(0, 92784, '\P{^Is_Blk=  Mro}', "");
    Error('\p{Block=__MULTANI:=}');
    Error('\P{Block=__MULTANI:=}');
    Expect(1, 70319, '\p{Block:	multani}', "");
    Expect(0, 70319, '\p{^Block:	multani}', "");
    Expect(0, 70319, '\P{Block:	multani}', "");
    Expect(1, 70319, '\P{^Block:	multani}', "");
    Expect(0, 70320, '\p{Block:	multani}', "");
    Expect(1, 70320, '\p{^Block:	multani}', "");
    Expect(1, 70320, '\P{Block:	multani}', "");
    Expect(0, 70320, '\P{^Block:	multani}', "");
    Expect(1, 70319, '\p{Block=	_Multani}', "");
    Expect(0, 70319, '\p{^Block=	_Multani}', "");
    Expect(0, 70319, '\P{Block=	_Multani}', "");
    Expect(1, 70319, '\P{^Block=	_Multani}', "");
    Expect(0, 70320, '\p{Block=	_Multani}', "");
    Expect(1, 70320, '\p{^Block=	_Multani}', "");
    Expect(1, 70320, '\P{Block=	_Multani}', "");
    Expect(0, 70320, '\P{^Block=	_Multani}', "");
    Error('\p{Blk=-/a/Multani}');
    Error('\P{Blk=-/a/Multani}');
    Expect(1, 70319, '\p{Blk=multani}', "");
    Expect(0, 70319, '\p{^Blk=multani}', "");
    Expect(0, 70319, '\P{Blk=multani}', "");
    Expect(1, 70319, '\P{^Blk=multani}', "");
    Expect(0, 70320, '\p{Blk=multani}', "");
    Expect(1, 70320, '\p{^Blk=multani}', "");
    Expect(1, 70320, '\P{Blk=multani}', "");
    Expect(0, 70320, '\P{^Blk=multani}', "");
    Expect(1, 70319, '\p{Blk=	multani}', "");
    Expect(0, 70319, '\p{^Blk=	multani}', "");
    Expect(0, 70319, '\P{Blk=	multani}', "");
    Expect(1, 70319, '\P{^Blk=	multani}', "");
    Expect(0, 70320, '\p{Blk=	multani}', "");
    Expect(1, 70320, '\p{^Blk=	multani}', "");
    Expect(1, 70320, '\P{Blk=	multani}', "");
    Expect(0, 70320, '\P{^Blk=	multani}', "");
    Error('\p{Is_Block=/a/MULTANI}');
    Error('\P{Is_Block=/a/MULTANI}');
    Expect(1, 70319, '\p{Is_Block:multani}', "");
    Expect(0, 70319, '\p{^Is_Block:multani}', "");
    Expect(0, 70319, '\P{Is_Block:multani}', "");
    Expect(1, 70319, '\P{^Is_Block:multani}', "");
    Expect(0, 70320, '\p{Is_Block:multani}', "");
    Expect(1, 70320, '\p{^Is_Block:multani}', "");
    Expect(1, 70320, '\P{Is_Block:multani}', "");
    Expect(0, 70320, '\P{^Is_Block:multani}', "");
    Expect(1, 70319, '\p{Is_Block=	_multani}', "");
    Expect(0, 70319, '\p{^Is_Block=	_multani}', "");
    Expect(0, 70319, '\P{Is_Block=	_multani}', "");
    Expect(1, 70319, '\P{^Is_Block=	_multani}', "");
    Expect(0, 70320, '\p{Is_Block=	_multani}', "");
    Expect(1, 70320, '\p{^Is_Block=	_multani}', "");
    Expect(1, 70320, '\P{Is_Block=	_multani}', "");
    Expect(0, 70320, '\P{^Is_Block=	_multani}', "");
    Error('\p{Is_Blk=:=-	multani}');
    Error('\P{Is_Blk=:=-	multani}');
    Expect(1, 70319, '\p{Is_Blk:   multani}', "");
    Expect(0, 70319, '\p{^Is_Blk:   multani}', "");
    Expect(0, 70319, '\P{Is_Blk:   multani}', "");
    Expect(1, 70319, '\P{^Is_Blk:   multani}', "");
    Expect(0, 70320, '\p{Is_Blk:   multani}', "");
    Expect(1, 70320, '\p{^Is_Blk:   multani}', "");
    Expect(1, 70320, '\P{Is_Blk:   multani}', "");
    Expect(0, 70320, '\P{^Is_Blk:   multani}', "");
    Expect(1, 70319, '\p{Is_Blk=--Multani}', "");
    Expect(0, 70319, '\p{^Is_Blk=--Multani}', "");
    Expect(0, 70319, '\P{Is_Blk=--Multani}', "");
    Expect(1, 70319, '\P{^Is_Blk=--Multani}', "");
    Expect(0, 70320, '\p{Is_Blk=--Multani}', "");
    Expect(1, 70320, '\p{^Is_Blk=--Multani}', "");
    Expect(1, 70320, '\P{Is_Blk=--Multani}', "");
    Expect(0, 70320, '\P{^Is_Blk=--Multani}', "");
    Error('\p{Block: :=_musical_SYMBOLS}');
    Error('\P{Block: :=_musical_SYMBOLS}');
    Expect(1, 119295, '\p{Block=musicalsymbols}', "");
    Expect(0, 119295, '\p{^Block=musicalsymbols}', "");
    Expect(0, 119295, '\P{Block=musicalsymbols}', "");
    Expect(1, 119295, '\P{^Block=musicalsymbols}', "");
    Expect(0, 119296, '\p{Block=musicalsymbols}', "");
    Expect(1, 119296, '\p{^Block=musicalsymbols}', "");
    Expect(1, 119296, '\P{Block=musicalsymbols}', "");
    Expect(0, 119296, '\P{^Block=musicalsymbols}', "");
    Expect(1, 119295, '\p{Block=	Musical_symbols}', "");
    Expect(0, 119295, '\p{^Block=	Musical_symbols}', "");
    Expect(0, 119295, '\P{Block=	Musical_symbols}', "");
    Expect(1, 119295, '\P{^Block=	Musical_symbols}', "");
    Expect(0, 119296, '\p{Block=	Musical_symbols}', "");
    Expect(1, 119296, '\p{^Block=	Musical_symbols}', "");
    Expect(1, 119296, '\P{Block=	Musical_symbols}', "");
    Expect(0, 119296, '\P{^Block=	Musical_symbols}', "");
    Error('\p{Blk=	Music:=}');
    Error('\P{Blk=	Music:=}');
    Expect(1, 119295, '\p{Blk=music}', "");
    Expect(0, 119295, '\p{^Blk=music}', "");
    Expect(0, 119295, '\P{Blk=music}', "");
    Expect(1, 119295, '\P{^Blk=music}', "");
    Expect(0, 119296, '\p{Blk=music}', "");
    Expect(1, 119296, '\p{^Blk=music}', "");
    Expect(1, 119296, '\P{Blk=music}', "");
    Expect(0, 119296, '\P{^Blk=music}', "");
    Expect(1, 119295, '\p{Blk= _Music}', "");
    Expect(0, 119295, '\p{^Blk= _Music}', "");
    Expect(0, 119295, '\P{Blk= _Music}', "");
    Expect(1, 119295, '\P{^Blk= _Music}', "");
    Expect(0, 119296, '\p{Blk= _Music}', "");
    Expect(1, 119296, '\p{^Blk= _Music}', "");
    Expect(1, 119296, '\P{Blk= _Music}', "");
    Expect(0, 119296, '\P{^Blk= _Music}', "");
    Error('\p{Is_Block=--Musical_Symbols/a/}');
    Error('\P{Is_Block=--Musical_Symbols/a/}');
    Expect(1, 119295, '\p{Is_Block=musicalsymbols}', "");
    Expect(0, 119295, '\p{^Is_Block=musicalsymbols}', "");
    Expect(0, 119295, '\P{Is_Block=musicalsymbols}', "");
    Expect(1, 119295, '\P{^Is_Block=musicalsymbols}', "");
    Expect(0, 119296, '\p{Is_Block=musicalsymbols}', "");
    Expect(1, 119296, '\p{^Is_Block=musicalsymbols}', "");
    Expect(1, 119296, '\P{Is_Block=musicalsymbols}', "");
    Expect(0, 119296, '\P{^Is_Block=musicalsymbols}', "");
    Expect(1, 119295, '\p{Is_Block= musical_Symbols}', "");
    Expect(0, 119295, '\p{^Is_Block= musical_Symbols}', "");
    Expect(0, 119295, '\P{Is_Block= musical_Symbols}', "");
    Expect(1, 119295, '\P{^Is_Block= musical_Symbols}', "");
    Expect(0, 119296, '\p{Is_Block= musical_Symbols}', "");
    Expect(1, 119296, '\p{^Is_Block= musical_Symbols}', "");
    Expect(1, 119296, '\P{Is_Block= musical_Symbols}', "");
    Expect(0, 119296, '\P{^Is_Block= musical_Symbols}', "");
    Error('\p{Is_Blk=-	Music:=}');
    Error('\P{Is_Blk=-	Music:=}');
    Expect(1, 119295, '\p{Is_Blk=music}', "");
    Expect(0, 119295, '\p{^Is_Blk=music}', "");
    Expect(0, 119295, '\P{Is_Blk=music}', "");
    Expect(1, 119295, '\P{^Is_Blk=music}', "");
    Expect(0, 119296, '\p{Is_Blk=music}', "");
    Expect(1, 119296, '\p{^Is_Blk=music}', "");
    Expect(1, 119296, '\P{Is_Blk=music}', "");
    Expect(0, 119296, '\P{^Is_Blk=music}', "");
    Expect(1, 119295, '\p{Is_Blk=_-MUSIC}', "");
    Expect(0, 119295, '\p{^Is_Blk=_-MUSIC}', "");
    Expect(0, 119295, '\P{Is_Blk=_-MUSIC}', "");
    Expect(1, 119295, '\P{^Is_Blk=_-MUSIC}', "");
    Expect(0, 119296, '\p{Is_Blk=_-MUSIC}', "");
    Expect(1, 119296, '\p{^Is_Blk=_-MUSIC}', "");
    Expect(1, 119296, '\P{Is_Blk=_-MUSIC}', "");
    Expect(0, 119296, '\P{^Is_Blk=_-MUSIC}', "");
    Error('\p{Block=-Myanmar/a/}');
    Error('\P{Block=-Myanmar/a/}');
    Expect(1, 4255, '\p{Block=myanmar}', "");
    Expect(0, 4255, '\p{^Block=myanmar}', "");
    Expect(0, 4255, '\P{Block=myanmar}', "");
    Expect(1, 4255, '\P{^Block=myanmar}', "");
    Expect(0, 4256, '\p{Block=myanmar}', "");
    Expect(1, 4256, '\p{^Block=myanmar}', "");
    Expect(1, 4256, '\P{Block=myanmar}', "");
    Expect(0, 4256, '\P{^Block=myanmar}', "");
    Expect(1, 4255, '\p{Block:    _Myanmar}', "");
    Expect(0, 4255, '\p{^Block:    _Myanmar}', "");
    Expect(0, 4255, '\P{Block:    _Myanmar}', "");
    Expect(1, 4255, '\P{^Block:    _Myanmar}', "");
    Expect(0, 4256, '\p{Block:    _Myanmar}', "");
    Expect(1, 4256, '\p{^Block:    _Myanmar}', "");
    Expect(1, 4256, '\P{Block:    _Myanmar}', "");
    Expect(0, 4256, '\P{^Block:    _Myanmar}', "");
    Error('\p{Blk=/a/__MYANMAR}');
    Error('\P{Blk=/a/__MYANMAR}');
    Expect(1, 4255, '\p{Blk:	myanmar}', "");
    Expect(0, 4255, '\p{^Blk:	myanmar}', "");
    Expect(0, 4255, '\P{Blk:	myanmar}', "");
    Expect(1, 4255, '\P{^Blk:	myanmar}', "");
    Expect(0, 4256, '\p{Blk:	myanmar}', "");
    Expect(1, 4256, '\p{^Blk:	myanmar}', "");
    Expect(1, 4256, '\P{Blk:	myanmar}', "");
    Expect(0, 4256, '\P{^Blk:	myanmar}', "");
    Expect(1, 4255, '\p{Blk=-MYANMAR}', "");
    Expect(0, 4255, '\p{^Blk=-MYANMAR}', "");
    Expect(0, 4255, '\P{Blk=-MYANMAR}', "");
    Expect(1, 4255, '\P{^Blk=-MYANMAR}', "");
    Expect(0, 4256, '\p{Blk=-MYANMAR}', "");
    Expect(1, 4256, '\p{^Blk=-MYANMAR}', "");
    Expect(1, 4256, '\P{Blk=-MYANMAR}', "");
    Expect(0, 4256, '\P{^Blk=-MYANMAR}', "");
    Error('\p{Is_Block=:=_-Myanmar}');
    Error('\P{Is_Block=:=_-Myanmar}');
    Expect(1, 4255, '\p{Is_Block:   myanmar}', "");
    Expect(0, 4255, '\p{^Is_Block:   myanmar}', "");
    Expect(0, 4255, '\P{Is_Block:   myanmar}', "");
    Expect(1, 4255, '\P{^Is_Block:   myanmar}', "");
    Expect(0, 4256, '\p{Is_Block:   myanmar}', "");
    Expect(1, 4256, '\p{^Is_Block:   myanmar}', "");
    Expect(1, 4256, '\P{Is_Block:   myanmar}', "");
    Expect(0, 4256, '\P{^Is_Block:   myanmar}', "");
    Expect(1, 4255, '\p{Is_Block=	 Myanmar}', "");
    Expect(0, 4255, '\p{^Is_Block=	 Myanmar}', "");
    Expect(0, 4255, '\P{Is_Block=	 Myanmar}', "");
    Expect(1, 4255, '\P{^Is_Block=	 Myanmar}', "");
    Expect(0, 4256, '\p{Is_Block=	 Myanmar}', "");
    Expect(1, 4256, '\p{^Is_Block=	 Myanmar}', "");
    Expect(1, 4256, '\P{Is_Block=	 Myanmar}', "");
    Expect(0, 4256, '\P{^Is_Block=	 Myanmar}', "");
    Error('\p{Is_Blk: /a/  Myanmar}');
    Error('\P{Is_Blk: /a/  Myanmar}');
    Expect(1, 4255, '\p{Is_Blk=myanmar}', "");
    Expect(0, 4255, '\p{^Is_Blk=myanmar}', "");
    Expect(0, 4255, '\P{Is_Blk=myanmar}', "");
    Expect(1, 4255, '\P{^Is_Blk=myanmar}', "");
    Expect(0, 4256, '\p{Is_Blk=myanmar}', "");
    Expect(1, 4256, '\p{^Is_Blk=myanmar}', "");
    Expect(1, 4256, '\P{Is_Blk=myanmar}', "");
    Expect(0, 4256, '\P{^Is_Blk=myanmar}', "");
    Expect(1, 4255, '\p{Is_Blk= -MYANMAR}', "");
    Expect(0, 4255, '\p{^Is_Blk= -MYANMAR}', "");
    Expect(0, 4255, '\P{Is_Blk= -MYANMAR}', "");
    Expect(1, 4255, '\P{^Is_Blk= -MYANMAR}', "");
    Expect(0, 4256, '\p{Is_Blk= -MYANMAR}', "");
    Expect(1, 4256, '\p{^Is_Blk= -MYANMAR}', "");
    Expect(1, 4256, '\P{Is_Blk= -MYANMAR}', "");
    Expect(0, 4256, '\P{^Is_Blk= -MYANMAR}', "");
    Error('\p{Block=/a/-Myanmar_extended_A}');
    Error('\P{Block=/a/-Myanmar_extended_A}');
    Expect(1, 43647, '\p{Block=myanmarextendeda}', "");
    Expect(0, 43647, '\p{^Block=myanmarextendeda}', "");
    Expect(0, 43647, '\P{Block=myanmarextendeda}', "");
    Expect(1, 43647, '\P{^Block=myanmarextendeda}', "");
    Expect(0, 43648, '\p{Block=myanmarextendeda}', "");
    Expect(1, 43648, '\p{^Block=myanmarextendeda}', "");
    Expect(1, 43648, '\P{Block=myanmarextendeda}', "");
    Expect(0, 43648, '\P{^Block=myanmarextendeda}', "");
    Expect(1, 43647, '\p{Block:		Myanmar_extended_A}', "");
    Expect(0, 43647, '\p{^Block:		Myanmar_extended_A}', "");
    Expect(0, 43647, '\P{Block:		Myanmar_extended_A}', "");
    Expect(1, 43647, '\P{^Block:		Myanmar_extended_A}', "");
    Expect(0, 43648, '\p{Block:		Myanmar_extended_A}', "");
    Expect(1, 43648, '\p{^Block:		Myanmar_extended_A}', "");
    Expect(1, 43648, '\P{Block:		Myanmar_extended_A}', "");
    Expect(0, 43648, '\P{^Block:		Myanmar_extended_A}', "");
    Error('\p{Blk= :=MYANMAR_Ext_A}');
    Error('\P{Blk= :=MYANMAR_Ext_A}');
    Expect(1, 43647, '\p{Blk=myanmarexta}', "");
    Expect(0, 43647, '\p{^Blk=myanmarexta}', "");
    Expect(0, 43647, '\P{Blk=myanmarexta}', "");
    Expect(1, 43647, '\P{^Blk=myanmarexta}', "");
    Expect(0, 43648, '\p{Blk=myanmarexta}', "");
    Expect(1, 43648, '\p{^Blk=myanmarexta}', "");
    Expect(1, 43648, '\P{Blk=myanmarexta}', "");
    Expect(0, 43648, '\P{^Blk=myanmarexta}', "");
    Expect(1, 43647, '\p{Blk= _MYANMAR_ext_A}', "");
    Expect(0, 43647, '\p{^Blk= _MYANMAR_ext_A}', "");
    Expect(0, 43647, '\P{Blk= _MYANMAR_ext_A}', "");
    Expect(1, 43647, '\P{^Blk= _MYANMAR_ext_A}', "");
    Expect(0, 43648, '\p{Blk= _MYANMAR_ext_A}', "");
    Expect(1, 43648, '\p{^Blk= _MYANMAR_ext_A}', "");
    Expect(1, 43648, '\P{Blk= _MYANMAR_ext_A}', "");
    Expect(0, 43648, '\P{^Blk= _MYANMAR_ext_A}', "");
    Error('\p{Is_Block=	:=Myanmar_Extended_A}');
    Error('\P{Is_Block=	:=Myanmar_Extended_A}');
    Expect(1, 43647, '\p{Is_Block=myanmarextendeda}', "");
    Expect(0, 43647, '\p{^Is_Block=myanmarextendeda}', "");
    Expect(0, 43647, '\P{Is_Block=myanmarextendeda}', "");
    Expect(1, 43647, '\P{^Is_Block=myanmarextendeda}', "");
    Expect(0, 43648, '\p{Is_Block=myanmarextendeda}', "");
    Expect(1, 43648, '\p{^Is_Block=myanmarextendeda}', "");
    Expect(1, 43648, '\P{Is_Block=myanmarextendeda}', "");
    Expect(0, 43648, '\P{^Is_Block=myanmarextendeda}', "");
    Expect(1, 43647, '\p{Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(0, 43647, '\p{^Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(0, 43647, '\P{Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(1, 43647, '\P{^Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(0, 43648, '\p{Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(1, 43648, '\p{^Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(1, 43648, '\P{Is_Block= 	Myanmar_EXTENDED_A}', "");
    Expect(0, 43648, '\P{^Is_Block= 	Myanmar_EXTENDED_A}', "");
    Error('\p{Is_Blk:  /a/MYANMAR_ext_A}');
    Error('\P{Is_Blk:  /a/MYANMAR_ext_A}');
    Expect(1, 43647, '\p{Is_Blk=myanmarexta}', "");
    Expect(0, 43647, '\p{^Is_Blk=myanmarexta}', "");
    Expect(0, 43647, '\P{Is_Blk=myanmarexta}', "");
    Expect(1, 43647, '\P{^Is_Blk=myanmarexta}', "");
    Expect(0, 43648, '\p{Is_Blk=myanmarexta}', "");
    Expect(1, 43648, '\p{^Is_Blk=myanmarexta}', "");
    Expect(1, 43648, '\P{Is_Blk=myanmarexta}', "");
    Expect(0, 43648, '\P{^Is_Blk=myanmarexta}', "");
    Expect(1, 43647, '\p{Is_Blk=_Myanmar_EXT_a}', "");
    Expect(0, 43647, '\p{^Is_Blk=_Myanmar_EXT_a}', "");
    Expect(0, 43647, '\P{Is_Blk=_Myanmar_EXT_a}', "");
    Expect(1, 43647, '\P{^Is_Blk=_Myanmar_EXT_a}', "");
    Expect(0, 43648, '\p{Is_Blk=_Myanmar_EXT_a}', "");
    Expect(1, 43648, '\p{^Is_Blk=_Myanmar_EXT_a}', "");
    Expect(1, 43648, '\P{Is_Blk=_Myanmar_EXT_a}', "");
    Expect(0, 43648, '\P{^Is_Blk=_Myanmar_EXT_a}', "");
    Error('\p{Block= _Myanmar_Extended_b/a/}');
    Error('\P{Block= _Myanmar_Extended_b/a/}');
    Expect(1, 43519, '\p{Block=myanmarextendedb}', "");
    Expect(0, 43519, '\p{^Block=myanmarextendedb}', "");
    Expect(0, 43519, '\P{Block=myanmarextendedb}', "");
    Expect(1, 43519, '\P{^Block=myanmarextendedb}', "");
    Expect(0, 43520, '\p{Block=myanmarextendedb}', "");
    Expect(1, 43520, '\p{^Block=myanmarextendedb}', "");
    Expect(1, 43520, '\P{Block=myanmarextendedb}', "");
    Expect(0, 43520, '\P{^Block=myanmarextendedb}', "");
    Expect(1, 43519, '\p{Block:--MYANMAR_extended_B}', "");
    Expect(0, 43519, '\p{^Block:--MYANMAR_extended_B}', "");
    Expect(0, 43519, '\P{Block:--MYANMAR_extended_B}', "");
    Expect(1, 43519, '\P{^Block:--MYANMAR_extended_B}', "");
    Expect(0, 43520, '\p{Block:--MYANMAR_extended_B}', "");
    Expect(1, 43520, '\p{^Block:--MYANMAR_extended_B}', "");
    Expect(1, 43520, '\P{Block:--MYANMAR_extended_B}', "");
    Expect(0, 43520, '\P{^Block:--MYANMAR_extended_B}', "");
    Error('\p{Blk=-:=Myanmar_Ext_B}');
    Error('\P{Blk=-:=Myanmar_Ext_B}');
    Expect(1, 43519, '\p{Blk=myanmarextb}', "");
    Expect(0, 43519, '\p{^Blk=myanmarextb}', "");
    Expect(0, 43519, '\P{Blk=myanmarextb}', "");
    Expect(1, 43519, '\P{^Blk=myanmarextb}', "");
    Expect(0, 43520, '\p{Blk=myanmarextb}', "");
    Expect(1, 43520, '\p{^Blk=myanmarextb}', "");
    Expect(1, 43520, '\P{Blk=myanmarextb}', "");
    Expect(0, 43520, '\P{^Blk=myanmarextb}', "");
    Expect(1, 43519, '\p{Blk=		Myanmar_EXT_B}', "");
    Expect(0, 43519, '\p{^Blk=		Myanmar_EXT_B}', "");
    Expect(0, 43519, '\P{Blk=		Myanmar_EXT_B}', "");
    Expect(1, 43519, '\P{^Blk=		Myanmar_EXT_B}', "");
    Expect(0, 43520, '\p{Blk=		Myanmar_EXT_B}', "");
    Expect(1, 43520, '\p{^Blk=		Myanmar_EXT_B}', "");
    Expect(1, 43520, '\P{Blk=		Myanmar_EXT_B}', "");
    Expect(0, 43520, '\P{^Blk=		Myanmar_EXT_B}', "");
    Error('\p{Is_Block::=	myanmar_EXTENDED_B}');
    Error('\P{Is_Block::=	myanmar_EXTENDED_B}');
    Expect(1, 43519, '\p{Is_Block=myanmarextendedb}', "");
    Expect(0, 43519, '\p{^Is_Block=myanmarextendedb}', "");
    Expect(0, 43519, '\P{Is_Block=myanmarextendedb}', "");
    Expect(1, 43519, '\P{^Is_Block=myanmarextendedb}', "");
    Expect(0, 43520, '\p{Is_Block=myanmarextendedb}', "");
    Expect(1, 43520, '\p{^Is_Block=myanmarextendedb}', "");
    Expect(1, 43520, '\P{Is_Block=myanmarextendedb}', "");
    Expect(0, 43520, '\P{^Is_Block=myanmarextendedb}', "");
    Expect(1, 43519, '\p{Is_Block=_ Myanmar_Extended_B}', "");
    Expect(0, 43519, '\p{^Is_Block=_ Myanmar_Extended_B}', "");
    Expect(0, 43519, '\P{Is_Block=_ Myanmar_Extended_B}', "");
    Expect(1, 43519, '\P{^Is_Block=_ Myanmar_Extended_B}', "");
    Expect(0, 43520, '\p{Is_Block=_ Myanmar_Extended_B}', "");
    Expect(1, 43520, '\p{^Is_Block=_ Myanmar_Extended_B}', "");
    Expect(1, 43520, '\P{Is_Block=_ Myanmar_Extended_B}', "");
    Expect(0, 43520, '\P{^Is_Block=_ Myanmar_Extended_B}', "");
    Error('\p{Is_Blk=	-myanmar_Ext_B/a/}');
    Error('\P{Is_Blk=	-myanmar_Ext_B/a/}');
    Expect(1, 43519, '\p{Is_Blk=myanmarextb}', "");
    Expect(0, 43519, '\p{^Is_Blk=myanmarextb}', "");
    Expect(0, 43519, '\P{Is_Blk=myanmarextb}', "");
    Expect(1, 43519, '\P{^Is_Blk=myanmarextb}', "");
    Expect(0, 43520, '\p{Is_Blk=myanmarextb}', "");
    Expect(1, 43520, '\p{^Is_Blk=myanmarextb}', "");
    Expect(1, 43520, '\P{Is_Blk=myanmarextb}', "");
    Expect(0, 43520, '\P{^Is_Blk=myanmarextb}', "");
    Expect(1, 43519, '\p{Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(0, 43519, '\p{^Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(0, 43519, '\P{Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(1, 43519, '\P{^Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(0, 43520, '\p{Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(1, 43520, '\p{^Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(1, 43520, '\P{Is_Blk:	-Myanmar_Ext_B}', "");
    Expect(0, 43520, '\P{^Is_Blk:	-Myanmar_Ext_B}', "");
    Error('\p{Block=:=nabataean}');
    Error('\P{Block=:=nabataean}');
    Expect(1, 67759, '\p{Block=nabataean}', "");
    Expect(0, 67759, '\p{^Block=nabataean}', "");
    Expect(0, 67759, '\P{Block=nabataean}', "");
    Expect(1, 67759, '\P{^Block=nabataean}', "");
    Expect(0, 67760, '\p{Block=nabataean}', "");
    Expect(1, 67760, '\p{^Block=nabataean}', "");
    Expect(1, 67760, '\P{Block=nabataean}', "");
    Expect(0, 67760, '\P{^Block=nabataean}', "");
    Expect(1, 67759, '\p{Block= -Nabataean}', "");
    Expect(0, 67759, '\p{^Block= -Nabataean}', "");
    Expect(0, 67759, '\P{Block= -Nabataean}', "");
    Expect(1, 67759, '\P{^Block= -Nabataean}', "");
    Expect(0, 67760, '\p{Block= -Nabataean}', "");
    Expect(1, 67760, '\p{^Block= -Nabataean}', "");
    Expect(1, 67760, '\P{Block= -Nabataean}', "");
    Expect(0, 67760, '\P{^Block= -Nabataean}', "");
    Error('\p{Blk:	 /a/Nabataean}');
    Error('\P{Blk:	 /a/Nabataean}');
    Expect(1, 67759, '\p{Blk=nabataean}', "");
    Expect(0, 67759, '\p{^Blk=nabataean}', "");
    Expect(0, 67759, '\P{Blk=nabataean}', "");
    Expect(1, 67759, '\P{^Blk=nabataean}', "");
    Expect(0, 67760, '\p{Blk=nabataean}', "");
    Expect(1, 67760, '\p{^Blk=nabataean}', "");
    Expect(1, 67760, '\P{Blk=nabataean}', "");
    Expect(0, 67760, '\P{^Blk=nabataean}', "");
    Error('\p{Is_Block=/a/	nabataean}');
    Error('\P{Is_Block=/a/	nabataean}');
    Expect(1, 67759, '\p{Is_Block:	nabataean}', "");
    Expect(0, 67759, '\p{^Is_Block:	nabataean}', "");
    Expect(0, 67759, '\P{Is_Block:	nabataean}', "");
    Expect(1, 67759, '\P{^Is_Block:	nabataean}', "");
    Expect(0, 67760, '\p{Is_Block:	nabataean}', "");
    Expect(1, 67760, '\p{^Is_Block:	nabataean}', "");
    Expect(1, 67760, '\P{Is_Block:	nabataean}', "");
    Expect(0, 67760, '\P{^Is_Block:	nabataean}', "");
    Expect(1, 67759, '\p{Is_Block=_nabataean}', "");
    Expect(0, 67759, '\p{^Is_Block=_nabataean}', "");
    Expect(0, 67759, '\P{Is_Block=_nabataean}', "");
    Expect(1, 67759, '\P{^Is_Block=_nabataean}', "");
    Expect(0, 67760, '\p{Is_Block=_nabataean}', "");
    Expect(1, 67760, '\p{^Is_Block=_nabataean}', "");
    Expect(1, 67760, '\P{Is_Block=_nabataean}', "");
    Expect(0, 67760, '\P{^Is_Block=_nabataean}', "");
    Error('\p{Is_Blk=/a/-Nabataean}');
    Error('\P{Is_Blk=/a/-Nabataean}');
    Expect(1, 67759, '\p{Is_Blk=nabataean}', "");
    Expect(0, 67759, '\p{^Is_Blk=nabataean}', "");
    Expect(0, 67759, '\P{Is_Blk=nabataean}', "");
    Expect(1, 67759, '\P{^Is_Blk=nabataean}', "");
    Expect(0, 67760, '\p{Is_Blk=nabataean}', "");
    Expect(1, 67760, '\p{^Is_Blk=nabataean}', "");
    Expect(1, 67760, '\P{Is_Blk=nabataean}', "");
    Expect(0, 67760, '\P{^Is_Blk=nabataean}', "");
    Expect(1, 67759, '\p{Is_Blk= _Nabataean}', "");
    Expect(0, 67759, '\p{^Is_Blk= _Nabataean}', "");
    Expect(0, 67759, '\P{Is_Blk= _Nabataean}', "");
    Expect(1, 67759, '\P{^Is_Blk= _Nabataean}', "");
    Expect(0, 67760, '\p{Is_Blk= _Nabataean}', "");
    Expect(1, 67760, '\p{^Is_Blk= _Nabataean}', "");
    Expect(1, 67760, '\P{Is_Blk= _Nabataean}', "");
    Expect(0, 67760, '\P{^Is_Blk= _Nabataean}', "");
    Error('\p{Block:	-No_BLOCK/a/}');
    Error('\P{Block:	-No_BLOCK/a/}');
    Expect(1, 918000, '\p{Block=noblock}', "");
    Expect(0, 918000, '\p{^Block=noblock}', "");
    Expect(0, 918000, '\P{Block=noblock}', "");
    Expect(1, 918000, '\P{^Block=noblock}', "");
    Expect(0, 983040, '\p{Block=noblock}', "");
    Expect(1, 983040, '\p{^Block=noblock}', "");
    Expect(1, 983040, '\P{Block=noblock}', "");
    Expect(0, 983040, '\P{^Block=noblock}', "");
    Expect(1, 918000, '\p{Block=	No_Block}', "");
    Expect(0, 918000, '\p{^Block=	No_Block}', "");
    Expect(0, 918000, '\P{Block=	No_Block}', "");
    Expect(1, 918000, '\P{^Block=	No_Block}', "");
    Expect(0, 983040, '\p{Block=	No_Block}', "");
    Expect(1, 983040, '\p{^Block=	No_Block}', "");
    Expect(1, 983040, '\P{Block=	No_Block}', "");
    Expect(0, 983040, '\P{^Block=	No_Block}', "");
    Error('\p{Blk= :=NB}');
    Error('\P{Blk= :=NB}');
    Expect(1, 918000, '\p{Blk=nb}', "");
    Expect(0, 918000, '\p{^Blk=nb}', "");
    Expect(0, 918000, '\P{Blk=nb}', "");
    Expect(1, 918000, '\P{^Blk=nb}', "");
    Expect(0, 983040, '\p{Blk=nb}', "");
    Expect(1, 983040, '\p{^Blk=nb}', "");
    Expect(1, 983040, '\P{Blk=nb}', "");
    Expect(0, 983040, '\P{^Blk=nb}', "");
    Expect(1, 918000, '\p{Blk=	_nb}', "");
    Expect(0, 918000, '\p{^Blk=	_nb}', "");
    Expect(0, 918000, '\P{Blk=	_nb}', "");
    Expect(1, 918000, '\P{^Blk=	_nb}', "");
    Expect(0, 983040, '\p{Blk=	_nb}', "");
    Expect(1, 983040, '\p{^Blk=	_nb}', "");
    Expect(1, 983040, '\P{Blk=	_nb}', "");
    Expect(0, 983040, '\P{^Blk=	_nb}', "");
    Error('\p{Is_Block=--No_block:=}');
    Error('\P{Is_Block=--No_block:=}');
    Expect(1, 918000, '\p{Is_Block=noblock}', "");
    Expect(0, 918000, '\p{^Is_Block=noblock}', "");
    Expect(0, 918000, '\P{Is_Block=noblock}', "");
    Expect(1, 918000, '\P{^Is_Block=noblock}', "");
    Expect(0, 983040, '\p{Is_Block=noblock}', "");
    Expect(1, 983040, '\p{^Is_Block=noblock}', "");
    Expect(1, 983040, '\P{Is_Block=noblock}', "");
    Expect(0, 983040, '\P{^Is_Block=noblock}', "");
    Expect(1, 918000, '\p{Is_Block=  no_Block}', "");
    Expect(0, 918000, '\p{^Is_Block=  no_Block}', "");
    Expect(0, 918000, '\P{Is_Block=  no_Block}', "");
    Expect(1, 918000, '\P{^Is_Block=  no_Block}', "");
    Expect(0, 983040, '\p{Is_Block=  no_Block}', "");
    Expect(1, 983040, '\p{^Is_Block=  no_Block}', "");
    Expect(1, 983040, '\P{Is_Block=  no_Block}', "");
    Expect(0, 983040, '\P{^Is_Block=  no_Block}', "");
    Error('\p{Is_Blk=_:=nb}');
    Error('\P{Is_Blk=_:=nb}');
    Expect(1, 918000, '\p{Is_Blk=nb}', "");
    Expect(0, 918000, '\p{^Is_Blk=nb}', "");
    Expect(0, 918000, '\P{Is_Blk=nb}', "");
    Expect(1, 918000, '\P{^Is_Blk=nb}', "");
    Expect(0, 983040, '\p{Is_Blk=nb}', "");
    Expect(1, 983040, '\p{^Is_Blk=nb}', "");
    Expect(1, 983040, '\P{Is_Blk=nb}', "");
    Expect(0, 983040, '\P{^Is_Blk=nb}', "");
    Expect(1, 918000, '\p{Is_Blk= -NB}', "");
    Expect(0, 918000, '\p{^Is_Blk= -NB}', "");
    Expect(0, 918000, '\P{Is_Blk= -NB}', "");
    Expect(1, 918000, '\P{^Is_Blk= -NB}', "");
    Expect(0, 983040, '\p{Is_Blk= -NB}', "");
    Expect(1, 983040, '\p{^Is_Blk= -NB}', "");
    Expect(1, 983040, '\P{Is_Blk= -NB}', "");
    Expect(0, 983040, '\P{^Is_Blk= -NB}', "");
    Error('\p{Block=-:=New_Tai_LUE}');
    Error('\P{Block=-:=New_Tai_LUE}');
    Expect(1, 6623, '\p{Block=newtailue}', "");
    Expect(0, 6623, '\p{^Block=newtailue}', "");
    Expect(0, 6623, '\P{Block=newtailue}', "");
    Expect(1, 6623, '\P{^Block=newtailue}', "");
    Expect(0, 6624, '\p{Block=newtailue}', "");
    Expect(1, 6624, '\p{^Block=newtailue}', "");
    Expect(1, 6624, '\P{Block=newtailue}', "");
    Expect(0, 6624, '\P{^Block=newtailue}', "");
    Expect(1, 6623, '\p{Block:_NEW_Tai_Lue}', "");
    Expect(0, 6623, '\p{^Block:_NEW_Tai_Lue}', "");
    Expect(0, 6623, '\P{Block:_NEW_Tai_Lue}', "");
    Expect(1, 6623, '\P{^Block:_NEW_Tai_Lue}', "");
    Expect(0, 6624, '\p{Block:_NEW_Tai_Lue}', "");
    Expect(1, 6624, '\p{^Block:_NEW_Tai_Lue}', "");
    Expect(1, 6624, '\P{Block:_NEW_Tai_Lue}', "");
    Expect(0, 6624, '\P{^Block:_NEW_Tai_Lue}', "");
    Error('\p{Blk=-New_Tai_lue:=}');
    Error('\P{Blk=-New_Tai_lue:=}');
    Expect(1, 6623, '\p{Blk=newtailue}', "");
    Expect(0, 6623, '\p{^Blk=newtailue}', "");
    Expect(0, 6623, '\P{Blk=newtailue}', "");
    Expect(1, 6623, '\P{^Blk=newtailue}', "");
    Expect(0, 6624, '\p{Blk=newtailue}', "");
    Expect(1, 6624, '\p{^Blk=newtailue}', "");
    Expect(1, 6624, '\P{Blk=newtailue}', "");
    Expect(0, 6624, '\P{^Blk=newtailue}', "");
    Expect(1, 6623, '\p{Blk:   -New_Tai_Lue}', "");
    Expect(0, 6623, '\p{^Blk:   -New_Tai_Lue}', "");
    Expect(0, 6623, '\P{Blk:   -New_Tai_Lue}', "");
    Expect(1, 6623, '\P{^Blk:   -New_Tai_Lue}', "");
    Expect(0, 6624, '\p{Blk:   -New_Tai_Lue}', "");
    Expect(1, 6624, '\p{^Blk:   -New_Tai_Lue}', "");
    Expect(1, 6624, '\P{Blk:   -New_Tai_Lue}', "");
    Expect(0, 6624, '\P{^Blk:   -New_Tai_Lue}', "");
    Error('\p{Is_Block=:= 	New_Tai_LUE}');
    Error('\P{Is_Block=:= 	New_Tai_LUE}');
    Expect(1, 6623, '\p{Is_Block=newtailue}', "");
    Expect(0, 6623, '\p{^Is_Block=newtailue}', "");
    Expect(0, 6623, '\P{Is_Block=newtailue}', "");
    Expect(1, 6623, '\P{^Is_Block=newtailue}', "");
    Expect(0, 6624, '\p{Is_Block=newtailue}', "");
    Expect(1, 6624, '\p{^Is_Block=newtailue}', "");
    Expect(1, 6624, '\P{Is_Block=newtailue}', "");
    Expect(0, 6624, '\P{^Is_Block=newtailue}', "");
    Expect(1, 6623, '\p{Is_Block:	--NEW_tai_lue}', "");
    Expect(0, 6623, '\p{^Is_Block:	--NEW_tai_lue}', "");
    Expect(0, 6623, '\P{Is_Block:	--NEW_tai_lue}', "");
    Expect(1, 6623, '\P{^Is_Block:	--NEW_tai_lue}', "");
    Expect(0, 6624, '\p{Is_Block:	--NEW_tai_lue}', "");
    Expect(1, 6624, '\p{^Is_Block:	--NEW_tai_lue}', "");
    Expect(1, 6624, '\P{Is_Block:	--NEW_tai_lue}', "");
    Expect(0, 6624, '\P{^Is_Block:	--NEW_tai_lue}', "");
    Error('\p{Is_Blk=--New_tai_Lue:=}');
    Error('\P{Is_Blk=--New_tai_Lue:=}');
    Expect(1, 6623, '\p{Is_Blk=newtailue}', "");
    Expect(0, 6623, '\p{^Is_Blk=newtailue}', "");
    Expect(0, 6623, '\P{Is_Blk=newtailue}', "");
    Expect(1, 6623, '\P{^Is_Blk=newtailue}', "");
    Expect(0, 6624, '\p{Is_Blk=newtailue}', "");
    Expect(1, 6624, '\p{^Is_Blk=newtailue}', "");
    Expect(1, 6624, '\P{Is_Blk=newtailue}', "");
    Expect(0, 6624, '\P{^Is_Blk=newtailue}', "");
    Expect(1, 6623, '\p{Is_Blk:    -new_tai_LUE}', "");
    Expect(0, 6623, '\p{^Is_Blk:    -new_tai_LUE}', "");
    Expect(0, 6623, '\P{Is_Blk:    -new_tai_LUE}', "");
    Expect(1, 6623, '\P{^Is_Blk:    -new_tai_LUE}', "");
    Expect(0, 6624, '\p{Is_Blk:    -new_tai_LUE}', "");
    Expect(1, 6624, '\p{^Is_Blk:    -new_tai_LUE}', "");
    Expect(1, 6624, '\P{Is_Blk:    -new_tai_LUE}', "");
    Expect(0, 6624, '\P{^Is_Blk:    -new_tai_LUE}', "");
    Error('\p{Block=/a/	-Newa}');
    Error('\P{Block=/a/	-Newa}');
    Expect(1, 70783, '\p{Block=newa}', "");
    Expect(0, 70783, '\p{^Block=newa}', "");
    Expect(0, 70783, '\P{Block=newa}', "");
    Expect(1, 70783, '\P{^Block=newa}', "");
    Expect(0, 70784, '\p{Block=newa}', "");
    Expect(1, 70784, '\p{^Block=newa}', "");
    Expect(1, 70784, '\P{Block=newa}', "");
    Expect(0, 70784, '\P{^Block=newa}', "");
    Expect(1, 70783, '\p{Block:_Newa}', "");
    Expect(0, 70783, '\p{^Block:_Newa}', "");
    Expect(0, 70783, '\P{Block:_Newa}', "");
    Expect(1, 70783, '\P{^Block:_Newa}', "");
    Expect(0, 70784, '\p{Block:_Newa}', "");
    Expect(1, 70784, '\p{^Block:_Newa}', "");
    Expect(1, 70784, '\P{Block:_Newa}', "");
    Expect(0, 70784, '\P{^Block:_Newa}', "");
    Error('\p{Blk=/a/ _Newa}');
    Error('\P{Blk=/a/ _Newa}');
    Expect(1, 70783, '\p{Blk=newa}', "");
    Expect(0, 70783, '\p{^Blk=newa}', "");
    Expect(0, 70783, '\P{Blk=newa}', "");
    Expect(1, 70783, '\P{^Blk=newa}', "");
    Expect(0, 70784, '\p{Blk=newa}', "");
    Expect(1, 70784, '\p{^Blk=newa}', "");
    Expect(1, 70784, '\P{Blk=newa}', "");
    Expect(0, 70784, '\P{^Blk=newa}', "");
    Expect(1, 70783, '\p{Blk=-Newa}', "");
    Expect(0, 70783, '\p{^Blk=-Newa}', "");
    Expect(0, 70783, '\P{Blk=-Newa}', "");
    Expect(1, 70783, '\P{^Blk=-Newa}', "");
    Expect(0, 70784, '\p{Blk=-Newa}', "");
    Expect(1, 70784, '\p{^Blk=-Newa}', "");
    Expect(1, 70784, '\P{Blk=-Newa}', "");
    Expect(0, 70784, '\P{^Blk=-Newa}', "");
    Error('\p{Is_Block=/a/_NEWA}');
    Error('\P{Is_Block=/a/_NEWA}');
    Expect(1, 70783, '\p{Is_Block=newa}', "");
    Expect(0, 70783, '\p{^Is_Block=newa}', "");
    Expect(0, 70783, '\P{Is_Block=newa}', "");
    Expect(1, 70783, '\P{^Is_Block=newa}', "");
    Expect(0, 70784, '\p{Is_Block=newa}', "");
    Expect(1, 70784, '\p{^Is_Block=newa}', "");
    Expect(1, 70784, '\P{Is_Block=newa}', "");
    Expect(0, 70784, '\P{^Is_Block=newa}', "");
    Expect(1, 70783, '\p{Is_Block:   -_NEWA}', "");
    Expect(0, 70783, '\p{^Is_Block:   -_NEWA}', "");
    Expect(0, 70783, '\P{Is_Block:   -_NEWA}', "");
    Expect(1, 70783, '\P{^Is_Block:   -_NEWA}', "");
    Expect(0, 70784, '\p{Is_Block:   -_NEWA}', "");
    Expect(1, 70784, '\p{^Is_Block:   -_NEWA}', "");
    Expect(1, 70784, '\P{Is_Block:   -_NEWA}', "");
    Expect(0, 70784, '\P{^Is_Block:   -_NEWA}', "");
    Error('\p{Is_Blk=NEWA:=}');
    Error('\P{Is_Blk=NEWA:=}');
    Expect(1, 70783, '\p{Is_Blk=newa}', "");
    Expect(0, 70783, '\p{^Is_Blk=newa}', "");
    Expect(0, 70783, '\P{Is_Blk=newa}', "");
    Expect(1, 70783, '\P{^Is_Blk=newa}', "");
    Expect(0, 70784, '\p{Is_Blk=newa}', "");
    Expect(1, 70784, '\p{^Is_Blk=newa}', "");
    Expect(1, 70784, '\P{Is_Blk=newa}', "");
    Expect(0, 70784, '\P{^Is_Blk=newa}', "");
    Expect(1, 70783, '\p{Is_Blk=	Newa}', "");
    Expect(0, 70783, '\p{^Is_Blk=	Newa}', "");
    Expect(0, 70783, '\P{Is_Blk=	Newa}', "");
    Expect(1, 70783, '\P{^Is_Blk=	Newa}', "");
    Expect(0, 70784, '\p{Is_Blk=	Newa}', "");
    Expect(1, 70784, '\p{^Is_Blk=	Newa}', "");
    Expect(1, 70784, '\P{Is_Blk=	Newa}', "");
    Expect(0, 70784, '\P{^Is_Blk=	Newa}', "");
    Error('\p{Block:		:=NKO}');
    Error('\P{Block:		:=NKO}');
    Expect(1, 2047, '\p{Block=nko}', "");
    Expect(0, 2047, '\p{^Block=nko}', "");
    Expect(0, 2047, '\P{Block=nko}', "");
    Expect(1, 2047, '\P{^Block=nko}', "");
    Expect(0, 2048, '\p{Block=nko}', "");
    Expect(1, 2048, '\p{^Block=nko}', "");
    Expect(1, 2048, '\P{Block=nko}', "");
    Expect(0, 2048, '\P{^Block=nko}', "");
    Expect(1, 2047, '\p{Block=__NKo}', "");
    Expect(0, 2047, '\p{^Block=__NKo}', "");
    Expect(0, 2047, '\P{Block=__NKo}', "");
    Expect(1, 2047, '\P{^Block=__NKo}', "");
    Expect(0, 2048, '\p{Block=__NKo}', "");
    Expect(1, 2048, '\p{^Block=__NKo}', "");
    Expect(1, 2048, '\P{Block=__NKo}', "");
    Expect(0, 2048, '\P{^Block=__NKo}', "");
    Error('\p{Blk=/a/NKo}');
    Error('\P{Blk=/a/NKo}');
    Expect(1, 2047, '\p{Blk=nko}', "");
    Expect(0, 2047, '\p{^Blk=nko}', "");
    Expect(0, 2047, '\P{Blk=nko}', "");
    Expect(1, 2047, '\P{^Blk=nko}', "");
    Expect(0, 2048, '\p{Blk=nko}', "");
    Expect(1, 2048, '\p{^Blk=nko}', "");
    Expect(1, 2048, '\P{Blk=nko}', "");
    Expect(0, 2048, '\P{^Blk=nko}', "");
    Expect(1, 2047, '\p{Blk=	nko}', "");
    Expect(0, 2047, '\p{^Blk=	nko}', "");
    Expect(0, 2047, '\P{Blk=	nko}', "");
    Expect(1, 2047, '\P{^Blk=	nko}', "");
    Expect(0, 2048, '\p{Blk=	nko}', "");
    Expect(1, 2048, '\p{^Blk=	nko}', "");
    Expect(1, 2048, '\P{Blk=	nko}', "");
    Expect(0, 2048, '\P{^Blk=	nko}', "");
    Error('\p{Is_Block=/a/ nko}');
    Error('\P{Is_Block=/a/ nko}');
    Expect(1, 2047, '\p{Is_Block=nko}', "");
    Expect(0, 2047, '\p{^Is_Block=nko}', "");
    Expect(0, 2047, '\P{Is_Block=nko}', "");
    Expect(1, 2047, '\P{^Is_Block=nko}', "");
    Expect(0, 2048, '\p{Is_Block=nko}', "");
    Expect(1, 2048, '\p{^Is_Block=nko}', "");
    Expect(1, 2048, '\P{Is_Block=nko}', "");
    Expect(0, 2048, '\P{^Is_Block=nko}', "");
    Expect(1, 2047, '\p{Is_Block: - NKo}', "");
    Expect(0, 2047, '\p{^Is_Block: - NKo}', "");
    Expect(0, 2047, '\P{Is_Block: - NKo}', "");
    Expect(1, 2047, '\P{^Is_Block: - NKo}', "");
    Expect(0, 2048, '\p{Is_Block: - NKo}', "");
    Expect(1, 2048, '\p{^Is_Block: - NKo}', "");
    Expect(1, 2048, '\P{Is_Block: - NKo}', "");
    Expect(0, 2048, '\P{^Is_Block: - NKo}', "");
    Error('\p{Is_Blk=  NKo:=}');
    Error('\P{Is_Blk=  NKo:=}');
    Expect(1, 2047, '\p{Is_Blk=nko}', "");
    Expect(0, 2047, '\p{^Is_Blk=nko}', "");
    Expect(0, 2047, '\P{Is_Blk=nko}', "");
    Expect(1, 2047, '\P{^Is_Blk=nko}', "");
    Expect(0, 2048, '\p{Is_Blk=nko}', "");
    Expect(1, 2048, '\p{^Is_Blk=nko}', "");
    Expect(1, 2048, '\P{Is_Blk=nko}', "");
    Expect(0, 2048, '\P{^Is_Blk=nko}', "");
    Expect(1, 2047, '\p{Is_Blk=_NKo}', "");
    Expect(0, 2047, '\p{^Is_Blk=_NKo}', "");
    Expect(0, 2047, '\P{Is_Blk=_NKo}', "");
    Expect(1, 2047, '\P{^Is_Blk=_NKo}', "");
    Expect(0, 2048, '\p{Is_Blk=_NKo}', "");
    Expect(1, 2048, '\p{^Is_Blk=_NKo}', "");
    Expect(1, 2048, '\P{Is_Blk=_NKo}', "");
    Expect(0, 2048, '\P{^Is_Blk=_NKo}', "");
    Error('\p{Block= :=number_Forms}');
    Error('\P{Block= :=number_Forms}');
    Expect(1, 8591, '\p{Block=numberforms}', "");
    Expect(0, 8591, '\p{^Block=numberforms}', "");
    Expect(0, 8591, '\P{Block=numberforms}', "");
    Expect(1, 8591, '\P{^Block=numberforms}', "");
    Expect(0, 8592, '\p{Block=numberforms}', "");
    Expect(1, 8592, '\p{^Block=numberforms}', "");
    Expect(1, 8592, '\P{Block=numberforms}', "");
    Expect(0, 8592, '\P{^Block=numberforms}', "");
    Expect(1, 8591, '\p{Block=-_Number_Forms}', "");
    Expect(0, 8591, '\p{^Block=-_Number_Forms}', "");
    Expect(0, 8591, '\P{Block=-_Number_Forms}', "");
    Expect(1, 8591, '\P{^Block=-_Number_Forms}', "");
    Expect(0, 8592, '\p{Block=-_Number_Forms}', "");
    Expect(1, 8592, '\p{^Block=-_Number_Forms}', "");
    Expect(1, 8592, '\P{Block=-_Number_Forms}', "");
    Expect(0, 8592, '\P{^Block=-_Number_Forms}', "");
    Error('\p{Blk=-number_forms:=}');
    Error('\P{Blk=-number_forms:=}');
    Expect(1, 8591, '\p{Blk=numberforms}', "");
    Expect(0, 8591, '\p{^Blk=numberforms}', "");
    Expect(0, 8591, '\P{Blk=numberforms}', "");
    Expect(1, 8591, '\P{^Blk=numberforms}', "");
    Expect(0, 8592, '\p{Blk=numberforms}', "");
    Expect(1, 8592, '\p{^Blk=numberforms}', "");
    Expect(1, 8592, '\P{Blk=numberforms}', "");
    Expect(0, 8592, '\P{^Blk=numberforms}', "");
    Expect(1, 8591, '\p{Blk:_ Number_forms}', "");
    Expect(0, 8591, '\p{^Blk:_ Number_forms}', "");
    Expect(0, 8591, '\P{Blk:_ Number_forms}', "");
    Expect(1, 8591, '\P{^Blk:_ Number_forms}', "");
    Expect(0, 8592, '\p{Blk:_ Number_forms}', "");
    Expect(1, 8592, '\p{^Blk:_ Number_forms}', "");
    Expect(1, 8592, '\P{Blk:_ Number_forms}', "");
    Expect(0, 8592, '\P{^Blk:_ Number_forms}', "");
    Error('\p{Is_Block:   -:=Number_FORMS}');
    Error('\P{Is_Block:   -:=Number_FORMS}');
    Expect(1, 8591, '\p{Is_Block: numberforms}', "");
    Expect(0, 8591, '\p{^Is_Block: numberforms}', "");
    Expect(0, 8591, '\P{Is_Block: numberforms}', "");
    Expect(1, 8591, '\P{^Is_Block: numberforms}', "");
    Expect(0, 8592, '\p{Is_Block: numberforms}', "");
    Expect(1, 8592, '\p{^Is_Block: numberforms}', "");
    Expect(1, 8592, '\P{Is_Block: numberforms}', "");
    Expect(0, 8592, '\P{^Is_Block: numberforms}', "");
    Expect(1, 8591, '\p{Is_Block=Number_FORMS}', "");
    Expect(0, 8591, '\p{^Is_Block=Number_FORMS}', "");
    Expect(0, 8591, '\P{Is_Block=Number_FORMS}', "");
    Expect(1, 8591, '\P{^Is_Block=Number_FORMS}', "");
    Expect(0, 8592, '\p{Is_Block=Number_FORMS}', "");
    Expect(1, 8592, '\p{^Is_Block=Number_FORMS}', "");
    Expect(1, 8592, '\P{Is_Block=Number_FORMS}', "");
    Expect(0, 8592, '\P{^Is_Block=Number_FORMS}', "");
    Error('\p{Is_Blk=	:=NUMBER_Forms}');
    Error('\P{Is_Blk=	:=NUMBER_Forms}');
    Expect(1, 8591, '\p{Is_Blk=numberforms}', "");
    Expect(0, 8591, '\p{^Is_Blk=numberforms}', "");
    Expect(0, 8591, '\P{Is_Blk=numberforms}', "");
    Expect(1, 8591, '\P{^Is_Blk=numberforms}', "");
    Expect(0, 8592, '\p{Is_Blk=numberforms}', "");
    Expect(1, 8592, '\p{^Is_Blk=numberforms}', "");
    Expect(1, 8592, '\P{Is_Blk=numberforms}', "");
    Expect(0, 8592, '\P{^Is_Blk=numberforms}', "");
    Expect(1, 8591, '\p{Is_Blk=- Number_Forms}', "");
    Expect(0, 8591, '\p{^Is_Blk=- Number_Forms}', "");
    Expect(0, 8591, '\P{Is_Blk=- Number_Forms}', "");
    Expect(1, 8591, '\P{^Is_Blk=- Number_Forms}', "");
    Expect(0, 8592, '\p{Is_Blk=- Number_Forms}', "");
    Expect(1, 8592, '\p{^Is_Blk=- Number_Forms}', "");
    Expect(1, 8592, '\P{Is_Blk=- Number_Forms}', "");
    Expect(0, 8592, '\P{^Is_Blk=- Number_Forms}', "");
    Error('\p{Block=:=-NUSHU}');
    Error('\P{Block=:=-NUSHU}');
    Expect(1, 111359, '\p{Block=nushu}', "");
    Expect(0, 111359, '\p{^Block=nushu}', "");
    Expect(0, 111359, '\P{Block=nushu}', "");
    Expect(1, 111359, '\P{^Block=nushu}', "");
    Expect(0, 111360, '\p{Block=nushu}', "");
    Expect(1, 111360, '\p{^Block=nushu}', "");
    Expect(1, 111360, '\P{Block=nushu}', "");
    Expect(0, 111360, '\P{^Block=nushu}', "");
    Expect(1, 111359, '\p{Block=		NUSHU}', "");
    Expect(0, 111359, '\p{^Block=		NUSHU}', "");
    Expect(0, 111359, '\P{Block=		NUSHU}', "");
    Expect(1, 111359, '\P{^Block=		NUSHU}', "");
    Expect(0, 111360, '\p{Block=		NUSHU}', "");
    Expect(1, 111360, '\p{^Block=		NUSHU}', "");
    Expect(1, 111360, '\P{Block=		NUSHU}', "");
    Expect(0, 111360, '\P{^Block=		NUSHU}', "");
    Error('\p{Blk=-/a/Nushu}');
    Error('\P{Blk=-/a/Nushu}');
    Expect(1, 111359, '\p{Blk=nushu}', "");
    Expect(0, 111359, '\p{^Blk=nushu}', "");
    Expect(0, 111359, '\P{Blk=nushu}', "");
    Expect(1, 111359, '\P{^Blk=nushu}', "");
    Expect(0, 111360, '\p{Blk=nushu}', "");
    Expect(1, 111360, '\p{^Blk=nushu}', "");
    Expect(1, 111360, '\P{Blk=nushu}', "");
    Expect(0, 111360, '\P{^Blk=nushu}', "");
    Expect(1, 111359, '\p{Blk=	_nushu}', "");
    Expect(0, 111359, '\p{^Blk=	_nushu}', "");
    Expect(0, 111359, '\P{Blk=	_nushu}', "");
    Expect(1, 111359, '\P{^Blk=	_nushu}', "");
    Expect(0, 111360, '\p{Blk=	_nushu}', "");
    Expect(1, 111360, '\p{^Blk=	_nushu}', "");
    Expect(1, 111360, '\P{Blk=	_nushu}', "");
    Expect(0, 111360, '\P{^Blk=	_nushu}', "");
    Error('\p{Is_Block=:=nushu}');
    Error('\P{Is_Block=:=nushu}');
    Expect(1, 111359, '\p{Is_Block=nushu}', "");
    Expect(0, 111359, '\p{^Is_Block=nushu}', "");
    Expect(0, 111359, '\P{Is_Block=nushu}', "");
    Expect(1, 111359, '\P{^Is_Block=nushu}', "");
    Expect(0, 111360, '\p{Is_Block=nushu}', "");
    Expect(1, 111360, '\p{^Is_Block=nushu}', "");
    Expect(1, 111360, '\P{Is_Block=nushu}', "");
    Expect(0, 111360, '\P{^Is_Block=nushu}', "");
    Expect(1, 111359, '\p{Is_Block=	_Nushu}', "");
    Expect(0, 111359, '\p{^Is_Block=	_Nushu}', "");
    Expect(0, 111359, '\P{Is_Block=	_Nushu}', "");
    Expect(1, 111359, '\P{^Is_Block=	_Nushu}', "");
    Expect(0, 111360, '\p{Is_Block=	_Nushu}', "");
    Expect(1, 111360, '\p{^Is_Block=	_Nushu}', "");
    Expect(1, 111360, '\P{Is_Block=	_Nushu}', "");
    Expect(0, 111360, '\P{^Is_Block=	_Nushu}', "");
    Error('\p{Is_Blk=/a/_ NUSHU}');
    Error('\P{Is_Blk=/a/_ NUSHU}');
    Expect(1, 111359, '\p{Is_Blk=nushu}', "");
    Expect(0, 111359, '\p{^Is_Blk=nushu}', "");
    Expect(0, 111359, '\P{Is_Blk=nushu}', "");
    Expect(1, 111359, '\P{^Is_Blk=nushu}', "");
    Expect(0, 111360, '\p{Is_Blk=nushu}', "");
    Expect(1, 111360, '\p{^Is_Blk=nushu}', "");
    Expect(1, 111360, '\P{Is_Blk=nushu}', "");
    Expect(0, 111360, '\P{^Is_Blk=nushu}', "");
    Expect(1, 111359, '\p{Is_Blk=	Nushu}', "");
    Expect(0, 111359, '\p{^Is_Blk=	Nushu}', "");
    Expect(0, 111359, '\P{Is_Blk=	Nushu}', "");
    Expect(1, 111359, '\P{^Is_Blk=	Nushu}', "");
    Expect(0, 111360, '\p{Is_Blk=	Nushu}', "");
    Expect(1, 111360, '\p{^Is_Blk=	Nushu}', "");
    Expect(1, 111360, '\P{Is_Blk=	Nushu}', "");
    Expect(0, 111360, '\P{^Is_Blk=	Nushu}', "");
    Error('\p{Block=	:=Optical_Character_Recognition}');
    Error('\P{Block=	:=Optical_Character_Recognition}');
    Expect(1, 9311, '\p{Block=opticalcharacterrecognition}', "");
    Expect(0, 9311, '\p{^Block=opticalcharacterrecognition}', "");
    Expect(0, 9311, '\P{Block=opticalcharacterrecognition}', "");
    Expect(1, 9311, '\P{^Block=opticalcharacterrecognition}', "");
    Expect(0, 9312, '\p{Block=opticalcharacterrecognition}', "");
    Expect(1, 9312, '\p{^Block=opticalcharacterrecognition}', "");
    Expect(1, 9312, '\P{Block=opticalcharacterrecognition}', "");
    Expect(0, 9312, '\P{^Block=opticalcharacterrecognition}', "");
    Expect(1, 9311, '\p{Block:	Optical_CHARACTER_Recognition}', "");
    Expect(0, 9311, '\p{^Block:	Optical_CHARACTER_Recognition}', "");
    Expect(0, 9311, '\P{Block:	Optical_CHARACTER_Recognition}', "");
    Expect(1, 9311, '\P{^Block:	Optical_CHARACTER_Recognition}', "");
    Expect(0, 9312, '\p{Block:	Optical_CHARACTER_Recognition}', "");
    Expect(1, 9312, '\p{^Block:	Optical_CHARACTER_Recognition}', "");
    Expect(1, 9312, '\P{Block:	Optical_CHARACTER_Recognition}', "");
    Expect(0, 9312, '\P{^Block:	Optical_CHARACTER_Recognition}', "");
    Error('\p{Blk=__OCR/a/}');
    Error('\P{Blk=__OCR/a/}');
    Expect(1, 9311, '\p{Blk=ocr}', "");
    Expect(0, 9311, '\p{^Blk=ocr}', "");
    Expect(0, 9311, '\P{Blk=ocr}', "");
    Expect(1, 9311, '\P{^Blk=ocr}', "");
    Expect(0, 9312, '\p{Blk=ocr}', "");
    Expect(1, 9312, '\p{^Blk=ocr}', "");
    Expect(1, 9312, '\P{Blk=ocr}', "");
    Expect(0, 9312, '\P{^Blk=ocr}', "");
    Expect(1, 9311, '\p{Blk=_OCR}', "");
    Expect(0, 9311, '\p{^Blk=_OCR}', "");
    Expect(0, 9311, '\P{Blk=_OCR}', "");
    Expect(1, 9311, '\P{^Blk=_OCR}', "");
    Expect(0, 9312, '\p{Blk=_OCR}', "");
    Expect(1, 9312, '\p{^Blk=_OCR}', "");
    Expect(1, 9312, '\P{Blk=_OCR}', "");
    Expect(0, 9312, '\P{^Blk=_OCR}', "");
    Error('\p{Is_Block=	:=OPTICAL_Character_recognition}');
    Error('\P{Is_Block=	:=OPTICAL_Character_recognition}');
    Expect(1, 9311, '\p{Is_Block=opticalcharacterrecognition}', "");
    Expect(0, 9311, '\p{^Is_Block=opticalcharacterrecognition}', "");
    Expect(0, 9311, '\P{Is_Block=opticalcharacterrecognition}', "");
    Expect(1, 9311, '\P{^Is_Block=opticalcharacterrecognition}', "");
    Expect(0, 9312, '\p{Is_Block=opticalcharacterrecognition}', "");
    Expect(1, 9312, '\p{^Is_Block=opticalcharacterrecognition}', "");
    Expect(1, 9312, '\P{Is_Block=opticalcharacterrecognition}', "");
    Expect(0, 9312, '\P{^Is_Block=opticalcharacterrecognition}', "");
    Expect(1, 9311, '\p{Is_Block=_	Optical_character_Recognition}', "");
    Expect(0, 9311, '\p{^Is_Block=_	Optical_character_Recognition}', "");
    Expect(0, 9311, '\P{Is_Block=_	Optical_character_Recognition}', "");
    Expect(1, 9311, '\P{^Is_Block=_	Optical_character_Recognition}', "");
    Expect(0, 9312, '\p{Is_Block=_	Optical_character_Recognition}', "");
    Expect(1, 9312, '\p{^Is_Block=_	Optical_character_Recognition}', "");
    Expect(1, 9312, '\P{Is_Block=_	Optical_character_Recognition}', "");
    Expect(0, 9312, '\P{^Is_Block=_	Optical_character_Recognition}', "");
    Error('\p{Is_Blk=_	ocr/a/}');
    Error('\P{Is_Blk=_	ocr/a/}');
    Expect(1, 9311, '\p{Is_Blk: ocr}', "");
    Expect(0, 9311, '\p{^Is_Blk: ocr}', "");
    Expect(0, 9311, '\P{Is_Blk: ocr}', "");
    Expect(1, 9311, '\P{^Is_Blk: ocr}', "");
    Expect(0, 9312, '\p{Is_Blk: ocr}', "");
    Expect(1, 9312, '\p{^Is_Blk: ocr}', "");
    Expect(1, 9312, '\P{Is_Blk: ocr}', "");
    Expect(0, 9312, '\P{^Is_Blk: ocr}', "");
    Expect(1, 9311, '\p{Is_Blk=--ocr}', "");
    Expect(0, 9311, '\p{^Is_Blk=--ocr}', "");
    Expect(0, 9311, '\P{Is_Blk=--ocr}', "");
    Expect(1, 9311, '\P{^Is_Blk=--ocr}', "");
    Expect(0, 9312, '\p{Is_Blk=--ocr}', "");
    Expect(1, 9312, '\p{^Is_Blk=--ocr}', "");
    Expect(1, 9312, '\P{Is_Blk=--ocr}', "");
    Expect(0, 9312, '\P{^Is_Blk=--ocr}', "");
    Error('\p{Block=-Ogham/a/}');
    Error('\P{Block=-Ogham/a/}');
    Expect(1, 5791, '\p{Block=ogham}', "");
    Expect(0, 5791, '\p{^Block=ogham}', "");
    Expect(0, 5791, '\P{Block=ogham}', "");
    Expect(1, 5791, '\P{^Block=ogham}', "");
    Expect(0, 5792, '\p{Block=ogham}', "");
    Expect(1, 5792, '\p{^Block=ogham}', "");
    Expect(1, 5792, '\P{Block=ogham}', "");
    Expect(0, 5792, '\P{^Block=ogham}', "");
    Expect(1, 5791, '\p{Block=-Ogham}', "");
    Expect(0, 5791, '\p{^Block=-Ogham}', "");
    Expect(0, 5791, '\P{Block=-Ogham}', "");
    Expect(1, 5791, '\P{^Block=-Ogham}', "");
    Expect(0, 5792, '\p{Block=-Ogham}', "");
    Expect(1, 5792, '\p{^Block=-Ogham}', "");
    Expect(1, 5792, '\P{Block=-Ogham}', "");
    Expect(0, 5792, '\P{^Block=-Ogham}', "");
    Error('\p{Blk:   :=	Ogham}');
    Error('\P{Blk:   :=	Ogham}');
    Expect(1, 5791, '\p{Blk=ogham}', "");
    Expect(0, 5791, '\p{^Blk=ogham}', "");
    Expect(0, 5791, '\P{Blk=ogham}', "");
    Expect(1, 5791, '\P{^Blk=ogham}', "");
    Expect(0, 5792, '\p{Blk=ogham}', "");
    Expect(1, 5792, '\p{^Blk=ogham}', "");
    Expect(1, 5792, '\P{Blk=ogham}', "");
    Expect(0, 5792, '\P{^Blk=ogham}', "");
    Expect(1, 5791, '\p{Blk=_ ogham}', "");
    Expect(0, 5791, '\p{^Blk=_ ogham}', "");
    Expect(0, 5791, '\P{Blk=_ ogham}', "");
    Expect(1, 5791, '\P{^Blk=_ ogham}', "");
    Expect(0, 5792, '\p{Blk=_ ogham}', "");
    Expect(1, 5792, '\p{^Blk=_ ogham}', "");
    Expect(1, 5792, '\P{Blk=_ ogham}', "");
    Expect(0, 5792, '\P{^Blk=_ ogham}', "");
    Error('\p{Is_Block= :=ogham}');
    Error('\P{Is_Block= :=ogham}');
    Expect(1, 5791, '\p{Is_Block=ogham}', "");
    Expect(0, 5791, '\p{^Is_Block=ogham}', "");
    Expect(0, 5791, '\P{Is_Block=ogham}', "");
    Expect(1, 5791, '\P{^Is_Block=ogham}', "");
    Expect(0, 5792, '\p{Is_Block=ogham}', "");
    Expect(1, 5792, '\p{^Is_Block=ogham}', "");
    Expect(1, 5792, '\P{Is_Block=ogham}', "");
    Expect(0, 5792, '\P{^Is_Block=ogham}', "");
    Expect(1, 5791, '\p{Is_Block=		Ogham}', "");
    Expect(0, 5791, '\p{^Is_Block=		Ogham}', "");
    Expect(0, 5791, '\P{Is_Block=		Ogham}', "");
    Expect(1, 5791, '\P{^Is_Block=		Ogham}', "");
    Expect(0, 5792, '\p{Is_Block=		Ogham}', "");
    Expect(1, 5792, '\p{^Is_Block=		Ogham}', "");
    Expect(1, 5792, '\P{Is_Block=		Ogham}', "");
    Expect(0, 5792, '\P{^Is_Block=		Ogham}', "");
    Error('\p{Is_Blk=_ Ogham/a/}');
    Error('\P{Is_Blk=_ Ogham/a/}');
    Expect(1, 5791, '\p{Is_Blk=ogham}', "");
    Expect(0, 5791, '\p{^Is_Blk=ogham}', "");
    Expect(0, 5791, '\P{Is_Blk=ogham}', "");
    Expect(1, 5791, '\P{^Is_Blk=ogham}', "");
    Expect(0, 5792, '\p{Is_Blk=ogham}', "");
    Expect(1, 5792, '\p{^Is_Blk=ogham}', "");
    Expect(1, 5792, '\P{Is_Blk=ogham}', "");
    Expect(0, 5792, '\P{^Is_Blk=ogham}', "");
    Expect(1, 5791, '\p{Is_Blk=_-ogham}', "");
    Expect(0, 5791, '\p{^Is_Blk=_-ogham}', "");
    Expect(0, 5791, '\P{Is_Blk=_-ogham}', "");
    Expect(1, 5791, '\P{^Is_Blk=_-ogham}', "");
    Expect(0, 5792, '\p{Is_Blk=_-ogham}', "");
    Expect(1, 5792, '\p{^Is_Blk=_-ogham}', "");
    Expect(1, 5792, '\P{Is_Blk=_-ogham}', "");
    Expect(0, 5792, '\P{^Is_Blk=_-ogham}', "");
    Error('\p{Block=	-Ol_CHIKI/a/}');
    Error('\P{Block=	-Ol_CHIKI/a/}');
    Expect(1, 7295, '\p{Block=olchiki}', "");
    Expect(0, 7295, '\p{^Block=olchiki}', "");
    Expect(0, 7295, '\P{Block=olchiki}', "");
    Expect(1, 7295, '\P{^Block=olchiki}', "");
    Expect(0, 7296, '\p{Block=olchiki}', "");
    Expect(1, 7296, '\p{^Block=olchiki}', "");
    Expect(1, 7296, '\P{Block=olchiki}', "");
    Expect(0, 7296, '\P{^Block=olchiki}', "");
    Expect(1, 7295, '\p{Block=_ ol_Chiki}', "");
    Expect(0, 7295, '\p{^Block=_ ol_Chiki}', "");
    Expect(0, 7295, '\P{Block=_ ol_Chiki}', "");
    Expect(1, 7295, '\P{^Block=_ ol_Chiki}', "");
    Expect(0, 7296, '\p{Block=_ ol_Chiki}', "");
    Expect(1, 7296, '\p{^Block=_ ol_Chiki}', "");
    Expect(1, 7296, '\P{Block=_ ol_Chiki}', "");
    Expect(0, 7296, '\P{^Block=_ ol_Chiki}', "");
    Error('\p{Blk= -OL_Chiki:=}');
    Error('\P{Blk= -OL_Chiki:=}');
    Expect(1, 7295, '\p{Blk=olchiki}', "");
    Expect(0, 7295, '\p{^Blk=olchiki}', "");
    Expect(0, 7295, '\P{Blk=olchiki}', "");
    Expect(1, 7295, '\P{^Blk=olchiki}', "");
    Expect(0, 7296, '\p{Blk=olchiki}', "");
    Expect(1, 7296, '\p{^Blk=olchiki}', "");
    Expect(1, 7296, '\P{Blk=olchiki}', "");
    Expect(0, 7296, '\P{^Blk=olchiki}', "");
    Expect(1, 7295, '\p{Blk=Ol_Chiki}', "");
    Expect(0, 7295, '\p{^Blk=Ol_Chiki}', "");
    Expect(0, 7295, '\P{Blk=Ol_Chiki}', "");
    Expect(1, 7295, '\P{^Blk=Ol_Chiki}', "");
    Expect(0, 7296, '\p{Blk=Ol_Chiki}', "");
    Expect(1, 7296, '\p{^Blk=Ol_Chiki}', "");
    Expect(1, 7296, '\P{Blk=Ol_Chiki}', "");
    Expect(0, 7296, '\P{^Blk=Ol_Chiki}', "");
    Error('\p{Is_Block=	Ol_CHIKI/a/}');
    Error('\P{Is_Block=	Ol_CHIKI/a/}');
    Expect(1, 7295, '\p{Is_Block=olchiki}', "");
    Expect(0, 7295, '\p{^Is_Block=olchiki}', "");
    Expect(0, 7295, '\P{Is_Block=olchiki}', "");
    Expect(1, 7295, '\P{^Is_Block=olchiki}', "");
    Expect(0, 7296, '\p{Is_Block=olchiki}', "");
    Expect(1, 7296, '\p{^Is_Block=olchiki}', "");
    Expect(1, 7296, '\P{Is_Block=olchiki}', "");
    Expect(0, 7296, '\P{^Is_Block=olchiki}', "");
    Expect(1, 7295, '\p{Is_Block:_OL_chiki}', "");
    Expect(0, 7295, '\p{^Is_Block:_OL_chiki}', "");
    Expect(0, 7295, '\P{Is_Block:_OL_chiki}', "");
    Expect(1, 7295, '\P{^Is_Block:_OL_chiki}', "");
    Expect(0, 7296, '\p{Is_Block:_OL_chiki}', "");
    Expect(1, 7296, '\p{^Is_Block:_OL_chiki}', "");
    Expect(1, 7296, '\P{Is_Block:_OL_chiki}', "");
    Expect(0, 7296, '\P{^Is_Block:_OL_chiki}', "");
    Error('\p{Is_Blk=:= _ol_chiki}');
    Error('\P{Is_Blk=:= _ol_chiki}');
    Expect(1, 7295, '\p{Is_Blk=olchiki}', "");
    Expect(0, 7295, '\p{^Is_Blk=olchiki}', "");
    Expect(0, 7295, '\P{Is_Blk=olchiki}', "");
    Expect(1, 7295, '\P{^Is_Blk=olchiki}', "");
    Expect(0, 7296, '\p{Is_Blk=olchiki}', "");
    Expect(1, 7296, '\p{^Is_Blk=olchiki}', "");
    Expect(1, 7296, '\P{Is_Blk=olchiki}', "");
    Expect(0, 7296, '\P{^Is_Blk=olchiki}', "");
    Expect(1, 7295, '\p{Is_Blk=_ ol_chiki}', "");
    Expect(0, 7295, '\p{^Is_Blk=_ ol_chiki}', "");
    Expect(0, 7295, '\P{Is_Blk=_ ol_chiki}', "");
    Expect(1, 7295, '\P{^Is_Blk=_ ol_chiki}', "");
    Expect(0, 7296, '\p{Is_Blk=_ ol_chiki}', "");
    Expect(1, 7296, '\p{^Is_Blk=_ ol_chiki}', "");
    Expect(1, 7296, '\P{Is_Blk=_ ol_chiki}', "");
    Expect(0, 7296, '\P{^Is_Blk=_ ol_chiki}', "");
    Error('\p{Block: -:=old_Hungarian}');
    Error('\P{Block: -:=old_Hungarian}');
    Expect(1, 68863, '\p{Block:oldhungarian}', "");
    Expect(0, 68863, '\p{^Block:oldhungarian}', "");
    Expect(0, 68863, '\P{Block:oldhungarian}', "");
    Expect(1, 68863, '\P{^Block:oldhungarian}', "");
    Expect(0, 68864, '\p{Block:oldhungarian}', "");
    Expect(1, 68864, '\p{^Block:oldhungarian}', "");
    Expect(1, 68864, '\P{Block:oldhungarian}', "");
    Expect(0, 68864, '\P{^Block:oldhungarian}', "");
    Expect(1, 68863, '\p{Block=old_hungarian}', "");
    Expect(0, 68863, '\p{^Block=old_hungarian}', "");
    Expect(0, 68863, '\P{Block=old_hungarian}', "");
    Expect(1, 68863, '\P{^Block=old_hungarian}', "");
    Expect(0, 68864, '\p{Block=old_hungarian}', "");
    Expect(1, 68864, '\p{^Block=old_hungarian}', "");
    Expect(1, 68864, '\P{Block=old_hungarian}', "");
    Expect(0, 68864, '\P{^Block=old_hungarian}', "");
    Error('\p{Blk=/a/old_Hungarian}');
    Error('\P{Blk=/a/old_Hungarian}');
    Expect(1, 68863, '\p{Blk=oldhungarian}', "");
    Expect(0, 68863, '\p{^Blk=oldhungarian}', "");
    Expect(0, 68863, '\P{Blk=oldhungarian}', "");
    Expect(1, 68863, '\P{^Blk=oldhungarian}', "");
    Expect(0, 68864, '\p{Blk=oldhungarian}', "");
    Expect(1, 68864, '\p{^Blk=oldhungarian}', "");
    Expect(1, 68864, '\P{Blk=oldhungarian}', "");
    Expect(0, 68864, '\P{^Blk=oldhungarian}', "");
    Expect(1, 68863, '\p{Blk=	OLD_Hungarian}', "");
    Expect(0, 68863, '\p{^Blk=	OLD_Hungarian}', "");
    Expect(0, 68863, '\P{Blk=	OLD_Hungarian}', "");
    Expect(1, 68863, '\P{^Blk=	OLD_Hungarian}', "");
    Expect(0, 68864, '\p{Blk=	OLD_Hungarian}', "");
    Expect(1, 68864, '\p{^Blk=	OLD_Hungarian}', "");
    Expect(1, 68864, '\P{Blk=	OLD_Hungarian}', "");
    Expect(0, 68864, '\P{^Blk=	OLD_Hungarian}', "");
    Error('\p{Is_Block=--Old_Hungarian/a/}');
    Error('\P{Is_Block=--Old_Hungarian/a/}');
    Expect(1, 68863, '\p{Is_Block:   oldhungarian}', "");
    Expect(0, 68863, '\p{^Is_Block:   oldhungarian}', "");
    Expect(0, 68863, '\P{Is_Block:   oldhungarian}', "");
    Expect(1, 68863, '\P{^Is_Block:   oldhungarian}', "");
    Expect(0, 68864, '\p{Is_Block:   oldhungarian}', "");
    Expect(1, 68864, '\p{^Is_Block:   oldhungarian}', "");
    Expect(1, 68864, '\P{Is_Block:   oldhungarian}', "");
    Expect(0, 68864, '\P{^Is_Block:   oldhungarian}', "");
    Expect(1, 68863, '\p{Is_Block=OLD_Hungarian}', "");
    Expect(0, 68863, '\p{^Is_Block=OLD_Hungarian}', "");
    Expect(0, 68863, '\P{Is_Block=OLD_Hungarian}', "");
    Expect(1, 68863, '\P{^Is_Block=OLD_Hungarian}', "");
    Expect(0, 68864, '\p{Is_Block=OLD_Hungarian}', "");
    Expect(1, 68864, '\p{^Is_Block=OLD_Hungarian}', "");
    Expect(1, 68864, '\P{Is_Block=OLD_Hungarian}', "");
    Expect(0, 68864, '\P{^Is_Block=OLD_Hungarian}', "");
    Error('\p{Is_Blk=:=		old_hungarian}');
    Error('\P{Is_Blk=:=		old_hungarian}');
    Expect(1, 68863, '\p{Is_Blk=oldhungarian}', "");
    Expect(0, 68863, '\p{^Is_Blk=oldhungarian}', "");
    Expect(0, 68863, '\P{Is_Blk=oldhungarian}', "");
    Expect(1, 68863, '\P{^Is_Blk=oldhungarian}', "");
    Expect(0, 68864, '\p{Is_Blk=oldhungarian}', "");
    Expect(1, 68864, '\p{^Is_Blk=oldhungarian}', "");
    Expect(1, 68864, '\P{Is_Blk=oldhungarian}', "");
    Expect(0, 68864, '\P{^Is_Blk=oldhungarian}', "");
    Expect(1, 68863, '\p{Is_Blk=_old_HUNGARIAN}', "");
    Expect(0, 68863, '\p{^Is_Blk=_old_HUNGARIAN}', "");
    Expect(0, 68863, '\P{Is_Blk=_old_HUNGARIAN}', "");
    Expect(1, 68863, '\P{^Is_Blk=_old_HUNGARIAN}', "");
    Expect(0, 68864, '\p{Is_Blk=_old_HUNGARIAN}', "");
    Expect(1, 68864, '\p{^Is_Blk=_old_HUNGARIAN}', "");
    Expect(1, 68864, '\P{Is_Blk=_old_HUNGARIAN}', "");
    Expect(0, 68864, '\P{^Is_Blk=_old_HUNGARIAN}', "");
    Error('\p{Block= -Old_Italic/a/}');
    Error('\P{Block= -Old_Italic/a/}');
    Expect(1, 66351, '\p{Block=olditalic}', "");
    Expect(0, 66351, '\p{^Block=olditalic}', "");
    Expect(0, 66351, '\P{Block=olditalic}', "");
    Expect(1, 66351, '\P{^Block=olditalic}', "");
    Expect(0, 66352, '\p{Block=olditalic}', "");
    Expect(1, 66352, '\p{^Block=olditalic}', "");
    Expect(1, 66352, '\P{Block=olditalic}', "");
    Expect(0, 66352, '\P{^Block=olditalic}', "");
    Expect(1, 66351, '\p{Block= Old_ITALIC}', "");
    Expect(0, 66351, '\p{^Block= Old_ITALIC}', "");
    Expect(0, 66351, '\P{Block= Old_ITALIC}', "");
    Expect(1, 66351, '\P{^Block= Old_ITALIC}', "");
    Expect(0, 66352, '\p{Block= Old_ITALIC}', "");
    Expect(1, 66352, '\p{^Block= Old_ITALIC}', "");
    Expect(1, 66352, '\P{Block= Old_ITALIC}', "");
    Expect(0, 66352, '\P{^Block= Old_ITALIC}', "");
    Error('\p{Blk=	:=Old_Italic}');
    Error('\P{Blk=	:=Old_Italic}');
    Expect(1, 66351, '\p{Blk=olditalic}', "");
    Expect(0, 66351, '\p{^Blk=olditalic}', "");
    Expect(0, 66351, '\P{Blk=olditalic}', "");
    Expect(1, 66351, '\P{^Blk=olditalic}', "");
    Expect(0, 66352, '\p{Blk=olditalic}', "");
    Expect(1, 66352, '\p{^Blk=olditalic}', "");
    Expect(1, 66352, '\P{Blk=olditalic}', "");
    Expect(0, 66352, '\P{^Blk=olditalic}', "");
    Expect(1, 66351, '\p{Blk=	Old_italic}', "");
    Expect(0, 66351, '\p{^Blk=	Old_italic}', "");
    Expect(0, 66351, '\P{Blk=	Old_italic}', "");
    Expect(1, 66351, '\P{^Blk=	Old_italic}', "");
    Expect(0, 66352, '\p{Blk=	Old_italic}', "");
    Expect(1, 66352, '\p{^Blk=	Old_italic}', "");
    Expect(1, 66352, '\P{Blk=	Old_italic}', "");
    Expect(0, 66352, '\P{^Blk=	Old_italic}', "");
    Error('\p{Is_Block=_:=Old_ITALIC}');
    Error('\P{Is_Block=_:=Old_ITALIC}');
    Expect(1, 66351, '\p{Is_Block:	olditalic}', "");
    Expect(0, 66351, '\p{^Is_Block:	olditalic}', "");
    Expect(0, 66351, '\P{Is_Block:	olditalic}', "");
    Expect(1, 66351, '\P{^Is_Block:	olditalic}', "");
    Expect(0, 66352, '\p{Is_Block:	olditalic}', "");
    Expect(1, 66352, '\p{^Is_Block:	olditalic}', "");
    Expect(1, 66352, '\P{Is_Block:	olditalic}', "");
    Expect(0, 66352, '\P{^Is_Block:	olditalic}', "");
    Expect(1, 66351, '\p{Is_Block=_Old_Italic}', "");
    Expect(0, 66351, '\p{^Is_Block=_Old_Italic}', "");
    Expect(0, 66351, '\P{Is_Block=_Old_Italic}', "");
    Expect(1, 66351, '\P{^Is_Block=_Old_Italic}', "");
    Expect(0, 66352, '\p{Is_Block=_Old_Italic}', "");
    Expect(1, 66352, '\p{^Is_Block=_Old_Italic}', "");
    Expect(1, 66352, '\P{Is_Block=_Old_Italic}', "");
    Expect(0, 66352, '\P{^Is_Block=_Old_Italic}', "");
    Error('\p{Is_Blk=/a/OLD_Italic}');
    Error('\P{Is_Blk=/a/OLD_Italic}');
    Expect(1, 66351, '\p{Is_Blk=olditalic}', "");
    Expect(0, 66351, '\p{^Is_Blk=olditalic}', "");
    Expect(0, 66351, '\P{Is_Blk=olditalic}', "");
    Expect(1, 66351, '\P{^Is_Blk=olditalic}', "");
    Expect(0, 66352, '\p{Is_Blk=olditalic}', "");
    Expect(1, 66352, '\p{^Is_Blk=olditalic}', "");
    Expect(1, 66352, '\P{Is_Blk=olditalic}', "");
    Expect(0, 66352, '\P{^Is_Blk=olditalic}', "");
    Expect(1, 66351, '\p{Is_Blk=_OLD_Italic}', "");
    Expect(0, 66351, '\p{^Is_Blk=_OLD_Italic}', "");
    Expect(0, 66351, '\P{Is_Blk=_OLD_Italic}', "");
    Expect(1, 66351, '\P{^Is_Blk=_OLD_Italic}', "");
    Expect(0, 66352, '\p{Is_Blk=_OLD_Italic}', "");
    Expect(1, 66352, '\p{^Is_Blk=_OLD_Italic}', "");
    Expect(1, 66352, '\P{Is_Blk=_OLD_Italic}', "");
    Expect(0, 66352, '\P{^Is_Blk=_OLD_Italic}', "");
    Error('\p{Block=:=Old_north_arabian}');
    Error('\P{Block=:=Old_north_arabian}');
    Expect(1, 68255, '\p{Block=oldnortharabian}', "");
    Expect(0, 68255, '\p{^Block=oldnortharabian}', "");
    Expect(0, 68255, '\P{Block=oldnortharabian}', "");
    Expect(1, 68255, '\P{^Block=oldnortharabian}', "");
    Expect(0, 68256, '\p{Block=oldnortharabian}', "");
    Expect(1, 68256, '\p{^Block=oldnortharabian}', "");
    Expect(1, 68256, '\P{Block=oldnortharabian}', "");
    Expect(0, 68256, '\P{^Block=oldnortharabian}', "");
    Expect(1, 68255, '\p{Block=	Old_North_Arabian}', "");
    Expect(0, 68255, '\p{^Block=	Old_North_Arabian}', "");
    Expect(0, 68255, '\P{Block=	Old_North_Arabian}', "");
    Expect(1, 68255, '\P{^Block=	Old_North_Arabian}', "");
    Expect(0, 68256, '\p{Block=	Old_North_Arabian}', "");
    Expect(1, 68256, '\p{^Block=	Old_North_Arabian}', "");
    Expect(1, 68256, '\P{Block=	Old_North_Arabian}', "");
    Expect(0, 68256, '\P{^Block=	Old_North_Arabian}', "");
    Error('\p{Blk=_old_NORTH_Arabian:=}');
    Error('\P{Blk=_old_NORTH_Arabian:=}');
    Expect(1, 68255, '\p{Blk=oldnortharabian}', "");
    Expect(0, 68255, '\p{^Blk=oldnortharabian}', "");
    Expect(0, 68255, '\P{Blk=oldnortharabian}', "");
    Expect(1, 68255, '\P{^Blk=oldnortharabian}', "");
    Expect(0, 68256, '\p{Blk=oldnortharabian}', "");
    Expect(1, 68256, '\p{^Blk=oldnortharabian}', "");
    Expect(1, 68256, '\P{Blk=oldnortharabian}', "");
    Expect(0, 68256, '\P{^Blk=oldnortharabian}', "");
    Expect(1, 68255, '\p{Blk=-	old_NORTH_arabian}', "");
    Expect(0, 68255, '\p{^Blk=-	old_NORTH_arabian}', "");
    Expect(0, 68255, '\P{Blk=-	old_NORTH_arabian}', "");
    Expect(1, 68255, '\P{^Blk=-	old_NORTH_arabian}', "");
    Expect(0, 68256, '\p{Blk=-	old_NORTH_arabian}', "");
    Expect(1, 68256, '\p{^Blk=-	old_NORTH_arabian}', "");
    Expect(1, 68256, '\P{Blk=-	old_NORTH_arabian}', "");
    Expect(0, 68256, '\P{^Blk=-	old_NORTH_arabian}', "");
    Error('\p{Is_Block=/a/- OLD_North_Arabian}');
    Error('\P{Is_Block=/a/- OLD_North_Arabian}');
    Expect(1, 68255, '\p{Is_Block=oldnortharabian}', "");
    Expect(0, 68255, '\p{^Is_Block=oldnortharabian}', "");
    Expect(0, 68255, '\P{Is_Block=oldnortharabian}', "");
    Expect(1, 68255, '\P{^Is_Block=oldnortharabian}', "");
    Expect(0, 68256, '\p{Is_Block=oldnortharabian}', "");
    Expect(1, 68256, '\p{^Is_Block=oldnortharabian}', "");
    Expect(1, 68256, '\P{Is_Block=oldnortharabian}', "");
    Expect(0, 68256, '\P{^Is_Block=oldnortharabian}', "");
    Expect(1, 68255, '\p{Is_Block=_-OLD_North_Arabian}', "");
    Expect(0, 68255, '\p{^Is_Block=_-OLD_North_Arabian}', "");
    Expect(0, 68255, '\P{Is_Block=_-OLD_North_Arabian}', "");
    Expect(1, 68255, '\P{^Is_Block=_-OLD_North_Arabian}', "");
    Expect(0, 68256, '\p{Is_Block=_-OLD_North_Arabian}', "");
    Expect(1, 68256, '\p{^Is_Block=_-OLD_North_Arabian}', "");
    Expect(1, 68256, '\P{Is_Block=_-OLD_North_Arabian}', "");
    Expect(0, 68256, '\P{^Is_Block=_-OLD_North_Arabian}', "");
    Error('\p{Is_Blk=_/a/old_NORTH_ARABIAN}');
    Error('\P{Is_Blk=_/a/old_NORTH_ARABIAN}');
    Expect(1, 68255, '\p{Is_Blk=oldnortharabian}', "");
    Expect(0, 68255, '\p{^Is_Blk=oldnortharabian}', "");
    Expect(0, 68255, '\P{Is_Blk=oldnortharabian}', "");
    Expect(1, 68255, '\P{^Is_Blk=oldnortharabian}', "");
    Expect(0, 68256, '\p{Is_Blk=oldnortharabian}', "");
    Expect(1, 68256, '\p{^Is_Blk=oldnortharabian}', "");
    Expect(1, 68256, '\P{Is_Blk=oldnortharabian}', "");
    Expect(0, 68256, '\P{^Is_Blk=oldnortharabian}', "");
    Expect(1, 68255, '\p{Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(0, 68255, '\p{^Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(0, 68255, '\P{Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(1, 68255, '\P{^Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(0, 68256, '\p{Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(1, 68256, '\p{^Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(1, 68256, '\P{Is_Blk=	-Old_NORTH_Arabian}', "");
    Expect(0, 68256, '\P{^Is_Blk=	-Old_NORTH_Arabian}', "");
    Error('\p{Block=-OLD_Permic/a/}');
    Error('\P{Block=-OLD_Permic/a/}');
    Expect(1, 66431, '\p{Block=oldpermic}', "");
    Expect(0, 66431, '\p{^Block=oldpermic}', "");
    Expect(0, 66431, '\P{Block=oldpermic}', "");
    Expect(1, 66431, '\P{^Block=oldpermic}', "");
    Expect(0, 66432, '\p{Block=oldpermic}', "");
    Expect(1, 66432, '\p{^Block=oldpermic}', "");
    Expect(1, 66432, '\P{Block=oldpermic}', "");
    Expect(0, 66432, '\P{^Block=oldpermic}', "");
    Expect(1, 66431, '\p{Block=__OLD_permic}', "");
    Expect(0, 66431, '\p{^Block=__OLD_permic}', "");
    Expect(0, 66431, '\P{Block=__OLD_permic}', "");
    Expect(1, 66431, '\P{^Block=__OLD_permic}', "");
    Expect(0, 66432, '\p{Block=__OLD_permic}', "");
    Expect(1, 66432, '\p{^Block=__OLD_permic}', "");
    Expect(1, 66432, '\P{Block=__OLD_permic}', "");
    Expect(0, 66432, '\P{^Block=__OLD_permic}', "");
    Error('\p{Blk=--old_PERMIC/a/}');
    Error('\P{Blk=--old_PERMIC/a/}');
    Expect(1, 66431, '\p{Blk=oldpermic}', "");
    Expect(0, 66431, '\p{^Blk=oldpermic}', "");
    Expect(0, 66431, '\P{Blk=oldpermic}', "");
    Expect(1, 66431, '\P{^Blk=oldpermic}', "");
    Expect(0, 66432, '\p{Blk=oldpermic}', "");
    Expect(1, 66432, '\p{^Blk=oldpermic}', "");
    Expect(1, 66432, '\P{Blk=oldpermic}', "");
    Expect(0, 66432, '\P{^Blk=oldpermic}', "");
    Expect(1, 66431, '\p{Blk=_	Old_Permic}', "");
    Expect(0, 66431, '\p{^Blk=_	Old_Permic}', "");
    Expect(0, 66431, '\P{Blk=_	Old_Permic}', "");
    Expect(1, 66431, '\P{^Blk=_	Old_Permic}', "");
    Expect(0, 66432, '\p{Blk=_	Old_Permic}', "");
    Expect(1, 66432, '\p{^Blk=_	Old_Permic}', "");
    Expect(1, 66432, '\P{Blk=_	Old_Permic}', "");
    Expect(0, 66432, '\P{^Blk=_	Old_Permic}', "");
    Error('\p{Is_Block= 	Old_Permic/a/}');
    Error('\P{Is_Block= 	Old_Permic/a/}');
    Expect(1, 66431, '\p{Is_Block=oldpermic}', "");
    Expect(0, 66431, '\p{^Is_Block=oldpermic}', "");
    Expect(0, 66431, '\P{Is_Block=oldpermic}', "");
    Expect(1, 66431, '\P{^Is_Block=oldpermic}', "");
    Expect(0, 66432, '\p{Is_Block=oldpermic}', "");
    Expect(1, 66432, '\p{^Is_Block=oldpermic}', "");
    Expect(1, 66432, '\P{Is_Block=oldpermic}', "");
    Expect(0, 66432, '\P{^Is_Block=oldpermic}', "");
    Expect(1, 66431, '\p{Is_Block= Old_permic}', "");
    Expect(0, 66431, '\p{^Is_Block= Old_permic}', "");
    Expect(0, 66431, '\P{Is_Block= Old_permic}', "");
    Expect(1, 66431, '\P{^Is_Block= Old_permic}', "");
    Expect(0, 66432, '\p{Is_Block= Old_permic}', "");
    Expect(1, 66432, '\p{^Is_Block= Old_permic}', "");
    Expect(1, 66432, '\P{Is_Block= Old_permic}', "");
    Expect(0, 66432, '\P{^Is_Block= Old_permic}', "");
    Error('\p{Is_Blk=:=-_OLD_PERMIC}');
    Error('\P{Is_Blk=:=-_OLD_PERMIC}');
    Expect(1, 66431, '\p{Is_Blk=oldpermic}', "");
    Expect(0, 66431, '\p{^Is_Blk=oldpermic}', "");
    Expect(0, 66431, '\P{Is_Blk=oldpermic}', "");
    Expect(1, 66431, '\P{^Is_Blk=oldpermic}', "");
    Expect(0, 66432, '\p{Is_Blk=oldpermic}', "");
    Expect(1, 66432, '\p{^Is_Blk=oldpermic}', "");
    Expect(1, 66432, '\P{Is_Blk=oldpermic}', "");
    Expect(0, 66432, '\P{^Is_Blk=oldpermic}', "");
    Expect(1, 66431, '\p{Is_Blk= Old_PERMIC}', "");
    Expect(0, 66431, '\p{^Is_Blk= Old_PERMIC}', "");
    Expect(0, 66431, '\P{Is_Blk= Old_PERMIC}', "");
    Expect(1, 66431, '\P{^Is_Blk= Old_PERMIC}', "");
    Expect(0, 66432, '\p{Is_Blk= Old_PERMIC}', "");
    Expect(1, 66432, '\p{^Is_Blk= Old_PERMIC}', "");
    Expect(1, 66432, '\P{Is_Blk= Old_PERMIC}', "");
    Expect(0, 66432, '\P{^Is_Blk= Old_PERMIC}', "");
    Error('\p{Block= :=Old_PERSIAN}');
    Error('\P{Block= :=Old_PERSIAN}');
    Expect(1, 66527, '\p{Block=oldpersian}', "");
    Expect(0, 66527, '\p{^Block=oldpersian}', "");
    Expect(0, 66527, '\P{Block=oldpersian}', "");
    Expect(1, 66527, '\P{^Block=oldpersian}', "");
    Expect(0, 66528, '\p{Block=oldpersian}', "");
    Expect(1, 66528, '\p{^Block=oldpersian}', "");
    Expect(1, 66528, '\P{Block=oldpersian}', "");
    Expect(0, 66528, '\P{^Block=oldpersian}', "");
    Expect(1, 66527, '\p{Block=	-OLD_persian}', "");
    Expect(0, 66527, '\p{^Block=	-OLD_persian}', "");
    Expect(0, 66527, '\P{Block=	-OLD_persian}', "");
    Expect(1, 66527, '\P{^Block=	-OLD_persian}', "");
    Expect(0, 66528, '\p{Block=	-OLD_persian}', "");
    Expect(1, 66528, '\p{^Block=	-OLD_persian}', "");
    Expect(1, 66528, '\P{Block=	-OLD_persian}', "");
    Expect(0, 66528, '\P{^Block=	-OLD_persian}', "");
    Error('\p{Blk=:=- Old_PERSIAN}');
    Error('\P{Blk=:=- Old_PERSIAN}');
    Expect(1, 66527, '\p{Blk=oldpersian}', "");
    Expect(0, 66527, '\p{^Blk=oldpersian}', "");
    Expect(0, 66527, '\P{Blk=oldpersian}', "");
    Expect(1, 66527, '\P{^Blk=oldpersian}', "");
    Expect(0, 66528, '\p{Blk=oldpersian}', "");
    Expect(1, 66528, '\p{^Blk=oldpersian}', "");
    Expect(1, 66528, '\P{Blk=oldpersian}', "");
    Expect(0, 66528, '\P{^Blk=oldpersian}', "");
    Expect(1, 66527, '\p{Blk=-OLD_Persian}', "");
    Expect(0, 66527, '\p{^Blk=-OLD_Persian}', "");
    Expect(0, 66527, '\P{Blk=-OLD_Persian}', "");
    Expect(1, 66527, '\P{^Blk=-OLD_Persian}', "");
    Expect(0, 66528, '\p{Blk=-OLD_Persian}', "");
    Expect(1, 66528, '\p{^Blk=-OLD_Persian}', "");
    Expect(1, 66528, '\P{Blk=-OLD_Persian}', "");
    Expect(0, 66528, '\P{^Blk=-OLD_Persian}', "");
    Error('\p{Is_Block=	old_persian:=}');
    Error('\P{Is_Block=	old_persian:=}');
    Expect(1, 66527, '\p{Is_Block=oldpersian}', "");
    Expect(0, 66527, '\p{^Is_Block=oldpersian}', "");
    Expect(0, 66527, '\P{Is_Block=oldpersian}', "");
    Expect(1, 66527, '\P{^Is_Block=oldpersian}', "");
    Expect(0, 66528, '\p{Is_Block=oldpersian}', "");
    Expect(1, 66528, '\p{^Is_Block=oldpersian}', "");
    Expect(1, 66528, '\P{Is_Block=oldpersian}', "");
    Expect(0, 66528, '\P{^Is_Block=oldpersian}', "");
    Expect(1, 66527, '\p{Is_Block= old_Persian}', "");
    Expect(0, 66527, '\p{^Is_Block= old_Persian}', "");
    Expect(0, 66527, '\P{Is_Block= old_Persian}', "");
    Expect(1, 66527, '\P{^Is_Block= old_Persian}', "");
    Expect(0, 66528, '\p{Is_Block= old_Persian}', "");
    Expect(1, 66528, '\p{^Is_Block= old_Persian}', "");
    Expect(1, 66528, '\P{Is_Block= old_Persian}', "");
    Expect(0, 66528, '\P{^Is_Block= old_Persian}', "");
    Error('\p{Is_Blk:   -Old_Persian:=}');
    Error('\P{Is_Blk:   -Old_Persian:=}');
    Expect(1, 66527, '\p{Is_Blk=oldpersian}', "");
    Expect(0, 66527, '\p{^Is_Blk=oldpersian}', "");
    Expect(0, 66527, '\P{Is_Blk=oldpersian}', "");
    Expect(1, 66527, '\P{^Is_Blk=oldpersian}', "");
    Expect(0, 66528, '\p{Is_Blk=oldpersian}', "");
    Expect(1, 66528, '\p{^Is_Blk=oldpersian}', "");
    Expect(1, 66528, '\P{Is_Blk=oldpersian}', "");
    Expect(0, 66528, '\P{^Is_Blk=oldpersian}', "");
    Expect(1, 66527, '\p{Is_Blk= -Old_persian}', "");
    Expect(0, 66527, '\p{^Is_Blk= -Old_persian}', "");
    Expect(0, 66527, '\P{Is_Blk= -Old_persian}', "");
    Expect(1, 66527, '\P{^Is_Blk= -Old_persian}', "");
    Expect(0, 66528, '\p{Is_Blk= -Old_persian}', "");
    Expect(1, 66528, '\p{^Is_Blk= -Old_persian}', "");
    Expect(1, 66528, '\P{Is_Blk= -Old_persian}', "");
    Expect(0, 66528, '\P{^Is_Blk= -Old_persian}', "");
    Error('\p{Block:  /a/Old_South_ARABIAN}');
    Error('\P{Block:  /a/Old_South_ARABIAN}');
    Expect(1, 68223, '\p{Block=oldsoutharabian}', "");
    Expect(0, 68223, '\p{^Block=oldsoutharabian}', "");
    Expect(0, 68223, '\P{Block=oldsoutharabian}', "");
    Expect(1, 68223, '\P{^Block=oldsoutharabian}', "");
    Expect(0, 68224, '\p{Block=oldsoutharabian}', "");
    Expect(1, 68224, '\p{^Block=oldsoutharabian}', "");
    Expect(1, 68224, '\P{Block=oldsoutharabian}', "");
    Expect(0, 68224, '\P{^Block=oldsoutharabian}', "");
    Expect(1, 68223, '\p{Block=_ old_South_Arabian}', "");
    Expect(0, 68223, '\p{^Block=_ old_South_Arabian}', "");
    Expect(0, 68223, '\P{Block=_ old_South_Arabian}', "");
    Expect(1, 68223, '\P{^Block=_ old_South_Arabian}', "");
    Expect(0, 68224, '\p{Block=_ old_South_Arabian}', "");
    Expect(1, 68224, '\p{^Block=_ old_South_Arabian}', "");
    Expect(1, 68224, '\P{Block=_ old_South_Arabian}', "");
    Expect(0, 68224, '\P{^Block=_ old_South_Arabian}', "");
    Error('\p{Blk: OLD_South_arabian:=}');
    Error('\P{Blk: OLD_South_arabian:=}');
    Expect(1, 68223, '\p{Blk:   oldsoutharabian}', "");
    Expect(0, 68223, '\p{^Blk:   oldsoutharabian}', "");
    Expect(0, 68223, '\P{Blk:   oldsoutharabian}', "");
    Expect(1, 68223, '\P{^Blk:   oldsoutharabian}', "");
    Expect(0, 68224, '\p{Blk:   oldsoutharabian}', "");
    Expect(1, 68224, '\p{^Blk:   oldsoutharabian}', "");
    Expect(1, 68224, '\P{Blk:   oldsoutharabian}', "");
    Expect(0, 68224, '\P{^Blk:   oldsoutharabian}', "");
    Expect(1, 68223, '\p{Blk=	-Old_SOUTH_Arabian}', "");
    Expect(0, 68223, '\p{^Blk=	-Old_SOUTH_Arabian}', "");
    Expect(0, 68223, '\P{Blk=	-Old_SOUTH_Arabian}', "");
    Expect(1, 68223, '\P{^Blk=	-Old_SOUTH_Arabian}', "");
    Expect(0, 68224, '\p{Blk=	-Old_SOUTH_Arabian}', "");
    Expect(1, 68224, '\p{^Blk=	-Old_SOUTH_Arabian}', "");
    Expect(1, 68224, '\P{Blk=	-Old_SOUTH_Arabian}', "");
    Expect(0, 68224, '\P{^Blk=	-Old_SOUTH_Arabian}', "");
    Error('\p{Is_Block=	_Old_South_ARABIAN/a/}');
    Error('\P{Is_Block=	_Old_South_ARABIAN/a/}');
    Expect(1, 68223, '\p{Is_Block=oldsoutharabian}', "");
    Expect(0, 68223, '\p{^Is_Block=oldsoutharabian}', "");
    Expect(0, 68223, '\P{Is_Block=oldsoutharabian}', "");
    Expect(1, 68223, '\P{^Is_Block=oldsoutharabian}', "");
    Expect(0, 68224, '\p{Is_Block=oldsoutharabian}', "");
    Expect(1, 68224, '\p{^Is_Block=oldsoutharabian}', "");
    Expect(1, 68224, '\P{Is_Block=oldsoutharabian}', "");
    Expect(0, 68224, '\P{^Is_Block=oldsoutharabian}', "");
    Expect(1, 68223, '\p{Is_Block=	OLD_south_Arabian}', "");
    Expect(0, 68223, '\p{^Is_Block=	OLD_south_Arabian}', "");
    Expect(0, 68223, '\P{Is_Block=	OLD_south_Arabian}', "");
    Expect(1, 68223, '\P{^Is_Block=	OLD_south_Arabian}', "");
    Expect(0, 68224, '\p{Is_Block=	OLD_south_Arabian}', "");
    Expect(1, 68224, '\p{^Is_Block=	OLD_south_Arabian}', "");
    Expect(1, 68224, '\P{Is_Block=	OLD_south_Arabian}', "");
    Expect(0, 68224, '\P{^Is_Block=	OLD_south_Arabian}', "");
    Error('\p{Is_Blk=_:=OLD_south_arabian}');
    Error('\P{Is_Blk=_:=OLD_south_arabian}');
    Expect(1, 68223, '\p{Is_Blk=oldsoutharabian}', "");
    Expect(0, 68223, '\p{^Is_Blk=oldsoutharabian}', "");
    Expect(0, 68223, '\P{Is_Blk=oldsoutharabian}', "");
    Expect(1, 68223, '\P{^Is_Blk=oldsoutharabian}', "");
    Expect(0, 68224, '\p{Is_Blk=oldsoutharabian}', "");
    Expect(1, 68224, '\p{^Is_Blk=oldsoutharabian}', "");
    Expect(1, 68224, '\P{Is_Blk=oldsoutharabian}', "");
    Expect(0, 68224, '\P{^Is_Blk=oldsoutharabian}', "");
    Expect(1, 68223, '\p{Is_Blk:    -Old_south_Arabian}', "");
    Expect(0, 68223, '\p{^Is_Blk:    -Old_south_Arabian}', "");
    Expect(0, 68223, '\P{Is_Blk:    -Old_south_Arabian}', "");
    Expect(1, 68223, '\P{^Is_Blk:    -Old_south_Arabian}', "");
    Expect(0, 68224, '\p{Is_Blk:    -Old_south_Arabian}', "");
    Expect(1, 68224, '\p{^Is_Blk:    -Old_south_Arabian}', "");
    Expect(1, 68224, '\P{Is_Blk:    -Old_south_Arabian}', "");
    Expect(0, 68224, '\P{^Is_Blk:    -Old_south_Arabian}', "");
    Error('\p{Block=__Old_TURKIC/a/}');
    Error('\P{Block=__Old_TURKIC/a/}');
    Expect(1, 68687, '\p{Block=oldturkic}', "");
    Expect(0, 68687, '\p{^Block=oldturkic}', "");
    Expect(0, 68687, '\P{Block=oldturkic}', "");
    Expect(1, 68687, '\P{^Block=oldturkic}', "");
    Expect(0, 68688, '\p{Block=oldturkic}', "");
    Expect(1, 68688, '\p{^Block=oldturkic}', "");
    Expect(1, 68688, '\P{Block=oldturkic}', "");
    Expect(0, 68688, '\P{^Block=oldturkic}', "");
    Expect(1, 68687, '\p{Block=	OLD_TURKIC}', "");
    Expect(0, 68687, '\p{^Block=	OLD_TURKIC}', "");
    Expect(0, 68687, '\P{Block=	OLD_TURKIC}', "");
    Expect(1, 68687, '\P{^Block=	OLD_TURKIC}', "");
    Expect(0, 68688, '\p{Block=	OLD_TURKIC}', "");
    Expect(1, 68688, '\p{^Block=	OLD_TURKIC}', "");
    Expect(1, 68688, '\P{Block=	OLD_TURKIC}', "");
    Expect(0, 68688, '\P{^Block=	OLD_TURKIC}', "");
    Error('\p{Blk=_:=OLD_Turkic}');
    Error('\P{Blk=_:=OLD_Turkic}');
    Expect(1, 68687, '\p{Blk:   oldturkic}', "");
    Expect(0, 68687, '\p{^Blk:   oldturkic}', "");
    Expect(0, 68687, '\P{Blk:   oldturkic}', "");
    Expect(1, 68687, '\P{^Blk:   oldturkic}', "");
    Expect(0, 68688, '\p{Blk:   oldturkic}', "");
    Expect(1, 68688, '\p{^Blk:   oldturkic}', "");
    Expect(1, 68688, '\P{Blk:   oldturkic}', "");
    Expect(0, 68688, '\P{^Blk:   oldturkic}', "");
    Expect(1, 68687, '\p{Blk=	 Old_Turkic}', "");
    Expect(0, 68687, '\p{^Blk=	 Old_Turkic}', "");
    Expect(0, 68687, '\P{Blk=	 Old_Turkic}', "");
    Expect(1, 68687, '\P{^Blk=	 Old_Turkic}', "");
    Expect(0, 68688, '\p{Blk=	 Old_Turkic}', "");
    Expect(1, 68688, '\p{^Blk=	 Old_Turkic}', "");
    Expect(1, 68688, '\P{Blk=	 Old_Turkic}', "");
    Expect(0, 68688, '\P{^Blk=	 Old_Turkic}', "");
    Error('\p{Is_Block=/a/	 old_Turkic}');
    Error('\P{Is_Block=/a/	 old_Turkic}');
    Expect(1, 68687, '\p{Is_Block=oldturkic}', "");
    Expect(0, 68687, '\p{^Is_Block=oldturkic}', "");
    Expect(0, 68687, '\P{Is_Block=oldturkic}', "");
    Expect(1, 68687, '\P{^Is_Block=oldturkic}', "");
    Expect(0, 68688, '\p{Is_Block=oldturkic}', "");
    Expect(1, 68688, '\p{^Is_Block=oldturkic}', "");
    Expect(1, 68688, '\P{Is_Block=oldturkic}', "");
    Expect(0, 68688, '\P{^Is_Block=oldturkic}', "");
    Expect(1, 68687, '\p{Is_Block=Old_TURKIC}', "");
    Expect(0, 68687, '\p{^Is_Block=Old_TURKIC}', "");
    Expect(0, 68687, '\P{Is_Block=Old_TURKIC}', "");
    Expect(1, 68687, '\P{^Is_Block=Old_TURKIC}', "");
    Expect(0, 68688, '\p{Is_Block=Old_TURKIC}', "");
    Expect(1, 68688, '\p{^Is_Block=Old_TURKIC}', "");
    Expect(1, 68688, '\P{Is_Block=Old_TURKIC}', "");
    Expect(0, 68688, '\P{^Is_Block=Old_TURKIC}', "");
    Error('\p{Is_Blk= Old_Turkic/a/}');
    Error('\P{Is_Blk= Old_Turkic/a/}');
    Expect(1, 68687, '\p{Is_Blk=oldturkic}', "");
    Expect(0, 68687, '\p{^Is_Blk=oldturkic}', "");
    Expect(0, 68687, '\P{Is_Blk=oldturkic}', "");
    Expect(1, 68687, '\P{^Is_Blk=oldturkic}', "");
    Expect(0, 68688, '\p{Is_Blk=oldturkic}', "");
    Expect(1, 68688, '\p{^Is_Blk=oldturkic}', "");
    Expect(1, 68688, '\P{Is_Blk=oldturkic}', "");
    Expect(0, 68688, '\P{^Is_Blk=oldturkic}', "");
    Expect(1, 68687, '\p{Is_Blk=_	old_TURKIC}', "");
    Expect(0, 68687, '\p{^Is_Blk=_	old_TURKIC}', "");
    Expect(0, 68687, '\P{Is_Blk=_	old_TURKIC}', "");
    Expect(1, 68687, '\P{^Is_Blk=_	old_TURKIC}', "");
    Expect(0, 68688, '\p{Is_Blk=_	old_TURKIC}', "");
    Expect(1, 68688, '\p{^Is_Blk=_	old_TURKIC}', "");
    Expect(1, 68688, '\P{Is_Blk=_	old_TURKIC}', "");
    Expect(0, 68688, '\P{^Is_Blk=_	old_TURKIC}', "");
    Error('\p{Block=- ORIYA:=}');
    Error('\P{Block=- ORIYA:=}');
    Expect(1, 2943, '\p{Block=oriya}', "");
    Expect(0, 2943, '\p{^Block=oriya}', "");
    Expect(0, 2943, '\P{Block=oriya}', "");
    Expect(1, 2943, '\P{^Block=oriya}', "");
    Expect(0, 2944, '\p{Block=oriya}', "");
    Expect(1, 2944, '\p{^Block=oriya}', "");
    Expect(1, 2944, '\P{Block=oriya}', "");
    Expect(0, 2944, '\P{^Block=oriya}', "");
    Expect(1, 2943, '\p{Block=_	oriya}', "");
    Expect(0, 2943, '\p{^Block=_	oriya}', "");
    Expect(0, 2943, '\P{Block=_	oriya}', "");
    Expect(1, 2943, '\P{^Block=_	oriya}', "");
    Expect(0, 2944, '\p{Block=_	oriya}', "");
    Expect(1, 2944, '\p{^Block=_	oriya}', "");
    Expect(1, 2944, '\P{Block=_	oriya}', "");
    Expect(0, 2944, '\P{^Block=_	oriya}', "");
    Error('\p{Blk=	/a/Oriya}');
    Error('\P{Blk=	/a/Oriya}');
    Expect(1, 2943, '\p{Blk=oriya}', "");
    Expect(0, 2943, '\p{^Blk=oriya}', "");
    Expect(0, 2943, '\P{Blk=oriya}', "");
    Expect(1, 2943, '\P{^Blk=oriya}', "");
    Expect(0, 2944, '\p{Blk=oriya}', "");
    Expect(1, 2944, '\p{^Blk=oriya}', "");
    Expect(1, 2944, '\P{Blk=oriya}', "");
    Expect(0, 2944, '\P{^Blk=oriya}', "");
    Expect(1, 2943, '\p{Blk= -Oriya}', "");
    Expect(0, 2943, '\p{^Blk= -Oriya}', "");
    Expect(0, 2943, '\P{Blk= -Oriya}', "");
    Expect(1, 2943, '\P{^Blk= -Oriya}', "");
    Expect(0, 2944, '\p{Blk= -Oriya}', "");
    Expect(1, 2944, '\p{^Blk= -Oriya}', "");
    Expect(1, 2944, '\P{Blk= -Oriya}', "");
    Expect(0, 2944, '\P{^Blk= -Oriya}', "");
    Error('\p{Is_Block=	:=Oriya}');
    Error('\P{Is_Block=	:=Oriya}');
    Expect(1, 2943, '\p{Is_Block=oriya}', "");
    Expect(0, 2943, '\p{^Is_Block=oriya}', "");
    Expect(0, 2943, '\P{Is_Block=oriya}', "");
    Expect(1, 2943, '\P{^Is_Block=oriya}', "");
    Expect(0, 2944, '\p{Is_Block=oriya}', "");
    Expect(1, 2944, '\p{^Is_Block=oriya}', "");
    Expect(1, 2944, '\P{Is_Block=oriya}', "");
    Expect(0, 2944, '\P{^Is_Block=oriya}', "");
    Expect(1, 2943, '\p{Is_Block= 	oriya}', "");
    Expect(0, 2943, '\p{^Is_Block= 	oriya}', "");
    Expect(0, 2943, '\P{Is_Block= 	oriya}', "");
    Expect(1, 2943, '\P{^Is_Block= 	oriya}', "");
    Expect(0, 2944, '\p{Is_Block= 	oriya}', "");
    Expect(1, 2944, '\p{^Is_Block= 	oriya}', "");
    Expect(1, 2944, '\P{Is_Block= 	oriya}', "");
    Expect(0, 2944, '\P{^Is_Block= 	oriya}', "");
    Error('\p{Is_Blk=-_ORIYA/a/}');
    Error('\P{Is_Blk=-_ORIYA/a/}');
    Expect(1, 2943, '\p{Is_Blk=oriya}', "");
    Expect(0, 2943, '\p{^Is_Blk=oriya}', "");
    Expect(0, 2943, '\P{Is_Blk=oriya}', "");
    Expect(1, 2943, '\P{^Is_Blk=oriya}', "");
    Expect(0, 2944, '\p{Is_Blk=oriya}', "");
    Expect(1, 2944, '\p{^Is_Blk=oriya}', "");
    Expect(1, 2944, '\P{Is_Blk=oriya}', "");
    Expect(0, 2944, '\P{^Is_Blk=oriya}', "");
    Expect(1, 2943, '\p{Is_Blk= 	oriya}', "");
    Expect(0, 2943, '\p{^Is_Blk= 	oriya}', "");
    Expect(0, 2943, '\P{Is_Blk= 	oriya}', "");
    Expect(1, 2943, '\P{^Is_Blk= 	oriya}', "");
    Expect(0, 2944, '\p{Is_Blk= 	oriya}', "");
    Expect(1, 2944, '\p{^Is_Blk= 	oriya}', "");
    Expect(1, 2944, '\P{Is_Blk= 	oriya}', "");
    Expect(0, 2944, '\P{^Is_Blk= 	oriya}', "");
    Error('\p{Block: :=	 Ornamental_dingbats}');
    Error('\P{Block: :=	 Ornamental_dingbats}');
    Expect(1, 128639, '\p{Block=ornamentaldingbats}', "");
    Expect(0, 128639, '\p{^Block=ornamentaldingbats}', "");
    Expect(0, 128639, '\P{Block=ornamentaldingbats}', "");
    Expect(1, 128639, '\P{^Block=ornamentaldingbats}', "");
    Expect(0, 128640, '\p{Block=ornamentaldingbats}', "");
    Expect(1, 128640, '\p{^Block=ornamentaldingbats}', "");
    Expect(1, 128640, '\P{Block=ornamentaldingbats}', "");
    Expect(0, 128640, '\P{^Block=ornamentaldingbats}', "");
    Expect(1, 128639, '\p{Block=	-Ornamental_Dingbats}', "");
    Expect(0, 128639, '\p{^Block=	-Ornamental_Dingbats}', "");
    Expect(0, 128639, '\P{Block=	-Ornamental_Dingbats}', "");
    Expect(1, 128639, '\P{^Block=	-Ornamental_Dingbats}', "");
    Expect(0, 128640, '\p{Block=	-Ornamental_Dingbats}', "");
    Expect(1, 128640, '\p{^Block=	-Ornamental_Dingbats}', "");
    Expect(1, 128640, '\P{Block=	-Ornamental_Dingbats}', "");
    Expect(0, 128640, '\P{^Block=	-Ornamental_Dingbats}', "");
    Error('\p{Blk=-ORNAMENTAL_dingbats/a/}');
    Error('\P{Blk=-ORNAMENTAL_dingbats/a/}');
    Expect(1, 128639, '\p{Blk=ornamentaldingbats}', "");
    Expect(0, 128639, '\p{^Blk=ornamentaldingbats}', "");
    Expect(0, 128639, '\P{Blk=ornamentaldingbats}', "");
    Expect(1, 128639, '\P{^Blk=ornamentaldingbats}', "");
    Expect(0, 128640, '\p{Blk=ornamentaldingbats}', "");
    Expect(1, 128640, '\p{^Blk=ornamentaldingbats}', "");
    Expect(1, 128640, '\P{Blk=ornamentaldingbats}', "");
    Expect(0, 128640, '\P{^Blk=ornamentaldingbats}', "");
    Expect(1, 128639, '\p{Blk=		ornamental_DINGBATS}', "");
    Expect(0, 128639, '\p{^Blk=		ornamental_DINGBATS}', "");
    Expect(0, 128639, '\P{Blk=		ornamental_DINGBATS}', "");
    Expect(1, 128639, '\P{^Blk=		ornamental_DINGBATS}', "");
    Expect(0, 128640, '\p{Blk=		ornamental_DINGBATS}', "");
    Expect(1, 128640, '\p{^Blk=		ornamental_DINGBATS}', "");
    Expect(1, 128640, '\P{Blk=		ornamental_DINGBATS}', "");
    Expect(0, 128640, '\P{^Blk=		ornamental_DINGBATS}', "");
    Error('\p{Is_Block=:=-_Ornamental_Dingbats}');
    Error('\P{Is_Block=:=-_Ornamental_Dingbats}');
    Expect(1, 128639, '\p{Is_Block=ornamentaldingbats}', "");
    Expect(0, 128639, '\p{^Is_Block=ornamentaldingbats}', "");
    Expect(0, 128639, '\P{Is_Block=ornamentaldingbats}', "");
    Expect(1, 128639, '\P{^Is_Block=ornamentaldingbats}', "");
    Expect(0, 128640, '\p{Is_Block=ornamentaldingbats}', "");
    Expect(1, 128640, '\p{^Is_Block=ornamentaldingbats}', "");
    Expect(1, 128640, '\P{Is_Block=ornamentaldingbats}', "");
    Expect(0, 128640, '\P{^Is_Block=ornamentaldingbats}', "");
    Expect(1, 128639, '\p{Is_Block=Ornamental_Dingbats}', "");
    Expect(0, 128639, '\p{^Is_Block=Ornamental_Dingbats}', "");
    Expect(0, 128639, '\P{Is_Block=Ornamental_Dingbats}', "");
    Expect(1, 128639, '\P{^Is_Block=Ornamental_Dingbats}', "");
    Expect(0, 128640, '\p{Is_Block=Ornamental_Dingbats}', "");
    Expect(1, 128640, '\p{^Is_Block=Ornamental_Dingbats}', "");
    Expect(1, 128640, '\P{Is_Block=Ornamental_Dingbats}', "");
    Expect(0, 128640, '\P{^Is_Block=Ornamental_Dingbats}', "");
    Error('\p{Is_Blk=/a/--ORNAMENTAL_Dingbats}');
    Error('\P{Is_Blk=/a/--ORNAMENTAL_Dingbats}');
    Expect(1, 128639, '\p{Is_Blk=ornamentaldingbats}', "");
    Expect(0, 128639, '\p{^Is_Blk=ornamentaldingbats}', "");
    Expect(0, 128639, '\P{Is_Blk=ornamentaldingbats}', "");
    Expect(1, 128639, '\P{^Is_Blk=ornamentaldingbats}', "");
    Expect(0, 128640, '\p{Is_Blk=ornamentaldingbats}', "");
    Expect(1, 128640, '\p{^Is_Blk=ornamentaldingbats}', "");
    Expect(1, 128640, '\P{Is_Blk=ornamentaldingbats}', "");
    Expect(0, 128640, '\P{^Is_Blk=ornamentaldingbats}', "");
    Expect(1, 128639, '\p{Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(0, 128639, '\p{^Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(0, 128639, '\P{Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(1, 128639, '\P{^Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(0, 128640, '\p{Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(1, 128640, '\p{^Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(1, 128640, '\P{Is_Blk=_	Ornamental_Dingbats}', "");
    Expect(0, 128640, '\P{^Is_Blk=_	Ornamental_Dingbats}', "");
    Error('\p{Block=:=Osage}');
    Error('\P{Block=:=Osage}');
    Expect(1, 66815, '\p{Block=osage}', "");
    Expect(0, 66815, '\p{^Block=osage}', "");
    Expect(0, 66815, '\P{Block=osage}', "");
    Expect(1, 66815, '\P{^Block=osage}', "");
    Expect(0, 66816, '\p{Block=osage}', "");
    Expect(1, 66816, '\p{^Block=osage}', "");
    Expect(1, 66816, '\P{Block=osage}', "");
    Expect(0, 66816, '\P{^Block=osage}', "");
    Expect(1, 66815, '\p{Block:	_OSAGE}', "");
    Expect(0, 66815, '\p{^Block:	_OSAGE}', "");
    Expect(0, 66815, '\P{Block:	_OSAGE}', "");
    Expect(1, 66815, '\P{^Block:	_OSAGE}', "");
    Expect(0, 66816, '\p{Block:	_OSAGE}', "");
    Expect(1, 66816, '\p{^Block:	_OSAGE}', "");
    Expect(1, 66816, '\P{Block:	_OSAGE}', "");
    Expect(0, 66816, '\P{^Block:	_OSAGE}', "");
    Error('\p{Blk: :=-	osage}');
    Error('\P{Blk: :=-	osage}');
    Expect(1, 66815, '\p{Blk=osage}', "");
    Expect(0, 66815, '\p{^Blk=osage}', "");
    Expect(0, 66815, '\P{Blk=osage}', "");
    Expect(1, 66815, '\P{^Blk=osage}', "");
    Expect(0, 66816, '\p{Blk=osage}', "");
    Expect(1, 66816, '\p{^Blk=osage}', "");
    Expect(1, 66816, '\P{Blk=osage}', "");
    Expect(0, 66816, '\P{^Blk=osage}', "");
    Expect(1, 66815, '\p{Blk=__OSAGE}', "");
    Expect(0, 66815, '\p{^Blk=__OSAGE}', "");
    Expect(0, 66815, '\P{Blk=__OSAGE}', "");
    Expect(1, 66815, '\P{^Blk=__OSAGE}', "");
    Expect(0, 66816, '\p{Blk=__OSAGE}', "");
    Expect(1, 66816, '\p{^Blk=__OSAGE}', "");
    Expect(1, 66816, '\P{Blk=__OSAGE}', "");
    Expect(0, 66816, '\P{^Blk=__OSAGE}', "");
    Error('\p{Is_Block=:=Osage}');
    Error('\P{Is_Block=:=Osage}');
    Expect(1, 66815, '\p{Is_Block=osage}', "");
    Expect(0, 66815, '\p{^Is_Block=osage}', "");
    Expect(0, 66815, '\P{Is_Block=osage}', "");
    Expect(1, 66815, '\P{^Is_Block=osage}', "");
    Expect(0, 66816, '\p{Is_Block=osage}', "");
    Expect(1, 66816, '\p{^Is_Block=osage}', "");
    Expect(1, 66816, '\P{Is_Block=osage}', "");
    Expect(0, 66816, '\P{^Is_Block=osage}', "");
    Expect(1, 66815, '\p{Is_Block=-OSAGE}', "");
    Expect(0, 66815, '\p{^Is_Block=-OSAGE}', "");
    Expect(0, 66815, '\P{Is_Block=-OSAGE}', "");
    Expect(1, 66815, '\P{^Is_Block=-OSAGE}', "");
    Expect(0, 66816, '\p{Is_Block=-OSAGE}', "");
    Expect(1, 66816, '\p{^Is_Block=-OSAGE}', "");
    Expect(1, 66816, '\P{Is_Block=-OSAGE}', "");
    Expect(0, 66816, '\P{^Is_Block=-OSAGE}', "");
    Error('\p{Is_Blk:    :=OSAGE}');
    Error('\P{Is_Blk:    :=OSAGE}');
    Expect(1, 66815, '\p{Is_Blk=osage}', "");
    Expect(0, 66815, '\p{^Is_Blk=osage}', "");
    Expect(0, 66815, '\P{Is_Blk=osage}', "");
    Expect(1, 66815, '\P{^Is_Blk=osage}', "");
    Expect(0, 66816, '\p{Is_Blk=osage}', "");
    Expect(1, 66816, '\p{^Is_Blk=osage}', "");
    Expect(1, 66816, '\P{Is_Blk=osage}', "");
    Expect(0, 66816, '\P{^Is_Blk=osage}', "");
    Expect(1, 66815, '\p{Is_Blk=- OSAGE}', "");
    Expect(0, 66815, '\p{^Is_Blk=- OSAGE}', "");
    Expect(0, 66815, '\P{Is_Blk=- OSAGE}', "");
    Expect(1, 66815, '\P{^Is_Blk=- OSAGE}', "");
    Expect(0, 66816, '\p{Is_Blk=- OSAGE}', "");
    Expect(1, 66816, '\p{^Is_Blk=- OSAGE}', "");
    Expect(1, 66816, '\P{Is_Blk=- OSAGE}', "");
    Expect(0, 66816, '\P{^Is_Blk=- OSAGE}', "");
    Error('\p{Block=/a/_osmanya}');
    Error('\P{Block=/a/_osmanya}');
    Expect(1, 66735, '\p{Block=osmanya}', "");
    Expect(0, 66735, '\p{^Block=osmanya}', "");
    Expect(0, 66735, '\P{Block=osmanya}', "");
    Expect(1, 66735, '\P{^Block=osmanya}', "");
    Expect(0, 66736, '\p{Block=osmanya}', "");
    Expect(1, 66736, '\p{^Block=osmanya}', "");
    Expect(1, 66736, '\P{Block=osmanya}', "");
    Expect(0, 66736, '\P{^Block=osmanya}', "");
    Expect(1, 66735, '\p{Block=_-Osmanya}', "");
    Expect(0, 66735, '\p{^Block=_-Osmanya}', "");
    Expect(0, 66735, '\P{Block=_-Osmanya}', "");
    Expect(1, 66735, '\P{^Block=_-Osmanya}', "");
    Expect(0, 66736, '\p{Block=_-Osmanya}', "");
    Expect(1, 66736, '\p{^Block=_-Osmanya}', "");
    Expect(1, 66736, '\P{Block=_-Osmanya}', "");
    Expect(0, 66736, '\P{^Block=_-Osmanya}', "");
    Error('\p{Blk:_:=OSMANYA}');
    Error('\P{Blk:_:=OSMANYA}');
    Expect(1, 66735, '\p{Blk=osmanya}', "");
    Expect(0, 66735, '\p{^Blk=osmanya}', "");
    Expect(0, 66735, '\P{Blk=osmanya}', "");
    Expect(1, 66735, '\P{^Blk=osmanya}', "");
    Expect(0, 66736, '\p{Blk=osmanya}', "");
    Expect(1, 66736, '\p{^Blk=osmanya}', "");
    Expect(1, 66736, '\P{Blk=osmanya}', "");
    Expect(0, 66736, '\P{^Blk=osmanya}', "");
    Expect(1, 66735, '\p{Blk=__Osmanya}', "");
    Expect(0, 66735, '\p{^Blk=__Osmanya}', "");
    Expect(0, 66735, '\P{Blk=__Osmanya}', "");
    Expect(1, 66735, '\P{^Blk=__Osmanya}', "");
    Expect(0, 66736, '\p{Blk=__Osmanya}', "");
    Expect(1, 66736, '\p{^Blk=__Osmanya}', "");
    Expect(1, 66736, '\P{Blk=__Osmanya}', "");
    Expect(0, 66736, '\P{^Blk=__Osmanya}', "");
    Error('\p{Is_Block=-osmanya:=}');
    Error('\P{Is_Block=-osmanya:=}');
    Expect(1, 66735, '\p{Is_Block=osmanya}', "");
    Expect(0, 66735, '\p{^Is_Block=osmanya}', "");
    Expect(0, 66735, '\P{Is_Block=osmanya}', "");
    Expect(1, 66735, '\P{^Is_Block=osmanya}', "");
    Expect(0, 66736, '\p{Is_Block=osmanya}', "");
    Expect(1, 66736, '\p{^Is_Block=osmanya}', "");
    Expect(1, 66736, '\P{Is_Block=osmanya}', "");
    Expect(0, 66736, '\P{^Is_Block=osmanya}', "");
    Expect(1, 66735, '\p{Is_Block= 	osmanya}', "");
    Expect(0, 66735, '\p{^Is_Block= 	osmanya}', "");
    Expect(0, 66735, '\P{Is_Block= 	osmanya}', "");
    Expect(1, 66735, '\P{^Is_Block= 	osmanya}', "");
    Expect(0, 66736, '\p{Is_Block= 	osmanya}', "");
    Expect(1, 66736, '\p{^Is_Block= 	osmanya}', "");
    Expect(1, 66736, '\P{Is_Block= 	osmanya}', "");
    Expect(0, 66736, '\P{^Is_Block= 	osmanya}', "");
    Error('\p{Is_Blk=:=- Osmanya}');
    Error('\P{Is_Blk=:=- Osmanya}');
    Expect(1, 66735, '\p{Is_Blk:	osmanya}', "");
    Expect(0, 66735, '\p{^Is_Blk:	osmanya}', "");
    Expect(0, 66735, '\P{Is_Blk:	osmanya}', "");
    Expect(1, 66735, '\P{^Is_Blk:	osmanya}', "");
    Expect(0, 66736, '\p{Is_Blk:	osmanya}', "");
    Expect(1, 66736, '\p{^Is_Blk:	osmanya}', "");
    Expect(1, 66736, '\P{Is_Blk:	osmanya}', "");
    Expect(0, 66736, '\P{^Is_Blk:	osmanya}', "");
    Expect(1, 66735, '\p{Is_Blk=	OSMANYA}', "");
    Expect(0, 66735, '\p{^Is_Blk=	OSMANYA}', "");
    Expect(0, 66735, '\P{Is_Blk=	OSMANYA}', "");
    Expect(1, 66735, '\P{^Is_Blk=	OSMANYA}', "");
    Expect(0, 66736, '\p{Is_Blk=	OSMANYA}', "");
    Expect(1, 66736, '\p{^Is_Blk=	OSMANYA}', "");
    Expect(1, 66736, '\P{Is_Blk=	OSMANYA}', "");
    Expect(0, 66736, '\P{^Is_Blk=	OSMANYA}', "");
    Error('\p{Block:_pahawh_Hmong/a/}');
    Error('\P{Block:_pahawh_Hmong/a/}');
    Expect(1, 93071, '\p{Block=pahawhhmong}', "");
    Expect(0, 93071, '\p{^Block=pahawhhmong}', "");
    Expect(0, 93071, '\P{Block=pahawhhmong}', "");
    Expect(1, 93071, '\P{^Block=pahawhhmong}', "");
    Expect(0, 93072, '\p{Block=pahawhhmong}', "");
    Expect(1, 93072, '\p{^Block=pahawhhmong}', "");
    Expect(1, 93072, '\P{Block=pahawhhmong}', "");
    Expect(0, 93072, '\P{^Block=pahawhhmong}', "");
    Expect(1, 93071, '\p{Block=--pahawh_Hmong}', "");
    Expect(0, 93071, '\p{^Block=--pahawh_Hmong}', "");
    Expect(0, 93071, '\P{Block=--pahawh_Hmong}', "");
    Expect(1, 93071, '\P{^Block=--pahawh_Hmong}', "");
    Expect(0, 93072, '\p{Block=--pahawh_Hmong}', "");
    Expect(1, 93072, '\p{^Block=--pahawh_Hmong}', "");
    Expect(1, 93072, '\P{Block=--pahawh_Hmong}', "");
    Expect(0, 93072, '\P{^Block=--pahawh_Hmong}', "");
    Error('\p{Blk= /a/PAHAWH_HMONG}');
    Error('\P{Blk= /a/PAHAWH_HMONG}');
    Expect(1, 93071, '\p{Blk=pahawhhmong}', "");
    Expect(0, 93071, '\p{^Blk=pahawhhmong}', "");
    Expect(0, 93071, '\P{Blk=pahawhhmong}', "");
    Expect(1, 93071, '\P{^Blk=pahawhhmong}', "");
    Expect(0, 93072, '\p{Blk=pahawhhmong}', "");
    Expect(1, 93072, '\p{^Blk=pahawhhmong}', "");
    Expect(1, 93072, '\P{Blk=pahawhhmong}', "");
    Expect(0, 93072, '\P{^Blk=pahawhhmong}', "");
    Expect(1, 93071, '\p{Blk: - PAHAWH_hmong}', "");
    Expect(0, 93071, '\p{^Blk: - PAHAWH_hmong}', "");
    Expect(0, 93071, '\P{Blk: - PAHAWH_hmong}', "");
    Expect(1, 93071, '\P{^Blk: - PAHAWH_hmong}', "");
    Expect(0, 93072, '\p{Blk: - PAHAWH_hmong}', "");
    Expect(1, 93072, '\p{^Blk: - PAHAWH_hmong}', "");
    Expect(1, 93072, '\P{Blk: - PAHAWH_hmong}', "");
    Expect(0, 93072, '\P{^Blk: - PAHAWH_hmong}', "");
    Error('\p{Is_Block=:=	 Pahawh_Hmong}');
    Error('\P{Is_Block=:=	 Pahawh_Hmong}');
    Expect(1, 93071, '\p{Is_Block=pahawhhmong}', "");
    Expect(0, 93071, '\p{^Is_Block=pahawhhmong}', "");
    Expect(0, 93071, '\P{Is_Block=pahawhhmong}', "");
    Expect(1, 93071, '\P{^Is_Block=pahawhhmong}', "");
    Expect(0, 93072, '\p{Is_Block=pahawhhmong}', "");
    Expect(1, 93072, '\p{^Is_Block=pahawhhmong}', "");
    Expect(1, 93072, '\P{Is_Block=pahawhhmong}', "");
    Expect(0, 93072, '\P{^Is_Block=pahawhhmong}', "");
    Expect(1, 93071, '\p{Is_Block=_Pahawh_hmong}', "");
    Expect(0, 93071, '\p{^Is_Block=_Pahawh_hmong}', "");
    Expect(0, 93071, '\P{Is_Block=_Pahawh_hmong}', "");
    Expect(1, 93071, '\P{^Is_Block=_Pahawh_hmong}', "");
    Expect(0, 93072, '\p{Is_Block=_Pahawh_hmong}', "");
    Expect(1, 93072, '\p{^Is_Block=_Pahawh_hmong}', "");
    Expect(1, 93072, '\P{Is_Block=_Pahawh_hmong}', "");
    Expect(0, 93072, '\P{^Is_Block=_Pahawh_hmong}', "");
    Error('\p{Is_Blk=		PAHAWH_Hmong:=}');
    Error('\P{Is_Blk=		PAHAWH_Hmong:=}');
    Expect(1, 93071, '\p{Is_Blk=pahawhhmong}', "");
    Expect(0, 93071, '\p{^Is_Blk=pahawhhmong}', "");
    Expect(0, 93071, '\P{Is_Blk=pahawhhmong}', "");
    Expect(1, 93071, '\P{^Is_Blk=pahawhhmong}', "");
    Expect(0, 93072, '\p{Is_Blk=pahawhhmong}', "");
    Expect(1, 93072, '\p{^Is_Blk=pahawhhmong}', "");
    Expect(1, 93072, '\P{Is_Blk=pahawhhmong}', "");
    Expect(0, 93072, '\P{^Is_Blk=pahawhhmong}', "");
    Expect(1, 93071, '\p{Is_Blk=		pahawh_HMONG}', "");
    Expect(0, 93071, '\p{^Is_Blk=		pahawh_HMONG}', "");
    Expect(0, 93071, '\P{Is_Blk=		pahawh_HMONG}', "");
    Expect(1, 93071, '\P{^Is_Blk=		pahawh_HMONG}', "");
    Expect(0, 93072, '\p{Is_Blk=		pahawh_HMONG}', "");
    Expect(1, 93072, '\p{^Is_Blk=		pahawh_HMONG}', "");
    Expect(1, 93072, '\P{Is_Blk=		pahawh_HMONG}', "");
    Expect(0, 93072, '\P{^Is_Blk=		pahawh_HMONG}', "");
    Error('\p{Block=	Palmyrene/a/}');
    Error('\P{Block=	Palmyrene/a/}');
    Expect(1, 67711, '\p{Block:   palmyrene}', "");
    Expect(0, 67711, '\p{^Block:   palmyrene}', "");
    Expect(0, 67711, '\P{Block:   palmyrene}', "");
    Expect(1, 67711, '\P{^Block:   palmyrene}', "");
    Expect(0, 67712, '\p{Block:   palmyrene}', "");
    Expect(1, 67712, '\p{^Block:   palmyrene}', "");
    Expect(1, 67712, '\P{Block:   palmyrene}', "");
    Expect(0, 67712, '\P{^Block:   palmyrene}', "");
    Expect(1, 67711, '\p{Block: 	 Palmyrene}', "");
    Expect(0, 67711, '\p{^Block: 	 Palmyrene}', "");
    Expect(0, 67711, '\P{Block: 	 Palmyrene}', "");
    Expect(1, 67711, '\P{^Block: 	 Palmyrene}', "");
    Expect(0, 67712, '\p{Block: 	 Palmyrene}', "");
    Expect(1, 67712, '\p{^Block: 	 Palmyrene}', "");
    Expect(1, 67712, '\P{Block: 	 Palmyrene}', "");
    Expect(0, 67712, '\P{^Block: 	 Palmyrene}', "");
    Error('\p{Blk=-/a/Palmyrene}');
    Error('\P{Blk=-/a/Palmyrene}');
    Expect(1, 67711, '\p{Blk: palmyrene}', "");
    Expect(0, 67711, '\p{^Blk: palmyrene}', "");
    Expect(0, 67711, '\P{Blk: palmyrene}', "");
    Expect(1, 67711, '\P{^Blk: palmyrene}', "");
    Expect(0, 67712, '\p{Blk: palmyrene}', "");
    Expect(1, 67712, '\p{^Blk: palmyrene}', "");
    Expect(1, 67712, '\P{Blk: palmyrene}', "");
    Expect(0, 67712, '\P{^Blk: palmyrene}', "");
    Expect(1, 67711, '\p{Blk=-_Palmyrene}', "");
    Expect(0, 67711, '\p{^Blk=-_Palmyrene}', "");
    Expect(0, 67711, '\P{Blk=-_Palmyrene}', "");
    Expect(1, 67711, '\P{^Blk=-_Palmyrene}', "");
    Expect(0, 67712, '\p{Blk=-_Palmyrene}', "");
    Expect(1, 67712, '\p{^Blk=-_Palmyrene}', "");
    Expect(1, 67712, '\P{Blk=-_Palmyrene}', "");
    Expect(0, 67712, '\P{^Blk=-_Palmyrene}', "");
    Error('\p{Is_Block=__Palmyrene/a/}');
    Error('\P{Is_Block=__Palmyrene/a/}');
    Expect(1, 67711, '\p{Is_Block=palmyrene}', "");
    Expect(0, 67711, '\p{^Is_Block=palmyrene}', "");
    Expect(0, 67711, '\P{Is_Block=palmyrene}', "");
    Expect(1, 67711, '\P{^Is_Block=palmyrene}', "");
    Expect(0, 67712, '\p{Is_Block=palmyrene}', "");
    Expect(1, 67712, '\p{^Is_Block=palmyrene}', "");
    Expect(1, 67712, '\P{Is_Block=palmyrene}', "");
    Expect(0, 67712, '\P{^Is_Block=palmyrene}', "");
    Expect(1, 67711, '\p{Is_Block=_ Palmyrene}', "");
    Expect(0, 67711, '\p{^Is_Block=_ Palmyrene}', "");
    Expect(0, 67711, '\P{Is_Block=_ Palmyrene}', "");
    Expect(1, 67711, '\P{^Is_Block=_ Palmyrene}', "");
    Expect(0, 67712, '\p{Is_Block=_ Palmyrene}', "");
    Expect(1, 67712, '\p{^Is_Block=_ Palmyrene}', "");
    Expect(1, 67712, '\P{Is_Block=_ Palmyrene}', "");
    Expect(0, 67712, '\P{^Is_Block=_ Palmyrene}', "");
    Error('\p{Is_Blk=_:=Palmyrene}');
    Error('\P{Is_Blk=_:=Palmyrene}');
    Expect(1, 67711, '\p{Is_Blk=palmyrene}', "");
    Expect(0, 67711, '\p{^Is_Blk=palmyrene}', "");
    Expect(0, 67711, '\P{Is_Blk=palmyrene}', "");
    Expect(1, 67711, '\P{^Is_Blk=palmyrene}', "");
    Expect(0, 67712, '\p{Is_Blk=palmyrene}', "");
    Expect(1, 67712, '\p{^Is_Blk=palmyrene}', "");
    Expect(1, 67712, '\P{Is_Blk=palmyrene}', "");
    Expect(0, 67712, '\P{^Is_Blk=palmyrene}', "");
    Expect(1, 67711, '\p{Is_Blk: _ Palmyrene}', "");
    Expect(0, 67711, '\p{^Is_Blk: _ Palmyrene}', "");
    Expect(0, 67711, '\P{Is_Blk: _ Palmyrene}', "");
    Expect(1, 67711, '\P{^Is_Blk: _ Palmyrene}', "");
    Expect(0, 67712, '\p{Is_Blk: _ Palmyrene}', "");
    Expect(1, 67712, '\p{^Is_Blk: _ Palmyrene}', "");
    Expect(1, 67712, '\P{Is_Blk: _ Palmyrene}', "");
    Expect(0, 67712, '\P{^Is_Blk: _ Palmyrene}', "");
    Error('\p{Block= -pau_Cin_Hau/a/}');
    Error('\P{Block= -pau_Cin_Hau/a/}');
    Expect(1, 72447, '\p{Block=paucinhau}', "");
    Expect(0, 72447, '\p{^Block=paucinhau}', "");
    Expect(0, 72447, '\P{Block=paucinhau}', "");
    Expect(1, 72447, '\P{^Block=paucinhau}', "");
    Expect(0, 72448, '\p{Block=paucinhau}', "");
    Expect(1, 72448, '\p{^Block=paucinhau}', "");
    Expect(1, 72448, '\P{Block=paucinhau}', "");
    Expect(0, 72448, '\P{^Block=paucinhau}', "");
    Expect(1, 72447, '\p{Block=__pau_CIN_Hau}', "");
    Expect(0, 72447, '\p{^Block=__pau_CIN_Hau}', "");
    Expect(0, 72447, '\P{Block=__pau_CIN_Hau}', "");
    Expect(1, 72447, '\P{^Block=__pau_CIN_Hau}', "");
    Expect(0, 72448, '\p{Block=__pau_CIN_Hau}', "");
    Expect(1, 72448, '\p{^Block=__pau_CIN_Hau}', "");
    Expect(1, 72448, '\P{Block=__pau_CIN_Hau}', "");
    Expect(0, 72448, '\P{^Block=__pau_CIN_Hau}', "");
    Error('\p{Blk=/a/ pau_CIN_Hau}');
    Error('\P{Blk=/a/ pau_CIN_Hau}');
    Expect(1, 72447, '\p{Blk: paucinhau}', "");
    Expect(0, 72447, '\p{^Blk: paucinhau}', "");
    Expect(0, 72447, '\P{Blk: paucinhau}', "");
    Expect(1, 72447, '\P{^Blk: paucinhau}', "");
    Expect(0, 72448, '\p{Blk: paucinhau}', "");
    Expect(1, 72448, '\p{^Blk: paucinhau}', "");
    Expect(1, 72448, '\P{Blk: paucinhau}', "");
    Expect(0, 72448, '\P{^Blk: paucinhau}', "");
    Expect(1, 72447, '\p{Blk=_pau_cin_Hau}', "");
    Expect(0, 72447, '\p{^Blk=_pau_cin_Hau}', "");
    Expect(0, 72447, '\P{Blk=_pau_cin_Hau}', "");
    Expect(1, 72447, '\P{^Blk=_pau_cin_Hau}', "");
    Expect(0, 72448, '\p{Blk=_pau_cin_Hau}', "");
    Expect(1, 72448, '\p{^Blk=_pau_cin_Hau}', "");
    Expect(1, 72448, '\P{Blk=_pau_cin_Hau}', "");
    Expect(0, 72448, '\P{^Blk=_pau_cin_Hau}', "");
    Error('\p{Is_Block=_:=pau_Cin_Hau}');
    Error('\P{Is_Block=_:=pau_Cin_Hau}');
    Expect(1, 72447, '\p{Is_Block=paucinhau}', "");
    Expect(0, 72447, '\p{^Is_Block=paucinhau}', "");
    Expect(0, 72447, '\P{Is_Block=paucinhau}', "");
    Expect(1, 72447, '\P{^Is_Block=paucinhau}', "");
    Expect(0, 72448, '\p{Is_Block=paucinhau}', "");
    Expect(1, 72448, '\p{^Is_Block=paucinhau}', "");
    Expect(1, 72448, '\P{Is_Block=paucinhau}', "");
    Expect(0, 72448, '\P{^Is_Block=paucinhau}', "");
    Expect(1, 72447, '\p{Is_Block:  Pau_cin_hau}', "");
    Expect(0, 72447, '\p{^Is_Block:  Pau_cin_hau}', "");
    Expect(0, 72447, '\P{Is_Block:  Pau_cin_hau}', "");
    Expect(1, 72447, '\P{^Is_Block:  Pau_cin_hau}', "");
    Expect(0, 72448, '\p{Is_Block:  Pau_cin_hau}', "");
    Expect(1, 72448, '\p{^Is_Block:  Pau_cin_hau}', "");
    Expect(1, 72448, '\P{Is_Block:  Pau_cin_hau}', "");
    Expect(0, 72448, '\P{^Is_Block:  Pau_cin_hau}', "");
    Error('\p{Is_Blk=/a/-_pau_CIN_Hau}');
    Error('\P{Is_Blk=/a/-_pau_CIN_Hau}');
    Expect(1, 72447, '\p{Is_Blk=paucinhau}', "");
    Expect(0, 72447, '\p{^Is_Blk=paucinhau}', "");
    Expect(0, 72447, '\P{Is_Blk=paucinhau}', "");
    Expect(1, 72447, '\P{^Is_Blk=paucinhau}', "");
    Expect(0, 72448, '\p{Is_Blk=paucinhau}', "");
    Expect(1, 72448, '\p{^Is_Blk=paucinhau}', "");
    Expect(1, 72448, '\P{Is_Blk=paucinhau}', "");
    Expect(0, 72448, '\P{^Is_Blk=paucinhau}', "");
    Expect(1, 72447, '\p{Is_Blk=_-pau_Cin_hau}', "");
    Expect(0, 72447, '\p{^Is_Blk=_-pau_Cin_hau}', "");
    Expect(0, 72447, '\P{Is_Blk=_-pau_Cin_hau}', "");
    Expect(1, 72447, '\P{^Is_Blk=_-pau_Cin_hau}', "");
    Expect(0, 72448, '\p{Is_Blk=_-pau_Cin_hau}', "");
    Expect(1, 72448, '\p{^Is_Blk=_-pau_Cin_hau}', "");
    Expect(1, 72448, '\P{Is_Blk=_-pau_Cin_hau}', "");
    Expect(0, 72448, '\P{^Is_Blk=_-pau_Cin_hau}', "");
    Error('\p{Block=	/a/Phags_PA}');
    Error('\P{Block=	/a/Phags_PA}');
    Expect(1, 43135, '\p{Block=phagspa}', "");
    Expect(0, 43135, '\p{^Block=phagspa}', "");
    Expect(0, 43135, '\P{Block=phagspa}', "");
    Expect(1, 43135, '\P{^Block=phagspa}', "");
    Expect(0, 43136, '\p{Block=phagspa}', "");
    Expect(1, 43136, '\p{^Block=phagspa}', "");
    Expect(1, 43136, '\P{Block=phagspa}', "");
    Expect(0, 43136, '\P{^Block=phagspa}', "");
    Expect(1, 43135, '\p{Block=	Phags_PA}', "");
    Expect(0, 43135, '\p{^Block=	Phags_PA}', "");
    Expect(0, 43135, '\P{Block=	Phags_PA}', "");
    Expect(1, 43135, '\P{^Block=	Phags_PA}', "");
    Expect(0, 43136, '\p{Block=	Phags_PA}', "");
    Expect(1, 43136, '\p{^Block=	Phags_PA}', "");
    Expect(1, 43136, '\P{Block=	Phags_PA}', "");
    Expect(0, 43136, '\P{^Block=	Phags_PA}', "");
    Error('\p{Blk=/a/--PHAGS_Pa}');
    Error('\P{Blk=/a/--PHAGS_Pa}');
    Expect(1, 43135, '\p{Blk=phagspa}', "");
    Expect(0, 43135, '\p{^Blk=phagspa}', "");
    Expect(0, 43135, '\P{Blk=phagspa}', "");
    Expect(1, 43135, '\P{^Blk=phagspa}', "");
    Expect(0, 43136, '\p{Blk=phagspa}', "");
    Expect(1, 43136, '\p{^Blk=phagspa}', "");
    Expect(1, 43136, '\P{Blk=phagspa}', "");
    Expect(0, 43136, '\P{^Blk=phagspa}', "");
    Expect(1, 43135, '\p{Blk=_Phags_PA}', "");
    Expect(0, 43135, '\p{^Blk=_Phags_PA}', "");
    Expect(0, 43135, '\P{Blk=_Phags_PA}', "");
    Expect(1, 43135, '\P{^Blk=_Phags_PA}', "");
    Expect(0, 43136, '\p{Blk=_Phags_PA}', "");
    Expect(1, 43136, '\p{^Blk=_Phags_PA}', "");
    Expect(1, 43136, '\P{Blk=_Phags_PA}', "");
    Expect(0, 43136, '\P{^Blk=_Phags_PA}', "");
    Error('\p{Is_Block::=	-PHAGS_Pa}');
    Error('\P{Is_Block::=	-PHAGS_Pa}');
    Expect(1, 43135, '\p{Is_Block=phagspa}', "");
    Expect(0, 43135, '\p{^Is_Block=phagspa}', "");
    Expect(0, 43135, '\P{Is_Block=phagspa}', "");
    Expect(1, 43135, '\P{^Is_Block=phagspa}', "");
    Expect(0, 43136, '\p{Is_Block=phagspa}', "");
    Expect(1, 43136, '\p{^Is_Block=phagspa}', "");
    Expect(1, 43136, '\P{Is_Block=phagspa}', "");
    Expect(0, 43136, '\P{^Is_Block=phagspa}', "");
    Expect(1, 43135, '\p{Is_Block= Phags_PA}', "");
    Expect(0, 43135, '\p{^Is_Block= Phags_PA}', "");
    Expect(0, 43135, '\P{Is_Block= Phags_PA}', "");
    Expect(1, 43135, '\P{^Is_Block= Phags_PA}', "");
    Expect(0, 43136, '\p{Is_Block= Phags_PA}', "");
    Expect(1, 43136, '\p{^Is_Block= Phags_PA}', "");
    Expect(1, 43136, '\P{Is_Block= Phags_PA}', "");
    Expect(0, 43136, '\P{^Is_Block= Phags_PA}', "");
    Error('\p{Is_Blk=:=-	Phags_pa}');
    Error('\P{Is_Blk=:=-	Phags_pa}');
    Expect(1, 43135, '\p{Is_Blk=phagspa}', "");
    Expect(0, 43135, '\p{^Is_Blk=phagspa}', "");
    Expect(0, 43135, '\P{Is_Blk=phagspa}', "");
    Expect(1, 43135, '\P{^Is_Blk=phagspa}', "");
    Expect(0, 43136, '\p{Is_Blk=phagspa}', "");
    Expect(1, 43136, '\p{^Is_Blk=phagspa}', "");
    Expect(1, 43136, '\P{Is_Blk=phagspa}', "");
    Expect(0, 43136, '\P{^Is_Blk=phagspa}', "");
    Expect(1, 43135, '\p{Is_Blk=-	phags_Pa}', "");
    Expect(0, 43135, '\p{^Is_Blk=-	phags_Pa}', "");
    Expect(0, 43135, '\P{Is_Blk=-	phags_Pa}', "");
    Expect(1, 43135, '\P{^Is_Blk=-	phags_Pa}', "");
    Expect(0, 43136, '\p{Is_Blk=-	phags_Pa}', "");
    Expect(1, 43136, '\p{^Is_Blk=-	phags_Pa}', "");
    Expect(1, 43136, '\P{Is_Blk=-	phags_Pa}', "");
    Expect(0, 43136, '\P{^Is_Blk=-	phags_Pa}', "");
    Error('\p{Block=:=_ Phaistos_Disc}');
    Error('\P{Block=:=_ Phaistos_Disc}');
    Expect(1, 66047, '\p{Block=phaistosdisc}', "");
    Expect(0, 66047, '\p{^Block=phaistosdisc}', "");
    Expect(0, 66047, '\P{Block=phaistosdisc}', "");
    Expect(1, 66047, '\P{^Block=phaistosdisc}', "");
    Expect(0, 66048, '\p{Block=phaistosdisc}', "");
    Expect(1, 66048, '\p{^Block=phaistosdisc}', "");
    Expect(1, 66048, '\P{Block=phaistosdisc}', "");
    Expect(0, 66048, '\P{^Block=phaistosdisc}', "");
    Expect(1, 66047, '\p{Block=	phaistos_Disc}', "");
    Expect(0, 66047, '\p{^Block=	phaistos_Disc}', "");
    Expect(0, 66047, '\P{Block=	phaistos_Disc}', "");
    Expect(1, 66047, '\P{^Block=	phaistos_Disc}', "");
    Expect(0, 66048, '\p{Block=	phaistos_Disc}', "");
    Expect(1, 66048, '\p{^Block=	phaistos_Disc}', "");
    Expect(1, 66048, '\P{Block=	phaistos_Disc}', "");
    Expect(0, 66048, '\P{^Block=	phaistos_Disc}', "");
    Error('\p{Blk=-	phaistos:=}');
    Error('\P{Blk=-	phaistos:=}');
    Expect(1, 66047, '\p{Blk=phaistos}', "");
    Expect(0, 66047, '\p{^Blk=phaistos}', "");
    Expect(0, 66047, '\P{Blk=phaistos}', "");
    Expect(1, 66047, '\P{^Blk=phaistos}', "");
    Expect(0, 66048, '\p{Blk=phaistos}', "");
    Expect(1, 66048, '\p{^Blk=phaistos}', "");
    Expect(1, 66048, '\P{Blk=phaistos}', "");
    Expect(0, 66048, '\P{^Blk=phaistos}', "");
    Expect(1, 66047, '\p{Blk=	phaistos}', "");
    Expect(0, 66047, '\p{^Blk=	phaistos}', "");
    Expect(0, 66047, '\P{Blk=	phaistos}', "");
    Expect(1, 66047, '\P{^Blk=	phaistos}', "");
    Expect(0, 66048, '\p{Blk=	phaistos}', "");
    Expect(1, 66048, '\p{^Blk=	phaistos}', "");
    Expect(1, 66048, '\P{Blk=	phaistos}', "");
    Expect(0, 66048, '\P{^Blk=	phaistos}', "");
    Error('\p{Is_Block=_:=Phaistos_Disc}');
    Error('\P{Is_Block=_:=Phaistos_Disc}');
    Expect(1, 66047, '\p{Is_Block=phaistosdisc}', "");
    Expect(0, 66047, '\p{^Is_Block=phaistosdisc}', "");
    Expect(0, 66047, '\P{Is_Block=phaistosdisc}', "");
    Expect(1, 66047, '\P{^Is_Block=phaistosdisc}', "");
    Expect(0, 66048, '\p{Is_Block=phaistosdisc}', "");
    Expect(1, 66048, '\p{^Is_Block=phaistosdisc}', "");
    Expect(1, 66048, '\P{Is_Block=phaistosdisc}', "");
    Expect(0, 66048, '\P{^Is_Block=phaistosdisc}', "");
    Expect(1, 66047, '\p{Is_Block=	phaistos_Disc}', "");
    Expect(0, 66047, '\p{^Is_Block=	phaistos_Disc}', "");
    Expect(0, 66047, '\P{Is_Block=	phaistos_Disc}', "");
    Expect(1, 66047, '\P{^Is_Block=	phaistos_Disc}', "");
    Expect(0, 66048, '\p{Is_Block=	phaistos_Disc}', "");
    Expect(1, 66048, '\p{^Is_Block=	phaistos_Disc}', "");
    Expect(1, 66048, '\P{Is_Block=	phaistos_Disc}', "");
    Expect(0, 66048, '\P{^Is_Block=	phaistos_Disc}', "");
    Error('\p{Is_Blk:	:=	 Phaistos}');
    Error('\P{Is_Blk:	:=	 Phaistos}');
    Expect(1, 66047, '\p{Is_Blk: phaistos}', "");
    Expect(0, 66047, '\p{^Is_Blk: phaistos}', "");
    Expect(0, 66047, '\P{Is_Blk: phaistos}', "");
    Expect(1, 66047, '\P{^Is_Blk: phaistos}', "");
    Expect(0, 66048, '\p{Is_Blk: phaistos}', "");
    Expect(1, 66048, '\p{^Is_Blk: phaistos}', "");
    Expect(1, 66048, '\P{Is_Blk: phaistos}', "");
    Expect(0, 66048, '\P{^Is_Blk: phaistos}', "");
    Expect(1, 66047, '\p{Is_Blk= _phaistos}', "");
    Expect(0, 66047, '\p{^Is_Blk= _phaistos}', "");
    Expect(0, 66047, '\P{Is_Blk= _phaistos}', "");
    Expect(1, 66047, '\P{^Is_Blk= _phaistos}', "");
    Expect(0, 66048, '\p{Is_Blk= _phaistos}', "");
    Expect(1, 66048, '\p{^Is_Blk= _phaistos}', "");
    Expect(1, 66048, '\P{Is_Blk= _phaistos}', "");
    Expect(0, 66048, '\P{^Is_Blk= _phaistos}', "");
    Error('\p{Block=_:=Phoenician}');
    Error('\P{Block=_:=Phoenician}');
    Expect(1, 67871, '\p{Block=phoenician}', "");
    Expect(0, 67871, '\p{^Block=phoenician}', "");
    Expect(0, 67871, '\P{Block=phoenician}', "");
    Expect(1, 67871, '\P{^Block=phoenician}', "");
    Expect(0, 67872, '\p{Block=phoenician}', "");
    Expect(1, 67872, '\p{^Block=phoenician}', "");
    Expect(1, 67872, '\P{Block=phoenician}', "");
    Expect(0, 67872, '\P{^Block=phoenician}', "");
    Expect(1, 67871, '\p{Block=		PHOENICIAN}', "");
    Expect(0, 67871, '\p{^Block=		PHOENICIAN}', "");
    Expect(0, 67871, '\P{Block=		PHOENICIAN}', "");
    Expect(1, 67871, '\P{^Block=		PHOENICIAN}', "");
    Expect(0, 67872, '\p{Block=		PHOENICIAN}', "");
    Expect(1, 67872, '\p{^Block=		PHOENICIAN}', "");
    Expect(1, 67872, '\P{Block=		PHOENICIAN}', "");
    Expect(0, 67872, '\P{^Block=		PHOENICIAN}', "");
    Error('\p{Blk=	:=phoenician}');
    Error('\P{Blk=	:=phoenician}');
    Expect(1, 67871, '\p{Blk=phoenician}', "");
    Expect(0, 67871, '\p{^Blk=phoenician}', "");
    Expect(0, 67871, '\P{Blk=phoenician}', "");
    Expect(1, 67871, '\P{^Blk=phoenician}', "");
    Expect(0, 67872, '\p{Blk=phoenician}', "");
    Expect(1, 67872, '\p{^Blk=phoenician}', "");
    Expect(1, 67872, '\P{Blk=phoenician}', "");
    Expect(0, 67872, '\P{^Blk=phoenician}', "");
    Expect(1, 67871, '\p{Blk=_PHOENICIAN}', "");
    Expect(0, 67871, '\p{^Blk=_PHOENICIAN}', "");
    Expect(0, 67871, '\P{Blk=_PHOENICIAN}', "");
    Expect(1, 67871, '\P{^Blk=_PHOENICIAN}', "");
    Expect(0, 67872, '\p{Blk=_PHOENICIAN}', "");
    Expect(1, 67872, '\p{^Blk=_PHOENICIAN}', "");
    Expect(1, 67872, '\P{Blk=_PHOENICIAN}', "");
    Expect(0, 67872, '\P{^Blk=_PHOENICIAN}', "");
    Error('\p{Is_Block=-	phoenician/a/}');
    Error('\P{Is_Block=-	phoenician/a/}');
    Expect(1, 67871, '\p{Is_Block=phoenician}', "");
    Expect(0, 67871, '\p{^Is_Block=phoenician}', "");
    Expect(0, 67871, '\P{Is_Block=phoenician}', "");
    Expect(1, 67871, '\P{^Is_Block=phoenician}', "");
    Expect(0, 67872, '\p{Is_Block=phoenician}', "");
    Expect(1, 67872, '\p{^Is_Block=phoenician}', "");
    Expect(1, 67872, '\P{Is_Block=phoenician}', "");
    Expect(0, 67872, '\P{^Is_Block=phoenician}', "");
    Expect(1, 67871, '\p{Is_Block=	Phoenician}', "");
    Expect(0, 67871, '\p{^Is_Block=	Phoenician}', "");
    Expect(0, 67871, '\P{Is_Block=	Phoenician}', "");
    Expect(1, 67871, '\P{^Is_Block=	Phoenician}', "");
    Expect(0, 67872, '\p{Is_Block=	Phoenician}', "");
    Expect(1, 67872, '\p{^Is_Block=	Phoenician}', "");
    Expect(1, 67872, '\P{Is_Block=	Phoenician}', "");
    Expect(0, 67872, '\P{^Is_Block=	Phoenician}', "");
    Error('\p{Is_Blk=__Phoenician:=}');
    Error('\P{Is_Blk=__Phoenician:=}');
    Expect(1, 67871, '\p{Is_Blk=phoenician}', "");
    Expect(0, 67871, '\p{^Is_Blk=phoenician}', "");
    Expect(0, 67871, '\P{Is_Blk=phoenician}', "");
    Expect(1, 67871, '\P{^Is_Blk=phoenician}', "");
    Expect(0, 67872, '\p{Is_Blk=phoenician}', "");
    Expect(1, 67872, '\p{^Is_Blk=phoenician}', "");
    Expect(1, 67872, '\P{Is_Blk=phoenician}', "");
    Expect(0, 67872, '\P{^Is_Blk=phoenician}', "");
    Expect(1, 67871, '\p{Is_Blk:   	Phoenician}', "");
    Expect(0, 67871, '\p{^Is_Blk:   	Phoenician}', "");
    Expect(0, 67871, '\P{Is_Blk:   	Phoenician}', "");
    Expect(1, 67871, '\P{^Is_Blk:   	Phoenician}', "");
    Expect(0, 67872, '\p{Is_Blk:   	Phoenician}', "");
    Expect(1, 67872, '\p{^Is_Blk:   	Phoenician}', "");
    Expect(1, 67872, '\P{Is_Blk:   	Phoenician}', "");
    Expect(0, 67872, '\P{^Is_Blk:   	Phoenician}', "");
    Error('\p{Block:	:=Phonetic_extensions}');
    Error('\P{Block:	:=Phonetic_extensions}');
    Expect(1, 7551, '\p{Block=phoneticextensions}', "");
    Expect(0, 7551, '\p{^Block=phoneticextensions}', "");
    Expect(0, 7551, '\P{Block=phoneticextensions}', "");
    Expect(1, 7551, '\P{^Block=phoneticextensions}', "");
    Expect(0, 7552, '\p{Block=phoneticextensions}', "");
    Expect(1, 7552, '\p{^Block=phoneticextensions}', "");
    Expect(1, 7552, '\P{Block=phoneticextensions}', "");
    Expect(0, 7552, '\P{^Block=phoneticextensions}', "");
    Expect(1, 7551, '\p{Block: phonetic_EXTENSIONS}', "");
    Expect(0, 7551, '\p{^Block: phonetic_EXTENSIONS}', "");
    Expect(0, 7551, '\P{Block: phonetic_EXTENSIONS}', "");
    Expect(1, 7551, '\P{^Block: phonetic_EXTENSIONS}', "");
    Expect(0, 7552, '\p{Block: phonetic_EXTENSIONS}', "");
    Expect(1, 7552, '\p{^Block: phonetic_EXTENSIONS}', "");
    Expect(1, 7552, '\P{Block: phonetic_EXTENSIONS}', "");
    Expect(0, 7552, '\P{^Block: phonetic_EXTENSIONS}', "");
    Error('\p{Blk=	 phonetic_Ext/a/}');
    Error('\P{Blk=	 phonetic_Ext/a/}');
    Expect(1, 7551, '\p{Blk=phoneticext}', "");
    Expect(0, 7551, '\p{^Blk=phoneticext}', "");
    Expect(0, 7551, '\P{Blk=phoneticext}', "");
    Expect(1, 7551, '\P{^Blk=phoneticext}', "");
    Expect(0, 7552, '\p{Blk=phoneticext}', "");
    Expect(1, 7552, '\p{^Blk=phoneticext}', "");
    Expect(1, 7552, '\P{Blk=phoneticext}', "");
    Expect(0, 7552, '\P{^Blk=phoneticext}', "");
    Expect(1, 7551, '\p{Blk= PHONETIC_ext}', "");
    Expect(0, 7551, '\p{^Blk= PHONETIC_ext}', "");
    Expect(0, 7551, '\P{Blk= PHONETIC_ext}', "");
    Expect(1, 7551, '\P{^Blk= PHONETIC_ext}', "");
    Expect(0, 7552, '\p{Blk= PHONETIC_ext}', "");
    Expect(1, 7552, '\p{^Blk= PHONETIC_ext}', "");
    Expect(1, 7552, '\P{Blk= PHONETIC_ext}', "");
    Expect(0, 7552, '\P{^Blk= PHONETIC_ext}', "");
    Error('\p{Is_Block= /a/phonetic_EXTENSIONS}');
    Error('\P{Is_Block= /a/phonetic_EXTENSIONS}');
    Expect(1, 7551, '\p{Is_Block=phoneticextensions}', "");
    Expect(0, 7551, '\p{^Is_Block=phoneticextensions}', "");
    Expect(0, 7551, '\P{Is_Block=phoneticextensions}', "");
    Expect(1, 7551, '\P{^Is_Block=phoneticextensions}', "");
    Expect(0, 7552, '\p{Is_Block=phoneticextensions}', "");
    Expect(1, 7552, '\p{^Is_Block=phoneticextensions}', "");
    Expect(1, 7552, '\P{Is_Block=phoneticextensions}', "");
    Expect(0, 7552, '\P{^Is_Block=phoneticextensions}', "");
    Expect(1, 7551, '\p{Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(0, 7551, '\p{^Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(0, 7551, '\P{Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(1, 7551, '\P{^Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(0, 7552, '\p{Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(1, 7552, '\p{^Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(1, 7552, '\P{Is_Block=  phonetic_EXTENSIONS}', "");
    Expect(0, 7552, '\P{^Is_Block=  phonetic_EXTENSIONS}', "");
    Error('\p{Is_Blk=/a/ -PHONETIC_Ext}');
    Error('\P{Is_Blk=/a/ -PHONETIC_Ext}');
    Expect(1, 7551, '\p{Is_Blk=phoneticext}', "");
    Expect(0, 7551, '\p{^Is_Blk=phoneticext}', "");
    Expect(0, 7551, '\P{Is_Blk=phoneticext}', "");
    Expect(1, 7551, '\P{^Is_Blk=phoneticext}', "");
    Expect(0, 7552, '\p{Is_Blk=phoneticext}', "");
    Expect(1, 7552, '\p{^Is_Blk=phoneticext}', "");
    Expect(1, 7552, '\P{Is_Blk=phoneticext}', "");
    Expect(0, 7552, '\P{^Is_Blk=phoneticext}', "");
    Expect(1, 7551, '\p{Is_Blk=-Phonetic_Ext}', "");
    Expect(0, 7551, '\p{^Is_Blk=-Phonetic_Ext}', "");
    Expect(0, 7551, '\P{Is_Blk=-Phonetic_Ext}', "");
    Expect(1, 7551, '\P{^Is_Blk=-Phonetic_Ext}', "");
    Expect(0, 7552, '\p{Is_Blk=-Phonetic_Ext}', "");
    Expect(1, 7552, '\p{^Is_Blk=-Phonetic_Ext}', "");
    Expect(1, 7552, '\P{Is_Blk=-Phonetic_Ext}', "");
    Expect(0, 7552, '\P{^Is_Blk=-Phonetic_Ext}', "");
    Error('\p{Block=	 Phonetic_Extensions_Supplement/a/}');
    Error('\P{Block=	 Phonetic_Extensions_Supplement/a/}');
    Expect(1, 7615, '\p{Block=phoneticextensionssupplement}', "");
    Expect(0, 7615, '\p{^Block=phoneticextensionssupplement}', "");
    Expect(0, 7615, '\P{Block=phoneticextensionssupplement}', "");
    Expect(1, 7615, '\P{^Block=phoneticextensionssupplement}', "");
    Expect(0, 7616, '\p{Block=phoneticextensionssupplement}', "");
    Expect(1, 7616, '\p{^Block=phoneticextensionssupplement}', "");
    Expect(1, 7616, '\P{Block=phoneticextensionssupplement}', "");
    Expect(0, 7616, '\P{^Block=phoneticextensionssupplement}', "");
    Expect(1, 7615, '\p{Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(0, 7615, '\p{^Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(0, 7615, '\P{Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(1, 7615, '\P{^Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(0, 7616, '\p{Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(1, 7616, '\p{^Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(1, 7616, '\P{Block=-	PHONETIC_Extensions_supplement}', "");
    Expect(0, 7616, '\P{^Block=-	PHONETIC_Extensions_supplement}', "");
    Error('\p{Blk=/a/-	PHONETIC_ext_Sup}');
    Error('\P{Blk=/a/-	PHONETIC_ext_Sup}');
    Expect(1, 7615, '\p{Blk=phoneticextsup}', "");
    Expect(0, 7615, '\p{^Blk=phoneticextsup}', "");
    Expect(0, 7615, '\P{Blk=phoneticextsup}', "");
    Expect(1, 7615, '\P{^Blk=phoneticextsup}', "");
    Expect(0, 7616, '\p{Blk=phoneticextsup}', "");
    Expect(1, 7616, '\p{^Blk=phoneticextsup}', "");
    Expect(1, 7616, '\P{Blk=phoneticextsup}', "");
    Expect(0, 7616, '\P{^Blk=phoneticextsup}', "");
    Expect(1, 7615, '\p{Blk=	Phonetic_Ext_sup}', "");
    Expect(0, 7615, '\p{^Blk=	Phonetic_Ext_sup}', "");
    Expect(0, 7615, '\P{Blk=	Phonetic_Ext_sup}', "");
    Expect(1, 7615, '\P{^Blk=	Phonetic_Ext_sup}', "");
    Expect(0, 7616, '\p{Blk=	Phonetic_Ext_sup}', "");
    Expect(1, 7616, '\p{^Blk=	Phonetic_Ext_sup}', "");
    Expect(1, 7616, '\P{Blk=	Phonetic_Ext_sup}', "");
    Expect(0, 7616, '\P{^Blk=	Phonetic_Ext_sup}', "");
    Error('\p{Is_Block: 	:=Phonetic_Extensions_Supplement}');
    Error('\P{Is_Block: 	:=Phonetic_Extensions_Supplement}');
    Expect(1, 7615, '\p{Is_Block=phoneticextensionssupplement}', "");
    Expect(0, 7615, '\p{^Is_Block=phoneticextensionssupplement}', "");
    Expect(0, 7615, '\P{Is_Block=phoneticextensionssupplement}', "");
    Expect(1, 7615, '\P{^Is_Block=phoneticextensionssupplement}', "");
    Expect(0, 7616, '\p{Is_Block=phoneticextensionssupplement}', "");
    Expect(1, 7616, '\p{^Is_Block=phoneticextensionssupplement}', "");
    Expect(1, 7616, '\P{Is_Block=phoneticextensionssupplement}', "");
    Expect(0, 7616, '\P{^Is_Block=phoneticextensionssupplement}', "");
    Expect(1, 7615, '\p{Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(0, 7615, '\p{^Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(0, 7615, '\P{Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(1, 7615, '\P{^Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(0, 7616, '\p{Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(1, 7616, '\p{^Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(1, 7616, '\P{Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Expect(0, 7616, '\P{^Is_Block=__Phonetic_EXTENSIONS_Supplement}', "");
    Error('\p{Is_Blk=	:=PHONETIC_Ext_Sup}');
    Error('\P{Is_Blk=	:=PHONETIC_Ext_Sup}');
    Expect(1, 7615, '\p{Is_Blk=phoneticextsup}', "");
    Expect(0, 7615, '\p{^Is_Blk=phoneticextsup}', "");
    Expect(0, 7615, '\P{Is_Blk=phoneticextsup}', "");
    Expect(1, 7615, '\P{^Is_Blk=phoneticextsup}', "");
    Expect(0, 7616, '\p{Is_Blk=phoneticextsup}', "");
    Expect(1, 7616, '\p{^Is_Blk=phoneticextsup}', "");
    Expect(1, 7616, '\P{Is_Blk=phoneticextsup}', "");
    Expect(0, 7616, '\P{^Is_Blk=phoneticextsup}', "");
    Expect(1, 7615, '\p{Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(0, 7615, '\p{^Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(0, 7615, '\P{Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(1, 7615, '\P{^Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(0, 7616, '\p{Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(1, 7616, '\p{^Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(1, 7616, '\P{Is_Blk=- phonetic_Ext_Sup}', "");
    Expect(0, 7616, '\P{^Is_Blk=- phonetic_Ext_Sup}', "");
    Error('\p{Block=	_playing_Cards/a/}');
    Error('\P{Block=	_playing_Cards/a/}');
    Expect(1, 127231, '\p{Block=playingcards}', "");
    Expect(0, 127231, '\p{^Block=playingcards}', "");
    Expect(0, 127231, '\P{Block=playingcards}', "");
    Expect(1, 127231, '\P{^Block=playingcards}', "");
    Expect(0, 127232, '\p{Block=playingcards}', "");
    Expect(1, 127232, '\p{^Block=playingcards}', "");
    Expect(1, 127232, '\P{Block=playingcards}', "");
    Expect(0, 127232, '\P{^Block=playingcards}', "");
    Expect(1, 127231, '\p{Block=		Playing_Cards}', "");
    Expect(0, 127231, '\p{^Block=		Playing_Cards}', "");
    Expect(0, 127231, '\P{Block=		Playing_Cards}', "");
    Expect(1, 127231, '\P{^Block=		Playing_Cards}', "");
    Expect(0, 127232, '\p{Block=		Playing_Cards}', "");
    Expect(1, 127232, '\p{^Block=		Playing_Cards}', "");
    Expect(1, 127232, '\P{Block=		Playing_Cards}', "");
    Expect(0, 127232, '\P{^Block=		Playing_Cards}', "");
    Error('\p{Blk=_:=PLAYING_CARDS}');
    Error('\P{Blk=_:=PLAYING_CARDS}');
    Expect(1, 127231, '\p{Blk=playingcards}', "");
    Expect(0, 127231, '\p{^Blk=playingcards}', "");
    Expect(0, 127231, '\P{Blk=playingcards}', "");
    Expect(1, 127231, '\P{^Blk=playingcards}', "");
    Expect(0, 127232, '\p{Blk=playingcards}', "");
    Expect(1, 127232, '\p{^Blk=playingcards}', "");
    Expect(1, 127232, '\P{Blk=playingcards}', "");
    Expect(0, 127232, '\P{^Blk=playingcards}', "");
    Expect(1, 127231, '\p{Blk=_-PLAYING_Cards}', "");
    Expect(0, 127231, '\p{^Blk=_-PLAYING_Cards}', "");
    Expect(0, 127231, '\P{Blk=_-PLAYING_Cards}', "");
    Expect(1, 127231, '\P{^Blk=_-PLAYING_Cards}', "");
    Expect(0, 127232, '\p{Blk=_-PLAYING_Cards}', "");
    Expect(1, 127232, '\p{^Blk=_-PLAYING_Cards}', "");
    Expect(1, 127232, '\P{Blk=_-PLAYING_Cards}', "");
    Expect(0, 127232, '\P{^Blk=_-PLAYING_Cards}', "");
    Error('\p{Is_Block=	-Playing_cards:=}');
    Error('\P{Is_Block=	-Playing_cards:=}');
    Expect(1, 127231, '\p{Is_Block=playingcards}', "");
    Expect(0, 127231, '\p{^Is_Block=playingcards}', "");
    Expect(0, 127231, '\P{Is_Block=playingcards}', "");
    Expect(1, 127231, '\P{^Is_Block=playingcards}', "");
    Expect(0, 127232, '\p{Is_Block=playingcards}', "");
    Expect(1, 127232, '\p{^Is_Block=playingcards}', "");
    Expect(1, 127232, '\P{Is_Block=playingcards}', "");
    Expect(0, 127232, '\P{^Is_Block=playingcards}', "");
    Expect(1, 127231, '\p{Is_Block=_Playing_cards}', "");
    Expect(0, 127231, '\p{^Is_Block=_Playing_cards}', "");
    Expect(0, 127231, '\P{Is_Block=_Playing_cards}', "");
    Expect(1, 127231, '\P{^Is_Block=_Playing_cards}', "");
    Expect(0, 127232, '\p{Is_Block=_Playing_cards}', "");
    Expect(1, 127232, '\p{^Is_Block=_Playing_cards}', "");
    Expect(1, 127232, '\P{Is_Block=_Playing_cards}', "");
    Expect(0, 127232, '\P{^Is_Block=_Playing_cards}', "");
    Error('\p{Is_Blk=-:=playing_cards}');
    Error('\P{Is_Blk=-:=playing_cards}');
    Expect(1, 127231, '\p{Is_Blk:   playingcards}', "");
    Expect(0, 127231, '\p{^Is_Blk:   playingcards}', "");
    Expect(0, 127231, '\P{Is_Blk:   playingcards}', "");
    Expect(1, 127231, '\P{^Is_Blk:   playingcards}', "");
    Expect(0, 127232, '\p{Is_Blk:   playingcards}', "");
    Expect(1, 127232, '\p{^Is_Blk:   playingcards}', "");
    Expect(1, 127232, '\P{Is_Blk:   playingcards}', "");
    Expect(0, 127232, '\P{^Is_Blk:   playingcards}', "");
    Expect(1, 127231, '\p{Is_Blk= Playing_CARDS}', "");
    Expect(0, 127231, '\p{^Is_Blk= Playing_CARDS}', "");
    Expect(0, 127231, '\P{Is_Blk= Playing_CARDS}', "");
    Expect(1, 127231, '\P{^Is_Blk= Playing_CARDS}', "");
    Expect(0, 127232, '\p{Is_Blk= Playing_CARDS}', "");
    Expect(1, 127232, '\p{^Is_Blk= Playing_CARDS}', "");
    Expect(1, 127232, '\P{Is_Blk= Playing_CARDS}', "");
    Expect(0, 127232, '\P{^Is_Blk= Playing_CARDS}', "");
    Error('\p{Block=/a/	PSALTER_pahlavi}');
    Error('\P{Block=/a/	PSALTER_pahlavi}');
    Expect(1, 68527, '\p{Block=psalterpahlavi}', "");
    Expect(0, 68527, '\p{^Block=psalterpahlavi}', "");
    Expect(0, 68527, '\P{Block=psalterpahlavi}', "");
    Expect(1, 68527, '\P{^Block=psalterpahlavi}', "");
    Expect(0, 68528, '\p{Block=psalterpahlavi}', "");
    Expect(1, 68528, '\p{^Block=psalterpahlavi}', "");
    Expect(1, 68528, '\P{Block=psalterpahlavi}', "");
    Expect(0, 68528, '\P{^Block=psalterpahlavi}', "");
    Expect(1, 68527, '\p{Block=- psalter_pahlavi}', "");
    Expect(0, 68527, '\p{^Block=- psalter_pahlavi}', "");
    Expect(0, 68527, '\P{Block=- psalter_pahlavi}', "");
    Expect(1, 68527, '\P{^Block=- psalter_pahlavi}', "");
    Expect(0, 68528, '\p{Block=- psalter_pahlavi}', "");
    Expect(1, 68528, '\p{^Block=- psalter_pahlavi}', "");
    Expect(1, 68528, '\P{Block=- psalter_pahlavi}', "");
    Expect(0, 68528, '\P{^Block=- psalter_pahlavi}', "");
    Error('\p{Blk=/a/Psalter_Pahlavi}');
    Error('\P{Blk=/a/Psalter_Pahlavi}');
    Expect(1, 68527, '\p{Blk=psalterpahlavi}', "");
    Expect(0, 68527, '\p{^Blk=psalterpahlavi}', "");
    Expect(0, 68527, '\P{Blk=psalterpahlavi}', "");
    Expect(1, 68527, '\P{^Blk=psalterpahlavi}', "");
    Expect(0, 68528, '\p{Blk=psalterpahlavi}', "");
    Expect(1, 68528, '\p{^Blk=psalterpahlavi}', "");
    Expect(1, 68528, '\P{Blk=psalterpahlavi}', "");
    Expect(0, 68528, '\P{^Blk=psalterpahlavi}', "");
    Expect(1, 68527, '\p{Blk=_Psalter_PAHLAVI}', "");
    Expect(0, 68527, '\p{^Blk=_Psalter_PAHLAVI}', "");
    Expect(0, 68527, '\P{Blk=_Psalter_PAHLAVI}', "");
    Expect(1, 68527, '\P{^Blk=_Psalter_PAHLAVI}', "");
    Expect(0, 68528, '\p{Blk=_Psalter_PAHLAVI}', "");
    Expect(1, 68528, '\p{^Blk=_Psalter_PAHLAVI}', "");
    Expect(1, 68528, '\P{Blk=_Psalter_PAHLAVI}', "");
    Expect(0, 68528, '\P{^Blk=_Psalter_PAHLAVI}', "");
    Error('\p{Is_Block=/a/  PSALTER_PAHLAVI}');
    Error('\P{Is_Block=/a/  PSALTER_PAHLAVI}');
    Expect(1, 68527, '\p{Is_Block=psalterpahlavi}', "");
    Expect(0, 68527, '\p{^Is_Block=psalterpahlavi}', "");
    Expect(0, 68527, '\P{Is_Block=psalterpahlavi}', "");
    Expect(1, 68527, '\P{^Is_Block=psalterpahlavi}', "");
    Expect(0, 68528, '\p{Is_Block=psalterpahlavi}', "");
    Expect(1, 68528, '\p{^Is_Block=psalterpahlavi}', "");
    Expect(1, 68528, '\P{Is_Block=psalterpahlavi}', "");
    Expect(0, 68528, '\P{^Is_Block=psalterpahlavi}', "");
    Expect(1, 68527, '\p{Is_Block=_PSALTER_Pahlavi}', "");
    Expect(0, 68527, '\p{^Is_Block=_PSALTER_Pahlavi}', "");
    Expect(0, 68527, '\P{Is_Block=_PSALTER_Pahlavi}', "");
    Expect(1, 68527, '\P{^Is_Block=_PSALTER_Pahlavi}', "");
    Expect(0, 68528, '\p{Is_Block=_PSALTER_Pahlavi}', "");
    Expect(1, 68528, '\p{^Is_Block=_PSALTER_Pahlavi}', "");
    Expect(1, 68528, '\P{Is_Block=_PSALTER_Pahlavi}', "");
    Expect(0, 68528, '\P{^Is_Block=_PSALTER_Pahlavi}', "");
    Error('\p{Is_Blk=_/a/PSALTER_PAHLAVI}');
    Error('\P{Is_Blk=_/a/PSALTER_PAHLAVI}');
    Expect(1, 68527, '\p{Is_Blk=psalterpahlavi}', "");
    Expect(0, 68527, '\p{^Is_Blk=psalterpahlavi}', "");
    Expect(0, 68527, '\P{Is_Blk=psalterpahlavi}', "");
    Expect(1, 68527, '\P{^Is_Blk=psalterpahlavi}', "");
    Expect(0, 68528, '\p{Is_Blk=psalterpahlavi}', "");
    Expect(1, 68528, '\p{^Is_Blk=psalterpahlavi}', "");
    Expect(1, 68528, '\P{Is_Blk=psalterpahlavi}', "");
    Expect(0, 68528, '\P{^Is_Blk=psalterpahlavi}', "");
    Expect(1, 68527, '\p{Is_Blk=-Psalter_Pahlavi}', "");
    Expect(0, 68527, '\p{^Is_Blk=-Psalter_Pahlavi}', "");
    Expect(0, 68527, '\P{Is_Blk=-Psalter_Pahlavi}', "");
    Expect(1, 68527, '\P{^Is_Blk=-Psalter_Pahlavi}', "");
    Expect(0, 68528, '\p{Is_Blk=-Psalter_Pahlavi}', "");
    Expect(1, 68528, '\p{^Is_Blk=-Psalter_Pahlavi}', "");
    Expect(1, 68528, '\P{Is_Blk=-Psalter_Pahlavi}', "");
    Expect(0, 68528, '\P{^Is_Blk=-Psalter_Pahlavi}', "");
    Error('\p{Block=/a/--Private_USE_AREA}');
    Error('\P{Block=/a/--Private_USE_AREA}');
    Expect(1, 63743, '\p{Block=privateusearea}', "");
    Expect(0, 63743, '\p{^Block=privateusearea}', "");
    Expect(0, 63743, '\P{Block=privateusearea}', "");
    Expect(1, 63743, '\P{^Block=privateusearea}', "");
    Expect(0, 63744, '\p{Block=privateusearea}', "");
    Expect(1, 63744, '\p{^Block=privateusearea}', "");
    Expect(1, 63744, '\P{Block=privateusearea}', "");
    Expect(0, 63744, '\P{^Block=privateusearea}', "");
    Expect(1, 63743, '\p{Block=  PRIVATE_use_Area}', "");
    Expect(0, 63743, '\p{^Block=  PRIVATE_use_Area}', "");
    Expect(0, 63743, '\P{Block=  PRIVATE_use_Area}', "");
    Expect(1, 63743, '\P{^Block=  PRIVATE_use_Area}', "");
    Expect(0, 63744, '\p{Block=  PRIVATE_use_Area}', "");
    Expect(1, 63744, '\p{^Block=  PRIVATE_use_Area}', "");
    Expect(1, 63744, '\P{Block=  PRIVATE_use_Area}', "");
    Expect(0, 63744, '\P{^Block=  PRIVATE_use_Area}', "");
    Error('\p{Blk:	_	pua:=}');
    Error('\P{Blk:	_	pua:=}');
    Expect(1, 63743, '\p{Blk=pua}', "");
    Expect(0, 63743, '\p{^Blk=pua}', "");
    Expect(0, 63743, '\P{Blk=pua}', "");
    Expect(1, 63743, '\P{^Blk=pua}', "");
    Expect(0, 63744, '\p{Blk=pua}', "");
    Expect(1, 63744, '\p{^Blk=pua}', "");
    Expect(1, 63744, '\P{Blk=pua}', "");
    Expect(0, 63744, '\P{^Blk=pua}', "");
    Expect(1, 63743, '\p{Blk= _pua}', "");
    Expect(0, 63743, '\p{^Blk= _pua}', "");
    Expect(0, 63743, '\P{Blk= _pua}', "");
    Expect(1, 63743, '\P{^Blk= _pua}', "");
    Expect(0, 63744, '\p{Blk= _pua}', "");
    Expect(1, 63744, '\p{^Blk= _pua}', "");
    Expect(1, 63744, '\P{Blk= _pua}', "");
    Expect(0, 63744, '\P{^Blk= _pua}', "");
    Error('\p{Is_Block=:=	 Private_use}');
    Error('\P{Is_Block=:=	 Private_use}');
    Expect(1, 63743, '\p{Is_Block=privateuse}', "");
    Expect(0, 63743, '\p{^Is_Block=privateuse}', "");
    Expect(0, 63743, '\P{Is_Block=privateuse}', "");
    Expect(1, 63743, '\P{^Is_Block=privateuse}', "");
    Expect(0, 63744, '\p{Is_Block=privateuse}', "");
    Expect(1, 63744, '\p{^Is_Block=privateuse}', "");
    Expect(1, 63744, '\P{Is_Block=privateuse}', "");
    Expect(0, 63744, '\P{^Is_Block=privateuse}', "");
    Expect(1, 63743, '\p{Is_Block=	_Private_use}', "");
    Expect(0, 63743, '\p{^Is_Block=	_Private_use}', "");
    Expect(0, 63743, '\P{Is_Block=	_Private_use}', "");
    Expect(1, 63743, '\P{^Is_Block=	_Private_use}', "");
    Expect(0, 63744, '\p{Is_Block=	_Private_use}', "");
    Expect(1, 63744, '\p{^Is_Block=	_Private_use}', "");
    Expect(1, 63744, '\P{Is_Block=	_Private_use}', "");
    Expect(0, 63744, '\P{^Is_Block=	_Private_use}', "");
    Error('\p{Is_Blk= :=Private_Use_Area}');
    Error('\P{Is_Blk= :=Private_Use_Area}');
    Expect(1, 63743, '\p{Is_Blk=privateusearea}', "");
    Expect(0, 63743, '\p{^Is_Blk=privateusearea}', "");
    Expect(0, 63743, '\P{Is_Blk=privateusearea}', "");
    Expect(1, 63743, '\P{^Is_Blk=privateusearea}', "");
    Expect(0, 63744, '\p{Is_Blk=privateusearea}', "");
    Expect(1, 63744, '\p{^Is_Blk=privateusearea}', "");
    Expect(1, 63744, '\P{Is_Blk=privateusearea}', "");
    Expect(0, 63744, '\P{^Is_Blk=privateusearea}', "");
    Expect(1, 63743, '\p{Is_Blk=	 Private_USE_Area}', "");
    Expect(0, 63743, '\p{^Is_Blk=	 Private_USE_Area}', "");
    Expect(0, 63743, '\P{Is_Blk=	 Private_USE_Area}', "");
    Expect(1, 63743, '\P{^Is_Blk=	 Private_USE_Area}', "");
    Expect(0, 63744, '\p{Is_Blk=	 Private_USE_Area}', "");
    Expect(1, 63744, '\p{^Is_Blk=	 Private_USE_Area}', "");
    Expect(1, 63744, '\P{Is_Blk=	 Private_USE_Area}', "");
    Expect(0, 63744, '\P{^Is_Blk=	 Private_USE_Area}', "");
    Error('\p{Block=:=-General_PUNCTUATION}');
    Error('\P{Block=:=-General_PUNCTUATION}');
    Expect(1, 8303, '\p{Block=generalpunctuation}', "");
    Expect(0, 8303, '\p{^Block=generalpunctuation}', "");
    Expect(0, 8303, '\P{Block=generalpunctuation}', "");
    Expect(1, 8303, '\P{^Block=generalpunctuation}', "");
    Expect(0, 8304, '\p{Block=generalpunctuation}', "");
    Expect(1, 8304, '\p{^Block=generalpunctuation}', "");
    Expect(1, 8304, '\P{Block=generalpunctuation}', "");
    Expect(0, 8304, '\P{^Block=generalpunctuation}', "");
    Expect(1, 8303, '\p{Block=	-GENERAL_Punctuation}', "");
    Expect(0, 8303, '\p{^Block=	-GENERAL_Punctuation}', "");
    Expect(0, 8303, '\P{Block=	-GENERAL_Punctuation}', "");
    Expect(1, 8303, '\P{^Block=	-GENERAL_Punctuation}', "");
    Expect(0, 8304, '\p{Block=	-GENERAL_Punctuation}', "");
    Expect(1, 8304, '\p{^Block=	-GENERAL_Punctuation}', "");
    Expect(1, 8304, '\P{Block=	-GENERAL_Punctuation}', "");
    Expect(0, 8304, '\P{^Block=	-GENERAL_Punctuation}', "");
    Error('\p{Blk=/a/	-Punctuation}');
    Error('\P{Blk=/a/	-Punctuation}');
    Expect(1, 8303, '\p{Blk=punctuation}', "");
    Expect(0, 8303, '\p{^Blk=punctuation}', "");
    Expect(0, 8303, '\P{Blk=punctuation}', "");
    Expect(1, 8303, '\P{^Blk=punctuation}', "");
    Expect(0, 8304, '\p{Blk=punctuation}', "");
    Expect(1, 8304, '\p{^Blk=punctuation}', "");
    Expect(1, 8304, '\P{Blk=punctuation}', "");
    Expect(0, 8304, '\P{^Blk=punctuation}', "");
    Expect(1, 8303, '\p{Blk:	PUNCTUATION}', "");
    Expect(0, 8303, '\p{^Blk:	PUNCTUATION}', "");
    Expect(0, 8303, '\P{Blk:	PUNCTUATION}', "");
    Expect(1, 8303, '\P{^Blk:	PUNCTUATION}', "");
    Expect(0, 8304, '\p{Blk:	PUNCTUATION}', "");
    Expect(1, 8304, '\p{^Blk:	PUNCTUATION}', "");
    Expect(1, 8304, '\P{Blk:	PUNCTUATION}', "");
    Expect(0, 8304, '\P{^Blk:	PUNCTUATION}', "");
    Error('\p{Is_Block:   	:=General_Punctuation}');
    Error('\P{Is_Block:   	:=General_Punctuation}');
    Expect(1, 8303, '\p{Is_Block:generalpunctuation}', "");
    Expect(0, 8303, '\p{^Is_Block:generalpunctuation}', "");
    Expect(0, 8303, '\P{Is_Block:generalpunctuation}', "");
    Expect(1, 8303, '\P{^Is_Block:generalpunctuation}', "");
    Expect(0, 8304, '\p{Is_Block:generalpunctuation}', "");
    Expect(1, 8304, '\p{^Is_Block:generalpunctuation}', "");
    Expect(1, 8304, '\P{Is_Block:generalpunctuation}', "");
    Expect(0, 8304, '\P{^Is_Block:generalpunctuation}', "");
    Expect(1, 8303, '\p{Is_Block=_ GENERAL_Punctuation}', "");
    Expect(0, 8303, '\p{^Is_Block=_ GENERAL_Punctuation}', "");
    Expect(0, 8303, '\P{Is_Block=_ GENERAL_Punctuation}', "");
    Expect(1, 8303, '\P{^Is_Block=_ GENERAL_Punctuation}', "");
    Expect(0, 8304, '\p{Is_Block=_ GENERAL_Punctuation}', "");
    Expect(1, 8304, '\p{^Is_Block=_ GENERAL_Punctuation}', "");
    Expect(1, 8304, '\P{Is_Block=_ GENERAL_Punctuation}', "");
    Expect(0, 8304, '\P{^Is_Block=_ GENERAL_Punctuation}', "");
    Error('\p{Is_Blk=_:=PUNCTUATION}');
    Error('\P{Is_Blk=_:=PUNCTUATION}');
    Expect(1, 8303, '\p{Is_Blk=punctuation}', "");
    Expect(0, 8303, '\p{^Is_Blk=punctuation}', "");
    Expect(0, 8303, '\P{Is_Blk=punctuation}', "");
    Expect(1, 8303, '\P{^Is_Blk=punctuation}', "");
    Expect(0, 8304, '\p{Is_Blk=punctuation}', "");
    Expect(1, 8304, '\p{^Is_Blk=punctuation}', "");
    Expect(1, 8304, '\P{Is_Blk=punctuation}', "");
    Expect(0, 8304, '\P{^Is_Blk=punctuation}', "");
    Expect(1, 8303, '\p{Is_Blk=	punctuation}', "");
    Expect(0, 8303, '\p{^Is_Blk=	punctuation}', "");
    Expect(0, 8303, '\P{Is_Blk=	punctuation}', "");
    Expect(1, 8303, '\P{^Is_Blk=	punctuation}', "");
    Expect(0, 8304, '\p{Is_Blk=	punctuation}', "");
    Expect(1, 8304, '\p{^Is_Blk=	punctuation}', "");
    Expect(1, 8304, '\P{Is_Blk=	punctuation}', "");
    Expect(0, 8304, '\P{^Is_Blk=	punctuation}', "");
    Error('\p{Block=	/a/REJANG}');
    Error('\P{Block=	/a/REJANG}');
    Expect(1, 43359, '\p{Block=rejang}', "");
    Expect(0, 43359, '\p{^Block=rejang}', "");
    Expect(0, 43359, '\P{Block=rejang}', "");
    Expect(1, 43359, '\P{^Block=rejang}', "");
    Expect(0, 43360, '\p{Block=rejang}', "");
    Expect(1, 43360, '\p{^Block=rejang}', "");
    Expect(1, 43360, '\P{Block=rejang}', "");
    Expect(0, 43360, '\P{^Block=rejang}', "");
    Expect(1, 43359, '\p{Block=_ REJANG}', "");
    Expect(0, 43359, '\p{^Block=_ REJANG}', "");
    Expect(0, 43359, '\P{Block=_ REJANG}', "");
    Expect(1, 43359, '\P{^Block=_ REJANG}', "");
    Expect(0, 43360, '\p{Block=_ REJANG}', "");
    Expect(1, 43360, '\p{^Block=_ REJANG}', "");
    Expect(1, 43360, '\P{Block=_ REJANG}', "");
    Expect(0, 43360, '\P{^Block=_ REJANG}', "");
    Error('\p{Blk=-/a/Rejang}');
    Error('\P{Blk=-/a/Rejang}');
    Expect(1, 43359, '\p{Blk=rejang}', "");
    Expect(0, 43359, '\p{^Blk=rejang}', "");
    Expect(0, 43359, '\P{Blk=rejang}', "");
    Expect(1, 43359, '\P{^Blk=rejang}', "");
    Expect(0, 43360, '\p{Blk=rejang}', "");
    Expect(1, 43360, '\p{^Blk=rejang}', "");
    Expect(1, 43360, '\P{Blk=rejang}', "");
    Expect(0, 43360, '\P{^Blk=rejang}', "");
    Expect(1, 43359, '\p{Blk:    _rejang}', "");
    Expect(0, 43359, '\p{^Blk:    _rejang}', "");
    Expect(0, 43359, '\P{Blk:    _rejang}', "");
    Expect(1, 43359, '\P{^Blk:    _rejang}', "");
    Expect(0, 43360, '\p{Blk:    _rejang}', "");
    Expect(1, 43360, '\p{^Blk:    _rejang}', "");
    Expect(1, 43360, '\P{Blk:    _rejang}', "");
    Expect(0, 43360, '\P{^Blk:    _rejang}', "");
    Error('\p{Is_Block=:=	_Rejang}');
    Error('\P{Is_Block=:=	_Rejang}');
    Expect(1, 43359, '\p{Is_Block=rejang}', "");
    Expect(0, 43359, '\p{^Is_Block=rejang}', "");
    Expect(0, 43359, '\P{Is_Block=rejang}', "");
    Expect(1, 43359, '\P{^Is_Block=rejang}', "");
    Expect(0, 43360, '\p{Is_Block=rejang}', "");
    Expect(1, 43360, '\p{^Is_Block=rejang}', "");
    Expect(1, 43360, '\P{Is_Block=rejang}', "");
    Expect(0, 43360, '\P{^Is_Block=rejang}', "");
    Expect(1, 43359, '\p{Is_Block:__REJANG}', "");
    Expect(0, 43359, '\p{^Is_Block:__REJANG}', "");
    Expect(0, 43359, '\P{Is_Block:__REJANG}', "");
    Expect(1, 43359, '\P{^Is_Block:__REJANG}', "");
    Expect(0, 43360, '\p{Is_Block:__REJANG}', "");
    Expect(1, 43360, '\p{^Is_Block:__REJANG}', "");
    Expect(1, 43360, '\P{Is_Block:__REJANG}', "");
    Expect(0, 43360, '\P{^Is_Block:__REJANG}', "");
    Error('\p{Is_Blk=/a/ 	REJANG}');
    Error('\P{Is_Blk=/a/ 	REJANG}');
    Expect(1, 43359, '\p{Is_Blk=rejang}', "");
    Expect(0, 43359, '\p{^Is_Blk=rejang}', "");
    Expect(0, 43359, '\P{Is_Blk=rejang}', "");
    Expect(1, 43359, '\P{^Is_Blk=rejang}', "");
    Expect(0, 43360, '\p{Is_Blk=rejang}', "");
    Expect(1, 43360, '\p