/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.views;

import com.scitools.understand.Database;
import com.scitools.understand.Entity;
import com.scitools.understand.Understand;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.IUnderstandDatabaseListener;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.nativeutils.EclipseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class MetricTableView
extends ViewPart
implements IUnderstandDatabaseListener {
    public static final String ID = "com.scitools.understand.plugin.views.MetricTableView";
    private TableViewer viewer = null;
    private MetricViewComparator comparator;
    private String[] metricCols;
    private static final int NUM_NONMETRIC_COLS = 2;
    private Menu headercontextmenu;
    private Menu cellcontextmenu;
    String sortCol = null;
    boolean sortDir = true;
    List<String> hiddenCols = new ArrayList<String>();

    public MetricTableView() {
        Activator.getDefault().addDatabaseListener(this);
    }

    public void dispose() {
        Activator.getDefault().removeDatabaseListener(this);
        this.headercontextmenu.dispose();
        super.dispose();
    }

    public void createPartControl(Composite composite) {
        this.comparator = new MetricViewComparator();
        this.viewer = new TableViewer(composite, 268501762);
        this.viewer.setUseHashlookup(true);
        Table table = this.viewer.getTable();
        this.initTableForDatabase(Activator.getDefault().getCurrentDatabase(), table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter(null);
        this.viewer.setInput((Object)Activator.getDefault().getCurrentDatabase());
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.refresh();
        this.hookDoubleClickAction();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.cellcontextmenu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(this.cellcontextmenu);
        this.viewer.getTable().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = event.display.map(null, (Control)MetricTableView.this.viewer.getTable(), new Point(event.x, event.y));
                Rectangle rectangle = MetricTableView.this.viewer.getTable().getClientArea();
                boolean bl = rectangle.y <= point.y && point.y < rectangle.y + MetricTableView.this.viewer.getTable().getHeaderHeight();
                MetricTableView.this.viewer.getControl().setMenu(bl ? MetricTableView.this.headercontextmenu : MetricTableView.this.cellcontextmenu);
            }
        });
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = MetricTableView.this.viewer.getSelection();
                Entity entity = (Entity)((IStructuredSelection)iSelection).getFirstElement();
                Activator.getDefault().jumpToDefinition(entity);
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn tableColumn, final int n) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MetricTableView.this.comparator.setColumn(n);
                int n2 = MetricTableView.this.comparator.getDirection();
                MetricTableView.this.viewer.getTable().setSortDirection(n2);
                MetricTableView.this.viewer.getTable().setSortColumn(tableColumn);
                MetricTableView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void initTableForDatabase(Database database, Table table) {
        TableColumn tableColumn;
        int menuItem;
        if (this.headercontextmenu != null) {
            this.headercontextmenu.dispose();
        }
        this.headercontextmenu = new Menu((Control)table);
        if (this.viewer.getInput() != null) {
            this.hiddenCols.clear();
            this.sortCol = table.getColumn(this.comparator.column).getText();
            this.sortDir = this.comparator.ascending;
        }
        TableColumn[] objectArray = table.getColumns();
        int string = objectArray.length;
        for (menuItem = 0; menuItem < string; ++menuItem) {
            tableColumn = objectArray[menuItem];
            if (tableColumn.getWidth() == 0) {
                this.hiddenCols.add(tableColumn.getText());
            }
            tableColumn.dispose();
        }
        if (database == null) {
            return;
        }
        String[] stringArray = database.language();
        if (stringArray.length == 0) {
            return;
        }
        String string2 = "";
        for (menuItem = 0; menuItem < stringArray.length; ++menuItem) {
            if (menuItem != 0) {
                string2 = string2 + ",";
            }
            string2 = stringArray[menuItem].equals("C++") ? string2 + "c" : string2 + stringArray[menuItem];
        }
        this.metricCols = Understand.metriclist(string2);
        if (this.metricCols.length > 0) {
            MenuItem tableColumn3 = new MenuItem(this.headercontextmenu, 0);
            tableColumn3.setText(Messages.MetricTableView_0);
            tableColumn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    for (MenuItem menuItem : ((MenuItem)selectionEvent.widget).getParent().getItems()) {
                        TableColumn tableColumn = (TableColumn)menuItem.getData();
                        if (tableColumn == null) continue;
                        menuItem.setSelection(true);
                        tableColumn.setWidth(100);
                        tableColumn.setResizable(true);
                    }
                }
            });
            tableColumn = new MenuItem(this.headercontextmenu, 0);
            tableColumn.setText(Messages.MetricTableView_1);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    for (MenuItem menuItem : ((MenuItem)selectionEvent.widget).getParent().getItems()) {
                        TableColumn tableColumn = (TableColumn)menuItem.getData();
                        if (tableColumn == null) continue;
                        menuItem.setSelection(false);
                        tableColumn.setWidth(0);
                        tableColumn.setResizable(false);
                    }
                }
            });
        }
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(Messages.MetricTableView_2);
        tableColumn2.setWidth(this.hiddenCols.contains(Messages.MetricTableView_2) ? 0 : 100);
        tableColumn2.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableColumn2, 0));
        this.createMenuItem(tableColumn2);
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.MetricTableView_3);
        tableColumn.setWidth(this.hiddenCols.contains(Messages.MetricTableView_3) ? 0 : 100);
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableColumn, 1));
        this.createMenuItem(tableColumn);
        for (int i = 0; i < this.metricCols.length; ++i) {
            TableColumn tableColumn3 = new TableColumn(table, 131072);
            tableColumn3.setWidth(this.hiddenCols.contains(this.metricCols[i]) ? 0 : 100);
            tableColumn3.setText(this.metricCols[i]);
            tableColumn3.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableColumn3, i + 2));
            this.createMenuItem(tableColumn3);
        }
        if (this.sortCol == null || this.sortCol.equals(Messages.MetricTableView_2)) {
            this.comparator.column = 0;
        } else if (this.sortCol.equals(Messages.MetricTableView_3)) {
            this.comparator.column = 1;
        } else {
            this.comparator.column = Arrays.asList(this.metricCols).indexOf(this.sortCol) + 2;
        }
        this.comparator.ascending = this.sortDir;
        table.setSortDirection(this.comparator.getDirection());
        table.setSortColumn(table.getColumn(this.comparator.column));
    }

    private void createMenuItem(final TableColumn tableColumn) {
        final MenuItem menuItem = new MenuItem(this.headercontextmenu, 32);
        menuItem.setText(tableColumn.getText());
        menuItem.setSelection(tableColumn.getResizable());
        menuItem.setData((Object)tableColumn);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (menuItem.getSelection()) {
                    tableColumn.setWidth(100);
                    tableColumn.setResizable(true);
                } else {
                    tableColumn.setWidth(0);
                    tableColumn.setResizable(false);
                }
            }
        });
    }

    @Override
    public void databaseAboutToClose() {
        if (this.viewer != null) {
            this.initTableForDatabase(null, this.viewer.getTable());
            this.viewer.setInput(null);
        }
    }

    @Override
    public void currentDatabaseChanged(Database database) {
        if (this.viewer != null) {
            this.initTableForDatabase(database, this.viewer.getTable());
            this.viewer.setInput((Object)database);
        }
    }

    class MetricViewComparator
    extends ViewerComparator {
        private int column = 0;
        private boolean ascending = true;

        public int getDirection() {
            return this.ascending ? 1024 : 128;
        }

        public void setColumn(int n) {
            if (n == this.column) {
                this.ascending = !this.ascending;
            } else {
                this.ascending = true;
                this.column = n;
            }
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            Entity entity = (Entity)object;
            Entity entity2 = (Entity)object2;
            int n = 0;
            switch (this.column) {
                case 0: {
                    n = entity.name().compareToIgnoreCase(entity2.name());
                    break;
                }
                case 1: {
                    n = entity.kind().name().compareToIgnoreCase(entity2.kind().name());
                    break;
                }
                default: {
                    if (this.column - 2 >= MetricTableView.this.metricCols.length) break;
                    Double d = entity.metric(MetricTableView.this.metricCols[this.column - 2]).doubleValue();
                    Double d2 = entity2.metric(MetricTableView.this.metricCols[this.column - 2]).doubleValue();
                    n = d.compareTo(d2);
                }
            }
            if (!this.ascending) {
                n = -n;
            }
            return n;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            Number number;
            String string = "";
            if (n == 0) {
                string = ((Entity)object).name();
            } else if (n == 1) {
                string = ((Entity)object).kind().name();
            } else if (n - 2 < MetricTableView.this.metricCols.length && (number = ((Entity)object).metric(MetricTableView.this.metricCols[n - 2])).intValue() != 0) {
                string = number.toString();
            }
            return string;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public Color getForeground(Object object, int n) {
            if (((Entity)object).kind().check("unknown,unresolved")) {
                return new Color((Device)Display.getDefault(), 120, 120, 120);
            }
            return null;
        }

        public Color getBackground(Object object, int n) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        Database currentInput;
        Entity[] cached = null;

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 != object || this.cached == null) {
                this.currentInput = (Database)object2;
                this.cached = this.currentInput == null ? new Entity[0] : EclipseUtil.metricEnts(this.currentInput);
                MetricTableView.this.viewer.getTable().clearAll();
                MetricTableView.this.viewer.getTable().setItemCount(0);
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return this.cached;
        }
    }
}

