/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.views;

import com.scitools.understand.Database;
import com.scitools.understand.Entity;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.IUnderstandDatabaseListener;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.nativeutils.EclipseUtil;
import com.scitools.understand.plugin.nativeutils.InfoBrowserField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class InfoBrowserView
extends ViewPart
implements IUnderstandDatabaseListener {
    TreeViewer viewer;
    Entity currentEnt = null;
    JumpToReference jumpjob;
    String restoreDbName;
    String restoreEntUniqueName;
    List<String> expansionState = new ArrayList<String>();
    public static final String ID = "com.scitools.understand.plugin.views.infoBrowserView";

    public InfoBrowserView() {
        this.jumpjob = new JumpToReference();
        Activator.getDefault().addDatabaseListener(this);
    }

    public void dispose() {
        Activator.getDefault().removeDatabaseListener(this);
    }

    public void saveExpansionState() {
        List<Object> list = Arrays.asList(this.viewer.getExpandedElements());
        this.expansionState.clear();
        for (Object object : list) {
            this.expansionState.add(((InfoBrowserElement)object).text);
        }
    }

    public void restoreExpansionState() {
        this.viewer.expandToLevel(2);
        ArrayList<InfoBrowserElement> arrayList = new ArrayList<InfoBrowserElement>();
        ViewContentProvider viewContentProvider = (ViewContentProvider)this.viewer.getContentProvider();
        arrayList.add(viewContentProvider.root);
        while (arrayList.size() > 0) {
            InfoBrowserElement infoBrowserElement = (InfoBrowserElement)arrayList.remove(0);
            if (infoBrowserElement != viewContentProvider.root && !this.expansionState.contains(infoBrowserElement.text)) continue;
            this.viewer.setExpandedState((Object)infoBrowserElement, true);
            arrayList.addAll(Arrays.asList((InfoBrowserElement[])viewContentProvider.getChildren(infoBrowserElement)));
        }
    }

    public void setEntity(Entity entity) {
        if (this.currentEnt == null || !this.currentEnt.equals(entity)) {
            if (this.currentEnt != null) {
                this.saveExpansionState();
            }
            this.viewer.setInput((Object)entity);
            this.currentEnt = entity;
            if (this.currentEnt != null) {
                this.restoreExpansionState();
            }
        }
    }

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.currentEnt);
        this.viewer.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                if (InfoBrowserView.this.viewer.getTree().getItem(point) != null) {
                    InfoBrowserElement infoBrowserElement = (InfoBrowserElement)InfoBrowserView.this.viewer.getTree().getItem(point).getData();
                    infoBrowserElement.setCurrentEnt(point);
                    if (infoBrowserElement.field.getFilename() != null) {
                        InfoBrowserView.this.jumpjob.setItem(infoBrowserElement);
                        InfoBrowserView.this.jumpjob.schedule(250L);
                    } else if (event.count == 2 && infoBrowserElement.getLinks().size() == 1) {
                        for (InfoBrowserElement.Link link : infoBrowserElement.getLinks()) {
                            Activator.getDefault().jumpToDefinition(link.ent);
                        }
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getControl().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = InfoBrowserView.this.viewer.getTree().toControl(event.x, event.y);
                if (InfoBrowserView.this.viewer.getTree().getItem(point) != null) {
                    Entity entity = ((InfoBrowserElement)InfoBrowserView.this.viewer.getTree().getItem(point).getData()).setCurrentEnt(point);
                    event.doit = entity != null;
                    InfoBrowserView.this.jumpjob.cancel();
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void databaseAboutToClose() {
        if (Activator.getDefault().getCurrentDatabase() != null) {
            this.restoreDbName = Activator.getDefault().getCurrentDatabase().name();
            if (this.currentEnt != null) {
                this.restoreEntUniqueName = this.currentEnt.uniquename();
            }
        }
        this.setEntity(null);
    }

    @Override
    public void currentDatabaseChanged(Database database) {
        if (database != null && database.name().equals(this.restoreDbName) && this.currentEnt == null && this.restoreEntUniqueName != null) {
            this.setEntity(database.lookup_uniquename(this.restoreEntUniqueName));
        }
    }

    public class JumpToReference
    extends WorkbenchJob {
        private InfoBrowserElement item;

        public JumpToReference() {
            super(Messages.InfoBrowserView_0);
        }

        public void setItem(InfoBrowserElement infoBrowserElement) {
            this.item = infoBrowserElement;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask(Messages.InfoBrowserView_1, -1);
            if (this.item != null) {
                Activator.getDefault().openEditor(this.item.field.getFilename(), this.item.field.getLine(), this.item.field.getColumn(), this.item.field.getHightlightString());
            }
            iProgressMonitor.done();
            return Status.OK_STATUS;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        InfoBrowserElement root;
        Map<InfoBrowserField, InfoBrowserElement> elements = null;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (this.elements != null) {
                this.elements.clear();
            }
            this.elements = new HashMap<InfoBrowserField, InfoBrowserElement>();
            if (object2 != null) {
                this.root = new InfoBrowserElement(EclipseUtil.detailedIb((Entity)object2, "{calls}levels=-1;{callbys}levels=-1;{includes}levels=-1;"));
                this.elements.put(this.root.field, this.root);
            } else {
                this.root = null;
            }
        }

        public Object[] getElements(Object object) {
            if (this.root != null) {
                return new InfoBrowserElement[]{this.root};
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            InfoBrowserField[] infoBrowserFieldArray = ((InfoBrowserElement)object).field.getChildren();
            if (infoBrowserFieldArray != null) {
                Object[] objectArray = new InfoBrowserElement[infoBrowserFieldArray.length];
                for (int i = 0; i < infoBrowserFieldArray.length; ++i) {
                    objectArray[i] = this.elements.containsKey(infoBrowserFieldArray[i]) ? this.elements.get(infoBrowserFieldArray[i]) : new InfoBrowserElement(infoBrowserFieldArray[i]);
                    this.elements.put(((InfoBrowserElement)objectArray[i]).field, (InfoBrowserElement)objectArray[i]);
                }
                return objectArray;
            }
            return null;
        }

        public Object getParent(Object object) {
            InfoBrowserField infoBrowserField = ((InfoBrowserElement)object).field.getParent();
            if (this.elements.containsKey(infoBrowserField)) {
                return this.elements.get(infoBrowserField);
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            InfoBrowserField[] infoBrowserFieldArray = ((InfoBrowserElement)object).field.getChildren();
            return infoBrowserFieldArray != null;
        }
    }

    public class InfoBrowserElement
    implements IAdaptable {
        InfoBrowserField field;
        String text;
        Entity current;
        Map<Link, Rectangle> linkAreas;

        /*
         * WARNING - void declaration
         */
        public InfoBrowserElement(InfoBrowserField infoBrowserField) {
            void var6_8;
            this.field = infoBrowserField;
            this.text = "";
            for (InfoBrowserField.Token object2 : infoBrowserField.getTokens()) {
                this.text = this.text + object2.getText();
            }
            this.linkAreas = new HashMap<Link, Rectangle>();
            InfoBrowserField.Token[] tokenArray = infoBrowserField.getTokens();
            int n = 0;
            int n2 = 0;
            Object var6_7 = null;
            for (int i = 0; i < tokenArray.length; ++i) {
                Entity entity = tokenArray[i].getEnt();
                if (entity != null && var6_8 != null && var6_8.equals(entity)) {
                    n2 += tokenArray[i].getText().length();
                    continue;
                }
                if (var6_8 != null) {
                    this.addLink(n, n2, (Entity)var6_8);
                }
                n += n2;
                n2 = tokenArray[i].getText().length();
                Entity entity2 = entity;
            }
            if (var6_8 != null) {
                this.addLink(n, n2, (Entity)var6_8);
            }
        }

        public Entity getEntitySelection() {
            return this.current;
        }

        public Entity setCurrentEnt(Point point) {
            this.current = this.getEntityAtPoint(point);
            return this.current;
        }

        public boolean hasMultipleLinks() {
            return this.linkAreas.size() > 1;
        }

        public Set<Link> getLinks() {
            return this.linkAreas.keySet();
        }

        public void setLinkArea(Link link, Rectangle rectangle) {
            this.linkAreas.put(link, rectangle);
        }

        public Entity getEntityAtPoint(Point point) {
            for (Map.Entry<Link, Rectangle> entry : this.linkAreas.entrySet()) {
                if ((entry.getValue() == null || !entry.getValue().contains(point)) && this.hasMultipleLinks()) continue;
                return entry.getKey().ent;
            }
            return null;
        }

        public String getLinkFromPoint(Point point) {
            String string = this.text;
            if (this.hasMultipleLinks()) {
                for (Map.Entry<Link, Rectangle> entry : this.linkAreas.entrySet()) {
                    if (entry.getValue() == null || !entry.getValue().contains(point)) continue;
                    string = this.text.substring(entry.getKey().start, entry.getKey().start + entry.getKey().length);
                    string = string + "\t" + entry.getKey().ent.name();
                    break;
                }
            }
            return string;
        }

        public void addLink(int n, int n2, Entity entity) {
            this.linkAreas.put(new Link(n, n2, entity), null);
        }

        public Object getAdapter(Class clazz) {
            if (clazz.equals(Entity.class)) {
                return this.current;
            }
            return null;
        }

        class Link {
            int start;
            int length;
            Entity ent;

            public Link(int n, int n2, Entity entity) {
                this.start = n;
                this.length = n2;
                this.ent = entity;
            }

            public int hashCode() {
                int n = 1;
                n = 31 * n + this.getOuterType().hashCode();
                n = 31 * n + this.length;
                n = 31 * n + this.start;
                return n;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Link link = (Link)object;
                if (!this.getOuterType().equals(link.getOuterType())) {
                    return false;
                }
                if (this.length != link.length) {
                    return false;
                }
                return this.start == link.start;
            }

            private InfoBrowserElement getOuterType() {
                return InfoBrowserElement.this;
            }
        }
    }

    class ViewLabelProvider
    extends StyledCellLabelProvider {
        private Color blue;
        private Color grey;
        private FontRegistry registry;

        public ViewLabelProvider() {
            super(1);
            this.registry = new FontRegistry();
            this.blue = new Color((Device)Display.getDefault(), 0, 0, 255);
            this.grey = new Color((Device)Display.getDefault(), 120, 120, 120);
        }

        public void update(ViewerCell viewerCell) {
            InfoBrowserElement infoBrowserElement = (InfoBrowserElement)viewerCell.getElement();
            viewerCell.setText(infoBrowserElement.text);
            InfoBrowserField.Token[] tokenArray = infoBrowserElement.field.getTokens();
            int n = 0;
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
            for (int i = 0; i < tokenArray.length; ++i) {
                Color color = null;
                if (tokenArray[i].getEnt() != null && !tokenArray[i].isDefaultFontColor()) {
                    color = tokenArray[i].getEnt().kind().check("unknown, unresolved") ? this.grey : this.blue;
                }
                arrayList.add(new StyleRange(n, tokenArray[i].getText().length(), color, null));
                if (tokenArray[i].isBold()) {
                    ((StyleRange)arrayList.get((int)i)).font = this.registry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
                }
                if (tokenArray[i].isItalic()) {
                    ((StyleRange)arrayList.get((int)i)).font = this.registry.getItalic(Display.getCurrent().getSystemFont().getFontData()[0].getName());
                }
                n += tokenArray[i].getText().length();
            }
            viewerCell.setStyleRanges(arrayList.toArray(new StyleRange[0]));
            super.update(viewerCell);
        }

        protected void paint(Event event, Object object) {
            InfoBrowserElement infoBrowserElement = (InfoBrowserElement)object;
            if (infoBrowserElement.hasMultipleLinks()) {
                for (InfoBrowserElement.Link link : infoBrowserElement.getLinks()) {
                    Point point = event.gc.stringExtent(infoBrowserElement.text.substring(link.start, link.start + link.length));
                    Point point2 = event.gc.stringExtent(infoBrowserElement.text.substring(0, link.start));
                    infoBrowserElement.setLinkArea(link, new Rectangle(event.x + point2.x, event.y, point.x, point.y));
                }
            }
            super.paint(event, object);
        }
    }
}

