/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.views;

import com.scitools.understand.Database;
import com.scitools.understand.Entity;
import com.scitools.understand.UnderstandException;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.IUnderstandDatabaseListener;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.nativeutils.EclipseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class GraphView
extends ViewPart
implements ISelectionProvider,
IUnderstandDatabaseListener {
    public static final String ID = "com.scitools.understand.plugin.views.graphView";
    List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    ISelection currentSelection = new StructuredSelection();
    Entity graphEnt;
    String graphName;
    String graphOpts;
    FigureCanvas canvas;
    Menu popup;
    EclipseDevice mDevice;
    Map<String, List<String>> mOptions = new TreeMap<String, List<String>>();
    Map<String, String> mOptionValues = new TreeMap<String, String>();
    DelaySyncJob delayJob = new DelaySyncJob();

    public GraphView() {
        Activator.getDefault().addDatabaseListener(this);
    }

    public void setContent(Entity entity, String string, String string2) {
        this.graphEnt = entity;
        this.graphName = string;
        this.graphOpts = string2;
        if (this.graphEnt != null && this.graphName != null) {
            this.setPartName(this.graphEnt.name() + " - " + this.graphName);
        }
        this.generate();
    }

    private void generate() {
        if (this.canvas != null) {
            if (this.mDevice != null) {
                this.mDevice.dispose();
            }
            this.mDevice = new EclipseDevice();
            if (this.graphEnt != null) {
                try {
                    EclipseUtil.graph(this.mDevice, this.graphEnt, this.graphName, this.graphOpts);
                }
                catch (UnderstandException understandException) {
                    MessageBox messageBox = new MessageBox(this.getSite().getShell(), 1);
                    messageBox.setMessage(Messages.OpenEntityGraph_1 + understandException.getMessage());
                    messageBox.open();
                    understandException.printStackTrace();
                }
            }
            this.canvas.setContents(this.mDevice.contents());
        }
    }

    public void createPartControl(Composite composite) {
        this.canvas = new FigureCanvas(composite);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (!GraphView.this.currentSelection.isEmpty()) {
                    iMenuManager.add((IContributionItem)new Separator("additions"));
                } else {
                    for (final String string : GraphView.this.mOptions.keySet()) {
                        MenuManager menuManager = new MenuManager(string);
                        for (final String string2 : GraphView.this.mOptions.get(string)) {
                            Action action = new Action(string2){

                                public void run() {
                                    GraphView.this.mOptionValues.put(string, string2);
                                    GraphView.this.graphOpts = "";
                                    for (String string3 : GraphView.this.mOptionValues.keySet()) {
                                        if (!GraphView.this.graphOpts.isEmpty()) {
                                            GraphView.this.graphOpts = GraphView.this.graphOpts + ';';
                                        }
                                        GraphView.this.graphOpts = GraphView.this.graphOpts + string3 + '=' + GraphView.this.mOptionValues.get(string3);
                                    }
                                    GraphView.this.generate();
                                }
                            };
                            action.setChecked(string2.equals(GraphView.this.mOptionValues.get(string)));
                            menuManager.add((IAction)action);
                        }
                        iMenuManager.add((IContributionItem)menuManager);
                    }
                }
            }
        });
        this.popup = menuManager.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(this.popup);
        this.canvas.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                GraphView.this.delayJob.cancel();
            }
        });
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public void dispose() {
        if (this.mDevice != null) {
            this.mDevice.dispose();
        }
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.listeners.contains(iSelectionChangedListener)) {
            this.listeners.add(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.currentSelection = iSelection;
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
        }
    }

    @Override
    public void databaseAboutToClose() {
        this.setContent(null, null, null);
        this.getViewSite().getPage().hideView((IViewPart)this);
    }

    @Override
    public void currentDatabaseChanged(Database database) {
        this.setContent(null, null, null);
        this.getViewSite().getPage().hideView((IViewPart)this);
    }

    public class EclipseDevice {
        Panel mRoot;
        Map<RGB, Color> mColors = new HashMap<RGB, Color>();
        Map<FontData, Font> mFonts = new HashMap<FontData, Font>();

        EclipseDevice() {
        }

        public Color getColor(int n, int n2, int n3) {
            RGB rGB = new RGB(n, n2, n3);
            if (!this.mColors.containsKey(rGB)) {
                this.mColors.put(rGB, new Color((Device)GraphView.this.canvas.getDisplay(), rGB));
            }
            return this.mColors.get(rGB);
        }

        public IFigure contents() {
            return this.mRoot;
        }

        public Font getFont(String string, int n, int n2) {
            for (FontData fontData : this.mFonts.keySet()) {
                if (!fontData.getName().equals(string) || fontData.getHeight() != n || fontData.getStyle() != n2) continue;
                return this.mFonts.get(fontData);
            }
            FontData fontData = new FontData(string, n, n2);
            this.mFonts.put(fontData, new Font((Device)GraphView.this.canvas.getDisplay(), fontData));
            return this.mFonts.get(fontData);
        }

        public SyncInfo getSyncData(String string, int n, int n2) {
            return new SyncInfo(string, n, n2);
        }

        public void DoBegin(int n, int n2, Color color) {
            this.mRoot = new Panel();
            XYLayout xYLayout = new XYLayout();
            this.mRoot.setLayoutManager((LayoutManager)xYLayout);
            this.mRoot.setBackgroundColor(color);
            this.mRoot.setSize(n, n2);
            this.mRoot.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                    GraphView.this.setSelection((ISelection)new StructuredSelection());
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseDoubleClicked(MouseEvent mouseEvent) {
                }
            });
        }

        public void addShape(Shape shape, int n, int n2, Color color, Color color2, Object object) {
            shape.setLineWidth(n);
            shape.setLineStyle(n2);
            shape.setForegroundColor(color);
            shape.setFill(color2 != null);
            shape.setBackgroundColor(color2);
            this.attachListeners((IFigure)shape, object);
            this.mRoot.add((IFigure)shape, (Object)new Rectangle(shape.getBounds()));
        }

        private void attachListeners(IFigure iFigure, Object object) {
            if (object != null && object instanceof Entity) {
                iFigure.addMouseListener((MouseListener)new EntNodeListener((Entity)object));
            } else if (object != null && object instanceof SyncInfo) {
                SyncInfo syncInfo = (SyncInfo)object;
                iFigure.addMouseListener((MouseListener)new RefNodeListener(syncInfo.file, syncInfo.line, syncInfo.col));
            }
        }

        public void DoEnd() {
        }

        public void DoDrawEllipse(Point point, int n, int n2, int n3, int n4, Color color, Color color2, Object object) {
            Ellipse ellipse = new Ellipse();
            ellipse.setBounds(new Rectangle(new Point(point.x - n, point.y + n2), new Point(point.x + n, point.y - n2)));
            this.addShape((Shape)ellipse, n3, n4, color, color2, object);
        }

        public void DoDrawLine(int[] nArray, int n, int n2, Color color, Object object) {
            Polyline polyline = new Polyline();
            polyline.setPoints(new PointList(nArray));
            this.addShape((Shape)polyline, n, n2, color, null, object);
        }

        public void DoDrawPolygon(int[] nArray, int n, int n2, Color color, Color color2, Object object) {
            Polygon polygon = new Polygon();
            polygon.setPoints(new PointList(nArray));
            this.addShape((Shape)polygon, n, n2, color, color2, object);
        }

        public void DoDrawRectangle(Point point, Point point2, int n, int n2, int n3, Color color, Color color2, Object object) {
            RectangleFigure rectangleFigure;
            Object object2 = rectangleFigure = n == 0 ? new RectangleFigure() : new RoundedRectangle();
            if (n != 0) {
                ((RoundedRectangle)rectangleFigure).setCornerDimensions(new Dimension(n, n));
            }
            rectangleFigure.setBounds(new Rectangle(point, point2));
            this.addShape((Shape)rectangleFigure, n2, n3, color, color2, object);
        }

        public void DoDrawText(String string, Point point, int n, int n2, Font font, Color color, Color color2, Object object) {
            Label label = new Label(string);
            label.setLocation(point);
            label.setFont(font);
            label.setForegroundColor(color);
            label.setBackgroundColor(color2);
            this.attachListeners((IFigure)label, object);
            this.mRoot.add((IFigure)label, (Object)new Rectangle(point.x, point.y, n, n2));
        }

        public void setOptions(Map<String, List<String>> map, Map<String, String> map2) {
            GraphView.this.mOptions = map;
            GraphView.this.mOptionValues = map2;
        }

        public void dispose() {
            for (Color color : this.mColors.values()) {
                color.dispose();
            }
            this.mColors.clear();
            for (Font font : this.mFonts.values()) {
                font.dispose();
            }
            this.mFonts.clear();
        }

        class SyncInfo {
            String file;
            int line;
            int col;

            SyncInfo(String string, int n, int n2) {
                this.file = string;
                this.line = n;
                this.col = n2;
            }
        }
    }

    public class RefNodeListener
    implements MouseListener {
        String file;
        int line;
        int column;

        public RefNodeListener(String string, int n, int n2) {
            this.file = string;
            this.line = n;
            this.column = n2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GraphView.this.delayJob.setItem(this);
            GraphView.this.delayJob.schedule(250L);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
        }
    }

    public class DelaySyncJob
    extends WorkbenchJob {
        RefNodeListener clicked;

        public DelaySyncJob() {
            super(Messages.GraphView_0);
        }

        public void setItem(RefNodeListener refNodeListener) {
            this.clicked = refNodeListener;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask(Messages.GraphView_1, -1);
            if (this.clicked != null) {
                Activator.getDefault().openEditor(this.clicked.file, this.clicked.line, this.clicked.column, null);
            }
            iProgressMonitor.done();
            return Status.OK_STATUS;
        }
    }

    public class EntNodeListener
    implements MouseListener {
        Entity ent;

        public EntNodeListener(Entity entity) {
            this.ent = entity;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GraphView.this.setSelection((ISelection)new StructuredSelection((Object)this.ent));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
            Activator.getDefault().jumpToDefinition(this.ent);
        }
    }
}

