/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.views;

import com.scitools.understand.Database;
import com.scitools.understand.Entity;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.IUnderstandDatabaseListener;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.nativeutils.EclipseUtil;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class EntityFilterView
extends ViewPart
implements IUnderstandDatabaseListener {
    public static final String ID = "com.scitools.understand.plugin.views.EntityFilterView";
    private TableViewer viewer = null;
    private EntityNameFilter namefilter;
    private String kindFilter = "";
    private Combo kindCombo;
    private RefreshJob refresh = new RefreshJob();
    private Action doubleClickAction;
    private String restoreKindFilter = "";

    public EntityFilterView() {
        Activator.getDefault().addDatabaseListener(this);
    }

    public void dispose() {
        Activator.getDefault().removeDatabaseListener(this);
        super.dispose();
    }

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.EntityFilterView_2);
        this.kindCombo = new Combo(composite, 8);
        this.kindCombo.setLayoutData((Object)new GridData(768));
        this.kindCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EntityFilterView.this.kindFilter = ((Combo)selectionEvent.widget).getItem(((Combo)selectionEvent.widget).getSelectionIndex());
                EntityFilterView.this.refresh.cancel();
                EntityFilterView.this.refresh.schedule(500L);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData());
        label2.setText(Messages.EntityFilterView_3);
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText("");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EntityFilterView.this.namefilter.setSearchString(((Text)modifyEvent.widget).getText());
                EntityFilterView.this.refresh.cancel();
                EntityFilterView.this.refresh.schedule(500L);
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.viewer = new TableViewer(composite, 268436226);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter(null);
        this.namefilter = new EntityNameFilter("");
        this.viewer.addFilter((ViewerFilter)this.namefilter);
        this.loadDatabase(Activator.getDefault().getCurrentDatabase());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.scitools.understand.plugin.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                EntityFilterView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection iSelection = EntityFilterView.this.viewer.getSelection();
                Entity entity = (Entity)((IStructuredSelection)iSelection).getFirstElement();
                Activator.getDefault().jumpToDefinition(entity);
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                EntityFilterView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void loadDatabase(Database database) {
        if (this.kindCombo != null) {
            if (this.kindFilter != null && !this.kindFilter.equals("")) {
                this.restoreKindFilter = this.kindFilter;
            }
            String[] stringArray = new String[]{};
            int n = 0;
            if (database != null) {
                stringArray = EclipseUtil.filters(database);
                n = Arrays.asList(stringArray).indexOf(this.restoreKindFilter);
                if (n == -1) {
                    n = 0;
                }
                this.kindFilter = stringArray.length == 0 ? "" : stringArray[n];
            } else {
                this.kindFilter = "";
            }
            this.kindCombo.setItems(stringArray);
            this.kindCombo.select(n);
        }
        if (this.viewer != null) {
            this.viewer.setInput((Object)database);
        }
    }

    @Override
    public void databaseAboutToClose() {
        this.loadDatabase(null);
    }

    @Override
    public void currentDatabaseChanged(Database database) {
        this.loadDatabase(database);
    }

    class RefreshJob
    extends WorkbenchJob {
        public RefreshJob() {
            super(Messages.EntityFilterView_0);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask(Messages.EntityFilterView_1, -1);
            EntityFilterView.this.viewer.getControl().setRedraw(false);
            EntityFilterView.this.viewer.refresh();
            EntityFilterView.this.viewer.getControl().setRedraw(true);
            iProgressMonitor.done();
            return Status.OK_STATUS;
        }
    }

    class EntityNameFilter
    extends ViewerFilter {
        private String searchstring;

        public EntityNameFilter(String string) {
            this.searchstring = string;
        }

        public void setSearchString(String string) {
            this.searchstring = string;
        }

        public String getSearchString() {
            return this.searchstring;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return ((Entity)object2).name().contains(this.searchstring);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            return ((Entity)object).name();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public Color getForeground(Object object, int n) {
            if (((Entity)object).kind().check("unknown,unresolved")) {
                return new Color((Device)Display.getDefault(), 120, 120, 120);
            }
            return null;
        }

        public Color getBackground(Object object, int n) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        Database currentInput;
        Entity[] cached;
        String prevKindFilter;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.currentInput = (Database)object2;
            this.prevKindFilter = null;
            EntityFilterView.this.viewer.getTable().clearAll();
            EntityFilterView.this.viewer.getTable().setItemCount(0);
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (this.prevKindFilter != null && this.prevKindFilter.equals(EntityFilterView.this.kindFilter)) {
                return this.cached;
            }
            this.prevKindFilter = EntityFilterView.this.kindFilter;
            this.cached = this.currentInput == null ? new Entity[0] : (EntityFilterView.this.kindFilter.equals("") ? this.currentInput.ents(null) : EclipseUtil.filteredEnts(this.currentInput, EntityFilterView.this.kindFilter));
            return this.cached;
        }
    }
}

