/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.commands;

import com.scitools.understand.Understand;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.views.ImageViewer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenMetricTreemap
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPage iWorkbenchPage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent).getActivePage();
        try {
            MetricTreemapDialog metricTreemapDialog = new MetricTreemapDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent));
            if (metricTreemapDialog.open() != 0) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Activator.getDefault().getCurrentDatabase().metrics_treemap(metricTreemapDialog.getSizeMetric(), metricTreemapDialog.getColorMetric(), metricTreemapDialog.getEntKinds()));
            ImageViewer imageViewer = (ImageViewer)iWorkbenchPage.showView("com.scitools.understand.plugin.views.imageViewer", metricTreemapDialog.getSizeMetric() + "-" + metricTreemapDialog.getColorMetric() + "-" + metricTreemapDialog.getEntKinds(), 1);
            Image image = new Image((Device)imageViewer.getDisplay(), (InputStream)byteArrayInputStream);
            imageViewer.setImage(image, Messages.OpenMetricTreemap_4 + metricTreemapDialog.getSizeMetric() + "-" + metricTreemapDialog.getColorMetric());
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled() {
        return Activator.getDefault().getCurrentDatabase() != null;
    }

    public class MetricTreemapDialog
    extends Dialog {
        private Combo sizeMetricCombo;
        private Combo colorMetricCombo;
        private Combo entKindsCombo;
        private String sizeMet;
        private String colorMet;
        private String kinds;

        private String[] getAvailableMetrics(int n) {
            if (n == 0) {
                String[] stringArray = Understand.metriclist("file");
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList("Cyclomatic", "CountPath", "CyclomaticModified", "CyclomaticStrict", "Essential", "MaxNesting"));
                for (String string : stringArray) {
                    if (arrayList2.contains(string)) continue;
                    arrayList.add(string);
                }
                return arrayList.toArray(new String[0]);
            }
            if (n == 1) {
                String string = "";
                for (String string2 : Activator.getDefault().getCurrentDatabase().language()) {
                    if (string2.equals("Ada")) {
                        string = string + (string.isEmpty() ? "" : ",") + "ada package ~unknown ~unresolved";
                    }
                    if (string2.equals("C++")) {
                        string = string + (string.isEmpty() ? "" : ",") + "c class ~unknown ~unresolved";
                    }
                    if (string2.equals("C#")) {
                        string = string + (string.isEmpty() ? "" : ",") + "c# class ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "c# interface ~unknown ~unresolved";
                    }
                    if (string2.equals("Java")) {
                        string = string + (string.isEmpty() ? "" : ",") + "java class ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "java interface ~unknown ~unresolved";
                    }
                    if (!string2.equals("Web")) continue;
                    string = string + (string.isEmpty() ? "" : ",") + "php class ~unknown ~unresolved";
                    string = string + (string.isEmpty() ? "" : ",") + "php interface ~unknown ~unresolved";
                }
                return Understand.metriclist(string);
            }
            if (n == 2) {
                String string = "";
                for (String string3 : Activator.getDefault().getCurrentDatabase().language()) {
                    if (string3.equals("Ada")) {
                        string = string + (string.isEmpty() ? "" : ",") + "ada procedure ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "ada function ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "ada task ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("C++")) {
                        string = string + (string.isEmpty() ? "" : ",") + "c function ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("C#")) {
                        string = string + (string.isEmpty() ? "" : ",") + "c# method ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Fortran")) {
                        string = string + (string.isEmpty() ? "" : ",") + "fortran method ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "fortran subroutine ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Java")) {
                        string = string + (string.isEmpty() ? "" : ",") + "java method ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Jovial")) {
                        string = string + (string.isEmpty() ? "" : ",") + "jovial subroutine ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Pascal")) {
                        string = string + (string.isEmpty() ? "" : ",") + "pascal method ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "pascal routine ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Plm")) {
                        string = string + (string.isEmpty() ? "" : ",") + "plm procedure ~unknown ~unresolved";
                        continue;
                    }
                    if (string3.equals("Web")) {
                        string = string + (string.isEmpty() ? "" : ",") + "php function ~unknown ~unresolved";
                        string = string + (string.isEmpty() ? "" : ",") + "javascript function ~unknown ~unresolved";
                        continue;
                    }
                    if (!string3.equals("Vhdl")) continue;
                    string = string + (string.isEmpty() ? "" : ",") + "vhdl function ~unknown ~unresolved";
                    string = string + (string.isEmpty() ? "" : ",") + "vhdl procedure ~unknown ~unresolved";
                }
                return Understand.metriclist(string);
            }
            return null;
        }

        public MetricTreemapDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.OpenMetricTreemap_0);
            this.entKindsCombo = new Combo(composite2, 8);
            this.entKindsCombo.setLayoutData((Object)new GridData(768));
            this.entKindsCombo.setItems(new String[]{"File", "Class", "Function"});
            this.entKindsCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MetricTreemapDialog.this.sizeMetricCombo.setItems(MetricTreemapDialog.this.getAvailableMetrics(((Combo)selectionEvent.widget).getSelectionIndex()));
                    MetricTreemapDialog.this.sizeMetricCombo.select(0);
                    MetricTreemapDialog.this.colorMetricCombo.setItems(MetricTreemapDialog.this.getAvailableMetrics(((Combo)selectionEvent.widget).getSelectionIndex()));
                    MetricTreemapDialog.this.colorMetricCombo.select(0);
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            Label label2 = new Label(composite2, 0);
            label2.setLayoutData((Object)new GridData());
            label2.setText(Messages.OpenMetricTreemap_1);
            this.sizeMetricCombo = new Combo(composite2, 8);
            this.sizeMetricCombo.setLayoutData((Object)new GridData(768));
            Label label3 = new Label(composite2, 0);
            label3.setLayoutData((Object)new GridData());
            label3.setText(Messages.OpenMetricTreemap_2);
            this.colorMetricCombo = new Combo(composite2, 8);
            this.colorMetricCombo.setLayoutData((Object)new GridData(768));
            this.entKindsCombo.select(0);
            this.sizeMetricCombo.setItems(this.getAvailableMetrics(0));
            this.sizeMetricCombo.select(0);
            this.colorMetricCombo.setItems(this.getAvailableMetrics(0));
            this.colorMetricCombo.select(0);
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.OpenMetricTreemap_3);
        }

        protected Point getInitialSize() {
            return new Point(300, 200);
        }

        protected void okPressed() {
            this.kinds = this.entKindsCombo.getItem(this.entKindsCombo.getSelectionIndex());
            this.sizeMet = this.sizeMetricCombo.getItem(this.sizeMetricCombo.getSelectionIndex());
            this.colorMet = this.colorMetricCombo.getItem(this.colorMetricCombo.getSelectionIndex());
            super.okPressed();
        }

        public String getEntKinds() {
            return this.kinds;
        }

        public String getSizeMetric() {
            return this.sizeMet;
        }

        public String getColorMetric() {
            return this.colorMet;
        }
    }
}

