/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.commands;

import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.Messages;
import com.scitools.understand.plugin.ProjectPropertyPage;
import com.scitools.understand.plugin.commands.OpenDatabase;
import com.scitools.understand.plugin.nativeutils.EclipseUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateUDB
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Object object;
        if (!EclipseUtil.licenseTest()) {
            MessageBox messageBox = new MessageBox(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), 1);
            messageBox.setMessage(Messages.CreateUDB_0);
            messageBox.open();
            return null;
        }
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        IProject iProject = null;
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            object = (IStructuredSelection)iSelection;
            for (Object e : object) {
                if (e instanceof IProject) {
                    iProject = (IProject)e;
                    break;
                }
                if (!(e instanceof IAdaptable)) continue;
                iProject = (IProject)((IAdaptable)e).getAdapter(IProject.class);
                break;
            }
        }
        if (iProject != null) {
            object = new BeforeCreateUdbDialog(iProject, HandlerUtil.getActiveShell((ExecutionEvent)executionEvent));
            object.open();
        }
        return null;
    }

    private class BeforeCreateUdbDialog
    extends TitleAreaDialog {
        private IProject mProject;
        private Text dbName;
        private Text directory;
        private CheckboxTableViewer viewer;

        public BeforeCreateUdbDialog(IProject iProject, Shell shell) {
            super(shell);
            this.mProject = iProject;
        }

        public void create() {
            super.create();
            this.setTitle(Messages.CreateUDB_1 + this.mProject.getName());
            this.setMessage(Messages.CreateUDB_2);
            this.getButton(0).setEnabled(false);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Composite composite3 = new Composite(composite2, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            composite3.setLayoutData((Object)new GridData(4, 4, true, true));
            composite3.setLayout((Layout)gridLayout);
            Label label = new Label(composite3, 0);
            label.setText(Messages.CreateUDB_3);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 2;
            this.dbName = new Text(composite3, 2048);
            this.dbName.setLayoutData((Object)gridData);
            this.dbName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    BeforeCreateUdbDialog.this.getButton(0).setEnabled(!BeforeCreateUdbDialog.this.dbName.getText().isEmpty());
                    if (BeforeCreateUdbDialog.this.dbName.getText().isEmpty()) {
                        BeforeCreateUdbDialog.this.setMessage(Messages.CreateUDB_4);
                    } else {
                        BeforeCreateUdbDialog.this.setMessage("");
                    }
                }
            });
            Label label2 = new Label(composite3, 0);
            label2.setText(Messages.CreateUDB_5);
            GridData gridData2 = new GridData();
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            this.directory = new Text(composite3, 2048);
            Path path = Paths.get("", new String[0]);
            this.directory.setText(path.toAbsolutePath().toString());
            this.directory.setLayoutData((Object)gridData2);
            Button button = new Button(composite3, 0);
            button.setText(Messages.CreateUDB_6);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(selectionEvent.display.getActiveShell());
                    BeforeCreateUdbDialog.this.directory.setText(directoryDialog.open());
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            Label label3 = new Label(composite3, 0);
            label3.setText(Messages.CreateUDB_7);
            GridData gridData3 = new GridData(1808);
            gridData3.horizontalSpan = 3;
            Table table = new Table(composite3, 800);
            this.viewer = new CheckboxTableViewer(table);
            this.viewer.getControl().setLayoutData((Object)gridData3);
            this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
            this.viewer.setInput((Object)this.mProject);
            this.viewer.setAllChecked(true);
            return composite2;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            Path path;
            String string;
            final File file = new File(this.directory.getText(), this.dbName.getText() + (this.dbName.getText().endsWith(".udb") ? "" : ".udb"));
            if (file.exists()) {
                string = new MessageBox(this.getShell(), 196);
                string.setMessage(Messages.CreateUDB_8);
                if (string.open() != 64) {
                    return;
                }
            }
            string = file.getAbsolutePath();
            Object[] objectArray = this.viewer.getCheckedElements();
            String string2 = "";
            try {
                string2 = this.mProject.getPersistentProperty(ProjectPropertyPage.UDB_FOR_PROJECT);
                this.mProject.setPersistentProperty(ProjectPropertyPage.UDB_FOR_PROJECT, string);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            final String string3 = string2;
            Activator.getDefault().closeCurrentDatabase();
            File file2 = new File(this.directory.getText(), this.dbName.getText() + "projectList.txt");
            BufferedWriter bufferedWriter = null;
            final String string4 = "@" + file2.getAbsolutePath().toString();
            try {
                path = FileSystems.getDefault().getPath(file2.getAbsolutePath(), new String[0]);
                Files.deleteIfExists(path);
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                for (Object object : objectArray) {
                    bufferedWriter.append((String)object).write("\r\n");
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            path = new Job(Messages.CreateUDB_9){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    Object object;
                    iProgressMonitor.beginTask(Messages.CreateUDB_10, -1);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("und");
                    arrayList.add("create");
                    arrayList.add("-db");
                    arrayList.add(string);
                    arrayList.add("-languages");
                    arrayList.add("all");
                    arrayList.add("add");
                    arrayList.add(string4);
                    arrayList.add("analyze");
                    arrayList.add("-all");
                    int n = 1;
                    String string5 = "";
                    final long l = file.exists() ? file.lastModified() : 0L;
                    try {
                        String string2;
                        object = new ProcessBuilder(arrayList);
                        ((ProcessBuilder)object).redirectErrorStream(true);
                        Process process = ((ProcessBuilder)object).start();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if ((!string2.startsWith("Files") || string2.endsWith(": 0") && !string5.isEmpty()) && !string2.startsWith("Analyze") && !string2.startsWith("Error:")) continue;
                            string5 = string5 + "\t" + string2 + "\n";
                        }
                        n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        n = 1;
                    }
                    catch (IOException iOException) {
                        n = 1;
                    }
                    object = string5;
                    final int n2 = n;
                    Display.getDefault().syncExec(new Runnable((String)object){
                        final /* synthetic */ String val$message;
                        {
                            this.val$message = string;
                        }

                        @Override
                        public void run() {
                            if (!(n2 == 0 || file.exists() && file.lastModified() != l)) {
                                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), n2 == 0 ? 2 : 1);
                                messageBox.setMessage(Messages.CreateUDB_11 + this.val$message);
                                messageBox.open();
                                try {
                                    BeforeCreateUdbDialog.this.mProject.setPersistentProperty(ProjectPropertyPage.UDB_FOR_PROJECT, string3);
                                }
                                catch (CoreException coreException) {
                                    coreException.printStackTrace();
                                }
                                return;
                            }
                            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), n2 == 0 ? 2 : 1);
                            messageBox.setMessage(Messages.CreateUDB_12 + Messages.CreateUDB_13 + this.val$message);
                            messageBox.open();
                            if (n2 != 0) {
                                return;
                            }
                            IWorkbenchPartSite iWorkbenchPartSite = null;
                            try {
                                iWorkbenchPartSite = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                            }
                            catch (NullPointerException nullPointerException) {
                                iWorkbenchPartSite = null;
                            }
                            OpenDatabase.OpenDB(string, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iWorkbenchPartSite);
                        }
                    });
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            path.schedule();
            super.okPressed();
        }

        private class ViewContentProvider
        implements IStructuredContentProvider {
            ArrayList<String> files;
            private final List<String> fileExtensions = Arrays.asList("c", "h", "txt", "a", "ada", "adb", "ads", "bas", "bat", "cbl", ".c", "cgi", "cob", "cpl", "cpp", "cpy", "cs", "css", "cxx", "dfm", "dpr", "f", "fo3", "f77", "f90", "f95", "for", "ftn", "gpr", "h", "hh", "hpp", "htm", "html", "hxx", "inl", "java", "jov", "js", "m", "mm", "pas", "php", "pl", "plm", "pm", "py", "s", "sp", "sql", "tcl", "txt", "v", "vh", "vhd", "vhdl", "xml");

            private ViewContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                if (object2 != null && object2 instanceof IProject) {
                    this.files = new ArrayList();
                    this.recurseAddPaths((IContainer)object2);
                }
            }

            public Object[] getElements(Object object) {
                return this.files.toArray();
            }

            private void recurseAddPaths(IContainer iContainer) {
                try {
                    for (IResource iResource : iContainer.members()) {
                        if (iResource.getType() == 1 && this.fileExtensions.contains(iResource.getFileExtension())) {
                            this.files.add(((IFile)iResource).getLocation().toOSString());
                            continue;
                        }
                        if (!(iResource instanceof IContainer)) continue;
                        this.recurseAddPaths((IContainer)iResource);
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
        }

        private class ViewLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private ViewLabelProvider() {
            }

            public Image getColumnImage(Object object, int n) {
                return null;
            }

            public String getColumnText(Object object, int n) {
                return (String)object;
            }
        }
    }
}

