/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin.commands;

import com.scitools.understand.Database;
import com.scitools.understand.Understand;
import com.scitools.understand.UnderstandException;
import com.scitools.understand.plugin.Activator;
import com.scitools.understand.plugin.Messages;
import java.io.IOException;
import java.util.Scanner;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class Analyze
extends AbstractHandler
implements IHandler,
IJobChangeListener {
    private String dbname;
    private String error;
    private Display disp;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Database database = Activator.getDefault().getCurrentDatabase();
        if (database != null) {
            this.dbname = database.name();
            this.error = null;
            this.disp = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent).getDisplay();
            final String string = executionEvent.getParameter("com.scitools.understand.plugin.analyzeParam");
            Activator.getDefault().closeCurrentDatabase();
            Job job = new Job(Messages.Analyze_0){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(Messages.Analyze_1, -1);
                    String[] stringArray = new String[]{"und", "-db", Analyze.this.dbname, "analyze", string};
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                        Process process = processBuilder.start();
                        int n = process.waitFor();
                        if (n != 0) {
                            Analyze.this.processError(process, Analyze.this.dbname);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)this);
            job.schedule();
        }
        return null;
    }

    public boolean isEnabled() {
        return Activator.getDefault().getCurrentDatabase() != null;
    }

    private void processError(Process process, String string) {
        Scanner scanner = new Scanner(process.getErrorStream());
        scanner.useDelimiter("\\A");
        String string2 = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        this.error = Messages.Analyze_2 + this.dbname + Messages.Analyze_3 + string2;
    }

    private void reopenDB() {
        this.disp.syncExec(new Runnable(){

            @Override
            public void run() {
                Database database = null;
                try {
                    database = Understand.open(Analyze.this.dbname);
                }
                catch (UnderstandException understandException) {
                    database = null;
                    Analyze.this.error = Messages.Analyze_2 + Analyze.this.dbname + Messages.Analyze_3 + understandException.getMessage();
                }
                if (database != null) {
                    Activator.getDefault().setCurrentDatabase(database);
                }
                if (Analyze.this.error != null) {
                    MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                    messageBox.setMessage(Messages.Analyze_4 + Analyze.this.dbname + Messages.Analyze_5 + Analyze.this.error);
                    messageBox.open();
                }
            }
        });
    }

    public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
    }

    public void awake(IJobChangeEvent iJobChangeEvent) {
    }

    public void done(IJobChangeEvent iJobChangeEvent) {
        if (this.error != null) {
            System.out.println(this.error);
        }
        this.reopenDB();
    }

    public void running(IJobChangeEvent iJobChangeEvent) {
    }

    public void scheduled(IJobChangeEvent iJobChangeEvent) {
    }

    public void sleeping(IJobChangeEvent iJobChangeEvent) {
    }
}

