/*
 * Decompiled with CFR 0.152.
 */
package com.scitools.understand.plugin;

import com.scitools.understand.Database;
import com.scitools.understand.Entity;
import com.scitools.understand.Reference;
import com.scitools.understand.plugin.IUnderstandDatabaseListener;
import com.scitools.understand.plugin.TextToEntityAdaptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.scitools.understand.plugin";
    private static Activator plugin;
    private Database currentDb = null;
    private List<IUnderstandDatabaseListener> dbListeners = new ArrayList<IUnderstandDatabaseListener>();

    public void addDatabaseListener(IUnderstandDatabaseListener iUnderstandDatabaseListener) {
        this.dbListeners.add(iUnderstandDatabaseListener);
    }

    public void removeDatabaseListener(IUnderstandDatabaseListener iUnderstandDatabaseListener) {
        this.dbListeners.remove(iUnderstandDatabaseListener);
    }

    public Database getCurrentDatabase() {
        return this.currentDb;
    }

    public void setCurrentDatabase(Database database) {
        this.currentDb = database;
        for (IUnderstandDatabaseListener iUnderstandDatabaseListener : this.dbListeners) {
            iUnderstandDatabaseListener.currentDatabaseChanged(this.currentDb);
        }
    }

    public void closeCurrentDatabase() {
        if (this.currentDb != null) {
            for (IUnderstandDatabaseListener iUnderstandDatabaseListener : this.dbListeners) {
                iUnderstandDatabaseListener.databaseAboutToClose();
            }
            this.currentDb.close();
            this.currentDb = null;
        }
    }

    public void openEditor(String string, final int n, int n2, final String string2) {
        Path path = new Path(string);
        final IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile != null) {
            final IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
            UIJob uIJob = new UIJob("OpenEditorForEntity"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    block10: {
                        IWorkbenchPage iWorkbenchPage;
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                            try {
                                IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId());
                                if (!(iEditorPart instanceof ITextEditor)) break block10;
                                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                                IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                                FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
                                if (iDocument == null) break block10;
                                IRegion iRegion = null;
                                try {
                                    iRegion = iDocument.getLineInformation(n - 1);
                                    if (string2 != null && !string2.isEmpty()) {
                                        iRegion = findReplaceDocumentAdapter.find(iRegion.getOffset(), string2, true, true, true, false);
                                    }
                                    if (iRegion != null && iDocument.getLineOfOffset(iRegion.getOffset()) != n - 1) {
                                        iRegion = iDocument.getLineInformation(n - 1);
                                    } else if (iRegion == null) {
                                        iRegion = iDocument.getLineInformation(n - 1);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                                if (iRegion != null) {
                                    iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                                }
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
            };
            uIJob.runInUIThread(null);
        } else {
            final File file = new File(string);
            if (file.exists() && file.isFile()) {
                UIJob uIJob = new UIJob("OpenEditorForEntity"){

                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        block9: {
                            IWorkbenchPage iWorkbenchPage;
                            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                                try {
                                    IEditorPart iEditorPart = IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
                                    if (!(iEditorPart instanceof ITextEditor)) break block9;
                                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                                    IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                                    FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
                                    if (iDocument == null) break block9;
                                    IRegion iRegion = null;
                                    try {
                                        iRegion = iDocument.getLineInformation(n - 1);
                                        iRegion = findReplaceDocumentAdapter.find(iRegion.getOffset(), string2, true, true, true, false);
                                        if (iRegion != null && iDocument.getLineOfOffset(iRegion.getOffset()) != n - 1) {
                                            iRegion = iDocument.getLineInformation(n - 1);
                                        } else if (iRegion == null) {
                                            iRegion = iDocument.getLineInformation(n - 1);
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                    if (iRegion != null) {
                                        iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                                    }
                                }
                                catch (PartInitException partInitException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                };
                uIJob.runInUIThread(null);
            }
        }
    }

    public void jumpToDefinition(Entity entity) {
        Reference[] referenceArray = entity.refs("definein", null, true);
        if (referenceArray.length == 0) {
            return;
        }
        Reference reference = referenceArray[0];
        this.openEditor(reference.file().longname(false), reference.line(), reference.column(), entity.simplename());
    }

    public Entity entFromSelection(ISelection iSelection) {
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                Entity entity = null;
                if (e instanceof Entity) {
                    entity = (Entity)e;
                } else if (e instanceof IAdaptable) {
                    entity = (Entity)((IAdaptable)e).getAdapter(Entity.class);
                }
                if (entity == null) continue;
                return entity;
            }
        } else if (iSelection instanceof ITextSelection) {
            TextToEntityAdaptor textToEntityAdaptor = new TextToEntityAdaptor();
            return (Entity)textToEntityAdaptor.getAdapter(iSelection, Entity.class);
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.closeCurrentDatabase();
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }
}

