/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.transport.Headers;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;

final class HttpClientTransport {
    private static final byte[] THROW_AWAY_BUFFER = new byte[8192];
    int statusCode;
    String statusMessage;
    int contentLength;
    private final Map<String, List<String>> reqHeaders;
    private Map<String, List<String>> respHeaders = null;
    private OutputStream outputStream;
    private boolean https;
    private HttpURLConnection httpConnection = null;
    private final EndpointAddress endpoint;
    private final Packet context;
    private final Integer chunkSize;

    public HttpClientTransport(@NotNull Packet packet, @NotNull Map<String, List<String>> map) {
        this.endpoint = packet.endpointAddress;
        this.context = packet;
        this.reqHeaders = map;
        this.chunkSize = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size");
    }

    OutputStream getOutput() {
        try {
            this.createHttpConnection();
            if (this.requiresOutputStream()) {
                List<String> list;
                this.outputStream = this.httpConnection.getOutputStream();
                if (this.chunkSize != null) {
                    this.outputStream = new WSChunkedOuputStream(this.outputStream, this.chunkSize);
                }
                if ((list = this.reqHeaders.get("Content-Encoding")) != null && list.get(0).contains("gzip")) {
                    this.outputStream = new GZIPOutputStream(this.outputStream);
                }
            }
            this.httpConnection.connect();
        }
        catch (Exception exception) {
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(exception), (Throwable)exception);
        }
        return this.outputStream;
    }

    void closeOutput() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    @Nullable
    InputStream getInput() {
        InputStream inputStream;
        try {
            String string;
            inputStream = this.readResponse();
            if (inputStream != null && (string = this.httpConnection.getContentEncoding()) != null && string.contains("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.statusMessage), (Throwable)iOException);
        }
        return inputStream;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        this.respHeaders = new Headers();
        this.respHeaders.putAll(this.httpConnection.getHeaderFields());
        return this.respHeaders;
    }

    @Nullable
    protected InputStream readResponse() {
        InputStream inputStream;
        try {
            inputStream = this.httpConnection.getInputStream();
        }
        catch (IOException iOException) {
            inputStream = this.httpConnection.getErrorStream();
        }
        if (inputStream == null) {
            return inputStream;
        }
        final InputStream inputStream2 = inputStream;
        return new FilterInputStream(inputStream2){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    while (inputStream2.read(THROW_AWAY_BUFFER) != -1) {
                    }
                    super.close();
                }
            }
        };
    }

    protected void readResponseCodeAndMessage() {
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            this.statusMessage = this.httpConnection.getResponseMessage();
            this.contentLength = this.httpConnection.getContentLength();
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    private void createHttpConnection() throws IOException {
        Integer n;
        Object object;
        Object object2;
        String string;
        this.httpConnection = (HttpURLConnection)this.endpoint.openConnection();
        String string2 = this.endpoint.getURI().getScheme();
        if (string2.equals("https")) {
            this.https = true;
        }
        if (this.httpConnection instanceof HttpsURLConnection) {
            this.https = true;
            boolean bl = false;
            string = (String)this.context.invocationProperties.get("com.sun.xml.internal.ws.client.http.HostnameVerificationProperty");
            if (string != null && string.equalsIgnoreCase("true")) {
                bl = true;
            }
            if (bl) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier(new HttpClientVerifier());
            }
            if ((object2 = (HostnameVerifier)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.https.client.hostname.verifier")) != null) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier((HostnameVerifier)object2);
            }
            if ((object = (SSLSocketFactory)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory")) != null) {
                ((HttpsURLConnection)this.httpConnection).setSSLSocketFactory((SSLSocketFactory)object);
            }
        }
        this.httpConnection.setAllowUserInteraction(true);
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setDoInput(true);
        String string3 = (String)this.context.invocationProperties.get("javax.xml.ws.http.request.method");
        string = string3 != null ? string3 : "POST";
        this.httpConnection.setRequestMethod(string);
        object2 = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.request.timeout");
        if (object2 != null) {
            this.httpConnection.setReadTimeout((Integer)object2);
        }
        if ((object = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.connect.timeout")) != null) {
            this.httpConnection.setConnectTimeout((Integer)object);
        }
        if ((n = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size")) != null) {
            this.httpConnection.setChunkedStreamingMode(n);
        }
        for (Map.Entry<String, List<String>> entry : this.reqHeaders.entrySet()) {
            for (String string4 : entry.getValue()) {
                this.httpConnection.addRequestProperty(entry.getKey(), string4);
            }
        }
    }

    boolean isSecure() {
        return this.https;
    }

    private boolean requiresOutputStream() {
        return !this.httpConnection.getRequestMethod().equalsIgnoreCase("GET") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("HEAD") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("DELETE");
    }

    @Nullable
    String getContentType() {
        return this.httpConnection.getContentType();
    }

    static {
        try {
            JAXBContext.newInstance(new Class[0]).createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    private static class HttpClientVerifier
    implements HostnameVerifier {
        private HttpClientVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    private static final class WSChunkedOuputStream
    extends FilterOutputStream {
        final int chunkSize;

        WSChunkedOuputStream(OutputStream outputStream, int n) {
            super(outputStream);
            this.chunkSize = n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = n2 > this.chunkSize ? this.chunkSize : n2;
                this.out.write(byArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }
}

