/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CP;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.Slider;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Textarea
extends ControllerGroup<Textarea>
implements ControlListener {
    protected String _myText;
    protected Slider _myScrollbar;
    protected int _myColorBackground = 0;
    protected boolean isColorBackground = false;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    protected int _myBottomOffset = 4;
    private int _myScrollbarWidth = 5;

    public Textarea(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, "", 0, 0, 199, 99);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Textarea(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, String string2, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myWidth = n3;
        this._myHeight = n4;
        this._myText = string2;
        this.setup();
    }

    public Textarea(String string, int n, int n2) {
        super(n, n2);
        this._myText = string;
        this.setup();
    }

    private void setup() {
        this._myValueLabel = new Label(this.cp5, this._myText);
        this._myValueLabel.setFont(this.cp5.controlFont == this.cp5.defaultFont ? this.cp5.defaultFontForText : this.cp5.controlFont);
        this._myValueLabel.setWidth(this._myWidth);
        this._myValueLabel.setHeight(this._myHeight);
        this._myValueLabel.setMultiline(true);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myScrollbar = new Slider(this.cp5, this._myParent, this.getName() + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth - 5, 0, 5, this._myHeight);
        this._myScrollbar.init();
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.isMoveable = false;
        this._myScrollbar.isLabelVisible = false;
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this.add(this._myScrollbar);
        this.setWidth(this._myWidth);
        this.setHeight(this._myHeight);
        this._myScrollbar.color.set(this.color);
        this._myScrollbar.setColorBackground(0);
        this._myScrollbar.setHandleSize(40);
    }

    @Override
    public void controlEvent(ControlEvent controlEvent) {
        this._myScrollValue = -(1.0f - controlEvent.getValue());
        this.scroll();
    }

    public Textarea hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
        return this;
    }

    public Textarea showScrollbar() {
        boolean bl;
        this.isScrollbarVisible = true;
        boolean bl2 = bl = this._myHeight < this._myValueLabel.getTextHeight() + this._myValueLabel.getLineHeight();
        if (bl) {
            this._myScrollbar.show();
        }
        return this;
    }

    public boolean isScrollable() {
        return this._myScrollbar.isVisible();
    }

    @Override
    public Textarea setColorBackground(int n) {
        this._myColorBackground = n;
        this.isColorBackground = true;
        return this;
    }

    public Textarea disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Textarea enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public Textarea scroll(float f) {
        this._myScrollbar.setValue(1.0f - f);
        return this;
    }

    private void scroll() {
        boolean bl;
        this._myScrollValue = PApplet.min((float)PApplet.max((float)-1.0f, (float)this._myScrollValue), (float)0.0f);
        float f = this._myValueLabel.getTextHeight() + this._myValueLabel.getLineHeight();
        float f2 = 0.0f;
        boolean bl2 = bl = (float)this._myHeight < f;
        if (bl) {
            f2 = this._myScrollValue * (f - (float)this._myHeight + (float)this._myBottomOffset);
        }
        bl = this.isScrollbarVisible ? bl : false;
        this._myScrollbar.setVisible(bl);
        this._myValueLabel.setOffsetYratio(this._myScrollValue);
    }

    @ControlP5.Invisible
    public void scrolled(int n) {
        if (this._myScrollbar.isVisible()) {
            int n2 = this._myValueLabel.getTextHeight() / this._myValueLabel.getLineHeight();
            float f = 1.0f / (float)n2;
            this.scroll(1.0f - this.getScrollPosition() + (float)n * f);
        }
    }

    @ControlP5.Invisible
    public float getScrollPosition() {
        return this._myScrollbar.getValue();
    }

    @Override
    public Textarea setWidth(int n) {
        this._myWidth = n = n < 10 ? 10 : n;
        this._myValueLabel.setWidth(this._myWidth - this._myScrollbarWidth - 10);
        return this;
    }

    @Override
    public Textarea setHeight(int n) {
        this._myHeight = n = n < 10 ? 10 : n;
        this._myValueLabel.setHeight(this._myHeight - 2);
        this._myScrollbar.setHeight(n);
        return this;
    }

    @Override
    public Textarea setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
        return this;
    }

    public Textarea setLineHeight(int n) {
        this._myValueLabel.setLineHeight(n);
        this.scroll();
        return this;
    }

    public Textarea setColor(int n) {
        this._myValueLabel.setColor(n, true);
        return this;
    }

    @Override
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    public Textarea setText(String string) {
        this._myValueLabel.set(string);
        this._myScrollValue = (float)this._myHeight / (float)this._myValueLabel.getTextHeight();
        this._myScrollbar.setHeight(this._myHeight + this._myValueLabel.getStyle().paddingTop + this._myValueLabel.getStyle().paddingBottom);
        return this;
    }

    public Textarea clear() {
        return this.setText("");
    }

    public Textarea append(String string) {
        return this.setText(this.getText() + string);
    }

    public Textarea append(String string, int n) {
        String string2 = this.getText() + string;
        if (n == -1) {
            return this.setText(string2);
        }
        List<String> list = Arrays.asList(string2.split("\n"));
        return this.setText(CP.join(list.subList(Math.max(0, list.size() - n), list.size()), "\n"));
    }

    public String getText() {
        return this.getStringValue();
    }

    @Override
    protected void preDraw(PApplet pApplet) {
        if (this.isScrollbarVisible) {
            this._myScrollbar.setVisible(this._myValueLabel.getOverflow() > 1);
        }
        if (this._myScrollbar.isVisible() || this.isColorBackground) {
            int n;
            this._myScrollbar.getPosition().x = this._myWidth - this._myScrollbarWidth + this._myValueLabel.getStyle().paddingLeft + this._myValueLabel.getStyle().paddingRight;
            if (!this.isColorBackground) {
                pApplet.noFill();
            } else {
                n = this._myColorBackground >> 24 & 0xFF;
                pApplet.fill(this._myColorBackground, n > 0 ? (float)n : 255.0f);
            }
            n = this._myWidth + this._myValueLabel.getStyle().paddingLeft + this._myValueLabel.getStyle().paddingRight;
            int n2 = this._myHeight + this._myValueLabel.getStyle().paddingTop + this._myValueLabel.getStyle().paddingBottom;
            pApplet.rect(0.0f, 0.0f, (float)n, (float)n2);
        }
    }

    @Override
    protected boolean inside() {
        return (float)this.cp5.getWindow().mouseX > this.position.x + this._myParent.absolutePosition.x && (float)this.cp5.getWindow().mouseX < this.position.x + this._myParent.absolutePosition.x + (float)this._myWidth && (float)this.cp5.getWindow().mouseY > this.position.y + this._myParent.absolutePosition.y && (float)this.cp5.getWindow().mouseY < this.position.y + this._myParent.absolutePosition.y + (float)this._myHeight;
    }

    @Override
    public String getStringValue() {
        return this._myValueLabel.getText();
    }

    public Textarea setFont(ControlFont controlFont) {
        this.getValueLabel().setFont(controlFont);
        return this;
    }

    public Textarea setFont(PFont pFont) {
        this.getValueLabel().setFont(pFont);
        return this;
    }

    public Textarea setFont(int n) {
        this.getValueLabel().setFont(n);
        return this;
    }

    public Textarea setScrollBackground(int n) {
        this._myScrollbar.setColorBackground(n);
        return this;
    }

    public Textarea setScrollForeground(int n) {
        this._myScrollbar.setColorForeground(n);
        return this;
    }

    public Textarea setScrollActive(int n) {
        this._myScrollbar.setColorActive(n);
        return this;
    }

    public Textarea setBorderColor(int n) {
        this.color.setBackground(n);
        return this;
    }

    @Override
    public float getValue() {
        return 0.0f;
    }

    @Override
    @Deprecated
    public float value() {
        return 0.0f;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Override
    @Deprecated
    public Label valueLabel() {
        return this.getValueLabel();
    }

    @Deprecated
    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    @Deprecated
    public String text() {
        return this.getText();
    }
}

