/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class SmartBlurFilter {
    private double SENSITIVITY = 10.0;
    private int REGION_SIZE = 5;
    float[] kernelArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    Kernel kernel = new Kernel(14, 14, this.normalizeKernel(this.kernelArray));

    float[] normalizeKernel(float[] fArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < fArray.length) {
            n = (int)((float)n + fArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < fArray.length) {
            int n3 = n2++;
            fArray[n3] = fArray[n3] / (float)n;
        }
        return fArray;
    }

    public double lerp(double d, double d2, double d3) {
        return d + d3 * (d2 - d);
    }

    public double getLerpAmount(double d, double d2) {
        if (d > d2) {
            return 1.0;
        }
        return d / d2;
    }

    public double rmsError(int[] nArray) {
        double d = 0.0;
        int n = 0;
        while (n < nArray.length) {
            d += (double)(nArray[n] >> 8 & 0xFF);
            ++n;
        }
        d /= (double)nArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < nArray.length) {
            d2 = (double)(nArray[n2] >> 8 & 0xFF) - d;
            d2 *= d2;
            d3 += d2;
            ++n2;
        }
        double d4 = d3 / (double)nArray.length;
        d4 = Math.sqrt(d4);
        return d4;
    }

    int[] getSample(BufferedImage bufferedImage, int n, int n2, int n3) {
        int[] nArray = new int[]{};
        try {
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(n, n2, n3, n3);
            nArray = bufferedImage2.getRGB(0, 0, n3, n3, null, 0, n3);
        }
        catch (Exception exception) {}
        return nArray;
    }

    int lerpPixel(int n, int n2, double d) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = (int)this.lerp(n3, n4, d) & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = (int)this.lerp(n6, n7, d) & 0xFF;
        int n9 = n & 0xFF;
        int n10 = n2 & 0xFF;
        int n11 = (int)this.lerp(n9, n10, d) & 0xFF;
        return n5 << 16 | n8 << 8 | n11;
    }

    int[] blurImage(BufferedImage bufferedImage, int[] nArray, int[] nArray2, double d) {
        int n = 0;
        double d2 = 0.0;
        int n2 = this.REGION_SIZE;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = bufferedImage.getWidth();
            int[] nArray3 = this.getSample(bufferedImage, n3 % n4, n3 / n4, n2);
            if (nArray3.length != 0) {
                d2 = this.getLerpAmount(this.rmsError(nArray3), d);
                nArray[n3] = n = this.lerpPixel(nArray2[n3], nArray[n3], d2);
            }
            ++n3;
        }
        return nArray;
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        ConvolveOp convolveOp = new ConvolveOp(this.kernel, 1, null);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        bufferedImage2 = convolveOp.filter(bufferedImage2, bufferedImage);
        int[] nArray2 = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
        nArray = this.blurImage(bufferedImage, nArray, nArray2, this.SENSITIVITY);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    public void setRadius(int n) {
        this.REGION_SIZE = n;
    }

    public void setThreshold(double d) {
        this.SENSITIVITY = d;
    }

    public int getRadius() {
        return this.REGION_SIZE;
    }

    public double getThreshold() {
        return this.SENSITIVITY;
    }
}

