/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public class GLReadBufferUtil {
    protected final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider;
    protected final int componentCount;
    protected final int alignment;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected GLPixelBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this(GLPixelBuffer.defaultProviderNoRowStride, bl, bl2);
    }

    public GLReadBufferUtil(GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider, boolean bl, boolean bl2) {
        this.pixelBufferProvider = gLPixelBufferProvider;
        this.componentCount = bl ? 4 : 3;
        this.alignment = bl ? 4 : 1;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
    }

    public GLPixelBuffer.GLPixelBufferProvider getPixelBufferProvider() {
        return this.pixelBufferProvider;
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer && this.readPixelBuffer.isValid();
    }

    public boolean hasAlpha() {
        return 4 == this.componentCount;
    }

    public GLPixelStorageModes getGLPixelStorageModes() {
        return this.psm;
    }

    public GLPixelBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public boolean readPixels(GL gL, boolean bl) {
        return this.readPixels(gL, 0, 0, 0, 0, bl);
    }

    public boolean readPixels(GL gL, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        int n5 = gL.glGetError();
        if (0 != n5) {
            System.err.println("Info: GLReadBufferUtil.readPixels: pre-exisiting GL error 0x" + Integer.toHexString(n5));
        }
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.pixelBufferProvider.getAttributes(gL, this.componentCount);
        int n6 = gL.isGL2GL3() && 3 == this.componentCount ? 6407 : (4 == this.componentCount ? 6408 : 6407);
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        int n7 = 0 >= n3 || gLDrawable.getWidth() < n3 ? gLDrawable.getWidth() : n3;
        int n8 = 0 >= n4 || gLDrawable.getHeight() < n4 ? gLDrawable.getHeight() : n4;
        boolean bl3 = gLDrawable.isGLOriented() ? bl : !bl;
        int[] nArray = new int[1];
        int n9 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.bytesPerPixel, n7, n8, 1, true);
        boolean bl4 = false;
        if (null == this.readPixelBuffer || this.readPixelBuffer.requiresNewBuffer(gL, n7, n8, n9)) {
            this.readPixelBuffer = this.pixelBufferProvider.allocate(gL, gLPixelAttributes, n7, n8, 1, true, n9);
            Buffers.rangeCheckBytes((Object)this.readPixelBuffer.buffer, (int)n9);
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n6, n7, n8, 0, gLPixelAttributes, false, false, bl3, this.readPixelBuffer.buffer, null);
                bl4 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        } else {
            this.readTextureData.setInternalFormat(n6);
            this.readTextureData.setWidth(n7);
            this.readTextureData.setHeight(n8);
            this.readTextureData.setPixelAttributes(gLPixelAttributes);
        }
        boolean bl5 = bl2 = null != this.readPixelBuffer && this.readPixelBuffer.isValid();
        if (bl2) {
            this.psm.setAlignment(gL, this.alignment, this.alignment);
            if (gL.isGL2GL3()) {
                gL.getGL2GL3().glPixelStorei(3330, this.readPixelBuffer.width);
            }
            this.readPixelBuffer.clear();
            try {
                gL.glReadPixels(n, n2, n7, n8, gLPixelAttributes.format, gLPixelAttributes.type, this.readPixelBuffer.buffer);
            }
            catch (GLException gLException) {
                bl2 = false;
                gLException.printStackTrace();
            }
            this.readPixelBuffer.position(n9);
            this.readPixelBuffer.flip();
            int n10 = gL.glGetError();
            if (0 != n10) {
                System.err.println("GLReadBufferUtil.readPixels: readPixels error 0x" + Integer.toHexString(n10) + " " + n7 + "x" + n8 + ", " + gLPixelAttributes + ", " + this.readPixelBuffer + ", sz " + n9);
                bl2 = false;
            }
            if (bl2 && null != this.readTexture) {
                if (bl4) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, n7, n8);
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
        return bl2;
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.dispose();
            this.readPixelBuffer = null;
        }
    }
}

