/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.cache.CachedManifest;
import com.sun.deploy.cache.IndexFileObjectInputStream;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.TrustedLibraries;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.security.pkcs.ParsingException;

public class CacheEntry
implements Resource {
    private static final String ABSOLUTE_PATH_ESCAPE_CHAR = "\t";
    public static int INCOMPLETE_FALSE = 0;
    public static int INCOMPLETE_TRUE = 1;
    public static int INCOMPLETE_ONHOLD = 2;
    public static int BUSY_FALSE = 0;
    public static int BUSY_TRUE = 1;
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = BUSY_TRUE;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private int isProxiedHost = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private long validationTimestampt = 0L;
    private long certExpirationDate = 0L;
    private boolean knownToBeSigned = false;
    private long blacklistValidationTime = 0L;
    private long trustedLibrariesValidationTime = 0L;
    private byte classVerificationStatus = 0;
    Map checkedJars = null;
    private boolean hasOnlySignedEntries = false;
    private boolean hasSingleCodeSource = false;
    private boolean hasMissingSignedEntries = false;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section4CertsLength = 0;
    private int section4SignersLength = 0;
    private int section4Pre15Length = 0;
    private int section5Length = 0;
    private int reducedManifestLength = 0;
    private int reducedManifest2Length = 0;
    private SoftReference manifestRef = null;
    private boolean doneReadManifest = false;
    private SoftReference signingDataRef = new SoftReference<Object>(null);
    private WeakReference jarRef = new WeakReference<Object>(null);
    private static boolean enhancedJarAccess = false;
    private volatile URL _url;

    static boolean hasEnhancedJarAccess() {
        return enhancedJarAccess;
    }

    void verifyJAR(URLClassLoader uRLClassLoader) {
        JarFile jarFile = this.getJarFile();
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string == null || !string.endsWith(".class")) continue;
            try {
                String string2 = string.substring(0, string.lastIndexOf(".class"));
                Class<?> clazz = Class.forName(string2.replace('/', '.'), false, uRLClassLoader);
                bl = true;
            }
            catch (Throwable throwable) {
                String string3;
                boolean bl3 = false;
                String string4 = string3 = throwable.getMessage() != null ? throwable.getMessage().replace('/', '.') : throwable.getClass().getName();
                if (string3 != null && (string3.indexOf("com.sun.media.jmcimpl.JMFPlayerPeer") != -1 || string3.indexOf("javafx.fxunit.FXTestCase") != -1 || string3.indexOf("javax.media.ControllerListener") != -1 || string3.indexOf("junit.framework.TestCase") != -1)) {
                    try {
                        URL uRL = new URL(this.getURL());
                        String string5 = uRL.getHost();
                        if (string5.equals("dl.javafx.com")) {
                            Trace.println("CacheEntry:  Skipped verification for class " + string3 + " in " + this.getURL(), TraceLevel.CACHE);
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Environment.allowAltJavaFxRuntimeURL()) {
                    bl3 = true;
                    if (Trace.isEnabled(TraceLevel.CACHE)) {
                        throwable.printStackTrace();
                    }
                }
                if (bl3) continue;
                Trace.println("Class verification failed: " + throwable.getMessage() + " for " + this.getURL(), TraceLevel.CACHE);
                bl2 = true;
                break;
            }
        }
        if (bl && !bl2) {
            this.updateClassVerificationStatus((byte)1);
            Trace.println("CacheEntry:  Pre-verify done for all classes in " + this.getURL(), TraceLevel.CACHE);
            return;
        }
        this.updateClassVerificationStatus((byte)2);
        Trace.println("CacheEntry:  Cannot pre-verify all classes in " + this.getURL(), TraceLevel.CACHE);
    }

    long getCertificateExpiration() {
        return this.certExpirationDate;
    }

    private boolean isOKToUseCachedSecurityValidation() {
        if (System.currentTimeMillis() > this.certExpirationDate) {
            Trace.println(ResourceManager.getString("cacheEntry.certExpired", this.url, new Date(this.certExpirationDate).toString()), TraceLevel.SECURITY);
            return false;
        }
        if (Config.getBooleanProperty("deployment.security.validation.crl") || Config.getBooleanProperty("deployment.security.validation.ocsp")) {
            Trace.println("Certificate revocation enabled. Disable security validation optimizations.", TraceLevel.SECURITY);
            return false;
        }
        return true;
    }

    public synchronized long getValidationTimestamp() {
        if (!this.isOKToUseCachedSecurityValidation()) {
            this.resetValidationResults();
        }
        return this.validationTimestampt;
    }

    private synchronized void resetValidationResults() {
        this.knownToBeSigned = false;
        this.validationTimestampt = 0L;
    }

    private void updateBlacklistValidation() {
        this.resetValidationResults();
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            this.blacklistValidationTime = System.currentTimeMillis();
        }
    }

    private void updateTrustedLibrariesValidation() {
        this.trustedLibrariesValidationTime = System.currentTimeMillis();
    }

    public synchronized boolean isKnownToBeSigned() {
        if (this.knownToBeSigned && !this.isOKToUseCachedSecurityValidation()) {
            Trace.println(ResourceManager.getString("cacheEntry.resetValidation", this.url), TraceLevel.SECURITY);
            this.resetValidationResults();
        }
        return this.knownToBeSigned;
    }

    public synchronized byte getClassesVerificationStatus() {
        return this.classVerificationStatus;
    }

    private synchronized void updateClassVerificationStatus(byte by) {
        this.classVerificationStatus = by;
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update Class Verification result in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    boolean hasSigningInfo() {
        return this.section4Length > 15;
    }

    public void updateValidationResults(boolean bl, Map map, long l, long l2, boolean bl2) {
        Map map2;
        JarSigningData jarSigningData = this.getJarSigningData();
        if (jarSigningData == null) {
            return;
        }
        Map map3 = map2 = Config.isJavaVersionAtLeast15() ? jarSigningData.getSignerMap() : jarSigningData.getCertificateMap();
        if (map2 != null && this.hasStrictSingleSigning()) {
            Trace.println("updateValidationResultsForApplet update", TraceLevel.BASIC);
            this.updateValidationResults(bl, map, l, l2);
        }
    }

    private synchronized void updateValidationResults(boolean bl, Map map, long l, long l2) {
        this.knownToBeSigned = bl;
        this.validationTimestampt = l;
        this.certExpirationDate = l2;
        this.checkedJars = map;
        Trace.println("Mark prevalidated: " + this.url + " " + bl + " tm=" + l + " cert=" + l2, TraceLevel.CACHE);
        try {
            this.updateSecurityValidationCache();
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update list of trusted cached entries in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    private void updateSecurityValidationCache() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.section5Length = 0;
                            if (CacheEntry.this.checkedJars != null && !CacheEntry.this.checkedJars.isEmpty()) {
                                Object object;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
                                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                Set set = CacheEntry.this.checkedJars.entrySet();
                                dataOutputStream.writeInt(set.size());
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    dataOutputStream.writeUTF((String)object.getKey());
                                    dataOutputStream.writeLong((Long)object.getValue());
                                }
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                object = byteArrayOutputStream.toByteArray();
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                                randomAccessFile.write((byte[])object);
                                CacheEntry.this.section5Length = ((Object)object).length;
                            }
                        }
                        finally {
                            if (randomAccessFile != null) {
                                CacheEntry.this.doUpdateHeader(randomAccessFile);
                                randomAccessFile.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSecurityValidationCache() throws IOException {
        if (this.section5Length != 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        byte[] byArray = new byte[CacheEntry.this.section5Length];
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                        try {
                            randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                            randomAccessFile.readFully(byArray);
                        }
                        finally {
                            randomAccessFile.close();
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (int i = dataInputStream.readInt(); i > 0; --i) {
                            String string = dataInputStream.readUTF();
                            Long l = new Long(dataInputStream.readLong());
                            hashMap.put(string, l);
                        }
                        CacheEntry.this.checkedJars = hashMap;
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) return;
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            this.checkedJars = null;
        }
    }

    public synchronized Map getCachedTrustedEntries() {
        if (this.section5Length == 0 && this.checkedJars == null) {
            return null;
        }
        if (this.checkedJars == null) {
            try {
                this.readSecurityValidationCache();
            }
            catch (IOException iOException) {
                Trace.println("Failed to read list of trusted cached entries from index", TraceLevel.CACHE);
                Trace.ignoredException(iOException);
            }
        }
        return this.checkedJars;
    }

    private void invalidateEntryDueToException(Throwable throwable) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(throwable);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(INCOMPLETE_TRUE);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    void markIncompleteOnHold() {
        this.setBusy(BUSY_TRUE);
        this.invalidateEntry();
        this.setIncomplete(INCOMPLETE_ONHOLD);
    }

    public CacheEntry(File file) {
        this(file, false);
    }

    CacheEntry(File file, final boolean bl) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CacheEntry.this.readIndexFile(bl);
                }
                catch (Throwable throwable) {
                    CacheEntry.this.invalidateEntryDueToException(throwable);
                }
                return null;
            }
        });
    }

    synchronized void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        SyncFileAccess.FObjLock fObjLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            fObjLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 10000, bl);
            randomAccessFile = fObjLock != null ? ((SyncFileAccess.RandomAccessFileLock)fObjLock).getRandomAccessFile() : new RandomAccessFile(this.indexFile, string);
            RandomAccessFile randomAccessFile2 = randomAccessFile;
            return randomAccessFile2;
        }
        finally {
            if (fObjLock != null) {
                fObjLock.release();
            }
        }
    }

    private void readIndexFileOld(DataInputStream dataInputStream, RandomAccessFile randomAccessFile) throws IOException {
        if (!this.indexFile.exists()) {
            return;
        }
        switch (this.getCacheVersion()) {
            case 603: 
            case 604: {
                this.readSection1Remaining604(dataInputStream);
                this.readSection2(randomAccessFile);
                return;
            }
            case 605: {
                randomAccessFile.close();
                randomAccessFile = null;
                this.readIndexFile();
                return;
            }
            case 602: {
                this.readIndexFile602(randomAccessFile);
            }
        }
    }

    private void readIndexFile() {
        this.readIndexFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile(boolean bl) {
        RandomAccessFile randomAccessFile = null;
        IOException iOException = null;
        try {
            if (this.indexFile.exists()) {
                randomAccessFile = this.openLockIndexFile("r", false);
                byte[] byArray = new byte[128];
                int n = randomAccessFile.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, n));
                this.setBusy(dataInputStream.readByte());
                int n2 = dataInputStream.readByte();
                if (bl && n2 == INCOMPLETE_TRUE) {
                    n2 = INCOMPLETE_ONHOLD;
                }
                this.setIncomplete(n2);
                if (this.isIncomplete()) {
                    return;
                }
                this.setCacheVersion(dataInputStream.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion()) {
                    Trace.println("In-place upgrading old version " + this.getCacheVersion() + " file: " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld(dataInputStream, randomAccessFile);
                    randomAccessFile.close();
                    randomAccessFile = null;
                    this.saveUpgrade();
                    return;
                }
                this.readSection1Remaining(dataInputStream);
                this.readSection2(randomAccessFile);
                File file = new File(this.getResourceFilename());
                if (!this.isRedirectEntry() && !file.exists()) {
                    this.setIncomplete(INCOMPLETE_TRUE);
                    return;
                }
                if (this.hasSigningInfo() && (this.section4Pre15Length == 0 && enhancedJarAccess || BlackList.getInstance().hasBeenModifiedSince(this.blacklistValidationTime) || TrustedLibraries.hasBeenModifiedSince(this.trustedLibrariesValidationTime)) && (!Cache.isSystemCacheEntry(this) || Environment.isSystemCacheMode())) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                    this.saveUpgrade();
                    Trace.println("readIndexFile returning success", TraceLevel.CACHE);
                }
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException3) {
                Trace.ignoredException(iOException3);
            }
        }
        if (iOException != null) {
            this.invalidateEntryDueToException(iOException);
        }
    }

    void processRedirectData(URL uRL, CacheEntry cacheEntry) throws IOException {
        this.setBusy(BUSY_FALSE);
        this.setIncomplete(INCOMPLETE_FALSE);
        this.setURL(uRL.toString());
        this.setLastModified(cacheEntry.getLastModified());
        this.setExpirationDate(cacheEntry.getExpirationDate());
        this.setVersion(cacheEntry.getVersion());
        this.headerFields = new MessageHeader();
        this.headerFields.add(null, String.valueOf(302));
        this.headerFields.add("Location", cacheEntry.getURL().toString());
        this.setHeaders(this.headerFields);
        this.writeFileToDisk();
    }

    public synchronized void setBusy(int n) {
        this.busy = n;
    }

    synchronized int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public synchronized void setIncomplete(int n) {
        this.incomplete = n;
    }

    public synchronized int getIncomplete() {
        return this.incomplete;
    }

    boolean isIncomplete() {
        return this.getIncomplete() == INCOMPLETE_TRUE;
    }

    public synchronized boolean isValidEntry() {
        return this.busy == BUSY_FALSE && this.incomplete == INCOMPLETE_FALSE;
    }

    synchronized boolean storageFilesExist() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CacheEntry.this.filename != null && new File(CacheEntry.this.filename).exists() && CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public synchronized void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public synchronized int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    public synchronized void setIsProxied(int n) {
        this.isProxiedHost = n;
    }

    public synchronized int getIsProxied() {
        return this.isProxiedHost;
    }

    synchronized boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.isIncomplete()) {
            return true;
        }
        if (cacheEntry.isIncomplete()) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    synchronized void setContentLength(int n) {
        this.contentLength = n;
    }

    public synchronized int getContentLength() {
        return this.contentLength;
    }

    synchronized JarSigningData getJarSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = (JarSigningData)this.signingDataRef.get();
        if (jarSigningData == null) {
            jarSigningData = new JarSigningData(this.hasOnlySignedEntries, this.hasSingleCodeSource, this.hasMissingSignedEntries);
            try {
                this.readSigningData(jarSigningData);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readSigningData(jarSigningData);
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                    this.signingDataRef = null;
                }
            }
            if (this.signingDataRef != null) {
                this.signingDataRef = new SoftReference<JarSigningData>(jarSigningData);
            }
        }
        return jarSigningData;
    }

    synchronized boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    private synchronized void readSigningData(JarSigningData jarSigningData) throws IOException {
        if (Config.isJavaVersionAtLeast15()) {
            this.readSigners(jarSigningData);
        } else {
            this.readCertificates(jarSigningData);
        }
    }

    public synchronized Certificate[] getCertificates() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCertificates() : null;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSigners() : null;
    }

    synchronized void setLastModified(long l) {
        this.lastModified = l;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    synchronized void updateExpirationInIndexFile(long l) {
        if (this.getExpirationDate() == l) {
            return;
        }
        this.setExpirationDate(l);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public synchronized long getExpirationDate() {
        return this.expirationDate;
    }

    synchronized boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    synchronized void setURL(String string) {
        this.url = string;
    }

    public synchronized String getURL() {
        return this.url;
    }

    synchronized void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    synchronized JarFile getRefJar() {
        Object t;
        if (this.jarRef != null && (t = this.jarRef.get()) instanceof JarFile) {
            return (JarFile)t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile getJarFile() {
        if (this.isRedirectEntry()) {
            return null;
        }
        JarFile jarFile = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            Object t;
            if (this.jarRef != null && (t = this.jarRef.get()) instanceof JarFile) {
                return (JarFile)t;
            }
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        if (Config.isJavaVersionAtLeast15()) {
                            return new CachedJarFile(CacheEntry.this);
                        }
                        return new CachedJarFile14(CacheEntry.this);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        return null;
                    }
                }
            });
            this.jarRef = new WeakReference<JarFile>(jarFile);
        }
        MemoryCache.addResourceReference(jarFile, this.url);
        return jarFile;
    }

    public synchronized String getResourceFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataFile() {
        File file = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (!this.isRedirectEntry() && this.filename != null && !this.url.equals("")) {
                file = new File(this.filename);
            }
        }
        if (file != null) {
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    synchronized File getTempDataFile() {
        return this.tempDataFile;
    }

    public synchronized File getIndexFile() {
        return this.indexFile;
    }

    public synchronized long getSize() {
        long l = 0L;
        if (this.getDataFile() != null) {
            l += this.getDataFile().length();
        }
        if (this.getIndexFile() != null) {
            l += this.getIndexFile().length();
        }
        return l;
    }

    synchronized void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    MessageHeader cloneHeaders() {
        return new MessageHeader(this.headerFields);
    }

    public synchronized Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public synchronized boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    synchronized boolean processTempDataFile(boolean bl, DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            object = null;
            String string2 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!string3.startsWith("current-version-id")) continue;
                object = string3.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, (String)object);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), (String)object, string), TraceLevel.NETWORK);
                }
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CacheEntry.this.tempDataFile.delete();
                    return null;
                }
            });
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (((Boolean)(object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CacheEntry.this.tempDataFile.renameTo(new File(CacheEntry.this.filename));
            }
        }))).booleanValue()) {
            bl2 = true;
        }
        return bl2;
    }

    private void initFrom(CacheEntry cacheEntry) {
        Trace.println("Recovering CacheEntry for " + cacheEntry.getURL(), TraceLevel.CACHE);
        this.filename = cacheEntry.filename;
        this.indexFile = cacheEntry.indexFile;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CacheEntry.this.readIndexFile();
                return null;
            }
        });
    }

    private void recover() {
        Trace.println("Trying to recover cache entry for " + this.url, TraceLevel.CACHE);
        try {
            URL uRL = new URL(this.url);
            String string = this.getVersion();
            String string2 = this.getNamespaceID();
            MemoryCache.removeLoadedResource(this.url);
            Cache.removeCacheEntry(this, false);
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string);
            if (cacheEntry == null) {
                throw new RuntimeException("ERROR: Recovery got null entry");
            }
            this.initFrom(cacheEntry);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            throw new RuntimeException("ERROR: Failed to recover corrupt cache entry");
        }
    }

    public synchronized Manifest getManifest() {
        Manifest manifest;
        Manifest manifest2 = manifest = this.manifestRef != null ? (Manifest)this.manifestRef.get() : null;
        if (!this.doneReadManifest || this.manifestRef != null && manifest == null) {
            try {
                manifest = this.readManifest();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    manifest = this.readManifest();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
        }
        return manifest;
    }

    private synchronized void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public synchronized String getCodebaseIP() {
        return this.codebaseIP;
    }

    void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    public synchronized boolean isJarFile() {
        Map map = this.headerFields != null ? this.headerFields.getHeaders() : Collections.EMPTY_MAP;
        return HttpUtils.isJarFile(this.url, map);
    }

    public synchronized boolean isJNLPFile() {
        Map map = this.headerFields != null ? this.headerFields.getHeaders() : Collections.EMPTY_MAP;
        return HttpUtils.isJNLPFile(this.url, map);
    }

    public synchronized void updateIndexHeaderOnDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        if (CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                            RandomAccessFile randomAccessFile = null;
                            try {
                                randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                                CacheEntry.this.doUpdateHeader(randomAccessFile);
                            }
                            finally {
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void doUpdateHeader(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile != null) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(this.prepareHeader());
        }
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.busy);
        dataOutputStream.writeByte(this.incomplete);
        dataOutputStream.writeInt(this.cacheVersion);
        dataOutputStream.writeByte(this.isShortcutImage);
        dataOutputStream.writeInt(this.contentLength);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeLong(this.expirationDate);
        dataOutputStream.writeLong(this.validationTimestampt);
        dataOutputStream.writeByte(this.knownToBeSigned ? 1 : 0);
        dataOutputStream.writeInt(this.section2Length);
        dataOutputStream.writeInt(this.section3Length);
        dataOutputStream.writeInt(this.section4Length);
        dataOutputStream.writeInt(this.section5Length);
        dataOutputStream.writeLong(this.blacklistValidationTime);
        dataOutputStream.writeLong(this.certExpirationDate);
        dataOutputStream.writeByte(this.classVerificationStatus);
        dataOutputStream.writeInt(this.reducedManifestLength);
        dataOutputStream.writeInt(this.section4Pre15Length);
        dataOutputStream.writeByte(this.hasOnlySignedEntries ? 1 : 0);
        dataOutputStream.writeByte(this.hasSingleCodeSource ? 1 : 0);
        dataOutputStream.writeInt(this.section4CertsLength);
        dataOutputStream.writeInt(this.section4SignersLength);
        dataOutputStream.writeByte(this.hasMissingSignedEntries ? 1 : 0);
        dataOutputStream.writeLong(this.trustedLibrariesValidationTime);
        dataOutputStream.writeInt(this.reducedManifest2Length);
        dataOutputStream.writeByte(this.isProxiedHost);
        dataOutputStream.flush();
        if (byteArrayOutputStream.size() < 128) {
            byte[] byArray = new byte[128 - byteArrayOutputStream.size()];
            dataOutputStream.write(byArray);
        } else {
            Trace.println("Incorrect header size: " + byteArrayOutputStream.size(), TraceLevel.CACHE);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    synchronized void writeFileToDisk(int n, DownloadDelegate downloadDelegate) throws IOException {
        this.writeFileToDisk(n, downloadDelegate, true);
    }

    synchronized void writeFileToDisk(final int n, final DownloadDelegate downloadDelegate, final boolean bl) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ZipFile zipFile = null;
                        RandomAccessFile randomAccessFile = null;
                        CacheEntry.this.section2Length = 0;
                        CacheEntry.this.section3Length = 0;
                        CacheEntry.this.section4Length = 0;
                        CacheEntry.this.section4Pre15Length = 0;
                        CacheEntry.this.section4CertsLength = 0;
                        CacheEntry.this.section4SignersLength = 0;
                        CacheEntry.this.section5Length = 0;
                        CacheEntry.this.reducedManifestLength = 0;
                        CacheEntry.this.reducedManifest2Length = 0;
                        try {
                            URL uRL;
                            String string;
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            byte[] byArray = CacheEntry.this.prepareHeader();
                            randomAccessFile.write(byArray);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                            dataOutputStream.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                            dataOutputStream.writeUTF(CacheEntry.this.getURL());
                            dataOutputStream.writeUTF(CacheEntry.this.getNamespaceID());
                            InetAddress inetAddress = null;
                            String string2 = "";
                            if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (inetAddress = Cache.getHostIP(string = (uRL = new URL(CacheEntry.this.url)).getHost())) != null) {
                                string2 = inetAddress.getHostAddress();
                            }
                            dataOutputStream.writeUTF(string2);
                            CacheEntry.this.writeHeaders(dataOutputStream);
                            dataOutputStream.close();
                            byteArrayOutputStream.close();
                            CacheEntry.this.section2Length = byteArrayOutputStream.size();
                            randomAccessFile.write(byteArrayOutputStream.toByteArray());
                            if (CacheEntry.this.incomplete == 0) {
                                if (CacheEntry.this.isJarFile() && !CacheEntry.this.hasCompressEncoding() && !CacheEntry.this.isRedirectEntry()) {
                                    CacheEntry.this.processJar(randomAccessFile, n, downloadDelegate);
                                }
                                if (bl) {
                                    UpdateTracker.checkDone(CacheEntry.this.url);
                                }
                                Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                CacheEntry.this.setBusy(BUSY_FALSE);
                                CacheEntry.this.setIncomplete(INCOMPLETE_FALSE);
                                CacheEntry.this.updateBlacklistValidation();
                                CacheEntry.this.updateTrustedLibrariesValidation();
                                CacheEntry.this.doUpdateHeader(randomAccessFile);
                                CacheEntry.this.doneReadManifest = true;
                            }
                        }
                        catch (Exception exception) {
                            Trace.ignoredException(exception);
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                                randomAccessFile = null;
                            }
                            if (zipFile != null) {
                                zipFile.close();
                                zipFile = null;
                            }
                            Cache.removeCacheEntry(CacheEntry.this);
                            if (exception instanceof JARSigningException) {
                                throw (JARSigningException)exception;
                            }
                            if (exception instanceof ZipException) {
                                throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, exception);
                            }
                            throw new IOException(exception.getMessage());
                        }
                        finally {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            Cache.cleanup();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    boolean isRedirectEntry() {
        return this.getRedirectFinalURL() != null;
    }

    public URL getRedirectFinalURL() {
        String string;
        Map map = this.getHeaders();
        List list = map == null ? null : (List)map.get("Location");
        String string2 = string = list == null || list.size() < 1 ? null : (String)list.get(0);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        }
        return null;
    }

    private void updateManifestRefs(Manifest manifest) {
        this.manifestRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
    }

    private byte[] readBlock(final int n, final int n2) throws IOException {
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                    try {
                        randomAccessFile.seek(n);
                        Object var2_2 = null;
                        byte[] byArray = new byte[n2];
                        randomAccessFile.readFully(byArray);
                        byte[] byArray2 = byArray;
                        return byArray2;
                    }
                    finally {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            return null;
        }
    }

    synchronized byte[] getFullManifestBytes() throws IOException {
        if (this.reducedManifest2Length > 0) {
            int n = 128 + this.section2Length;
            int n2 = this.section3Length - this.reducedManifest2Length;
            return this.readBlock(n, n2);
        }
        if (this.reducedManifestLength > 0) {
            int n = 128 + this.section2Length + this.reducedManifestLength;
            int n3 = this.section3Length - this.reducedManifestLength;
            return this.readBlock(n, n3);
        }
        return null;
    }

    synchronized Manifest readManifest() throws IOException {
        CachedManifest cachedManifest = null;
        if (this.section3Length != 0) {
            int n;
            int n2 = 128 + this.section2Length;
            if (this.reducedManifest2Length > 0) {
                n2 += this.section3Length - this.reducedManifest2Length;
                n = this.reducedManifest2Length;
            } else {
                n = this.reducedManifestLength > 0 ? this.reducedManifestLength : this.section3Length;
            }
            byte[] byArray = this.readBlock(n2, n);
            Trace.println(" Read manifest for " + this.url + ": read=" + n + " full=" + this.section3Length, TraceLevel.CACHE);
            cachedManifest = new CachedManifest(this.getURL(), byArray, this.reducedManifest2Length > 0 || this.reducedManifestLength > 0);
            this.updateManifestRefs(cachedManifest);
        }
        this.doneReadManifest = true;
        return cachedManifest;
    }

    private void readCertificates(final JarSigningData jarSigningData) throws IOException {
        block3: {
            int n = this.section4Pre15Length != 0 ? this.section4Pre15Length : this.section4Length;
            final int n2 = this.hasStrictSingleSigning() ? this.section4CertsLength : n;
            Trace.println("Reading certificates from " + n2 + " " + this.url + " | " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            if (this.section4Length != 0) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws IOException {
                            RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                            try {
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length);
                                byte[] byArray = new byte[n2];
                                randomAccessFile.readFully(byArray);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                                IndexFileObjectInputStream indexFileObjectInputStream = new IndexFileObjectInputStream(bufferedInputStream);
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(indexFileObjectInputStream));
                                CacheEntry.this.readCertificates(indexFileObjectInputStream, bufferedReader, jarSigningData);
                                if (Trace.isEnabled(TraceLevel.CACHE)) {
                                    Trace.println("Done readCertificates(" + CacheEntry.this.getURL() + "): " + CacheEntry.asString(jarSigningData.getCertificates()), TraceLevel.CACHE);
                                }
                            }
                            finally {
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block3;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private static String asString(Certificate[] certificateArray) {
        if (certificateArray != null) {
            return Arrays.asList(certificateArray).toString();
        }
        return "null";
    }

    private void readSigners(final JarSigningData jarSigningData) throws IOException {
        block3: {
            final boolean bl = this.section4Pre15Length != 0 && this.section4SignersLength < 5;
            final int n = this.section4Pre15Length != 0 && (!bl || this.hasStrictSingleSigning()) ? this.section4CertsLength : this.section4Length - (this.section4Length - this.section4Pre15Length);
            final int n2 = this.hasStrictSingleSigning() || bl ? this.section4SignersLength : this.section4Length - this.section4Pre15Length;
            Trace.println("Reading Signers from " + n2 + " " + this.url + " | " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            if (this.section4Length != 0) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws IOException {
                            RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                            try {
                                byte[] byArray = new byte[n + n2];
                                if (n != 0) {
                                    randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length);
                                    randomAccessFile.readFully(byArray, 0, n);
                                }
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Pre15Length);
                                randomAccessFile.readFully(byArray, n, n2);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                                IndexFileObjectInputStream indexFileObjectInputStream = new IndexFileObjectInputStream(bufferedInputStream);
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(indexFileObjectInputStream));
                                if (n2 == CacheEntry.this.section4Length || bl) {
                                    CacheEntry.this.readCertificates(indexFileObjectInputStream, bufferedReader, jarSigningData);
                                    if (Trace.isEnabled(TraceLevel.CACHE)) {
                                        Trace.println("Done readCertificates(" + CacheEntry.this.getURL() + "): " + CacheEntry.asString(jarSigningData.getCertificates()), TraceLevel.CACHE);
                                    }
                                } else {
                                    int n3 = indexFileObjectInputStream.readInt();
                                    try {
                                        for (int i = 0; i < n3; ++i) {
                                            indexFileObjectInputStream.readObject();
                                        }
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new IOException("Error reading signer certificates");
                                    }
                                }
                                CacheEntry.this.readSigners(indexFileObjectInputStream, bufferedReader, jarSigningData);
                                if (Trace.isEnabled(TraceLevel.CACHE)) {
                                    Trace.println("Done readSigners(" + CacheEntry.this.getURL() + ")", TraceLevel.CACHE);
                                }
                            }
                            finally {
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block3;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private void readCertificates(ObjectInputStream objectInputStream, BufferedReader bufferedReader, JarSigningData jarSigningData) throws IOException {
        int n = objectInputStream.readInt();
        if (n > 0) {
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            HashMap<int[], CodeSource> hashMap2 = new HashMap<int[], CodeSource>();
            Certificate[] certificateArray = new Certificate[n];
            try {
                for (int i = 0; i < n; ++i) {
                    certificateArray[i] = (Certificate)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading signer certificates: " + classNotFoundException);
            }
            int[] nArray = null;
            if (this.hasStrictSingleSigning()) {
                nArray = new int[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    nArray[i] = i;
                }
                CodeSource codeSource = this.createCodeSource(certificateArray);
                hashMap.put(null, nArray);
                hashMap2.put(nArray, codeSource);
                jarSigningData.updateCertInfo(certificateArray, hashMap, hashMap2);
                return;
            }
            String string = bufferedReader.readLine();
            String string2 = null;
            HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>();
            int[] nArray2 = null;
            while (string != null && !string.equals("")) {
                String string3 = string;
                if (string2 != null && string3.startsWith("/")) {
                    string3 = string2 + string3;
                } else if (string3.startsWith(ABSOLUTE_PATH_ESCAPE_CHAR)) {
                    string3 = string3.substring(1);
                    string2 = null;
                } else {
                    int n2 = string3.lastIndexOf("/");
                    string2 = n2 > 0 ? string3.substring(0, n2) : null;
                }
                string = bufferedReader.readLine();
                if (nArray2 != null) {
                    hashMap.put(string3, nArray2);
                } else {
                    nArray = (int[])hashMap3.get(string);
                    if (nArray == null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
                        int n3 = Integer.parseInt(stringTokenizer.nextToken());
                        nArray = new int[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        hashMap3.put(string, nArray);
                        Certificate[] certificateArray2 = new Certificate[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            certificateArray2[i] = certificateArray[nArray[i]];
                        }
                        CodeSource codeSource = this.createCodeSource(certificateArray2);
                        hashMap2.put(nArray, codeSource);
                    }
                    hashMap.put(string3, nArray);
                    if (this.hasSingleCodeSource) {
                        nArray2 = nArray;
                    }
                }
                string = bufferedReader.readLine();
            }
            jarSigningData.updateCertInfo(certificateArray, hashMap, hashMap2);
        } else {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
        }
    }

    private void readSigners(ObjectInputStream objectInputStream, BufferedReader bufferedReader, JarSigningData jarSigningData) throws IOException {
        String string = bufferedReader.readLine();
        int n = 0;
        if (!Config.isJavaVersionAtLeast15()) {
            Trace.println("readSigners called pre-1.5 ", TraceLevel.CACHE);
            return;
        }
        if (string != null) {
            n = Integer.parseInt(string);
        }
        if (n < 1 && (jarSigningData.getCertificateMap() == null || jarSigningData.getCodeSourceCertCache() == null)) {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<int[], Object> hashMap2 = new HashMap<int[], Object>();
        CodeSigner[] codeSignerArray = null;
        if (n == 0) {
            Object object;
            Object object2;
            Map.Entry entry;
            ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
            HashMap<int[], int[]> hashMap3 = new HashMap<int[], int[]>();
            Iterator iterator = jarSigningData.getCodeSourceCertCache().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                object2 = (int[])entry.getKey();
                object = (CodeSource)entry.getValue();
                CodeSigner[] codeSignerArray2 = ((CodeSource)object).getCodeSigners();
                codeSignerArray2 = this.convertCertArrayToSignerArray(((CodeSource)object).getCertificates());
                object = new CodeSource(((CodeSource)object).getLocation(), codeSignerArray2);
                if (codeSignerArray2 == null || codeSignerArray2.length <= 0) continue;
                int[] nArray = new int[codeSignerArray2.length];
                for (int i = 0; i < codeSignerArray2.length; ++i) {
                    int n2 = arrayList.indexOf(codeSignerArray2[i]);
                    if (n2 == -1) {
                        n2 = arrayList.size();
                        arrayList.add(codeSignerArray2[i]);
                    }
                    nArray[i] = n2;
                }
                hashMap3.put((int[])object2, nArray);
                hashMap2.put(nArray, object);
            }
            iterator = jarSigningData.getCertificateMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                object2 = (String)entry.getKey();
                object = (int[])entry.getValue();
                hashMap.put(object2, hashMap3.get(object));
            }
            codeSignerArray = arrayList.toArray(new CodeSigner[arrayList.size()]);
        } else if (n > 0) {
            codeSignerArray = new CodeSigner[n];
            try {
                for (int i = 0; i < n; ++i) {
                    codeSignerArray[i] = this.newCodeSigner((CodeSigner)objectInputStream.readObject());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading code signer");
            }
            int[] nArray = null;
            if (this.hasStrictSingleSigning()) {
                nArray = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    nArray[i] = i;
                }
                CodeSource codeSource = this.createCodeSource(codeSignerArray);
                hashMap.put(null, nArray);
                hashMap2.put(nArray, codeSource);
            } else {
                String string2 = bufferedReader.readLine();
                String string3 = null;
                HashMap<String, int[]> hashMap4 = new HashMap<String, int[]>();
                while (string2 != null && !string2.equals("")) {
                    String string4 = string2;
                    if (string3 != null && string4.startsWith("/")) {
                        string4 = string3 + string4;
                    } else if (string4.startsWith(ABSOLUTE_PATH_ESCAPE_CHAR)) {
                        string4 = string4.substring(1);
                        string3 = null;
                    } else {
                        int n3 = string4.lastIndexOf("/");
                        string3 = n3 > 0 ? string4.substring(0, n3) : null;
                    }
                    string2 = bufferedReader.readLine();
                    nArray = (int[])hashMap4.get(string2);
                    if (nArray == null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
                        int n4 = Integer.parseInt(stringTokenizer.nextToken());
                        nArray = new int[n4];
                        for (int i = 0; i < n4; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        hashMap4.put(string2, nArray);
                        CodeSigner[] codeSignerArray3 = new CodeSigner[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            codeSignerArray3[i] = codeSignerArray[nArray[i]];
                        }
                        CodeSource codeSource = this.createCodeSource(codeSignerArray3);
                        hashMap2.put(nArray, codeSource);
                    }
                    hashMap.put(string4, nArray);
                    string2 = bufferedReader.readLine();
                }
            }
        }
        jarSigningData.updateSignerInfo(codeSignerArray, hashMap, hashMap2);
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) throws IOException {
        try {
            int n;
            CodeSigner[] codeSignerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < certificateArray.length) {
                Serializable serializable;
                codeSignerArray = new ArrayList();
                n = n3;
                for (n = n3; n < certificateArray.length; ++n) {
                    serializable = null;
                    Serializable serializable2 = null;
                    if (certificateArray[n] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n];
                    }
                    serializable2 = n + 1 < certificateArray.length && certificateArray[n + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n + 1] : serializable;
                    codeSignerArray.add(serializable);
                    if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                }
                n4 = n < certificateArray.length ? n + 1 : n;
                serializable = certificateFactory.generateCertPath((List<? extends Certificate>)codeSignerArray);
                codeSignerArray.clear();
                arrayList.add((CertPath)serializable);
                n3 = n4;
                ++n2;
            }
            codeSignerArray = new CodeSigner[n2];
            for (n = 0; n < n2; ++n) {
                codeSignerArray[n] = new CodeSigner((CertPath)arrayList.get(n), null);
            }
            return codeSignerArray;
        }
        catch (CertificateException certificateException) {
            throw new IOException("Error process signer certificates");
        }
    }

    private CodeSigner newCodeSigner(CodeSigner codeSigner) {
        CertPath certPath = codeSigner.getSignerCertPath();
        Timestamp timestamp = codeSigner.getTimestamp();
        CodeSigner codeSigner2 = new CodeSigner(certPath, this.newTimestamp(timestamp));
        return codeSigner2;
    }

    private Timestamp newTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = timestamp.getTimestamp();
        CertPath certPath = timestamp.getSignerCertPath();
        return new Timestamp(date, certPath);
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    private void processJar(RandomAccessFile randomAccessFile, int n, DownloadDelegate downloadDelegate) throws IOException, ParsingException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        URL uRL = new URL(this.url);
        File file = new File(this.filename);
        File file2 = null;
        if (DownloadEngine.isNativeContentType(n)) {
            file2 = new File(this.getNativeLibPath()).getCanonicalFile();
        }
        JarVerifier jarVerifier = JarVerifier.create(uRL, this.version, file, file2);
        jarVerifier.validate(downloadDelegate);
        this.hasOnlySignedEntries = jarVerifier.hasOnlySignedEntries();
        this.hasSingleCodeSource = jarVerifier.hasSingleCodeSource();
        this.hasMissingSignedEntries = jarVerifier.hasMissingSignedEntries();
        CachedManifest cachedManifest = null;
        Manifest manifest = jarVerifier.getManifest();
        if (manifest != null) {
            cachedManifest = new CachedManifest(manifest);
            this.section3Length = cachedManifest.writeFull(byteArrayOutputStream);
            this.reducedManifest2Length = cachedManifest.writeReduced(byteArrayOutputStream);
            this.section3Length += this.reducedManifest2Length;
        } else {
            this.section3Length = 0;
            this.reducedManifest2Length = 0;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
        this.writeCertificates(jarVerifier, objectOutputStream, bufferedWriter, byteArrayOutputStream);
        this.writeSigners(jarVerifier, objectOutputStream, bufferedWriter, byteArrayOutputStream);
        this.signingDataRef = new SoftReference<JarSigningData>(JarSigningData.create(jarVerifier));
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        if (cachedManifest != null) {
            cachedManifest.postprocess();
            this.updateManifestRefs(cachedManifest);
        }
    }

    private void writeCertificates(JarVerifier jarVerifier, ObjectOutputStream objectOutputStream, BufferedWriter bufferedWriter, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (!jarVerifier.getSignerCerts().isEmpty()) {
            objectOutputStream.writeInt(jarVerifier.getSignerCerts().size());
            Iterator iterator = jarVerifier.getSignerCerts().iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            objectOutputStream.flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
            Map map = jarVerifier.getSignerMapCert();
            Iterator iterator2 = map.keySet().iterator();
            String string = null;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null || string2.length() == 0) continue;
                int[] nArray = (int[])map.get(string2);
                if (string2.startsWith("/")) {
                    string2 = ABSOLUTE_PATH_ESCAPE_CHAR + string2;
                    string = null;
                } else {
                    int n = string2.lastIndexOf("/");
                    if (n > 0) {
                        String string3 = string2.substring(0, n);
                        if (string3.equals(string)) {
                            string2 = string2.substring(string3.length());
                        } else {
                            string = string3;
                        }
                    } else {
                        string = null;
                    }
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                String string4 = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    string4 = string4 + " " + nArray[i];
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (this.hasStrictSingleSigning()) {
                map.clear();
                map.put(null, jarVerifier.getSingleSignerIndicesCert());
            }
        } else {
            objectOutputStream.writeInt(0);
            objectOutputStream.flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        }
        objectOutputStream.flush();
        this.section4Pre15Length = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
    }

    private void writeSigners(JarVerifier jarVerifier, ObjectOutputStream objectOutputStream, BufferedWriter bufferedWriter, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        List list = jarVerifier.getSignersCS();
        if (!list.isEmpty()) {
            Integer n = new Integer(list.size());
            bufferedWriter.write(n.toString());
            bufferedWriter.newLine();
            bufferedWriter.flush();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            objectOutputStream.flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
            Map map = jarVerifier.getSignerMap();
            Iterator iterator2 = map.keySet().iterator();
            String string = null;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null || string2.length() == 0) continue;
                int[] nArray = (int[])map.get(string2);
                if (string2.startsWith("/")) {
                    string2 = ABSOLUTE_PATH_ESCAPE_CHAR + string2;
                    string = null;
                } else {
                    int n2 = string2.lastIndexOf("/");
                    if (n2 > 0) {
                        String string3 = string2.substring(0, n2);
                        if (string3.equals(string)) {
                            string2 = string2.substring(n2);
                        } else {
                            string = string3;
                        }
                    } else {
                        string = null;
                    }
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                String string4 = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    string4 = string4 + " " + nArray[i];
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            if (this.hasStrictSingleSigning()) {
                map.clear();
                map.put(null, jarVerifier.getSingleSignerIndicesCS());
            }
        } else {
            bufferedWriter.write("0");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            objectOutputStream.flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
        }
        bufferedWriter.flush();
        objectOutputStream.flush();
        this.section4Length = byteArrayOutputStream.size() - this.section3Length;
    }

    private void readIndexFile602(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.readByte();
        randomAccessFile.readByte();
        randomAccessFile.readInt();
        randomAccessFile.read();
        randomAccessFile.read();
        this.setIsShortcutImage(randomAccessFile.read());
        this.setContentLength(randomAccessFile.readInt());
        this.setLastModified(randomAccessFile.readLong());
        this.setExpirationDate(randomAccessFile.readLong());
        this.setVersion(randomAccessFile.readUTF());
        this.setURL(randomAccessFile.readUTF());
        this.setNamespaceID(randomAccessFile.readUTF());
        File file = new File(this.getResourceFilename());
        if (!this.isRedirectEntry() && !file.exists()) {
            this.invalidateEntry();
        }
        if (!this.isIncomplete()) {
            this.readHeaders602(randomAccessFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders602(RandomAccessFile randomAccessFile) throws IOException {
        for (int i = randomAccessFile.readInt(); i > 0; --i) {
            String string = randomAccessFile.readUTF();
            if (string.equals("deploy_resource_codebase_ip")) {
                this.setCodebaseIP(randomAccessFile.readUTF());
                continue;
            }
            if (string.equals("<null>")) {
                string = null;
            }
            this.headerFields.add(string, randomAccessFile.readUTF());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(DataInputStream dataInputStream) throws IOException {
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            String string = dataInputStream.readUTF();
            if (string.equals("<null>")) {
                string = null;
            }
            this.headerFields.add(string, dataInputStream.readUTF());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaders(DataOutputStream dataOutputStream) throws IOException {
        if (this.headerFields == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        Map map = this.headerFields.getHeaders();
        if (!map.isEmpty()) {
            dataOutputStream.writeInt(map.size());
            for (int i = 0; i < map.size(); ++i) {
                String string;
                String string2 = this.headerFields.getKey(i);
                if (null == string2) {
                    string2 = "<null>";
                }
                if ((string = this.headerFields.getValue(i)) == null) {
                    if (!Cache.DEBUG) continue;
                    Trace.print("Header field '" + string2 + "' null, skip.");
                    continue;
                }
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeUTF(string);
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        return "URL: " + this.url + " | " + this.indexFile;
    }

    public String dumpToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }

    public boolean hasCompressEncoding() {
        return HttpUtils.hasGzipOrPack200Encoding(this.getHeaders());
    }

    boolean matchesVersionString(String string, boolean bl) {
        return CacheEntry.matchesVersionString(this, string, bl);
    }

    static boolean matchesVersionString(Resource resource, String string, boolean bl) {
        if (resource.getVersion() == null && string == null) {
            return true;
        }
        VersionString versionString = new VersionString(string);
        if (bl && !versionString.isSimpleVersion()) {
            return false;
        }
        return versionString.contains(resource.getVersion());
    }

    public boolean isSameEntry(CacheEntry cacheEntry) {
        return cacheEntry != null && this.getIndexFile().equals(cacheEntry.getIndexFile());
    }

    private void readSection2(RandomAccessFile randomAccessFile) throws IOException {
        if (this.section2Length > 0) {
            byte[] byArray = new byte[this.section2Length];
            randomAccessFile.read(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.setVersion(dataInputStream.readUTF());
            this.setURL(dataInputStream.readUTF());
            this.setNamespaceID(dataInputStream.readUTF());
            this.setCodebaseIP(dataInputStream.readUTF());
            this.readHeaders(dataInputStream);
        }
    }

    private void readSection1Remaining(DataInputStream dataInputStream) throws IOException {
        this.setIsShortcutImage(dataInputStream.readByte());
        this.setContentLength(dataInputStream.readInt());
        this.setLastModified(dataInputStream.readLong());
        this.setExpirationDate(dataInputStream.readLong());
        this.validationTimestampt = dataInputStream.readLong();
        this.knownToBeSigned = dataInputStream.readByte() == 1;
        this.section2Length = dataInputStream.readInt();
        this.section3Length = dataInputStream.readInt();
        this.section4Length = dataInputStream.readInt();
        this.section5Length = dataInputStream.readInt();
        this.blacklistValidationTime = dataInputStream.readLong();
        this.certExpirationDate = dataInputStream.readLong();
        this.classVerificationStatus = dataInputStream.readByte();
        this.reducedManifestLength = dataInputStream.readInt();
        this.section4Pre15Length = dataInputStream.readInt();
        this.hasOnlySignedEntries = dataInputStream.readByte() == 1;
        this.hasSingleCodeSource = dataInputStream.readByte() == 1;
        this.section4CertsLength = dataInputStream.readInt();
        this.section4SignersLength = dataInputStream.readInt();
        this.hasMissingSignedEntries = dataInputStream.readByte() == 1;
        this.trustedLibrariesValidationTime = dataInputStream.readLong();
        this.reducedManifest2Length = dataInputStream.readInt();
        this.setIsProxied(dataInputStream.readByte());
        dataInputStream.close();
    }

    private void readSection1Remaining604(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
        dataInputStream.readByte();
        this.setIsShortcutImage(dataInputStream.readByte());
        this.setContentLength(dataInputStream.readInt());
        this.setLastModified(dataInputStream.readLong());
        this.setExpirationDate(dataInputStream.readLong());
        this.validationTimestampt = dataInputStream.readLong();
        this.knownToBeSigned = dataInputStream.readByte() == 1;
        this.section2Length = dataInputStream.readInt();
        this.section3Length = dataInputStream.readInt();
        this.section4Length = dataInputStream.readInt();
        this.section5Length = dataInputStream.readInt();
        this.blacklistValidationTime = dataInputStream.readLong();
        this.certExpirationDate = dataInputStream.readLong();
        this.classVerificationStatus = dataInputStream.readByte();
        this.reducedManifestLength = dataInputStream.readInt();
        this.section4Pre15Length = dataInputStream.readInt();
        this.hasOnlySignedEntries = dataInputStream.readByte() == 1;
        this.hasSingleCodeSource = dataInputStream.readByte() == 1;
        this.section4CertsLength = dataInputStream.readInt();
        this.section4SignersLength = dataInputStream.readInt();
        this.hasMissingSignedEntries = dataInputStream.readByte() == 1;
        this.trustedLibrariesValidationTime = dataInputStream.readLong();
        this.reducedManifest2Length = dataInputStream.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpgrade() throws IOException {
        Trace.println("Trying to update in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
        this.cacheVersion = Cache.getCacheVersion();
        boolean bl = this.isValidEntry();
        try {
            this.setBusy(BUSY_TRUE);
            this.updateIndexHeaderOnDisk();
            if (bl) {
                Trace.println("Upgrade writing to disk for " + this.getResourceFilename(), TraceLevel.CACHE);
                this.writeFileToDisk(1, null, false);
                Trace.println("Upgrade of entry done", TraceLevel.CACHE);
            } else {
                Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
            }
        }
        finally {
            this.setBusy(BUSY_FALSE);
        }
    }

    public int getState() {
        if (this.incomplete == INCOMPLETE_TRUE && this.busy == BUSY_FALSE) {
            return 2;
        }
        if (this.incomplete == INCOMPLETE_FALSE && this.busy == BUSY_FALSE) {
            return 1;
        }
        return 0;
    }

    private CodeSource createCodeSource(Certificate[] certificateArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, certificateArray);
    }

    private CodeSource createCodeSource(CodeSigner[] codeSignerArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, codeSignerArray);
    }

    static {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            javaUtilJarAccess.setEagerValidation((JarFile)null, false);
            enhancedJarAccess = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NullPointerException nullPointerException) {
            enhancedJarAccess = true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

