/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.RadioButton;
import controlP5.Slider;
import controlP5.Textarea;
import controlP5.Toggle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.processing.wiki.triangulate.Triangle;
import org.processing.wiki.triangulate.Triangulate;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;

public class TriangulateImage5
extends PApplet {
    public int blur_val = 0;
    public boolean displayImage = true;
    public boolean displayMesh = false;
    public boolean displayResult = false;
    public boolean deleteMode = false;
    public boolean displayBlurred = false;
    public boolean displayLoupe = false;
    public SmartBlurFilter smartFilter = new SmartBlurFilter();
    public Insets insets;
    public int widthInsets;
    public int heightInsets;
    private ControlP5 cp5;
    ControlFrame cf;
    RadioButton r;
    Toggle e;
    Toggle l;
    Textarea ta;
    PrintWriter output;
    PGraphics pdf;
    HashSet<Integer> chosenPointsList = new HashSet();
    ArrayList triangles = new ArrayList();
    ArrayList<PVector> points = new ArrayList();
    PImage img;
    PImage img_b;
    PImage delCursor;

    public void setup() {
        this.img = this.loadImage("Instructions.jpg");
        this.delCursor = this.loadImage("delcursor.png");
        this.img_b = this.img.get();
        this.size(this.img.width, this.img.height);
        this.insets = this.frame.getInsets();
        this.widthInsets = this.insets.left + this.insets.right;
        this.heightInsets = this.insets.top + this.insets.bottom;
        this.points.add(new PVector(0.0f, 0.0f, 0.0f));
        this.points.add(new PVector((float)this.img.width, 0.0f, 0.0f));
        this.points.add(new PVector((float)this.img.width, (float)this.img.height, 0.0f));
        this.points.add(new PVector(0.0f, (float)this.img.height, 0.0f));
        this.points.add(new PVector((float)(this.img.width / 2), (float)(this.img.height / 2), 0.0f));
        int n = 0;
        while (n < this.points.size()) {
            int n2 = PApplet.parseInt((float)(this.points.get((int)n).y * (float)this.img.width + this.points.get((int)n).x));
            this.chosenPointsList.add(n2);
            ++n;
        }
        this.noStroke();
        this.frameRate(24.0f);
        this.cursor(1);
        this.smooth();
        this.cp5 = new ControlP5((PApplet)this);
        this.cf = this.addControlFrame("Tools", 230, 460);
    }

    public void draw() {
        Triangle triangle;
        int n;
        int n2;
        if (this.displayImage) {
            this.image(this.img, 0.0f, 0.0f);
            this.noStroke();
            this.fill(0.0f, 0.0f, 255.0f);
            n2 = 0;
            while (n2 < this.points.size()) {
                this.ellipse(this.points.get((int)n2).x, this.points.get((int)n2).y, 2.0f, 2.0f);
                ++n2;
            }
            if (this.displayLoupe) {
                this.copy(this.mouseX - 10, this.mouseY - 10, 20, 20, 25, 25, 50, 50);
            }
        }
        if (this.displayBlurred) {
            this.image(this.img_b, 0.0f, 0.0f);
            this.noStroke();
            this.fill(0.0f, 0.0f, 255.0f);
            n2 = 0;
            while (n2 < this.points.size()) {
                this.ellipse(this.points.get((int)n2).x, this.points.get((int)n2).y, 2.0f, 2.0f);
                ++n2;
            }
            if (this.displayLoupe) {
                this.copy(this.mouseX - 10, this.mouseY - 10, 20, 20, 25, 25, 50, 50);
            }
        }
        if (this.displayMesh) {
            this.image(this.img, 0.0f, 0.0f);
            ArrayList<PVector> arrayList = new ArrayList<PVector>(this.points);
            this.triangles = Triangulate.triangulate(arrayList);
            this.noFill();
            this.beginShape(9);
            n = 0;
            while (n < this.triangles.size()) {
                triangle = (Triangle)this.triangles.get(n);
                this.strokeJoin(32);
                this.strokeWeight(0.7f);
                this.stroke(0.0f, 0.0f, 255.0f);
                this.vertex(triangle.p1.x, triangle.p1.y);
                this.vertex(triangle.p2.x, triangle.p2.y);
                this.vertex(triangle.p3.x, triangle.p3.y);
                ++n;
            }
            this.endShape();
            if (this.displayLoupe) {
                this.copy(this.mouseX - 10, this.mouseY - 10, 20, 20, 25, 25, 50, 50);
            }
        }
        if (this.displayResult) {
            this.image(this.img_b, 0.0f, 0.0f);
            this.noStroke();
            ArrayList<PVector> arrayList = new ArrayList<PVector>(this.points);
            this.triangles = Triangulate.triangulate(arrayList);
            n = 0;
            while (n < this.triangles.size()) {
                triangle = (Triangle)this.triangles.get(n);
                int n3 = PApplet.parseInt((float)((triangle.p1.x + triangle.p2.x + triangle.p3.x) / 3.0f));
                int n4 = PApplet.parseInt((float)((triangle.p1.y + triangle.p2.y + triangle.p3.y) / 3.0f));
                this.fill(this.img_b.get(n3, n4), 255.0f);
                this.triangle(triangle.p1.x, triangle.p1.y, triangle.p2.x, triangle.p2.y, triangle.p3.x, triangle.p3.y);
                ++n;
            }
            if (this.displayLoupe) {
                this.copy(this.mouseX - 10, this.mouseY - 10, 20, 20, 25, 25, 50, 50);
            }
        }
    }

    public void mouseMoved() {
        if (!this.deleteMode) {
            this.noLoop();
            int n = PApplet.parseInt((float)(this.mouseY * this.img.width + this.mouseX));
            HashSet<Integer> hashSet = new HashSet<Integer>(this.chosenPointsList);
            HashSet<Integer> hashSet2 = new HashSet<Integer>(this.chosenPointsList);
            hashSet.add(n);
            if (hashSet != hashSet2) {
                this.points.set(this.points.size() - 1, new PVector((float)this.mouseX, (float)this.mouseY, 0.0f));
            }
            this.loop();
        }
    }

    public void mousePressed() {
        int n;
        if (!this.deleteMode && this.mouseEvent.getClickCount() < 2) {
            this.noLoop();
            n = PApplet.parseInt((float)(this.mouseY * this.img.width + this.mouseX));
            HashSet<Integer> hashSet = new HashSet<Integer>(this.chosenPointsList);
            HashSet<Integer> hashSet2 = new HashSet<Integer>(this.chosenPointsList);
            hashSet.add(n);
            if (hashSet.size() != hashSet2.size()) {
                this.points.add(new PVector((float)this.mouseX, (float)this.mouseY, 0.0f));
            }
            this.loop();
        }
        if (this.deleteMode) {
            n = 0;
            while (n < this.points.size()) {
                float f = TriangulateImage5.dist((float)this.mouseX, (float)this.mouseY, (float)this.points.get((int)n).x, (float)this.points.get((int)n).y);
                if (f < 5.0f) {
                    this.points.remove(n);
                }
                ++n;
            }
        }
    }

    public void mouseReleased() {
        this.frameRate(24.0f);
    }

    public void keyPressed() {
        if (this.key == 's') {
            PGraphics pGraphics = this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", "output.pdf");
            pGraphics.beginDraw();
            pGraphics.noStroke();
            pGraphics.image(this.img, 0.0f, 0.0f);
            ArrayList<PVector> arrayList = new ArrayList<PVector>(this.points);
            this.triangles = Triangulate.triangulate(arrayList);
            int n = 0;
            while (n < this.triangles.size()) {
                Triangle triangle = (Triangle)this.triangles.get(n);
                int n2 = PApplet.parseInt((float)((triangle.p1.x + triangle.p2.x + triangle.p3.x) / 3.0f));
                int n3 = PApplet.parseInt((float)((triangle.p1.y + triangle.p2.y + triangle.p3.y) / 3.0f));
                pGraphics.fill(this.img_b.get(n2, n3));
                pGraphics.triangle(triangle.p1.x, triangle.p1.y, triangle.p2.x, triangle.p2.y, triangle.p3.x, triangle.p3.y);
                ++n;
            }
            pGraphics.dispose();
            pGraphics.endDraw();
            this.save("output.tga");
        }
        if (this.key == 'o' || this.key == 'O') {
            this.displayImage = true;
            this.displayMesh = false;
            this.displayResult = false;
            this.displayBlurred = false;
            this.r.activate(0);
        }
        if (this.key == 'r' || this.key == 'R') {
            this.displayImage = false;
            this.displayMesh = false;
            this.displayResult = true;
            this.displayBlurred = false;
            this.r.activate(3);
        }
        if (this.key == 'b' || this.key == 'B') {
            this.displayImage = false;
            this.displayMesh = false;
            this.displayResult = false;
            this.displayBlurred = true;
            this.r.activate(1);
        }
        if (this.key == 'm' || this.key == 'M') {
            this.displayImage = false;
            this.displayMesh = true;
            this.displayResult = false;
            this.displayBlurred = false;
            this.r.activate(2);
        }
        if (this.key == 'l' || this.key == 'L') {
            if (this.displayLoupe) {
                this.displayLoupe = false;
                this.l.setState(false);
            } else if (!this.displayLoupe) {
                this.displayLoupe = true;
                this.l.setState(true);
            }
        }
        if (this.key == 'e' || this.key == 'E') {
            if (this.deleteMode) {
                this.deleteMode = false;
                this.cursor(1);
                this.e.setState(false);
                TriangulateImage5.println((String)"true");
            } else if (!this.deleteMode) {
                this.deleteMode = true;
                this.cursor(this.delCursor, 16, 16);
                this.e.setState(true);
                TriangulateImage5.println((String)"false");
            }
        }
    }

    public void eraser(boolean bl) {
        if (bl) {
            this.deleteMode = true;
            this.points.remove(this.points.size() - 1);
            this.cursor(this.delCursor, 16, 16);
            TriangulateImage5.println((String)"false");
        } else {
            this.deleteMode = false;
            this.points.add(new PVector((float)this.mouseX, (float)this.mouseY, 0.0f));
            this.cursor(1);
            TriangulateImage5.println((String)"true");
        }
    }

    public void loupe(boolean bl) {
        this.displayLoupe = bl;
    }

    public void choose() {
        this.selectInput("Select a file to process:", "imageFileSelect");
    }

    public void lPoints() {
        this.selectInput("Select a points text file:", "pointsFileSelect");
    }

    public void sPoints() {
        this.selectOutput("Save points text file:", "pointsFileSave");
    }

    public void blur(int n) {
        this.smartFilter.setRadius(PApplet.parseInt((float)n));
    }

    public void threshold(float f) {
        this.smartFilter.setThreshold(f);
    }

    public void blurIt() {
        if (this.smartFilter.getRadius() != 0 && this.smartFilter.getThreshold() != 0.0) {
            this.noLoop();
            BufferedImage bufferedImage = this.smartFilter.filter((BufferedImage)this.img.getNative());
            this.img_b = new PImage((Image)bufferedImage);
            this.loop();
        } else {
            this.img_b = this.img.get();
        }
        this.displayImage = false;
        this.displayBlurred = true;
        this.displayMesh = false;
        this.displayResult = false;
        this.r.activate(1);
    }

    public void passChooser(int n) {
        if (n == 1) {
            this.displayImage = true;
            this.displayBlurred = false;
            this.displayMesh = false;
            this.displayResult = false;
        }
        if (n == 2) {
            this.displayImage = false;
            this.displayBlurred = true;
            this.displayMesh = false;
            this.displayResult = false;
        }
        if (n == 3) {
            this.displayImage = false;
            this.displayBlurred = false;
            this.displayMesh = true;
            this.displayResult = false;
        }
        if (n == 4) {
            this.displayImage = false;
            this.displayBlurred = false;
            this.displayMesh = false;
            this.displayResult = true;
        }
    }

    public void savePDF() {
        this.selectOutput("Save as a pdf:", "pdfFileSave");
    }

    public int[] getUniqueValues_2(int[] nArray, boolean bl) {
        int n = nArray.length;
        int n2 = nArray[0];
        int n3 = nArray[0];
        int n4 = 1;
        while (n4 < n) {
            if (nArray[n4] > n2) {
                n2 = nArray[n4];
            }
            if (nArray[n4] < n3) {
                n3 = nArray[n4];
            }
            ++n4;
        }
        int n5 = n2 - n3 + 1;
        boolean[] blArray = new boolean[n5];
        int[] nArray2 = new int[n5];
        n4 = 0;
        int n6 = 0;
        while (n4 < n) {
            int n7 = nArray[n4];
            int n8 = n7 - n3;
            if (!blArray[n8]) {
                nArray2[n6++] = n7;
                blArray[n8] = true;
            }
            ++n4;
        }
        nArray2 = Arrays.copyOf(nArray2, n6);
        if (bl) {
            Arrays.sort(nArray2);
        }
        return nArray2;
    }

    public int[] ListToArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    public void pdfFileSave(File file) {
        if (file == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, no file saved.");
        } else {
            this.pdf = file.getName().endsWith(".pdf") ? this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", file.getAbsolutePath()) : this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", String.valueOf(file.getAbsolutePath()) + ".pdf");
            this.pdf.beginDraw();
            this.pdf.noStroke();
            this.pdf.image(this.img, 0.0f, 0.0f);
            ArrayList<PVector> arrayList = new ArrayList<PVector>(this.points);
            this.triangles = Triangulate.triangulate(arrayList);
            int n = 0;
            while (n < this.triangles.size()) {
                Triangle triangle = (Triangle)this.triangles.get(n);
                int n2 = PApplet.parseInt((float)((triangle.p1.x + triangle.p2.x + triangle.p3.x) / 3.0f));
                int n3 = PApplet.parseInt((float)((triangle.p1.y + triangle.p2.y + triangle.p3.y) / 3.0f));
                this.pdf.fill(this.img_b.get(n2, n3));
                this.pdf.triangle(triangle.p1.x, triangle.p1.y, triangle.p2.x, triangle.p2.y, triangle.p3.x, triangle.p3.y);
                ++n;
            }
            this.pdf.dispose();
            this.pdf.endDraw();
            this.ta.setColor(this.color(0, 255, 0));
            this.ta.setText("Success.\nThe File was Saved Successfully!");
        }
    }

    public void pointsFileSave(File file) {
        if (file == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, no file saved.");
        } else {
            this.output = file.getName().endsWith(".txt") ? this.createWriter(file.getAbsolutePath()) : this.createWriter(String.valueOf(file.getAbsolutePath()) + ".txt");
            this.output.println(String.valueOf(this.img.width) + " " + this.img.height);
            int n = 0;
            while (n < this.points.size()) {
                this.output.println(this.points.get(n));
                ++n;
            }
            this.output.flush();
            this.output.close();
            this.ta.setColor(this.color(0, 255, 0));
            this.ta.setText("Success.\nThe File was Saved Successfully!");
        }
    }

    public void pointsFileSelect(File file) {
        if (file == null) {
            TriangulateImage5.println((String)"Window was closed or the user hit cancel.");
        } else if (file.getName().endsWith("txt")) {
            String[] stringArray = this.loadStrings(file.getPath());
            String[] stringArray2 = TriangulateImage5.split((String)stringArray[0], (String)" ");
            if (TriangulateImage5.parseFloat((String)stringArray2[0]) == (float)this.img.width && TriangulateImage5.parseFloat((String)stringArray2[1]) == (float)this.img.height) {
                this.noLoop();
                this.points = new ArrayList();
                this.chosenPointsList = new HashSet();
                int n = 1;
                while (n < stringArray.length) {
                    String[] stringArray3 = TriangulateImage5.split((String)stringArray[n], (String)", ");
                    String[] stringArray4 = TriangulateImage5.split((String)stringArray3[0], (String)"[ ");
                    float f = TriangulateImage5.parseFloat((String)stringArray4[1]);
                    float f2 = TriangulateImage5.parseFloat((String)stringArray3[1]);
                    this.points.add(new PVector(f, f2, 0.0f));
                    int n2 = PApplet.parseInt((float)(f2 * (float)this.img.width + f));
                    this.chosenPointsList.add(n2);
                    ++n;
                }
                this.loop();
                this.ta.setColor(this.color(0, 255, 0));
                this.ta.setText("Success.\nPoints are loaded.");
            } else {
                this.ta.setColor(this.color(255, 0, 0));
                this.ta.setText("Error.\nPoints file does not match the loaded image.");
            }
        } else {
            this.ta.setColor(this.color(255, 0, 0));
            this.ta.setText("Error.\nPlease choose a txt file.");
        }
    }

    public void imageFileSelect(File file) {
        if (file == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, selection was cancelled.");
        } else if (file.getName().endsWith("jpg") || file.getName().endsWith("jpeg") || file.getName().endsWith("png") || file.getName().endsWith("gif") || file.getName().endsWith("tga")) {
            PImage pImage = this.loadImage(file.getAbsolutePath());
            if (pImage != null && pImage.width > 0 && pImage.height > 0) {
                int n;
                int n2;
                this.img = pImage.get();
                String string = "";
                String string2 = "";
                int n3 = file.getAbsolutePath().lastIndexOf(46);
                if (n3 > (n2 = Math.max(file.getAbsolutePath().lastIndexOf(47), file.getAbsolutePath().lastIndexOf(92)))) {
                    string2 = file.getAbsolutePath().substring(n3 + 1);
                }
                if (this.img.width + 60 > this.displayWidth || this.img.height + 60 > this.displayHeight) {
                    float f = PApplet.parseFloat((int)this.img.width) / PApplet.parseFloat((int)this.img.height);
                    TriangulateImage5.println((float)f);
                    n = 0;
                    int n4 = 0;
                    if (this.img.width + 60 > this.displayWidth) {
                        n = PApplet.parseInt((float)(((float)this.displayWidth - 60.0f) / f));
                        n4 = this.displayWidth - 60;
                    }
                    if (this.img.height + 60 > this.displayHeight) {
                        n4 = PApplet.parseInt((float)(((float)this.displayHeight - 60.0f) * f));
                        n = this.displayHeight - 60;
                    }
                    PGraphics pGraphics = this.createGraphics(n4, n);
                    pGraphics.beginDraw();
                    pGraphics.background(0.0f, 0.0f, 0.0f, 0.0f);
                    pGraphics.image(this.img, 0.0f, 0.0f, (float)n4, (float)n);
                    pGraphics.endDraw();
                    pGraphics.save(String.valueOf(file.getAbsolutePath().substring(0, n3)) + "_scaled." + string2);
                    this.img = this.loadImage(String.valueOf(file.getAbsolutePath().substring(0, n3)) + "_scaled." + string2);
                    string = " Original image was too large for your display - scaled to fit and saved as " + file.getAbsolutePath().substring(0, n3) + "_scaled." + string2;
                }
                this.img_b = this.img.get();
                this.size(this.img.width + this.widthInsets, this.img.height + this.heightInsets);
                this.frame.setSize(this.img.width + this.widthInsets, this.img.height + this.heightInsets);
                this.r.activate(0);
                this.chosenPointsList = new HashSet();
                this.points = new ArrayList();
                this.points.add(new PVector(0.0f, 0.0f, 0.0f));
                this.points.add(new PVector((float)this.img.width, 0.0f, 0.0f));
                this.points.add(new PVector((float)this.img.width, (float)this.img.height, 0.0f));
                this.points.add(new PVector(0.0f, (float)this.img.height, 0.0f));
                this.points.add(new PVector((float)(this.img.width / 2), (float)(this.img.height / 2), 0.0f));
                int n5 = 0;
                while (n5 < this.points.size()) {
                    n = PApplet.parseInt((float)(this.points.get((int)n5).y * (float)this.img.width + this.points.get((int)n5).x));
                    this.chosenPointsList.add(n);
                    ++n5;
                }
                this.displayImage = true;
                this.displayBlurred = false;
                this.displayMesh = false;
                this.displayResult = false;
                this.ta.setColor(this.color(0, 255, 0));
                this.ta.setText("Success.\nImage file is loaded." + string);
            } else {
                this.ta.setColor(this.color(255, 0, 0));
                this.ta.setText("Error.\nFile chosen is not a valid image file.");
            }
        } else {
            this.ta.setColor(this.color(255, 0, 0));
            this.ta.setText("Error.\nPlease choose an image file. (JPEG, JPG, PNG, TGA or GIF).");
        }
    }

    public ControlFrame addControlFrame(String string, int n, int n2) {
        Frame frame = new Frame(string);
        ControlFrame controlFrame = new ControlFrame((Object)this, n, n2);
        frame.add((Component)((Object)controlFrame));
        controlFrame.init();
        frame.setTitle(string);
        frame.setSize(controlFrame.w, controlFrame.h);
        frame.setLocation(50, 50);
        frame.setResizable(false);
        frame.setVisible(true);
        return controlFrame;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"TriangulateImage5"};
        if (stringArray != null) {
            PApplet.main((String[])TriangulateImage5.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    public class ControlFrame
    extends PApplet {
        int w;
        int h;
        ControlP5 cp5;
        Object parent;

        public void setup() {
            this.size(this.w, this.h);
            this.frameRate(25.0f);
            this.cp5 = new ControlP5((PApplet)this);
            ((Button)((Button)((Button)this.cp5.addButton("choose").setPosition(10.0f, 10.0f)).setSize(200, 20)).plugTo(this.parent, "choose")).setLabel("Choose an Image...");
            ((Slider)((Slider)this.cp5.addSlider("blur").setPosition(10.0f, 50.0f)).setSize(90, 20).setRange(0.0f, 20.0f).setValue(5.0f).setLabel("Blur Radius")).plugTo(this.parent, "blur");
            ((Slider)((Slider)this.cp5.addSlider("threshold").setPosition(10.0f, 80.0f)).setSize(90, 20).setRange(0.0f, 255.0f).setValue(10.0f).setLabel("Threshold")).plugTo(this.parent, "threshold");
            ((Button)((Button)((Button)this.cp5.addButton("blurIt").setPosition(10.0f, 110.0f)).setSize(90, 20)).plugTo(this.parent, "blurIt")).setLabel("Blur");
            ((Button)((Button)((Button)this.cp5.addButton("sPoints").setPosition(10.0f, 150.0f)).setSize(90, 20)).plugTo(this.parent, "sPoints")).setLabel("Save Points");
            ((Button)((Button)((Button)this.cp5.addButton("lPoints").setPosition(120.0f, 150.0f)).setSize(90, 20)).plugTo(this.parent, "lPoints")).setLabel("Load Points");
            TriangulateImage5.this.e = (Toggle)((Toggle)((Toggle)((Toggle)this.cp5.addToggle("eraser").plugTo(this.parent, "eraser")).setPosition(10.0f, 180.0f)).setSize(90, 20)).setLabel("On/Off Eraser (e)");
            TriangulateImage5.this.l = (Toggle)((Toggle)((Toggle)((Toggle)this.cp5.addToggle("loupe").plugTo(this.parent, "loupe")).setPosition(120.0f, 180.0f)).setSize(90, 20)).setLabel("Show/Hide Loupe (l)");
            TriangulateImage5.this.r = ((RadioButton)this.cp5.addRadioButton("passChooser").setPosition(10.0f, 240.0f)).setSize(20, 20).setItemsPerRow(2).setSpacingColumn(90).setSpacingRow(10).addItem("original (o)", 1.0f).addItem("blurred (b)", 2.0f).addItem("mesh (m)", 3.0f).addItem("result (r)", 4.0f).activate(0).plugTo(this.parent, "passChooser");
            ((Button)((Button)((Button)this.cp5.addButton("savePDF").setPosition(10.0f, 320.0f)).setSize(200, 20)).setLabel("Write to PDF")).plugTo(this.parent, "savePDF");
            TriangulateImage5.this.ta = ((Textarea)this.cp5.addTextarea("txt").setPosition(10.0f, 360.0f)).setSize(200, 60).setLineHeight(14).setColor(this.color(255)).setColorBackground(this.color(2, 52, 77)).setBorderColor(this.color(2, 52, 77)).setText("Message Window");
        }

        public void draw() {
            this.background(100);
        }

        private ControlFrame() {
        }

        public ControlFrame(Object object, int n, int n2) {
            this.parent = object;
            this.w = n;
            this.h = n2;
        }

        public ControlP5 control() {
            return this.cp5;
        }
    }
}

