/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.AudioPermission;
import sun.misc.Service;

final class JSSecurityManager {
    private JSSecurityManager() {
    }

    private static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AudioPermission("record"));
        }
    }

    static String getProperty(final String string) {
        String string2;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty(string);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                };
                string2 = (String)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                string2 = System.getProperty(string);
            }
        } else {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    static void loadProperties(final Properties properties, final String string) {
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        JSSecurityManager.loadPropertiesImpl(properties, string);
                        return null;
                    }
                };
                AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                JSSecurityManager.loadPropertiesImpl(properties, string);
            }
        } else {
            JSSecurityManager.loadPropertiesImpl(properties, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesImpl(Properties properties, String string) {
        String string2 = System.getProperty("java.home");
        try {
            if (string2 == null) {
                throw new Error("Can't find java.home ??");
            }
            File file = new File(string2, "lib");
            file = new File(file, string);
            string2 = file.getCanonicalPath();
            FileInputStream fileInputStream = new FileInputStream(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                properties.load(bufferedInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Thread createThread(Runnable runnable, String string, boolean bl, int n, boolean bl2) {
        Thread thread = new Thread(runnable);
        if (string != null) {
            thread.setName(string);
        }
        thread.setDaemon(bl);
        if (n >= 0) {
            thread.setPriority(n);
        }
        if (bl2) {
            thread.start();
        }
        return thread;
    }

    static List getProviders(Class clazz) {
        ArrayList arrayList = new ArrayList();
        final Iterator iterator = Service.providers(clazz);
        PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return iterator.hasNext();
            }
        };
        while (AccessController.doPrivileged(privilegedAction).booleanValue()) {
            try {
                Object e = iterator.next();
                if (!clazz.isInstance(e)) continue;
                arrayList.add(0, e);
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }
}

