/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public final class DataPusher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private static final boolean DEBUG = false;
    private final SourceDataLine source;
    private final AudioFormat format;
    private AudioInputStream ais = null;
    private byte[] audioData = null;
    private int audioDataByteLength = 0;
    private int pos;
    private int newPos = -1;
    private boolean looping;
    private Thread pushThread = null;
    private int wantedState;
    private int threadState;
    private final int STATE_NONE = 0;
    private final int STATE_PLAYING = 1;
    private final int STATE_WAITING = 2;
    private final int STATE_STOPPING = 3;
    private final int STATE_STOPPED = 4;
    private final int BUFFER_SIZE = 16384;

    public DataPusher(SourceDataLine sourceDataLine, AudioFormat audioFormat, byte[] byArray, int n) {
        this.audioData = byArray;
        this.audioDataByteLength = n;
        this.format = audioFormat;
        this.source = sourceDataLine;
    }

    public DataPusher(SourceDataLine sourceDataLine, AudioInputStream audioInputStream) {
        this.ais = audioInputStream;
        this.format = audioInputStream.getFormat();
        this.source = sourceDataLine;
    }

    public synchronized void start() {
        this.start(false);
    }

    public synchronized void start(boolean bl) {
        try {
            if (this.threadState == 3) {
                this.stop();
            }
            this.looping = bl;
            this.newPos = 0;
            this.wantedState = 1;
            if (!this.source.isOpen()) {
                this.source.open(this.format);
            }
            this.source.flush();
            this.source.start();
            if (this.pushThread == null) {
                this.pushThread = JSSecurityManager.createThread(this, null, false, -1, true);
            }
            this.notifyAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        if (this.threadState == 3 || this.threadState == 4 || this.pushThread == null) {
            return;
        }
        this.wantedState = 2;
        if (this.source != null) {
            this.source.flush();
        }
        this.notifyAll();
        int n = 50;
        while (n-- >= 0 && this.threadState == 1) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void close() {
        if (this.source != null) {
            this.source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] byArray = null;
        boolean bl = this.ais != null;
        byArray = bl ? new byte[16384] : this.audioData;
        while (this.wantedState != 3) {
            if (this.wantedState == 2) {
                try {
                    DataPusher dataPusher = this;
                    synchronized (dataPusher) {
                        this.threadState = 2;
                        this.wantedState = 3;
                        this.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (this.newPos >= 0) {
                this.pos = this.newPos;
                this.newPos = -1;
            }
            this.threadState = 1;
            int n = 16384;
            if (bl) {
                try {
                    this.pos = 0;
                    n = this.ais.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    n = -1;
                }
            } else {
                if (n > this.audioDataByteLength - this.pos) {
                    n = this.audioDataByteLength - this.pos;
                }
                if (n == 0) {
                    n = -1;
                }
            }
            if (n < 0) {
                if (!bl && this.looping) {
                    this.pos = 0;
                    continue;
                }
                this.wantedState = 2;
                this.source.drain();
                continue;
            }
            int n2 = this.source.write(byArray, this.pos, n);
            this.pos += n2;
        }
        this.threadState = 3;
        this.source.flush();
        this.source.stop();
        this.source.flush();
        this.source.close();
        this.threadState = 4;
        DataPusher dataPusher = this;
        synchronized (dataPusher) {
            this.pushThread = null;
            this.notifyAll();
        }
    }
}

