/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import java.security.CodeSource;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateRevokedException;

public class BlockedException
extends SecurityException {
    private final CodeSource codeSource;
    private AppInfo appInfo;

    public BlockedException(String string, Throwable throwable) {
        this(string, throwable, null, null);
    }

    public BlockedException(String string, Throwable throwable, CodeSource codeSource, AppInfo appInfo) {
        super(string, throwable);
        this.codeSource = codeSource;
        this.appInfo = appInfo;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public String getReason() {
        Throwable throwable = this.getCause();
        String string = null;
        if (throwable instanceof CertificateRevokedException) {
            string = this.getMessage("security.badcert.blocked.revoked.reason");
        } else if (throwable instanceof CertificateExpiredException) {
            string = this.getMessage("security.badcert.blocked.expired.reason");
        } else if (throwable != null) {
            string = throwable.getLocalizedMessage();
        }
        if (string == null || string.isEmpty()) {
            string = this.getLocalizedMessage();
        }
        return string;
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

