/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.jrockit.jfr.DCmd;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

final class DCmdCheck
extends DCmd {
    DCmdCheck(VMJFR vMJFR) {
        super(vMJFR);
    }

    public void execute(String string, long l, boolean bl) throws DCmdException {
        if (string != null || l != -1L) {
            this.printRecording(this.findRecording(DCmd.RecordingIdentifier.createValid(string, l)), bl);
            return;
        }
        List<Recording> list = this.getRecordings();
        if (list.isEmpty()) {
            this.println("No available recordings.", new Object[0]);
            this.println();
            this.println("Use JFR.start to start a recording.", new Object[0]);
            return;
        }
        boolean bl2 = true;
        for (Recording recording : list) {
            if (!bl2) {
                this.println();
                if (bl) {
                    this.println();
                }
            }
            bl2 = false;
            this.printRecording(recording, bl);
        }
    }

    private void printRecording(Recording recording, boolean bl) {
        this.printGeneral(recording);
        if (bl) {
            this.println();
            this.printSetttings(recording);
        }
    }

    private void printGeneral(Recording recording) {
        long l;
        String string;
        String string2 = "Recording: recording=%d name=\"%s\"";
        this.print(string2, recording.getId(), recording.getName());
        long l2 = recording.getDuration(TimeUnit.NANOSECONDS);
        if (l2 != 0L) {
            this.print(" duration=");
            this.printTimespan(l2, "");
        }
        if ((string = recording.getDestination()) != null) {
            this.print(" filename=\"%s\" compress=%s", string, recording.isDestinationCompressed());
        }
        long l3 = recording.getMaxSize();
        if (recording.getMaxSize() != 0L) {
            this.print(" maxsize=");
            this.printBytes(l3, "");
        }
        if ((l = recording.getMaxAge(TimeUnit.NANOSECONDS)) != 0L) {
            this.print(" maxage=");
            this.printTimespan(l, "");
        }
        if (!recording.isStarted()) {
            this.print(" (unstarted)");
        }
        if (recording.isRunning()) {
            this.print(" (running)");
        }
        if (recording.isStopped()) {
            this.print(" (stopped)");
        }
        this.println();
    }

    private void printSetttings(Recording recording) {
        HashMap<Integer, EventSetting> hashMap = new HashMap<Integer, EventSetting>();
        for (EventSetting object : recording.getEventSettings().getSettings()) {
            hashMap.put(object.getId(), object);
        }
        boolean bl = true;
        for (EventDescriptor eventDescriptor : DCmdCheck.sortByEventPath(this.jfr.getEvents())) {
            EventSetting eventSetting = (EventSetting)hashMap.get(eventDescriptor.getId());
            if (eventSetting == null) continue;
            if (!bl) {
                this.println();
            }
            bl = false;
            this.print(" %s (%s)", eventDescriptor.getName(), eventDescriptor.getPath());
            this.println();
            this.print("   [");
            this.printEnabled(eventSetting.isEnabled());
            if (eventDescriptor.hasStackTrace()) {
                this.print(" ");
                this.printStackTrace(eventSetting.isStacktraceEnabled());
            }
            if (eventDescriptor.isTimed()) {
                this.print(" ");
                this.printThreshold(eventSetting.getThreshold());
            }
            if (eventDescriptor.isRequestable()) {
                this.print(" ");
                this.printPeriod(eventSetting.getPeriod());
            }
            this.println("]", new Object[0]);
        }
    }

    private static List<EventDescriptor> sortByEventPath(Collection<EventDescriptor> collection) {
        ArrayList<EventDescriptor> arrayList = new ArrayList<EventDescriptor>();
        arrayList.addAll(collection);
        Collections.sort(arrayList, new Comparator<EventDescriptor>(){

            @Override
            public int compare(EventDescriptor eventDescriptor, EventDescriptor eventDescriptor2) {
                return eventDescriptor.getPath().compareTo(eventDescriptor2.getPath());
            }
        });
        return arrayList;
    }

    private void printEnabled(boolean bl) {
        this.print("enabled=" + bl);
    }

    private void printStackTrace(boolean bl) {
        this.print("stackTrace=" + bl);
    }

    private void printThreshold(long l) {
        this.print("threshold=");
        this.printTimespan(l, "");
    }

    private void printPeriod(long l) {
        this.print("period=");
        if (l == 0L) {
            this.print("everyChunk");
        } else {
            long l2 = TimeUnit.NANOSECONDS.convert(l, TimeUnit.MILLISECONDS);
            this.printTimespan(l2, "");
        }
    }
}

