/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.PixelRectangle;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_Rectangle;

public abstract class JAWTWindow
implements NativeWindow,
OffscreenLayerSurface,
OffscreenLayerOption {
    protected static final boolean DEBUG = JAWTUtil.DEBUG;
    protected boolean shallUseOffscreenLayer = false;
    protected final Component component;
    private final AWTGraphicsConfiguration config;
    private final SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private final RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    private final JAWTComponentListener jawtComponentListener;
    private boolean isApplet;
    private JAWT jawt;
    private boolean isOffscreenLayerSurface;
    protected long drawable;
    protected Rectangle bounds;
    protected Insets insets;
    private volatile long offscreenSurfaceLayer;
    private long drawable_old;
    private final Runnable detachSurfaceLayerNotify = new Runnable(){

        @Override
        public void run() {
            JAWTWindow.this.offscreenSurfaceLayer = 0L;
        }
    };

    protected JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is null");
        }
        if (!(abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration)) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is not an AWTGraphicsConfiguration: " + abstractGraphicsConfiguration);
        }
        this.component = (Component)object;
        this.config = (AWTGraphicsConfiguration)abstractGraphicsConfiguration;
        this.jawtComponentListener = new JAWTComponentListener();
        this.invalidate();
        this.isApplet = false;
        this.offscreenSurfaceLayer = 0L;
    }

    private static String id(Object object) {
        return "0x" + (null != object ? Integer.toHexString(object.hashCode()) : "nil");
    }

    private String jawtStr() {
        return "JAWTWindow[" + JAWTWindow.id(this) + "]";
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected synchronized void invalidate() {
        if (DEBUG) {
            System.err.println(this.jawtStr() + ".invalidate() - " + this.jawtComponentListener.toString());
            if (this.isSurfaceLayerAttached()) {
                System.err.println("OffscreenSurfaceLayer still attached: 0x" + Long.toHexString(this.offscreenSurfaceLayer));
            }
        }
        this.invalidateNative();
        this.jawt = null;
        this.isOffscreenLayerSurface = false;
        this.drawable = 0L;
        this.drawable_old = 0L;
        this.bounds = new Rectangle();
        this.insets = new Insets();
    }

    protected abstract void invalidateNative();

    protected final boolean updateBounds(JAWT_Rectangle jAWT_Rectangle) {
        boolean bl;
        Rectangle rectangle = new Rectangle(jAWT_Rectangle.getX(), jAWT_Rectangle.getY(), jAWT_Rectangle.getWidth(), jAWT_Rectangle.getHeight());
        boolean bl2 = bl = !this.bounds.equals(rectangle);
        if (bl) {
            if (DEBUG) {
                System.err.println("JAWTWindow.updateBounds: " + this.bounds + " -> " + rectangle);
            }
            this.bounds.set(jAWT_Rectangle.getX(), jAWT_Rectangle.getY(), jAWT_Rectangle.getWidth(), jAWT_Rectangle.getHeight());
            if (this.component instanceof Container) {
                java.awt.Insets insets = ((Container)this.component).getInsets();
                this.insets.set(insets.left, insets.right, insets.top, insets.bottom);
            }
        }
        return bl;
    }

    public final RectangleImmutable getBounds() {
        return this.bounds;
    }

    @Override
    public final InsetsImmutable getInsets() {
        return this.insets;
    }

    public final Component getAWTComponent() {
        return this.component;
    }

    public final boolean isApplet() {
        return this.isApplet;
    }

    public final JAWT getJAWT() {
        return this.jawt;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        return this.isOffscreenLayerSurface;
    }

    @Override
    public final void attachSurfaceLayer(long l) throws NativeWindowException {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new NativeWindowException("Not an offscreen layer surface");
        }
        this.attachSurfaceLayerImpl(l);
        this.offscreenSurfaceLayer = l;
        this.component.repaint();
    }

    protected void attachSurfaceLayerImpl(long l) {
        throw new UnsupportedOperationException("offscreen layer not supported");
    }

    protected void layoutSurfaceLayerImpl(long l, boolean bl) {
    }

    private final void layoutSurfaceLayerIfEnabled(boolean bl) throws NativeWindowException {
        if (this.isOffscreenLayerSurfaceEnabled() && 0L != this.offscreenSurfaceLayer) {
            this.layoutSurfaceLayerImpl(this.offscreenSurfaceLayer, bl);
        }
    }

    @Override
    public final void detachSurfaceLayer() throws NativeWindowException {
        if (0L == this.offscreenSurfaceLayer) {
            throw new NativeWindowException("No offscreen layer attached: " + this);
        }
        if (DEBUG) {
            System.err.println("JAWTWindow.detachSurfaceHandle(): osh " + this.toHexString(this.offscreenSurfaceLayer));
        }
        this.detachSurfaceLayerImpl(this.offscreenSurfaceLayer, this.detachSurfaceLayerNotify);
    }

    protected void detachSurfaceLayerImpl(long l, Runnable runnable) {
        throw new UnsupportedOperationException("offscreen layer not supported");
    }

    @Override
    public final long getAttachedSurfaceLayer() {
        return this.offscreenSurfaceLayer;
    }

    @Override
    public final boolean isSurfaceLayerAttached() {
        return 0L != this.offscreenSurfaceLayer;
    }

    @Override
    public final void setChosenCapabilities(CapabilitiesImmutable capabilitiesImmutable) {
        ((MutableGraphicsConfiguration)this.getGraphicsConfiguration()).setChosenCapabilities(capabilitiesImmutable);
        this.config.setChosenCapabilities(capabilitiesImmutable);
    }

    @Override
    public final RecursiveLock getLock() {
        return this.surfaceLock;
    }

    @Override
    public final boolean setCursor(final PixelRectangle pixelRectangle, final PointImmutable pointImmutable) {
        AWTEDTExecutor.singleton.invoke(false, new Runnable(){

            @Override
            public void run() {
                Cursor cursor = null;
                if (null == pixelRectangle || null == pointImmutable) {
                    cursor = Cursor.getDefaultCursor();
                } else {
                    java.awt.Point point = new java.awt.Point(pointImmutable.getX(), pointImmutable.getY());
                    try {
                        cursor = AWTMisc.getCursor(pixelRectangle, point);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (null != cursor) {
                    JAWTWindow.this.component.setCursor(cursor);
                }
            }
        });
        return true;
    }

    @Override
    public final boolean hideCursor() {
        AWTEDTExecutor.singleton.invoke(false, new Runnable(){

            @Override
            public void run() {
                JAWTWindow.this.component.setCursor(AWTMisc.getNullCursor());
            }
        });
        return true;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    private void determineIfApplet() {
        for (Component component = this.component; !this.isApplet && null != component; component = component.getParent()) {
            this.isApplet = component instanceof Applet;
        }
    }

    protected abstract JAWT fetchJAWTImpl() throws NativeWindowException;

    protected abstract int lockSurfaceImpl() throws NativeWindowException;

    protected void dumpJAWTInfo() {
        System.err.println(this.jawt2String(null).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            if (!this.component.isDisplayable()) {
                this.surfaceLock.unlock();
                if (DEBUG) {
                    System.err.println("JAWTWindow: Can't lock surface, component peer n/a. Component displayable " + this.component.isDisplayable() + ", " + this.component);
                    Thread.dumpStack();
                }
            } else {
                this.determineIfApplet();
                try {
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        if (null == this.jawt) {
                            this.jawt = this.fetchJAWTImpl();
                            this.isOffscreenLayerSurface = JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt);
                        }
                        if (3 == (n = this.lockSurfaceImpl()) && this.drawable_old != this.drawable) {
                            n = 2;
                            if (DEBUG) {
                                System.err.println("JAWTWindow: surface change " + this.toHexString(this.drawable_old) + " -> " + this.toHexString(this.drawable));
                            }
                        }
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        this.surfaceLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    protected abstract void unlockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.drawable_old = this.drawable;
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                if (null != this.jawt) {
                    this.unlockSurfaceImpl();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public long getSurfaceHandle() {
        return this.drawable;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.getGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public final int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.component.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.surfaceLock.lock();
        try {
            this.jawtComponentListener.detach();
            this.invalidate();
        }
        finally {
            this.surfaceLock.unlock();
        }
    }

    @Override
    public final NativeWindow getParent() {
        return null;
    }

    @Override
    public long getWindowHandle() {
        return this.drawable;
    }

    @Override
    public final int getX() {
        return this.component.getX();
    }

    @Override
    public final int getY() {
        return this.component.getY();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        Point point2 = this.getLocationOnScreenNative(point);
        if (null == point2) {
            if (!Thread.holdsLock(this.component.getTreeLock())) {
                if (DEBUG) {
                    System.err.println("Warning: JAWT Lock hold, but not the AWT tree lock: " + this);
                    Thread.dumpStack();
                }
                if (null == point) {
                    point = new Point();
                }
                JAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
                return point;
            }
            java.awt.Point point3 = this.component.getLocationOnScreen();
            point2 = null != point ? point.translate(point3.x, point3.y) : new Point(point3.x, point3.y);
        }
        return point2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point getLocationOnScreenNative(Point point) {
        int n = this.lockSurface();
        if (1 == n) {
            if (DEBUG) {
                System.err.println("Warning: JAWT Lock couldn't be acquired: " + this);
                Thread.dumpStack();
            }
            return null;
        }
        try {
            Point point2 = this.getLocationOnScreenNativeImpl(0, 0);
            if (null != point2 && null != point) {
                point.translate(point2.getX(), point2.getY());
                Point point3 = point;
                return point3;
            }
            Point point4 = point2;
            return point4;
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract Point getLocationOnScreenNativeImpl(int var1, int var2);

    protected static Component getLocationOnScreenNonBlocking(Point point, Component component) {
        java.awt.Insets insets = new java.awt.Insets(0, 0, 0, 0);
        Component component2 = null;
        while (null != component) {
            int n = component.getX();
            int n2 = component.getY();
            if (DEBUG) {
                java.awt.Insets insets2 = AWTMisc.getInsets(component, false);
                if (null != insets2) {
                    insets.bottom += insets2.bottom;
                    insets.top += insets2.top;
                    insets.left += insets2.left;
                    insets.right += insets2.right;
                }
                System.err.print("LOS: " + point + " + " + component.getClass().getName() + "[" + n + "/" + n2 + ", vis " + component.isVisible() + ", ins " + insets2 + " -> " + insets + "] -> ");
            }
            point.translate(n, n2);
            if (DEBUG) {
                System.err.println(point);
            }
            component2 = component;
            if (component instanceof Window) break;
            component = component.getParent();
        }
        return component2;
    }

    @Override
    public boolean hasFocus() {
        return this.component.hasFocus();
    }

    protected StringBuilder jawt2String(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (null != this.jawt) {
            stringBuilder.append("JAWT version: 0x").append(Integer.toHexString(this.jawt.getCachedVersion())).append(", CA_LAYER: ").append(JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt)).append(", isLayeredSurface ").append(this.isOffscreenLayerSurfaceEnabled()).append(", bounds ").append(this.bounds).append(", insets ").append(this.insets);
        } else {
            stringBuilder.append("JAWT n/a, bounds ").append(this.bounds).append(", insets ").append(this.insets);
        }
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jawtStr() + "[");
        this.jawt2String(stringBuilder);
        stringBuilder.append(", shallUseOffscreenLayer " + this.shallUseOffscreenLayer + ", isOffscreenLayerSurface " + this.isOffscreenLayerSurface + ", attachedSurfaceLayer " + this.toHexString(this.getAttachedSurfaceLayer()) + ", windowHandle " + this.toHexString(this.getWindowHandle()) + ", surfaceHandle " + this.toHexString(this.getSurfaceHandle()) + ", bounds " + this.bounds + ", insets " + this.insets);
        stringBuilder.append(", pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.component.isVisible());
        stringBuilder.append(", lockedExt " + this.isSurfaceLockedByOtherThread() + ",\n\tconfig " + this.config + ",\n\tawtComponent " + this.getAWTComponent() + ",\n\tsurfaceLock " + this.surfaceLock + "]");
        return stringBuilder.toString();
    }

    protected final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private class JAWTComponentListener
    implements ComponentListener,
    HierarchyListener {
        private boolean isShowing;

        private String str(Object object) {
            if (null == object) {
                return "0xnil: null";
            }
            if (object instanceof Component) {
                Component component = (Component)object;
                return JAWTWindow.id(object) + ": " + component.getClass().getSimpleName() + "[visible " + component.isVisible() + ", showing " + component.isShowing() + ", valid " + component.isValid() + ", displayable " + component.isDisplayable() + ", " + component.getX() + "/" + component.getY() + " " + component.getWidth() + "x" + component.getHeight() + "]";
            }
            return JAWTWindow.id(object) + ": " + object.getClass().getSimpleName() + "[..]";
        }

        private String s(ComponentEvent componentEvent) {
            return "visible[isShowing " + this.isShowing + "]," + Platform.getNewline() + "    ** COMP " + this.str(componentEvent.getComponent()) + Platform.getNewline() + "    ** SOURCE " + this.str(componentEvent.getSource()) + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        private String s(HierarchyEvent hierarchyEvent) {
            return "visible[isShowing " + this.isShowing + "], changeBits 0x" + Long.toHexString(hierarchyEvent.getChangeFlags()) + Platform.getNewline() + "    ** COMP " + this.str(hierarchyEvent.getComponent()) + Platform.getNewline() + "    ** SOURCE " + this.str(hierarchyEvent.getSource()) + Platform.getNewline() + "    ** CHANGED " + this.str(hierarchyEvent.getChanged()) + Platform.getNewline() + "    ** CHANGEDPARENT " + this.str(hierarchyEvent.getChangedParent()) + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        public final String toString() {
            return "visible[isShowing " + this.isShowing + "]," + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        private JAWTComponentListener() {
            this.isShowing = JAWTWindow.this.component.isShowing();
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".attach @ Thread " + JAWTWindow.getThreadName() + ": " + this.toString());
            }
            JAWTWindow.this.component.addComponentListener(this);
            JAWTWindow.this.component.addHierarchyListener(this);
        }

        private final void detach() {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".detach @ Thread " + JAWTWindow.getThreadName() + ": " + this.toString());
            }
            JAWTWindow.this.component.removeComponentListener(this);
            JAWTWindow.this.component.removeHierarchyListener(this);
        }

        @Override
        public final void componentResized(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".componentResized: " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentMoved(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".componentMoved: " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentShown(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".componentShown: " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentHidden(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr() + ".componentHidden: " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            boolean bl = this.isShowing;
            this.isShowing = JAWTWindow.this.component.isShowing();
            int n = 0;
            if (0L != (4L & hierarchyEvent.getChangeFlags()) && hierarchyEvent.getChanged() != JAWTWindow.this.component && bl != this.isShowing) {
                JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
                n = 1;
            }
            if (DEBUG) {
                Component component = hierarchyEvent.getChanged();
                boolean bl2 = component.isDisplayable();
                boolean bl3 = component.isShowing();
                System.err.println(JAWTWindow.this.jawtStr() + ".hierarchyChanged: action " + n + ", displayable " + bl2 + ", showing [changed " + bl3 + ", comp " + this.isShowing + "], " + this.s(hierarchyEvent));
            }
        }
    }
}

