/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.ID;
import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.foundation.NSNumber;
import com.apple.jobjc.foundation.NSString;
import java.util.concurrent.Callable;

public class Utils {
    JObjCRuntime runtime;
    private static Utils utils;
    private Strings strings_;
    private Numbers numbers_;
    private Threads threads_;

    Utils(JObjCRuntime runtime) {
        this.runtime = runtime;
    }

    public static Utils get() {
        JObjCRuntime runtime = JObjCRuntime.getInstance();
        return utils != null ? utils : (utils = new Utils(runtime));
    }

    public Strings strings() {
        return this.strings_ != null ? this.strings_ : (this.strings_ = new Strings(this.runtime));
    }

    public Numbers numbers() {
        return this.numbers_ != null ? this.numbers_ : (this.numbers_ = new Numbers(this.runtime));
    }

    public Threads threads() {
        return this.threads_ != null ? this.threads_ : (this.threads_ = new Threads(this.runtime));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Threads {
        JObjCRuntime runtime;

        private static native void performRunnableOnMainThread(Runnable var0, boolean var1);

        private static native <V> V performCallableOnMainThread(Callable<V> var0) throws Exception;

        Threads(JObjCRuntime runtime) {
            this.runtime = runtime;
        }

        public void performOnMainThread(Runnable runnable, boolean wait) {
            Threads.performRunnableOnMainThread(runnable, wait);
        }

        public <V> V performOnMainThread(Callable<V> callable) throws Exception {
            return Threads.performCallableOnMainThread(callable);
        }
    }

    public static class Numbers {
        JObjCRuntime runtime;

        private static native long getNativeNSNumberForJavaNumber(Number var0);

        private static native Number getNativeJavaNumberForNSNumber(long var0);

        Numbers(JObjCRuntime runtime) {
            this.runtime = runtime;
        }

        public NSNumber nsNumber(Number num) {
            if (num == null) {
                return null;
            }
            long nsNumber = Numbers.getNativeNSNumberForJavaNumber(num);
            return ID.createNewObjCObjectForClass(NSNumber.class, nsNumber, this.runtime);
        }

        public Number javaNumber(NSNumber num) {
            if (num == null) {
                return null;
            }
            return Numbers.getNativeJavaNumberForNSNumber(num.ptr);
        }
    }

    public static class Strings {
        JObjCRuntime runtime;

        private static native long getNativeNSStringForJavaString(String var0);

        private static native String getNativeJavaStringForNSString(long var0);

        Strings(JObjCRuntime runtime) {
            this.runtime = runtime;
        }

        public NSString nsString(String str) {
            if (str == null) {
                return null;
            }
            long nsString = Strings.getNativeNSStringForJavaString(str);
            return ID.createNewObjCObjectForClass(NSString.class, nsString, this.runtime);
        }

        public String javaString(NSString str) {
            if (str == null) {
                return null;
            }
            return Strings.getNativeJavaStringForNSString(str.ptr);
        }
    }
}

