/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.JObjCRuntime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NativeBuffer {
    public final ByteBuffer buffer;
    public final long bufferPtr;

    static native long getPtrOfBuffer(ByteBuffer var0);

    public NativeBuffer(int capacity) {
        this(ByteBuffer.allocateDirect(capacity));
    }

    public NativeBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.bufferPtr = NativeBuffer.getPtrOfBuffer(buffer);
        assert (buffer != null);
        assert (this.bufferPtr != 0L);
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public byte get() {
        return this.buffer.get();
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public NativeBuffer put(byte b) {
        this.buffer.put(b);
        return this;
    }

    public NativeBuffer put(NativeBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public NativeBuffer putChar(char c) {
        this.buffer.putChar(c);
        return this;
    }

    public NativeBuffer putDouble(double d) {
        this.buffer.putDouble(d);
        return this;
    }

    public NativeBuffer putFloat(float f) {
        this.buffer.putFloat(f);
        return this;
    }

    public NativeBuffer putInt(int i) {
        this.buffer.putInt(i);
        return this;
    }

    public NativeBuffer putLong(long l) {
        this.buffer.putLong(l);
        return this;
    }

    public NativeBuffer putShort(short s) {
        this.buffer.putShort(s);
        return this;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int position() {
        return this.buffer.position();
    }

    public NativeBuffer position(int newPosition) {
        this.buffer.position(newPosition);
        return this;
    }

    public NativeBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    public int limit() {
        return this.buffer.limit();
    }

    public NativeBuffer limit(int sizeof) {
        this.buffer.limit(sizeof);
        return this;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public NativeBuffer slice() {
        return new NativeBuffer(this.buffer.slice());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.limit(); i += JObjCRuntime.PTR_LEN) {
            if (this.position() == i) {
                builder.append("*");
            }
            if (JObjCRuntime.IS32) {
                builder.append(this.buffer.getInt(i));
            } else {
                builder.append(this.buffer.getLong(i));
            }
            builder.append(" ");
        }
        return builder.toString();
    }

    public long positionPtr() {
        return this.bufferPtr + (long)this.position();
    }

    public boolean ptrInBounds(long ptr) {
        return this.bufferPtr <= ptr && ptr < this.bufferPtr + (long)this.capacity();
    }
}

