/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.ID;
import com.apple.jobjc.NSClass;
import com.apple.jobjc.NativeArgumentBuffer;
import com.apple.jobjc.Subclassing;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JObjCRuntime {
    public static final Arch ARCH;
    public static final Width WIDTH;
    public static final boolean IS32;
    public static final boolean IS64;
    public static final int PTR_LEN;
    public static final boolean IS_BIG_ENDIAN;
    static final boolean DEBUG;
    private static JObjCRuntime instance;
    final Unsafe unsafe = JObjCRuntime.getUnsafe();
    final Subclassing subclassing = new Subclassing(this);
    final List<String> registeredPackages = new ArrayList<String>();

    private static Arch getArch() {
        String arch = System.getProperty("os.arch");
        if ("ppc".equals(arch)) {
            return Arch.ppc;
        }
        if ("i386".equals(arch)) {
            return Arch.i386;
        }
        if ("x86_64".equals(arch)) {
            return Arch.x86_64;
        }
        if ("amd64".equals(arch)) {
            return Arch.x86_64;
        }
        if ("universal".equals(arch)) {
            return Arch.x86_64;
        }
        throw new RuntimeException("Did not recognize os.arch system property: '" + arch + "'");
    }

    private static Width getWidth() {
        String width = System.getProperty("sun.arch.data.model");
        if ("32".equals(width)) {
            return Width.W32;
        }
        if ("64".equals(width)) {
            return Width.W64;
        }
        throw new RuntimeException("Did not recognize sun.arch.data.model system property: '" + width + "'");
    }

    static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
        }
    }

    public final void assertOK() {
        if (this != instance) {
            throw new SecurityException("runtime");
        }
    }

    private JObjCRuntime() {
    }

    static JObjCRuntime inst() {
        if (instance == null) {
            instance = new JObjCRuntime();
        }
        return instance;
    }

    public static JObjCRuntime getInstance() {
        JObjCRuntime.checkPermission();
        return JObjCRuntime.inst();
    }

    public final NativeArgumentBuffer getThreadLocalState() {
        return NativeArgumentBuffer.getThreadLocalBuffer(this);
    }

    Class<? extends ID> getClassForNativeClassName(String className) {
        for (String pkg : this.registeredPackages) {
            try {
                Class<?> clazz = Class.forName(pkg + "." + className);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    private static final Unsafe getUnsafe() {
        Unsafe inst = null;
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            inst = (Unsafe)f.get(null);
            if (inst == null) {
                throw new NullPointerException("Unsafe.theUnsafe == null");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get instance of Unsafe.", e);
        }
        return inst;
    }

    public void registerPackage(String pkg) {
        this.registeredPackages.add(pkg);
    }

    public boolean registerUserClass(Class<? extends ID> clazz, Class<? extends NSClass> clazzClazz) {
        return this.subclassing.registerUserClass(clazz, clazzClazz);
    }

    static {
        System.loadLibrary("JObjC");
        ARCH = JObjCRuntime.getArch();
        WIDTH = JObjCRuntime.getWidth();
        IS32 = System.getProperty("sun.arch.data.model").equals("32");
        IS64 = System.getProperty("sun.arch.data.model").equals("64");
        PTR_LEN = IS64 ? 8 : 4;
        IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        DEBUG = Boolean.parseBoolean(System.getProperty("JObjC.debug"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Width {
        W32,
        W64;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arch {
        ppc,
        i386,
        x86_64;

    }
}

