/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.FFIType;
import com.apple.jobjc.ID;
import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.NSClass;
import com.apple.jobjc.NativeArgumentBuffer;
import com.apple.jobjc.Pointer;
import com.apple.jobjc.PrimitiveCoder;
import com.apple.jobjc.SEL;
import com.apple.jobjc.Struct;
import java.io.StringWriter;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Coder<T> {
    static final int FFI_VOID = 0;
    static final int FFI_PTR = 1;
    static final int FFI_SINT8 = 2;
    static final int FFI_UINT8 = 3;
    static final int FFI_SINT16 = 4;
    static final int FFI_UINT16 = 5;
    static final int FFI_SINT32 = 6;
    static final int FFI_UINT32 = 7;
    static final int FFI_SINT64 = 8;
    static final int FFI_UINT64 = 9;
    static final int FFI_FLOAT = 10;
    static final int FFI_DOUBLE = 11;
    static final int FFI_LONGDOUBLE = 12;
    private static long[] ffiCodesToFFITypePtrs;
    private final int ffiTypeCode;
    private final String objCEncoding;
    private final Class jclass;
    private final Class jprim;
    private static Coder[] runtimeCoders;

    private static native long getNativeFFITypePtrForCode(int var0);

    long getFFITypePtr() {
        return ffiCodesToFFITypePtrs[this.getTypeCode()];
    }

    public abstract void push(JObjCRuntime var1, long var2, T var4);

    public abstract T pop(JObjCRuntime var1, long var2);

    public void push(NativeArgumentBuffer args, T x) {
        this.push(args.runtime, args.argValuesPtr, x);
        args.didPutArgValue(this.sizeof());
    }

    public T pop(NativeArgumentBuffer args) {
        return this.pop(args.runtime, args.retValPtr);
    }

    public abstract int sizeof(JObjCRuntime.Width var1);

    public final int sizeof() {
        return this.sizeof(JObjCRuntime.WIDTH);
    }

    public Coder(int ffiTypeCode, String objCEncoding, Class jclass, Class jprim) {
        this.ffiTypeCode = ffiTypeCode;
        this.objCEncoding = objCEncoding;
        this.jclass = jclass;
        this.jprim = jprim;
    }

    public Coder(int ffiTypeCode, String objCEncoding, Class jclass) {
        this(ffiTypeCode, objCEncoding, jclass, null);
    }

    final int getTypeCode() {
        return this.ffiTypeCode;
    }

    final String getObjCEncoding() {
        return this.objCEncoding;
    }

    public final Class getJavaClass() {
        return this.jclass;
    }

    public final Class getJavaPrimitive() {
        return this.jprim;
    }

    public static Coder getCoderAtRuntimeForType(Class cls) {
        if (runtimeCoders == null) {
            runtimeCoders = new Coder[]{NSClassCoder.INST, IDCoder.INST, PointerCoder.INST, PrimitiveCoder.DoubleCoder.INST, PrimitiveCoder.FloatCoder.INST, PrimitiveCoder.SLongLongCoder.INST, PrimitiveCoder.SIntCoder.INST, PrimitiveCoder.SShortCoder.INST, PrimitiveCoder.SCharCoder.INST, PrimitiveCoder.BoolCoder.INST, VoidCoder.INST};
        }
        for (Coder c : runtimeCoders) {
            if ((c.getJavaClass() == null || !c.getJavaClass().isAssignableFrom(cls)) && (c.getJavaPrimitive() == null || !c.getJavaPrimitive().isAssignableFrom(cls))) continue;
            return c;
        }
        if (Struct.class.isAssignableFrom(cls)) {
            try {
                Method m = cls.getDeclaredMethod("getStructCoder", new Class[0]);
                m.setAccessible(true);
                return (Coder)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Could not find suitable coder for " + cls);
    }

    public static Coder getCoderAtRuntime(Object inst) {
        if (inst == null) {
            return PointerCoder.INST;
        }
        if (inst instanceof Struct) {
            return ((Struct)inst).getCoder();
        }
        return Coder.getCoderAtRuntimeForType(inst.getClass());
    }

    static {
        System.loadLibrary("JObjC");
        ffiCodesToFFITypePtrs = new long[13];
        for (int i = 0; i < 13; ++i) {
            Coder.ffiCodesToFFITypePtrs[i] = Coder.getNativeFFITypePtrForCode(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NSClassCoder
    extends Coder<NSClass> {
        public static final NSClassCoder INST = new NSClassCoder();

        public NSClassCoder() {
            super(1, "#", NSClass.class);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return PrimitivePointerCoder.INST.sizeof(w);
        }

        @Override
        public NSClass pop(JObjCRuntime runtime, long addr) {
            long clsPtr = PrimitivePointerCoder.INST.popPtr(runtime, addr);
            if (clsPtr == 0L) {
                return null;
            }
            return NSClass.getObjCClassFor(runtime, clsPtr);
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, NSClass x) {
            PointerCoder.INST.push(runtime, addr, x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IDCoder
    extends Coder<ID> {
        public static final IDCoder INST = new IDCoder();

        public IDCoder() {
            super(1, "@", ID.class);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return PrimitivePointerCoder.INST.sizeof(w);
        }

        public <T extends ID> T newID(JObjCRuntime runtime, long objPtr) {
            return ID.getObjCObjectFor(runtime, objPtr);
        }

        @Override
        public ID pop(JObjCRuntime runtime, long addr) {
            return this.newID(runtime, PrimitivePointerCoder.INST.popPtr(runtime, addr));
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, ID x) {
            PointerCoder.INST.push(runtime, addr, x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StructCoder
    extends Coder<Struct> {
        private final FFIType ffiType;
        final int sizeof;

        public StructCoder(int sizeof, Coder ... elementCoders) {
            super(-1, StructCoder.objCEncoding(elementCoders), null);
            this.ffiType = new FFIType(elementCoders);
            this.sizeof = sizeof;
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return this.sizeof;
        }

        private static String objCEncoding(Coder[] elementCoders) {
            StringWriter str = new StringWriter();
            str.append("{?=");
            for (Coder c : elementCoders) {
                str.append(c.getObjCEncoding());
            }
            str.append("}");
            return str.toString();
        }

        @Override
        long getFFITypePtr() {
            return this.ffiType.getPtr();
        }

        @Override
        public void push(NativeArgumentBuffer argBuf, Struct x) {
            argBuf.doPutArgPtr(x.raw.bufferPtr);
        }

        @Override
        public void push(JObjCRuntime rt, long addr, Struct x) {
            rt.unsafe.copyMemory(x.raw.bufferPtr, addr, this.sizeof);
        }

        protected abstract Struct newInstance(JObjCRuntime var1);

        @Override
        public Struct pop(JObjCRuntime runtime, long addr) {
            Struct s = this.newInstance(runtime);
            runtime.unsafe.copyMemory(addr, s.raw.bufferPtr, this.sizeof);
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SELCoder
    extends Coder<SEL> {
        public static final SELCoder INST = new SELCoder();

        public SELCoder() {
            super(1, ":", SEL.class);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return PrimitivePointerCoder.INST.sizeof(w);
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, SEL x) {
            PrimitivePointerCoder.INST.push(runtime, addr, x == null ? 0L : x.selPtr);
        }

        @Override
        public SEL pop(JObjCRuntime runtime, long addr) {
            return new SEL(PrimitivePointerCoder.INST.popPtr(runtime, addr));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PointerCoder
    extends Coder<Pointer> {
        public static final PointerCoder INST = new PointerCoder();

        public PointerCoder() {
            super(1, "^?", Pointer.class);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return PrimitivePointerCoder.INST.sizeof(w);
        }

        @Override
        public Pointer pop(JObjCRuntime runtime, long addr) {
            return new Pointer(PrimitivePointerCoder.INST.popPtr(runtime, addr));
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, Pointer x) {
            PrimitivePointerCoder.INST.push(runtime, addr, x == null ? 0L : x.ptr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PrimitivePointerCoder
    extends Coder<Long> {
        public static final PrimitivePointerCoder INST = new PrimitivePointerCoder();

        public PrimitivePointerCoder() {
            super(1, "^?", Long.class, Long.TYPE);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return JObjCRuntime.PTR_LEN;
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, long x) {
            if (JObjCRuntime.IS64) {
                runtime.unsafe.putLong(addr, x);
            } else {
                runtime.unsafe.putInt(addr, (int)x);
            }
        }

        public void push(JObjCRuntime runtime, NativeArgumentBuffer argBuf, long ptr) {
            this.push(runtime, argBuf.argValuesPtr, ptr);
            argBuf.didPutArgValue(this.sizeof());
        }

        public long popPtr(JObjCRuntime runtime, long addr) {
            return JObjCRuntime.IS64 ? runtime.unsafe.getLong(addr) : (long)runtime.unsafe.getInt(addr);
        }

        public long popPtr(JObjCRuntime runtime, NativeArgumentBuffer argBuf) {
            return this.popPtr(runtime, argBuf.retValPtr);
        }

        @Override
        public Long pop(JObjCRuntime runtime, long addr) {
            return this.popPtr(runtime, addr);
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, Long x) {
            this.push(runtime, addr, (long)x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UnknownCoder
    extends Coder<Object> {
        public static final UnknownCoder INST = new UnknownCoder();

        public UnknownCoder() {
            super(-1, "?", null, null);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return -1;
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, Object x) {
            throw new RuntimeException("Coder not implemented");
        }

        @Override
        public Object pop(JObjCRuntime runtime, long addr) {
            throw new RuntimeException("Coder not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VoidCoder
    extends Coder<Object> {
        public static final VoidCoder INST = new VoidCoder();

        public VoidCoder() {
            super(0, "v", Void.class, Void.TYPE);
        }

        @Override
        public int sizeof(JObjCRuntime.Width w) {
            return -1;
        }

        @Override
        public Object pop(JObjCRuntime runtime, long addr) {
            throw new RuntimeException("Trying to pop a Void.");
        }

        @Override
        public void push(JObjCRuntime runtime, long addr, Object x) {
            throw new RuntimeException("Trying to push a Void.");
        }
    }
}

