/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.Coder;
import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.NativeArgumentBuffer;
import com.apple.jobjc.NativeBuffer;

class CIF {
    private static final int SIZEOF = CIF.getSizeofCIF();
    final NativeBuffer cif;
    final Coder returnCoder;
    final Coder[] argCoders;

    private static native int getSizeofCIF();

    private static native boolean prepCIF(long var0, int var2, long var3, long var5);

    public static CIF createCIFFor(NativeArgumentBuffer args, Coder returnCoder, Coder ... argCoders) {
        long argsPtr;
        NativeBuffer cifBuf = new NativeBuffer(SIZEOF + argCoders.length * JObjCRuntime.PTR_LEN);
        long argsIterPtr = argsPtr = cifBuf.bufferPtr + (long)SIZEOF;
        for (Coder coder : argCoders) {
            Coder.PrimitivePointerCoder.INST.push(args.runtime, argsIterPtr, coder.getFFITypePtr());
            argsIterPtr += (long)JObjCRuntime.PTR_LEN;
        }
        boolean ok = CIF.prepCIF(cifBuf.bufferPtr, argCoders.length, returnCoder.getFFITypePtr(), argsPtr);
        if (!ok) {
            throw new RuntimeException("ffi_prep_cif failed.");
        }
        return new CIF(cifBuf, returnCoder, argCoders);
    }

    private CIF(NativeBuffer cif, Coder returnCoder, Coder ... argCoders) {
        this.cif = cif;
        this.returnCoder = returnCoder;
        this.argCoders = argCoders;
    }
}

