/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.util;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.util.Optional;

public class TaskResultUtil {
    private TaskResultUtil() {
    }

    public static String getLocalizedTextForResult(LocalizationProvider localizationProvider, ScheduleMetadata.ResultReason resultReason, String string) {
        if (resultReason != null) {
            switch (resultReason) {
                case EXECUTION_CANCELED: {
                    return localizationProvider.getLocalizedString(ResultReasonTranslationKey.KEY_EXECUTION_CANCELED.getKey());
                }
                case JUMP_LABEL_MISSING: {
                    return localizationProvider.getLocalizedString(ResultReasonTranslationKey.KEY_JUMP_LABEL_MISSING.getKey(), new Object[]{string});
                }
                case INTERNAL_ERROR: {
                    return localizationProvider.getLocalizedString(ResultReasonTranslationKey.KEY_INTERNAL_ERROR.getKey(), new Object[]{string});
                }
                case SCHEDULE_MISSED: {
                    return localizationProvider.getLocalizedString(ResultReasonTranslationKey.KEY_SCHEDULE_MISSED.getKey());
                }
            }
        }
        return string;
    }

    public static enum ResultReasonTranslationKey {
        KEY_EXECUTION_CANCELED("common.resultReason.taskExecutionCanceled"),
        KEY_JUMP_LABEL_MISSING("common.resultReason.jumpLabelMissing"),
        KEY_INTERNAL_ERROR("common.resultReason.internalErrorOccured"),
        KEY_SCHEDULE_MISSED("common.resultReason.taskExecutionSkipped");

        private String key;

        private ResultReasonTranslationKey(String string2) {
            this.key = string2;
        }

        public String getKey() {
            return this.key;
        }

        public static Optional<ResultReasonTranslationKey> forKey(String string) {
            for (ResultReasonTranslationKey resultReasonTranslationKey : ResultReasonTranslationKey.values()) {
                if (!resultReasonTranslationKey.getKey().equals(string)) continue;
                return Optional.of(resultReasonTranslationKey);
            }
            return Optional.empty();
        }
    }
}

