/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.textPane;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.ttd.constant.TaskTillDawnConstants;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownTypeConverterException;
import de.oliver_matuschin.ttd.plugin.converter.TypeConverter;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.ui.button.PopupButton;
import de.oliver_matuschin.ttd.ui.popupMenu.VariablePopupMenu;
import de.oliver_matuschin.ttd.ui.type.TypeInformationProvider;
import de.oliver_matuschin.util.TypeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class VariableTextPane
extends JPanel {
    private LocalizationProvider localizationProvider;
    private TypeInformationProvider typeInformationProvider;
    private ActionPackPluginManager actionPackPluginManager;
    private UIManager uiManager;
    private List<Action.ActionVariable> variables;
    private JTextPane textPane;
    private PopupButton addButton;

    public VariableTextPane(String string, boolean bl, boolean bl2, boolean bl3, LocalizationProvider localizationProvider, UIManager uIManager, TypeInformationProvider typeInformationProvider, ActionPackPluginManager actionPackPluginManager, List<Action.ActionVariable> list) {
        this.variables = list;
        this.localizationProvider = localizationProvider;
        this.typeInformationProvider = typeInformationProvider;
        this.actionPackPluginManager = actionPackPluginManager;
        this.uiManager = uIManager;
        this.initUI(bl, bl2, bl3);
        if (string != null) {
            this.setText(string);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.textPane.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.textPane.removeKeyListener(keyListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textPane.setEnabled(bl);
        this.addButton.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.textPane.isEnabled();
    }

    private void initUI(boolean bl, boolean bl2, boolean bl3) {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.textPane = new JTextPane();
        this.textPane.setBorder(BorderFactory.createEmptyBorder(this.getPixelsForDots(2), this.getPixelsForDots(2), this.getPixelsForDots(2), this.getPixelsForDots(2)));
        this.textPane.setOpaque(true);
        this.textPane.setBackground(Color.WHITE);
        this.textPane.setEditable(bl2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        if (bl) {
            jScrollPane.setPreferredSize(this.uiManager.getPixelsForDots(new Dimension(1, 90)));
            if (bl3) {
                jScrollPane.getViewport().add(this.textPane);
            } else {
                jComponent = new JPanel(new BorderLayout());
                jComponent.setOpaque(false);
                jComponent.setBorder(null);
                jComponent.add((Component)this.textPane, "Center");
                jScrollPane.getViewport().add(jComponent);
            }
        } else {
            jComponent = new JPanel(new BorderLayout());
            jComponent.setOpaque(false);
            jComponent.setBorder(null);
            jComponent.add((Component)this.textPane, "Center");
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getViewport().add(jComponent);
        }
        this.add((Component)jScrollPane, "Center");
        this.setMaximumSize(new Dimension(this.textPane.getMaximumSize().width, this.textPane.getPreferredSize().height + this.getPixelsForDots(2)));
        if (bl2) {
            jComponent = new VariablePopupMenu(this.localizationProvider, this.actionPackPluginManager, this.typeInformationProvider, this.variables, (Type)((Object)String.class), false);
            ((VariablePopupMenu)jComponent).addVariableSelectionListener(new VariablePopupMenu.VariableSelectionListener(){

                @Override
                public void variableSelected(Action.ConvertibleVariable convertibleVariable) {
                    VariableTextPane.this.textPane.insertComponent(VariableTextPane.this.newVariableNameLabel(convertibleVariable, VariableTextPane.this.actionPackPluginManager));
                    VariableTextPane.this.textPane.setCaretPosition(VariableTextPane.this.textPane.getCaretPosition());
                    VariableTextPane.this.textPane.requestFocus();
                }
            });
            this.addButton = new PopupButton();
            this.addButton.setFocusPainted(false);
            this.addButton.setContentAreaFilled(false);
            this.addButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_insert_variable.png"));
            this.addButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_insert_variable_pressed.png"));
            this.addButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_insert_variable_disabled.png"));
            this.addButton.setToolTipText(this.localizationProvider.getLocalizedString("pane.VariableTextPane.button.addVariable"));
            this.addButton.setPopupMenu((JPopupMenu)jComponent);
            if (bl) {
                this.add((Component)UIUtil.createMiniToolbar((Component[])new Component[]{this.addButton}), "South");
            } else {
                this.addButton.setBorder(BorderFactory.createEmptyBorder(this.uiManager.getPixelsForDots(4), this.uiManager.getPixelsForDots(5), this.uiManager.getPixelsForDots(4), this.uiManager.getPixelsForDots(5)));
                this.add((Component)this.addButton, "West");
            }
            this.addListeners(bl);
        } else {
            this.setOpaque(false);
            this.setBorder(null);
            this.textPane.setOpaque(false);
            this.textPane.setBorder(null);
            jScrollPane.getViewport().setOpaque(false);
        }
    }

    private void addListeners(boolean bl) {
        if (!bl) {
            ((AbstractDocument)this.textPane.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    filterBypass.insertString(n, string.replaceAll("[\\r\\n]", ""), attributeSet);
                }

                @Override
                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    filterBypass.replace(n, n2, string.replaceAll("[\\r\\n]", ""), attributeSet);
                }
            });
            this.textPane.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    this.handleEvent(keyEvent);
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    this.handleEvent(keyEvent);
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    this.handleEvent(keyEvent);
                }

                private void handleEvent(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 9) {
                        keyEvent.consume();
                        if ((keyEvent.getModifiersEx() & 0x40) > 0) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                        } else {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                        }
                    }
                }
            });
        }
    }

    private JLabel newVariableNameLabel(Action.ConvertibleVariable convertibleVariable, ActionPackPluginManager actionPackPluginManager) {
        VariableNameLabel variableNameLabel = new VariableNameLabel(convertibleVariable, actionPackPluginManager);
        variableNameLabel.setBorder(BorderFactory.createEmptyBorder(0, this.getPixelsForDots(10), 0, this.getPixelsForDots(10)));
        variableNameLabel.setOpaque(true);
        variableNameLabel.setFont(this.uiManager.getFont(UIManager.FontSize.MEDIUM));
        variableNameLabel.setIconTextGap(this.uiManager.getPixelsForDots(7));
        variableNameLabel.setIcon(this.typeInformationProvider.getIconForType(TypeUtil.getTypeFromString((String)convertibleVariable.getType())));
        variableNameLabel.setBackground(TaskTillDawnConstants.VARIABLE_COLOR);
        variableNameLabel.setHorizontalAlignment(0);
        variableNameLabel.setMaximumSize(new Dimension(this.getTextWidthForString(variableNameLabel.getText(), variableNameLabel.getFont()) + variableNameLabel.getIcon().getIconWidth() + variableNameLabel.getIconTextGap() + this.getPixelsForDots(20), this.getPixelsForDots(16)));
        variableNameLabel.setAlignmentY(0.86f);
        return variableNameLabel;
    }

    private int getPixelsForDots(int n) {
        if (this.uiManager.getDPIMultiplier() > 1.5f) {
            return 2 * n;
        }
        return n;
    }

    private int getTextWidthForString(String string, Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    public String getText() {
        Element element;
        StringBuilder stringBuilder = new StringBuilder(this.textPane.getText());
        int n = 0;
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        ElementIterator elementIterator = new ElementIterator(styledDocument);
        while ((element = elementIterator.next()) != null) {
            AttributeSet attributeSet = element.getAttributes();
            if (!attributeSet.containsAttribute("$ename", "component") || !(StyleConstants.getComponent(attributeSet) instanceof VariableNameLabel)) continue;
            VariableNameLabel variableNameLabel = (VariableNameLabel)StyleConstants.getComponent(attributeSet);
            Action.ConvertibleVariable convertibleVariable = variableNameLabel.getActionVariable();
            StringBuilder stringBuilder2 = new StringBuilder().append("\u001e").append(convertibleVariable.getName()).append("\u001f").append(convertibleVariable.getType()).append(convertibleVariable.getConverter() != null ? "\u001f" + convertibleVariable.getConverter() : "").append(convertibleVariable.getConfiguration() != null ? "\u001f" + convertibleVariable.getConfiguration() : "").append("\u001e");
            stringBuilder.replace(n + element.getStartOffset(), n + element.getEndOffset(), stringBuilder2.toString());
            n += stringBuilder2.toString().length() - (element.getEndOffset() - element.getStartOffset());
        }
        return stringBuilder.toString();
    }

    public List<Action.ActionVariable> getUsedActionVariables() {
        Element element;
        ArrayList<Action.ActionVariable> arrayList = new ArrayList<Action.ActionVariable>();
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        ElementIterator elementIterator = new ElementIterator(styledDocument);
        while ((element = elementIterator.next()) != null) {
            AttributeSet attributeSet = element.getAttributes();
            if (!attributeSet.containsAttribute("$ename", "component") || !(StyleConstants.getComponent(attributeSet) instanceof VariableNameLabel)) continue;
            VariableNameLabel variableNameLabel = (VariableNameLabel)StyleConstants.getComponent(attributeSet);
            arrayList.add(variableNameLabel.getActionVariable());
        }
        return arrayList;
    }

    public void setText(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            string = "";
        }
        int n2 = 0;
        int n3 = 0;
        LinkedHashMap<Integer, StringBuilder> linkedHashMap = new LinkedHashMap<Integer, StringBuilder>();
        StringBuilder stringBuilder2 = null;
        int n4 = string.length();
        block4: for (n = 0; n < n4; ++n) {
            switch (n2) {
                case 0: {
                    Object object = string.substring(n, n + 1);
                    if (((String)object).equals("\u001e")) {
                        n2 = 1;
                        stringBuilder2 = new StringBuilder();
                        linkedHashMap.put(n - n3, stringBuilder2);
                        continue block4;
                    }
                    stringBuilder.append((String)object);
                    continue block4;
                }
                case 1: {
                    Object object = string.substring(n, n + 1);
                    ++n3;
                    if (((String)object).equals("\u001e")) {
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder2.append((String)object);
                }
            }
        }
        this.textPane.setText(stringBuilder.toString());
        n = 0;
        for (Integer n5 : linkedHashMap.keySet()) {
            String string2 = ((StringBuilder)linkedHashMap.get(n5)).toString();
            String[] stringArray = string2.split("\u001f");
            if (stringArray.length <= 1) continue;
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = null;
            String string6 = null;
            if (stringArray.length > 2) {
                string5 = stringArray[2];
            }
            if (stringArray.length > 3) {
                string6 = stringArray[3];
            }
            Action.ConvertibleVariable convertibleVariable = new Action.ConvertibleVariable(string3, string4, string5, string6);
            boolean bl = false;
            boolean bl2 = false;
            for (Action.ActionVariable actionVariable : this.variables) {
                if (!actionVariable.getName().equals(string3)) continue;
                bl = true;
                bl2 = actionVariable.getType().equals(string4);
                break;
            }
            if (!bl) {
                this.variables.add(convertibleVariable);
            } else if (!bl2) {
                ++n;
                continue;
            }
            this.textPane.setCaretPosition(n5 - n);
            this.textPane.insertComponent(this.newVariableNameLabel(convertibleVariable, this.actionPackPluginManager));
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.textPane != null) {
            this.textPane.setForeground(color);
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            this.textPane.setDocument(styledDocument);
        }
        super.setForeground(color);
    }

    @Override
    public Color getForeground() {
        if (this.textPane != null) {
            return this.textPane.getForeground();
        }
        return super.getForeground();
    }

    private static class VariableNameLabel
    extends JLabel {
        private Action.ConvertibleVariable actionVariable;

        public VariableNameLabel(Action.ConvertibleVariable convertibleVariable, ActionPackPluginManager actionPackPluginManager) {
            super(VariableNameLabel.getVariableName(convertibleVariable, actionPackPluginManager));
            this.actionVariable = convertibleVariable;
        }

        private static String getVariableName(Action.ConvertibleVariable convertibleVariable, ActionPackPluginManager actionPackPluginManager) {
            block5: {
                if (convertibleVariable.getConverter() != null && convertibleVariable.getConfiguration() != null) {
                    try {
                        TypeConverter typeConverter = actionPackPluginManager.getTypeConverterForName(convertibleVariable.getConverter());
                        List<TypeConverter.Option> list = typeConverter.getOptions(TypeUtil.getTypeFromString((String)convertibleVariable.getType()), (Type)((Object)String.class));
                        if (list != null && list.size() > 0) {
                            for (TypeConverter.Option option : list) {
                                if (option == null || !convertibleVariable.getConfiguration().equals(option.getConfiguration())) continue;
                                return convertibleVariable.getName() + ": " + option.getLocalizedDescription();
                            }
                            break block5;
                        }
                        return convertibleVariable.getName();
                    }
                    catch (UnknownTypeConverterException unknownTypeConverterException) {
                        return "<error>";
                    }
                }
            }
            return convertibleVariable.getName();
        }

        public Action.ConvertibleVariable getActionVariable() {
            return this.actionVariable;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.clipRect(2, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
        }
    }
}

