/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.renderer;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.constant.TaskTillDawnConstants;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.plugin.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractPredictableSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractRestrictedTimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.IntervalSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.TimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.Trigger;
import de.oliver_matuschin.ttd.ui.imaging.AnimatedImage;
import de.oliver_matuschin.ttd.ui.model.TaskContainer;
import de.oliver_matuschin.ttd.ui.model.TaskListModel;
import de.oliver_matuschin.ttd.util.TaskResultUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.image.ImageObserver;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class TaskListCellRenderer
extends JPanel
implements ListCellRenderer<TaskContainer>,
ImageObserver {
    private int viewOptions;
    private final JLabel titleLabel = new JLabel();
    private final JPanel informationPane = new JPanel(new BorderLayout());
    private final JPanel iconPane = new JPanel(new FlowLayout(3));
    private final JLabel taskIconLabel1 = new JLabel("", 0);
    private final JLabel taskIconLabel2 = new JLabel("", 0);
    private final JLabel taskIconLabel3 = new JLabel("", 0);
    private final JPanel informationTextPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
    private final JPanel leftPane = new JPanel((LayoutManager)new VerticalFlowLayout());
    private final JLabel statusLabel = new JLabel("", 0);
    private final JLabel smallStatusTextLabel = new JLabel("", 0);
    private AnimatedImage progressIcon;
    private final ImageIcon errorIcon = ImageBuilder.buildFor((String)"/resources/task_status_error.png");
    private final ImageIcon errorIconDisabled = ImageBuilder.buildFor((String)"/resources/task_status_error_disabled.png");
    private ImageIcon noScheduleIcon;
    private ImageIcon intervalScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval.png");
    private ImageIcon intervalScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval_disabled.png");
    private ImageIcon timeScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time.png");
    private ImageIcon timeScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time_disabled.png");
    private ImageIcon triggerScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger.png");
    private ImageIcon triggerScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger_disabled.png");
    private List<JLabel> labelsList;
    private LocalizationProvider localizationProvider;
    private UIManager uiManager;
    private ActionPackPluginManager actionPackPluginManager;

    public TaskListCellRenderer(ActionPackPluginManager actionPackPluginManager, LocalizationProvider localizationProvider, UIManager uIManager, int n) {
        this.actionPackPluginManager = actionPackPluginManager;
        this.uiManager = uIManager;
        this.localizationProvider = localizationProvider;
        this.viewOptions = n;
        this.labelsList = new ArrayList<JLabel>();
        for (int i = 0; i < 150; ++i) {
            JLabel jLabel = new JLabel();
            jLabel.setFont(uIManager.getFont(UIManager.FontSize.MEDIUM));
            jLabel.setOpaque(false);
            this.labelsList.add(jLabel);
        }
        if ((this.viewOptions & 1) == 0) {
            this.iconPane.add(this.statusLabel);
        }
        this.iconPane.add(this.taskIconLabel1);
        this.iconPane.add(this.taskIconLabel2);
        this.iconPane.add(this.taskIconLabel3);
        this.iconPane.setOpaque(true);
        this.leftPane.add(this.iconPane);
        if ((this.viewOptions & 1) > 0) {
            this.leftPane.add(new JLabel(" "));
            this.leftPane.add(this.statusLabel);
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            jPanel.setBorder(null);
            jPanel.add(this.smallStatusTextLabel);
            this.leftPane.add(jPanel);
        }
        this.leftPane.setOpaque(true);
        if ((this.viewOptions & 1) > 0) {
            this.leftPane.setPreferredSize(new Dimension(uIManager.getPixelsForDots(100), 120));
        } else {
            this.leftPane.setPreferredSize(new Dimension(uIManager.getPixelsForDots(100), 1));
        }
        this.titleLabel.setFont(uIManager.getFont(UIManager.FontSize.LARGE, 1));
        this.titleLabel.setOpaque(false);
        this.statusLabel.setFont(uIManager.getFont(UIManager.FontSize.MEDIUM));
        this.statusLabel.setHorizontalTextPosition(0);
        this.statusLabel.setVerticalTextPosition(3);
        this.statusLabel.setOpaque(false);
        this.smallStatusTextLabel.setFont(uIManager.getFont(UIManager.FontSize.MEDIUM));
        this.smallStatusTextLabel.setOpaque(false);
        this.informationTextPanel.setOpaque(false);
        this.informationPane.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(4), uIManager.getPixelsForDots(4), uIManager.getPixelsForDots(4), uIManager.getPixelsForDots(4)));
        this.informationPane.setOpaque(true);
        this.informationPane.add((Component)this.titleLabel, "North");
        this.informationPane.add((Component)this.informationTextPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPane, "West");
        this.add((Component)this.informationPane, "Center");
        this.setupImages();
        this.progressIcon.startAnimation();
    }

    private void setupImages() {
        if ((this.viewOptions & 1) > 0) {
            this.progressIcon = new AnimatedImage("/resources/images/progress/ProgressIndicator.1.png", "/resources/images/progress/ProgressIndicator.2.png", "/resources/images/progress/ProgressIndicator.3.png", "/resources/images/progress/ProgressIndicator.4.png", "/resources/images/progress/ProgressIndicator.5.png", "/resources/images/progress/ProgressIndicator.6.png", "/resources/images/progress/ProgressIndicator.7.png", "/resources/images/progress/ProgressIndicator.8.png");
            this.noScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_none.png");
            this.intervalScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval.png");
            this.intervalScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval_disabled.png");
            this.timeScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time.png");
            this.timeScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time_disabled.png");
            this.triggerScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger.png");
            this.triggerScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger_disabled.png");
        } else {
            this.progressIcon = new AnimatedImage("/resources/images/progress/ProgressIndicator_small.1.png", "/resources/images/progress/ProgressIndicator_small.2.png", "/resources/images/progress/ProgressIndicator_small.3.png", "/resources/images/progress/ProgressIndicator_small.4.png", "/resources/images/progress/ProgressIndicator_small.5.png", "/resources/images/progress/ProgressIndicator_small.6.png", "/resources/images/progress/ProgressIndicator_small.7.png", "/resources/images/progress/ProgressIndicator_small.8.png");
            this.noScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_none_small.png");
            this.intervalScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval_small.png");
            this.intervalScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_interval_small_disabled.png");
            this.timeScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time_small.png");
            this.timeScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_time_small_disabled.png");
            this.triggerScheduleIcon = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger_small.png");
            this.triggerScheduleIconDisabled = ImageBuilder.buildFor((String)"/resources/images/scheduleTypes/schedule_type_trigger_small_disabled.png");
        }
    }

    public void dispose() {
        this.progressIcon.setImageObserver(null);
        this.progressIcon.stopAnimation();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends TaskContainer> jList, TaskContainer taskContainer, int n, boolean bl, boolean bl2) {
        if (n > -1) {
            if (this.progressIcon.getImageObserver() == null) {
                this.progressIcon.setImageObserver(jList);
            }
            TaskListModel taskListModel = (TaskListModel)jList.getModel();
            TaskContainer taskContainer2 = taskListModel.getElementAt(n);
            Task task = taskContainer2.getTask();
            TaskMetadata taskMetadata = taskContainer2.getTaskMetadata();
            List<ScheduleMetadata> list = taskContainer2.getScheduleMetadatas();
            this.informationTextPanel.removeAll();
            for (JLabel jLabel : this.labelsList) {
                jLabel.setIcon(null);
                jLabel.setDisabledIcon(null);
                jLabel.setText("");
                jLabel.setFont(new Font(jLabel.getFont().getName(), 0, jLabel.getFont().getSize()));
            }
            Iterator<JLabel> iterator = this.labelsList.iterator();
            this.titleLabel.setText(task.getName());
            if ((this.viewOptions & 2) > 0) {
                this.addDescription(task, iterator);
            }
            this.setScheduleIcon(taskContainer2);
            this.setStatusIcon(taskContainer2, jList);
            boolean bl3 = false;
            if ((this.viewOptions & 4) > 0) {
                bl3 = this.displayExecutionCount(taskMetadata, iterator);
            }
            if (task.getMaximumExecutionCount().compareTo(BigInteger.ZERO) > 0 && (this.viewOptions & 8) > 0) {
                if (!bl3) {
                    this.addEmptyLabel(iterator);
                }
                this.displayMaximumExecutionCount(task, iterator);
                bl3 = true;
            }
            if ((this.viewOptions & 0x10) == 0) {
                if (!bl3) {
                    this.addEmptyLabel(iterator);
                }
                this.displayAggregatedScheduleInformation(taskContainer2, taskMetadata, iterator);
            }
            block1: for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                for (ScheduleMetadata scheduleMetadata : list) {
                    boolean bl4;
                    if (!scheduleMetadata.getScheduleId().equals(abstractSchedule.getId()) || (this.viewOptions & 0x10) == 0 && !(abstractSchedule instanceof Trigger) || (this.viewOptions & 0x20) == 0 && abstractSchedule instanceof Trigger) continue;
                    this.addEmptyLabel(iterator);
                    if (iterator.hasNext()) {
                        String string = abstractSchedule.getClass().getSimpleName();
                        if (abstractSchedule instanceof Trigger) {
                            string = Trigger.class.getSimpleName();
                        }
                        JLabel jLabel = iterator.next();
                        jLabel.setText(this.localizationProvider.getLocalizedString("schedule." + string + ".title") + ":");
                        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
                        this.informationTextPanel.add(jLabel);
                    }
                    if (bl4 = this.displayScheduleValidityPeriod(abstractSchedule, this.informationTextPanel, iterator)) {
                        this.addEmptyLabel(iterator);
                    }
                    this.displayOccurrence(abstractSchedule, this.informationTextPanel, iterator);
                    this.displayTriggers(abstractSchedule, this.informationTextPanel, iterator);
                    this.displayLastSuccessfulStartTime(scheduleMetadata, iterator);
                    this.displayLastExecutionStatus(scheduleMetadata, this.informationTextPanel, taskMetadata.isTaskEnabled(), iterator);
                    this.displayNextFireTime(taskContainer2, abstractSchedule, scheduleMetadata, iterator);
                    continue block1;
                }
            }
            this.setRowColorsAndStyles(jList, n, bl, taskMetadata.isTaskEnabled());
        }
        return this;
    }

    private void displayAggregatedScheduleInformation(TaskContainer taskContainer, TaskMetadata taskMetadata, Iterator<JLabel> iterator) {
        ScheduleMetadata scheduleMetadata = null;
        ScheduleMetadata scheduleMetadata2 = null;
        ScheduleMetadata object = null;
        ScheduleMetadata scheduleMetadata3 = null;
        List<ScheduleMetadata> list = taskContainer.getScheduleMetadatas();
        for (ScheduleMetadata object2 : list) {
            if (scheduleMetadata3 == null) {
                scheduleMetadata3 = object2;
            }
            if (object2.getSuccessfulStart() != null && (scheduleMetadata == null || scheduleMetadata.getSuccessfulStart().before(object2.getSuccessfulStart()))) {
                scheduleMetadata = object2;
            }
            if (object2.getNextFireTime() != null) {
                if (object == null || object.getNextFireTime() != null && object.getNextFireTime().after(object2.getNextFireTime())) {
                    object = object2;
                }
            } else if (taskContainer.getCurrentSchedule() != null && taskContainer.getCurrentSchedule().getId().equals(object2.getScheduleId())) {
                object = object2;
            }
            if (object2.getResultTime() == null || scheduleMetadata2 != null && !object2.getResultTime().after(scheduleMetadata2.getResultTime())) continue;
            scheduleMetadata2 = object2;
        }
        if (scheduleMetadata == null) {
            scheduleMetadata = scheduleMetadata3;
        } else if (scheduleMetadata2 != null && scheduleMetadata2.getResultTime().before(scheduleMetadata.getSuccessfulStart())) {
            scheduleMetadata2 = null;
        }
        if (scheduleMetadata != null) {
            this.displayLastSuccessfulStartTime(scheduleMetadata, iterator);
        }
        if (scheduleMetadata2 != null) {
            this.displayLastExecutionStatus(scheduleMetadata2, this.informationTextPanel, taskMetadata.isTaskEnabled(), iterator);
        }
        if (object != null) {
            for (AbstractSchedule abstractSchedule : taskContainer.getTask().getSchedules()) {
                if (!abstractSchedule.getId().equals(object.getScheduleId())) continue;
                this.displayNextFireTime(taskContainer, abstractSchedule, object, iterator);
                break;
            }
        } else if (iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            if (taskContainer.getRecalculateSchedules() != null && !taskContainer.getRecalculateSchedules().isEmpty()) {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.calculating") + " ...");
            } else if (iterator.hasNext()) {
                jLabel.setText(" ");
            }
            this.informationTextPanel.add(jLabel);
        }
    }

    private void addDescription(Task task, Iterator<JLabel> iterator) {
        String[] stringArray = task.getDescription().split("\\r?\\n");
        int n = 0;
        for (String string : stringArray) {
            JLabel jLabel;
            if (iterator.hasNext()) {
                if (string.equals("") && stringArray.length > 1) {
                    string = " ";
                }
                jLabel = iterator.next();
                jLabel.setText(string);
                this.informationTextPanel.add(jLabel);
                ++n;
            }
            if (n <= 10) continue;
            if (!iterator.hasNext()) break;
            jLabel = iterator.next();
            jLabel.setText("...");
            this.informationTextPanel.add(jLabel);
            break;
        }
    }

    private void setRowColorsAndStyles(JList<? extends TaskContainer> jList, int n, boolean bl, boolean bl2) {
        if (n < jList.getModel().getSize() - 1) {
            this.setBorder(BorderFactory.createMatteBorder(this.uiManager.getPixelsForDots(3), this.uiManager.getPixelsForDots(3), this.uiManager.getPixelsForDots(0), this.uiManager.getPixelsForDots(3), Color.WHITE));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(this.uiManager.getPixelsForDots(3), this.uiManager.getPixelsForDots(3), this.uiManager.getPixelsForDots(3), this.uiManager.getPixelsForDots(3), Color.WHITE));
        }
        if (bl) {
            this.informationPane.setBackground(jList.getSelectionBackground());
            this.iconPane.setBackground(jList.getSelectionBackground());
            this.leftPane.setBackground(jList.getSelectionBackground());
            this.titleLabel.setForeground(jList.getSelectionForeground());
            this.statusLabel.setForeground(jList.getSelectionForeground());
            this.smallStatusTextLabel.setForeground(jList.getSelectionForeground());
        } else {
            if (bl2) {
                this.informationPane.setBackground(TaskTillDawnConstants.BRIGHT_AND_SHINY);
                this.iconPane.setBackground(TaskTillDawnConstants.BRIGHT_AND_SHINY);
                this.leftPane.setBackground(TaskTillDawnConstants.BRIGHT_AND_SHINY);
            } else {
                this.informationPane.setBackground(TaskTillDawnConstants.BRIGHTER_AND_SHINY);
                this.iconPane.setBackground(TaskTillDawnConstants.BRIGHTER_AND_SHINY);
                this.leftPane.setBackground(TaskTillDawnConstants.BRIGHTER_AND_SHINY);
            }
            this.titleLabel.setForeground(jList.getForeground());
            this.statusLabel.setForeground(jList.getForeground());
            this.smallStatusTextLabel.setForeground(jList.getForeground());
        }
        if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
            if (!bl2) {
                this.titleLabel.setForeground(Color.LIGHT_GRAY);
                this.statusLabel.setForeground(Color.LIGHT_GRAY);
                this.smallStatusTextLabel.setForeground(Color.LIGHT_GRAY);
            }
        } else {
            this.titleLabel.setEnabled(bl2);
            this.statusLabel.setEnabled(bl2);
            this.smallStatusTextLabel.setEnabled(bl2);
        }
        for (JLabel jLabel : this.labelsList) {
            if (bl) {
                jLabel.setForeground(jList.getSelectionForeground());
            } else {
                jLabel.setForeground(jList.getForeground());
            }
            if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
                if (bl2) continue;
                jLabel.setForeground(Color.LIGHT_GRAY);
                continue;
            }
            jLabel.setEnabled(bl2);
        }
    }

    private void displayNextFireTime(TaskContainer taskContainer, AbstractSchedule abstractSchedule, ScheduleMetadata scheduleMetadata, Iterator<JLabel> iterator) {
        if (iterator.hasNext()) {
            JLabel jLabel = null;
            if (taskContainer.getCurrentSchedule() != null && taskContainer.getCurrentSchedule().getId().equals(abstractSchedule.getId())) {
                jLabel = iterator.next();
                if (taskContainer.getCurrentAction() == null) {
                    jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.taskIsBeingExecuted") + " ...");
                } else {
                    try {
                        Class<? extends Action<?, ?, ?>> clazz = this.actionPackPluginManager.getActionClassForName(taskContainer.getCurrentAction().getType());
                        jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.currentAction") + ": " + this.actionPackPluginManager.getLocalizedStringForActionClass(clazz, "title", null));
                    }
                    catch (UnknownActionException unknownActionException) {
                        jLabel.setText("");
                    }
                }
                this.informationTextPanel.add(jLabel);
            } else if (taskContainer.getTaskMetadata().isTaskEnabled()) {
                if (scheduleMetadata.getNextFireTime() != null) {
                    jLabel = iterator.next();
                    jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.nextPlannedExecution", new Object[]{DateFormat.getDateInstance(3).format(scheduleMetadata.getNextFireTime()), DateFormat.getTimeInstance(2).format(scheduleMetadata.getNextFireTime())}));
                    this.informationTextPanel.add(jLabel);
                } else if (abstractSchedule instanceof AbstractPredictableSchedule) {
                    if (taskContainer.getRecalculateSchedules() != null && !taskContainer.getRecalculateSchedules().isEmpty()) {
                        for (AbstractSchedule abstractSchedule2 : taskContainer.getRecalculateSchedules()) {
                            if (!abstractSchedule2.getId().equals(abstractSchedule.getId())) continue;
                            jLabel = iterator.next();
                            jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.calculating") + " ...");
                            this.informationTextPanel.add(jLabel);
                            break;
                        }
                    } else {
                        jLabel = iterator.next();
                        jLabel.setText(" ");
                        this.informationTextPanel.add(jLabel);
                    }
                }
            }
        }
    }

    private void setStatusIcon(TaskContainer taskContainer, JList<? extends TaskContainer> jList) {
        if (taskContainer.getCurrentSchedule() != null) {
            this.statusLabel.setText("");
            this.statusLabel.setIcon(this.progressIcon);
            this.statusLabel.setDisabledIcon(this.progressIcon);
            this.smallStatusTextLabel.setText("");
            this.progressIcon.startAnimation();
            if (taskContainer.getCurrentStatusText() != null) {
                if ((this.viewOptions & 1) > 0) {
                    this.statusLabel.setText(taskContainer.getCurrentStatusText());
                } else {
                    this.smallStatusTextLabel.setText(taskContainer.getCurrentStatusText());
                }
            }
        } else {
            this.statusLabel.setText("");
            this.statusLabel.setIcon(this.noScheduleIcon);
            this.statusLabel.setDisabledIcon(this.noScheduleIcon);
            this.smallStatusTextLabel.setText("");
            ListModel<? extends TaskContainer> listModel = jList.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                if (listModel.getElementAt(i).getCurrentSchedule() == null) continue;
                return;
            }
            this.progressIcon.stopAnimation();
        }
    }

    private void displayLastExecutionStatus(ScheduleMetadata scheduleMetadata, JPanel jPanel, boolean bl, Iterator<JLabel> iterator) {
        Date date;
        if ((ScheduleMetadata.ResultType.ERROR.equals((Object)scheduleMetadata.getResultType()) || ScheduleMetadata.ResultType.WARNING.equals((Object)scheduleMetadata.getResultType())) && (date = scheduleMetadata.getResultTime()) != null) {
            JLabel jLabel;
            if (iterator.hasNext()) {
                jLabel = iterator.next();
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.lastExecutionFailure", new Object[]{DateFormat.getDateInstance(3).format(date), DateFormat.getTimeInstance(2).format(date)}));
                jPanel.add(jLabel);
            }
            if (iterator.hasNext()) {
                jLabel = iterator.next();
                if (bl) {
                    jLabel.setIcon(this.errorIcon);
                    jLabel.setDisabledIcon(this.errorIconDisabled);
                } else {
                    jLabel.setIcon(this.errorIconDisabled);
                    jLabel.setDisabledIcon(this.errorIconDisabled);
                }
                jLabel.setText(TaskResultUtil.getLocalizedTextForResult(this.localizationProvider, scheduleMetadata.getResultReason(), scheduleMetadata.getResultDescription()));
                jPanel.add(jLabel);
            }
        }
    }

    private void setScheduleIcon(TaskContainer taskContainer) {
        this.taskIconLabel1.setEnabled(true);
        this.taskIconLabel2.setEnabled(true);
        this.taskIconLabel3.setEnabled(true);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ImmutableArrayList<AbstractSchedule> immutableArrayList = taskContainer.getTask().getSchedules();
        for (AbstractSchedule abstractSchedule : immutableArrayList) {
            if (abstractSchedule instanceof IntervalSchedule) {
                bl2 = true;
                continue;
            }
            if (abstractSchedule instanceof TimeSchedule) {
                bl = true;
                continue;
            }
            if (!(abstractSchedule instanceof Trigger)) continue;
            bl3 = true;
        }
        this.taskIconLabel1.setIcon(null);
        this.taskIconLabel1.setDisabledIcon(null);
        this.taskIconLabel1.setVisible(false);
        this.taskIconLabel2.setIcon(null);
        this.taskIconLabel2.setDisabledIcon(null);
        this.taskIconLabel2.setVisible(false);
        this.taskIconLabel3.setIcon(null);
        this.taskIconLabel3.setDisabledIcon(null);
        this.taskIconLabel3.setVisible(false);
        if (bl2) {
            this.taskIconLabel1.setIcon(this.intervalScheduleIcon);
            this.taskIconLabel1.setDisabledIcon(this.intervalScheduleIconDisabled);
            this.taskIconLabel1.setVisible(true);
        }
        if (bl) {
            this.taskIconLabel2.setIcon(this.timeScheduleIcon);
            this.taskIconLabel2.setDisabledIcon(this.timeScheduleIconDisabled);
            this.taskIconLabel2.setVisible(true);
        }
        if (bl3) {
            this.taskIconLabel3.setIcon(this.triggerScheduleIcon);
            this.taskIconLabel3.setDisabledIcon(this.triggerScheduleIconDisabled);
            this.taskIconLabel3.setVisible(true);
        }
        if (!taskContainer.getTaskMetadata().isTaskEnabled()) {
            this.taskIconLabel1.setEnabled(false);
            this.taskIconLabel2.setEnabled(false);
            this.taskIconLabel3.setEnabled(false);
        }
    }

    private boolean displayExecutionCount(TaskMetadata taskMetadata, Iterator<JLabel> iterator) {
        this.addEmptyLabel(iterator);
        if (iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            String string = "renderer.TaskListCellRenderer.label.successfulExecutions";
            String string2 = "renderer.TaskListCellRenderer.label.totalTries";
            if (taskMetadata.getSuccessfulExecutionCount().compareTo(BigInteger.ONE) == 0) {
                string = "renderer.TaskListCellRenderer.label.successfulExecution";
            }
            if (taskMetadata.getTotalExecutionCount().compareTo(BigInteger.ONE) == 0) {
                string2 = "renderer.TaskListCellRenderer.label.totalTry";
            }
            jLabel.setText(this.localizationProvider.getLocalizedString(string, new Object[]{String.valueOf(taskMetadata.getSuccessfulExecutionCount())}) + ", " + this.localizationProvider.getLocalizedString(string2, new Object[]{String.valueOf(taskMetadata.getTotalExecutionCount())}));
            this.informationTextPanel.add(jLabel);
        }
        return true;
    }

    private void addEmptyLabel(Iterator<JLabel> iterator) {
        if (iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            jLabel.setText(" ");
            this.informationTextPanel.add(jLabel);
        }
    }

    private void displayMaximumExecutionCount(Task task, Iterator<JLabel> iterator) {
        if (task.getMaximumExecutionCount().compareTo(BigInteger.ZERO) > 0 && iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            if (task.isDeleteAfterMaximumExecutionsReached()) {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.deleteAfterMaximumExecutionsReached", new Object[]{String.valueOf(task.getMaximumExecutionCount())}));
            } else {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.disableAfterMaximumExecutionsReached", new Object[]{String.valueOf(task.getMaximumExecutionCount())}));
            }
            this.informationTextPanel.add(jLabel);
        }
    }

    private boolean displayScheduleValidityPeriod(AbstractSchedule abstractSchedule, JPanel jPanel, Iterator<JLabel> iterator) {
        if ((abstractSchedule.getValidFrom() != null || abstractSchedule.getValidUntil() != null) && iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            if (abstractSchedule.getValidFrom() != null && abstractSchedule.getValidUntil() != null) {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.scheduleValidFromUntil", new Object[]{abstractSchedule.getValidFrom(), abstractSchedule.getValidUntil()}));
            } else if (abstractSchedule.getValidFrom() != null) {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.scheduleValidFrom", new Object[]{abstractSchedule.getValidFrom()}));
            } else if (abstractSchedule.getValidUntil() != null) {
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.scheduleValidUntil", new Object[]{abstractSchedule.getValidUntil()}));
            }
            jPanel.add(jLabel);
            return true;
        }
        return false;
    }

    private void displayOccurrence(AbstractSchedule abstractSchedule, JPanel jPanel, Iterator<JLabel> iterator) {
        if (iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            if (abstractSchedule instanceof AbstractRestrictedTimeSchedule) {
                int n;
                StringBuilder stringBuilder = new StringBuilder(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.onEveryDay"));
                AbstractRestrictedTimeSchedule abstractRestrictedTimeSchedule = (AbstractRestrictedTimeSchedule)abstractSchedule;
                if (abstractRestrictedTimeSchedule.getWeekdays() < 127) {
                    stringBuilder = new StringBuilder(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.onTheFollowingDays")).append(":");
                    n = 1;
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 1) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.monday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 2) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.tuesday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 4) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.wednesday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 8) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.thursday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 0x10) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.friday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 0x20) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.saturday"));
                        n = 0;
                    }
                    if ((abstractRestrictedTimeSchedule.getWeekdays() & 0x40) != 0) {
                        stringBuilder.append(n != 0 ? " " : ", ").append(this.localizationProvider.getLocalizedString("common.day.sunday"));
                    }
                }
                if (abstractRestrictedTimeSchedule.getDayOfMonth() > 0) {
                    stringBuilder = new StringBuilder(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.every")).append(" ");
                    n = abstractRestrictedTimeSchedule.getDayOfMonth();
                    if (n < 32) {
                        stringBuilder.append(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.dayOfMonth." + n + (n % 10 == 1 && n != 11 ? "st" : (n % 10 == 2 && n != 12 ? "nd" : (n % 10 == 3 && n != 13 ? "rd" : "th")))));
                    } else {
                        stringBuilder.append(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.dayOfMonth.last"));
                    }
                    stringBuilder.append(" ").append(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.XthDayOfTheMonth"));
                }
                if (abstractRestrictedTimeSchedule instanceof IntervalSchedule) {
                    IntervalSchedule intervalSchedule = (IntervalSchedule)abstractRestrictedTimeSchedule;
                    String string = this.localizationProvider.getLocalizedString("common.timeunit.seconds");
                    int n2 = intervalSchedule.getIntervalInSeconds();
                    if (n2 % 86400 == 0) {
                        n2 /= 86400;
                        string = this.localizationProvider.getLocalizedString("common.timeunit.days");
                    } else if (n2 % 3600 == 0) {
                        n2 /= 3600;
                        string = this.localizationProvider.getLocalizedString("common.timeunit.hours");
                    } else if (n2 % 60 == 0) {
                        n2 /= 60;
                        string = this.localizationProvider.getLocalizedString("common.timeunit.minutes");
                    }
                    StringBuilder stringBuilder2 = new StringBuilder(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.intervalScheduleOccurrence", new Object[]{n2, string, stringBuilder}));
                    if (intervalSchedule.getIntervalStart() != null && intervalSchedule.getIntervalEnd() != null) {
                        stringBuilder2.append(" ").append(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.intervalBetween", new Object[]{DateFormat.getTimeInstance(3).format(intervalSchedule.getIntervalStart()), DateFormat.getTimeInstance(3).format(intervalSchedule.getIntervalEnd())}));
                    }
                    jLabel.setText(stringBuilder2.toString());
                    jPanel.add(jLabel);
                } else if (abstractRestrictedTimeSchedule instanceof TimeSchedule) {
                    TimeSchedule timeSchedule = (TimeSchedule)abstractRestrictedTimeSchedule;
                    StringBuilder stringBuilder3 = new StringBuilder(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.timeScheduleOccurrence", new Object[]{DateFormat.getTimeInstance(2).format(timeSchedule.getSpecifiedTime()), stringBuilder}));
                    jLabel.setText(stringBuilder3.toString());
                    jPanel.add(jLabel);
                }
            }
        }
    }

    private void displayTriggers(AbstractSchedule abstractSchedule, JPanel jPanel, Iterator<JLabel> iterator) {
        if (abstractSchedule instanceof Trigger && iterator.hasNext()) {
            JLabel jLabel = iterator.next();
            jLabel.setText(this.localizationProvider.getLocalizedString("trigger." + abstractSchedule.getClass().getSimpleName() + ".title"));
            jPanel.add(jLabel);
        }
    }

    private void displayLastSuccessfulStartTime(ScheduleMetadata scheduleMetadata, Iterator<JLabel> iterator) {
        if (iterator.hasNext()) {
            if (scheduleMetadata.getSuccessfulStart() != null) {
                JLabel jLabel = iterator.next();
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.lastSuccessfulExecution", new Object[]{DateFormat.getDateInstance(3).format(scheduleMetadata.getSuccessfulStart()), DateFormat.getTimeInstance(2).format(scheduleMetadata.getSuccessfulStart())}));
                this.informationTextPanel.add(jLabel);
            } else if (scheduleMetadata.getStart() == null) {
                JLabel jLabel = iterator.next();
                jLabel.setText(this.localizationProvider.getLocalizedString("renderer.TaskListCellRenderer.label.neverExecuted"));
                this.informationTextPanel.add(jLabel);
            }
        }
    }

    public static class ViewOption {
        public static final int LARGE_ICONS = 1;
        public static final int DESCRIPTION = 2;
        public static final int EXECUTION_COUNT = 4;
        public static final int MAXIMUM_EXECUTION_COUNT = 8;
        public static final int SCHEDULES = 16;
        public static final int TRIGGERS = 32;
    }
}

