/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.renderer;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class GroupListCellRenderer
extends JPanel
implements ListCellRenderer<String> {
    private final JLabel groupLabel = new JLabel();
    private final ImageIcon allTasksImage = ImageBuilder.buildFor((String)"/resources/group_icon_alltasks.png");
    private ApplicationContext<?> applicationContext;

    public GroupListCellRenderer(ApplicationContext<?> applicationContext) {
        this.applicationContext = applicationContext;
        this.setLayout(new BorderLayout());
        this.groupLabel.setOpaque(false);
        this.groupLabel.setBorder(BorderFactory.createEmptyBorder(applicationContext.getUIManager().getPixelsForDots(3), applicationContext.getUIManager().getPixelsForDots(10), applicationContext.getUIManager().getPixelsForDots(3), applicationContext.getUIManager().getPixelsForDots(10)));
        this.add((Component)this.groupLabel, "West");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
        this.groupLabel.setText(string);
        this.groupLabel.setIcon(null);
        if (string.equals("All tasks")) {
            this.groupLabel.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("application.defaultTaskGroup"));
            this.groupLabel.setIcon(this.allTasksImage);
        } else if (string.equals("Last import")) {
            this.groupLabel.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("application.importTaskGroup"));
        }
        this.setRowColorsAndStyles(jList, n, bl);
        return this;
    }

    private void setRowColorsAndStyles(JList<? extends String> jList, int n, boolean bl) {
        this.setBackground(jList.getBackground());
        this.groupLabel.setForeground(jList.getForeground());
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.groupLabel.setForeground(jList.getSelectionForeground());
        }
    }
}

