/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.renderer;

import de.oliver_matuschin.base.ui.UIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public abstract class AbstractListCellRenderer<T>
extends JPanel
implements ListCellRenderer<T> {
    private final JLabel label = new JLabel();

    public AbstractListCellRenderer(UIManager uIManager, UIManager.FontSize fontSize) {
        this.setLayout(new BorderLayout());
        this.label.setOpaque(false);
        this.label.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(3), uIManager.getPixelsForDots(3), uIManager.getPixelsForDots(3), uIManager.getPixelsForDots(3)));
        this.label.setFont(uIManager.getFont(fontSize));
        this.add((Component)this.label, "West");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> jList, T t, int n, boolean bl, boolean bl2) {
        this.label.setText(this.getDisplayableString(t, n));
        this.label.setIcon(this.getIconForValue(t, n, bl));
        this.setRowColorsAndStyles(jList, n, bl);
        return this;
    }

    protected abstract String getDisplayableString(T var1, int var2);

    protected abstract ImageIcon getIconForValue(T var1, int var2, boolean var3);

    private void setRowColorsAndStyles(JList<? extends T> jList, int n, boolean bl) {
        this.setBackground(jList.getBackground());
        this.label.setForeground(jList.getForeground());
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.label.setForeground(jList.getSelectionForeground());
        }
    }
}

