/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.popupMenu;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.plugin.converter.TypeConverter;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.ui.type.TypeInformationProvider;
import de.oliver_matuschin.util.TypeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class VariablePopupMenu
extends JPopupMenu {
    private EventListenerList variableSelectionListeners = new EventListenerList();
    private List<Component> components = new ArrayList<Component>();

    public VariablePopupMenu(final LocalizationProvider localizationProvider, final ActionPackPluginManager actionPackPluginManager, final TypeInformationProvider typeInformationProvider, final List<Action.ActionVariable> list, final Type type, final boolean bl) {
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                VariablePopupMenu.this.populatePopupMenu(localizationProvider, actionPackPluginManager, typeInformationProvider, list, type, bl);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void addInternal(Component component) {
        this.add(component);
        this.components.add(component);
    }

    private void populatePopupMenu(LocalizationProvider localizationProvider, ActionPackPluginManager actionPackPluginManager, TypeInformationProvider typeInformationProvider, List<Action.ActionVariable> list, Type type, boolean bl) {
        for (Component object : this.components) {
            this.remove(object);
        }
        this.components.clear();
        if (this.getComponentCount() > 0) {
            this.addInternal(new JSeparator(0));
        }
        JMenuItem jMenuItem = new JMenuItem(typeInformationProvider.getLocalizedTypeName(type) + ":");
        jMenuItem.setEnabled(false);
        this.addInternal(jMenuItem);
        Collections.sort(list, new Comparator<Action.ActionVariable>(){

            @Override
            public int compare(Action.ActionVariable actionVariable, Action.ActionVariable actionVariable2) {
                return actionVariable.getName().compareTo(actionVariable2.getName());
            }
        });
        int n = 0;
        for (Action.ActionVariable actionVariable : list) {
            if (type.getTypeName().equals(actionVariable.getType())) {
                ++n;
                this.addVariableMenuItem(this, localizationProvider, typeInformationProvider, actionVariable.getName(), null, true, new Action.ConvertibleVariable(actionVariable.getName(), actionVariable.getType()));
                continue;
            }
            JMenu jMenu = new JMenu(actionVariable.getName());
            jMenu.setIcon(typeInformationProvider.getIconForType(TypeUtil.getTypeFromString((String)actionVariable.getType())));
            int n2 = 0;
            boolean bl2 = true;
            Object object = null;
            List<TypeConverter> list2 = actionPackPluginManager.listTypeConverters();
            for (TypeConverter typeConverter : list2) {
                if (bl && !typeConverter.getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.converter.GenericListToObjectListConverter") || !typeConverter.supports(TypeUtil.getTypeFromString((String)actionVariable.getType()), type)) continue;
                List<TypeConverter.Option> list3 = typeConverter.getOptions(TypeUtil.getTypeFromString((String)actionVariable.getType()), type);
                if (list3 != null && list3.size() > 0) {
                    for (TypeConverter.Option option : list3) {
                        bl2 = false;
                        if (option != null) {
                            this.addVariableMenuItem(jMenu, localizationProvider, typeInformationProvider, option.getLocalizedDescription(), option.getLocalizedExample(), false, new Action.ConvertibleVariable(actionVariable.getName(), actionVariable.getType(), typeConverter.getClass().getCanonicalName(), option.getConfiguration()));
                            continue;
                        }
                        jMenu.addSeparator();
                    }
                } else {
                    object = typeConverter;
                    this.addVariableMenuItem(jMenu, localizationProvider, typeInformationProvider, localizationProvider.getLocalizedString("popupMenu.VariablePopupMenu.directAssignment"), null, false, new Action.ConvertibleVariable(actionVariable.getName(), actionVariable.getType(), typeConverter.getClass().getCanonicalName(), null));
                }
                ++n2;
            }
            if (n2 <= 0) continue;
            if (bl2) {
                ++n;
                this.addVariableMenuItem(this, localizationProvider, typeInformationProvider, actionVariable.getName(), null, true, new Action.ConvertibleVariable(actionVariable.getName(), actionVariable.getType(), object.getClass().getCanonicalName(), null));
                continue;
            }
            ++n;
            this.addInternal(jMenu);
        }
        if (n == 0) {
            JMenuItem jMenuItem2 = new JMenuItem(localizationProvider.getLocalizedString("popupMenu.VariablePopupMenu.noVariablesAvailable"));
            jMenuItem2.setEnabled(false);
            this.addInternal(jMenuItem2);
        }
    }

    private void addVariableMenuItem(JComponent jComponent, LocalizationProvider localizationProvider, TypeInformationProvider typeInformationProvider, String string, String string2, boolean bl, final Action.ConvertibleVariable convertibleVariable) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append(" (").append(localizationProvider.getLocalizedString("popupMenu.VariablePopupMenu.example", new Object[]{string2})).append(")");
        }
        JMenuItem jMenuItem = new JMenuItem(stringBuilder.toString());
        if (bl) {
            jMenuItem.setIcon(typeInformationProvider.getIconForType(TypeUtil.getTypeFromString((String)convertibleVariable.getType())));
        }
        jComponent.add(jMenuItem);
        if (jComponent == this) {
            this.components.add(jMenuItem);
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableSelectionListener[] variableSelectionListenerArray;
                for (VariableSelectionListener variableSelectionListener : variableSelectionListenerArray = (VariableSelectionListener[])VariablePopupMenu.this.variableSelectionListeners.getListeners(VariableSelectionListener.class)) {
                    variableSelectionListener.variableSelected(convertibleVariable);
                }
            }
        });
    }

    public void addVariableSelectionListener(VariableSelectionListener variableSelectionListener) {
        this.variableSelectionListeners.add(VariableSelectionListener.class, variableSelectionListener);
    }

    public void removeVariableSelectionListener(VariableSelectionListener variableSelectionListener) {
        this.variableSelectionListeners.remove(VariableSelectionListener.class, variableSelectionListener);
    }

    public static abstract class VariableSelectionListener
    implements EventListener {
        public abstract void variableSelected(Action.ConvertibleVariable var1);
    }
}

