/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.popupMenu;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.ui.popupMenu.listener.TaskPopupMenuEventListener;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class TaskPopupMenu
extends PopupMenu {
    private transient TaskRepository taskRepository;
    private transient TaskGroupManager taskGroupManager;
    private transient LocalizationProvider localizationProvider;
    private transient EventListenerList listeners;
    private boolean showTasks;
    private boolean showGroups;
    private boolean showDisabledTasks;
    private int dynamicSectionIndex;
    private transient TaskRepositoryEventListener repositoryEventListener = new TaskRepositoryEventListener(){

        private void updateTaskMenuItems(final Task task) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        TaskMetadata taskMetadata = TaskPopupMenu.this.taskRepository.getTaskMetadata(task.getId());
                        if (taskMetadata != null) {
                            if (!taskMetadata.isTaskEnabled() && !TaskPopupMenu.this.showDisabledTasks) {
                                List<String> list = TaskPopupMenu.this.taskGroupManager.listGroups();
                                for (String string : list) {
                                    TaskPopupMenu.this.removeTask(string, task.getId());
                                }
                            } else {
                                List<String> list = TaskPopupMenu.this.taskGroupManager.listGroups();
                                for (String string : list) {
                                    List<String> list2 = TaskPopupMenu.this.taskGroupManager.listTasksOfGroup(string);
                                    if (list2 == null || !list2.contains(task.getId())) continue;
                                    TaskPopupMenu.this.updateTasksInGroupMenuItems(string);
                                }
                            }
                        }
                    } else {
                        TaskPopupMenu.this.updateTasksMenuItems();
                    }
                }
            });
        }

        @Override
        public void taskUpdated(Task task) {
            this.updateTaskMenuItems(task);
        }

        @Override
        public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
            this.updateTaskMenuItems(task);
        }

        @Override
        public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
        }

        @Override
        public void taskAdded(Task task) {
        }

        @Override
        public void taskRemoved(Task task) {
        }
    };
    private transient TaskGroupEventListener taskGroupEventListener = new TaskGroupEventListener(){

        private void addGroup(String string, int n) {
            int n2;
            String string2 = string;
            if (string.equals("All tasks")) {
                string2 = TaskPopupMenu.this.localizationProvider.getLocalizedString("application.defaultTaskGroup");
            } else if (string.equals("Last import")) {
                string2 = TaskPopupMenu.this.localizationProvider.getLocalizedString("application.importTaskGroup");
            }
            GroupMenu groupMenu = new GroupMenu(TaskPopupMenu.this.getAdjustedName(string2));
            groupMenu.setGroupName(string);
            groupMenu.addActionListener(TaskPopupMenu.this.groupSelectionActionListener);
            List list = TaskPopupMenu.this.findGroupMenus();
            if (n <= list.size() && (n2 = n < list.size() ? TaskPopupMenu.this.indexOfGroupMenu(((GroupMenu)list.get(n)).getGroupName()) : TaskPopupMenu.this.indexOfGroupMenu(((GroupMenu)list.get(list.size() - 1)).getGroupName()) + 1) != -1) {
                TaskPopupMenu.this.insert(groupMenu, n2);
                groupMenu.add(TaskPopupMenu.this.createEmptyMenuItem());
            }
        }

        private void removeGroup(String string) {
            GroupMenu groupMenu = TaskPopupMenu.this.findGroupMenuForGroup(string);
            if (groupMenu != null) {
                TaskPopupMenu.this.remove(groupMenu);
            }
        }

        @Override
        public void taskAdded(final String string, String string2, int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        TaskPopupMenu.this.updateTasksInGroupMenuItems(string);
                    } else {
                        TaskPopupMenu.this.updateTasksMenuItems();
                    }
                }
            });
        }

        @Override
        public void taskMoved(final String string, String string2, int n, int n2) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        TaskPopupMenu.this.updateTasksInGroupMenuItems(string);
                    } else {
                        TaskPopupMenu.this.updateTasksMenuItems();
                    }
                }
            });
        }

        @Override
        public void taskRemoved(final String string, final String string2, int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        TaskPopupMenu.this.removeTask(string, string2);
                    } else {
                        TaskPopupMenu.this.updateTasksMenuItems();
                    }
                }
            });
        }

        @Override
        public void groupAdded(final String string, final int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        this.addGroup(string, n);
                    }
                }
            });
        }

        @Override
        public void groupMoved(final String string, final int n, final int n2) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups && TaskPopupMenu.this.taskGroupManager.listGroups().size() > 1) {
                        int n3 = n2;
                        if (n3 > n) {
                            --n3;
                        }
                        this.removeGroup(string);
                        this.addGroup(string, n3);
                        TaskPopupMenu.this.removeEmptyMenuItem(TaskPopupMenu.this.findGroupMenuForGroup(string));
                        TaskPopupMenu.this.updateTasksInGroupMenuItems(string);
                    }
                }
            });
        }

        @Override
        public void groupRemoved(final String string, int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TaskPopupMenu.this.showGroups) {
                        this.removeGroup(string);
                    }
                }
            });
        }
    };
    private transient ActionListener taskSelectionActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof TaskMenuItem) {
                TaskMenuItem taskMenuItem = (TaskMenuItem)object;
                TaskPopupMenu.this.fireTaskSelected(taskMenuItem.getTaskId());
            }
        }
    };
    private transient ActionListener groupSelectionActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof GroupMenu) {
                GroupMenu groupMenu = (GroupMenu)object;
                TaskPopupMenu.this.fireGroupSelected(groupMenu.getGroupName());
            }
        }
    };

    public TaskPopupMenu(TaskRepository taskRepository, TaskGroupManager taskGroupManager, LocalizationProvider localizationProvider, int n, boolean bl, boolean bl2, boolean bl3) {
        this.taskRepository = taskRepository;
        this.taskGroupManager = taskGroupManager;
        this.localizationProvider = localizationProvider;
        this.listeners = new EventListenerList();
        this.dynamicSectionIndex = n;
        this.showTasks = bl;
        this.showGroups = bl2;
        this.showDisabledTasks = bl3;
        if (bl) {
            if (bl2) {
                this.populateGroupMenus();
            } else {
                this.populateTasksMenu();
            }
        }
    }

    public void setShowGroups(boolean bl) {
        if (this.showGroups != bl) {
            this.showGroups = bl;
            if (this.showTasks) {
                if (bl) {
                    this.clearTasksMenu();
                    this.populateGroupMenus();
                } else {
                    this.clearGroupMenus();
                    this.populateTasksMenu();
                }
            }
        }
    }

    public void setShowTasks(boolean bl) {
        if (this.showTasks != bl) {
            this.showTasks = bl;
            if (!this.showTasks) {
                if (this.showGroups) {
                    this.clearGroupMenus();
                } else {
                    this.clearTasksMenu();
                }
            } else if (this.showGroups) {
                this.populateGroupMenus();
            } else {
                this.populateTasksMenu();
            }
        }
    }

    public void setShowDisabledTasks(boolean bl) {
        if (this.showDisabledTasks != bl) {
            this.showDisabledTasks = bl;
            if (this.showTasks) {
                if (this.showGroups) {
                    List<String> list = this.taskGroupManager.listGroups();
                    for (String string : list) {
                        this.updateTasksInGroupMenuItems(string);
                    }
                } else {
                    this.updateTasksMenuItems();
                }
            }
        }
    }

    public void dispose() {
        this.taskGroupManager.removeTaskGroupEventListener(this.taskGroupEventListener);
        this.taskRepository.removeTaskRepositoryEventListener(this.repositoryEventListener);
    }

    public void addTaskPopupMenuActionListener(TaskPopupMenuEventListener taskPopupMenuEventListener) {
        this.listeners.add(TaskPopupMenuEventListener.class, taskPopupMenuEventListener);
    }

    public void removeTaskPopupMenuActionListener(TaskPopupMenuEventListener taskPopupMenuEventListener) {
        this.listeners.remove(TaskPopupMenuEventListener.class, taskPopupMenuEventListener);
    }

    private void fireGroupSelected(String string) {
        TaskPopupMenuEventListener[] taskPopupMenuEventListenerArray;
        for (TaskPopupMenuEventListener taskPopupMenuEventListener : taskPopupMenuEventListenerArray = (TaskPopupMenuEventListener[])this.listeners.getListeners(TaskPopupMenuEventListener.class)) {
            taskPopupMenuEventListener.groupSelected(string);
        }
    }

    private void fireTaskSelected(String string) {
        TaskPopupMenuEventListener[] taskPopupMenuEventListenerArray;
        for (TaskPopupMenuEventListener taskPopupMenuEventListener : taskPopupMenuEventListenerArray = (TaskPopupMenuEventListener[])this.listeners.getListeners(TaskPopupMenuEventListener.class)) {
            taskPopupMenuEventListener.taskSelected(string);
        }
    }

    private void clearGroupMenus() {
        this.taskRepository.removeTaskRepositoryEventListener(this.repositoryEventListener);
        this.taskGroupManager.removeTaskGroupEventListener(this.taskGroupEventListener);
        List<String> list = this.taskGroupManager.listGroups();
        for (String string : list) {
            GroupMenu groupMenu = this.findGroupMenuForGroup(string);
            if (groupMenu == null) continue;
            this.remove(groupMenu);
        }
        this.removeMenuSeparator();
    }

    private void clearTasksMenu() {
        this.taskRepository.removeTaskRepositoryEventListener(this.repositoryEventListener);
        this.taskGroupManager.removeTaskGroupEventListener(this.taskGroupEventListener);
        int n = this.getItemCount();
        for (int i = n - 1; i >= this.dynamicSectionIndex; --i) {
            MenuItem menuItem = this.getItem(i);
            if (!(menuItem instanceof TaskMenuItem)) continue;
            this.remove(menuItem);
        }
        this.removeEmptyMenuItem(this);
        this.removeMenuSeparator();
    }

    private void removeMenuSeparator() {
        int n = this.getItemCount();
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.getItem(i) instanceof MenuSeparator)) continue;
            this.remove(i);
        }
    }

    private void populateTasksMenu() {
        this.updateTasksMenuItems();
        this.taskRepository.addTaskRepositoryEventListener(this.repositoryEventListener);
        this.taskGroupManager.addTaskGroupEventListener(this.taskGroupEventListener);
    }

    private void updateTasksMenuItems() {
        List<String> list = this.taskGroupManager.listTasksOfGroup("All tasks");
        if (!this.showDisabledTasks && list != null) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                TaskMetadata taskMetadata = this.taskRepository.getTaskMetadata(iterator.next());
                if (taskMetadata == null || taskMetadata.isTaskEnabled()) continue;
                iterator.remove();
            }
        }
        if (list != null && list.size() > 0) {
            MenuItem menuItem;
            int n;
            this.removeEmptyMenuItem(this);
            int n2 = this.getItemCount();
            for (n = 0; n < list.size(); ++n) {
                Task task = this.taskRepository.getTask(list.get(n));
                if (task == null) continue;
                if (this.dynamicSectionIndex + n < n2) {
                    TaskMenuItem taskMenuItem;
                    menuItem = this.getItem(this.dynamicSectionIndex + n);
                    if (menuItem instanceof TaskMenuItem) {
                        if (task.getId().equals(((TaskMenuItem)menuItem).getTaskId()) && this.getAdjustedName(task.getName()).equals(menuItem.getLabel())) continue;
                        taskMenuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                        taskMenuItem.setTaskId(task.getId());
                        this.insert(taskMenuItem, this.dynamicSectionIndex + n);
                        taskMenuItem.addActionListener(this.taskSelectionActionListener);
                        if (!(this.getItem(this.dynamicSectionIndex + n + 1) instanceof TaskMenuItem)) continue;
                        this.remove(this.dynamicSectionIndex + n + 1);
                        continue;
                    }
                    taskMenuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                    taskMenuItem.setTaskId(task.getId());
                    this.insert(taskMenuItem, this.dynamicSectionIndex + n);
                    taskMenuItem.addActionListener(this.taskSelectionActionListener);
                    continue;
                }
                menuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                ((TaskMenuItem)menuItem).setTaskId(task.getId());
                this.insert(menuItem, this.dynamicSectionIndex + n);
                menuItem.addActionListener(this.taskSelectionActionListener);
            }
            this.addSeparator(this.dynamicSectionIndex + n);
            n2 = this.getItemCount();
            for (int i = n2 - 1; i >= this.dynamicSectionIndex + n; --i) {
                menuItem = this.getItem(i);
                if (!(menuItem instanceof TaskMenuItem)) continue;
                this.remove(menuItem);
            }
        } else if (!this.hasEmptyMenuItem(this)) {
            int n = this.getItemCount();
            for (int i = n - 1; i >= this.dynamicSectionIndex; --i) {
                MenuItem menuItem = this.getItem(i);
                if (!(menuItem instanceof TaskMenuItem)) continue;
                this.remove(menuItem);
            }
            this.insert(this.createEmptyMenuItem(), this.dynamicSectionIndex);
            this.addSeparator(this.dynamicSectionIndex + 1);
        }
    }

    private void addSeparator(int n) {
        int n2 = this.getItemCount();
        for (int i = 0; i < n2; ++i) {
            if (!(this.getItem(i) instanceof MenuSeparator)) continue;
            return;
        }
        if (n < n2) {
            this.insert(new MenuSeparator(), n);
        } else if (n >= n2) {
            this.insert(new MenuSeparator(), n2);
        }
    }

    private void populateGroupMenus() {
        int n;
        List<String> list = this.taskGroupManager.listGroups();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            String string;
            String string2 = string = list.get(n);
            if (string.equals("All tasks")) {
                string2 = this.localizationProvider.getLocalizedString("application.defaultTaskGroup");
            } else if (string.equals("Last import")) {
                string2 = this.localizationProvider.getLocalizedString("application.importTaskGroup");
            }
            GroupMenu groupMenu = new GroupMenu(this.getAdjustedName(string2));
            groupMenu.setGroupName(string);
            if (this.dynamicSectionIndex + n > this.getItemCount()) {
                this.add(groupMenu);
            } else {
                this.insert(groupMenu, this.dynamicSectionIndex + n);
            }
            groupMenu.addActionListener(this.groupSelectionActionListener);
            this.updateTasksInGroupMenuItems(string);
        }
        this.addSeparator(this.dynamicSectionIndex + n);
        this.taskRepository.addTaskRepositoryEventListener(this.repositoryEventListener);
        this.taskGroupManager.addTaskGroupEventListener(this.taskGroupEventListener);
    }

    private void updateTasksInGroupMenuItems(String string) {
        GroupMenu groupMenu = this.findGroupMenuForGroup(string);
        if (groupMenu != null) {
            int n;
            List<String> list = this.taskGroupManager.listTasksOfGroup(string);
            int n2 = n = list != null ? list.size() : 0;
            if (!this.showDisabledTasks && list != null) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TaskMetadata taskMetadata = this.taskRepository.getTaskMetadata(iterator.next());
                    if (taskMetadata == null || taskMetadata.isTaskEnabled()) continue;
                    iterator.remove();
                }
            }
            if (list != null && n > 0) {
                this.removeEmptyMenuItem(groupMenu);
                int n3 = groupMenu.getItemCount();
                for (int i = 0; i < list.size(); ++i) {
                    MenuItem menuItem;
                    Task task = this.taskRepository.getTask(list.get(i));
                    if (task == null) continue;
                    if (i < n3) {
                        TaskMenuItem taskMenuItem;
                        menuItem = groupMenu.getItem(i);
                        if (menuItem instanceof TaskMenuItem) {
                            if (task.getId().equals(((TaskMenuItem)menuItem).getTaskId()) && this.getAdjustedName(task.getName()).equals(menuItem.getLabel())) continue;
                            taskMenuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                            taskMenuItem.setTaskId(task.getId());
                            groupMenu.insert(taskMenuItem, i);
                            taskMenuItem.addActionListener(this.taskSelectionActionListener);
                            groupMenu.remove(i + 1);
                            continue;
                        }
                        taskMenuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                        taskMenuItem.setTaskId(task.getId());
                        groupMenu.insert(taskMenuItem, i);
                        taskMenuItem.addActionListener(this.taskSelectionActionListener);
                        continue;
                    }
                    menuItem = new TaskMenuItem(this.getAdjustedName(task.getName()));
                    ((TaskMenuItem)menuItem).setTaskId(task.getId());
                    groupMenu.insert(menuItem, i);
                    menuItem.addActionListener(this.taskSelectionActionListener);
                }
                while (groupMenu.getItemCount() > list.size()) {
                    groupMenu.remove(groupMenu.getItemCount() - 1);
                }
            }
            if (groupMenu.getItemCount() == 0) {
                groupMenu.add(this.createEmptyMenuItem());
            }
        }
    }

    private MenuItem createEmptyMenuItem() {
        MenuItem menuItem = new MenuItem(this.localizationProvider.getLocalizedString("popupMenu.TaskPopupMenu.noTasksAvailable"));
        menuItem.setEnabled(false);
        menuItem.setName("#");
        return menuItem;
    }

    private boolean hasEmptyMenuItem(Menu menu) {
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (menu.getItem(i).isEnabled() || !"#".equals(menu.getItem(i).getName())) continue;
            return true;
        }
        return false;
    }

    private void removeEmptyMenuItem(Menu menu) {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (menu.getItem(i).isEnabled() || !"#".equals(menu.getItem(i).getName())) continue;
            arrayList.add(menu.getItem(i));
        }
        for (MenuItem menuItem : arrayList) {
            menu.remove(menuItem);
        }
    }

    private List<GroupMenu> findGroupMenus() {
        ArrayList<GroupMenu> arrayList = new ArrayList<GroupMenu>();
        List<String> list = this.taskGroupManager.listGroups();
        for (String string : list) {
            GroupMenu groupMenu = this.findGroupMenuForGroup(string);
            if (groupMenu == null) continue;
            arrayList.add(groupMenu);
        }
        return arrayList;
    }

    private GroupMenu findGroupMenuForGroup(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = this.getItem(i);
            if (!(menuItem instanceof GroupMenu) || !string.equals(((GroupMenu)menuItem).getGroupName())) continue;
            return (GroupMenu)menuItem;
        }
        return null;
    }

    private int indexOfGroupMenu(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = this.getItem(i);
            if (!(menuItem instanceof GroupMenu) || !string.equals(((GroupMenu)menuItem).getGroupName())) continue;
            return i;
        }
        return -1;
    }

    private List<TaskMenuItem> findTaskMenuItemsForTask(String string) {
        ArrayList<TaskMenuItem> arrayList = new ArrayList<TaskMenuItem>();
        List<GroupMenu> list = this.findGroupMenus();
        for (GroupMenu groupMenu : list) {
            TaskMenuItem taskMenuItem = this.findTaskMenuItemForTask(groupMenu.getGroupName(), string);
            if (taskMenuItem == null) continue;
            arrayList.add(taskMenuItem);
        }
        return arrayList;
    }

    private TaskMenuItem findTaskMenuItemForTask(String string, String string2) {
        GroupMenu groupMenu = this.findGroupMenuForGroup(string);
        if (string != null) {
            int n = groupMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                MenuItem menuItem = groupMenu.getItem(i);
                if (!(menuItem instanceof TaskMenuItem) || !string2.equals(((TaskMenuItem)menuItem).getTaskId())) continue;
                return (TaskMenuItem)menuItem;
            }
        }
        return null;
    }

    private void removeTask(String string, String string2) {
        GroupMenu groupMenu = this.findGroupMenuForGroup(string);
        if (groupMenu != null) {
            TaskMenuItem taskMenuItem = this.findTaskMenuItemForTask(string, string2);
            if (taskMenuItem != null) {
                groupMenu.remove(taskMenuItem);
            }
            if (groupMenu.getItemCount() == 0) {
                groupMenu.add(this.createEmptyMenuItem());
            }
        }
    }

    private String getAdjustedName(String string) {
        if (string.length() > 60) {
            string = string.substring(0, 60) + "...";
        } else if (string.equals("-")) {
            string = "\u2212";
        }
        return string;
    }

    private static class MenuSeparator
    extends MenuItem {
        public MenuSeparator() {
            super("-");
        }
    }

    private static class GroupMenu
    extends Menu {
        private String groupName;

        public GroupMenu(String string) throws HeadlessException {
            super(string);
        }

        public void setGroupName(String string) {
            this.groupName = string;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }

    private static class TaskMenuItem
    extends MenuItem {
        private String taskId;

        public TaskMenuItem(String string) throws HeadlessException {
            super(string);
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String string) {
            this.taskId = string;
        }
    }
}

